
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  111 ( 1618),  selected  111 , name 1vae_A
# Molecule2: number of CA atoms  104 (  799),  selected  104 , name T0392.pdb
# PARAMETERS: 1vae_A.T0392.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      M       1           -
LGA    S     2_A      H       2           -
LGA    S     3_A      H       3           -
LGA    G     4_A      H       4           -
LGA    S     5_A      H       5           -
LGA    S     6_A      H       6           -
LGA    G     7_A      H       7           -
LGA    S     8_A      S       8           -
LGA    A     9_A      S       9           -
LGA    S    10_A      G      10           -
LGA    K    11_A      V      11           -
LGA    R    12_A      D      12           -
LGA    -       -      L      13           -
LGA    -       -      G      14           -
LGA    -       -      T      15           -
LGA    -       -      E      16           -
LGA    -       -      N      17           -
LGA    -       -      L      18           -
LGA    -       -      Y      19           -
LGA    -       -      F      20           -
LGA    W    13_A      Q      21           #
LGA    S    14_A      S      22          1.355
LGA    P    15_A      M      23          0.846
LGA    P    16_A      P      24          0.416
LGA    R    17_A      R      25          0.169
LGA    G    18_A      S      26          0.917
LGA    I    19_A      I      27          0.900
LGA    H    20_A      R      28          1.093
LGA    F    21_A      F      29          0.922
LGA    T    22_A      T      30          1.366
LGA    V    23_A      A      31          2.773
LGA    E    24_A      E      32          3.839
LGA    E    25_A      E      33          4.809
LGA    G    26_A      G      34          3.303
LGA    D    27_A      D      35          1.841
LGA    L    28_A      L      36          1.309
LGA    G    29_A      G      37          1.243
LGA    F    30_A      F      38          0.557
LGA    T    31_A      T      39          0.678
LGA    L    32_A      L      40          0.615
LGA    R    33_A      R      41          0.683
LGA    G    34_A      G      42          1.137
LGA    N    35_A      N      43          1.722
LGA    T    36_A      A      44          1.968
LGA    P    37_A      P      45          0.494
LGA    V    38_A      V      46          0.466
LGA    Q    39_A      Q      47          0.442
LGA    V    40_A      V      48          0.496
LGA    H    41_A      H      49          1.069
LGA    F    42_A      F      50          2.883
LGA    L    43_A      L      51          3.392
LGA    D    44_A      D      52          1.510
LGA    P    45_A      P      53          1.086
LGA    H    46_A      Y      54          0.848
LGA    C    47_A      C      55          1.898
LGA    S    48_A      S      56          2.232
LGA    A    49_A      A      57          0.841
LGA    S    50_A      S      58          0.646
LGA    L    51_A      V      59          1.396
LGA    A    52_A      A      60          1.620
LGA    G    53_A      G      61          1.728
LGA    A    54_A      A      62          1.296
LGA    K    55_A      R      63          1.258
LGA    E    56_A      E      64          1.479
LGA    G    57_A      G      65          0.809
LGA    D    58_A      D      66          0.798
LGA    Y    59_A      Y      67          0.499
LGA    I    60_A      I      68          0.434
LGA    V    61_A      V      69          0.678
LGA    S    62_A      S      70          0.617
LGA    I    63_A      I      71          0.398
LGA    Q    64_A      Q      72          1.220
LGA    G    65_A      L      73          1.107
LGA    V    66_A      V      74          0.788
LGA    D    67_A      D      75          1.067
LGA    C    68_A      C      76          0.637
LGA    K    69_A      K      77          0.663
LGA    W    70_A      W      78          0.794
LGA    L    71_A      L      79          0.742
LGA    T    72_A      T      80          1.098
LGA    V    73_A      L      81          1.118
LGA    S    74_A      S      82          1.049
LGA    E    75_A      E      83          0.678
LGA    V    76_A      V      84          0.770
LGA    M    77_A      M      85          0.736
LGA    K    78_A      K      86          0.920
LGA    L    79_A      L      87          0.457
LGA    L    80_A      L      88          0.458
LGA    K    81_A      K      89          0.766
LGA    S    82_A      S      90          0.448
LGA    F    83_A      F      91          0.939
LGA    G    84_A      G      92          1.426
LGA    G    85_A      E      93          1.054
LGA    E    86_A      D      94          1.160
LGA    E    87_A      E      95          1.030
LGA    V    88_A      I      96          2.047
LGA    E    89_A      E      97          1.242
LGA    M    90_A      M      98          0.766
LGA    K    91_A      K      99          0.072
LGA    V    92_A      V     100          0.569
LGA    V    93_A      V     101          1.292
LGA    S    94_A      S     102          2.276
LGA    L    95_A      L     103          1.804
LGA    L    96_A      L     104          5.573
LGA    D    97_A      -       -           -
LGA    S    98_A      -       -           -
LGA    T    99_A      -       -           -
LGA    S   100_A      -       -           -
LGA    S   101_A      -       -           -
LGA    M   102_A      -       -           -
LGA    H   103_A      -       -           -
LGA    N   104_A      -       -           -
LGA    K   105_A      -       -           -
LGA    S   106_A      -       -           -
LGA    G   107_A      -       -           -
LGA    P   108_A      -       -           -
LGA    S   109_A      -       -           -
LGA    S   110_A      -       -           -
LGA    G   111_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  111  104    5.0     83    1.55    84.34     75.405     5.016

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.092507 * X  +  -0.954853 * Y  +  -0.282310 * Z  +  16.494705
  Y_new =  -0.831592 * X  +   0.081846 * Y  +  -0.549323 * Z  +  20.327833
  Z_new =   0.547629 * X  +   0.285583 * Y  +  -0.786477 * Z  +   5.724172 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.793281   -0.348312  [ DEG:   160.0432    -19.9568 ]
  Theta =  -0.579527   -2.562065  [ DEG:   -33.2045   -146.7955 ]
  Phi   =  -1.460011    1.681582  [ DEG:   -83.6525     96.3475 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1vae_A                                        
REMARK     2: T0392.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1vae_A.T0392.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  111  104   5.0   83   1.55   84.34  75.405
REMARK  ---------------------------------------------------------- 
MOLECULE 1vae_A
HEADER    SIGNALING PROTEIN                       14-FEB-04   1VAE              
TITLE     SOLUTION STRUCTURE OF THE PDZ DOMAIN OF MOUSE RHOPHILIN-2             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: RHOPHILIN, RHO GTPASE BINDING PROTEIN 2;                   
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PDZ DOMAIN;                                                
COMPND   5 SYNONYM: RHOPHILIN 2;                                                
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: RIKEN CDNA 1300002E07;                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P030203-40;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    PDZ DOMAIN, INTRACELLULAR SIGNALING CASCADE, SIGNAL                   
KEYWDS   2 TRANSDUCTION, RHO GTPASE BINDING PROTEIN 2, ALPHA-ACTIN-4            
KEYWDS   3 BINDING DOMAIN, STRUCTURAL GENOMICS, RIKEN STRUCTURAL                
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    M.YONEYAMA,N.TOCHIO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,            
AUTHOR   2 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)               
REVDAT   1   14-AUG-04 1VAE    0                                                
JRNL        AUTH   M.YONEYAMA,N.TOCHIO,S.KOSHIBA,M.INOUE,T.KIGAWA,              
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE PDZ DOMAIN OF MOUSE                
JRNL        TITL 2 RHOPHILIN-2                                                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1VAE A    8   105  UNP    Q8BWR8   RHPN2_MOUSE    506    603             
SEQRES   1 A  111  GLY SER SER GLY SER SER GLY SER ALA SER LYS ARG TRP          
SEQRES   2 A  111  SER PRO PRO ARG GLY ILE HIS PHE THR VAL GLU GLU GLY          
SEQRES   3 A  111  ASP LEU GLY PHE THR LEU ARG GLY ASN THR PRO VAL GLN          
SEQRES   4 A  111  VAL HIS PHE LEU ASP PRO HIS CYS SER ALA SER LEU ALA          
SEQRES   5 A  111  GLY ALA LYS GLU GLY ASP TYR ILE VAL SER ILE GLN GLY          
SEQRES   6 A  111  VAL ASP CYS LYS TRP LEU THR VAL SER GLU VAL MET LYS          
SEQRES   7 A  111  LEU LEU LYS SER PHE GLY GLY GLU GLU VAL GLU MET LYS          
SEQRES   8 A  111  VAL VAL SER LEU LEU ASP SER THR SER SER MET HIS ASN          
SEQRES   9 A  111  LYS SER GLY PRO SER SER GLY                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      10.176  49.215  18.951  1.00  0.00           N  
ATOM      2  CA  GLY A   1      10.297  47.909  19.576  1.00  0.00           C  
ATOM      3  C   GLY A   1       9.034  47.561  20.365  1.00  0.00           C  
ATOM      4  O   GLY A   1       8.122  48.379  20.478  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      10.474  47.152  18.813  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      11.161  47.900  20.242  1.00  0.00           H  
ATOM      7  H1  GLY A   1       9.349  49.724  19.191  1.00  0.00           H  
ATOM      8  N   SER A   2       9.020  46.345  20.891  1.00  0.00           N  
ATOM      9  CA  SER A   2       7.884  45.877  21.666  1.00  0.00           C  
ATOM     10  C   SER A   2       8.249  44.589  22.406  1.00  0.00           C  
ATOM     11  O   SER A   2       9.289  43.990  22.140  1.00  0.00           O  
ATOM     12  CB  SER A   2       6.664  45.648  20.772  1.00  0.00           C  
ATOM     13  OG  SER A   2       5.440  45.843  21.476  1.00  0.00           O  
ATOM     14  H   SER A   2       9.765  45.686  20.794  1.00  0.00           H  
ATOM     15  HA  SER A   2       7.668  46.677  22.374  1.00  0.00           H  
ATOM     16  HB2 SER A   2       6.705  46.327  19.920  1.00  0.00           H  
ATOM     17  HB3 SER A   2       6.693  44.634  20.372  1.00  0.00           H  
ATOM     18  HG  SER A   2       4.808  45.096  21.277  1.00  0.00           H  
ATOM     19  N   SER A   3       7.372  44.201  23.321  1.00  0.00           N  
ATOM     20  CA  SER A   3       7.590  42.994  24.102  1.00  0.00           C  
ATOM     21  C   SER A   3       6.413  42.034  23.919  1.00  0.00           C  
ATOM     22  O   SER A   3       6.597  40.897  23.487  1.00  0.00           O  
ATOM     23  CB  SER A   3       7.781  43.324  25.583  1.00  0.00           C  
ATOM     24  OG  SER A   3       8.900  42.641  26.142  1.00  0.00           O  
ATOM     25  H   SER A   3       6.528  44.694  23.531  1.00  0.00           H  
ATOM     26  HA  SER A   3       8.507  42.557  23.706  1.00  0.00           H  
ATOM     27  HB2 SER A   3       7.916  44.400  25.700  1.00  0.00           H  
ATOM     28  HB3 SER A   3       6.880  43.054  26.133  1.00  0.00           H  
ATOM     29  HG  SER A   3       9.557  42.415  25.422  1.00  0.00           H  
ATOM     30  N   GLY A   4       5.231  42.526  24.257  1.00  0.00           N  
ATOM     31  CA  GLY A   4       4.024  41.726  24.136  1.00  0.00           C  
ATOM     32  C   GLY A   4       2.935  42.228  25.085  1.00  0.00           C  
ATOM     33  O   GLY A   4       3.131  43.213  25.795  1.00  0.00           O  
ATOM     34  H   GLY A   4       5.090  43.452  24.607  1.00  0.00           H  
ATOM     35  HA2 GLY A   4       3.661  41.761  23.108  1.00  0.00           H  
ATOM     36  HA3 GLY A   4       4.251  40.683  24.357  1.00  0.00           H  
ATOM     37  N   SER A   5       1.809  41.530  25.066  1.00  0.00           N  
ATOM     38  CA  SER A   5       0.688  41.893  25.916  1.00  0.00           C  
ATOM     39  C   SER A   5      -0.323  40.747  25.967  1.00  0.00           C  
ATOM     40  O   SER A   5      -0.552  40.071  24.964  1.00  0.00           O  
ATOM     41  CB  SER A   5       0.013  43.174  25.421  1.00  0.00           C  
ATOM     42  OG  SER A   5      -0.784  42.944  24.263  1.00  0.00           O  
ATOM     43  H   SER A   5       1.658  40.730  24.485  1.00  0.00           H  
ATOM     44  HA  SER A   5       1.119  42.068  26.901  1.00  0.00           H  
ATOM     45  HB2 SER A   5      -0.609  43.586  26.215  1.00  0.00           H  
ATOM     46  HB3 SER A   5       0.775  43.920  25.194  1.00  0.00           H  
ATOM     47  HG  SER A   5      -0.296  43.251  23.445  1.00  0.00           H  
ATOM     48  N   SER A   6      -0.902  40.562  27.144  1.00  0.00           N  
ATOM     49  CA  SER A   6      -1.884  39.508  27.339  1.00  0.00           C  
ATOM     50  C   SER A   6      -1.251  38.145  27.058  1.00  0.00           C  
ATOM     51  O   SER A   6      -0.265  38.052  26.329  1.00  0.00           O  
ATOM     52  CB  SER A   6      -3.105  39.721  26.442  1.00  0.00           C  
ATOM     53  OG  SER A   6      -4.181  40.339  27.142  1.00  0.00           O  
ATOM     54  H   SER A   6      -0.710  41.116  27.954  1.00  0.00           H  
ATOM     55  HA  SER A   6      -2.185  39.583  28.383  1.00  0.00           H  
ATOM     56  HB2 SER A   6      -2.825  40.340  25.588  1.00  0.00           H  
ATOM     57  HB3 SER A   6      -3.434  38.761  26.044  1.00  0.00           H  
ATOM     58  HG  SER A   6      -3.829  41.046  27.754  1.00  0.00           H  
ATOM     59  N   GLY A   7      -1.844  37.120  27.652  1.00  0.00           N  
ATOM     60  CA  GLY A   7      -1.350  35.764  27.476  1.00  0.00           C  
ATOM     61  C   GLY A   7      -1.993  35.101  26.257  1.00  0.00           C  
ATOM     62  O   GLY A   7      -2.876  34.256  26.399  1.00  0.00           O  
ATOM     63  H   GLY A   7      -2.645  37.203  28.244  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      -0.266  35.781  27.355  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      -1.561  35.177  28.369  1.00  0.00           H  
ATOM     66  N   SER A   8      -1.526  35.507  25.086  1.00  0.00           N  
ATOM     67  CA  SER A   8      -2.046  34.963  23.843  1.00  0.00           C  
ATOM     68  C   SER A   8      -1.510  33.546  23.628  1.00  0.00           C  
ATOM     69  O   SER A   8      -0.313  33.356  23.422  1.00  0.00           O  
ATOM     70  CB  SER A   8      -1.679  35.854  22.655  1.00  0.00           C  
ATOM     71  OG  SER A   8      -2.662  36.858  22.417  1.00  0.00           O  
ATOM     72  H   SER A   8      -0.808  36.195  24.978  1.00  0.00           H  
ATOM     73  HA  SER A   8      -3.128  34.948  23.965  1.00  0.00           H  
ATOM     74  HB2 SER A   8      -0.715  36.328  22.840  1.00  0.00           H  
ATOM     75  HB3 SER A   8      -1.565  35.240  21.761  1.00  0.00           H  
ATOM     76  HG  SER A   8      -2.881  37.331  23.271  1.00  0.00           H  
ATOM     77  N   ALA A   9      -2.424  32.588  23.684  1.00  0.00           N  
ATOM     78  CA  ALA A   9      -2.059  31.193  23.499  1.00  0.00           C  
ATOM     79  C   ALA A   9      -1.730  30.949  22.024  1.00  0.00           C  
ATOM     80  O   ALA A   9      -2.625  30.920  21.182  1.00  0.00           O  
ATOM     81  CB  ALA A   9      -3.192  30.297  24.000  1.00  0.00           C  
ATOM     82  H   ALA A   9      -3.396  32.750  23.852  1.00  0.00           H  
ATOM     83  HA  ALA A   9      -1.168  31.001  24.098  1.00  0.00           H  
ATOM     84  HB1 ALA A   9      -3.768  30.829  24.757  1.00  0.00           H  
ATOM     85  HB2 ALA A   9      -3.843  30.034  23.166  1.00  0.00           H  
ATOM     86  HB3 ALA A   9      -2.772  29.389  24.434  1.00  0.00           H  
ATOM     87  N   SER A  10      -0.442  30.779  21.758  1.00  0.00           N  
ATOM     88  CA  SER A  10       0.016  30.538  20.400  1.00  0.00           C  
ATOM     89  C   SER A  10       1.471  30.065  20.415  1.00  0.00           C  
ATOM     90  O   SER A  10       2.236  30.429  21.307  1.00  0.00           O  
ATOM     91  CB  SER A  10      -0.126  31.795  19.541  1.00  0.00           C  
ATOM     92  OG  SER A  10      -0.560  31.491  18.217  1.00  0.00           O  
ATOM     93  H   SER A  10       0.280  30.803  22.450  1.00  0.00           H  
ATOM     94  HA  SER A  10      -0.637  29.756  20.011  1.00  0.00           H  
ATOM     95  HB2 SER A  10      -0.838  32.476  20.007  1.00  0.00           H  
ATOM     96  HB3 SER A  10       0.831  32.314  19.498  1.00  0.00           H  
ATOM     97  HG  SER A  10      -0.444  30.513  18.036  1.00  0.00           H  
ATOM     98  N   LYS A  11       1.809  29.263  19.416  1.00  0.00           N  
ATOM     99  CA  LYS A  11       3.159  28.738  19.304  1.00  0.00           C  
ATOM    100  C   LYS A  11       4.158  29.895  19.358  1.00  0.00           C  
ATOM    101  O   LYS A  11       3.795  31.045  19.116  1.00  0.00           O  
ATOM    102  CB  LYS A  11       3.291  27.867  18.052  1.00  0.00           C  
ATOM    103  CG  LYS A  11       3.399  26.387  18.423  1.00  0.00           C  
ATOM    104  CD  LYS A  11       4.308  25.642  17.444  1.00  0.00           C  
ATOM    105  CE  LYS A  11       3.959  24.152  17.397  1.00  0.00           C  
ATOM    106  NZ  LYS A  11       2.880  23.903  16.415  1.00  0.00           N  
ATOM    107  H   LYS A  11       1.180  28.972  18.696  1.00  0.00           H  
ATOM    108  HA  LYS A  11       3.331  28.092  20.165  1.00  0.00           H  
ATOM    109  HB2 LYS A  11       2.430  28.021  17.403  1.00  0.00           H  
ATOM    110  HB3 LYS A  11       4.173  28.169  17.487  1.00  0.00           H  
ATOM    111  HG2 LYS A  11       3.792  26.289  19.435  1.00  0.00           H  
ATOM    112  HG3 LYS A  11       2.408  25.935  18.421  1.00  0.00           H  
ATOM    113  HD2 LYS A  11       4.208  26.072  16.448  1.00  0.00           H  
ATOM    114  HD3 LYS A  11       5.350  25.765  17.742  1.00  0.00           H  
ATOM    115  HE2 LYS A  11       4.843  23.573  17.129  1.00  0.00           H  
ATOM    116  HE3 LYS A  11       3.645  23.815  18.386  1.00  0.00           H  
ATOM    117  HZ1 LYS A  11       1.997  23.900  16.885  1.00  0.00           H  
ATOM    118  HZ2 LYS A  11       2.886  24.624  15.723  1.00  0.00           H  
ATOM    119  HZ3 LYS A  11       3.027  23.017  15.976  1.00  0.00           H  
ATOM    120  N   ARG A  12       5.398  29.550  19.675  1.00  0.00           N  
ATOM    121  CA  ARG A  12       6.452  30.547  19.763  1.00  0.00           C  
ATOM    122  C   ARG A  12       7.753  29.995  19.176  1.00  0.00           C  
ATOM    123  O   ARG A  12       8.216  28.928  19.578  1.00  0.00           O  
ATOM    124  CB  ARG A  12       6.692  30.967  21.213  1.00  0.00           C  
ATOM    125  CG  ARG A  12       6.819  29.744  22.125  1.00  0.00           C  
ATOM    126  CD  ARG A  12       8.070  29.841  23.001  1.00  0.00           C  
ATOM    127  NE  ARG A  12       7.789  29.291  24.346  1.00  0.00           N  
ATOM    128  CZ  ARG A  12       8.506  29.582  25.441  1.00  0.00           C  
ATOM    129  NH1 ARG A  12       9.550  30.416  25.356  1.00  0.00           N  
ATOM    130  NH2 ARG A  12       8.178  29.036  26.620  1.00  0.00           N  
ATOM    131  H   ARG A  12       5.684  28.612  19.870  1.00  0.00           H  
ATOM    132  HA  ARG A  12       6.086  31.391  19.179  1.00  0.00           H  
ATOM    133  HB2 ARG A  12       7.600  31.568  21.277  1.00  0.00           H  
ATOM    134  HB3 ARG A  12       5.870  31.596  21.555  1.00  0.00           H  
ATOM    135  HG2 ARG A  12       5.934  29.664  22.757  1.00  0.00           H  
ATOM    136  HG3 ARG A  12       6.863  28.839  21.521  1.00  0.00           H  
ATOM    137  HD2 ARG A  12       8.890  29.292  22.539  1.00  0.00           H  
ATOM    138  HD3 ARG A  12       8.388  30.880  23.083  1.00  0.00           H  
ATOM    139  HE  ARG A  12       7.016  28.664  24.445  1.00  0.00           H  
ATOM    140 HH11 ARG A  12       9.795  30.824  24.476  1.00  0.00           H  
ATOM    141 HH12 ARG A  12      10.086  30.634  26.173  1.00  0.00           H  
ATOM    142 HH21 ARG A  12       7.399  28.413  26.683  1.00  0.00           H  
ATOM    143 HH22 ARG A  12       8.714  29.252  27.437  1.00  0.00           H  
ATOM    144  N   TRP A  13       8.306  30.747  18.236  1.00  0.00           N  
ATOM    145  CA  TRP A  13       9.545  30.346  17.590  1.00  0.00           C  
ATOM    146  C   TRP A  13      10.669  31.233  18.132  1.00  0.00           C  
ATOM    147  O   TRP A  13      10.435  32.385  18.493  1.00  0.00           O  
ATOM    148  CB  TRP A  13       9.415  30.410  16.067  1.00  0.00           C  
ATOM    149  CG  TRP A  13       8.583  29.275  15.466  1.00  0.00           C  
ATOM    150  CD1 TRP A  13       7.262  29.075  15.572  1.00  0.00           C  
ATOM    151  CD2 TRP A  13       9.073  28.186  14.656  1.00  0.00           C  
ATOM    152  NE1 TRP A  13       6.866  27.941  14.893  1.00  0.00           N  
ATOM    153  CE2 TRP A  13       8.002  27.384  14.318  1.00  0.00           C  
ATOM    154  CE3 TRP A  13      10.376  27.887  14.224  1.00  0.00           C  
ATOM    155  CZ2 TRP A  13       8.126  26.231  13.532  1.00  0.00           C  
ATOM    156  CZ3 TRP A  13      10.484  26.733  13.439  1.00  0.00           C  
ATOM    157  CH2 TRP A  13       9.416  25.915  13.090  1.00  0.00           C  
ATOM    158  H   TRP A  13       7.923  31.612  17.915  1.00  0.00           H  
ATOM    159  HA  TRP A  13       9.735  29.304  17.849  1.00  0.00           H  
ATOM    160  HB2 TRP A  13       8.965  31.362  15.791  1.00  0.00           H  
ATOM    161  HB3 TRP A  13      10.411  30.388  15.627  1.00  0.00           H  
ATOM    162  HD1 TRP A  13       6.585  29.727  16.125  1.00  0.00           H  
ATOM    163  HE1 TRP A  13       5.849  27.555  14.820  1.00  0.00           H  
ATOM    164  HE3 TRP A  13      11.238  28.505  14.477  1.00  0.00           H  
ATOM    165  HZ2 TRP A  13       7.264  25.613  13.279  1.00  0.00           H  
ATOM    166  HZ3 TRP A  13      11.474  26.456  13.077  1.00  0.00           H  
ATOM    167  HH2 TRP A  13       9.582  25.031  12.474  1.00  0.00           H  
ATOM    168  N   SER A  14      11.863  30.662  18.171  1.00  0.00           N  
ATOM    169  CA  SER A  14      13.023  31.386  18.662  1.00  0.00           C  
ATOM    170  C   SER A  14      13.515  32.369  17.599  1.00  0.00           C  
ATOM    171  O   SER A  14      12.970  32.421  16.497  1.00  0.00           O  
ATOM    172  CB  SER A  14      14.146  30.424  19.057  1.00  0.00           C  
ATOM    173  OG  SER A  14      14.505  30.557  20.430  1.00  0.00           O  
ATOM    174  H   SER A  14      12.044  29.724  17.876  1.00  0.00           H  
ATOM    175  HA  SER A  14      12.676  31.920  19.547  1.00  0.00           H  
ATOM    176  HB2 SER A  14      13.831  29.400  18.862  1.00  0.00           H  
ATOM    177  HB3 SER A  14      15.021  30.614  18.434  1.00  0.00           H  
ATOM    178  HG  SER A  14      14.086  31.379  20.815  1.00  0.00           H  
ATOM    179  N   PRO A  15      14.567  33.144  17.976  1.00  0.00           N  
ATOM    180  CA  PRO A  15      15.139  34.123  17.067  1.00  0.00           C  
ATOM    181  C   PRO A  15      15.983  33.442  15.987  1.00  0.00           C  
ATOM    182  O   PRO A  15      16.558  32.380  16.222  1.00  0.00           O  
ATOM    183  CB  PRO A  15      15.947  35.057  17.952  1.00  0.00           C  
ATOM    184  CG  PRO A  15      16.179  34.303  19.251  1.00  0.00           C  
ATOM    185  CD  PRO A  15      15.237  33.110  19.272  1.00  0.00           C  
ATOM    186  HA  PRO A  15      14.413  34.610  16.579  1.00  0.00           H  
ATOM    187  HB2 PRO A  15      16.894  35.321  17.479  1.00  0.00           H  
ATOM    188  HB3 PRO A  15      15.411  35.988  18.131  1.00  0.00           H  
ATOM    189  HG2 PRO A  15      17.215  33.973  19.322  1.00  0.00           H  
ATOM    190  HG3 PRO A  15      15.992  34.952  20.107  1.00  0.00           H  
ATOM    191  HD2 PRO A  15      15.783  32.177  19.411  1.00  0.00           H  
ATOM    192  HD3 PRO A  15      14.522  33.185  20.090  1.00  0.00           H  
ATOM    193  N   PRO A  16      16.031  34.097  14.797  1.00  0.00           N  
ATOM    194  CA  PRO A  16      16.795  33.566  13.680  1.00  0.00           C  
ATOM    195  C   PRO A  16      18.295  33.774  13.895  1.00  0.00           C  
ATOM    196  O   PRO A  16      18.728  34.867  14.257  1.00  0.00           O  
ATOM    197  CB  PRO A  16      16.262  34.295  12.457  1.00  0.00           C  
ATOM    198  CG  PRO A  16      15.554  35.532  12.984  1.00  0.00           C  
ATOM    199  CD  PRO A  16      15.362  35.356  14.482  1.00  0.00           C  
ATOM    200  HA  PRO A  16      16.663  32.577  13.609  1.00  0.00           H  
ATOM    201  HB2 PRO A  16      17.073  34.567  11.781  1.00  0.00           H  
ATOM    202  HB3 PRO A  16      15.576  33.663  11.893  1.00  0.00           H  
ATOM    203  HG2 PRO A  16      16.142  36.426  12.778  1.00  0.00           H  
ATOM    204  HG3 PRO A  16      14.592  35.662  12.489  1.00  0.00           H  
ATOM    205  HD2 PRO A  16      15.798  36.186  15.037  1.00  0.00           H  
ATOM    206  HD3 PRO A  16      14.304  35.319  14.744  1.00  0.00           H  
ATOM    207  N   ARG A  17      19.047  32.709  13.661  1.00  0.00           N  
ATOM    208  CA  ARG A  17      20.490  32.761  13.824  1.00  0.00           C  
ATOM    209  C   ARG A  17      21.155  33.213  12.522  1.00  0.00           C  
ATOM    210  O   ARG A  17      20.512  33.255  11.475  1.00  0.00           O  
ATOM    211  CB  ARG A  17      21.048  31.395  14.227  1.00  0.00           C  
ATOM    212  CG  ARG A  17      20.157  30.724  15.273  1.00  0.00           C  
ATOM    213  CD  ARG A  17      20.573  29.269  15.498  1.00  0.00           C  
ATOM    214  NE  ARG A  17      21.931  29.216  16.085  1.00  0.00           N  
ATOM    215  CZ  ARG A  17      22.427  28.156  16.735  1.00  0.00           C  
ATOM    216  NH1 ARG A  17      21.681  27.054  16.888  1.00  0.00           N  
ATOM    217  NH2 ARG A  17      23.670  28.198  17.235  1.00  0.00           N  
ATOM    218  H   ARG A  17      18.687  31.824  13.366  1.00  0.00           H  
ATOM    219  HA  ARG A  17      20.654  33.486  14.622  1.00  0.00           H  
ATOM    220  HB2 ARG A  17      21.126  30.755  13.346  1.00  0.00           H  
ATOM    221  HB3 ARG A  17      22.057  31.512  14.623  1.00  0.00           H  
ATOM    222  HG2 ARG A  17      20.217  31.273  16.214  1.00  0.00           H  
ATOM    223  HG3 ARG A  17      19.116  30.762  14.949  1.00  0.00           H  
ATOM    224  HD2 ARG A  17      19.862  28.777  16.162  1.00  0.00           H  
ATOM    225  HD3 ARG A  17      20.556  28.727  14.553  1.00  0.00           H  
ATOM    226  HE  ARG A  17      22.514  30.023  15.989  1.00  0.00           H  
ATOM    227 HH11 ARG A  17      20.754  27.022  16.516  1.00  0.00           H  
ATOM    228 HH12 ARG A  17      22.051  26.262  17.374  1.00  0.00           H  
ATOM    229 HH21 ARG A  17      24.227  29.020  17.122  1.00  0.00           H  
ATOM    230 HH22 ARG A  17      24.041  27.406  17.721  1.00  0.00           H  
ATOM    231  N   GLY A  18      22.435  33.539  12.632  1.00  0.00           N  
ATOM    232  CA  GLY A  18      23.194  33.987  11.476  1.00  0.00           C  
ATOM    233  C   GLY A  18      24.357  33.037  11.184  1.00  0.00           C  
ATOM    234  O   GLY A  18      25.380  33.074  11.866  1.00  0.00           O  
ATOM    235  H   GLY A  18      22.950  33.502  13.487  1.00  0.00           H  
ATOM    236  HA2 GLY A  18      22.539  34.045  10.606  1.00  0.00           H  
ATOM    237  HA3 GLY A  18      23.576  34.992  11.654  1.00  0.00           H  
ATOM    238  N   ILE A  19      24.162  32.209  10.168  1.00  0.00           N  
ATOM    239  CA  ILE A  19      25.182  31.251   9.776  1.00  0.00           C  
ATOM    240  C   ILE A  19      25.998  31.826   8.617  1.00  0.00           C  
ATOM    241  O   ILE A  19      25.504  32.662   7.862  1.00  0.00           O  
ATOM    242  CB  ILE A  19      24.552  29.892   9.471  1.00  0.00           C  
ATOM    243  CG1 ILE A  19      23.485  29.535  10.508  1.00  0.00           C  
ATOM    244  CG2 ILE A  19      25.622  28.804   9.353  1.00  0.00           C  
ATOM    245  CD1 ILE A  19      22.909  28.142  10.247  1.00  0.00           C  
ATOM    246  H   ILE A  19      23.328  32.185   9.618  1.00  0.00           H  
ATOM    247  HA  ILE A  19      25.846  31.113  10.631  1.00  0.00           H  
ATOM    248  HB  ILE A  19      24.052  29.957   8.504  1.00  0.00           H  
ATOM    249 HG12 ILE A  19      23.918  29.572  11.507  1.00  0.00           H  
ATOM    250 HG13 ILE A  19      22.684  30.275  10.480  1.00  0.00           H  
ATOM    251 HG21 ILE A  19      26.005  28.562  10.345  1.00  0.00           H  
ATOM    252 HG22 ILE A  19      25.186  27.912   8.905  1.00  0.00           H  
ATOM    253 HG23 ILE A  19      26.438  29.164   8.727  1.00  0.00           H  
ATOM    254 HD11 ILE A  19      23.676  27.390  10.435  1.00  0.00           H  
ATOM    255 HD12 ILE A  19      22.061  27.970  10.909  1.00  0.00           H  
ATOM    256 HD13 ILE A  19      22.581  28.074   9.209  1.00  0.00           H  
ATOM    257  N   HIS A  20      27.232  31.355   8.512  1.00  0.00           N  
ATOM    258  CA  HIS A  20      28.120  31.812   7.457  1.00  0.00           C  
ATOM    259  C   HIS A  20      28.928  30.630   6.919  1.00  0.00           C  
ATOM    260  O   HIS A  20      29.796  30.101   7.612  1.00  0.00           O  
ATOM    261  CB  HIS A  20      29.004  32.960   7.950  1.00  0.00           C  
ATOM    262  CG  HIS A  20      29.312  32.906   9.427  1.00  0.00           C  
ATOM    263  ND1 HIS A  20      28.812  33.827  10.331  1.00  0.00           N  
ATOM    264  CD2 HIS A  20      30.074  32.034  10.146  1.00  0.00           C  
ATOM    265  CE1 HIS A  20      29.260  33.514  11.537  1.00  0.00           C  
ATOM    266  NE2 HIS A  20      30.043  32.402  11.421  1.00  0.00           N  
ATOM    267  H   HIS A  20      27.625  30.675   9.130  1.00  0.00           H  
ATOM    268  HA  HIS A  20      27.486  32.200   6.659  1.00  0.00           H  
ATOM    269  HB2 HIS A  20      29.940  32.949   7.393  1.00  0.00           H  
ATOM    270  HB3 HIS A  20      28.511  33.906   7.725  1.00  0.00           H  
ATOM    271  HD1 HIS A  20      28.215  34.599  10.111  1.00  0.00           H  
ATOM    272  HD2 HIS A  20      30.617  31.179   9.744  1.00  0.00           H  
ATOM    273  HE1 HIS A  20      29.041  34.050  12.462  1.00  0.00           H  
ATOM    274  N   PHE A  21      28.616  30.251   5.689  1.00  0.00           N  
ATOM    275  CA  PHE A  21      29.303  29.142   5.050  1.00  0.00           C  
ATOM    276  C   PHE A  21      29.203  29.239   3.526  1.00  0.00           C  
ATOM    277  O   PHE A  21      28.560  30.145   2.999  1.00  0.00           O  
ATOM    278  CB  PHE A  21      28.608  27.859   5.513  1.00  0.00           C  
ATOM    279  CG  PHE A  21      27.198  27.677   4.948  1.00  0.00           C  
ATOM    280  CD1 PHE A  21      26.148  28.331   5.513  1.00  0.00           C  
ATOM    281  CD2 PHE A  21      26.994  26.859   3.880  1.00  0.00           C  
ATOM    282  CE1 PHE A  21      24.840  28.162   4.989  1.00  0.00           C  
ATOM    283  CE2 PHE A  21      25.685  26.689   3.356  1.00  0.00           C  
ATOM    284  CZ  PHE A  21      24.635  27.344   3.921  1.00  0.00           C  
ATOM    285  H   PHE A  21      27.909  30.687   5.132  1.00  0.00           H  
ATOM    286  HA  PHE A  21      30.349  29.195   5.348  1.00  0.00           H  
ATOM    287  HB2 PHE A  21      29.218  27.003   5.225  1.00  0.00           H  
ATOM    288  HB3 PHE A  21      28.554  27.859   6.602  1.00  0.00           H  
ATOM    289  HD1 PHE A  21      26.312  28.986   6.369  1.00  0.00           H  
ATOM    290  HD2 PHE A  21      27.835  26.334   3.427  1.00  0.00           H  
ATOM    291  HE1 PHE A  21      23.999  28.686   5.442  1.00  0.00           H  
ATOM    292  HE2 PHE A  21      25.521  26.034   2.500  1.00  0.00           H  
ATOM    293  HZ  PHE A  21      23.632  27.214   3.519  1.00  0.00           H  
ATOM    294  N   THR A  22      29.850  28.294   2.861  1.00  0.00           N  
ATOM    295  CA  THR A  22      29.842  28.261   1.409  1.00  0.00           C  
ATOM    296  C   THR A  22      29.193  26.970   0.907  1.00  0.00           C  
ATOM    297  O   THR A  22      29.778  25.893   1.017  1.00  0.00           O  
ATOM    298  CB  THR A  22      31.282  28.445   0.925  1.00  0.00           C  
ATOM    299  OG1 THR A  22      31.473  29.858   0.931  1.00  0.00           O  
ATOM    300  CG2 THR A  22      31.461  28.053  -0.544  1.00  0.00           C  
ATOM    301  H   THR A  22      30.371  27.559   3.297  1.00  0.00           H  
ATOM    302  HA  THR A  22      29.230  29.088   1.050  1.00  0.00           H  
ATOM    303  HB  THR A  22      31.980  27.901   1.561  1.00  0.00           H  
ATOM    304  HG1 THR A  22      32.443  30.071   1.043  1.00  0.00           H  
ATOM    305 HG21 THR A  22      32.432  28.400  -0.897  1.00  0.00           H  
ATOM    306 HG22 THR A  22      31.406  26.968  -0.639  1.00  0.00           H  
ATOM    307 HG23 THR A  22      30.672  28.510  -1.141  1.00  0.00           H  
ATOM    308  N   VAL A  23      27.992  27.121   0.365  1.00  0.00           N  
ATOM    309  CA  VAL A  23      27.258  25.980  -0.153  1.00  0.00           C  
ATOM    310  C   VAL A  23      28.223  25.049  -0.889  1.00  0.00           C  
ATOM    311  O   VAL A  23      29.308  25.465  -1.291  1.00  0.00           O  
ATOM    312  CB  VAL A  23      26.102  26.459  -1.033  1.00  0.00           C  
ATOM    313  CG1 VAL A  23      25.529  25.307  -1.863  1.00  0.00           C  
ATOM    314  CG2 VAL A  23      25.010  27.123  -0.190  1.00  0.00           C  
ATOM    315  H   VAL A  23      27.525  28.000   0.280  1.00  0.00           H  
ATOM    316  HA  VAL A  23      26.835  25.446   0.698  1.00  0.00           H  
ATOM    317  HB  VAL A  23      26.492  27.207  -1.723  1.00  0.00           H  
ATOM    318 HG11 VAL A  23      25.090  24.564  -1.197  1.00  0.00           H  
ATOM    319 HG12 VAL A  23      24.763  25.691  -2.536  1.00  0.00           H  
ATOM    320 HG13 VAL A  23      26.328  24.847  -2.445  1.00  0.00           H  
ATOM    321 HG21 VAL A  23      25.455  27.551   0.708  1.00  0.00           H  
ATOM    322 HG22 VAL A  23      24.532  27.912  -0.771  1.00  0.00           H  
ATOM    323 HG23 VAL A  23      24.265  26.378   0.093  1.00  0.00           H  
ATOM    324  N   GLU A  24      27.792  23.806  -1.045  1.00  0.00           N  
ATOM    325  CA  GLU A  24      28.605  22.812  -1.726  1.00  0.00           C  
ATOM    326  C   GLU A  24      27.797  22.134  -2.834  1.00  0.00           C  
ATOM    327  O   GLU A  24      26.933  21.302  -2.557  1.00  0.00           O  
ATOM    328  CB  GLU A  24      29.154  21.780  -0.738  1.00  0.00           C  
ATOM    329  CG  GLU A  24      30.422  22.295  -0.056  1.00  0.00           C  
ATOM    330  CD  GLU A  24      31.675  21.810  -0.788  1.00  0.00           C  
ATOM    331  OE1 GLU A  24      31.601  20.704  -1.366  1.00  0.00           O  
ATOM    332  OE2 GLU A  24      32.676  22.557  -0.755  1.00  0.00           O  
ATOM    333  H   GLU A  24      26.908  23.475  -0.715  1.00  0.00           H  
ATOM    334  HA  GLU A  24      29.437  23.366  -2.161  1.00  0.00           H  
ATOM    335  HB2 GLU A  24      28.398  21.555   0.015  1.00  0.00           H  
ATOM    336  HB3 GLU A  24      29.370  20.850  -1.261  1.00  0.00           H  
ATOM    337  HG2 GLU A  24      30.410  23.386  -0.032  1.00  0.00           H  
ATOM    338  HG3 GLU A  24      30.447  21.955   0.979  1.00  0.00           H  
ATOM    339  N   GLU A  25      28.105  22.513  -4.065  1.00  0.00           N  
ATOM    340  CA  GLU A  25      27.418  21.952  -5.215  1.00  0.00           C  
ATOM    341  C   GLU A  25      27.991  20.575  -5.557  1.00  0.00           C  
ATOM    342  O   GLU A  25      28.397  20.332  -6.694  1.00  0.00           O  
ATOM    343  CB  GLU A  25      27.501  22.895  -6.418  1.00  0.00           C  
ATOM    344  CG  GLU A  25      26.139  23.522  -6.719  1.00  0.00           C  
ATOM    345  CD  GLU A  25      25.911  23.641  -8.227  1.00  0.00           C  
ATOM    346  OE1 GLU A  25      26.415  24.630  -8.801  1.00  0.00           O  
ATOM    347  OE2 GLU A  25      25.237  22.739  -8.772  1.00  0.00           O  
ATOM    348  H   GLU A  25      28.809  23.189  -4.282  1.00  0.00           H  
ATOM    349  HA  GLU A  25      26.375  21.854  -4.911  1.00  0.00           H  
ATOM    350  HB2 GLU A  25      28.231  23.679  -6.219  1.00  0.00           H  
ATOM    351  HB3 GLU A  25      27.854  22.346  -7.291  1.00  0.00           H  
ATOM    352  HG2 GLU A  25      25.349  22.916  -6.275  1.00  0.00           H  
ATOM    353  HG3 GLU A  25      26.079  24.509  -6.259  1.00  0.00           H  
ATOM    354  N   GLY A  26      28.008  19.711  -4.554  1.00  0.00           N  
ATOM    355  CA  GLY A  26      28.526  18.365  -4.734  1.00  0.00           C  
ATOM    356  C   GLY A  26      28.246  17.500  -3.503  1.00  0.00           C  
ATOM    357  O   GLY A  26      27.886  16.331  -3.629  1.00  0.00           O  
ATOM    358  H   GLY A  26      27.676  19.916  -3.634  1.00  0.00           H  
ATOM    359  HA2 GLY A  26      28.069  17.911  -5.613  1.00  0.00           H  
ATOM    360  HA3 GLY A  26      29.599  18.406  -4.918  1.00  0.00           H  
ATOM    361  N   ASP A  27      28.421  18.110  -2.339  1.00  0.00           N  
ATOM    362  CA  ASP A  27      28.192  17.411  -1.087  1.00  0.00           C  
ATOM    363  C   ASP A  27      27.808  18.423  -0.006  1.00  0.00           C  
ATOM    364  O   ASP A  27      28.672  18.943   0.698  1.00  0.00           O  
ATOM    365  CB  ASP A  27      29.454  16.681  -0.624  1.00  0.00           C  
ATOM    366  CG  ASP A  27      29.835  15.455  -1.456  1.00  0.00           C  
ATOM    367  OD1 ASP A  27      28.976  14.553  -1.562  1.00  0.00           O  
ATOM    368  OD2 ASP A  27      30.975  15.447  -1.967  1.00  0.00           O  
ATOM    369  H   ASP A  27      28.714  19.061  -2.245  1.00  0.00           H  
ATOM    370  HA  ASP A  27      27.392  16.701  -1.297  1.00  0.00           H  
ATOM    371  HB2 ASP A  27      30.289  17.384  -0.638  1.00  0.00           H  
ATOM    372  HB3 ASP A  27      29.318  16.370   0.412  1.00  0.00           H  
ATOM    373  N   LEU A  28      26.510  18.673   0.093  1.00  0.00           N  
ATOM    374  CA  LEU A  28      26.001  19.613   1.076  1.00  0.00           C  
ATOM    375  C   LEU A  28      26.279  19.075   2.481  1.00  0.00           C  
ATOM    376  O   LEU A  28      26.435  19.848   3.426  1.00  0.00           O  
ATOM    377  CB  LEU A  28      24.524  19.916   0.813  1.00  0.00           C  
ATOM    378  CG  LEU A  28      24.219  20.721  -0.450  1.00  0.00           C  
ATOM    379  CD1 LEU A  28      22.732  20.650  -0.801  1.00  0.00           C  
ATOM    380  CD2 LEU A  28      24.706  22.166  -0.311  1.00  0.00           C  
ATOM    381  H   LEU A  28      25.814  18.245  -0.484  1.00  0.00           H  
ATOM    382  HA  LEU A  28      26.549  20.547   0.949  1.00  0.00           H  
ATOM    383  HB2 LEU A  28      23.985  18.970   0.757  1.00  0.00           H  
ATOM    384  HB3 LEU A  28      24.128  20.458   1.671  1.00  0.00           H  
ATOM    385  HG  LEU A  28      24.767  20.276  -1.281  1.00  0.00           H  
ATOM    386 HD11 LEU A  28      22.379  19.626  -0.679  1.00  0.00           H  
ATOM    387 HD12 LEU A  28      22.171  21.309  -0.139  1.00  0.00           H  
ATOM    388 HD13 LEU A  28      22.587  20.962  -1.835  1.00  0.00           H  
ATOM    389 HD21 LEU A  28      23.937  22.762   0.179  1.00  0.00           H  
ATOM    390 HD22 LEU A  28      25.618  22.186   0.286  1.00  0.00           H  
ATOM    391 HD23 LEU A  28      24.911  22.577  -1.300  1.00  0.00           H  
ATOM    392  N   GLY A  29      26.331  17.754   2.574  1.00  0.00           N  
ATOM    393  CA  GLY A  29      26.586  17.105   3.849  1.00  0.00           C  
ATOM    394  C   GLY A  29      25.302  16.989   4.674  1.00  0.00           C  
ATOM    395  O   GLY A  29      25.310  16.424   5.766  1.00  0.00           O  
ATOM    396  H   GLY A  29      26.202  17.133   1.802  1.00  0.00           H  
ATOM    397  HA2 GLY A  29      27.003  16.112   3.677  1.00  0.00           H  
ATOM    398  HA3 GLY A  29      27.331  17.671   4.407  1.00  0.00           H  
ATOM    399  N   PHE A  30      24.229  17.534   4.117  1.00  0.00           N  
ATOM    400  CA  PHE A  30      22.941  17.499   4.787  1.00  0.00           C  
ATOM    401  C   PHE A  30      21.797  17.455   3.773  1.00  0.00           C  
ATOM    402  O   PHE A  30      22.020  17.604   2.572  1.00  0.00           O  
ATOM    403  CB  PHE A  30      22.829  18.785   5.609  1.00  0.00           C  
ATOM    404  CG  PHE A  30      22.598  20.043   4.768  1.00  0.00           C  
ATOM    405  CD1 PHE A  30      21.342  20.359   4.349  1.00  0.00           C  
ATOM    406  CD2 PHE A  30      23.647  20.842   4.439  1.00  0.00           C  
ATOM    407  CE1 PHE A  30      21.128  21.526   3.569  1.00  0.00           C  
ATOM    408  CE2 PHE A  30      23.431  22.009   3.658  1.00  0.00           C  
ATOM    409  CZ  PHE A  30      22.177  22.326   3.240  1.00  0.00           C  
ATOM    410  H   PHE A  30      24.231  17.991   3.229  1.00  0.00           H  
ATOM    411  HA  PHE A  30      22.917  16.596   5.398  1.00  0.00           H  
ATOM    412  HB2 PHE A  30      22.009  18.681   6.319  1.00  0.00           H  
ATOM    413  HB3 PHE A  30      23.741  18.913   6.192  1.00  0.00           H  
ATOM    414  HD1 PHE A  30      20.502  19.717   4.613  1.00  0.00           H  
ATOM    415  HD2 PHE A  30      24.652  20.588   4.774  1.00  0.00           H  
ATOM    416  HE1 PHE A  30      20.123  21.779   3.233  1.00  0.00           H  
ATOM    417  HE2 PHE A  30      24.273  22.651   3.395  1.00  0.00           H  
ATOM    418  HZ  PHE A  30      22.013  23.222   2.640  1.00  0.00           H  
ATOM    419  N   THR A  31      20.595  17.249   4.292  1.00  0.00           N  
ATOM    420  CA  THR A  31      19.416  17.182   3.446  1.00  0.00           C  
ATOM    421  C   THR A  31      18.273  17.992   4.061  1.00  0.00           C  
ATOM    422  O   THR A  31      18.410  18.533   5.157  1.00  0.00           O  
ATOM    423  CB  THR A  31      19.069  15.707   3.234  1.00  0.00           C  
ATOM    424  OG1 THR A  31      17.643  15.684   3.219  1.00  0.00           O  
ATOM    425  CG2 THR A  31      19.443  14.838   4.437  1.00  0.00           C  
ATOM    426  H   THR A  31      20.421  17.127   5.270  1.00  0.00           H  
ATOM    427  HA  THR A  31      19.654  17.641   2.488  1.00  0.00           H  
ATOM    428  HB  THR A  31      19.526  15.326   2.321  1.00  0.00           H  
ATOM    429  HG1 THR A  31      17.320  14.934   2.644  1.00  0.00           H  
ATOM    430 HG21 THR A  31      18.904  15.186   5.318  1.00  0.00           H  
ATOM    431 HG22 THR A  31      19.175  13.801   4.233  1.00  0.00           H  
ATOM    432 HG23 THR A  31      20.516  14.908   4.615  1.00  0.00           H  
ATOM    433  N   LEU A  32      17.170  18.050   3.328  1.00  0.00           N  
ATOM    434  CA  LEU A  32      16.004  18.786   3.787  1.00  0.00           C  
ATOM    435  C   LEU A  32      14.788  17.858   3.786  1.00  0.00           C  
ATOM    436  O   LEU A  32      14.404  17.334   2.741  1.00  0.00           O  
ATOM    437  CB  LEU A  32      15.810  20.056   2.956  1.00  0.00           C  
ATOM    438  CG  LEU A  32      16.980  21.041   2.952  1.00  0.00           C  
ATOM    439  CD1 LEU A  32      16.778  22.131   1.897  1.00  0.00           C  
ATOM    440  CD2 LEU A  32      17.207  21.629   4.346  1.00  0.00           C  
ATOM    441  H   LEU A  32      17.067  17.608   2.438  1.00  0.00           H  
ATOM    442  HA  LEU A  32      16.199  19.100   4.813  1.00  0.00           H  
ATOM    443  HB2 LEU A  32      15.604  19.763   1.926  1.00  0.00           H  
ATOM    444  HB3 LEU A  32      14.925  20.575   3.323  1.00  0.00           H  
ATOM    445  HG  LEU A  32      17.886  20.496   2.683  1.00  0.00           H  
ATOM    446 HD11 LEU A  32      15.790  22.575   2.019  1.00  0.00           H  
ATOM    447 HD12 LEU A  32      17.541  22.899   2.017  1.00  0.00           H  
ATOM    448 HD13 LEU A  32      16.859  21.691   0.902  1.00  0.00           H  
ATOM    449 HD21 LEU A  32      16.259  21.665   4.884  1.00  0.00           H  
ATOM    450 HD22 LEU A  32      17.911  21.004   4.894  1.00  0.00           H  
ATOM    451 HD23 LEU A  32      17.610  22.637   4.255  1.00  0.00           H  
ATOM    452  N   ARG A  33      14.215  17.683   4.968  1.00  0.00           N  
ATOM    453  CA  ARG A  33      13.051  16.828   5.116  1.00  0.00           C  
ATOM    454  C   ARG A  33      11.849  17.646   5.593  1.00  0.00           C  
ATOM    455  O   ARG A  33      12.004  18.779   6.046  1.00  0.00           O  
ATOM    456  CB  ARG A  33      13.319  15.700   6.115  1.00  0.00           C  
ATOM    457  CG  ARG A  33      14.178  14.601   5.484  1.00  0.00           C  
ATOM    458  CD  ARG A  33      13.329  13.379   5.128  1.00  0.00           C  
ATOM    459  NE  ARG A  33      13.937  12.654   3.990  1.00  0.00           N  
ATOM    460  CZ  ARG A  33      13.385  11.587   3.398  1.00  0.00           C  
ATOM    461  NH1 ARG A  33      12.209  11.114   3.831  1.00  0.00           N  
ATOM    462  NH2 ARG A  33      14.009  10.993   2.372  1.00  0.00           N  
ATOM    463  H   ARG A  33      14.534  18.114   5.813  1.00  0.00           H  
ATOM    464  HA  ARG A  33      12.878  16.419   4.121  1.00  0.00           H  
ATOM    465  HB2 ARG A  33      13.824  16.101   6.995  1.00  0.00           H  
ATOM    466  HB3 ARG A  33      12.374  15.277   6.455  1.00  0.00           H  
ATOM    467  HG2 ARG A  33      14.663  14.985   4.586  1.00  0.00           H  
ATOM    468  HG3 ARG A  33      14.969  14.311   6.174  1.00  0.00           H  
ATOM    469  HD2 ARG A  33      13.249  12.718   5.991  1.00  0.00           H  
ATOM    470  HD3 ARG A  33      12.316  13.692   4.871  1.00  0.00           H  
ATOM    471  HE  ARG A  33      14.816  12.981   3.642  1.00  0.00           H  
ATOM    472 HH11 ARG A  33      11.742  11.558   4.597  1.00  0.00           H  
ATOM    473 HH12 ARG A  33      11.796  10.317   3.389  1.00  0.00           H  
ATOM    474 HH21 ARG A  33      14.887  11.345   2.048  1.00  0.00           H  
ATOM    475 HH22 ARG A  33      13.597  10.196   1.929  1.00  0.00           H  
ATOM    476  N   GLY A  34      10.676  17.040   5.474  1.00  0.00           N  
ATOM    477  CA  GLY A  34       9.448  17.698   5.886  1.00  0.00           C  
ATOM    478  C   GLY A  34       8.855  18.518   4.740  1.00  0.00           C  
ATOM    479  O   GLY A  34       9.199  18.310   3.578  1.00  0.00           O  
ATOM    480  H   GLY A  34      10.559  16.118   5.104  1.00  0.00           H  
ATOM    481  HA2 GLY A  34       8.725  16.952   6.217  1.00  0.00           H  
ATOM    482  HA3 GLY A  34       9.648  18.347   6.738  1.00  0.00           H  
ATOM    483  N   ASN A  35       7.971  19.435   5.107  1.00  0.00           N  
ATOM    484  CA  ASN A  35       7.325  20.288   4.124  1.00  0.00           C  
ATOM    485  C   ASN A  35       7.847  21.719   4.275  1.00  0.00           C  
ATOM    486  O   ASN A  35       8.570  22.214   3.412  1.00  0.00           O  
ATOM    487  CB  ASN A  35       5.809  20.314   4.328  1.00  0.00           C  
ATOM    488  CG  ASN A  35       5.450  20.095   5.799  1.00  0.00           C  
ATOM    489  OD1 ASN A  35       5.869  19.139   6.431  1.00  0.00           O  
ATOM    490  ND2 ASN A  35       4.654  21.031   6.306  1.00  0.00           N  
ATOM    491  H   ASN A  35       7.695  19.599   6.054  1.00  0.00           H  
ATOM    492  HA  ASN A  35       7.577  19.852   3.157  1.00  0.00           H  
ATOM    493  HB2 ASN A  35       5.409  21.271   3.991  1.00  0.00           H  
ATOM    494  HB3 ASN A  35       5.344  19.541   3.717  1.00  0.00           H  
ATOM    495 HD21 ASN A  35       4.346  21.790   5.734  1.00  0.00           H  
ATOM    496 HD22 ASN A  35       4.362  20.976   7.262  1.00  0.00           H  
ATOM    497  N   THR A  36       7.462  22.342   5.379  1.00  0.00           N  
ATOM    498  CA  THR A  36       7.882  23.706   5.654  1.00  0.00           C  
ATOM    499  C   THR A  36       7.406  24.139   7.042  1.00  0.00           C  
ATOM    500  O   THR A  36       6.291  23.817   7.449  1.00  0.00           O  
ATOM    501  CB  THR A  36       7.360  24.597   4.526  1.00  0.00           C  
ATOM    502  OG1 THR A  36       7.862  25.892   4.847  1.00  0.00           O  
ATOM    503  CG2 THR A  36       5.840  24.765   4.566  1.00  0.00           C  
ATOM    504  H   THR A  36       6.874  21.932   6.076  1.00  0.00           H  
ATOM    505  HA  THR A  36       8.971  23.733   5.666  1.00  0.00           H  
ATOM    506  HB  THR A  36       7.686  24.226   3.554  1.00  0.00           H  
ATOM    507  HG1 THR A  36       7.553  26.161   5.760  1.00  0.00           H  
ATOM    508 HG21 THR A  36       5.444  24.731   3.551  1.00  0.00           H  
ATOM    509 HG22 THR A  36       5.402  23.960   5.155  1.00  0.00           H  
ATOM    510 HG23 THR A  36       5.593  25.724   5.022  1.00  0.00           H  
ATOM    511  N   PRO A  37       8.299  24.884   7.748  1.00  0.00           N  
ATOM    512  CA  PRO A  37       9.598  25.222   7.192  1.00  0.00           C  
ATOM    513  C   PRO A  37      10.535  24.013   7.216  1.00  0.00           C  
ATOM    514  O   PRO A  37      10.658  23.338   8.238  1.00  0.00           O  
ATOM    515  CB  PRO A  37      10.100  26.379   8.040  1.00  0.00           C  
ATOM    516  CG  PRO A  37       9.281  26.345   9.320  1.00  0.00           C  
ATOM    517  CD  PRO A  37       8.095  25.423   9.089  1.00  0.00           C  
ATOM    518  HA  PRO A  37       9.507  25.478   6.229  1.00  0.00           H  
ATOM    519  HB2 PRO A  37      11.164  26.275   8.252  1.00  0.00           H  
ATOM    520  HB3 PRO A  37       9.970  27.329   7.519  1.00  0.00           H  
ATOM    521  HG2 PRO A  37       9.889  25.985  10.151  1.00  0.00           H  
ATOM    522  HG3 PRO A  37       8.941  27.346   9.584  1.00  0.00           H  
ATOM    523  HD2 PRO A  37       8.060  24.629   9.834  1.00  0.00           H  
ATOM    524  HD3 PRO A  37       7.153  25.967   9.160  1.00  0.00           H  
ATOM    525  N   VAL A  38      11.172  23.776   6.080  1.00  0.00           N  
ATOM    526  CA  VAL A  38      12.095  22.659   5.958  1.00  0.00           C  
ATOM    527  C   VAL A  38      13.088  22.695   7.121  1.00  0.00           C  
ATOM    528  O   VAL A  38      13.402  23.764   7.641  1.00  0.00           O  
ATOM    529  CB  VAL A  38      12.777  22.692   4.588  1.00  0.00           C  
ATOM    530  CG1 VAL A  38      11.771  22.414   3.468  1.00  0.00           C  
ATOM    531  CG2 VAL A  38      13.493  24.024   4.363  1.00  0.00           C  
ATOM    532  H   VAL A  38      11.067  24.329   5.253  1.00  0.00           H  
ATOM    533  HA  VAL A  38      11.511  21.741   6.023  1.00  0.00           H  
ATOM    534  HB  VAL A  38      13.526  21.900   4.569  1.00  0.00           H  
ATOM    535 HG11 VAL A  38      12.199  21.700   2.764  1.00  0.00           H  
ATOM    536 HG12 VAL A  38      10.857  22.001   3.895  1.00  0.00           H  
ATOM    537 HG13 VAL A  38      11.541  23.343   2.948  1.00  0.00           H  
ATOM    538 HG21 VAL A  38      13.833  24.420   5.321  1.00  0.00           H  
ATOM    539 HG22 VAL A  38      14.351  23.869   3.709  1.00  0.00           H  
ATOM    540 HG23 VAL A  38      12.807  24.733   3.900  1.00  0.00           H  
ATOM    541  N   GLN A  39      13.555  21.513   7.494  1.00  0.00           N  
ATOM    542  CA  GLN A  39      14.507  21.395   8.586  1.00  0.00           C  
ATOM    543  C   GLN A  39      15.844  20.862   8.070  1.00  0.00           C  
ATOM    544  O   GLN A  39      15.932  20.389   6.938  1.00  0.00           O  
ATOM    545  CB  GLN A  39      13.954  20.504   9.701  1.00  0.00           C  
ATOM    546  CG  GLN A  39      12.887  21.241  10.514  1.00  0.00           C  
ATOM    547  CD  GLN A  39      11.885  20.257  11.121  1.00  0.00           C  
ATOM    548  OE1 GLN A  39      10.761  20.116  10.668  1.00  0.00           O  
ATOM    549  NE2 GLN A  39      12.354  19.587  12.170  1.00  0.00           N  
ATOM    550  H   GLN A  39      13.295  20.648   7.066  1.00  0.00           H  
ATOM    551  HA  GLN A  39      14.635  22.408   8.969  1.00  0.00           H  
ATOM    552  HB2 GLN A  39      13.527  19.599   9.269  1.00  0.00           H  
ATOM    553  HB3 GLN A  39      14.766  20.193  10.358  1.00  0.00           H  
ATOM    554  HG2 GLN A  39      13.363  21.817  11.307  1.00  0.00           H  
ATOM    555  HG3 GLN A  39      12.363  21.950   9.873  1.00  0.00           H  
ATOM    556 HE21 GLN A  39      13.286  19.750  12.492  1.00  0.00           H  
ATOM    557 HE22 GLN A  39      11.772  18.919  12.637  1.00  0.00           H  
ATOM    558  N   VAL A  40      16.852  20.956   8.924  1.00  0.00           N  
ATOM    559  CA  VAL A  40      18.181  20.490   8.568  1.00  0.00           C  
ATOM    560  C   VAL A  40      18.420  19.116   9.199  1.00  0.00           C  
ATOM    561  O   VAL A  40      18.493  18.994  10.421  1.00  0.00           O  
ATOM    562  CB  VAL A  40      19.228  21.527   8.980  1.00  0.00           C  
ATOM    563  CG1 VAL A  40      20.645  20.999   8.742  1.00  0.00           C  
ATOM    564  CG2 VAL A  40      19.005  22.851   8.246  1.00  0.00           C  
ATOM    565  H   VAL A  40      16.772  21.343   9.843  1.00  0.00           H  
ATOM    566  HA  VAL A  40      18.215  20.387   7.484  1.00  0.00           H  
ATOM    567  HB  VAL A  40      19.115  21.712  10.048  1.00  0.00           H  
ATOM    568 HG11 VAL A  40      20.789  20.815   7.677  1.00  0.00           H  
ATOM    569 HG12 VAL A  40      21.370  21.739   9.084  1.00  0.00           H  
ATOM    570 HG13 VAL A  40      20.784  20.071   9.295  1.00  0.00           H  
ATOM    571 HG21 VAL A  40      19.891  23.478   8.353  1.00  0.00           H  
ATOM    572 HG22 VAL A  40      18.824  22.655   7.189  1.00  0.00           H  
ATOM    573 HG23 VAL A  40      18.143  23.363   8.674  1.00  0.00           H  
ATOM    574  N   HIS A  41      18.536  18.116   8.338  1.00  0.00           N  
ATOM    575  CA  HIS A  41      18.766  16.756   8.796  1.00  0.00           C  
ATOM    576  C   HIS A  41      20.233  16.382   8.576  1.00  0.00           C  
ATOM    577  O   HIS A  41      20.539  15.504   7.770  1.00  0.00           O  
ATOM    578  CB  HIS A  41      17.797  15.784   8.118  1.00  0.00           C  
ATOM    579  CG  HIS A  41      18.008  14.340   8.502  1.00  0.00           C  
ATOM    580  ND1 HIS A  41      17.874  13.882   9.802  1.00  0.00           N  
ATOM    581  CD2 HIS A  41      18.345  13.256   7.746  1.00  0.00           C  
ATOM    582  CE1 HIS A  41      18.121  12.581   9.815  1.00  0.00           C  
ATOM    583  NE2 HIS A  41      18.413  12.195   8.541  1.00  0.00           N  
ATOM    584  H   HIS A  41      18.476  18.224   7.346  1.00  0.00           H  
ATOM    585  HA  HIS A  41      18.553  16.746   9.865  1.00  0.00           H  
ATOM    586  HB2 HIS A  41      16.776  16.071   8.369  1.00  0.00           H  
ATOM    587  HB3 HIS A  41      17.899  15.881   7.038  1.00  0.00           H  
ATOM    588  HD1 HIS A  41      17.631  14.439  10.596  1.00  0.00           H  
ATOM    589  HD2 HIS A  41      18.527  13.262   6.671  1.00  0.00           H  
ATOM    590  HE1 HIS A  41      18.095  11.932  10.691  1.00  0.00           H  
ATOM    591  N   PHE A  42      21.101  17.066   9.307  1.00  0.00           N  
ATOM    592  CA  PHE A  42      22.528  16.816   9.203  1.00  0.00           C  
ATOM    593  C   PHE A  42      22.815  15.317   9.085  1.00  0.00           C  
ATOM    594  O   PHE A  42      22.412  14.535   9.945  1.00  0.00           O  
ATOM    595  CB  PHE A  42      23.171  17.347  10.486  1.00  0.00           C  
ATOM    596  CG  PHE A  42      23.522  18.835  10.435  1.00  0.00           C  
ATOM    597  CD1 PHE A  42      24.108  19.357   9.325  1.00  0.00           C  
ATOM    598  CD2 PHE A  42      23.249  19.635  11.500  1.00  0.00           C  
ATOM    599  CE1 PHE A  42      24.435  20.739   9.278  1.00  0.00           C  
ATOM    600  CE2 PHE A  42      23.576  21.016  11.453  1.00  0.00           C  
ATOM    601  CZ  PHE A  42      24.162  21.539  10.344  1.00  0.00           C  
ATOM    602  H   PHE A  42      20.843  17.778   9.961  1.00  0.00           H  
ATOM    603  HA  PHE A  42      22.881  17.322   8.304  1.00  0.00           H  
ATOM    604  HB2 PHE A  42      22.491  17.172  11.319  1.00  0.00           H  
ATOM    605  HB3 PHE A  42      24.077  16.776  10.690  1.00  0.00           H  
ATOM    606  HD1 PHE A  42      24.328  18.716   8.471  1.00  0.00           H  
ATOM    607  HD2 PHE A  42      22.780  19.215  12.390  1.00  0.00           H  
ATOM    608  HE1 PHE A  42      24.905  21.158   8.387  1.00  0.00           H  
ATOM    609  HE2 PHE A  42      23.357  21.657  12.307  1.00  0.00           H  
ATOM    610  HZ  PHE A  42      24.413  22.599  10.308  1.00  0.00           H  
ATOM    611  N   LEU A  43      23.509  14.962   8.014  1.00  0.00           N  
ATOM    612  CA  LEU A  43      23.855  13.571   7.773  1.00  0.00           C  
ATOM    613  C   LEU A  43      25.349  13.369   8.036  1.00  0.00           C  
ATOM    614  O   LEU A  43      25.775  12.277   8.407  1.00  0.00           O  
ATOM    615  CB  LEU A  43      23.413  13.144   6.373  1.00  0.00           C  
ATOM    616  CG  LEU A  43      21.943  12.745   6.225  1.00  0.00           C  
ATOM    617  CD1 LEU A  43      21.625  12.350   4.782  1.00  0.00           C  
ATOM    618  CD2 LEU A  43      21.573  11.641   7.217  1.00  0.00           C  
ATOM    619  H   LEU A  43      23.833  15.604   7.320  1.00  0.00           H  
ATOM    620  HA  LEU A  43      23.294  12.967   8.487  1.00  0.00           H  
ATOM    621  HB2 LEU A  43      23.618  13.964   5.684  1.00  0.00           H  
ATOM    622  HB3 LEU A  43      24.031  12.303   6.059  1.00  0.00           H  
ATOM    623  HG  LEU A  43      21.329  13.612   6.464  1.00  0.00           H  
ATOM    624 HD11 LEU A  43      20.573  12.074   4.704  1.00  0.00           H  
ATOM    625 HD12 LEU A  43      21.829  13.192   4.121  1.00  0.00           H  
ATOM    626 HD13 LEU A  43      22.246  11.502   4.491  1.00  0.00           H  
ATOM    627 HD21 LEU A  43      20.960  12.060   8.015  1.00  0.00           H  
ATOM    628 HD22 LEU A  43      21.015  10.861   6.700  1.00  0.00           H  
ATOM    629 HD23 LEU A  43      22.482  11.216   7.643  1.00  0.00           H  
ATOM    630  N   ASP A  44      26.103  14.438   7.832  1.00  0.00           N  
ATOM    631  CA  ASP A  44      27.540  14.392   8.041  1.00  0.00           C  
ATOM    632  C   ASP A  44      27.948  15.513   9.000  1.00  0.00           C  
ATOM    633  O   ASP A  44      27.511  16.653   8.850  1.00  0.00           O  
ATOM    634  CB  ASP A  44      28.296  14.597   6.727  1.00  0.00           C  
ATOM    635  CG  ASP A  44      27.869  13.672   5.586  1.00  0.00           C  
ATOM    636  OD1 ASP A  44      26.966  12.843   5.834  1.00  0.00           O  
ATOM    637  OD2 ASP A  44      28.454  13.815   4.490  1.00  0.00           O  
ATOM    638  H   ASP A  44      25.749  15.324   7.530  1.00  0.00           H  
ATOM    639  HA  ASP A  44      27.738  13.401   8.450  1.00  0.00           H  
ATOM    640  HB2 ASP A  44      28.164  15.630   6.406  1.00  0.00           H  
ATOM    641  HB3 ASP A  44      29.361  14.453   6.912  1.00  0.00           H  
ATOM    642  N   PRO A  45      28.803  15.140   9.990  1.00  0.00           N  
ATOM    643  CA  PRO A  45      29.275  16.100  10.974  1.00  0.00           C  
ATOM    644  C   PRO A  45      30.327  17.032  10.369  1.00  0.00           C  
ATOM    645  O   PRO A  45      30.434  18.191  10.764  1.00  0.00           O  
ATOM    646  CB  PRO A  45      29.815  15.259  12.118  1.00  0.00           C  
ATOM    647  CG  PRO A  45      30.052  13.872  11.541  1.00  0.00           C  
ATOM    648  CD  PRO A  45      29.341  13.799  10.198  1.00  0.00           C  
ATOM    649  HA  PRO A  45      28.524  16.691  11.269  1.00  0.00           H  
ATOM    650  HB2 PRO A  45      30.740  15.681  12.512  1.00  0.00           H  
ATOM    651  HB3 PRO A  45      29.105  15.221  12.944  1.00  0.00           H  
ATOM    652  HG2 PRO A  45      31.120  13.687  11.418  1.00  0.00           H  
ATOM    653  HG3 PRO A  45      29.672  13.107  12.216  1.00  0.00           H  
ATOM    654  HD2 PRO A  45      30.030  13.520   9.401  1.00  0.00           H  
ATOM    655  HD3 PRO A  45      28.549  13.050  10.211  1.00  0.00           H  
ATOM    656  N   HIS A  46      31.075  16.490   9.419  1.00  0.00           N  
ATOM    657  CA  HIS A  46      32.115  17.258   8.756  1.00  0.00           C  
ATOM    658  C   HIS A  46      31.554  17.887   7.479  1.00  0.00           C  
ATOM    659  O   HIS A  46      32.296  18.154   6.536  1.00  0.00           O  
ATOM    660  CB  HIS A  46      33.350  16.392   8.498  1.00  0.00           C  
ATOM    661  CG  HIS A  46      34.116  16.028   9.747  1.00  0.00           C  
ATOM    662  ND1 HIS A  46      35.216  15.189   9.733  1.00  0.00           N  
ATOM    663  CD2 HIS A  46      33.930  16.397  11.046  1.00  0.00           C  
ATOM    664  CE1 HIS A  46      35.665  15.064  10.973  1.00  0.00           C  
ATOM    665  NE2 HIS A  46      34.865  15.815  11.786  1.00  0.00           N  
ATOM    666  H   HIS A  46      30.981  15.546   9.104  1.00  0.00           H  
ATOM    667  HA  HIS A  46      32.404  18.052   9.444  1.00  0.00           H  
ATOM    668  HB2 HIS A  46      33.040  15.477   7.993  1.00  0.00           H  
ATOM    669  HB3 HIS A  46      34.016  16.922   7.817  1.00  0.00           H  
ATOM    670  HD1 HIS A  46      35.608  14.750   8.924  1.00  0.00           H  
ATOM    671  HD2 HIS A  46      33.147  17.060  11.414  1.00  0.00           H  
ATOM    672  HE1 HIS A  46      36.521  14.469  11.289  1.00  0.00           H  
ATOM    673  N   CYS A  47      30.246  18.103   7.489  1.00  0.00           N  
ATOM    674  CA  CYS A  47      29.576  18.694   6.343  1.00  0.00           C  
ATOM    675  C   CYS A  47      30.127  20.107   6.141  1.00  0.00           C  
ATOM    676  O   CYS A  47      31.334  20.291   5.990  1.00  0.00           O  
ATOM    677  CB  CYS A  47      28.055  18.693   6.514  1.00  0.00           C  
ATOM    678  SG  CYS A  47      27.609  19.403   8.141  1.00  0.00           S  
ATOM    679  H   CYS A  47      29.649  17.882   8.261  1.00  0.00           H  
ATOM    680  HA  CYS A  47      29.807  18.062   5.486  1.00  0.00           H  
ATOM    681  HB2 CYS A  47      27.592  19.270   5.715  1.00  0.00           H  
ATOM    682  HB3 CYS A  47      27.673  17.675   6.436  1.00  0.00           H  
ATOM    683  HG  CYS A  47      28.650  20.225   8.225  1.00  0.00           H  
ATOM    684  N   SER A  48      29.215  21.068   6.146  1.00  0.00           N  
ATOM    685  CA  SER A  48      29.594  22.460   5.965  1.00  0.00           C  
ATOM    686  C   SER A  48      28.732  23.357   6.854  1.00  0.00           C  
ATOM    687  O   SER A  48      29.252  24.087   7.697  1.00  0.00           O  
ATOM    688  CB  SER A  48      29.465  22.880   4.500  1.00  0.00           C  
ATOM    689  OG  SER A  48      28.838  21.874   3.709  1.00  0.00           O  
ATOM    690  H   SER A  48      28.237  20.911   6.271  1.00  0.00           H  
ATOM    691  HA  SER A  48      30.640  22.515   6.267  1.00  0.00           H  
ATOM    692  HB2 SER A  48      28.885  23.802   4.438  1.00  0.00           H  
ATOM    693  HB3 SER A  48      30.453  23.097   4.096  1.00  0.00           H  
ATOM    694  HG  SER A  48      29.319  21.004   3.820  1.00  0.00           H  
ATOM    695  N   ALA A  49      27.428  23.274   6.636  1.00  0.00           N  
ATOM    696  CA  ALA A  49      26.486  24.069   7.406  1.00  0.00           C  
ATOM    697  C   ALA A  49      26.792  23.909   8.897  1.00  0.00           C  
ATOM    698  O   ALA A  49      26.896  24.897   9.622  1.00  0.00           O  
ATOM    699  CB  ALA A  49      25.058  23.652   7.056  1.00  0.00           C  
ATOM    700  H   ALA A  49      27.013  22.677   5.948  1.00  0.00           H  
ATOM    701  HA  ALA A  49      26.627  25.113   7.125  1.00  0.00           H  
ATOM    702  HB1 ALA A  49      25.072  22.671   6.582  1.00  0.00           H  
ATOM    703  HB2 ALA A  49      24.458  23.608   7.966  1.00  0.00           H  
ATOM    704  HB3 ALA A  49      24.624  24.380   6.370  1.00  0.00           H  
ATOM    705  N   SER A  50      26.926  22.658   9.310  1.00  0.00           N  
ATOM    706  CA  SER A  50      27.217  22.356  10.702  1.00  0.00           C  
ATOM    707  C   SER A  50      28.527  23.026  11.119  1.00  0.00           C  
ATOM    708  O   SER A  50      28.575  23.732  12.126  1.00  0.00           O  
ATOM    709  CB  SER A  50      27.297  20.845  10.932  1.00  0.00           C  
ATOM    710  OG  SER A  50      27.119  20.505  12.304  1.00  0.00           O  
ATOM    711  H   SER A  50      26.841  21.860   8.713  1.00  0.00           H  
ATOM    712  HA  SER A  50      26.380  22.766  11.266  1.00  0.00           H  
ATOM    713  HB2 SER A  50      26.535  20.347  10.333  1.00  0.00           H  
ATOM    714  HB3 SER A  50      28.264  20.477  10.590  1.00  0.00           H  
ATOM    715  HG  SER A  50      26.337  21.002  12.682  1.00  0.00           H  
ATOM    716  N   LEU A  51      29.560  22.781  10.325  1.00  0.00           N  
ATOM    717  CA  LEU A  51      30.868  23.352  10.600  1.00  0.00           C  
ATOM    718  C   LEU A  51      30.734  24.869  10.756  1.00  0.00           C  
ATOM    719  O   LEU A  51      31.507  25.492  11.483  1.00  0.00           O  
ATOM    720  CB  LEU A  51      31.873  22.930   9.527  1.00  0.00           C  
ATOM    721  CG  LEU A  51      32.143  21.428   9.415  1.00  0.00           C  
ATOM    722  CD1 LEU A  51      32.770  21.083   8.063  1.00  0.00           C  
ATOM    723  CD2 LEU A  51      32.997  20.936  10.585  1.00  0.00           C  
ATOM    724  H   LEU A  51      29.514  22.206   9.509  1.00  0.00           H  
ATOM    725  HA  LEU A  51      31.213  22.937  11.547  1.00  0.00           H  
ATOM    726  HB2 LEU A  51      31.516  23.288   8.562  1.00  0.00           H  
ATOM    727  HB3 LEU A  51      32.819  23.435   9.725  1.00  0.00           H  
ATOM    728  HG  LEU A  51      31.189  20.905   9.470  1.00  0.00           H  
ATOM    729 HD11 LEU A  51      33.851  21.218   8.118  1.00  0.00           H  
ATOM    730 HD12 LEU A  51      32.547  20.047   7.812  1.00  0.00           H  
ATOM    731 HD13 LEU A  51      32.361  21.740   7.294  1.00  0.00           H  
ATOM    732 HD21 LEU A  51      33.342  19.922  10.381  1.00  0.00           H  
ATOM    733 HD22 LEU A  51      33.856  21.594  10.710  1.00  0.00           H  
ATOM    734 HD23 LEU A  51      32.400  20.940  11.498  1.00  0.00           H  
ATOM    735  N   ALA A  52      29.750  25.419  10.062  1.00  0.00           N  
ATOM    736  CA  ALA A  52      29.505  26.850  10.113  1.00  0.00           C  
ATOM    737  C   ALA A  52      29.115  27.245  11.539  1.00  0.00           C  
ATOM    738  O   ALA A  52      29.780  28.071  12.162  1.00  0.00           O  
ATOM    739  CB  ALA A  52      28.430  27.222   9.090  1.00  0.00           C  
ATOM    740  H   ALA A  52      29.125  24.905   9.473  1.00  0.00           H  
ATOM    741  HA  ALA A  52      30.433  27.355   9.846  1.00  0.00           H  
ATOM    742  HB1 ALA A  52      28.559  26.618   8.192  1.00  0.00           H  
ATOM    743  HB2 ALA A  52      27.444  27.037   9.515  1.00  0.00           H  
ATOM    744  HB3 ALA A  52      28.522  28.277   8.834  1.00  0.00           H  
ATOM    745  N   GLY A  53      28.038  26.636  12.014  1.00  0.00           N  
ATOM    746  CA  GLY A  53      27.551  26.914  13.354  1.00  0.00           C  
ATOM    747  C   GLY A  53      26.034  26.733  13.435  1.00  0.00           C  
ATOM    748  O   GLY A  53      25.336  27.563  14.015  1.00  0.00           O  
ATOM    749  H   GLY A  53      27.503  25.965  11.500  1.00  0.00           H  
ATOM    750  HA2 GLY A  53      28.039  26.249  14.067  1.00  0.00           H  
ATOM    751  HA3 GLY A  53      27.815  27.933  13.637  1.00  0.00           H  
ATOM    752  N   ALA A  54      25.569  25.642  12.845  1.00  0.00           N  
ATOM    753  CA  ALA A  54      24.147  25.340  12.842  1.00  0.00           C  
ATOM    754  C   ALA A  54      23.889  24.114  13.719  1.00  0.00           C  
ATOM    755  O   ALA A  54      24.794  23.628  14.396  1.00  0.00           O  
ATOM    756  CB  ALA A  54      23.670  25.139  11.403  1.00  0.00           C  
ATOM    757  H   ALA A  54      26.143  24.971  12.375  1.00  0.00           H  
ATOM    758  HA  ALA A  54      23.626  26.198  13.269  1.00  0.00           H  
ATOM    759  HB1 ALA A  54      22.794  25.762  11.220  1.00  0.00           H  
ATOM    760  HB2 ALA A  54      24.466  25.419  10.713  1.00  0.00           H  
ATOM    761  HB3 ALA A  54      23.408  24.092  11.251  1.00  0.00           H  
ATOM    762  N   LYS A  55      22.649  23.648  13.680  1.00  0.00           N  
ATOM    763  CA  LYS A  55      22.260  22.487  14.462  1.00  0.00           C  
ATOM    764  C   LYS A  55      21.243  21.662  13.672  1.00  0.00           C  
ATOM    765  O   LYS A  55      20.997  21.933  12.498  1.00  0.00           O  
ATOM    766  CB  LYS A  55      21.763  22.915  15.845  1.00  0.00           C  
ATOM    767  CG  LYS A  55      22.931  23.321  16.746  1.00  0.00           C  
ATOM    768  CD  LYS A  55      22.665  22.926  18.200  1.00  0.00           C  
ATOM    769  CE  LYS A  55      23.716  23.532  19.134  1.00  0.00           C  
ATOM    770  NZ  LYS A  55      23.590  22.962  20.494  1.00  0.00           N  
ATOM    771  H   LYS A  55      21.918  24.049  13.127  1.00  0.00           H  
ATOM    772  HA  LYS A  55      23.153  21.881  14.614  1.00  0.00           H  
ATOM    773  HB2 LYS A  55      21.070  23.750  15.744  1.00  0.00           H  
ATOM    774  HB3 LYS A  55      21.210  22.097  16.306  1.00  0.00           H  
ATOM    775  HG2 LYS A  55      23.847  22.844  16.398  1.00  0.00           H  
ATOM    776  HG3 LYS A  55      23.088  24.398  16.680  1.00  0.00           H  
ATOM    777  HD2 LYS A  55      21.671  23.265  18.497  1.00  0.00           H  
ATOM    778  HD3 LYS A  55      22.673  21.841  18.292  1.00  0.00           H  
ATOM    779  HE2 LYS A  55      24.714  23.338  18.742  1.00  0.00           H  
ATOM    780  HE3 LYS A  55      23.594  24.615  19.174  1.00  0.00           H  
ATOM    781  HZ1 LYS A  55      24.031  22.065  20.522  1.00  0.00           H  
ATOM    782  HZ2 LYS A  55      24.030  23.572  21.152  1.00  0.00           H  
ATOM    783  HZ3 LYS A  55      22.622  22.864  20.726  1.00  0.00           H  
ATOM    784  N   GLU A  56      20.679  20.671  14.347  1.00  0.00           N  
ATOM    785  CA  GLU A  56      19.694  19.804  13.723  1.00  0.00           C  
ATOM    786  C   GLU A  56      18.288  20.377  13.910  1.00  0.00           C  
ATOM    787  O   GLU A  56      18.074  21.240  14.760  1.00  0.00           O  
ATOM    788  CB  GLU A  56      19.786  18.382  14.278  1.00  0.00           C  
ATOM    789  CG  GLU A  56      20.623  17.487  13.361  1.00  0.00           C  
ATOM    790  CD  GLU A  56      19.761  16.394  12.725  1.00  0.00           C  
ATOM    791  OE1 GLU A  56      18.887  15.868  13.448  1.00  0.00           O  
ATOM    792  OE2 GLU A  56      19.995  16.110  11.531  1.00  0.00           O  
ATOM    793  H   GLU A  56      20.886  20.457  15.303  1.00  0.00           H  
ATOM    794  HA  GLU A  56      19.950  19.791  12.663  1.00  0.00           H  
ATOM    795  HB2 GLU A  56      20.230  18.403  15.273  1.00  0.00           H  
ATOM    796  HB3 GLU A  56      18.785  17.964  14.384  1.00  0.00           H  
ATOM    797  HG2 GLU A  56      21.084  18.092  12.580  1.00  0.00           H  
ATOM    798  HG3 GLU A  56      21.432  17.031  13.930  1.00  0.00           H  
ATOM    799  N   GLY A  57      17.367  19.873  13.103  1.00  0.00           N  
ATOM    800  CA  GLY A  57      15.987  20.324  13.170  1.00  0.00           C  
ATOM    801  C   GLY A  57      15.893  21.834  12.947  1.00  0.00           C  
ATOM    802  O   GLY A  57      14.870  22.447  13.249  1.00  0.00           O  
ATOM    803  H   GLY A  57      17.549  19.171  12.414  1.00  0.00           H  
ATOM    804  HA2 GLY A  57      15.394  19.804  12.417  1.00  0.00           H  
ATOM    805  HA3 GLY A  57      15.563  20.068  14.141  1.00  0.00           H  
ATOM    806  N   ASP A  58      16.973  22.392  12.420  1.00  0.00           N  
ATOM    807  CA  ASP A  58      17.025  23.819  12.154  1.00  0.00           C  
ATOM    808  C   ASP A  58      16.058  24.156  11.015  1.00  0.00           C  
ATOM    809  O   ASP A  58      16.193  23.639   9.908  1.00  0.00           O  
ATOM    810  CB  ASP A  58      18.428  24.248  11.724  1.00  0.00           C  
ATOM    811  CG  ASP A  58      19.503  24.118  12.805  1.00  0.00           C  
ATOM    812  OD1 ASP A  58      19.201  23.473  13.832  1.00  0.00           O  
ATOM    813  OD2 ASP A  58      20.603  24.667  12.580  1.00  0.00           O  
ATOM    814  H   ASP A  58      17.800  21.886  12.177  1.00  0.00           H  
ATOM    815  HA  ASP A  58      16.745  24.297  13.093  1.00  0.00           H  
ATOM    816  HB2 ASP A  58      18.727  23.652  10.862  1.00  0.00           H  
ATOM    817  HB3 ASP A  58      18.390  25.287  11.395  1.00  0.00           H  
ATOM    818  N   TYR A  59      15.106  25.022  11.328  1.00  0.00           N  
ATOM    819  CA  TYR A  59      14.117  25.435  10.346  1.00  0.00           C  
ATOM    820  C   TYR A  59      14.555  26.715   9.632  1.00  0.00           C  
ATOM    821  O   TYR A  59      14.529  27.797  10.218  1.00  0.00           O  
ATOM    822  CB  TYR A  59      12.834  25.715  11.131  1.00  0.00           C  
ATOM    823  CG  TYR A  59      12.331  24.523  11.948  1.00  0.00           C  
ATOM    824  CD1 TYR A  59      12.855  24.275  13.200  1.00  0.00           C  
ATOM    825  CD2 TYR A  59      11.354  23.697  11.433  1.00  0.00           C  
ATOM    826  CE1 TYR A  59      12.382  23.153  13.969  1.00  0.00           C  
ATOM    827  CE2 TYR A  59      10.880  22.575  12.202  1.00  0.00           C  
ATOM    828  CZ  TYR A  59      11.418  22.359  13.431  1.00  0.00           C  
ATOM    829  OH  TYR A  59      10.970  21.299  14.158  1.00  0.00           O  
ATOM    830  H   TYR A  59      15.003  25.439  12.231  1.00  0.00           H  
ATOM    831  HA  TYR A  59      14.018  24.635   9.613  1.00  0.00           H  
ATOM    832  HB2 TYR A  59      13.008  26.556  11.803  1.00  0.00           H  
ATOM    833  HB3 TYR A  59      12.054  26.020  10.435  1.00  0.00           H  
ATOM    834  HD1 TYR A  59      13.628  24.928  13.607  1.00  0.00           H  
ATOM    835  HD2 TYR A  59      10.939  23.894  10.443  1.00  0.00           H  
ATOM    836  HE1 TYR A  59      12.787  22.945  14.959  1.00  0.00           H  
ATOM    837  HE2 TYR A  59      10.108  21.915  11.806  1.00  0.00           H  
ATOM    838  HH  TYR A  59      11.588  20.521  14.043  1.00  0.00           H  
ATOM    839  N   ILE A  60      14.948  26.551   8.378  1.00  0.00           N  
ATOM    840  CA  ILE A  60      15.390  27.681   7.579  1.00  0.00           C  
ATOM    841  C   ILE A  60      14.225  28.654   7.389  1.00  0.00           C  
ATOM    842  O   ILE A  60      13.103  28.236   7.108  1.00  0.00           O  
ATOM    843  CB  ILE A  60      16.008  27.198   6.265  1.00  0.00           C  
ATOM    844  CG1 ILE A  60      17.168  26.234   6.526  1.00  0.00           C  
ATOM    845  CG2 ILE A  60      16.432  28.380   5.390  1.00  0.00           C  
ATOM    846  CD1 ILE A  60      17.075  25.005   5.620  1.00  0.00           C  
ATOM    847  H   ILE A  60      14.967  25.668   7.909  1.00  0.00           H  
ATOM    848  HA  ILE A  60      16.177  28.189   8.137  1.00  0.00           H  
ATOM    849  HB  ILE A  60      15.249  26.645   5.712  1.00  0.00           H  
ATOM    850 HG12 ILE A  60      18.116  26.745   6.355  1.00  0.00           H  
ATOM    851 HG13 ILE A  60      17.159  25.922   7.570  1.00  0.00           H  
ATOM    852 HG21 ILE A  60      15.548  28.942   5.087  1.00  0.00           H  
ATOM    853 HG22 ILE A  60      17.099  29.030   5.956  1.00  0.00           H  
ATOM    854 HG23 ILE A  60      16.949  28.011   4.504  1.00  0.00           H  
ATOM    855 HD11 ILE A  60      17.608  25.199   4.689  1.00  0.00           H  
ATOM    856 HD12 ILE A  60      17.523  24.148   6.122  1.00  0.00           H  
ATOM    857 HD13 ILE A  60      16.028  24.793   5.402  1.00  0.00           H  
ATOM    858  N   VAL A  61      14.531  29.933   7.549  1.00  0.00           N  
ATOM    859  CA  VAL A  61      13.524  30.968   7.399  1.00  0.00           C  
ATOM    860  C   VAL A  61      13.855  31.823   6.174  1.00  0.00           C  
ATOM    861  O   VAL A  61      12.956  32.266   5.460  1.00  0.00           O  
ATOM    862  CB  VAL A  61      13.418  31.786   8.687  1.00  0.00           C  
ATOM    863  CG1 VAL A  61      12.683  31.002   9.776  1.00  0.00           C  
ATOM    864  CG2 VAL A  61      14.799  32.231   9.170  1.00  0.00           C  
ATOM    865  H   VAL A  61      15.447  30.264   7.777  1.00  0.00           H  
ATOM    866  HA  VAL A  61      12.567  30.474   7.233  1.00  0.00           H  
ATOM    867  HB  VAL A  61      12.835  32.681   8.470  1.00  0.00           H  
ATOM    868 HG11 VAL A  61      12.819  31.499  10.737  1.00  0.00           H  
ATOM    869 HG12 VAL A  61      11.621  30.954   9.537  1.00  0.00           H  
ATOM    870 HG13 VAL A  61      13.088  29.991   9.831  1.00  0.00           H  
ATOM    871 HG21 VAL A  61      15.350  32.672   8.338  1.00  0.00           H  
ATOM    872 HG22 VAL A  61      14.687  32.970   9.963  1.00  0.00           H  
ATOM    873 HG23 VAL A  61      15.346  31.368   9.551  1.00  0.00           H  
ATOM    874  N   SER A  62      15.148  32.028   5.967  1.00  0.00           N  
ATOM    875  CA  SER A  62      15.609  32.822   4.842  1.00  0.00           C  
ATOM    876  C   SER A  62      17.030  32.407   4.456  1.00  0.00           C  
ATOM    877  O   SER A  62      17.759  31.843   5.271  1.00  0.00           O  
ATOM    878  CB  SER A  62      15.561  34.316   5.164  1.00  0.00           C  
ATOM    879  OG  SER A  62      14.227  34.815   5.191  1.00  0.00           O  
ATOM    880  H   SER A  62      15.872  31.664   6.553  1.00  0.00           H  
ATOM    881  HA  SER A  62      14.914  32.603   4.030  1.00  0.00           H  
ATOM    882  HB2 SER A  62      16.034  34.493   6.130  1.00  0.00           H  
ATOM    883  HB3 SER A  62      16.139  34.867   4.421  1.00  0.00           H  
ATOM    884  HG  SER A  62      14.072  35.419   4.409  1.00  0.00           H  
ATOM    885  N   ILE A  63      17.383  32.703   3.213  1.00  0.00           N  
ATOM    886  CA  ILE A  63      18.704  32.367   2.710  1.00  0.00           C  
ATOM    887  C   ILE A  63      19.259  33.553   1.918  1.00  0.00           C  
ATOM    888  O   ILE A  63      18.871  33.775   0.773  1.00  0.00           O  
ATOM    889  CB  ILE A  63      18.659  31.062   1.914  1.00  0.00           C  
ATOM    890  CG1 ILE A  63      18.212  29.896   2.796  1.00  0.00           C  
ATOM    891  CG2 ILE A  63      20.002  30.787   1.236  1.00  0.00           C  
ATOM    892  CD1 ILE A  63      18.011  28.626   1.968  1.00  0.00           C  
ATOM    893  H   ILE A  63      16.785  33.162   2.557  1.00  0.00           H  
ATOM    894  HA  ILE A  63      19.348  32.196   3.573  1.00  0.00           H  
ATOM    895  HB  ILE A  63      17.916  31.171   1.123  1.00  0.00           H  
ATOM    896 HG12 ILE A  63      18.958  29.714   3.571  1.00  0.00           H  
ATOM    897 HG13 ILE A  63      17.283  30.154   3.304  1.00  0.00           H  
ATOM    898 HG21 ILE A  63      20.444  31.728   0.909  1.00  0.00           H  
ATOM    899 HG22 ILE A  63      20.673  30.298   1.944  1.00  0.00           H  
ATOM    900 HG23 ILE A  63      19.848  30.138   0.374  1.00  0.00           H  
ATOM    901 HD11 ILE A  63      18.680  27.846   2.329  1.00  0.00           H  
ATOM    902 HD12 ILE A  63      16.978  28.291   2.061  1.00  0.00           H  
ATOM    903 HD13 ILE A  63      18.230  28.837   0.921  1.00  0.00           H  
ATOM    904  N   GLN A  64      20.160  34.282   2.560  1.00  0.00           N  
ATOM    905  CA  GLN A  64      20.772  35.440   1.930  1.00  0.00           C  
ATOM    906  C   GLN A  64      19.782  36.606   1.885  1.00  0.00           C  
ATOM    907  O   GLN A  64      20.052  37.630   1.258  1.00  0.00           O  
ATOM    908  CB  GLN A  64      21.280  35.096   0.528  1.00  0.00           C  
ATOM    909  CG  GLN A  64      22.792  35.305   0.427  1.00  0.00           C  
ATOM    910  CD  GLN A  64      23.160  36.773   0.650  1.00  0.00           C  
ATOM    911  OE1 GLN A  64      22.404  37.682   0.349  1.00  0.00           O  
ATOM    912  NE2 GLN A  64      24.359  36.954   1.196  1.00  0.00           N  
ATOM    913  H   GLN A  64      20.471  34.095   3.493  1.00  0.00           H  
ATOM    914  HA  GLN A  64      21.620  35.700   2.563  1.00  0.00           H  
ATOM    915  HB2 GLN A  64      21.036  34.060   0.293  1.00  0.00           H  
ATOM    916  HB3 GLN A  64      20.773  35.718  -0.209  1.00  0.00           H  
ATOM    917  HG2 GLN A  64      23.300  34.683   1.164  1.00  0.00           H  
ATOM    918  HG3 GLN A  64      23.142  34.985  -0.555  1.00  0.00           H  
ATOM    919 HE21 GLN A  64      24.930  36.164   1.420  1.00  0.00           H  
ATOM    920 HE22 GLN A  64      24.690  37.879   1.381  1.00  0.00           H  
ATOM    921  N   GLY A  65      18.657  36.411   2.555  1.00  0.00           N  
ATOM    922  CA  GLY A  65      17.625  37.434   2.599  1.00  0.00           C  
ATOM    923  C   GLY A  65      16.317  36.919   1.994  1.00  0.00           C  
ATOM    924  O   GLY A  65      15.245  37.448   2.283  1.00  0.00           O  
ATOM    925  H   GLY A  65      18.445  35.575   3.063  1.00  0.00           H  
ATOM    926  HA2 GLY A  65      17.457  37.741   3.631  1.00  0.00           H  
ATOM    927  HA3 GLY A  65      17.960  38.316   2.054  1.00  0.00           H  
ATOM    928  N   VAL A  66      16.449  35.893   1.165  1.00  0.00           N  
ATOM    929  CA  VAL A  66      15.291  35.301   0.518  1.00  0.00           C  
ATOM    930  C   VAL A  66      14.373  34.693   1.580  1.00  0.00           C  
ATOM    931  O   VAL A  66      14.826  34.335   2.666  1.00  0.00           O  
ATOM    932  CB  VAL A  66      15.742  34.287  -0.534  1.00  0.00           C  
ATOM    933  CG1 VAL A  66      14.539  33.635  -1.219  1.00  0.00           C  
ATOM    934  CG2 VAL A  66      16.671  34.938  -1.562  1.00  0.00           C  
ATOM    935  H   VAL A  66      17.325  35.468   0.936  1.00  0.00           H  
ATOM    936  HA  VAL A  66      14.754  36.101   0.007  1.00  0.00           H  
ATOM    937  HB  VAL A  66      16.303  33.503  -0.026  1.00  0.00           H  
ATOM    938 HG11 VAL A  66      13.829  34.407  -1.519  1.00  0.00           H  
ATOM    939 HG12 VAL A  66      14.874  33.087  -2.100  1.00  0.00           H  
ATOM    940 HG13 VAL A  66      14.055  32.947  -0.525  1.00  0.00           H  
ATOM    941 HG21 VAL A  66      16.595  34.405  -2.510  1.00  0.00           H  
ATOM    942 HG22 VAL A  66      16.380  35.978  -1.706  1.00  0.00           H  
ATOM    943 HG23 VAL A  66      17.699  34.894  -1.201  1.00  0.00           H  
ATOM    944  N   ASP A  67      13.099  34.595   1.230  1.00  0.00           N  
ATOM    945  CA  ASP A  67      12.113  34.037   2.139  1.00  0.00           C  
ATOM    946  C   ASP A  67      12.077  32.516   1.974  1.00  0.00           C  
ATOM    947  O   ASP A  67      11.801  32.012   0.887  1.00  0.00           O  
ATOM    948  CB  ASP A  67      10.715  34.578   1.837  1.00  0.00           C  
ATOM    949  CG  ASP A  67      10.030  35.290   3.004  1.00  0.00           C  
ATOM    950  OD1 ASP A  67      10.723  36.094   3.665  1.00  0.00           O  
ATOM    951  OD2 ASP A  67       8.828  35.015   3.211  1.00  0.00           O  
ATOM    952  H   ASP A  67      12.739  34.890   0.345  1.00  0.00           H  
ATOM    953  HA  ASP A  67      12.437  34.341   3.135  1.00  0.00           H  
ATOM    954  HB2 ASP A  67      10.783  35.271   0.998  1.00  0.00           H  
ATOM    955  HB3 ASP A  67      10.082  33.751   1.514  1.00  0.00           H  
ATOM    956  N   CYS A  68      12.361  31.827   3.069  1.00  0.00           N  
ATOM    957  CA  CYS A  68      12.366  30.374   3.060  1.00  0.00           C  
ATOM    958  C   CYS A  68      11.593  29.883   4.286  1.00  0.00           C  
ATOM    959  O   CYS A  68      12.103  29.080   5.066  1.00  0.00           O  
ATOM    960  CB  CYS A  68      13.788  29.813   3.019  1.00  0.00           C  
ATOM    961  SG  CYS A  68      14.490  30.006   1.341  1.00  0.00           S  
ATOM    962  H   CYS A  68      12.586  32.245   3.951  1.00  0.00           H  
ATOM    963  HA  CYS A  68      11.869  30.066   2.141  1.00  0.00           H  
ATOM    964  HB2 CYS A  68      14.414  30.331   3.746  1.00  0.00           H  
ATOM    965  HB3 CYS A  68      13.780  28.759   3.300  1.00  0.00           H  
ATOM    966  HG  CYS A  68      14.610  31.330   1.392  1.00  0.00           H  
ATOM    967  N   LYS A  69      10.375  30.387   4.419  1.00  0.00           N  
ATOM    968  CA  LYS A  69       9.526  30.010   5.537  1.00  0.00           C  
ATOM    969  C   LYS A  69       8.364  29.157   5.024  1.00  0.00           C  
ATOM    970  O   LYS A  69       7.884  28.269   5.727  1.00  0.00           O  
ATOM    971  CB  LYS A  69       9.083  31.251   6.314  1.00  0.00           C  
ATOM    972  CG  LYS A  69       9.032  30.967   7.818  1.00  0.00           C  
ATOM    973  CD  LYS A  69       8.089  31.939   8.528  1.00  0.00           C  
ATOM    974  CE  LYS A  69       8.670  33.355   8.540  1.00  0.00           C  
ATOM    975  NZ  LYS A  69       8.990  33.772   9.925  1.00  0.00           N  
ATOM    976  H   LYS A  69       9.966  31.040   3.780  1.00  0.00           H  
ATOM    977  HA  LYS A  69      10.128  29.404   6.213  1.00  0.00           H  
ATOM    978  HB2 LYS A  69       9.770  32.073   6.119  1.00  0.00           H  
ATOM    979  HB3 LYS A  69       8.099  31.569   5.968  1.00  0.00           H  
ATOM    980  HG2 LYS A  69       8.700  29.943   7.986  1.00  0.00           H  
ATOM    981  HG3 LYS A  69      10.034  31.051   8.240  1.00  0.00           H  
ATOM    982  HD2 LYS A  69       7.121  31.944   8.027  1.00  0.00           H  
ATOM    983  HD3 LYS A  69       7.918  31.604   9.550  1.00  0.00           H  
ATOM    984  HE2 LYS A  69       9.570  33.391   7.926  1.00  0.00           H  
ATOM    985  HE3 LYS A  69       7.956  34.051   8.100  1.00  0.00           H  
ATOM    986  HZ1 LYS A  69       9.881  33.401  10.187  1.00  0.00           H  
ATOM    987  HZ2 LYS A  69       9.016  34.771   9.974  1.00  0.00           H  
ATOM    988  HZ3 LYS A  69       8.289  33.425  10.547  1.00  0.00           H  
ATOM    989  N   TRP A  70       7.945  29.456   3.803  1.00  0.00           N  
ATOM    990  CA  TRP A  70       6.849  28.728   3.189  1.00  0.00           C  
ATOM    991  C   TRP A  70       7.443  27.733   2.190  1.00  0.00           C  
ATOM    992  O   TRP A  70       6.929  26.627   2.029  1.00  0.00           O  
ATOM    993  CB  TRP A  70       5.842  29.687   2.552  1.00  0.00           C  
ATOM    994  CG  TRP A  70       5.525  30.916   3.407  1.00  0.00           C  
ATOM    995  CD1 TRP A  70       6.207  32.068   3.479  1.00  0.00           C  
ATOM    996  CD2 TRP A  70       4.413  31.070   4.312  1.00  0.00           C  
ATOM    997  NE1 TRP A  70       5.617  32.949   4.363  1.00  0.00           N  
ATOM    998  CE2 TRP A  70       4.491  32.322   4.886  1.00  0.00           C  
ATOM    999  CE3 TRP A  70       3.374  30.179   4.638  1.00  0.00           C  
ATOM   1000  CZ2 TRP A  70       3.562  32.799   5.817  1.00  0.00           C  
ATOM   1001  CZ3 TRP A  70       2.454  30.671   5.571  1.00  0.00           C  
ATOM   1002  CH2 TRP A  70       2.519  31.929   6.156  1.00  0.00           C  
ATOM   1003  H   TRP A  70       8.341  30.180   3.238  1.00  0.00           H  
ATOM   1004  HA  TRP A  70       6.320  28.193   3.978  1.00  0.00           H  
ATOM   1005  HB2 TRP A  70       6.231  30.018   1.588  1.00  0.00           H  
ATOM   1006  HB3 TRP A  70       4.916  29.148   2.353  1.00  0.00           H  
ATOM   1007  HD1 TRP A  70       7.113  32.282   2.913  1.00  0.00           H  
ATOM   1008  HE1 TRP A  70       5.969  33.951   4.606  1.00  0.00           H  
ATOM   1009  HE3 TRP A  70       3.290  29.185   4.199  1.00  0.00           H  
ATOM   1010  HZ2 TRP A  70       3.646  33.793   6.256  1.00  0.00           H  
ATOM   1011  HZ3 TRP A  70       1.628  30.020   5.858  1.00  0.00           H  
ATOM   1012  HH2 TRP A  70       1.760  32.238   6.877  1.00  0.00           H  
ATOM   1013  N   LEU A  71       8.517  28.163   1.544  1.00  0.00           N  
ATOM   1014  CA  LEU A  71       9.186  27.324   0.564  1.00  0.00           C  
ATOM   1015  C   LEU A  71       9.272  25.893   1.099  1.00  0.00           C  
ATOM   1016  O   LEU A  71       9.253  25.677   2.309  1.00  0.00           O  
ATOM   1017  CB  LEU A  71      10.542  27.921   0.184  1.00  0.00           C  
ATOM   1018  CG  LEU A  71      10.512  29.335  -0.402  1.00  0.00           C  
ATOM   1019  CD1 LEU A  71      11.824  29.657  -1.119  1.00  0.00           C  
ATOM   1020  CD2 LEU A  71       9.298  29.525  -1.312  1.00  0.00           C  
ATOM   1021  H   LEU A  71       8.928  29.063   1.680  1.00  0.00           H  
ATOM   1022  HA  LEU A  71       8.572  27.320  -0.337  1.00  0.00           H  
ATOM   1023  HB2 LEU A  71      11.175  27.931   1.073  1.00  0.00           H  
ATOM   1024  HB3 LEU A  71      11.019  27.259  -0.538  1.00  0.00           H  
ATOM   1025  HG  LEU A  71      10.413  30.043   0.421  1.00  0.00           H  
ATOM   1026 HD11 LEU A  71      12.219  28.751  -1.581  1.00  0.00           H  
ATOM   1027 HD12 LEU A  71      11.642  30.407  -1.889  1.00  0.00           H  
ATOM   1028 HD13 LEU A  71      12.547  30.044  -0.400  1.00  0.00           H  
ATOM   1029 HD21 LEU A  71       8.424  29.761  -0.706  1.00  0.00           H  
ATOM   1030 HD22 LEU A  71       9.491  30.342  -2.009  1.00  0.00           H  
ATOM   1031 HD23 LEU A  71       9.115  28.608  -1.870  1.00  0.00           H  
ATOM   1032  N   THR A  72       9.364  24.953   0.169  1.00  0.00           N  
ATOM   1033  CA  THR A  72       9.453  23.548   0.531  1.00  0.00           C  
ATOM   1034  C   THR A  72      10.911  23.083   0.508  1.00  0.00           C  
ATOM   1035  O   THR A  72      11.818  23.857   0.808  1.00  0.00           O  
ATOM   1036  CB  THR A  72       8.548  22.758  -0.415  1.00  0.00           C  
ATOM   1037  OG1 THR A  72       9.295  22.679  -1.626  1.00  0.00           O  
ATOM   1038  CG2 THR A  72       7.288  23.534  -0.805  1.00  0.00           C  
ATOM   1039  H   THR A  72       9.379  25.137  -0.814  1.00  0.00           H  
ATOM   1040  HA  THR A  72       9.098  23.435   1.556  1.00  0.00           H  
ATOM   1041  HB  THR A  72       8.291  21.789   0.012  1.00  0.00           H  
ATOM   1042  HG1 THR A  72       9.357  23.582  -2.049  1.00  0.00           H  
ATOM   1043 HG21 THR A  72       6.794  23.901   0.095  1.00  0.00           H  
ATOM   1044 HG22 THR A  72       7.562  24.378  -1.438  1.00  0.00           H  
ATOM   1045 HG23 THR A  72       6.610  22.877  -1.349  1.00  0.00           H  
ATOM   1046  N   VAL A  73      11.089  21.820   0.149  1.00  0.00           N  
ATOM   1047  CA  VAL A  73      12.420  21.242   0.082  1.00  0.00           C  
ATOM   1048  C   VAL A  73      13.037  21.549  -1.284  1.00  0.00           C  
ATOM   1049  O   VAL A  73      14.175  22.008  -1.366  1.00  0.00           O  
ATOM   1050  CB  VAL A  73      12.356  19.744   0.388  1.00  0.00           C  
ATOM   1051  CG1 VAL A  73      13.684  19.060   0.054  1.00  0.00           C  
ATOM   1052  CG2 VAL A  73      11.963  19.498   1.845  1.00  0.00           C  
ATOM   1053  H   VAL A  73      10.345  21.197  -0.094  1.00  0.00           H  
ATOM   1054  HA  VAL A  73      13.024  21.719   0.855  1.00  0.00           H  
ATOM   1055  HB  VAL A  73      11.585  19.306  -0.246  1.00  0.00           H  
ATOM   1056 HG11 VAL A  73      13.955  18.380   0.861  1.00  0.00           H  
ATOM   1057 HG12 VAL A  73      13.579  18.498  -0.875  1.00  0.00           H  
ATOM   1058 HG13 VAL A  73      14.462  19.814  -0.063  1.00  0.00           H  
ATOM   1059 HG21 VAL A  73      11.116  20.132   2.105  1.00  0.00           H  
ATOM   1060 HG22 VAL A  73      11.686  18.451   1.975  1.00  0.00           H  
ATOM   1061 HG23 VAL A  73      12.807  19.734   2.494  1.00  0.00           H  
ATOM   1062  N   SER A  74      12.259  21.281  -2.322  1.00  0.00           N  
ATOM   1063  CA  SER A  74      12.714  21.523  -3.680  1.00  0.00           C  
ATOM   1064  C   SER A  74      13.142  22.984  -3.837  1.00  0.00           C  
ATOM   1065  O   SER A  74      14.259  23.264  -4.269  1.00  0.00           O  
ATOM   1066  CB  SER A  74      11.624  21.177  -4.696  1.00  0.00           C  
ATOM   1067  OG  SER A  74      12.169  20.824  -5.965  1.00  0.00           O  
ATOM   1068  H   SER A  74      11.334  20.907  -2.246  1.00  0.00           H  
ATOM   1069  HA  SER A  74      13.566  20.858  -3.821  1.00  0.00           H  
ATOM   1070  HB2 SER A  74      11.024  20.349  -4.317  1.00  0.00           H  
ATOM   1071  HB3 SER A  74      10.954  22.029  -4.814  1.00  0.00           H  
ATOM   1072  HG  SER A  74      11.578  21.162  -6.697  1.00  0.00           H  
ATOM   1073  N   GLU A  75      12.231  23.876  -3.478  1.00  0.00           N  
ATOM   1074  CA  GLU A  75      12.499  25.300  -3.573  1.00  0.00           C  
ATOM   1075  C   GLU A  75      13.840  25.633  -2.917  1.00  0.00           C  
ATOM   1076  O   GLU A  75      14.798  25.992  -3.600  1.00  0.00           O  
ATOM   1077  CB  GLU A  75      11.365  26.115  -2.947  1.00  0.00           C  
ATOM   1078  CG  GLU A  75      10.304  26.470  -3.992  1.00  0.00           C  
ATOM   1079  CD  GLU A  75       8.985  25.754  -3.696  1.00  0.00           C  
ATOM   1080  OE1 GLU A  75       8.860  24.590  -4.134  1.00  0.00           O  
ATOM   1081  OE2 GLU A  75       8.130  26.388  -3.040  1.00  0.00           O  
ATOM   1082  H   GLU A  75      11.324  23.639  -3.128  1.00  0.00           H  
ATOM   1083  HA  GLU A  75      12.546  25.515  -4.641  1.00  0.00           H  
ATOM   1084  HB2 GLU A  75      10.908  25.546  -2.138  1.00  0.00           H  
ATOM   1085  HB3 GLU A  75      11.768  27.027  -2.509  1.00  0.00           H  
ATOM   1086  HG2 GLU A  75      10.144  27.548  -4.000  1.00  0.00           H  
ATOM   1087  HG3 GLU A  75      10.658  26.192  -4.984  1.00  0.00           H  
ATOM   1088  N   VAL A  76      13.867  25.499  -1.599  1.00  0.00           N  
ATOM   1089  CA  VAL A  76      15.076  25.781  -0.843  1.00  0.00           C  
ATOM   1090  C   VAL A  76      16.276  25.157  -1.556  1.00  0.00           C  
ATOM   1091  O   VAL A  76      17.211  25.860  -1.937  1.00  0.00           O  
ATOM   1092  CB  VAL A  76      14.916  25.292   0.599  1.00  0.00           C  
ATOM   1093  CG1 VAL A  76      16.245  25.366   1.352  1.00  0.00           C  
ATOM   1094  CG2 VAL A  76      13.827  26.081   1.329  1.00  0.00           C  
ATOM   1095  H   VAL A  76      13.084  25.205  -1.051  1.00  0.00           H  
ATOM   1096  HA  VAL A  76      15.203  26.863  -0.820  1.00  0.00           H  
ATOM   1097  HB  VAL A  76      14.608  24.247   0.565  1.00  0.00           H  
ATOM   1098 HG11 VAL A  76      16.193  24.741   2.243  1.00  0.00           H  
ATOM   1099 HG12 VAL A  76      17.049  25.013   0.706  1.00  0.00           H  
ATOM   1100 HG13 VAL A  76      16.440  26.399   1.644  1.00  0.00           H  
ATOM   1101 HG21 VAL A  76      13.275  25.412   1.988  1.00  0.00           H  
ATOM   1102 HG22 VAL A  76      14.287  26.875   1.917  1.00  0.00           H  
ATOM   1103 HG23 VAL A  76      13.144  26.517   0.599  1.00  0.00           H  
ATOM   1104  N   MET A  77      16.212  23.844  -1.717  1.00  0.00           N  
ATOM   1105  CA  MET A  77      17.282  23.117  -2.378  1.00  0.00           C  
ATOM   1106  C   MET A  77      17.830  23.910  -3.566  1.00  0.00           C  
ATOM   1107  O   MET A  77      19.044  24.014  -3.740  1.00  0.00           O  
ATOM   1108  CB  MET A  77      16.756  21.766  -2.867  1.00  0.00           C  
ATOM   1109  CG  MET A  77      17.138  20.646  -1.896  1.00  0.00           C  
ATOM   1110  SD  MET A  77      18.915  20.542  -1.755  1.00  0.00           S  
ATOM   1111  CE  MET A  77      19.060  20.002  -0.059  1.00  0.00           C  
ATOM   1112  H   MET A  77      15.447  23.279  -1.404  1.00  0.00           H  
ATOM   1113  HA  MET A  77      18.060  22.992  -1.625  1.00  0.00           H  
ATOM   1114  HB2 MET A  77      15.672  21.808  -2.967  1.00  0.00           H  
ATOM   1115  HB3 MET A  77      17.161  21.549  -3.855  1.00  0.00           H  
ATOM   1116  HG2 MET A  77      16.698  20.835  -0.918  1.00  0.00           H  
ATOM   1117  HG3 MET A  77      16.737  19.696  -2.248  1.00  0.00           H  
ATOM   1118  HE1 MET A  77      19.182  20.871   0.589  1.00  0.00           H  
ATOM   1119  HE2 MET A  77      18.159  19.460   0.228  1.00  0.00           H  
ATOM   1120  HE3 MET A  77      19.927  19.349   0.042  1.00  0.00           H  
ATOM   1121  N   LYS A  78      16.910  24.449  -4.353  1.00  0.00           N  
ATOM   1122  CA  LYS A  78      17.287  25.230  -5.519  1.00  0.00           C  
ATOM   1123  C   LYS A  78      17.847  26.580  -5.065  1.00  0.00           C  
ATOM   1124  O   LYS A  78      18.842  27.057  -5.607  1.00  0.00           O  
ATOM   1125  CB  LYS A  78      16.109  25.348  -6.487  1.00  0.00           C  
ATOM   1126  CG  LYS A  78      16.199  24.293  -7.592  1.00  0.00           C  
ATOM   1127  CD  LYS A  78      14.992  24.375  -8.528  1.00  0.00           C  
ATOM   1128  CE  LYS A  78      15.432  24.669  -9.964  1.00  0.00           C  
ATOM   1129  NZ  LYS A  78      14.323  25.284 -10.730  1.00  0.00           N  
ATOM   1130  H   LYS A  78      15.926  24.360  -4.204  1.00  0.00           H  
ATOM   1131  HA  LYS A  78      18.076  24.685  -6.036  1.00  0.00           H  
ATOM   1132  HB2 LYS A  78      15.171  25.231  -5.943  1.00  0.00           H  
ATOM   1133  HB3 LYS A  78      16.096  26.344  -6.931  1.00  0.00           H  
ATOM   1134  HG2 LYS A  78      17.116  24.436  -8.162  1.00  0.00           H  
ATOM   1135  HG3 LYS A  78      16.251  23.299  -7.147  1.00  0.00           H  
ATOM   1136  HD2 LYS A  78      14.438  23.436  -8.499  1.00  0.00           H  
ATOM   1137  HD3 LYS A  78      14.313  25.156  -8.185  1.00  0.00           H  
ATOM   1138  HE2 LYS A  78      16.292  25.337  -9.958  1.00  0.00           H  
ATOM   1139  HE3 LYS A  78      15.748  23.746 -10.450  1.00  0.00           H  
ATOM   1140  HZ1 LYS A  78      13.588  25.543 -10.103  1.00  0.00           H  
ATOM   1141  HZ2 LYS A  78      14.659  26.098 -11.204  1.00  0.00           H  
ATOM   1142  HZ3 LYS A  78      13.976  24.628 -11.399  1.00  0.00           H  
ATOM   1143  N   LEU A  79      17.184  27.155  -4.073  1.00  0.00           N  
ATOM   1144  CA  LEU A  79      17.603  28.441  -3.539  1.00  0.00           C  
ATOM   1145  C   LEU A  79      19.022  28.317  -2.979  1.00  0.00           C  
ATOM   1146  O   LEU A  79      19.758  29.301  -2.921  1.00  0.00           O  
ATOM   1147  CB  LEU A  79      16.584  28.957  -2.522  1.00  0.00           C  
ATOM   1148  CG  LEU A  79      16.045  30.368  -2.770  1.00  0.00           C  
ATOM   1149  CD1 LEU A  79      14.518  30.362  -2.871  1.00  0.00           C  
ATOM   1150  CD2 LEU A  79      16.545  31.342  -1.702  1.00  0.00           C  
ATOM   1151  H   LEU A  79      16.376  26.761  -3.637  1.00  0.00           H  
ATOM   1152  HA  LEU A  79      17.619  29.149  -4.368  1.00  0.00           H  
ATOM   1153  HB2 LEU A  79      15.741  28.266  -2.500  1.00  0.00           H  
ATOM   1154  HB3 LEU A  79      17.042  28.933  -1.533  1.00  0.00           H  
ATOM   1155  HG  LEU A  79      16.429  30.717  -3.729  1.00  0.00           H  
ATOM   1156 HD11 LEU A  79      14.200  31.107  -3.599  1.00  0.00           H  
ATOM   1157 HD12 LEU A  79      14.179  29.376  -3.188  1.00  0.00           H  
ATOM   1158 HD13 LEU A  79      14.089  30.598  -1.898  1.00  0.00           H  
ATOM   1159 HD21 LEU A  79      17.440  30.936  -1.231  1.00  0.00           H  
ATOM   1160 HD22 LEU A  79      16.780  32.300  -2.164  1.00  0.00           H  
ATOM   1161 HD23 LEU A  79      15.771  31.482  -0.947  1.00  0.00           H  
ATOM   1162  N   LEU A  80      19.363  27.100  -2.582  1.00  0.00           N  
ATOM   1163  CA  LEU A  80      20.680  26.835  -2.029  1.00  0.00           C  
ATOM   1164  C   LEU A  80      21.653  26.520  -3.167  1.00  0.00           C  
ATOM   1165  O   LEU A  80      22.759  27.056  -3.210  1.00  0.00           O  
ATOM   1166  CB  LEU A  80      20.604  25.738  -0.964  1.00  0.00           C  
ATOM   1167  CG  LEU A  80      20.621  26.214   0.491  1.00  0.00           C  
ATOM   1168  CD1 LEU A  80      20.301  25.064   1.447  1.00  0.00           C  
ATOM   1169  CD2 LEU A  80      21.952  26.889   0.831  1.00  0.00           C  
ATOM   1170  H   LEU A  80      18.758  26.305  -2.633  1.00  0.00           H  
ATOM   1171  HA  LEU A  80      21.015  27.745  -1.531  1.00  0.00           H  
ATOM   1172  HB2 LEU A  80      19.691  25.165  -1.127  1.00  0.00           H  
ATOM   1173  HB3 LEU A  80      21.440  25.056  -1.113  1.00  0.00           H  
ATOM   1174  HG  LEU A  80      19.840  26.964   0.615  1.00  0.00           H  
ATOM   1175 HD11 LEU A  80      20.623  24.121   1.003  1.00  0.00           H  
ATOM   1176 HD12 LEU A  80      20.824  25.219   2.390  1.00  0.00           H  
ATOM   1177 HD13 LEU A  80      19.226  25.030   1.628  1.00  0.00           H  
ATOM   1178 HD21 LEU A  80      22.448  27.199  -0.089  1.00  0.00           H  
ATOM   1179 HD22 LEU A  80      21.767  27.762   1.456  1.00  0.00           H  
ATOM   1180 HD23 LEU A  80      22.589  26.185   1.367  1.00  0.00           H  
ATOM   1181  N   LYS A  81      21.204  25.652  -4.062  1.00  0.00           N  
ATOM   1182  CA  LYS A  81      22.022  25.258  -5.198  1.00  0.00           C  
ATOM   1183  C   LYS A  81      22.473  26.510  -5.954  1.00  0.00           C  
ATOM   1184  O   LYS A  81      23.658  26.676  -6.236  1.00  0.00           O  
ATOM   1185  CB  LYS A  81      21.275  24.248  -6.070  1.00  0.00           C  
ATOM   1186  CG  LYS A  81      21.283  22.858  -5.431  1.00  0.00           C  
ATOM   1187  CD  LYS A  81      20.192  21.970  -6.032  1.00  0.00           C  
ATOM   1188  CE  LYS A  81      19.688  20.952  -5.009  1.00  0.00           C  
ATOM   1189  NZ  LYS A  81      18.687  20.051  -5.622  1.00  0.00           N  
ATOM   1190  H   LYS A  81      20.303  25.220  -4.020  1.00  0.00           H  
ATOM   1191  HA  LYS A  81      22.905  24.755  -4.806  1.00  0.00           H  
ATOM   1192  HB2 LYS A  81      20.247  24.578  -6.218  1.00  0.00           H  
ATOM   1193  HB3 LYS A  81      21.738  24.202  -7.056  1.00  0.00           H  
ATOM   1194  HG2 LYS A  81      22.258  22.393  -5.577  1.00  0.00           H  
ATOM   1195  HG3 LYS A  81      21.132  22.949  -4.355  1.00  0.00           H  
ATOM   1196  HD2 LYS A  81      19.363  22.590  -6.373  1.00  0.00           H  
ATOM   1197  HD3 LYS A  81      20.582  21.451  -6.907  1.00  0.00           H  
ATOM   1198  HE2 LYS A  81      20.525  20.367  -4.626  1.00  0.00           H  
ATOM   1199  HE3 LYS A  81      19.246  21.469  -4.158  1.00  0.00           H  
ATOM   1200  HZ1 LYS A  81      19.008  19.106  -5.565  1.00  0.00           H  
ATOM   1201  HZ2 LYS A  81      17.817  20.139  -5.136  1.00  0.00           H  
ATOM   1202  HZ3 LYS A  81      18.559  20.302  -6.583  1.00  0.00           H  
ATOM   1203  N   SER A  82      21.502  27.359  -6.260  1.00  0.00           N  
ATOM   1204  CA  SER A  82      21.784  28.591  -6.977  1.00  0.00           C  
ATOM   1205  C   SER A  82      23.014  29.275  -6.378  1.00  0.00           C  
ATOM   1206  O   SER A  82      23.892  29.732  -7.109  1.00  0.00           O  
ATOM   1207  CB  SER A  82      20.581  29.535  -6.943  1.00  0.00           C  
ATOM   1208  OG  SER A  82      20.681  30.562  -7.926  1.00  0.00           O  
ATOM   1209  H   SER A  82      20.541  27.216  -6.026  1.00  0.00           H  
ATOM   1210  HA  SER A  82      21.978  28.288  -8.006  1.00  0.00           H  
ATOM   1211  HB2 SER A  82      19.667  28.965  -7.108  1.00  0.00           H  
ATOM   1212  HB3 SER A  82      20.502  29.987  -5.955  1.00  0.00           H  
ATOM   1213  HG  SER A  82      21.639  30.816  -8.059  1.00  0.00           H  
ATOM   1214  N   PHE A  83      23.037  29.326  -5.054  1.00  0.00           N  
ATOM   1215  CA  PHE A  83      24.146  29.947  -4.349  1.00  0.00           C  
ATOM   1216  C   PHE A  83      25.256  28.933  -4.069  1.00  0.00           C  
ATOM   1217  O   PHE A  83      25.799  28.889  -2.966  1.00  0.00           O  
ATOM   1218  CB  PHE A  83      23.595  30.463  -3.018  1.00  0.00           C  
ATOM   1219  CG  PHE A  83      22.473  31.492  -3.165  1.00  0.00           C  
ATOM   1220  CD1 PHE A  83      22.623  32.546  -4.011  1.00  0.00           C  
ATOM   1221  CD2 PHE A  83      21.323  31.352  -2.451  1.00  0.00           C  
ATOM   1222  CE1 PHE A  83      21.581  33.501  -4.147  1.00  0.00           C  
ATOM   1223  CE2 PHE A  83      20.281  32.307  -2.588  1.00  0.00           C  
ATOM   1224  CZ  PHE A  83      20.432  33.361  -3.433  1.00  0.00           C  
ATOM   1225  H   PHE A  83      22.319  28.953  -4.468  1.00  0.00           H  
ATOM   1226  HA  PHE A  83      24.533  30.740  -4.989  1.00  0.00           H  
ATOM   1227  HB2 PHE A  83      23.226  29.618  -2.437  1.00  0.00           H  
ATOM   1228  HB3 PHE A  83      24.410  30.910  -2.448  1.00  0.00           H  
ATOM   1229  HD1 PHE A  83      23.544  32.659  -4.583  1.00  0.00           H  
ATOM   1230  HD2 PHE A  83      21.203  30.506  -1.774  1.00  0.00           H  
ATOM   1231  HE1 PHE A  83      21.701  34.346  -4.825  1.00  0.00           H  
ATOM   1232  HE2 PHE A  83      19.360  32.194  -2.016  1.00  0.00           H  
ATOM   1233  HZ  PHE A  83      19.632  34.094  -3.538  1.00  0.00           H  
ATOM   1234  N   GLY A  84      25.561  28.143  -5.088  1.00  0.00           N  
ATOM   1235  CA  GLY A  84      26.597  27.131  -4.965  1.00  0.00           C  
ATOM   1236  C   GLY A  84      27.990  27.762  -5.032  1.00  0.00           C  
ATOM   1237  O   GLY A  84      28.283  28.531  -5.946  1.00  0.00           O  
ATOM   1238  H   GLY A  84      25.115  28.184  -5.981  1.00  0.00           H  
ATOM   1239  HA2 GLY A  84      26.480  26.598  -4.022  1.00  0.00           H  
ATOM   1240  HA3 GLY A  84      26.488  26.395  -5.763  1.00  0.00           H  
ATOM   1241  N   GLY A  85      28.811  27.411  -4.054  1.00  0.00           N  
ATOM   1242  CA  GLY A  85      30.165  27.933  -3.990  1.00  0.00           C  
ATOM   1243  C   GLY A  85      30.160  29.441  -3.729  1.00  0.00           C  
ATOM   1244  O   GLY A  85      31.065  30.152  -4.162  1.00  0.00           O  
ATOM   1245  H   GLY A  85      28.565  26.784  -3.315  1.00  0.00           H  
ATOM   1246  HA2 GLY A  85      30.717  27.425  -3.199  1.00  0.00           H  
ATOM   1247  HA3 GLY A  85      30.683  27.724  -4.925  1.00  0.00           H  
ATOM   1248  N   GLU A  86      29.130  29.883  -3.022  1.00  0.00           N  
ATOM   1249  CA  GLU A  86      28.995  31.294  -2.698  1.00  0.00           C  
ATOM   1250  C   GLU A  86      28.600  31.465  -1.230  1.00  0.00           C  
ATOM   1251  O   GLU A  86      27.589  30.921  -0.788  1.00  0.00           O  
ATOM   1252  CB  GLU A  86      27.984  31.973  -3.622  1.00  0.00           C  
ATOM   1253  CG  GLU A  86      28.408  31.846  -5.088  1.00  0.00           C  
ATOM   1254  CD  GLU A  86      28.133  33.141  -5.853  1.00  0.00           C  
ATOM   1255  OE1 GLU A  86      26.935  33.449  -6.036  1.00  0.00           O  
ATOM   1256  OE2 GLU A  86      29.126  33.795  -6.237  1.00  0.00           O  
ATOM   1257  H   GLU A  86      28.399  29.298  -2.674  1.00  0.00           H  
ATOM   1258  HA  GLU A  86      29.981  31.725  -2.869  1.00  0.00           H  
ATOM   1259  HB2 GLU A  86      27.001  31.526  -3.484  1.00  0.00           H  
ATOM   1260  HB3 GLU A  86      27.894  33.027  -3.357  1.00  0.00           H  
ATOM   1261  HG2 GLU A  86      29.469  31.604  -5.143  1.00  0.00           H  
ATOM   1262  HG3 GLU A  86      27.867  31.021  -5.555  1.00  0.00           H  
ATOM   1263  N   GLU A  87      29.416  32.225  -0.515  1.00  0.00           N  
ATOM   1264  CA  GLU A  87      29.163  32.475   0.894  1.00  0.00           C  
ATOM   1265  C   GLU A  87      27.806  33.158   1.077  1.00  0.00           C  
ATOM   1266  O   GLU A  87      27.636  34.317   0.704  1.00  0.00           O  
ATOM   1267  CB  GLU A  87      30.286  33.312   1.511  1.00  0.00           C  
ATOM   1268  CG  GLU A  87      30.765  32.698   2.828  1.00  0.00           C  
ATOM   1269  CD  GLU A  87      32.185  33.162   3.164  1.00  0.00           C  
ATOM   1270  OE1 GLU A  87      33.105  32.749   2.426  1.00  0.00           O  
ATOM   1271  OE2 GLU A  87      32.316  33.918   4.150  1.00  0.00           O  
ATOM   1272  H   GLU A  87      30.236  32.664  -0.882  1.00  0.00           H  
ATOM   1273  HA  GLU A  87      29.150  31.492   1.365  1.00  0.00           H  
ATOM   1274  HB2 GLU A  87      31.120  33.381   0.812  1.00  0.00           H  
ATOM   1275  HB3 GLU A  87      29.932  34.328   1.687  1.00  0.00           H  
ATOM   1276  HG2 GLU A  87      30.087  32.980   3.633  1.00  0.00           H  
ATOM   1277  HG3 GLU A  87      30.742  31.611   2.756  1.00  0.00           H  
ATOM   1278  N   VAL A  88      26.875  32.409   1.649  1.00  0.00           N  
ATOM   1279  CA  VAL A  88      25.539  32.928   1.886  1.00  0.00           C  
ATOM   1280  C   VAL A  88      25.285  33.003   3.393  1.00  0.00           C  
ATOM   1281  O   VAL A  88      26.088  32.513   4.187  1.00  0.00           O  
ATOM   1282  CB  VAL A  88      24.508  32.071   1.148  1.00  0.00           C  
ATOM   1283  CG1 VAL A  88      24.863  31.939  -0.333  1.00  0.00           C  
ATOM   1284  CG2 VAL A  88      24.369  30.695   1.803  1.00  0.00           C  
ATOM   1285  H   VAL A  88      27.023  31.466   1.949  1.00  0.00           H  
ATOM   1286  HA  VAL A  88      25.499  33.935   1.473  1.00  0.00           H  
ATOM   1287  HB  VAL A  88      23.543  32.574   1.218  1.00  0.00           H  
ATOM   1288 HG11 VAL A  88      25.657  32.645  -0.581  1.00  0.00           H  
ATOM   1289 HG12 VAL A  88      25.204  30.924  -0.537  1.00  0.00           H  
ATOM   1290 HG13 VAL A  88      23.983  32.156  -0.939  1.00  0.00           H  
ATOM   1291 HG21 VAL A  88      23.973  30.812   2.812  1.00  0.00           H  
ATOM   1292 HG22 VAL A  88      23.688  30.080   1.215  1.00  0.00           H  
ATOM   1293 HG23 VAL A  88      25.346  30.214   1.850  1.00  0.00           H  
ATOM   1294  N   GLU A  89      24.167  33.621   3.742  1.00  0.00           N  
ATOM   1295  CA  GLU A  89      23.797  33.766   5.140  1.00  0.00           C  
ATOM   1296  C   GLU A  89      22.464  33.068   5.412  1.00  0.00           C  
ATOM   1297  O   GLU A  89      21.405  33.585   5.061  1.00  0.00           O  
ATOM   1298  CB  GLU A  89      23.735  35.242   5.539  1.00  0.00           C  
ATOM   1299  CG  GLU A  89      24.495  35.490   6.844  1.00  0.00           C  
ATOM   1300  CD  GLU A  89      24.531  36.982   7.183  1.00  0.00           C  
ATOM   1301  OE1 GLU A  89      25.064  37.741   6.345  1.00  0.00           O  
ATOM   1302  OE2 GLU A  89      24.025  37.328   8.272  1.00  0.00           O  
ATOM   1303  H   GLU A  89      23.519  34.016   3.091  1.00  0.00           H  
ATOM   1304  HA  GLU A  89      24.593  33.278   5.702  1.00  0.00           H  
ATOM   1305  HB2 GLU A  89      24.160  35.856   4.745  1.00  0.00           H  
ATOM   1306  HB3 GLU A  89      22.696  35.548   5.655  1.00  0.00           H  
ATOM   1307  HG2 GLU A  89      24.018  34.940   7.656  1.00  0.00           H  
ATOM   1308  HG3 GLU A  89      25.512  35.109   6.755  1.00  0.00           H  
ATOM   1309  N   MET A  90      22.558  31.904   6.037  1.00  0.00           N  
ATOM   1310  CA  MET A  90      21.373  31.129   6.362  1.00  0.00           C  
ATOM   1311  C   MET A  90      20.863  31.467   7.763  1.00  0.00           C  
ATOM   1312  O   MET A  90      21.651  31.613   8.696  1.00  0.00           O  
ATOM   1313  CB  MET A  90      21.700  29.636   6.284  1.00  0.00           C  
ATOM   1314  CG  MET A  90      20.444  28.788   6.486  1.00  0.00           C  
ATOM   1315  SD  MET A  90      20.685  27.164   5.785  1.00  0.00           S  
ATOM   1316  CE  MET A  90      22.180  26.681   6.630  1.00  0.00           C  
ATOM   1317  H   MET A  90      23.424  31.490   6.320  1.00  0.00           H  
ATOM   1318  HA  MET A  90      20.627  31.411   5.617  1.00  0.00           H  
ATOM   1319  HB2 MET A  90      22.146  29.408   5.315  1.00  0.00           H  
ATOM   1320  HB3 MET A  90      22.441  29.383   7.043  1.00  0.00           H  
ATOM   1321  HG2 MET A  90      20.218  28.705   7.548  1.00  0.00           H  
ATOM   1322  HG3 MET A  90      19.589  29.273   6.015  1.00  0.00           H  
ATOM   1323  HE1 MET A  90      22.604  25.802   6.144  1.00  0.00           H  
ATOM   1324  HE2 MET A  90      22.899  27.499   6.593  1.00  0.00           H  
ATOM   1325  HE3 MET A  90      21.950  26.445   7.670  1.00  0.00           H  
ATOM   1326  N   LYS A  91      19.547  31.585   7.868  1.00  0.00           N  
ATOM   1327  CA  LYS A  91      18.922  31.903   9.140  1.00  0.00           C  
ATOM   1328  C   LYS A  91      17.972  30.771   9.535  1.00  0.00           C  
ATOM   1329  O   LYS A  91      17.124  30.363   8.742  1.00  0.00           O  
ATOM   1330  CB  LYS A  91      18.250  33.277   9.077  1.00  0.00           C  
ATOM   1331  CG  LYS A  91      19.284  34.399   9.193  1.00  0.00           C  
ATOM   1332  CD  LYS A  91      19.363  35.207   7.896  1.00  0.00           C  
ATOM   1333  CE  LYS A  91      19.836  36.636   8.168  1.00  0.00           C  
ATOM   1334  NZ  LYS A  91      20.110  37.343   6.897  1.00  0.00           N  
ATOM   1335  H   LYS A  91      18.912  31.465   7.103  1.00  0.00           H  
ATOM   1336  HA  LYS A  91      19.714  31.966   9.886  1.00  0.00           H  
ATOM   1337  HB2 LYS A  91      17.703  33.376   8.140  1.00  0.00           H  
ATOM   1338  HB3 LYS A  91      17.521  33.366   9.882  1.00  0.00           H  
ATOM   1339  HG2 LYS A  91      19.020  35.058  10.020  1.00  0.00           H  
ATOM   1340  HG3 LYS A  91      20.262  33.975   9.421  1.00  0.00           H  
ATOM   1341  HD2 LYS A  91      20.047  34.720   7.201  1.00  0.00           H  
ATOM   1342  HD3 LYS A  91      18.384  35.229   7.417  1.00  0.00           H  
ATOM   1343  HE2 LYS A  91      19.077  37.175   8.736  1.00  0.00           H  
ATOM   1344  HE3 LYS A  91      20.738  36.617   8.781  1.00  0.00           H  
ATOM   1345  HZ1 LYS A  91      21.097  37.419   6.763  1.00  0.00           H  
ATOM   1346  HZ2 LYS A  91      19.709  36.831   6.138  1.00  0.00           H  
ATOM   1347  HZ3 LYS A  91      19.706  38.257   6.931  1.00  0.00           H  
ATOM   1348  N   VAL A  92      18.145  30.297  10.759  1.00  0.00           N  
ATOM   1349  CA  VAL A  92      17.313  29.219  11.269  1.00  0.00           C  
ATOM   1350  C   VAL A  92      16.730  29.629  12.623  1.00  0.00           C  
ATOM   1351  O   VAL A  92      17.304  30.458  13.326  1.00  0.00           O  
ATOM   1352  CB  VAL A  92      18.121  27.921  11.334  1.00  0.00           C  
ATOM   1353  CG1 VAL A  92      18.721  27.580   9.968  1.00  0.00           C  
ATOM   1354  CG2 VAL A  92      19.209  28.006  12.406  1.00  0.00           C  
ATOM   1355  H   VAL A  92      18.836  30.635  11.397  1.00  0.00           H  
ATOM   1356  HA  VAL A  92      16.495  29.074  10.563  1.00  0.00           H  
ATOM   1357  HB  VAL A  92      17.439  27.117  11.611  1.00  0.00           H  
ATOM   1358 HG11 VAL A  92      18.743  26.498   9.842  1.00  0.00           H  
ATOM   1359 HG12 VAL A  92      18.110  28.025   9.182  1.00  0.00           H  
ATOM   1360 HG13 VAL A  92      19.735  27.974   9.909  1.00  0.00           H  
ATOM   1361 HG21 VAL A  92      18.949  28.780  13.127  1.00  0.00           H  
ATOM   1362 HG22 VAL A  92      19.291  27.045  12.916  1.00  0.00           H  
ATOM   1363 HG23 VAL A  92      20.162  28.249  11.937  1.00  0.00           H  
ATOM   1364  N   VAL A  93      15.594  29.028  12.947  1.00  0.00           N  
ATOM   1365  CA  VAL A  93      14.925  29.319  14.203  1.00  0.00           C  
ATOM   1366  C   VAL A  93      14.575  28.007  14.906  1.00  0.00           C  
ATOM   1367  O   VAL A  93      14.216  27.026  14.255  1.00  0.00           O  
ATOM   1368  CB  VAL A  93      13.706  30.208  13.953  1.00  0.00           C  
ATOM   1369  CG1 VAL A  93      14.103  31.685  13.906  1.00  0.00           C  
ATOM   1370  CG2 VAL A  93      12.978  29.794  12.673  1.00  0.00           C  
ATOM   1371  H   VAL A  93      15.132  28.355  12.369  1.00  0.00           H  
ATOM   1372  HA  VAL A  93      15.626  29.876  14.827  1.00  0.00           H  
ATOM   1373  HB  VAL A  93      13.017  30.074  14.788  1.00  0.00           H  
ATOM   1374 HG11 VAL A  93      14.303  31.974  12.874  1.00  0.00           H  
ATOM   1375 HG12 VAL A  93      13.290  32.293  14.303  1.00  0.00           H  
ATOM   1376 HG13 VAL A  93      15.000  31.840  14.507  1.00  0.00           H  
ATOM   1377 HG21 VAL A  93      12.060  30.373  12.572  1.00  0.00           H  
ATOM   1378 HG22 VAL A  93      13.622  29.982  11.813  1.00  0.00           H  
ATOM   1379 HG23 VAL A  93      12.736  28.732  12.719  1.00  0.00           H  
ATOM   1380  N   SER A  94      14.690  28.030  16.226  1.00  0.00           N  
ATOM   1381  CA  SER A  94      14.390  26.854  17.025  1.00  0.00           C  
ATOM   1382  C   SER A  94      12.890  26.794  17.326  1.00  0.00           C  
ATOM   1383  O   SER A  94      12.254  27.826  17.528  1.00  0.00           O  
ATOM   1384  CB  SER A  94      15.194  26.851  18.326  1.00  0.00           C  
ATOM   1385  OG  SER A  94      16.550  27.236  18.117  1.00  0.00           O  
ATOM   1386  H   SER A  94      14.982  28.831  16.748  1.00  0.00           H  
ATOM   1387  HA  SER A  94      14.691  26.004  16.411  1.00  0.00           H  
ATOM   1388  HB2 SER A  94      14.729  27.532  19.040  1.00  0.00           H  
ATOM   1389  HB3 SER A  94      15.163  25.855  18.769  1.00  0.00           H  
ATOM   1390  HG  SER A  94      16.666  28.206  18.329  1.00  0.00           H  
ATOM   1391  N   LEU A  95      12.371  25.575  17.347  1.00  0.00           N  
ATOM   1392  CA  LEU A  95      10.960  25.369  17.621  1.00  0.00           C  
ATOM   1393  C   LEU A  95      10.782  24.976  19.088  1.00  0.00           C  
ATOM   1394  O   LEU A  95      11.435  24.052  19.572  1.00  0.00           O  
ATOM   1395  CB  LEU A  95      10.366  24.358  16.637  1.00  0.00           C  
ATOM   1396  CG  LEU A  95       8.961  23.850  16.963  1.00  0.00           C  
ATOM   1397  CD1 LEU A  95       7.930  24.975  16.848  1.00  0.00           C  
ATOM   1398  CD2 LEU A  95       8.596  22.646  16.092  1.00  0.00           C  
ATOM   1399  H   LEU A  95      12.897  24.741  17.182  1.00  0.00           H  
ATOM   1400  HA  LEU A  95      10.452  26.318  17.453  1.00  0.00           H  
ATOM   1401  HB2 LEU A  95      10.345  24.813  15.647  1.00  0.00           H  
ATOM   1402  HB3 LEU A  95      11.037  23.501  16.579  1.00  0.00           H  
ATOM   1403  HG  LEU A  95       8.953  23.511  18.000  1.00  0.00           H  
ATOM   1404 HD11 LEU A  95       8.048  25.478  15.888  1.00  0.00           H  
ATOM   1405 HD12 LEU A  95       6.925  24.557  16.918  1.00  0.00           H  
ATOM   1406 HD13 LEU A  95       8.082  25.692  17.655  1.00  0.00           H  
ATOM   1407 HD21 LEU A  95       9.485  22.293  15.571  1.00  0.00           H  
ATOM   1408 HD22 LEU A  95       8.201  21.849  16.721  1.00  0.00           H  
ATOM   1409 HD23 LEU A  95       7.840  22.942  15.363  1.00  0.00           H  
ATOM   1410  N   LEU A  96       9.894  25.696  19.757  1.00  0.00           N  
ATOM   1411  CA  LEU A  96       9.620  25.434  21.160  1.00  0.00           C  
ATOM   1412  C   LEU A  96       8.188  24.919  21.309  1.00  0.00           C  
ATOM   1413  O   LEU A  96       7.246  25.546  20.827  1.00  0.00           O  
ATOM   1414  CB  LEU A  96       9.920  26.674  22.005  1.00  0.00           C  
ATOM   1415  CG  LEU A  96      11.261  27.360  21.738  1.00  0.00           C  
ATOM   1416  CD1 LEU A  96      12.401  26.340  21.710  1.00  0.00           C  
ATOM   1417  CD2 LEU A  96      11.206  28.193  20.457  1.00  0.00           C  
ATOM   1418  H   LEU A  96       9.366  26.445  19.357  1.00  0.00           H  
ATOM   1419  HA  LEU A  96      10.305  24.651  21.485  1.00  0.00           H  
ATOM   1420  HB2 LEU A  96       9.123  27.401  21.841  1.00  0.00           H  
ATOM   1421  HB3 LEU A  96       9.881  26.392  23.056  1.00  0.00           H  
ATOM   1422  HG  LEU A  96      11.463  28.046  22.561  1.00  0.00           H  
ATOM   1423 HD11 LEU A  96      13.324  26.835  21.404  1.00  0.00           H  
ATOM   1424 HD12 LEU A  96      12.532  25.913  22.706  1.00  0.00           H  
ATOM   1425 HD13 LEU A  96      12.162  25.546  21.003  1.00  0.00           H  
ATOM   1426 HD21 LEU A  96      10.242  28.697  20.392  1.00  0.00           H  
ATOM   1427 HD22 LEU A  96      12.004  28.937  20.473  1.00  0.00           H  
ATOM   1428 HD23 LEU A  96      11.335  27.542  19.594  1.00  0.00           H  
ATOM   1429  N   ASP A  97       8.069  23.782  21.980  1.00  0.00           N  
ATOM   1430  CA  ASP A  97       6.766  23.176  22.198  1.00  0.00           C  
ATOM   1431  C   ASP A  97       6.887  22.093  23.273  1.00  0.00           C  
ATOM   1432  O   ASP A  97       7.951  21.501  23.447  1.00  0.00           O  
ATOM   1433  CB  ASP A  97       6.243  22.518  20.921  1.00  0.00           C  
ATOM   1434  CG  ASP A  97       4.745  22.696  20.668  1.00  0.00           C  
ATOM   1435  OD1 ASP A  97       4.162  23.589  21.319  1.00  0.00           O  
ATOM   1436  OD2 ASP A  97       4.216  21.934  19.830  1.00  0.00           O  
ATOM   1437  H   ASP A  97       8.839  23.280  22.370  1.00  0.00           H  
ATOM   1438  HA  ASP A  97       6.116  23.996  22.505  1.00  0.00           H  
ATOM   1439  HB2 ASP A  97       6.790  22.925  20.070  1.00  0.00           H  
ATOM   1440  HB3 ASP A  97       6.465  21.452  20.962  1.00  0.00           H  
ATOM   1441  N   SER A  98       5.781  21.867  23.967  1.00  0.00           N  
ATOM   1442  CA  SER A  98       5.749  20.866  25.019  1.00  0.00           C  
ATOM   1443  C   SER A  98       6.346  19.552  24.510  1.00  0.00           C  
ATOM   1444  O   SER A  98       6.519  19.371  23.305  1.00  0.00           O  
ATOM   1445  CB  SER A  98       4.322  20.640  25.522  1.00  0.00           C  
ATOM   1446  OG  SER A  98       3.615  21.866  25.690  1.00  0.00           O  
ATOM   1447  H   SER A  98       4.920  22.353  23.820  1.00  0.00           H  
ATOM   1448  HA  SER A  98       6.358  21.274  25.825  1.00  0.00           H  
ATOM   1449  HB2 SER A  98       3.784  20.006  24.817  1.00  0.00           H  
ATOM   1450  HB3 SER A  98       4.353  20.107  26.473  1.00  0.00           H  
ATOM   1451  HG  SER A  98       2.754  21.703  26.171  1.00  0.00           H  
ATOM   1452  N   THR A  99       6.642  18.670  25.452  1.00  0.00           N  
ATOM   1453  CA  THR A  99       7.216  17.378  25.113  1.00  0.00           C  
ATOM   1454  C   THR A  99       6.910  16.355  26.210  1.00  0.00           C  
ATOM   1455  O   THR A  99       6.655  16.724  27.354  1.00  0.00           O  
ATOM   1456  CB  THR A  99       8.713  17.575  24.866  1.00  0.00           C  
ATOM   1457  OG1 THR A  99       9.166  16.293  24.437  1.00  0.00           O  
ATOM   1458  CG2 THR A  99       9.491  17.832  26.157  1.00  0.00           C  
ATOM   1459  H   THR A  99       6.498  18.825  26.429  1.00  0.00           H  
ATOM   1460  HA  THR A  99       6.740  17.019  24.200  1.00  0.00           H  
ATOM   1461  HB  THR A  99       8.886  18.371  24.142  1.00  0.00           H  
ATOM   1462  HG1 THR A  99      10.112  16.354  24.119  1.00  0.00           H  
ATOM   1463 HG21 THR A  99       9.258  17.054  26.884  1.00  0.00           H  
ATOM   1464 HG22 THR A  99      10.560  17.823  25.946  1.00  0.00           H  
ATOM   1465 HG23 THR A  99       9.209  18.804  26.564  1.00  0.00           H  
ATOM   1466  N   SER A 100       6.948  15.089  25.820  1.00  0.00           N  
ATOM   1467  CA  SER A 100       6.678  14.010  26.756  1.00  0.00           C  
ATOM   1468  C   SER A 100       5.227  14.085  27.236  1.00  0.00           C  
ATOM   1469  O   SER A 100       4.667  15.172  27.365  1.00  0.00           O  
ATOM   1470  CB  SER A 100       7.636  14.063  27.948  1.00  0.00           C  
ATOM   1471  OG  SER A 100       8.686  13.106  27.832  1.00  0.00           O  
ATOM   1472  H   SER A 100       7.156  14.796  24.887  1.00  0.00           H  
ATOM   1473  HA  SER A 100       6.849  13.092  26.194  1.00  0.00           H  
ATOM   1474  HB2 SER A 100       8.063  15.063  28.025  1.00  0.00           H  
ATOM   1475  HB3 SER A 100       7.079  13.882  28.868  1.00  0.00           H  
ATOM   1476  HG  SER A 100       9.556  13.522  28.092  1.00  0.00           H  
ATOM   1477  N   SER A 101       4.661  12.913  27.487  1.00  0.00           N  
ATOM   1478  CA  SER A 101       3.285  12.832  27.951  1.00  0.00           C  
ATOM   1479  C   SER A 101       2.958  11.396  28.366  1.00  0.00           C  
ATOM   1480  O   SER A 101       3.541  10.447  27.844  1.00  0.00           O  
ATOM   1481  CB  SER A 101       2.311  13.309  26.872  1.00  0.00           C  
ATOM   1482  OG  SER A 101       2.310  12.449  25.736  1.00  0.00           O  
ATOM   1483  H   SER A 101       5.123  12.033  27.380  1.00  0.00           H  
ATOM   1484  HA  SER A 101       3.231  13.500  28.810  1.00  0.00           H  
ATOM   1485  HB2 SER A 101       1.305  13.360  27.289  1.00  0.00           H  
ATOM   1486  HB3 SER A 101       2.580  14.319  26.562  1.00  0.00           H  
ATOM   1487  HG  SER A 101       2.760  12.899  24.965  1.00  0.00           H  
ATOM   1488  N   MET A 102       2.025  11.282  29.299  1.00  0.00           N  
ATOM   1489  CA  MET A 102       1.611   9.978  29.790  1.00  0.00           C  
ATOM   1490  C   MET A 102       0.768   9.242  28.747  1.00  0.00           C  
ATOM   1491  O   MET A 102       0.014   9.865  28.001  1.00  0.00           O  
ATOM   1492  CB  MET A 102       0.800  10.150  31.075  1.00  0.00           C  
ATOM   1493  CG  MET A 102       1.615   9.729  32.300  1.00  0.00           C  
ATOM   1494  SD  MET A 102       0.527   9.413  33.678  1.00  0.00           S  
ATOM   1495  CE  MET A 102       1.143   7.820  34.200  1.00  0.00           C  
ATOM   1496  H   MET A 102       1.555  12.060  29.718  1.00  0.00           H  
ATOM   1497  HA  MET A 102       2.535   9.429  29.974  1.00  0.00           H  
ATOM   1498  HB2 MET A 102       0.492  11.190  31.179  1.00  0.00           H  
ATOM   1499  HB3 MET A 102      -0.111   9.553  31.016  1.00  0.00           H  
ATOM   1500  HG2 MET A 102       2.195   8.836  32.071  1.00  0.00           H  
ATOM   1501  HG3 MET A 102       2.326  10.513  32.559  1.00  0.00           H  
ATOM   1502  HE1 MET A 102       0.612   7.502  35.096  1.00  0.00           H  
ATOM   1503  HE2 MET A 102       0.985   7.091  33.405  1.00  0.00           H  
ATOM   1504  HE3 MET A 102       2.208   7.897  34.417  1.00  0.00           H  
ATOM   1505  N   HIS A 103       0.923   7.927  28.728  1.00  0.00           N  
ATOM   1506  CA  HIS A 103       0.186   7.099  27.790  1.00  0.00           C  
ATOM   1507  C   HIS A 103      -0.164   5.763  28.448  1.00  0.00           C  
ATOM   1508  O   HIS A 103       0.288   5.475  29.555  1.00  0.00           O  
ATOM   1509  CB  HIS A 103       0.966   6.930  26.485  1.00  0.00           C  
ATOM   1510  CG  HIS A 103       0.094   6.717  25.271  1.00  0.00           C  
ATOM   1511  ND1 HIS A 103      -0.329   7.755  24.460  1.00  0.00           N  
ATOM   1512  CD2 HIS A 103      -0.430   5.574  24.739  1.00  0.00           C  
ATOM   1513  CE1 HIS A 103      -1.073   7.249  23.487  1.00  0.00           C  
ATOM   1514  NE2 HIS A 103      -1.135   5.898  23.662  1.00  0.00           N  
ATOM   1515  H   HIS A 103       1.539   7.428  29.339  1.00  0.00           H  
ATOM   1516  HA  HIS A 103      -0.736   7.633  27.559  1.00  0.00           H  
ATOM   1517  HB2 HIS A 103       1.583   7.814  26.324  1.00  0.00           H  
ATOM   1518  HB3 HIS A 103       1.644   6.082  26.586  1.00  0.00           H  
ATOM   1519  HD1 HIS A 103      -0.110   8.722  24.585  1.00  0.00           H  
ATOM   1520  HD2 HIS A 103      -0.292   4.567  25.132  1.00  0.00           H  
ATOM   1521  HE1 HIS A 103      -1.552   7.814  22.687  1.00  0.00           H  
ATOM   1522  N   ASN A 104      -0.966   4.983  27.740  1.00  0.00           N  
ATOM   1523  CA  ASN A 104      -1.382   3.684  28.241  1.00  0.00           C  
ATOM   1524  C   ASN A 104      -0.259   2.671  28.016  1.00  0.00           C  
ATOM   1525  O   ASN A 104       0.612   2.883  27.173  1.00  0.00           O  
ATOM   1526  CB  ASN A 104      -2.626   3.182  27.506  1.00  0.00           C  
ATOM   1527  CG  ASN A 104      -3.763   4.203  27.590  1.00  0.00           C  
ATOM   1528  OD1 ASN A 104      -3.663   5.229  28.242  1.00  0.00           O  
ATOM   1529  ND2 ASN A 104      -4.846   3.865  26.896  1.00  0.00           N  
ATOM   1530  H   ASN A 104      -1.330   5.224  26.840  1.00  0.00           H  
ATOM   1531  HA  ASN A 104      -1.597   3.840  29.298  1.00  0.00           H  
ATOM   1532  HB2 ASN A 104      -2.383   2.989  26.461  1.00  0.00           H  
ATOM   1533  HB3 ASN A 104      -2.951   2.235  27.936  1.00  0.00           H  
ATOM   1534 HD21 ASN A 104      -4.863   3.008  26.380  1.00  0.00           H  
ATOM   1535 HD22 ASN A 104      -5.644   4.468  26.888  1.00  0.00           H  
ATOM   1536  N   LYS A 105      -0.314   1.592  28.783  1.00  0.00           N  
ATOM   1537  CA  LYS A 105       0.688   0.546  28.677  1.00  0.00           C  
ATOM   1538  C   LYS A 105       0.044  -0.715  28.097  1.00  0.00           C  
ATOM   1539  O   LYS A 105      -1.170  -0.764  27.907  1.00  0.00           O  
ATOM   1540  CB  LYS A 105       1.373   0.321  30.026  1.00  0.00           C  
ATOM   1541  CG  LYS A 105       0.418  -0.337  31.023  1.00  0.00           C  
ATOM   1542  CD  LYS A 105       1.077  -1.538  31.705  1.00  0.00           C  
ATOM   1543  CE  LYS A 105       0.262  -2.813  31.479  1.00  0.00           C  
ATOM   1544  NZ  LYS A 105      -0.515  -3.153  32.692  1.00  0.00           N  
ATOM   1545  H   LYS A 105      -1.026   1.428  29.466  1.00  0.00           H  
ATOM   1546  HA  LYS A 105       1.453   0.895  27.982  1.00  0.00           H  
ATOM   1547  HB2 LYS A 105       2.254  -0.307  29.892  1.00  0.00           H  
ATOM   1548  HB3 LYS A 105       1.721   1.275  30.426  1.00  0.00           H  
ATOM   1549  HG2 LYS A 105       0.113   0.391  31.776  1.00  0.00           H  
ATOM   1550  HG3 LYS A 105      -0.487  -0.658  30.507  1.00  0.00           H  
ATOM   1551  HD2 LYS A 105       2.086  -1.673  31.315  1.00  0.00           H  
ATOM   1552  HD3 LYS A 105       1.172  -1.347  32.774  1.00  0.00           H  
ATOM   1553  HE2 LYS A 105      -0.413  -2.675  30.634  1.00  0.00           H  
ATOM   1554  HE3 LYS A 105       0.928  -3.637  31.224  1.00  0.00           H  
ATOM   1555  HZ1 LYS A 105      -1.054  -2.359  32.976  1.00  0.00           H  
ATOM   1556  HZ2 LYS A 105      -1.128  -3.917  32.491  1.00  0.00           H  
ATOM   1557  HZ3 LYS A 105       0.112  -3.412  33.427  1.00  0.00           H  
ATOM   1558  N   SER A 106       0.887  -1.703  27.832  1.00  0.00           N  
ATOM   1559  CA  SER A 106       0.414  -2.960  27.278  1.00  0.00           C  
ATOM   1560  C   SER A 106       0.888  -4.126  28.148  1.00  0.00           C  
ATOM   1561  O   SER A 106       1.828  -3.982  28.928  1.00  0.00           O  
ATOM   1562  CB  SER A 106       0.897  -3.143  25.838  1.00  0.00           C  
ATOM   1563  OG  SER A 106       2.280  -3.481  25.777  1.00  0.00           O  
ATOM   1564  H   SER A 106       1.872  -1.654  27.991  1.00  0.00           H  
ATOM   1565  HA  SER A 106      -0.673  -2.890  27.290  1.00  0.00           H  
ATOM   1566  HB2 SER A 106       0.310  -3.925  25.356  1.00  0.00           H  
ATOM   1567  HB3 SER A 106       0.724  -2.224  25.278  1.00  0.00           H  
ATOM   1568  HG  SER A 106       2.418  -4.240  25.139  1.00  0.00           H  
ATOM   1569  N   GLY A 107       0.215  -5.256  27.985  1.00  0.00           N  
ATOM   1570  CA  GLY A 107       0.555  -6.447  28.745  1.00  0.00           C  
ATOM   1571  C   GLY A 107       1.256  -7.479  27.862  1.00  0.00           C  
ATOM   1572  O   GLY A 107       0.982  -7.568  26.666  1.00  0.00           O  
ATOM   1573  H   GLY A 107      -0.548  -5.365  27.347  1.00  0.00           H  
ATOM   1574  HA2 GLY A 107       1.203  -6.177  29.579  1.00  0.00           H  
ATOM   1575  HA3 GLY A 107      -0.349  -6.881  29.172  1.00  0.00           H  
ATOM   1576  N   PRO A 108       2.171  -8.257  28.501  1.00  0.00           N  
ATOM   1577  CA  PRO A 108       2.914  -9.281  27.787  1.00  0.00           C  
ATOM   1578  C   PRO A 108       2.031 -10.497  27.499  1.00  0.00           C  
ATOM   1579  O   PRO A 108       0.841 -10.491  27.806  1.00  0.00           O  
ATOM   1580  CB  PRO A 108       4.099  -9.605  28.683  1.00  0.00           C  
ATOM   1581  CG  PRO A 108       3.728  -9.094  30.065  1.00  0.00           C  
ATOM   1582  CD  PRO A 108       2.522  -8.181  29.917  1.00  0.00           C  
ATOM   1583  HA  PRO A 108       3.206  -8.939  26.895  1.00  0.00           H  
ATOM   1584  HB2 PRO A 108       4.292 -10.678  28.701  1.00  0.00           H  
ATOM   1585  HB3 PRO A 108       5.006  -9.124  28.320  1.00  0.00           H  
ATOM   1586  HG2 PRO A 108       3.496  -9.926  30.731  1.00  0.00           H  
ATOM   1587  HG3 PRO A 108       4.564  -8.553  30.510  1.00  0.00           H  
ATOM   1588  HD2 PRO A 108       1.695  -8.510  30.548  1.00  0.00           H  
ATOM   1589  HD3 PRO A 108       2.760  -7.159  30.211  1.00  0.00           H  
ATOM   1590  N   SER A 109       2.651 -11.511  26.913  1.00  0.00           N  
ATOM   1591  CA  SER A 109       1.936 -12.732  26.579  1.00  0.00           C  
ATOM   1592  C   SER A 109       2.592 -13.928  27.272  1.00  0.00           C  
ATOM   1593  O   SER A 109       3.721 -13.829  27.754  1.00  0.00           O  
ATOM   1594  CB  SER A 109       1.898 -12.952  25.065  1.00  0.00           C  
ATOM   1595  OG  SER A 109       3.138 -13.448  24.567  1.00  0.00           O  
ATOM   1596  H   SER A 109       3.619 -11.508  26.666  1.00  0.00           H  
ATOM   1597  HA  SER A 109       0.923 -12.584  26.949  1.00  0.00           H  
ATOM   1598  HB2 SER A 109       1.102 -13.656  24.821  1.00  0.00           H  
ATOM   1599  HB3 SER A 109       1.656 -12.013  24.568  1.00  0.00           H  
ATOM   1600  HG  SER A 109       3.102 -14.444  24.487  1.00  0.00           H  
ATOM   1601  N   SER A 110       1.857 -15.030  27.304  1.00  0.00           N  
ATOM   1602  CA  SER A 110       2.352 -16.243  27.932  1.00  0.00           C  
ATOM   1603  C   SER A 110       2.881 -17.205  26.865  1.00  0.00           C  
ATOM   1604  O   SER A 110       2.627 -17.019  25.676  1.00  0.00           O  
ATOM   1605  CB  SER A 110       1.260 -16.919  28.762  1.00  0.00           C  
ATOM   1606  OG  SER A 110       0.300 -17.582  27.944  1.00  0.00           O  
ATOM   1607  H   SER A 110       0.939 -15.101  26.911  1.00  0.00           H  
ATOM   1608  HA  SER A 110       3.160 -15.919  28.588  1.00  0.00           H  
ATOM   1609  HB2 SER A 110       1.716 -17.638  29.443  1.00  0.00           H  
ATOM   1610  HB3 SER A 110       0.758 -16.172  29.378  1.00  0.00           H  
ATOM   1611  HG  SER A 110       0.372 -17.257  27.001  1.00  0.00           H  
ATOM   1612  N   GLY A 111       3.606 -18.212  27.330  1.00  0.00           N  
ATOM   1613  CA  GLY A 111       4.171 -19.203  26.431  1.00  0.00           C  
ATOM   1614  C   GLY A 111       4.466 -20.510  27.170  1.00  0.00           C  
ATOM   1615  O   GLY A 111       4.248 -21.595  26.633  1.00  0.00           O  
ATOM   1616  H   GLY A 111       3.808 -18.356  28.299  1.00  0.00           H  
ATOM   1617  HA2 GLY A 111       3.479 -19.394  25.611  1.00  0.00           H  
ATOM   1618  HA3 GLY A 111       5.090 -18.817  25.989  1.00  0.00           H  
TER    1619      GLY A 111                                                      
END
MOLECULE T0392.pdb
HEADER    PDZ DOMAIN                              29-APR-08   4TST
ATOM    745  N   MET     1       9.079  20.462  53.470  1.00 34.33           N  
ATOM    746  CA  MET     1       8.577  20.614  52.070  1.00 35.57           C  
ATOM    747  C   MET     1       9.596  21.354  51.183  1.00 35.56           C  
ATOM    748  O   MET     1      10.494  20.737  50.591  1.00 34.08           O  
ATOM    749  CB  MET     1       7.230  21.359  52.067  1.00 32.48           C  
ATOM    750  N   HIS     2       9.458  22.677  51.126  1.00 34.53           N  
ATOM    751  CA  HIS     2      10.280  23.527  50.277  1.00 29.99           C  
ATOM    752  C   HIS     2      11.693  23.706  50.854  1.00 30.62           C  
ATOM    753  O   HIS     2      11.858  23.960  52.051  1.00 34.33           O  
ATOM    754  CB  HIS     2       9.605  24.889  50.123  1.00 31.08           C  
ATOM    755  CG  HIS     2      10.472  25.932  49.494  1.00 29.51           C  
ATOM    756  ND1 HIS     2      10.594  26.071  48.129  1.00 22.27           N  
ATOM    757  CD2 HIS     2      11.243  26.902  50.042  1.00 36.02           C  
ATOM    758  CE1 HIS     2      11.411  27.075  47.863  1.00 32.73           C  
ATOM    759  NE2 HIS     2      11.816  27.598  49.007  1.00 30.65           N  
ATOM    760  N   HIS     3      12.701  23.567  49.995  1.00 23.38           N  
ATOM    761  CA  HIS     3      14.089  23.885  50.353  1.00 21.72           C  
ATOM    762  C   HIS     3      14.569  25.043  49.493  1.00 24.24           C  
ATOM    763  O   HIS     3      14.156  25.189  48.336  1.00 25.13           O  
ATOM    764  CB  HIS     3      14.995  22.698  50.092  1.00 19.21           C  
ATOM    765  CG  HIS     3      14.777  21.556  51.020  1.00 18.72           C  
ATOM    766  ND1 HIS     3      13.675  20.735  50.943  1.00 24.78           N  
ATOM    767  CD2 HIS     3      15.542  21.073  52.031  1.00 24.61           C  
ATOM    768  CE1 HIS     3      13.762  19.800  51.876  1.00 33.23           C  
ATOM    769  NE2 HIS     3      14.888  19.980  52.547  1.00 22.18           N  
ATOM    770  N   HIS     4      15.433  25.873  50.062  1.00 26.56           N  
ATOM    771  CA  HIS     4      16.114  26.884  49.279  1.00 27.15           C  
ATOM    772  C   HIS     4      17.299  26.213  48.616  1.00 29.84           C  
ATOM    773  O   HIS     4      18.042  25.462  49.267  1.00 22.33           O  
ATOM    774  CB  HIS     4      16.599  28.033  50.148  1.00 26.90           C  
ATOM    775  CG  HIS     4      17.309  29.104  49.381  1.00 31.76           C  
ATOM    776  ND1 HIS     4      16.669  29.913  48.468  1.00 25.97           N  
ATOM    777  CD2 HIS     4      18.605  29.500  49.393  1.00 33.01           C  
ATOM    778  CE1 HIS     4      17.537  30.763  47.951  1.00 33.29           C  
ATOM    779  NE2 HIS     4      18.720  30.534  48.496  1.00 27.03           N  
ATOM    780  N   HIS     5      17.451  26.478  47.318  1.00 27.66           N  
ATOM    781  CA  HIS     5      18.589  26.008  46.550  1.00 27.31           C  
ATOM    782  C   HIS     5      19.398  27.205  46.108  1.00 24.55           C  
ATOM    783  O   HIS     5      18.963  28.011  45.273  1.00 22.13           O  
ATOM    784  CB  HIS     5      18.118  25.190  45.355  1.00 26.88           C  
ATOM    785  CG  HIS     5      17.503  23.886  45.744  1.00 33.29           C  
ATOM    786  ND1 HIS     5      18.237  22.855  46.293  1.00 34.21           N  
ATOM    787  CD2 HIS     5      16.221  23.452  45.690  1.00 29.10           C  
ATOM    788  CE1 HIS     5      17.435  21.835  46.543  1.00 41.61           C  
ATOM    789  NE2 HIS     5      16.207  22.172  46.185  1.00 16.47           N  
ATOM    790  N   HIS     6      20.585  27.313  46.678  1.00 24.33           N  
ATOM    791  CA  HIS     6      21.467  28.425  46.387  1.00 25.49           C  
ATOM    792  C   HIS     6      22.214  28.242  45.059  1.00 23.99           C  
ATOM    793  O   HIS     6      23.219  27.520  44.976  1.00 20.58           O  
ATOM    794  CB  HIS     6      22.462  28.590  47.518  1.00 24.34           C  
ATOM    795  CG  HIS     6      23.326  29.793  47.375  1.00 22.72           C  
ATOM    796  ND1 HIS     6      22.859  31.070  47.592  1.00 14.01           N  
ATOM    797  CD2 HIS     6      24.636  29.914  47.063  1.00 11.95           C  
ATOM    798  CE1 HIS     6      23.843  31.929  47.412  1.00 16.75           C  
ATOM    799  NE2 HIS     6      24.937  31.253  47.110  1.00 15.24           N  
ATOM    800  N   HIS     7      21.698  28.908  44.033  1.00 22.65           N  
ATOM    801  CA  HIS     7      22.364  29.031  42.747  1.00 19.66           C  
ATOM    802  C   HIS     7      21.655  30.091  41.913  1.00 21.41           C  
ATOM    803  O   HIS     7      20.580  30.565  42.297  1.00 18.86           O  
ATOM    804  CB  HIS     7      22.390  27.693  42.011  1.00 21.80           C  
ATOM    805  CG  HIS     7      21.057  27.026  41.924  1.00 13.40           C  
ATOM    806  ND1 HIS     7      19.973  27.608  41.303  1.00 23.25           N  
ATOM    807  CD2 HIS     7      20.630  25.828  42.388  1.00 13.64           C  
ATOM    808  CE1 HIS     7      18.940  26.787  41.370  1.00 20.59           C  
ATOM    809  NE2 HIS     7      19.310  25.701  42.024  1.00 17.53           N  
ATOM    810  N   SER     8      22.240  30.443  40.768  1.00 19.43           N  
ATOM    811  CA  SER     8      21.630  31.422  39.846  1.00 23.18           C  
ATOM    812  C   SER     8      20.214  31.001  39.430  1.00 18.68           C  
ATOM    813  O   SER     8      19.850  29.820  39.486  1.00 14.96           O  
ATOM    814  CB  SER     8      22.483  31.598  38.591  1.00 18.80           C  
ATOM    815  OG  SER     8      22.403  30.442  37.775  1.00 27.99           O  
ATOM    816  N   SER     9      19.428  31.965  38.979  1.00 20.08           N  
ATOM    817  CA  SER     9      18.029  31.689  38.737  1.00 15.94           C  
ATOM    818  C   SER     9      17.882  30.744  37.539  1.00 15.40           C  
ATOM    819  O   SER     9      18.299  31.057  36.425  1.00 13.50           O  
ATOM    820  CB  SER     9      17.250  32.980  38.512  1.00 19.11           C  
ATOM    821  OG  SER     9      16.034  32.721  37.834  1.00 12.84           O  
ATOM    822  N   GLY    10      17.293  29.580  37.791  1.00 10.67           N  
ATOM    823  CA  GLY    10      17.009  28.607  36.737  1.00 11.07           C  
ATOM    824  C   GLY    10      16.016  29.184  35.742  1.00 11.98           C  
ATOM    825  O   GLY    10      16.065  28.859  34.561  1.00 11.37           O  
ATOM    826  N   VAL    11      15.133  30.069  36.206  1.00 11.35           N  
ATOM    827  CA  VAL    11      14.160  30.676  35.307  1.00 10.68           C  
ATOM    828  C   VAL    11      14.892  31.670  34.389  1.00 10.50           C  
ATOM    829  O   VAL    11      14.673  31.697  33.177  1.00 10.37           O  
ATOM    830  CB  VAL    11      12.962  31.308  36.070  1.00  8.81           C  
ATOM    831  CG1 VAL    11      12.148  32.147  35.169  1.00  3.01           C  
ATOM    832  CG2 VAL    11      12.114  30.208  36.672  1.00 13.51           C  
ATOM    833  N   ASP    12      15.800  32.450  34.954  1.00 10.57           N  
ATOM    834  CA  ASP    12      16.609  33.349  34.127  1.00 13.37           C  
ATOM    835  C   ASP    12      17.336  32.553  33.030  1.00 12.93           C  
ATOM    836  O   ASP    12      17.203  32.858  31.839  1.00 11.49           O  
ATOM    837  CB  ASP    12      17.626  34.129  34.961  1.00 15.93           C  
ATOM    838  CG  ASP    12      16.999  35.224  35.775  1.00 16.66           C  
ATOM    839  OD1 ASP    12      15.800  35.528  35.600  1.00 20.54           O  
ATOM    840  OD2 ASP    12      17.734  35.766  36.621  1.00 21.55           O  
ATOM    841  N   LEU    13      18.047  31.509  33.429  1.00 10.88           N  
ATOM    842  CA  LEU    13      18.865  30.754  32.497  1.00 10.37           C  
ATOM    843  C   LEU    13      18.005  30.076  31.440  1.00  9.19           C  
ATOM    844  O   LEU    13      18.286  30.187  30.242  1.00 10.82           O  
ATOM    845  CB  LEU    13      19.742  29.716  33.224  1.00 11.65           C  
ATOM    846  CG  LEU    13      20.840  30.305  34.092  1.00 19.41           C  
ATOM    847  CD1 LEU    13      21.777  29.213  34.641  1.00 22.36           C  
ATOM    848  CD2 LEU    13      21.598  31.355  33.293  1.00 28.04           C  
ATOM    849  N   GLY    14      16.964  29.378  31.897  1.00  9.75           N  
ATOM    850  CA  GLY    14      16.087  28.634  31.023  1.00 11.34           C  
ATOM    851  C   GLY    14      15.386  29.511  30.015  1.00  8.90           C  
ATOM    852  O   GLY    14      15.172  29.109  28.857  1.00 11.69           O  
ATOM    853  N   THR    15      14.997  30.718  30.423  1.00  7.18           N  
ATOM    854  CA  THR    15      14.284  31.570  29.485  1.00  7.37           C  
ATOM    855  C   THR    15      15.242  32.190  28.505  1.00 10.83           C  
ATOM    856  O   THR    15      14.858  32.481  27.366  1.00 14.40           O  
ATOM    857  CB  THR    15      13.395  32.646  30.173  1.00 13.52           C  
ATOM    858  OG1 THR    15      14.177  33.425  31.091  1.00  8.29           O  
ATOM    859  CG2 THR    15      12.265  31.974  30.886  1.00 11.02           C  
ATOM    860  N   GLU    16      16.492  32.384  28.936  1.00 11.70           N  
ATOM    861  CA  GLU    16      17.537  32.847  28.062  1.00 16.86           C  
ATOM    862  C   GLU    16      17.828  31.786  27.005  1.00 14.73           C  
ATOM    863  O   GLU    16      17.990  32.104  25.822  1.00 15.13           O  
ATOM    864  CB  GLU    16      18.808  33.128  28.856  1.00 16.45           C  
ATOM    865  CG  GLU    16      19.879  33.816  28.031  1.00 28.20           C  
ATOM    866  CD  GLU    16      21.130  34.120  28.819  1.00 40.94           C  
ATOM    867  OE1 GLU    16      21.513  33.314  29.702  1.00 40.42           O  
ATOM    868  OE2 GLU    16      21.742  35.168  28.535  1.00 46.61           O  
ATOM    869  N   ASN    17      17.892  30.531  27.442  1.00 13.33           N  
ATOM    870  CA  ASN    17      18.158  29.415  26.540  1.00 13.30           C  
ATOM    871  C   ASN    17      17.079  29.396  25.460  1.00 15.69           C  
ATOM    872  O   ASN    17      17.347  29.240  24.276  1.00 13.96           O  
ATOM    873  CB  ASN    17      18.202  28.091  27.325  1.00 15.13           C  
ATOM    874  CG  ASN    17      19.482  27.923  28.192  1.00 30.01           C  
ATOM    875  OD1 ASN    17      20.466  28.648  28.038  1.00 38.34           O  
ATOM    876  ND2 ASN    17      19.457  26.932  29.096  1.00 31.22           N  
ATOM    877  N   LEU    18      15.852  29.641  25.878  1.00 15.02           N  
ATOM    878  CA  LEU    18      14.710  29.575  24.989  1.00 11.30           C  
ATOM    879  C   LEU    18      14.792  30.664  23.920  1.00 14.65           C  
ATOM    880  O   LEU    18      14.497  30.440  22.722  1.00 17.59           O  
ATOM    881  CB  LEU    18      13.424  29.677  25.825  1.00 17.86           C  
ATOM    882  CG  LEU    18      12.154  28.977  25.377  1.00 18.64           C  
ATOM    883  CD1 LEU    18      12.385  27.501  25.078  1.00  8.48           C  
ATOM    884  CD2 LEU    18      11.043  29.167  26.443  1.00 17.70           C  
ATOM    885  N   TYR    19      15.170  31.861  24.348  1.00 12.70           N  
ATOM    886  CA  TYR    19      15.424  32.949  23.430  1.00 19.67           C  
ATOM    887  C   TYR    19      16.463  32.543  22.378  1.00 19.77           C  
ATOM    888  O   TYR    19      16.191  32.657  21.177  1.00 18.59           O  
ATOM    889  CB  TYR    19      15.887  34.172  24.217  1.00 22.23           C  
ATOM    890  CG  TYR    19      15.926  35.462  23.448  1.00 18.91           C  
ATOM    891  CD1 TYR    19      14.744  36.155  23.149  1.00 24.05           C  
ATOM    892  CD2 TYR    19      17.133  36.013  23.047  1.00 30.31           C  
ATOM    893  CE1 TYR    19      14.774  37.353  22.462  1.00 24.75           C  
ATOM    894  CE2 TYR    19      17.177  37.218  22.354  1.00 31.52           C  
ATOM    895  CZ  TYR    19      15.993  37.884  22.064  1.00 38.61           C  
ATOM    896  OH  TYR    19      16.030  39.081  21.379  1.00 48.38           O  
ATOM    897  N   PHE    20      17.624  32.053  22.832  1.00 18.49           N  
ATOM    898  CA  PHE    20      18.701  31.577  21.942  1.00 19.62           C  
ATOM    899  C   PHE    20      18.186  30.584  20.894  1.00 20.56           C  
ATOM    900  O   PHE    20      18.478  30.725  19.699  1.00 20.23           O  
ATOM    901  CB  PHE    20      19.829  30.915  22.738  1.00 16.81           C  
ATOM    902  CG  PHE    20      20.979  31.831  23.045  1.00 22.80           C  
ATOM    903  CD1 PHE    20      22.163  31.791  22.324  1.00 24.02           C  
ATOM    904  CD2 PHE    20      20.873  32.740  24.095  1.00 23.64           C  
ATOM    905  CE1 PHE    20      23.212  32.657  22.625  1.00 28.35           C  
ATOM    906  CE2 PHE    20      21.923  33.603  24.418  1.00 25.52           C  
ATOM    907  CZ  PHE    20      23.090  33.562  23.686  1.00 30.99           C  
ATOM    908  N   GLN    21      17.415  29.598  21.339  1.00 18.64           N  
ATOM    909  CA  GLN    21      16.928  28.535  20.452  1.00 16.25           C  
ATOM    910  C   GLN    21      15.797  28.998  19.537  1.00 15.58           C  
ATOM    911  O   GLN    21      15.550  28.378  18.495  1.00 15.82           O  
ATOM    912  CB  GLN    21      16.455  27.328  21.261  1.00 18.32           C  
ATOM    913  CG  GLN    21      17.490  26.733  22.203  1.00 23.69           C  
ATOM    914  CD  GLN    21      18.745  26.253  21.487  1.00 37.75           C  
ATOM    915  OE1 GLN    21      19.416  27.016  20.789  1.00 37.91           O  
ATOM    916  NE2 GLN    21      19.075  24.978  21.673  1.00 48.62           N  
ATOM    917  N   SER    22      15.130  30.086  19.912  1.00 12.05           N  
ATOM    918  CA  SER    22      13.933  30.547  19.213  1.00 15.38           C  
ATOM    919  C   SER    22      14.190  31.712  18.253  1.00 17.78           C  
ATOM    920  O   SER    22      13.450  31.900  17.287  1.00 21.34           O  
ATOM    921  CB  SER    22      12.851  30.940  20.233  1.00 17.68           C  
ATOM    922  OG  SER    22      12.485  29.813  21.006  1.00 19.13           O  
ATOM    923  N   MET    23      15.227  32.497  18.508  1.00 18.63           N  
ATOM    924  CA  MET    23      15.528  33.634  17.637  1.00 21.79           C  
ATOM    925  C   MET    23      16.360  33.192  16.425  1.00 21.41           C  
ATOM    926  O   MET    23      17.366  32.481  16.588  1.00 16.83           O  
ATOM    927  CB  MET    23      16.282  34.727  18.398  1.00 22.95           C  
ATOM    928  CG  MET    23      15.434  35.450  19.434  1.00 29.01           C  
ATOM    929  SD  MET    23      13.999  36.323  18.747  1.00 43.59           S  
ATOM    930  CE  MET    23      14.814  37.671  17.886  1.00 31.30           C  
ATOM    931  N   PRO    24      15.954  33.636  15.211  1.00 20.95           N  
ATOM    932  CA  PRO    24      16.714  33.314  14.001  1.00 18.53           C  
ATOM    933  C   PRO    24      18.205  33.660  14.141  1.00 17.96           C  
ATOM    934  O   PRO    24      18.561  34.773  14.546  1.00 16.34           O  
ATOM    935  CB  PRO    24      16.047  34.169  12.928  1.00 20.14           C  
ATOM    936  CG  PRO    24      14.638  34.335  13.411  1.00 26.18           C  
ATOM    937  CD  PRO    24      14.740  34.424  14.904  1.00 21.09           C  
ATOM    938  N   ARG    25      19.058  32.692  13.844  1.00  9.85           N  
ATOM    939  CA  ARG    25      20.496  32.928  13.799  1.00 13.96           C  
ATOM    940  C   ARG    25      21.121  32.634  12.437  1.00 11.86           C  
ATOM    941  O   ARG    25      20.776  31.665  11.774  1.00  8.29           O  
ATOM    942  CB  ARG    25      21.218  32.116  14.874  1.00 12.27           C  
ATOM    943  CG  ARG    25      21.197  30.628  14.659  1.00 10.91           C  
ATOM    944  CD  ARG    25      21.732  29.899  15.875  1.00 12.81           C  
ATOM    945  NE  ARG    25      22.008  28.489  15.599  1.00 13.49           N  
ATOM    946  CZ  ARG    25      21.096  27.520  15.584  1.00 11.66           C  
ATOM    947  NH1 ARG    25      19.811  27.772  15.814  1.00 14.13           N  
ATOM    948  NH2 ARG    25      21.473  26.280  15.303  1.00 12.33           N  
ATOM    949  N   SER    26      22.116  33.454  12.111  1.00 16.03           N  
ATOM    950  CA  SER    26      22.789  33.487  10.822  1.00 13.37           C  
ATOM    951  C   SER    26      23.884  32.458  10.734  1.00 10.12           C  
ATOM    952  O   SER    26      24.766  32.391  11.605  1.00 13.31           O  
ATOM    953  CB  SER    26      23.385  34.895  10.611  1.00 19.17           C  
ATOM    954  OG  SER    26      23.956  35.029   9.316  1.00 17.01           O  
ATOM    955  N   ILE    27      23.793  31.622   9.706  1.00  7.55           N  
ATOM    956  CA  ILE    27      24.729  30.565   9.410  1.00 14.30           C  
ATOM    957  C   ILE    27      25.355  30.914   8.054  1.00 16.83           C  
ATOM    958  O   ILE    27      24.664  30.958   7.043  1.00 15.50           O  
ATOM    959  CB  ILE    27      24.000  29.195   9.287  1.00 14.07           C  
ATOM    960  CG1 ILE    27      23.149  28.894  10.531  1.00 21.93           C  
ATOM    961  CG2 ILE    27      24.994  28.041   9.060  1.00 18.68           C  
ATOM    962  CD1 ILE    27      23.937  28.914  11.826  1.00 14.40           C  
ATOM    963  N   ARG    28      26.655  31.186   8.032  1.00 12.82           N  
ATOM    964  CA  ARG    28      27.354  31.444   6.770  1.00 12.96           C  
ATOM    965  C   ARG    28      28.243  30.257   6.451  1.00 16.33           C  
ATOM    966  O   ARG    28      29.078  29.846   7.271  1.00 11.48           O  
ATOM    967  CB  ARG    28      28.167  32.738   6.835  1.00 15.11           C  
ATOM    968  CG  ARG    28      27.324  34.012   6.749  1.00 25.29           C  
ATOM    969  CD  ARG    28      28.211  35.264   6.646  1.00 20.85           C  
ATOM    970  N   PHE    29      28.063  29.704   5.264  1.00 13.29           N  
ATOM    971  CA  PHE    29      28.704  28.457   4.897  1.00 17.83           C  
ATOM    972  C   PHE    29      28.780  28.272   3.384  1.00 16.70           C  
ATOM    973  O   PHE    29      28.224  29.049   2.606  1.00 16.21           O  
ATOM    974  CB  PHE    29      27.958  27.274   5.532  1.00 16.59           C  
ATOM    975  CG  PHE    29      26.588  27.039   4.961  1.00 14.92           C  
ATOM    976  CD1 PHE    29      26.366  26.019   4.058  1.00 13.39           C  
ATOM    977  CD2 PHE    29      25.527  27.834   5.324  1.00 13.76           C  
ATOM    978  CE1 PHE    29      25.120  25.789   3.556  1.00 10.75           C  
ATOM    979  CE2 PHE    29      24.268  27.611   4.809  1.00 15.55           C  
ATOM    980  CZ  PHE    29      24.066  26.581   3.927  1.00 14.71           C  
ATOM    981  N   THR    30      29.490  27.222   2.989  1.00 19.32           N  
ATOM    982  CA  THR    30      29.712  26.915   1.599  1.00 19.83           C  
ATOM    983  C   THR    30      29.469  25.439   1.390  1.00 21.16           C  
ATOM    984  O   THR    30      29.665  24.645   2.304  1.00 21.37           O  
ATOM    985  CB  THR    30      31.147  27.249   1.194  1.00 20.91           C  
ATOM    986  OG1 THR    30      32.063  26.533   2.046  1.00 29.16           O  
ATOM    987  CG2 THR    30      31.376  28.761   1.302  1.00 15.15           C  
ATOM    988  N   ALA    31      28.948  25.101   0.217  1.00 25.50           N  
ATOM    989  CA  ALA    31      28.856  23.715  -0.217  1.00 28.81           C  
ATOM    990  C   ALA    31      30.065  23.426  -1.104  1.00 30.05           C  
ATOM    991  O   ALA    31      29.987  23.573  -2.320  1.00 34.51           O  
ATOM    992  CB  ALA    31      27.583  23.481  -0.979  1.00 26.19           C  
ATOM    993  N   GLU    32      31.177  23.048  -0.480  1.00 30.95           N  
ATOM    994  CA  GLU    32      32.403  22.651  -1.191  1.00 32.63           C  
ATOM    995  C   GLU    32      32.109  21.565  -2.231  1.00 31.96           C  
ATOM    996  O   GLU    32      31.609  20.488  -1.884  1.00 35.67           O  
ATOM    997  CB  GLU    32      33.452  22.139  -0.197  1.00 25.57           C  
ATOM    998  N   GLU    33      32.399  21.869  -3.498  1.00 26.63           N  
ATOM    999  CA  GLU    33      32.093  20.986  -4.639  1.00 27.92           C  
ATOM   1000  C   GLU    33      30.601  20.790  -4.880  1.00 26.97           C  
ATOM   1001  O   GLU    33      30.202  19.782  -5.461  1.00 24.93           O  
ATOM   1002  CB  GLU    33      32.784  19.622  -4.483  1.00 29.67           C  
ATOM   1003  N   GLY    34      29.785  21.750  -4.446  1.00 25.19           N  
ATOM   1004  CA  GLY    34      28.325  21.657  -4.560  1.00 25.45           C  
ATOM   1005  C   GLY    34      27.664  20.704  -3.558  1.00 21.41           C  
ATOM   1006  O   GLY    34      26.424  20.545  -3.558  1.00 18.45           O  
ATOM   1007  N   ASP    35      28.497  20.069  -2.730  1.00 11.29           N  
ATOM   1008  CA  ASP    35      28.082  19.160  -1.651  1.00 13.16           C  
ATOM   1009  C   ASP    35      27.657  20.010  -0.417  1.00 12.23           C  
ATOM   1010  O   ASP    35      28.491  20.651   0.216  1.00 14.67           O  
ATOM   1011  CB  ASP    35      29.254  18.266  -1.279  1.00 11.46           C  
ATOM   1012  CG  ASP    35      28.875  17.137  -0.347  1.00 18.99           C  
ATOM   1013  OD1 ASP    35      27.675  16.966  -0.041  1.00 18.46           O  
ATOM   1014  OD2 ASP    35      29.796  16.416   0.102  1.00 38.04           O  
ATOM   1015  N   LEU    36      26.351  20.032  -0.131  1.00  9.93           N  
ATOM   1016  CA  LEU    36      25.781  20.893   0.913  1.00  9.20           C  
ATOM   1017  C   LEU    36      26.088  20.318   2.300  1.00  9.06           C  
ATOM   1018  O   LEU    36      26.262  21.062   3.245  1.00 14.82           O  
ATOM   1019  CB  LEU    36      24.266  21.007   0.699  1.00 13.68           C  
ATOM   1020  CG  LEU    36      23.433  22.042   1.474  1.00 20.91           C  
ATOM   1021  CD1 LEU    36      23.549  23.451   0.890  1.00 15.95           C  
ATOM   1022  CD2 LEU    36      21.962  21.615   1.477  1.00 12.71           C  
ATOM   1023  N   GLY    37      26.176  18.993   2.404  1.00 10.72           N  
ATOM   1024  CA  GLY    37      26.492  18.330   3.662  1.00 15.66           C  
ATOM   1025  C   GLY    37      25.316  18.041   4.569  1.00 14.96           C  
ATOM   1026  O   GLY    37      25.495  17.495   5.670  1.00 12.72           O  
ATOM   1027  N   PHE    38      24.109  18.394   4.141  1.00  7.47           N  
ATOM   1028  CA  PHE    38      22.927  18.038   4.927  1.00  6.82           C  
ATOM   1029  C   PHE    38      21.777  17.691   4.041  1.00  6.45           C  
ATOM   1030  O   PHE    38      21.735  18.147   2.914  1.00  7.70           O  
ATOM   1031  CB  PHE    38      22.515  19.128   5.948  1.00  7.03           C  
ATOM   1032  CG  PHE    38      22.417  20.519   5.398  1.00  6.90           C  
ATOM   1033  CD1 PHE    38      21.195  21.029   4.975  1.00 12.12           C  
ATOM   1034  CD2 PHE    38      23.535  21.334   5.340  1.00 10.75           C  
ATOM   1035  CE1 PHE    38      21.082  22.325   4.503  1.00 14.75           C  
ATOM   1036  CE2 PHE    38      23.440  22.650   4.849  1.00  9.47           C  
ATOM   1037  CZ  PHE    38      22.225  23.143   4.440  1.00 18.04           C  
ATOM   1038  N   THR    39      20.860  16.879   4.552  1.00  6.08           N  
ATOM   1039  CA  THR    39      19.568  16.703   3.901  1.00  5.92           C  
ATOM   1040  C   THR    39      18.509  17.566   4.551  1.00  9.00           C  
ATOM   1041  O   THR    39      18.714  18.179   5.600  1.00  4.70           O  
ATOM   1042  CB  THR    39      19.093  15.251   3.856  1.00  4.43           C  
ATOM   1043  OG1 THR    39      18.847  14.777   5.181  1.00  9.73           O  
ATOM   1044  CG2 THR    39      20.154  14.360   3.119  1.00  6.34           C  
ATOM   1045  N   LEU    40      17.371  17.649   3.884  1.00  5.35           N  
ATOM   1046  CA  LEU    40      16.285  18.524   4.267  1.00  6.00           C  
ATOM   1047  C   LEU    40      15.020  17.684   4.354  1.00  3.78           C  
ATOM   1048  O   LEU    40      14.932  16.635   3.726  1.00  4.02           O  
ATOM   1049  CB  LEU    40      16.069  19.589   3.184  1.00  5.27           C  
ATOM   1050  CG  LEU    40      17.204  20.576   2.949  1.00 10.43           C  
ATOM   1051  CD1 LEU    40      16.918  21.443   1.721  1.00 16.56           C  
ATOM   1052  CD2 LEU    40      17.399  21.424   4.186  1.00 14.10           C  
ATOM   1053  N   ARG    41      14.049  18.167   5.106  1.00  7.16           N  
ATOM   1054  CA  ARG    41      12.821  17.412   5.386  1.00 10.55           C  
ATOM   1055  C   ARG    41      11.674  18.365   5.658  1.00 10.30           C  
ATOM   1056  O   ARG    41      11.878  19.430   6.215  1.00  8.12           O  
ATOM   1057  CB  ARG    41      13.062  16.519   6.609  1.00 13.33           C  
ATOM   1058  CG  ARG    41      11.918  15.649   7.006  1.00 21.89           C  
ATOM   1059  CD  ARG    41      12.320  14.703   8.139  1.00 22.96           C  
ATOM   1060  NE  ARG    41      12.378  15.355   9.462  1.00 30.14           N  
ATOM   1061  CZ  ARG    41      12.123  14.743  10.624  1.00 35.50           C  
ATOM   1062  NH1 ARG    41      11.793  13.456  10.657  1.00 35.36           N  
ATOM   1063  NH2 ARG    41      12.190  15.418  11.765  1.00 34.72           N  
ATOM   1064  N   GLY    42      10.468  17.985   5.245  1.00 11.47           N  
ATOM   1065  CA  GLY    42       9.286  18.770   5.544  1.00 10.62           C  
ATOM   1066  C   GLY    42       9.166  20.034   4.716  1.00 12.87           C  
ATOM   1067  O   GLY    42      10.034  20.329   3.885  1.00 11.31           O  
ATOM   1068  N   ASN    43       8.096  20.783   4.985  1.00 14.51           N  
ATOM   1069  CA  ASN    43       7.722  21.961   4.219  1.00 13.65           C  
ATOM   1070  C   ASN    43       7.329  23.090   5.160  1.00 12.98           C  
ATOM   1071  O   ASN    43       6.694  22.872   6.179  1.00 11.47           O  
ATOM   1072  CB  ASN    43       6.532  21.657   3.294  1.00 16.19           C  
ATOM   1073  CG  ASN    43       6.825  20.543   2.300  1.00 23.13           C  
ATOM   1074  OD1 ASN    43       7.577  20.718   1.339  1.00 17.38           O  
ATOM   1075  ND2 ASN    43       6.230  19.382   2.536  1.00 28.04           N  
ATOM   1076  N   ALA    44       7.716  24.304   4.819  1.00 12.65           N  
ATOM   1077  CA  ALA    44       7.097  25.489   5.377  1.00 12.34           C  
ATOM   1078  C   ALA    44       7.012  25.525   6.898  1.00 13.37           C  
ATOM   1079  O   ALA    44       5.917  25.524   7.463  1.00 13.70           O  
ATOM   1080  CB  ALA    44       5.697  25.684   4.769  1.00  9.52           C  
ATOM   1081  N   PRO    45       8.160  25.603   7.571  1.00 12.61           N  
ATOM   1082  CA  PRO    45       9.486  25.671   7.020  1.00  8.62           C  
ATOM   1083  C   PRO    45      10.077  24.294   6.814  1.00 10.25           C  
ATOM   1084  O   PRO    45       9.606  23.297   7.398  1.00 10.08           O  
ATOM   1085  CB  PRO    45      10.274  26.431   8.096  1.00 11.79           C  
ATOM   1086  CG  PRO    45       9.598  26.073   9.359  1.00 24.83           C  
ATOM   1087  CD  PRO    45       8.167  25.717   9.035  1.00 16.29           C  
ATOM   1088  N   VAL    46      11.132  24.264   6.014  1.00  6.98           N  
ATOM   1089  CA  VAL    46      11.940  23.071   5.804  1.00  8.35           C  
ATOM   1090  C   VAL    46      12.948  22.944   6.946  1.00 10.05           C  
ATOM   1091  O   VAL    46      13.479  23.927   7.466  1.00 11.09           O  
ATOM   1092  CB  VAL    46      12.720  23.132   4.456  1.00 11.28           C  
ATOM   1093  CG1 VAL    46      13.484  21.848   4.246  1.00  7.74           C  
ATOM   1094  CG2 VAL    46      11.764  23.366   3.297  1.00  8.59           C  
ATOM   1095  N   GLN    47      13.231  21.703   7.299  1.00  5.55           N  
ATOM   1096  CA  GLN    47      14.109  21.356   8.397  1.00  9.72           C  
ATOM   1097  C   GLN    47      15.391  20.692   7.898  1.00 10.41           C  
ATOM   1098  O   GLN    47      15.360  19.900   6.955  1.00  7.62           O  
ATOM   1099  CB  GLN    47      13.320  20.389   9.292  1.00 14.34           C  
ATOM   1100  CG  GLN    47      13.824  20.250  10.684  1.00 24.10           C  
ATOM   1101  CD  GLN    47      12.841  19.500  11.570  1.00 31.19           C  
ATOM   1102  OE1 GLN    47      12.215  18.520  11.152  1.00 26.02           O  
ATOM   1103  NE2 GLN    47      12.705  19.958  12.795  1.00 25.24           N  
ATOM   1104  N   VAL    48      16.521  21.040   8.503  1.00  5.55           N  
ATOM   1105  CA  VAL    48      17.766  20.281   8.396  1.00  6.39           C  
ATOM   1106  C   VAL    48      17.573  18.889   9.036  1.00 14.07           C  
ATOM   1107  O   VAL    48      17.083  18.777  10.154  1.00 13.05           O  
ATOM   1108  CB  VAL    48      18.893  21.008   9.170  1.00 10.11           C  
ATOM   1109  CG1 VAL    48      20.206  20.181   9.221  1.00  7.95           C  
ATOM   1110  CG2 VAL    48      19.139  22.396   8.585  1.00  7.33           C  
ATOM   1111  N   HIS    49      17.908  17.822   8.315  1.00 11.73           N  
ATOM   1112  CA  HIS    49      17.731  16.497   8.854  1.00  5.88           C  
ATOM   1113  C   HIS    49      19.108  15.880   9.070  1.00  6.08           C  
ATOM   1114  O   HIS    49      19.764  16.199  10.060  1.00 11.87           O  
ATOM   1115  CB  HIS    49      16.806  15.681   7.971  1.00 10.15           C  
ATOM   1116  CG  HIS    49      16.329  14.422   8.612  1.00 12.45           C  
ATOM   1117  ND1 HIS    49      15.499  14.420   9.709  1.00 13.31           N  
ATOM   1118  CD2 HIS    49      16.570  13.119   8.317  1.00 16.40           C  
ATOM   1119  CE1 HIS    49      15.237  13.166  10.053  1.00 15.13           C  
ATOM   1120  NE2 HIS    49      15.877  12.361   9.223  1.00 15.86           N  
ATOM   1121  N   PHE    50      19.593  15.049   8.157  1.00  7.83           N  
ATOM   1122  CA  PHE    50      20.986  14.573   8.253  1.00  5.66           C  
ATOM   1123  C   PHE    50      21.978  15.726   8.138  1.00  4.88           C  
ATOM   1124  O   PHE    50      21.830  16.587   7.276  1.00  6.24           O  
ATOM   1125  CB  PHE    50      21.304  13.507   7.179  1.00  7.08           C  
ATOM   1126  CG  PHE    50      22.769  13.346   6.932  1.00  7.50           C  
ATOM   1127  CD1 PHE    50      23.528  12.494   7.742  1.00 12.67           C  
ATOM   1128  CD2 PHE    50      23.416  14.119   5.978  1.00  7.73           C  
ATOM   1129  CE1 PHE    50      24.910  12.380   7.559  1.00  7.16           C  
ATOM   1130  CE2 PHE    50      24.800  14.022   5.787  1.00 11.10           C  
ATOM   1131  CZ  PHE    50      25.544  13.141   6.585  1.00  9.77           C  
ATOM   1132  N   LEU    51      23.032  15.725   8.957  1.00  5.25           N  
ATOM   1133  CA  LEU    51      23.993  16.769   8.897  1.00  4.97           C  
ATOM   1134  C   LEU    51      25.381  16.194   9.141  1.00  7.53           C  
ATOM   1135  O   LEU    51      25.650  15.584  10.157  1.00  8.27           O  
ATOM   1136  CB  LEU    51      23.661  17.853   9.925  1.00  6.92           C  
ATOM   1137  CG  LEU    51      24.654  19.010  10.118  1.00 13.13           C  
ATOM   1138  CD1 LEU    51      24.624  19.967   8.940  1.00  9.28           C  
ATOM   1139  CD2 LEU    51      24.378  19.821  11.412  1.00 12.19           C  
ATOM   1140  N   ASP    52      26.235  16.360   8.154  1.00  8.86           N  
ATOM   1141  CA  ASP    52      27.616  15.886   8.244  1.00  6.39           C  
ATOM   1142  C   ASP    52      28.324  16.798   9.210  1.00 10.25           C  
ATOM   1143  O   ASP    52      28.351  18.004   8.997  1.00  8.25           O  
ATOM   1144  CB  ASP    52      28.228  15.944   6.869  1.00  6.88           C  
ATOM   1145  CG  ASP    52      29.662  15.427   6.810  1.00 13.74           C  
ATOM   1146  OD1 ASP    52      30.408  15.407   7.826  1.00 10.45           O  
ATOM   1147  OD2 ASP    52      30.042  15.020   5.691  1.00 18.22           O  
ATOM   1148  N   PRO    53      28.877  16.237  10.301  1.00  9.82           N  
ATOM   1149  CA  PRO    53      29.513  17.110  11.295  1.00  8.66           C  
ATOM   1150  C   PRO    53      30.785  17.791  10.781  1.00 13.43           C  
ATOM   1151  O   PRO    53      31.227  18.786  11.354  1.00 14.38           O  
ATOM   1152  CB  PRO    53      29.850  16.154  12.442  1.00  9.73           C  
ATOM   1153  CG  PRO    53      29.882  14.807  11.831  1.00 14.94           C  
ATOM   1154  CD  PRO    53      28.776  14.859  10.799  1.00 11.26           C  
ATOM   1155  N   TYR    54      31.358  17.280   9.695  1.00 10.82           N  
ATOM   1156  CA  TYR    54      32.523  17.922   9.090  1.00 12.03           C  
ATOM   1157  C   TYR    54      32.190  19.055   8.116  1.00 12.45           C  
ATOM   1158  O   TYR    54      33.080  19.804   7.748  1.00 15.72           O  
ATOM   1159  CB  TYR    54      33.386  16.877   8.383  1.00 14.56           C  
ATOM   1160  CG  TYR    54      33.904  15.807   9.298  1.00 11.96           C  
ATOM   1161  CD1 TYR    54      34.984  16.044  10.140  1.00 23.56           C  
ATOM   1162  CD2 TYR    54      33.319  14.547   9.322  1.00 19.04           C  
ATOM   1163  CE1 TYR    54      35.463  15.050  10.988  1.00 22.44           C  
ATOM   1164  CE2 TYR    54      33.800  13.550  10.148  1.00 16.23           C  
ATOM   1165  CZ  TYR    54      34.871  13.803  10.977  1.00 18.15           C  
ATOM   1166  OH  TYR    54      35.325  12.807  11.808  1.00 25.56           O  
ATOM   1167  N   CYS    55      30.929  19.190   7.686  1.00 13.35           N  
ATOM   1168  CA  CYS    55      30.603  20.240   6.738  1.00  9.84           C  
ATOM   1169  C   CYS    55      30.621  21.629   7.361  1.00 11.88           C  
ATOM   1170  O   CYS    55      30.593  21.773   8.603  1.00 11.81           O  
ATOM   1171  CB  CYS    55      29.271  19.984   6.030  1.00 11.68           C  
ATOM   1172  SG  CYS    55      27.820  20.416   6.949  1.00 13.53           S  
ATOM   1173  N   SER    56      30.736  22.643   6.496  1.00  9.53           N  
ATOM   1174  CA  SER    56      30.835  24.044   6.931  1.00 10.16           C  
ATOM   1175  C   SER    56      29.555  24.505   7.617  1.00 12.08           C  
ATOM   1176  O   SER    56      29.610  25.272   8.550  1.00 14.87           O  
ATOM   1177  CB  SER    56      31.213  24.993   5.764  1.00 10.71           C  
ATOM   1178  OG  SER    56      30.250  24.928   4.704  1.00 17.49           O  
ATOM   1179  N   ALA    57      28.396  24.026   7.169  1.00 14.88           N  
ATOM   1180  CA  ALA    57      27.144  24.350   7.849  1.00 13.21           C  
ATOM   1181  C   ALA    57      27.178  23.866   9.309  1.00 11.00           C  
ATOM   1182  O   ALA    57      26.742  24.566  10.235  1.00  8.90           O  
ATOM   1183  CB  ALA    57      25.946  23.754   7.109  1.00 15.12           C  
ATOM   1184  N   SER    58      27.709  22.675   9.537  1.00  7.83           N  
ATOM   1185  CA  SER    58      27.808  22.184  10.898  1.00  8.45           C  
ATOM   1186  C   SER    58      28.790  23.033  11.688  1.00 10.01           C  
ATOM   1187  O   SER    58      28.490  23.468  12.794  1.00 10.27           O  
ATOM   1188  CB  SER    58      28.255  20.731  10.921  1.00 11.31           C  
ATOM   1189  OG  SER    58      28.237  20.237  12.229  1.00 11.18           O  
ATOM   1190  N   VAL    59      29.972  23.260  11.123  1.00 10.48           N  
ATOM   1191  CA  VAL    59      30.970  24.058  11.800  1.00 12.37           C  
ATOM   1192  C   VAL    59      30.406  25.456  12.153  1.00 14.90           C  
ATOM   1193  O   VAL    59      30.707  26.024  13.202  1.00 12.20           O  
ATOM   1194  CB  VAL    59      32.276  24.153  10.970  1.00 14.35           C  
ATOM   1195  CG1 VAL    59      33.149  25.249  11.508  1.00 15.48           C  
ATOM   1196  CG2 VAL    59      33.010  22.808  10.968  1.00 17.02           C  
ATOM   1197  N   ALA    60      29.531  25.974  11.309  1.00 17.12           N  
ATOM   1198  CA  ALA    60      28.894  27.267  11.554  1.00 16.74           C  
ATOM   1199  C   ALA    60      27.777  27.203  12.623  1.00 14.22           C  
ATOM   1200  O   ALA    60      27.283  28.238  13.089  1.00 18.76           O  
ATOM   1201  CB  ALA    60      28.342  27.850  10.208  1.00 11.86           C  
ATOM   1202  N   GLY    61      27.379  25.990  13.008  1.00 11.50           N  
ATOM   1203  CA  GLY    61      26.493  25.794  14.136  1.00  9.65           C  
ATOM   1204  C   GLY    61      25.084  25.351  13.801  1.00 11.47           C  
ATOM   1205  O   GLY    61      24.253  25.279  14.693  1.00 10.97           O  
ATOM   1206  N   ALA    62      24.825  25.058  12.527  1.00 12.08           N  
ATOM   1207  CA  ALA    62      23.600  24.413  12.121  1.00 12.19           C  
ATOM   1208  C   ALA    62      23.527  23.102  12.898  1.00 12.72           C  
ATOM   1209  O   ALA    62      24.576  22.520  13.243  1.00 12.82           O  
ATOM   1210  CB  ALA    62      23.604  24.161  10.606  1.00 14.07           C  
ATOM   1211  N   ARG    63      22.306  22.688  13.231  1.00 12.62           N  
ATOM   1212  CA  ARG    63      22.054  21.400  13.863  1.00 11.94           C  
ATOM   1213  C   ARG    63      20.878  20.647  13.258  1.00 10.34           C  
ATOM   1214  O   ARG    63      19.957  21.226  12.688  1.00 12.18           O  
ATOM   1215  CB  ARG    63      21.819  21.587  15.354  1.00 14.18           C  
ATOM   1216  CG  ARG    63      23.029  22.133  16.084  1.00 19.20           C  
ATOM   1217  N   GLU    64      20.910  19.333  13.426  1.00 10.41           N  
ATOM   1218  CA  GLU    64      19.789  18.495  13.041  1.00 10.61           C  
ATOM   1219  C   GLU    64      18.464  18.999  13.659  1.00 11.34           C  
ATOM   1220  O   GLU    64      18.392  19.378  14.821  1.00 10.20           O  
ATOM   1221  CB  GLU    64      20.035  17.033  13.440  1.00 12.71           C  
ATOM   1222  CG  GLU    64      21.323  16.435  12.891  1.00 11.18           C  
ATOM   1223  CD  GLU    64      22.535  16.615  13.782  1.00 28.41           C  
ATOM   1224  OE1 GLU    64      22.580  17.587  14.583  1.00 25.92           O  
ATOM   1225  OE2 GLU    64      23.461  15.784  13.652  1.00 21.72           O  
ATOM   1226  N   GLY    65      17.417  19.035  12.856  1.00  7.95           N  
ATOM   1227  CA  GLY    65      16.147  19.546  13.327  1.00  9.85           C  
ATOM   1228  C   GLY    65      15.962  21.050  13.198  1.00 10.26           C  
ATOM   1229  O   GLY    65      14.836  21.498  13.298  1.00  8.62           O  
ATOM   1230  N   ASP    66      17.031  21.830  12.972  1.00 10.17           N  
ATOM   1231  CA  ASP    66      16.876  23.297  12.739  1.00  6.46           C  
ATOM   1232  C   ASP    66      15.940  23.612  11.574  1.00  6.65           C  
ATOM   1233  O   ASP    66      15.916  22.900  10.545  1.00 10.28           O  
ATOM   1234  CB  ASP    66      18.215  23.977  12.506  1.00  6.44           C  
ATOM   1235  CG  ASP    66      19.043  24.046  13.765  1.00 13.87           C  
ATOM   1236  OD1 ASP    66      18.519  23.680  14.839  1.00 17.52           O  
ATOM   1237  OD2 ASP    66      20.218  24.436  13.673  1.00 15.20           O  
ATOM   1238  N   TYR    67      15.140  24.658  11.737  1.00  4.07           N  
ATOM   1239  CA  TYR    67      14.246  25.094  10.687  1.00  4.44           C  
ATOM   1240  C   TYR    67      14.881  26.264   9.942  1.00  3.99           C  
ATOM   1241  O   TYR    67      15.395  27.174  10.574  1.00  9.12           O  
ATOM   1242  CB  TYR    67      12.905  25.556  11.269  1.00  9.32           C  
ATOM   1243  CG  TYR    67      12.209  24.492  12.083  1.00  9.87           C  
ATOM   1244  CD1 TYR    67      11.369  23.574  11.473  1.00 21.06           C  
ATOM   1245  CD2 TYR    67      12.452  24.362  13.459  1.00 12.87           C  
ATOM   1246  CE1 TYR    67      10.747  22.584  12.203  1.00 27.88           C  
ATOM   1247  CE2 TYR    67      11.833  23.372  14.194  1.00 20.15           C  
ATOM   1248  CZ  TYR    67      10.979  22.492  13.560  1.00 24.19           C  
ATOM   1249  OH  TYR    67      10.362  21.508  14.283  1.00 38.52           O  
ATOM   1250  N   ILE    68      14.826  26.228   8.618  1.00  7.50           N  
ATOM   1251  CA  ILE    68      15.417  27.292   7.771  1.00  4.08           C  
ATOM   1252  C   ILE    68      14.364  28.343   7.576  1.00  6.46           C  
ATOM   1253  O   ILE    68      13.285  28.062   7.024  1.00 10.78           O  
ATOM   1254  CB  ILE    68      15.936  26.744   6.409  1.00  9.56           C  
ATOM   1255  CG1 ILE    68      16.956  25.608   6.644  1.00  6.05           C  
ATOM   1256  CG2 ILE    68      16.591  27.930   5.586  1.00  5.99           C  
ATOM   1257  CD1 ILE    68      17.112  24.647   5.526  1.00  9.72           C  
ATOM   1258  N   VAL    69      14.631  29.560   8.024  1.00  5.87           N  
ATOM   1259  CA  VAL    69      13.563  30.576   7.950  1.00  8.37           C  
ATOM   1260  C   VAL    69      13.845  31.607   6.867  1.00  4.96           C  
ATOM   1261  O   VAL    69      12.910  32.223   6.334  1.00  7.18           O  
ATOM   1262  CB  VAL    69      13.320  31.222   9.314  1.00  7.67           C  
ATOM   1263  CG1 VAL    69      12.587  30.220  10.214  1.00  5.72           C  
ATOM   1264  CG2 VAL    69      14.658  31.660   9.924  1.00 10.95           C  
ATOM   1265  N   SER    70      15.127  31.757   6.524  1.00  4.87           N  
ATOM   1266  CA  SER    70      15.554  32.629   5.425  1.00  6.09           C  
ATOM   1267  C   SER    70      16.908  32.233   4.837  1.00 11.98           C  
ATOM   1268  O   SER    70      17.728  31.580   5.498  1.00  7.43           O  
ATOM   1269  CB  SER    70      15.555  34.094   5.878  1.00 10.50           C  
ATOM   1270  OG  SER    70      16.458  34.298   6.924  1.00  7.24           O  
ATOM   1271  N   ILE    71      17.076  32.576   3.555  1.00  8.93           N  
ATOM   1272  CA  ILE    71      18.332  32.451   2.824  1.00  5.13           C  
ATOM   1273  C   ILE    71      18.617  33.848   2.308  1.00  8.23           C  
ATOM   1274  O   ILE    71      17.819  34.415   1.563  1.00  6.65           O  
ATOM   1275  CB  ILE    71      18.210  31.389   1.657  1.00  5.72           C  
ATOM   1276  CG1 ILE    71      17.973  29.983   2.232  1.00  6.80           C  
ATOM   1277  CG2 ILE    71      19.484  31.398   0.761  1.00  2.66           C  
ATOM   1278  CD1 ILE    71      17.510  28.983   1.186  1.00  2.00           C  
ATOM   1279  N   GLN    72      19.699  34.450   2.783  1.00  6.11           N  
ATOM   1280  CA  GLN    72      19.882  35.890   2.632  1.00 11.15           C  
ATOM   1281  C   GLN    72      18.564  36.609   2.970  1.00 10.12           C  
ATOM   1282  O   GLN    72      18.033  36.394   4.041  1.00  9.59           O  
ATOM   1283  CB  GLN    72      20.396  36.248   1.244  1.00  8.35           C  
ATOM   1284  CG  GLN    72      21.809  35.679   0.901  1.00  6.65           C  
ATOM   1285  CD  GLN    72      22.293  36.040  -0.502  1.00 12.88           C  
ATOM   1286  OE1 GLN    72      21.534  36.600  -1.312  1.00  7.90           O  
ATOM   1287  NE2 GLN    72      23.576  35.731  -0.794  1.00  2.06           N  
ATOM   1288  N   LEU    73      18.062  37.469   2.090  1.00  9.31           N  
ATOM   1289  CA  LEU    73      16.866  38.216   2.405  1.00 12.23           C  
ATOM   1290  C   LEU    73      15.656  37.617   1.719  1.00 14.29           C  
ATOM   1291  O   LEU    73      14.653  38.303   1.603  1.00 10.61           O  
ATOM   1292  CB  LEU    73      17.038  39.713   2.069  1.00 14.11           C  
ATOM   1293  CG  LEU    73      18.183  40.466   2.793  1.00 15.70           C  
ATOM   1294  CD1 LEU    73      18.206  41.952   2.421  1.00 16.52           C  
ATOM   1295  CD2 LEU    73      18.105  40.336   4.317  1.00 20.45           C  
ATOM   1296  N   VAL    74      15.745  36.339   1.313  1.00 10.15           N  
ATOM   1297  CA  VAL    74      14.602  35.591   0.768  1.00 12.81           C  
ATOM   1298  C   VAL    74      13.971  34.821   1.911  1.00 12.23           C  
ATOM   1299  O   VAL    74      14.656  34.076   2.640  1.00  8.77           O  
ATOM   1300  CB  VAL    74      15.000  34.590  -0.375  1.00 13.63           C  
ATOM   1301  CG1 VAL    74      13.783  33.730  -0.799  1.00 13.08           C  
ATOM   1302  CG2 VAL    74      15.565  35.353  -1.596  1.00 13.88           C  
ATOM   1303  N   ASP    75      12.668  35.032   2.086  1.00  9.65           N  
ATOM   1304  CA  ASP    75      11.929  34.372   3.135  1.00 13.01           C  
ATOM   1305  C   ASP    75      11.709  32.928   2.732  1.00 11.42           C  
ATOM   1306  O   ASP    75      11.206  32.670   1.635  1.00  9.02           O  
ATOM   1307  CB  ASP    75      10.572  35.054   3.324  1.00 11.96           C  
ATOM   1308  CG  ASP    75       9.814  34.558   4.556  1.00 24.12           C  
ATOM   1309  OD1 ASP    75      10.353  33.741   5.350  1.00 17.51           O  
ATOM   1310  OD2 ASP    75       8.661  35.008   4.724  1.00 28.01           O  
ATOM   1311  N   CYS    76      12.030  32.007   3.632  1.00  8.22           N  
ATOM   1312  CA  CYS    76      11.846  30.568   3.374  1.00  9.15           C  
ATOM   1313  C   CYS    76      10.730  29.921   4.175  1.00  9.30           C  
ATOM   1314  O   CYS    76      10.520  28.699   4.050  1.00  7.63           O  
ATOM   1315  CB  CYS    76      13.137  29.807   3.668  1.00 11.40           C  
ATOM   1316  SG  CYS    76      14.362  30.210   2.444  1.00 12.88           S  
ATOM   1317  N   LYS    77      10.075  30.728   5.026  1.00 10.57           N  
ATOM   1318  CA  LYS    77       9.123  30.218   6.020  1.00 14.26           C  
ATOM   1319  C   LYS    77       7.978  29.472   5.387  1.00  8.53           C  
ATOM   1320  O   LYS    77       7.507  28.479   5.963  1.00 11.10           O  
ATOM   1321  CB  LYS    77       8.599  31.324   6.957  1.00 15.67           C  
ATOM   1322  CG  LYS    77       9.511  31.573   8.157  1.00 19.89           C  
ATOM   1323  CD  LYS    77       8.895  32.620   9.109  1.00 24.19           C  
ATOM   1324  CE  LYS    77       9.716  33.884   9.209  1.00 33.17           C  
ATOM   1325  NZ  LYS    77      10.877  33.697  10.136  1.00 29.25           N  
ATOM   1326  N   TRP    78       7.555  29.925   4.204  1.00 10.27           N  
ATOM   1327  CA  TRP    78       6.425  29.319   3.508  1.00 16.47           C  
ATOM   1328  C   TRP    78       6.787  28.462   2.308  1.00 13.58           C  
ATOM   1329  O   TRP    78       5.897  28.040   1.575  1.00 15.77           O  
ATOM   1330  CB  TRP    78       5.444  30.407   3.091  1.00 19.36           C  
ATOM   1331  CG  TRP    78       5.118  31.309   4.246  1.00 25.42           C  
ATOM   1332  CD1 TRP    78       5.855  32.385   4.697  1.00 25.84           C  
ATOM   1333  CD2 TRP    78       3.998  31.195   5.125  1.00 30.37           C  
ATOM   1334  NE1 TRP    78       5.247  32.943   5.791  1.00 36.66           N  
ATOM   1335  CE2 TRP    78       4.105  32.237   6.074  1.00 37.31           C  
ATOM   1336  CE3 TRP    78       2.914  30.318   5.202  1.00 34.68           C  
ATOM   1337  CZ2 TRP    78       3.165  32.421   7.082  1.00 37.30           C  
ATOM   1338  CZ3 TRP    78       1.977  30.506   6.199  1.00 41.73           C  
ATOM   1339  CH2 TRP    78       2.107  31.550   7.127  1.00 47.11           C  
ATOM   1340  N   LEU    79       8.074  28.152   2.143  1.00 10.68           N  
ATOM   1341  CA  LEU    79       8.567  27.438   0.958  1.00  7.83           C  
ATOM   1342  C   LEU    79       8.520  25.937   1.174  1.00 10.20           C  
ATOM   1343  O   LEU    79       8.641  25.464   2.309  1.00 11.47           O  
ATOM   1344  CB  LEU    79      10.024  27.853   0.658  1.00  5.36           C  
ATOM   1345  CG  LEU    79      10.263  29.304   0.268  1.00  7.56           C  
ATOM   1346  CD1 LEU    79      11.691  29.559  -0.205  1.00  2.25           C  
ATOM   1347  CD2 LEU    79       9.315  29.803  -0.814  1.00 10.35           C  
ATOM   1348  N   THR    80       8.296  25.187   0.094  1.00  8.23           N  
ATOM   1349  CA  THR    80       8.446  23.738   0.137  1.00  8.87           C  
ATOM   1350  C   THR    80       9.914  23.255   0.147  1.00  7.73           C  
ATOM   1351  O   THR    80      10.857  23.983  -0.175  1.00  6.98           O  
ATOM   1352  CB  THR    80       7.763  23.092  -1.069  1.00  8.21           C  
ATOM   1353  OG1 THR    80       8.509  23.398  -2.256  1.00 14.27           O  
ATOM   1354  CG2 THR    80       6.296  23.574  -1.200  1.00 11.15           C  
ATOM   1355  N   LEU    81      10.078  21.976   0.495  1.00 10.71           N  
ATOM   1356  CA  LEU    81      11.363  21.298   0.440  1.00  7.48           C  
ATOM   1357  C   LEU    81      12.005  21.488  -0.934  1.00  7.36           C  
ATOM   1358  O   LEU    81      13.163  21.824  -1.024  1.00  6.16           O  
ATOM   1359  CB  LEU    81      11.177  19.803   0.725  1.00  6.16           C  
ATOM   1360  CG  LEU    81      12.394  18.902   0.656  1.00  7.27           C  
ATOM   1361  CD1 LEU    81      13.460  19.358   1.651  1.00 16.39           C  
ATOM   1362  CD2 LEU    81      11.974  17.430   0.875  1.00  8.47           C  
ATOM   1363  N   SER    82      11.221  21.291  -1.999  1.00  9.16           N  
ATOM   1364  CA  SER    82      11.721  21.413  -3.360  1.00 13.04           C  
ATOM   1365  C   SER    82      12.234  22.831  -3.647  1.00  4.44           C  
ATOM   1366  O   SER    82      13.322  23.013  -4.217  1.00  8.02           O  
ATOM   1367  CB  SER    82      10.603  21.044  -4.336  1.00 12.18           C  
ATOM   1368  OG  SER    82      11.042  21.203  -5.649  1.00 25.44           O  
ATOM   1369  N   GLU    83      11.469  23.827  -3.226  1.00  4.16           N  
ATOM   1370  CA  GLU    83      11.854  25.227  -3.378  1.00  4.64           C  
ATOM   1371  C   GLU    83      13.121  25.638  -2.616  1.00  5.93           C  
ATOM   1372  O   GLU    83      14.003  26.352  -3.135  1.00  7.43           O  
ATOM   1373  CB  GLU    83      10.703  26.096  -2.987  1.00  9.11           C  
ATOM   1374  CG  GLU    83       9.535  25.922  -3.946  1.00  7.17           C  
ATOM   1375  CD  GLU    83       8.320  26.666  -3.485  1.00 23.55           C  
ATOM   1376  OE1 GLU    83       7.958  26.580  -2.295  1.00 16.25           O  
ATOM   1377  OE2 GLU    83       7.717  27.344  -4.327  1.00 20.56           O  
ATOM   1378  N   VAL    84      13.218  25.172  -1.390  1.00  4.00           N  
ATOM   1379  CA  VAL    84      14.413  25.464  -0.610  1.00  4.11           C  
ATOM   1380  C   VAL    84      15.624  24.811  -1.224  1.00  6.45           C  
ATOM   1381  O   VAL    84      16.665  25.429  -1.338  1.00  2.38           O  
ATOM   1382  CB  VAL    84      14.271  25.044   0.858  1.00  8.92           C  
ATOM   1383  CG1 VAL    84      15.679  25.183   1.545  1.00  2.12           C  
ATOM   1384  CG2 VAL    84      13.244  25.899   1.545  1.00  6.68           C  
ATOM   1385  N   MET    85      15.494  23.558  -1.652  1.00  8.74           N  
ATOM   1386  CA  MET    85      16.577  22.904  -2.372  1.00  6.59           C  
ATOM   1387  C   MET    85      17.015  23.704  -3.605  1.00  7.94           C  
ATOM   1388  O   MET    85      18.209  23.919  -3.816  1.00  3.90           O  
ATOM   1389  CB  MET    85      16.164  21.483  -2.760  0.50  7.10           C  
ATOM   1390  CG  MET    85      17.205  20.703  -3.526  0.50 15.40           C  
ATOM   1391  SD  MET    85      16.731  18.968  -3.550  0.50 18.17           S  
ATOM   1392  CE  MET    85      16.585  18.749  -1.774  0.50 13.19           C  
ATOM   1397  N   LYS    86      16.059  24.173  -4.408  1.00  6.05           N  
ATOM   1398  CA  LYS    86      16.420  24.932  -5.603  1.00  4.57           C  
ATOM   1399  C   LYS    86      17.121  26.234  -5.281  1.00  4.76           C  
ATOM   1400  O   LYS    86      18.127  26.568  -5.909  1.00 11.03           O  
ATOM   1401  CB  LYS    86      15.196  25.198  -6.465  1.00  2.09           C  
ATOM   1402  CG  LYS    86      14.726  24.002  -7.191  1.00 12.23           C  
ATOM   1403  CD  LYS    86      13.358  24.250  -7.766  1.00  9.18           C  
ATOM   1404  CE  LYS    86      12.849  23.034  -8.501  1.00 24.80           C  
ATOM   1405  NZ  LYS    86      11.687  23.394  -9.324  1.00 24.84           N  
ATOM   1406  N   LEU    87      16.648  26.948  -4.269  1.00  6.22           N  
ATOM   1407  CA  LEU    87      17.391  28.103  -3.762  1.00  8.18           C  
ATOM   1408  C   LEU    87      18.833  27.796  -3.346  1.00  4.86           C  
ATOM   1409  O   LEU    87      19.763  28.506  -3.743  1.00  4.68           O  
ATOM   1410  CB  LEU    87      16.669  28.750  -2.579  1.00  6.63           C  
ATOM   1411  CG  LEU    87      15.497  29.623  -3.020  1.00 19.07           C  
ATOM   1412  CD1 LEU    87      14.634  30.001  -1.797  1.00 12.85           C  
ATOM   1413  CD2 LEU    87      16.015  30.877  -3.808  1.00 16.54           C  
ATOM   1414  N   LEU    88      19.044  26.778  -2.518  1.00  5.02           N  
ATOM   1415  CA  LEU    88      20.411  26.475  -2.116  1.00  7.45           C  
ATOM   1416  C   LEU    88      21.246  26.012  -3.297  1.00  7.49           C  
ATOM   1417  O   LEU    88      22.434  26.323  -3.360  1.00  8.28           O  
ATOM   1418  CB  LEU    88      20.470  25.421  -0.992  1.00  8.39           C  
ATOM   1419  CG  LEU    88      19.766  25.835   0.281  1.00 12.05           C  
ATOM   1420  CD1 LEU    88      19.161  24.562   1.025  1.00  5.51           C  
ATOM   1421  CD2 LEU    88      20.756  26.688   1.091  1.00  3.97           C  
ATOM   1422  N   LYS    89      20.650  25.255  -4.236  1.00  6.37           N  
ATOM   1423  CA  LYS    89      21.449  24.771  -5.342  1.00  9.47           C  
ATOM   1424  C   LYS    89      22.010  25.971  -6.156  1.00 10.74           C  
ATOM   1425  O   LYS    89      23.152  25.953  -6.607  1.00 10.52           O  
ATOM   1426  CB  LYS    89      20.682  23.804  -6.231  1.00  8.47           C  
ATOM   1427  CG  LYS    89      21.625  23.124  -7.238  1.00 19.48           C  
ATOM   1428  CD  LYS    89      21.139  21.768  -7.726  1.00 27.70           C  
ATOM   1429  CE  LYS    89      21.991  21.271  -8.894  1.00 40.46           C  
ATOM   1430  NZ  LYS    89      23.461  21.214  -8.576  1.00 36.37           N  
ATOM   1431  N   SER    90      21.206  27.022  -6.240  1.00  9.90           N  
ATOM   1432  CA  SER    90      21.523  28.228  -7.000  1.00 13.03           C  
ATOM   1433  C   SER    90      22.831  28.915  -6.591  1.00 11.86           C  
ATOM   1434  O   SER    90      23.389  29.693  -7.376  1.00 13.25           O  
ATOM   1435  CB  SER    90      20.360  29.231  -6.891  1.00 11.73           C  
ATOM   1436  OG  SER    90      20.523  30.032  -5.712  1.00 11.54           O  
ATOM   1437  N   PHE    91      23.325  28.658  -5.375  1.00  8.21           N  
ATOM   1438  CA  PHE    91      24.548  29.298  -4.895  1.00 11.95           C  
ATOM   1439  C   PHE    91      25.804  28.639  -5.434  1.00 14.18           C  
ATOM   1440  O   PHE    91      26.902  29.206  -5.369  1.00 11.71           O  
ATOM   1441  CB  PHE    91      24.578  29.296  -3.346  1.00  9.38           C  
ATOM   1442  CG  PHE    91      23.673  30.314  -2.716  1.00 11.45           C  
ATOM   1443  CD1 PHE    91      24.159  31.550  -2.367  1.00 10.27           C  
ATOM   1444  CD2 PHE    91      22.331  30.056  -2.515  1.00  7.95           C  
ATOM   1445  CE1 PHE    91      23.379  32.476  -1.814  1.00  4.95           C  
ATOM   1446  CE2 PHE    91      21.522  31.010  -1.939  1.00  6.69           C  
ATOM   1447  CZ  PHE    91      22.039  32.237  -1.599  1.00 13.11           C  
ATOM   1448  N   GLY    92      25.677  27.397  -5.897  1.00 17.00           N  
ATOM   1449  CA  GLY    92      26.841  26.667  -6.292  1.00 13.63           C  
ATOM   1450  C   GLY    92      27.825  26.631  -5.155  1.00 15.11           C  
ATOM   1451  O   GLY    92      27.479  26.257  -4.037  1.00 14.41           O  
ATOM   1452  N   GLU    93      29.067  26.990  -5.445  1.00 13.66           N  
ATOM   1453  CA  GLU    93      30.123  26.975  -4.428  1.00 16.30           C  
ATOM   1454  C   GLU    93      30.317  28.352  -3.806  1.00 15.31           C  
ATOM   1455  O   GLU    93      31.269  28.555  -3.048  1.00 18.24           O  
ATOM   1456  CB  GLU    93      31.448  26.530  -5.042  1.00 19.40           C  
ATOM   1457  CG  GLU    93      31.466  25.101  -5.549  1.00 27.12           C  
ATOM   1458  CD  GLU    93      32.869  24.609  -5.857  1.00 42.34           C  
ATOM   1459  OE1 GLU    93      33.840  25.389  -5.722  1.00 37.39           O  
ATOM   1460  OE2 GLU    93      33.001  23.434  -6.248  1.00 55.68           O  
ATOM   1461  N   ASP    94      29.433  29.291  -4.106  1.00 14.41           N  
ATOM   1462  CA  ASP    94      29.536  30.610  -3.463  1.00 18.77           C  
ATOM   1463  C   ASP    94      28.987  30.623  -2.027  1.00 17.03           C  
ATOM   1464  O   ASP    94      28.247  29.720  -1.629  1.00 14.54           O  
ATOM   1465  CB  ASP    94      28.841  31.673  -4.307  1.00 21.18           C  
ATOM   1466  CG  ASP    94      29.594  32.001  -5.600  1.00 28.24           C  
ATOM   1467  OD1 ASP    94      30.847  31.887  -5.642  1.00 41.06           O  
ATOM   1468  OD2 ASP    94      28.921  32.414  -6.567  1.00 41.68           O  
ATOM   1469  N   GLU    95      29.349  31.669  -1.275  1.00 12.55           N  
ATOM   1470  CA  GLU    95      28.953  31.844   0.107  1.00 14.79           C  
ATOM   1471  C   GLU    95      27.430  31.830   0.229  1.00 11.75           C  
ATOM   1472  O   GLU    95      26.734  32.547  -0.487  1.00 11.21           O  
ATOM   1473  CB  GLU    95      29.454  33.182   0.657  1.00 16.25           C  
ATOM   1474  CG  GLU    95      29.422  33.243   2.189  1.00 36.27           C  
ATOM   1475  CD  GLU    95      29.882  34.583   2.763  1.00 31.85           C  
ATOM   1476  OE1 GLU    95      30.147  35.528   1.979  1.00 58.74           O  
ATOM   1477  OE2 GLU    95      29.974  34.682   4.004  1.00 51.18           O  
ATOM   1478  N   ILE    96      26.938  30.973   1.118  1.00  9.32           N  
ATOM   1479  CA  ILE    96      25.512  30.924   1.465  1.00  8.00           C  
ATOM   1480  C   ILE    96      25.370  31.511   2.886  1.00  7.20           C  
ATOM   1481  O   ILE    96      26.187  31.231   3.782  1.00 11.10           O  
ATOM   1482  CB  ILE    96      24.971  29.491   1.450  1.00  8.59           C  
ATOM   1483  CG1 ILE    96      25.246  28.822   0.101  1.00 13.38           C  
ATOM   1484  CG2 ILE    96      23.471  29.492   1.726  1.00 13.49           C  
ATOM   1485  CD1 ILE    96      24.789  27.353   0.009  1.00 14.65           C  
ATOM   1486  N   GLU    97      24.366  32.366   3.055  1.00 10.36           N  
ATOM   1487  CA  GLU    97      23.903  32.800   4.366  1.00  7.65           C  
ATOM   1488  C   GLU    97      22.462  32.312   4.462  1.00 13.35           C  
ATOM   1489  O   GLU    97      21.681  32.544   3.556  1.00  7.60           O  
ATOM   1490  CB  GLU    97      24.005  34.322   4.533  1.00 10.13           C  
ATOM   1491  CG  GLU    97      23.734  34.832   5.968  1.00 11.02           C  
ATOM   1492  CD  GLU    97      22.233  34.974   6.320  1.00 14.32           C  
ATOM   1493  OE1 GLU    97      21.362  34.842   5.416  1.00 16.85           O  
ATOM   1494  OE2 GLU    97      21.920  35.253   7.497  1.00 22.74           O  
ATOM   1495  N   MET    98      22.163  31.545   5.512  1.00  9.75           N  
ATOM   1496  CA  MET    98      20.790  31.250   5.879  1.00 10.15           C  
ATOM   1497  C   MET    98      20.607  31.552   7.370  1.00 14.35           C  
ATOM   1498  O   MET    98      21.595  31.625   8.142  1.00 13.10           O  
ATOM   1499  CB  MET    98      20.437  29.810   5.548  1.00 11.11           C  
ATOM   1500  CG  MET    98      21.128  28.795   6.319  1.00 15.03           C  
ATOM   1501  SD  MET    98      20.607  27.189   5.714  1.00 17.06           S  
ATOM   1502  CE  MET    98      21.447  26.122   6.881  1.00 16.50           C  
ATOM   1503  N   LYS    99      19.358  31.803   7.744  1.00 10.16           N  
ATOM   1504  CA  LYS    99      18.989  31.878   9.129  1.00  8.29           C  
ATOM   1505  C   LYS    99      18.144  30.684   9.520  1.00 10.11           C  
ATOM   1506  O   LYS    99      17.218  30.280   8.812  1.00  5.05           O  
ATOM   1507  CB  LYS    99      18.261  33.190   9.444  1.00  9.41           C  
ATOM   1508  CG  LYS    99      19.201  34.394   9.408  1.00 11.94           C  
ATOM   1509  CD  LYS    99      18.500  35.689   9.672  1.00 20.67           C  
ATOM   1510  CE  LYS    99      19.470  36.878   9.595  1.00 24.00           C  
ATOM   1511  NZ  LYS    99      20.021  37.081   8.210  1.00 25.57           N  
ATOM   1512  N   VAL   100      18.486  30.127  10.664  1.00  4.91           N  
ATOM   1513  CA  VAL   100      17.822  28.972  11.213  1.00  9.59           C  
ATOM   1514  C   VAL   100      17.330  29.229  12.627  1.00 14.84           C  
ATOM   1515  O   VAL   100      17.856  30.103  13.353  1.00 12.38           O  
ATOM   1516  CB  VAL   100      18.743  27.731  11.230  1.00 11.37           C  
ATOM   1517  CG1 VAL   100      19.069  27.259   9.800  1.00  7.19           C  
ATOM   1518  CG2 VAL   100      19.993  28.009  12.044  1.00 10.60           C  
ATOM   1519  N   VAL   101      16.307  28.470  13.012  1.00 11.53           N  
ATOM   1520  CA  VAL   101      15.860  28.447  14.392  1.00 13.42           C  
ATOM   1521  C   VAL   101      15.840  27.007  14.856  1.00 10.82           C  
ATOM   1522  O   VAL   101      15.514  26.101  14.090  1.00  9.81           O  
ATOM   1523  CB  VAL   101      14.482  29.110  14.585  1.00 12.10           C  
ATOM   1524  CG1 VAL   101      14.572  30.556  14.299  1.00 11.18           C  
ATOM   1525  CG2 VAL   101      13.401  28.449  13.702  1.00 23.54           C  
ATOM   1526  N   SER   102      16.199  26.791  16.112  1.00  7.33           N  
ATOM   1527  CA  SER   102      16.144  25.445  16.681  1.00  9.03           C  
ATOM   1528  C   SER   102      14.784  25.075  17.273  1.00 14.29           C  
ATOM   1529  O   SER   102      14.484  23.882  17.411  1.00 17.89           O  
ATOM   1530  CB  SER   102      17.260  25.262  17.693  1.00 10.99           C  
ATOM   1531  OG  SER   102      18.509  25.269  17.028  1.00 12.55           O  
ATOM   1532  N   LEU   103      13.993  26.094  17.624  1.00 17.48           N  
ATOM   1533  CA  LEU   103      12.611  25.944  18.066  1.00 19.20           C  
ATOM   1534  C   LEU   103      11.714  26.860  17.277  1.00 18.10           C  
ATOM   1535  O   LEU   103      11.957  28.062  17.214  1.00 24.41           O  
ATOM   1536  CB  LEU   103      12.467  26.341  19.533  1.00 19.88           C  
ATOM   1537  CG  LEU   103      13.041  25.404  20.571  1.00 22.67           C  
ATOM   1538  CD1 LEU   103      12.926  26.066  21.942  1.00 22.53           C  
ATOM   1539  CD2 LEU   103      12.305  24.086  20.542  1.00 20.19           C  
ATOM   1540  N   LEU   104      10.650  26.308  16.716  1.00 22.65           N  
ATOM   1541  CA  LEU   104       9.787  27.063  15.833  1.00 27.19           C  
ATOM   1542  C   LEU   104       8.562  27.562  16.581  1.00 32.83           C  
ATOM   1543  O   LEU   104       8.687  28.359  17.504  1.00 38.11           O  
ATOM   1544  CB  LEU   104       9.374  26.195  14.651  1.00 29.93           C  
ATOM   1545  CG  LEU   104       8.464  26.866  13.621  1.00 32.89           C  
ATOM   1546  CD1 LEU   104       9.127  28.089  12.994  1.00 31.89           C  
ATOM   1547  CD2 LEU   104       8.059  25.860  12.564  1.00 23.60           C  
END
