
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  109 (  852),  selected  109 , name 3c0d_A
# Molecule2: number of CA atoms  136 ( 1099),  selected  136 , name T0391.pdb
# PARAMETERS: 3c0d_A.T0391.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L     4_A      K      14           -
LGA    T     5_A      Y      15           #
LGA    -       -      T      16           -
LGA    K     6_A      S      17          3.217
LGA    V     7_A      V      18          3.020
LGA    K     8_A      C      19          1.593
LGA    L     9_A      V      20          1.677
LGA    C    10_A      G      21          0.836
LGA    Q    11_A      R      22          0.584
LGA    L    12_A      E      23          1.476
LGA    D    13_A      E      24          2.231
LGA    D    14_A      D      25          2.218
LGA    L    15_A      I      26          1.328
LGA    -       -      R      27           -
LGA    X    16_A      K      28          3.285
LGA    P    17_A      S      29          4.725
LGA    F    18_A      E      30          3.812
LGA    I    19_A      -       -           -
LGA    G    20_A      R      31          3.059
LGA    A    21_A      M      32          1.597
LGA    T    22_A      T      33          1.384
LGA    V    23_A      A      34          0.846
LGA    L    24_A      V      35          0.855
LGA    I    25_A      V      36          0.967
LGA    E    26_A      H      37          0.664
LGA    G    27_A      D      38          0.760
LGA    E    28_A      R      39          1.011
LGA    R    29_A      E      40          1.458
LGA    V    30_A      V      41          0.323
LGA    A    31_A      V      42          0.613
LGA    L    32_A      I      43          0.654
LGA    F    33_A      F      44          0.187
LGA    Y    34_A      Y      45          0.833
LGA    I    35_A      H      46          1.616
LGA    P    36_A      K      47          3.987
LGA    D    37_A      G      48          2.338
LGA    S    38_A      E      49          2.216
LGA    G    39_A      -       -           -
LGA    V    40_A      Y      50          1.091
LGA    Y    41_A      H      51          0.542
LGA    A    42_A      A      52          0.314
LGA    V    43_A      M      53          0.751
LGA    Q    44_A      D      54          0.625
LGA    D    45_A      I      55          0.548
LGA    W    46_A      R      56          0.710
LGA    D    47_A      C      57          0.914
LGA    P    48_A      Y      58          1.437
LGA    I    49_A      H      59          1.075
LGA    G    50_A      S      60          2.612
LGA    K    51_A      G      61          2.163
LGA    A    52_A      G      62          3.362
LGA    Y    53_A      -       -           -
LGA    V    54_A      P      63          0.251
LGA    X    55_A      L      64          0.576
LGA    S    56_A      H      65          0.440
LGA    R    57_A      L      66          0.666
LGA    G    58_A      G      67          0.768
LGA    I    59_A      E      68          0.251
LGA    V    60_A      I      69          0.585
LGA    G    61_A      E      70          1.365
LGA    D    62_A      D      71          1.506
LGA    I    63_A      F      72          1.824
LGA    N    64_A      N      73          2.515
LGA    G    65_A      G      74          2.271
LGA    E    66_A      Q      75          2.564
LGA    X    67_A      S      76          0.496
LGA    C    68_A      C      77          0.887
LGA    V    69_A      I      78          0.374
LGA    A    70_A      V      79          0.278
LGA    S    71_A      C      80          0.372
LGA    P    72_A      P      81          0.449
LGA    L    73_A      W      82          0.553
LGA    Y    74_A      H      83          0.369
LGA    K    75_A      K      84          0.084
LGA    Q    76_A      Y      85          0.646
LGA    H    77_A      K      86          0.416
LGA    F    78_A      I      87          0.293
LGA    S    79_A      T      88          0.509
LGA    L    80_A      L      89          0.652
LGA    K    81_A      A      90          0.718
LGA    S    82_A      T      91          0.575
LGA    G    83_A      G      92          0.505
LGA    Q    84_A      E      93          0.641
LGA    C    85_A      G      94          0.786
LGA    L    86_A      L      95          0.400
LGA    E    87_A      Y      96          2.618
LGA    D    88_A      Q      97           -
LGA    -       -      S      98           -
LGA    -       -      I      99           -
LGA    -       -      N     100           -
LGA    -       -      P     101           -
LGA    -       -      K     107           -
LGA    -       -      P     108           -
LGA    -       -      K     109           -
LGA    -       -      W     110           -
LGA    -       -      C     111           -
LGA    -       -      S     112           -
LGA    E    89_A      K     113          1.251
LGA    A    90_A      G     114          5.905
LGA    H    91_A      V     115          5.875
LGA    C    92_A      K     116          1.017
LGA    L    93_A      Q     117          0.626
LGA    K    94_A      R     118          0.735
LGA    T    95_A      I     119          1.209
LGA    W    96_A      H     120          0.957
LGA    R    97_A      T     121          0.672
LGA    V    98_A      V     122          0.491
LGA    T    99_A      K     123          0.706
LGA    V   100_A      V     124          0.973
LGA    D   101_A      D     125          1.547
LGA    D   102_A      N     126          2.362
LGA    N   103_A      G     127          1.463
LGA    Q   104_A      N     128          0.382
LGA    V   105_A      I     129          0.368
LGA    C   106_A      Y     130          0.574
LGA    Y   107_A      V     131          1.692
LGA    L   108_A      T     132          3.323
LGA    A   109_A      L     133           #
LGA    K   110_A      S     134           -
LGA    E   111_A      K     135           -
LGA    L   112_A      E     136           -
LGA    -       -      P     137           -
LGA    -       -      F     138           -
LGA    -       -      K     139           -
LGA    -       -      C     140           -
LGA    -       -      D     141           -
LGA    -       -      S     142           -
LGA    -       -      D     143           -
LGA    -       -      Y     144           -
LGA    -       -      Y     145           -
LGA    -       -      A     146           -
LGA    -       -      T     147           -
LGA    -       -      G     148           -
LGA    -       -      E     149           -
LGA    -       -      F     150           -
LGA    -       -      K     151           -
LGA    -       -      V     152           -
LGA    -       -      I     153           -
LGA    -       -      Q     154           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  109  136    5.0     99    1.77    20.20     67.531     5.291

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.118538 * X  +   0.961228 * Y  +  -0.248978 * Z  + -33.104267
  Y_new =   0.761348 * X  +  -0.248950 * Y  +  -0.598643 * Z  +  -5.856997
  Z_new =  -0.637415 * X  +  -0.118597 * Y  +  -0.761339 * Z  +  51.810562 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.987061    0.154532  [ DEG:  -171.1460      8.8540 ]
  Theta =   0.691139    2.450454  [ DEG:    39.5993    140.4007 ]
  Phi   =   1.416341   -1.725252  [ DEG:    81.1504    -98.8496 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3c0d_A                                        
REMARK     2: T0391.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3c0d_A.T0391.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  109  136   5.0   99   1.77   20.20  67.531
REMARK  ---------------------------------------------------------- 
MOLECULE 3c0d_A
HEADER    OXIDOREDUCTASE                          19-JAN-08   3C0D              
TITLE     CRYSTAL STRUCTURE OF THE PUTATIVE NITRITE REDUCTASE NADPH             
TITLE    2 (SMALL SUBUNIT) OXIDOREDUCTASE PROTEIN Q87HB1. NORTHEAST             
TITLE    3 STRUCTURAL GENOMICS CONSORTIUM TARGET VPR162                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE NITRITE REDUCTASE NADPH (SMALL SUBUNIT)           
COMPND   3 OXIDOREDUCTASE PROTEIN;                                              
COMPND   4 CHAIN: A, B, C, D, E, F, G, H;                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: VIBRIO PARAHAEMOLYTICUS RIMD 2210633;           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: RIMD 2210633 / SEROTYPE O3:K6;                               
SOURCE   5 GENE: VPA1054;                                                       
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI                                  
KEYWDS    NESG, VPR162, Q87HB1, XRAY, STRUCTURE, STRUCTURAL GENOMICS,           
KEYWDS   2 PSI-2, PROTEIN STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL            
KEYWDS   3 GENOMICS CONSORTIUM, OXIDOREDUCTASE                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.P.KUZIN,M.ABASHIDZE,J.SEETHARAMAN,S.M.VOROBIEV,D.WANG,              
AUTHOR   2 Y.FANG,L.OWENS,L-C.MA,R.XIAO,J.LIU,M.C.BARAN,T.B.ACTON,              
AUTHOR   3 B.ROST,G.T.MONTELIONE,L.TONG,J.F.HUNT,NORTHEAST STRUCTURAL           
AUTHOR   4 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   1   04-MAR-08 3C0D    0                                                
JRNL        AUTH   A.P.KUZIN,M.ABASHIDZE,J.SEETHARAMAN,S.M.VOROBIEV,            
JRNL        AUTH 2 D.WANG,Y.FANG,L.OWENS,L-C.MA,R.XIAO,J.LIU,                   
JRNL        AUTH 3 M.C.BARAN,T.B.ACTON,B.ROST,G.T.MONTELIONE,L.TONG,            
JRNL        AUTH 4 J.F.HUNT                                                     
JRNL        TITL   CRYSTAL STRUCTURE OF THE PUTATIVE NITRITE                    
JRNL        TITL 2 REDUCTASE NADPH (SMALL SUBUNIT) OXIDOREDUCTASE               
JRNL        TITL 3 PROTEIN Q87HB1.                                              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  3C0D A    1   111  UNP    Q87HB1   Q87HB1_VIBPA     1    111             
DBREF  3C0D B    1   111  UNP    Q87HB1   Q87HB1_VIBPA     1    111             
DBREF  3C0D C    1   111  UNP    Q87HB1   Q87HB1_VIBPA     1    111             
DBREF  3C0D D    1   111  UNP    Q87HB1   Q87HB1_VIBPA     1    111             
DBREF  3C0D E    1   111  UNP    Q87HB1   Q87HB1_VIBPA     1    111             
DBREF  3C0D F    1   111  UNP    Q87HB1   Q87HB1_VIBPA     1    111             
DBREF  3C0D G    1   111  UNP    Q87HB1   Q87HB1_VIBPA     1    111             
DBREF  3C0D H    1   111  UNP    Q87HB1   Q87HB1_VIBPA     1    111             
SEQRES   1 A  119  MSE ALA ALA LEU THR LYS VAL LYS LEU CYS GLN LEU ASP          
SEQRES   2 A  119  ASP LEU MSE PRO PHE ILE GLY ALA THR VAL LEU ILE GLU          
SEQRES   3 A  119  GLY GLU ARG VAL ALA LEU PHE TYR ILE PRO ASP SER GLY          
SEQRES   4 A  119  VAL TYR ALA VAL GLN ASP TRP ASP PRO ILE GLY LYS ALA          
SEQRES   5 A  119  TYR VAL MSE SER ARG GLY ILE VAL GLY ASP ILE ASN GLY          
SEQRES   6 A  119  GLU MSE CYS VAL ALA SER PRO LEU TYR LYS GLN HIS PHE          
SEQRES   7 A  119  SER LEU LYS SER GLY GLN CYS LEU GLU ASP GLU ALA HIS          
SEQRES   8 A  119  CYS LEU LYS THR TRP ARG VAL THR VAL ASP ASP ASN GLN          
SEQRES   9 A  119  VAL CYS TYR LEU ALA LYS GLU LEU GLU HIS HIS HIS HIS          
SEQRES  10 A  119  HIS HIS                                                      
SEQRES   1 B  119  MSE ALA ALA LEU THR LYS VAL LYS LEU CYS GLN LEU ASP          
SEQRES   2 B  119  ASP LEU MSE PRO PHE ILE GLY ALA THR VAL LEU ILE GLU          
SEQRES   3 B  119  GLY GLU ARG VAL ALA LEU PHE TYR ILE PRO ASP SER GLY          
SEQRES   4 B  119  VAL TYR ALA VAL GLN ASP TRP ASP PRO ILE GLY LYS ALA          
SEQRES   5 B  119  TYR VAL MSE SER ARG GLY ILE VAL GLY ASP ILE ASN GLY          
SEQRES   6 B  119  GLU MSE CYS VAL ALA SER PRO LEU TYR LYS GLN HIS PHE          
SEQRES   7 B  119  SER LEU LYS SER GLY GLN CYS LEU GLU ASP GLU ALA HIS          
SEQRES   8 B  119  CYS LEU LYS THR TRP ARG VAL THR VAL ASP ASP ASN GLN          
SEQRES   9 B  119  VAL CYS TYR LEU ALA LYS GLU LEU GLU HIS HIS HIS HIS          
SEQRES  10 B  119  HIS HIS                                                      
SEQRES   1 C  119  MSE ALA ALA LEU THR LYS VAL LYS LEU CYS GLN LEU ASP          
SEQRES   2 C  119  ASP LEU MSE PRO PHE ILE GLY ALA THR VAL LEU ILE GLU          
SEQRES   3 C  119  GLY GLU ARG VAL ALA LEU PHE TYR ILE PRO ASP SER GLY          
SEQRES   4 C  119  VAL TYR ALA VAL GLN ASP TRP ASP PRO ILE GLY LYS ALA          
SEQRES   5 C  119  TYR VAL MSE SER ARG GLY ILE VAL GLY ASP ILE ASN GLY          
SEQRES   6 C  119  GLU MSE CYS VAL ALA SER PRO LEU TYR LYS GLN HIS PHE          
SEQRES   7 C  119  SER LEU LYS SER GLY GLN CYS LEU GLU ASP GLU ALA HIS          
SEQRES   8 C  119  CYS LEU LYS THR TRP ARG VAL THR VAL ASP ASP ASN GLN          
SEQRES   9 C  119  VAL CYS TYR LEU ALA LYS GLU LEU GLU HIS HIS HIS HIS          
SEQRES  10 C  119  HIS HIS                                                      
SEQRES   1 D  119  MSE ALA ALA LEU THR LYS VAL LYS LEU CYS GLN LEU ASP          
SEQRES   2 D  119  ASP LEU MSE PRO PHE ILE GLY ALA THR VAL LEU ILE GLU          
SEQRES   3 D  119  GLY GLU ARG VAL ALA LEU PHE TYR ILE PRO ASP SER GLY          
SEQRES   4 D  119  VAL TYR ALA VAL GLN ASP TRP ASP PRO ILE GLY LYS ALA          
SEQRES   5 D  119  TYR VAL MSE SER ARG GLY ILE VAL GLY ASP ILE ASN GLY          
SEQRES   6 D  119  GLU MSE CYS VAL ALA SER PRO LEU TYR LYS GLN HIS PHE          
SEQRES   7 D  119  SER LEU LYS SER GLY GLN CYS LEU GLU ASP GLU ALA HIS          
SEQRES   8 D  119  CYS LEU LYS THR TRP ARG VAL THR VAL ASP ASP ASN GLN          
SEQRES   9 D  119  VAL CYS TYR LEU ALA LYS GLU LEU GLU HIS HIS HIS HIS          
SEQRES  10 D  119  HIS HIS                                                      
SEQRES   1 E  119  MSE ALA ALA LEU THR LYS VAL LYS LEU CYS GLN LEU ASP          
SEQRES   2 E  119  ASP LEU MSE PRO PHE ILE GLY ALA THR VAL LEU ILE GLU          
SEQRES   3 E  119  GLY GLU ARG VAL ALA LEU PHE TYR ILE PRO ASP SER GLY          
SEQRES   4 E  119  VAL TYR ALA VAL GLN ASP TRP ASP PRO ILE GLY LYS ALA          
SEQRES   5 E  119  TYR VAL MSE SER ARG GLY ILE VAL GLY ASP ILE ASN GLY          
SEQRES   6 E  119  GLU MSE CYS VAL ALA SER PRO LEU TYR LYS GLN HIS PHE          
SEQRES   7 E  119  SER LEU LYS SER GLY GLN CYS LEU GLU ASP GLU ALA HIS          
SEQRES   8 E  119  CYS LEU LYS THR TRP ARG VAL THR VAL ASP ASP ASN GLN          
SEQRES   9 E  119  VAL CYS TYR LEU ALA LYS GLU LEU GLU HIS HIS HIS HIS          
SEQRES  10 E  119  HIS HIS                                                      
SEQRES   1 F  119  MSE ALA ALA LEU THR LYS VAL LYS LEU CYS GLN LEU ASP          
SEQRES   2 F  119  ASP LEU MSE PRO PHE ILE GLY ALA THR VAL LEU ILE GLU          
SEQRES   3 F  119  GLY GLU ARG VAL ALA LEU PHE TYR ILE PRO ASP SER GLY          
SEQRES   4 F  119  VAL TYR ALA VAL GLN ASP TRP ASP PRO ILE GLY LYS ALA          
SEQRES   5 F  119  TYR VAL MSE SER ARG GLY ILE VAL GLY ASP ILE ASN GLY          
SEQRES   6 F  119  GLU MSE CYS VAL ALA SER PRO LEU TYR LYS GLN HIS PHE          
SEQRES   7 F  119  SER LEU LYS SER GLY GLN CYS LEU GLU ASP GLU ALA HIS          
SEQRES   8 F  119  CYS LEU LYS THR TRP ARG VAL THR VAL ASP ASP ASN GLN          
SEQRES   9 F  119  VAL CYS TYR LEU ALA LYS GLU LEU GLU HIS HIS HIS HIS          
SEQRES  10 F  119  HIS HIS                                                      
SEQRES   1 G  119  MSE ALA ALA LEU THR LYS VAL LYS LEU CYS GLN LEU ASP          
SEQRES   2 G  119  ASP LEU MSE PRO PHE ILE GLY ALA THR VAL LEU ILE GLU          
SEQRES   3 G  119  GLY GLU ARG VAL ALA LEU PHE TYR ILE PRO ASP SER GLY          
SEQRES   4 G  119  VAL TYR ALA VAL GLN ASP TRP ASP PRO ILE GLY LYS ALA          
SEQRES   5 G  119  TYR VAL MSE SER ARG GLY ILE VAL GLY ASP ILE ASN GLY          
SEQRES   6 G  119  GLU MSE CYS VAL ALA SER PRO LEU TYR LYS GLN HIS PHE          
SEQRES   7 G  119  SER LEU LYS SER GLY GLN CYS LEU GLU ASP GLU ALA HIS          
SEQRES   8 G  119  CYS LEU LYS THR TRP ARG VAL THR VAL ASP ASP ASN GLN          
SEQRES   9 G  119  VAL CYS TYR LEU ALA LYS GLU LEU GLU HIS HIS HIS HIS          
SEQRES  10 G  119  HIS HIS                                                      
SEQRES   1 H  119  MSE ALA ALA LEU THR LYS VAL LYS LEU CYS GLN LEU ASP          
SEQRES   2 H  119  ASP LEU MSE PRO PHE ILE GLY ALA THR VAL LEU ILE GLU          
SEQRES   3 H  119  GLY GLU ARG VAL ALA LEU PHE TYR ILE PRO ASP SER GLY          
SEQRES   4 H  119  VAL TYR ALA VAL GLN ASP TRP ASP PRO ILE GLY LYS ALA          
SEQRES   5 H  119  TYR VAL MSE SER ARG GLY ILE VAL GLY ASP ILE ASN GLY          
SEQRES   6 H  119  GLU MSE CYS VAL ALA SER PRO LEU TYR LYS GLN HIS PHE          
SEQRES   7 H  119  SER LEU LYS SER GLY GLN CYS LEU GLU ASP GLU ALA HIS          
SEQRES   8 H  119  CYS LEU LYS THR TRP ARG VAL THR VAL ASP ASP ASN GLN          
SEQRES   9 H  119  VAL CYS TYR LEU ALA LYS GLU LEU GLU HIS HIS HIS HIS          
SEQRES  10 H  119  HIS HIS                                                      
HET    MSE  A  16       8                                                       
HET    MSE  A  55       8                                                       
HET    MSE  A  67       8                                                       
HET    MSE  B  16       8                                                       
HET    MSE  B  55       8                                                       
HET    MSE  B  67       8                                                       
HET    MSE  C  16       8                                                       
HET    MSE  C  55       8                                                       
HET    MSE  C  67       8                                                       
HET    MSE  D  16       8                                                       
HET    MSE  D  55       8                                                       
HET    MSE  D  67       8                                                       
HET    MSE  E  16       8                                                       
HET    MSE  E  55       8                                                       
HET    MSE  E  67       8                                                       
HET    MSE  F  16       8                                                       
HET    MSE  F  55       8                                                       
HET    MSE  F  67       8                                                       
HET    MSE  G  16       8                                                       
HET    MSE  G  55       8                                                       
HET    MSE  G  67       8                                                       
HET    MSE  H  16       8                                                       
HET    MSE  H  55       8                                                       
HET    MSE  H  67       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    24(C5 H11 N O2 SE)                                           
FORMUL   9  HOH   *79(H2 O)                                                     
CRYST1   61.667  103.462   82.951  90.00  91.37  90.00 P 1 21 1     16          
ATOM      1  N   LEU A   4      24.588 -17.389  -9.023  1.00 70.30           N  
ATOM      2  CA  LEU A   4      24.268 -16.086  -9.674  1.00 71.65           C  
ATOM      3  C   LEU A   4      22.777 -15.985  -9.989  1.00 71.32           C  
ATOM      4  O   LEU A   4      22.246 -14.883 -10.148  1.00 72.27           O  
ATOM      5  CB  LEU A   4      25.057 -15.919 -10.989  1.00 71.89           C  
ATOM      6  CG  LEU A   4      26.590 -15.818 -11.041  1.00 71.30           C  
ATOM      7  CD1 LEU A   4      27.016 -15.646 -12.492  1.00 69.37           C  
ATOM      8  CD2 LEU A   4      27.080 -14.644 -10.204  1.00 71.09           C  
ATOM      9  N   THR A   5      22.098 -17.127 -10.073  1.00 69.65           N  
ATOM     10  CA  THR A   5      20.669 -17.133 -10.401  1.00 68.17           C  
ATOM     11  C   THR A   5      19.718 -16.736  -9.266  1.00 66.76           C  
ATOM     12  O   THR A   5      19.971 -17.020  -8.089  1.00 67.49           O  
ATOM     13  CB  THR A   5      20.230 -18.507 -10.948  1.00 68.30           C  
ATOM     14  OG1 THR A   5      20.632 -19.541 -10.035  1.00 67.78           O  
ATOM     15  CG2 THR A   5      20.853 -18.758 -12.322  1.00 69.04           C  
ATOM     16  N   LYS A   6      18.624 -16.074  -9.642  1.00 63.20           N  
ATOM     17  CA  LYS A   6      17.620 -15.614  -8.691  1.00 59.01           C  
ATOM     18  C   LYS A   6      16.266 -16.281  -8.918  1.00 57.41           C  
ATOM     19  O   LYS A   6      15.833 -16.469 -10.052  1.00 56.68           O  
ATOM     20  CB  LYS A   6      17.471 -14.094  -8.778  1.00 57.29           C  
ATOM     21  CG  LYS A   6      17.094 -13.571 -10.147  1.00 54.95           C  
ATOM     22  CD  LYS A   6      16.961 -12.055 -10.131  1.00 54.96           C  
ATOM     23  CE  LYS A   6      18.263 -11.391  -9.707  1.00 53.35           C  
ATOM     24  NZ  LYS A   6      18.134  -9.915  -9.728  1.00 53.38           N  
ATOM     25  N   VAL A   7      15.598 -16.633  -7.825  1.00 55.72           N  
ATOM     26  CA  VAL A   7      14.300 -17.302  -7.894  1.00 52.59           C  
ATOM     27  C   VAL A   7      13.195 -16.420  -7.312  1.00 50.17           C  
ATOM     28  O   VAL A   7      13.282 -15.996  -6.158  1.00 49.05           O  
ATOM     29  CB  VAL A   7      14.323 -18.630  -7.084  1.00 52.71           C  
ATOM     30  CG1 VAL A   7      13.113 -19.496  -7.447  1.00 52.79           C  
ATOM     31  CG2 VAL A   7      15.622 -19.370  -7.336  1.00 52.32           C  
ATOM     32  N   LYS A   8      12.158 -16.150  -8.100  1.00 47.35           N  
ATOM     33  CA  LYS A   8      11.046 -15.337  -7.622  1.00 45.91           C  
ATOM     34  C   LYS A   8      10.584 -15.872  -6.274  1.00 44.63           C  
ATOM     35  O   LYS A   8      10.328 -17.067  -6.131  1.00 44.99           O  
ATOM     36  CB  LYS A   8       9.883 -15.370  -8.623  1.00 48.24           C  
ATOM     37  CG  LYS A   8      10.177 -14.665  -9.953  1.00 48.91           C  
ATOM     38  CD  LYS A   8       8.995 -14.727 -10.910  1.00 48.87           C  
ATOM     39  CE  LYS A   8       9.314 -13.989 -12.203  1.00 50.72           C  
ATOM     40  NZ  LYS A   8       8.255 -14.134 -13.239  1.00 50.37           N  
ATOM     41  N   LEU A   9      10.485 -14.981  -5.290  1.00 42.89           N  
ATOM     42  CA  LEU A   9      10.074 -15.330  -3.926  1.00 41.53           C  
ATOM     43  C   LEU A   9       8.688 -14.747  -3.606  1.00 41.09           C  
ATOM     44  O   LEU A   9       7.745 -15.476  -3.276  1.00 38.74           O  
ATOM     45  CB  LEU A   9      11.114 -14.783  -2.955  1.00 41.50           C  
ATOM     46  CG  LEU A   9      11.244 -15.439  -1.590  1.00 43.67           C  
ATOM     47  CD1 LEU A   9      11.387 -16.936  -1.749  1.00 44.48           C  
ATOM     48  CD2 LEU A   9      12.460 -14.864  -0.889  1.00 43.80           C  
ATOM     49  N   CYS A  10       8.580 -13.422  -3.690  1.00 41.90           N  
ATOM     50  CA  CYS A  10       7.314 -12.720  -3.463  1.00 40.77           C  
ATOM     51  C   CYS A  10       7.367 -11.294  -4.000  1.00 41.62           C  
ATOM     52  O   CYS A  10       8.408 -10.827  -4.454  1.00 40.57           O  
ATOM     53  CB  CYS A  10       6.965 -12.681  -1.976  1.00 40.29           C  
ATOM     54  SG  CYS A  10       7.879 -11.477  -0.987  1.00 38.09           S  
ATOM     55  N   GLN A  11       6.223 -10.618  -3.952  1.00 44.13           N  
ATOM     56  CA  GLN A  11       6.086  -9.234  -4.411  1.00 43.29           C  
ATOM     57  C   GLN A  11       6.419  -8.322  -3.241  1.00 41.62           C  
ATOM     58  O   GLN A  11       6.007  -8.597  -2.119  1.00 42.35           O  
ATOM     59  CB  GLN A  11       4.647  -8.957  -4.833  1.00 45.61           C  
ATOM     60  CG  GLN A  11       4.243  -9.578  -6.140  1.00 47.02           C  
ATOM     61  CD  GLN A  11       5.069  -9.056  -7.285  1.00 47.58           C  
ATOM     62  OE1 GLN A  11       6.095  -9.642  -7.648  1.00 46.34           O  
ATOM     63  NE2 GLN A  11       4.636  -7.936  -7.858  1.00 47.58           N  
ATOM     64  N   LEU A  12       7.141  -7.236  -3.490  1.00 39.40           N  
ATOM     65  CA  LEU A  12       7.485  -6.330  -2.407  1.00 38.70           C  
ATOM     66  C   LEU A  12       6.267  -5.873  -1.588  1.00 38.73           C  
ATOM     67  O   LEU A  12       6.354  -5.768  -0.365  1.00 36.88           O  
ATOM     68  CB  LEU A  12       8.221  -5.095  -2.921  1.00 35.17           C  
ATOM     69  CG  LEU A  12       8.653  -4.219  -1.740  1.00 34.46           C  
ATOM     70  CD1 LEU A  12      10.101  -4.546  -1.352  1.00 34.69           C  
ATOM     71  CD2 LEU A  12       8.499  -2.754  -2.093  1.00 31.41           C  
ATOM     72  N   ASP A  13       5.134  -5.595  -2.232  1.00 39.75           N  
ATOM     73  CA  ASP A  13       3.983  -5.155  -1.454  1.00 41.12           C  
ATOM     74  C   ASP A  13       3.261  -6.279  -0.703  1.00 42.25           C  
ATOM     75  O   ASP A  13       2.133  -6.101  -0.224  1.00 41.80           O  
ATOM     76  CB  ASP A  13       3.002  -4.332  -2.300  1.00 42.65           C  
ATOM     77  CG  ASP A  13       2.701  -4.952  -3.637  1.00 45.41           C  
ATOM     78  OD1 ASP A  13       3.644  -5.438  -4.299  1.00 48.62           O  
ATOM     79  OD2 ASP A  13       1.517  -4.923  -4.033  1.00 45.32           O  
ATOM     80  N   ASP A  14       3.930  -7.428  -0.595  1.00 41.11           N  
ATOM     81  CA  ASP A  14       3.423  -8.557   0.170  1.00 41.24           C  
ATOM     82  C   ASP A  14       4.093  -8.371   1.537  1.00 42.03           C  
ATOM     83  O   ASP A  14       3.702  -8.975   2.547  1.00 40.60           O  
ATOM     84  CB  ASP A  14       3.878  -9.890  -0.432  1.00 41.33           C  
ATOM     85  CG  ASP A  14       2.933 -10.410  -1.504  1.00 43.49           C  
ATOM     86  OD1 ASP A  14       1.700 -10.302  -1.328  1.00 43.89           O  
ATOM     87  OD2 ASP A  14       3.429 -10.950  -2.516  1.00 44.42           O  
ATOM     88  N   LEU A  15       5.110  -7.511   1.540  1.00 41.89           N  
ATOM     89  CA  LEU A  15       5.887  -7.208   2.733  1.00 43.14           C  
ATOM     90  C   LEU A  15       5.590  -5.842   3.351  1.00 45.46           C  
ATOM     91  O   LEU A  15       5.794  -4.806   2.711  1.00 47.05           O  
ATOM     92  CB  LEU A  15       7.385  -7.249   2.417  1.00 41.60           C  
ATOM     93  CG  LEU A  15       8.036  -8.490   1.815  1.00 41.38           C  
ATOM     94  CD1 LEU A  15       9.523  -8.211   1.672  1.00 41.62           C  
ATOM     95  CD2 LEU A  15       7.803  -9.704   2.698  1.00 40.97           C  
HETATM   96  N   MSE A  16       5.131  -5.847   4.601  1.00 46.93           N  
HETATM   97  CA  MSE A  16       4.859  -4.618   5.323  1.00 47.06           C  
HETATM   98  C   MSE A  16       6.199  -4.140   5.872  1.00 45.05           C  
HETATM   99  O   MSE A  16       7.036  -4.949   6.271  1.00 44.06           O  
HETATM  100  CB  MSE A  16       3.903  -4.868   6.482  1.00 53.69           C  
HETATM  101  CG  MSE A  16       2.439  -4.935   6.098  1.00 64.29           C  
HETATM  102 SE   MSE A  16       1.306  -5.104   7.687  1.00 82.72          SE  
HETATM  103  CE  MSE A  16       0.897  -3.219   7.984  1.00 76.25           C  
ATOM    104  N   PRO A  17       6.423  -2.815   5.897  1.00 42.60           N  
ATOM    105  CA  PRO A  17       7.678  -2.262   6.405  1.00 39.85           C  
ATOM    106  C   PRO A  17       7.992  -2.643   7.842  1.00 37.56           C  
ATOM    107  O   PRO A  17       7.172  -2.458   8.733  1.00 36.27           O  
ATOM    108  CB  PRO A  17       7.478  -0.769   6.229  1.00 40.20           C  
ATOM    109  CG  PRO A  17       6.640  -0.704   4.995  1.00 38.90           C  
ATOM    110  CD  PRO A  17       5.602  -1.747   5.308  1.00 39.07           C  
ATOM    111  N   PHE A  18       9.182  -3.196   8.045  1.00 35.72           N  
ATOM    112  CA  PHE A  18       9.636  -3.590   9.373  1.00 35.46           C  
ATOM    113  C   PHE A  18       8.864  -4.738  10.015  1.00 32.98           C  
ATOM    114  O   PHE A  18       9.047  -5.010  11.199  1.00 32.96           O  
ATOM    115  CB  PHE A  18       9.591  -2.374  10.315  1.00 36.46           C  
ATOM    116  CG  PHE A  18      10.409  -1.208   9.837  1.00 37.73           C  
ATOM    117  CD1 PHE A  18      11.803  -1.309   9.754  1.00 37.97           C  
ATOM    118  CD2 PHE A  18       9.801  -0.007   9.486  1.00 35.67           C  
ATOM    119  CE1 PHE A  18      12.585  -0.230   9.334  1.00 35.74           C  
ATOM    120  CE2 PHE A  18      10.572   1.087   9.063  1.00 35.53           C  
ATOM    121  CZ  PHE A  18      11.966   0.968   8.991  1.00 37.11           C  
ATOM    122  N   ILE A  19       8.017  -5.408   9.245  1.00 29.97           N  
ATOM    123  CA  ILE A  19       7.223  -6.501   9.775  1.00 27.91           C  
ATOM    124  C   ILE A  19       7.479  -7.836   9.069  1.00 26.99           C  
ATOM    125  O   ILE A  19       7.218  -7.987   7.879  1.00 25.18           O  
ATOM    126  CB  ILE A  19       5.737  -6.126   9.718  1.00 28.59           C  
ATOM    127  CG1 ILE A  19       5.503  -4.932  10.652  1.00 28.24           C  
ATOM    128  CG2 ILE A  19       4.866  -7.312  10.127  1.00 26.85           C  
ATOM    129  CD1 ILE A  19       4.087  -4.387  10.639  1.00 29.47           C  
ATOM    130  N   GLY A  20       7.976  -8.804   9.837  1.00 27.33           N  
ATOM    131  CA  GLY A  20       8.308 -10.112   9.301  1.00 26.92           C  
ATOM    132  C   GLY A  20       7.214 -10.902   8.609  1.00 26.86           C  
ATOM    133  O   GLY A  20       6.110 -11.020   9.127  1.00 27.51           O  
ATOM    134  N   ALA A  21       7.535 -11.424   7.425  1.00 25.47           N  
ATOM    135  CA  ALA A  21       6.631 -12.251   6.629  1.00 26.45           C  
ATOM    136  C   ALA A  21       7.336 -13.588   6.446  1.00 26.43           C  
ATOM    137  O   ALA A  21       8.469 -13.633   5.989  1.00 28.68           O  
ATOM    138  CB  ALA A  21       6.388 -11.622   5.272  1.00 24.29           C  
ATOM    139  N   THR A  22       6.689 -14.679   6.795  1.00 24.96           N  
ATOM    140  CA  THR A  22       7.351 -15.953   6.640  1.00 25.18           C  
ATOM    141  C   THR A  22       7.177 -16.404   5.222  1.00 27.31           C  
ATOM    142  O   THR A  22       6.207 -16.032   4.567  1.00 30.68           O  
ATOM    143  CB  THR A  22       6.734 -17.026   7.541  1.00 24.41           C  
ATOM    144  OG1 THR A  22       5.379 -17.253   7.136  1.00 26.41           O  
ATOM    145  CG2 THR A  22       6.773 -16.591   9.006  1.00 22.94           C  
ATOM    146  N   VAL A  23       8.136 -17.190   4.752  1.00 28.96           N  
ATOM    147  CA  VAL A  23       8.135 -17.763   3.412  1.00 28.00           C  
ATOM    148  C   VAL A  23       8.982 -19.005   3.518  1.00 29.40           C  
ATOM    149  O   VAL A  23       9.641 -19.241   4.530  1.00 30.97           O  
ATOM    150  CB  VAL A  23       8.798 -16.856   2.353  1.00 29.17           C  
ATOM    151  CG1 VAL A  23       7.915 -15.639   2.071  1.00 29.10           C  
ATOM    152  CG2 VAL A  23      10.194 -16.449   2.827  1.00 27.22           C  
ATOM    153  N   LEU A  24       8.974 -19.795   2.462  1.00 30.71           N  
ATOM    154  CA  LEU A  24       9.739 -21.024   2.435  1.00 32.49           C  
ATOM    155  C   LEU A  24      10.761 -20.938   1.312  1.00 33.02           C  
ATOM    156  O   LEU A  24      10.441 -20.527   0.185  1.00 35.19           O  
ATOM    157  CB  LEU A  24       8.807 -22.212   2.174  1.00 33.40           C  
ATOM    158  CG  LEU A  24       8.383 -23.158   3.294  1.00 34.73           C  
ATOM    159  CD1 LEU A  24       8.143 -22.415   4.608  1.00 35.30           C  
ATOM    160  CD2 LEU A  24       7.127 -23.885   2.826  1.00 33.42           C  
ATOM    161  N   ILE A  25      11.996 -21.300   1.625  1.00 30.91           N  
ATOM    162  CA  ILE A  25      13.030 -21.319   0.615  1.00 30.94           C  
ATOM    163  C   ILE A  25      13.569 -22.730   0.614  1.00 31.87           C  
ATOM    164  O   ILE A  25      14.213 -23.166   1.562  1.00 29.60           O  
ATOM    165  CB  ILE A  25      14.142 -20.309   0.902  1.00 30.79           C  
ATOM    166  CG1 ILE A  25      13.558 -18.896   0.904  1.00 28.79           C  
ATOM    167  CG2 ILE A  25      15.238 -20.425  -0.164  1.00 28.16           C  
ATOM    168  CD1 ILE A  25      14.604 -17.818   0.953  1.00 30.95           C  
ATOM    169  N   GLU A  26      13.251 -23.452  -0.449  1.00 35.30           N  
ATOM    170  CA  GLU A  26      13.681 -24.822  -0.586  1.00 38.62           C  
ATOM    171  C   GLU A  26      13.537 -25.598   0.711  1.00 37.82           C  
ATOM    172  O   GLU A  26      14.481 -26.234   1.164  1.00 38.86           O  
ATOM    173  CB  GLU A  26      15.127 -24.866  -1.079  1.00 42.12           C  
ATOM    174  CG  GLU A  26      15.226 -24.650  -2.578  1.00 50.00           C  
ATOM    175  CD  GLU A  26      14.430 -25.692  -3.365  1.00 54.77           C  
ATOM    176  OE1 GLU A  26      14.791 -26.897  -3.318  1.00 55.49           O  
ATOM    177  OE2 GLU A  26      13.439 -25.306  -4.030  1.00 57.92           O  
ATOM    178  N   GLY A  27      12.355 -25.522   1.315  1.00 37.19           N  
ATOM    179  CA  GLY A  27      12.095 -26.275   2.532  1.00 36.35           C  
ATOM    180  C   GLY A  27      12.372 -25.680   3.899  1.00 36.07           C  
ATOM    181  O   GLY A  27      11.793 -26.119   4.894  1.00 36.13           O  
ATOM    182  N   GLU A  28      13.251 -24.689   3.974  1.00 36.40           N  
ATOM    183  CA  GLU A  28      13.575 -24.082   5.253  1.00 35.31           C  
ATOM    184  C   GLU A  28      12.681 -22.892   5.579  1.00 34.28           C  
ATOM    185  O   GLU A  28      12.305 -22.134   4.699  1.00 34.35           O  
ATOM    186  CB  GLU A  28      15.040 -23.660   5.258  1.00 36.11           C  
ATOM    187  CG  GLU A  28      16.005 -24.825   5.097  1.00 40.05           C  
ATOM    188  CD  GLU A  28      17.466 -24.399   5.217  1.00 43.06           C  
ATOM    189  OE1 GLU A  28      17.817 -23.733   6.227  1.00 39.83           O  
ATOM    190  OE2 GLU A  28      18.258 -24.741   4.305  1.00 42.61           O  
ATOM    191  N   ARG A  29      12.344 -22.740   6.855  1.00 34.30           N  
ATOM    192  CA  ARG A  29      11.498 -21.644   7.308  1.00 34.10           C  
ATOM    193  C   ARG A  29      12.269 -20.352   7.285  1.00 33.04           C  
ATOM    194  O   ARG A  29      13.245 -20.222   8.012  1.00 33.77           O  
ATOM    195  CB  ARG A  29      11.059 -21.851   8.747  1.00 35.62           C  
ATOM    196  CG  ARG A  29       9.697 -21.268   9.021  1.00 35.80           C  
ATOM    197  CD  ARG A  29       8.702 -22.355   8.832  1.00 33.39           C  
ATOM    198  NE  ARG A  29       9.383 -23.507   8.284  1.00 31.68           N  
ATOM    199  CZ  ARG A  29       8.862 -24.712   8.280  1.00 35.79           C  
ATOM    200  NH1 ARG A  29       7.658 -24.893   8.806  1.00 38.79           N  
ATOM    201  NH2 ARG A  29       9.535 -25.725   7.753  1.00 39.67           N  
ATOM    202  N   VAL A  30      11.817 -19.382   6.494  1.00 31.72           N  
ATOM    203  CA  VAL A  30      12.508 -18.099   6.396  1.00 28.32           C  
ATOM    204  C   VAL A  30      11.622 -16.912   6.779  1.00 27.76           C  
ATOM    205  O   VAL A  30      10.411 -16.915   6.547  1.00 27.01           O  
ATOM    206  CB  VAL A  30      13.038 -17.882   4.962  1.00 27.90           C  
ATOM    207  CG1 VAL A  30      13.854 -16.613   4.889  1.00 25.26           C  
ATOM    208  CG2 VAL A  30      13.860 -19.076   4.536  1.00 26.10           C  
ATOM    209  N   ALA A  31      12.240 -15.897   7.370  1.00 25.63           N  
ATOM    210  CA  ALA A  31      11.525 -14.695   7.772  1.00 27.53           C  
ATOM    211  C   ALA A  31      12.034 -13.530   6.933  1.00 28.02           C  
ATOM    212  O   ALA A  31      13.226 -13.249   6.936  1.00 31.10           O  
ATOM    213  CB  ALA A  31      11.751 -14.414   9.266  1.00 23.04           C  
ATOM    214  N   LEU A  32      11.143 -12.871   6.197  1.00 28.30           N  
ATOM    215  CA  LEU A  32      11.540 -11.739   5.375  1.00 29.70           C  
ATOM    216  C   LEU A  32      11.253 -10.439   6.108  1.00 31.57           C  
ATOM    217  O   LEU A  32      10.198 -10.286   6.725  1.00 31.58           O  
ATOM    218  CB  LEU A  32      10.801 -11.736   4.040  1.00 27.06           C  
ATOM    219  CG  LEU A  32      11.062 -12.930   3.130  1.00 27.19           C  
ATOM    220  CD1 LEU A  32      10.622 -12.585   1.726  1.00 26.83           C  
ATOM    221  CD2 LEU A  32      12.544 -13.297   3.152  1.00 25.58           C  
ATOM    222  N   PHE A  33      12.193  -9.503   6.039  1.00 30.69           N  
ATOM    223  CA  PHE A  33      12.037  -8.227   6.714  1.00 33.06           C  
ATOM    224  C   PHE A  33      12.392  -7.108   5.749  1.00 34.01           C  
ATOM    225  O   PHE A  33      13.562  -6.918   5.404  1.00 35.10           O  
ATOM    226  CB  PHE A  33      12.957  -8.153   7.932  1.00 31.42           C  
ATOM    227  CG  PHE A  33      12.459  -8.912   9.124  1.00 31.91           C  
ATOM    228  CD1 PHE A  33      11.437  -8.391   9.922  1.00 33.46           C  
ATOM    229  CD2 PHE A  33      13.065 -10.116   9.504  1.00 33.94           C  
ATOM    230  CE1 PHE A  33      11.021  -9.057  11.100  1.00 32.12           C  
ATOM    231  CE2 PHE A  33      12.663 -10.798  10.680  1.00 32.22           C  
ATOM    232  CZ  PHE A  33      11.642 -10.260  11.474  1.00 32.87           C  
ATOM    233  N   TYR A  34      11.378  -6.364   5.319  1.00 34.13           N  
ATOM    234  CA  TYR A  34      11.589  -5.259   4.392  1.00 35.16           C  
ATOM    235  C   TYR A  34      11.927  -3.960   5.128  1.00 34.78           C  
ATOM    236  O   TYR A  34      11.106  -3.439   5.876  1.00 35.40           O  
ATOM    237  CB  TYR A  34      10.334  -5.074   3.529  1.00 35.18           C  
ATOM    238  CG  TYR A  34      10.284  -3.785   2.746  1.00 34.46           C  
ATOM    239  CD1 TYR A  34      11.383  -3.350   2.008  1.00 33.78           C  
ATOM    240  CD2 TYR A  34       9.118  -3.024   2.702  1.00 35.42           C  
ATOM    241  CE1 TYR A  34      11.324  -2.177   1.234  1.00 35.88           C  
ATOM    242  CE2 TYR A  34       9.043  -1.854   1.924  1.00 36.49           C  
ATOM    243  CZ  TYR A  34      10.151  -1.440   1.189  1.00 35.79           C  
ATOM    244  OH  TYR A  34      10.074  -0.329   0.374  1.00 36.51           O  
ATOM    245  N   ILE A  35      13.139  -3.453   4.918  1.00 34.76           N  
ATOM    246  CA  ILE A  35      13.573  -2.203   5.542  1.00 38.11           C  
ATOM    247  C   ILE A  35      13.659  -1.159   4.434  1.00 41.16           C  
ATOM    248  O   ILE A  35      14.575  -1.208   3.614  1.00 40.26           O  
ATOM    249  CB  ILE A  35      14.983  -2.322   6.176  1.00 37.34           C  
ATOM    250  CG1 ILE A  35      15.081  -3.584   7.036  1.00 35.47           C  
ATOM    251  CG2 ILE A  35      15.261  -1.114   7.032  1.00 34.62           C  
ATOM    252  CD1 ILE A  35      14.094  -3.609   8.200  1.00 35.06           C  
ATOM    253  N   PRO A  36      12.714  -0.193   4.399  1.00 44.57           N  
ATOM    254  CA  PRO A  36      12.693   0.863   3.372  1.00 45.72           C  
ATOM    255  C   PRO A  36      14.060   1.406   2.936  1.00 47.30           C  
ATOM    256  O   PRO A  36      14.397   1.374   1.747  1.00 47.27           O  
ATOM    257  CB  PRO A  36      11.823   1.940   4.006  1.00 44.26           C  
ATOM    258  CG  PRO A  36      10.833   1.134   4.783  1.00 44.54           C  
ATOM    259  CD  PRO A  36      11.694   0.069   5.434  1.00 43.45           C  
ATOM    260  N   ASP A  37      14.855   1.881   3.887  1.00 48.81           N  
ATOM    261  CA  ASP A  37      16.165   2.436   3.547  1.00 53.37           C  
ATOM    262  C   ASP A  37      17.202   1.392   3.075  1.00 52.95           C  
ATOM    263  O   ASP A  37      18.097   1.714   2.290  1.00 51.89           O  
ATOM    264  CB  ASP A  37      16.744   3.212   4.746  1.00 57.08           C  
ATOM    265  CG  ASP A  37      15.669   3.704   5.721  1.00 61.13           C  
ATOM    266  OD1 ASP A  37      15.018   2.851   6.381  1.00 65.14           O  
ATOM    267  OD2 ASP A  37      15.478   4.938   5.828  1.00 60.23           O  
ATOM    268  N   SER A  38      17.059   0.149   3.541  1.00 51.90           N  
ATOM    269  CA  SER A  38      18.005  -0.931   3.242  1.00 50.76           C  
ATOM    270  C   SER A  38      17.664  -1.982   2.186  1.00 50.25           C  
ATOM    271  O   SER A  38      18.550  -2.497   1.519  1.00 50.31           O  
ATOM    272  CB  SER A  38      18.337  -1.680   4.535  1.00 50.95           C  
ATOM    273  OG  SER A  38      18.942  -0.838   5.490  1.00 51.64           O  
ATOM    274  N   GLY A  39      16.394  -2.329   2.052  1.00 50.50           N  
ATOM    275  CA  GLY A  39      16.024  -3.350   1.089  1.00 49.03           C  
ATOM    276  C   GLY A  39      15.330  -4.479   1.839  1.00 48.12           C  
ATOM    277  O   GLY A  39      14.540  -4.214   2.755  1.00 48.08           O  
ATOM    278  N   VAL A  40      15.617  -5.730   1.483  1.00 44.93           N  
ATOM    279  CA  VAL A  40      14.974  -6.852   2.160  1.00 42.17           C  
ATOM    280  C   VAL A  40      15.967  -7.866   2.749  1.00 41.26           C  
ATOM    281  O   VAL A  40      16.881  -8.334   2.061  1.00 39.16           O  
ATOM    282  CB  VAL A  40      14.002  -7.572   1.200  1.00 40.57           C  
ATOM    283  CG1 VAL A  40      13.192  -8.598   1.938  1.00 40.02           C  
ATOM    284  CG2 VAL A  40      13.072  -6.565   0.555  1.00 41.55           C  
ATOM    285  N   TYR A  41      15.793  -8.187   4.030  1.00 40.41           N  
ATOM    286  CA  TYR A  41      16.658  -9.161   4.707  1.00 41.00           C  
ATOM    287  C   TYR A  41      15.905 -10.451   5.078  1.00 40.59           C  
ATOM    288  O   TYR A  41      14.758 -10.411   5.521  1.00 42.56           O  
ATOM    289  CB  TYR A  41      17.272  -8.541   5.959  1.00 41.80           C  
ATOM    290  CG  TYR A  41      18.183  -7.386   5.651  1.00 45.66           C  
ATOM    291  CD1 TYR A  41      17.669  -6.134   5.357  1.00 47.49           C  
ATOM    292  CD2 TYR A  41      19.568  -7.557   5.611  1.00 48.59           C  
ATOM    293  CE1 TYR A  41      18.513  -5.062   5.024  1.00 51.12           C  
ATOM    294  CE2 TYR A  41      20.427  -6.502   5.279  1.00 50.77           C  
ATOM    295  CZ  TYR A  41      19.894  -5.252   4.984  1.00 52.93           C  
ATOM    296  OH  TYR A  41      20.738  -4.199   4.634  1.00 54.19           O  
ATOM    297  N   ALA A  42      16.561 -11.592   4.896  1.00 37.36           N  
ATOM    298  CA  ALA A  42      15.967 -12.889   5.190  1.00 33.50           C  
ATOM    299  C   ALA A  42      16.760 -13.577   6.278  1.00 34.79           C  
ATOM    300  O   ALA A  42      17.985 -13.582   6.226  1.00 37.64           O  
ATOM    301  CB  ALA A  42      15.979 -13.747   3.948  1.00 32.69           C  
ATOM    302  N   VAL A  43      16.078 -14.165   7.258  1.00 33.24           N  
ATOM    303  CA  VAL A  43      16.757 -14.886   8.340  1.00 32.64           C  
ATOM    304  C   VAL A  43      15.906 -16.111   8.677  1.00 34.05           C  
ATOM    305  O   VAL A  43      14.716 -16.122   8.371  1.00 36.47           O  
ATOM    306  CB  VAL A  43      16.892 -14.024   9.613  1.00 32.43           C  
ATOM    307  CG1 VAL A  43      17.837 -12.859   9.369  1.00 32.40           C  
ATOM    308  CG2 VAL A  43      15.517 -13.509  10.040  1.00 33.01           C  
ATOM    309  N   GLN A  44      16.489 -17.139   9.289  1.00 32.30           N  
ATOM    310  CA  GLN A  44      15.699 -18.314   9.648  1.00 30.37           C  
ATOM    311  C   GLN A  44      14.602 -17.876  10.606  1.00 30.48           C  
ATOM    312  O   GLN A  44      14.844 -17.078  11.515  1.00 29.62           O  
ATOM    313  CB  GLN A  44      16.552 -19.360  10.339  1.00 31.06           C  
ATOM    314  CG  GLN A  44      16.910 -19.024  11.763  1.00 30.22           C  
ATOM    315  CD  GLN A  44      17.836 -20.058  12.342  1.00 34.49           C  
ATOM    316  OE1 GLN A  44      18.924 -20.295  11.809  1.00 35.86           O  
ATOM    317  NE2 GLN A  44      17.414 -20.694  13.434  1.00 33.00           N  
ATOM    318  N   ASP A  45      13.402 -18.411  10.404  1.00 30.09           N  
ATOM    319  CA  ASP A  45      12.264 -18.060  11.225  1.00 29.95           C  
ATOM    320  C   ASP A  45      12.305 -18.781  12.535  1.00 30.86           C  
ATOM    321  O   ASP A  45      11.771 -18.289  13.519  1.00 32.62           O  
ATOM    322  CB  ASP A  45      10.956 -18.372  10.510  1.00 31.24           C  
ATOM    323  CG  ASP A  45       9.750 -17.797  11.236  1.00 32.41           C  
ATOM    324  OD1 ASP A  45       9.791 -16.606  11.618  1.00 34.29           O  
ATOM    325  OD2 ASP A  45       8.755 -18.526  11.420  1.00 31.31           O  
ATOM    326  N   TRP A  46      12.940 -19.944  12.557  1.00 31.75           N  
ATOM    327  CA  TRP A  46      13.052 -20.706  13.798  1.00 34.07           C  
ATOM    328  C   TRP A  46      14.038 -20.030  14.778  1.00 33.82           C  
ATOM    329  O   TRP A  46      15.179 -19.738  14.423  1.00 34.93           O  
ATOM    330  CB  TRP A  46      13.490 -22.138  13.460  1.00 36.07           C  
ATOM    331  CG  TRP A  46      13.755 -23.049  14.630  1.00 37.04           C  
ATOM    332  CD1 TRP A  46      14.953 -23.277  15.229  1.00 37.40           C  
ATOM    333  CD2 TRP A  46      12.803 -23.881  15.305  1.00 39.00           C  
ATOM    334  NE1 TRP A  46      14.817 -24.204  16.231  1.00 38.18           N  
ATOM    335  CE2 TRP A  46      13.508 -24.595  16.301  1.00 40.06           C  
ATOM    336  CE3 TRP A  46      11.423 -24.100  15.162  1.00 40.03           C  
ATOM    337  CZ2 TRP A  46      12.879 -25.511  17.157  1.00 38.69           C  
ATOM    338  CZ3 TRP A  46      10.796 -25.013  16.011  1.00 39.40           C  
ATOM    339  CH2 TRP A  46      11.528 -25.710  16.993  1.00 39.20           C  
ATOM    340  N   ASP A  47      13.566 -19.760  15.995  1.00 33.71           N  
ATOM    341  CA  ASP A  47      14.356 -19.145  17.058  1.00 34.52           C  
ATOM    342  C   ASP A  47      15.191 -20.226  17.745  1.00 36.51           C  
ATOM    343  O   ASP A  47      14.658 -21.075  18.459  1.00 37.78           O  
ATOM    344  CB  ASP A  47      13.425 -18.509  18.088  1.00 35.12           C  
ATOM    345  CG  ASP A  47      14.168 -17.960  19.289  1.00 36.81           C  
ATOM    346  OD1 ASP A  47      15.379 -18.237  19.424  1.00 38.65           O  
ATOM    347  OD2 ASP A  47      13.539 -17.256  20.103  1.00 36.99           O  
ATOM    348  N   PRO A  48      16.514 -20.196  17.563  1.00 37.75           N  
ATOM    349  CA  PRO A  48      17.423 -21.186  18.165  1.00 38.18           C  
ATOM    350  C   PRO A  48      17.399 -21.217  19.686  1.00 38.23           C  
ATOM    351  O   PRO A  48      17.792 -22.196  20.302  1.00 37.72           O  
ATOM    352  CB  PRO A  48      18.783 -20.769  17.629  1.00 38.84           C  
ATOM    353  CG  PRO A  48      18.643 -19.266  17.554  1.00 39.42           C  
ATOM    354  CD  PRO A  48      17.262 -19.079  16.963  1.00 37.67           C  
ATOM    355  N   ILE A  49      16.950 -20.125  20.283  1.00 39.47           N  
ATOM    356  CA  ILE A  49      16.861 -20.015  21.731  1.00 39.74           C  
ATOM    357  C   ILE A  49      15.395 -19.690  21.963  1.00 42.56           C  
ATOM    358  O   ILE A  49      14.996 -18.515  21.916  1.00 46.74           O  
ATOM    359  CB  ILE A  49      17.674 -18.814  22.275  1.00 37.89           C  
ATOM    360  CG1 ILE A  49      19.055 -18.752  21.622  1.00 34.74           C  
ATOM    361  CG2 ILE A  49      17.823 -18.936  23.779  1.00 37.49           C  
ATOM    362  CD1 ILE A  49      19.805 -17.500  21.980  1.00 33.88           C  
ATOM    363  N   GLY A  50      14.579 -20.701  22.217  1.00 40.34           N  
ATOM    364  CA  GLY A  50      13.166 -20.429  22.426  1.00 38.60           C  
ATOM    365  C   GLY A  50      12.443 -21.576  21.775  1.00 38.30           C  
ATOM    366  O   GLY A  50      11.343 -21.955  22.177  1.00 38.15           O  
ATOM    367  N   LYS A  51      13.086 -22.101  20.738  1.00 35.78           N  
ATOM    368  CA  LYS A  51      12.599 -23.255  20.024  1.00 35.65           C  
ATOM    369  C   LYS A  51      11.199 -23.183  19.425  1.00 35.05           C  
ATOM    370  O   LYS A  51      10.298 -23.912  19.849  1.00 35.91           O  
ATOM    371  CB  LYS A  51      12.708 -24.460  20.955  1.00 33.70           C  
ATOM    372  CG  LYS A  51      14.074 -24.585  21.565  1.00 31.13           C  
ATOM    373  CD  LYS A  51      15.101 -24.704  20.468  1.00 33.11           C  
ATOM    374  CE  LYS A  51      16.487 -24.892  21.033  1.00 35.02           C  
ATOM    375  NZ  LYS A  51      17.483 -24.918  19.932  1.00 37.85           N  
ATOM    376  N   ALA A  52      11.020 -22.322  18.428  1.00 33.74           N  
ATOM    377  CA  ALA A  52       9.730 -22.198  17.764  1.00 31.29           C  
ATOM    378  C   ALA A  52       9.835 -21.247  16.587  1.00 29.10           C  
ATOM    379  O   ALA A  52      10.595 -20.283  16.641  1.00 27.50           O  
ATOM    380  CB  ALA A  52       8.669 -21.709  18.742  1.00 28.98           C  
ATOM    381  N   TYR A  53       9.100 -21.538  15.514  1.00 27.41           N  
ATOM    382  CA  TYR A  53       9.120 -20.664  14.358  1.00 26.12           C  
ATOM    383  C   TYR A  53       8.395 -19.453  14.861  1.00 27.55           C  
ATOM    384  O   TYR A  53       7.172 -19.489  15.010  1.00 28.03           O  
ATOM    385  CB  TYR A  53       8.334 -21.235  13.185  1.00 24.17           C  
ATOM    386  CG  TYR A  53       8.814 -22.563  12.684  1.00 21.90           C  
ATOM    387  CD1 TYR A  53      10.039 -22.691  12.030  1.00 20.87           C  
ATOM    388  CD2 TYR A  53       8.045 -23.699  12.871  1.00 21.35           C  
ATOM    389  CE1 TYR A  53      10.486 -23.933  11.570  1.00 21.31           C  
ATOM    390  CE2 TYR A  53       8.478 -24.940  12.426  1.00 22.10           C  
ATOM    391  CZ  TYR A  53       9.688 -25.053  11.773  1.00 21.41           C  
ATOM    392  OH  TYR A  53      10.057 -26.280  11.285  1.00 20.85           O  
ATOM    393  N   VAL A  54       9.139 -18.379  15.121  1.00 28.72           N  
ATOM    394  CA  VAL A  54       8.529 -17.173  15.642  1.00 27.63           C  
ATOM    395  C   VAL A  54       9.271 -15.876  15.311  1.00 28.34           C  
ATOM    396  O   VAL A  54       8.810 -14.789  15.689  1.00 27.93           O  
ATOM    397  CB  VAL A  54       8.364 -17.302  17.175  1.00 27.23           C  
ATOM    398  CG1 VAL A  54       9.698 -17.151  17.876  1.00 24.45           C  
ATOM    399  CG2 VAL A  54       7.365 -16.281  17.670  1.00 28.10           C  
HETATM  400  N   MSE A  55      10.388 -15.971  14.595  1.00 28.45           N  
HETATM  401  CA  MSE A  55      11.151 -14.776  14.279  1.00 30.13           C  
HETATM  402  C   MSE A  55      10.397 -13.762  13.448  1.00 29.38           C  
HETATM  403  O   MSE A  55      10.690 -12.566  13.496  1.00 29.04           O  
HETATM  404  CB  MSE A  55      12.467 -15.132  13.588  1.00 33.41           C  
HETATM  405  CG  MSE A  55      13.451 -15.914  14.474  1.00 41.55           C  
HETATM  406 SE   MSE A  55      13.815 -15.185  16.284  1.00 53.32          SE  
HETATM  407  CE  MSE A  55      14.674 -13.507  15.781  1.00 44.23           C  
ATOM    408  N   SER A  56       9.409 -14.211  12.690  1.00 26.89           N  
ATOM    409  CA  SER A  56       8.672 -13.257  11.879  1.00 28.10           C  
ATOM    410  C   SER A  56       7.876 -12.324  12.783  1.00 29.08           C  
ATOM    411  O   SER A  56       7.507 -11.227  12.395  1.00 30.49           O  
ATOM    412  CB  SER A  56       7.733 -13.988  10.926  1.00 28.06           C  
ATOM    413  OG  SER A  56       6.424 -14.058  11.444  1.00 29.18           O  
ATOM    414  N   ARG A  57       7.647 -12.750  14.013  1.00 31.72           N  
ATOM    415  CA  ARG A  57       6.863 -11.963  14.946  1.00 31.20           C  
ATOM    416  C   ARG A  57       7.695 -11.063  15.854  1.00 31.19           C  
ATOM    417  O   ARG A  57       7.152 -10.380  16.712  1.00 32.42           O  
ATOM    418  CB  ARG A  57       5.996 -12.903  15.799  1.00 32.16           C  
ATOM    419  CG  ARG A  57       4.988 -13.777  15.023  1.00 32.82           C  
ATOM    420  CD  ARG A  57       3.974 -12.926  14.278  1.00 36.03           C  
ATOM    421  NE  ARG A  57       3.456 -11.867  15.136  1.00 41.07           N  
ATOM    422  CZ  ARG A  57       2.998 -10.701  14.690  1.00 43.49           C  
ATOM    423  NH1 ARG A  57       2.997 -10.447  13.385  1.00 44.60           N  
ATOM    424  NH2 ARG A  57       2.562  -9.782  15.550  1.00 43.08           N  
ATOM    425  N   GLY A  58       9.008 -11.046  15.671  1.00 32.48           N  
ATOM    426  CA  GLY A  58       9.847 -10.215  16.529  1.00 32.10           C  
ATOM    427  C   GLY A  58       9.899  -8.736  16.166  1.00 33.70           C  
ATOM    428  O   GLY A  58       9.862  -8.370  14.988  1.00 33.34           O  
ATOM    429  N   ILE A  59       9.998  -7.881  17.179  1.00 34.51           N  
ATOM    430  CA  ILE A  59      10.056  -6.440  16.970  1.00 36.51           C  
ATOM    431  C   ILE A  59      11.398  -5.993  16.397  1.00 38.84           C  
ATOM    432  O   ILE A  59      12.456  -6.316  16.948  1.00 37.74           O  
ATOM    433  CB  ILE A  59       9.797  -5.684  18.292  1.00 36.60           C  
ATOM    434  CG1 ILE A  59       8.336  -5.869  18.704  1.00 36.31           C  
ATOM    435  CG2 ILE A  59      10.147  -4.200  18.141  1.00 32.71           C  
ATOM    436  CD1 ILE A  59       7.980  -5.186  20.000  1.00 35.55           C  
ATOM    437  N   VAL A  60      11.341  -5.256  15.286  1.00 39.32           N  
ATOM    438  CA  VAL A  60      12.537  -4.735  14.631  1.00 40.89           C  
ATOM    439  C   VAL A  60      12.915  -3.393  15.262  1.00 43.77           C  
ATOM    440  O   VAL A  60      12.046  -2.601  15.624  1.00 43.60           O  
ATOM    441  CB  VAL A  60      12.289  -4.504  13.139  1.00 40.11           C  
ATOM    442  CG1 VAL A  60      13.569  -4.053  12.466  1.00 38.45           C  
ATOM    443  CG2 VAL A  60      11.748  -5.761  12.504  1.00 40.44           C  
ATOM    444  N   GLY A  61      14.210  -3.136  15.396  1.00 47.38           N  
ATOM    445  CA  GLY A  61      14.656  -1.883  15.981  1.00 50.20           C  
ATOM    446  C   GLY A  61      16.127  -1.682  15.707  1.00 53.34           C  
ATOM    447  O   GLY A  61      16.788  -2.604  15.245  1.00 52.82           O  
ATOM    448  N   ASP A  62      16.654  -0.491  15.980  1.00 57.92           N  
ATOM    449  CA  ASP A  62      18.079  -0.239  15.747  1.00 60.84           C  
ATOM    450  C   ASP A  62      18.918  -0.356  17.012  1.00 60.79           C  
ATOM    451  O   ASP A  62      18.511   0.056  18.092  1.00 61.55           O  
ATOM    452  CB  ASP A  62      18.309   1.143  15.104  1.00 63.78           C  
ATOM    453  CG  ASP A  62      17.168   2.116  15.358  1.00 66.49           C  
ATOM    454  OD1 ASP A  62      16.416   1.924  16.344  1.00 66.61           O  
ATOM    455  OD2 ASP A  62      17.031   3.087  14.571  1.00 66.24           O  
ATOM    456  N   ILE A  63      20.090  -0.950  16.875  1.00 61.33           N  
ATOM    457  CA  ILE A  63      20.976  -1.096  18.007  1.00 62.31           C  
ATOM    458  C   ILE A  63      22.321  -0.663  17.475  1.00 65.10           C  
ATOM    459  O   ILE A  63      22.861  -1.278  16.550  1.00 64.61           O  
ATOM    460  CB  ILE A  63      21.017  -2.546  18.501  1.00 60.04           C  
ATOM    461  CG1 ILE A  63      19.641  -2.937  19.029  1.00 56.67           C  
ATOM    462  CG2 ILE A  63      22.044  -2.701  19.610  1.00 58.72           C  
ATOM    463  CD1 ILE A  63      19.565  -4.383  19.434  1.00 55.91           C  
ATOM    464  N   ASN A  64      22.837   0.416  18.065  1.00 68.02           N  
ATOM    465  CA  ASN A  64      24.097   1.021  17.666  1.00 69.86           C  
ATOM    466  C   ASN A  64      24.158   1.048  16.143  1.00 70.38           C  
ATOM    467  O   ASN A  64      25.158   0.674  15.530  1.00 69.70           O  
ATOM    468  CB  ASN A  64      25.311   0.289  18.282  1.00 71.40           C  
ATOM    469  CG  ASN A  64      25.473  -1.142  17.790  1.00 73.86           C  
ATOM    470  OD1 ASN A  64      24.715  -2.041  18.171  1.00 75.34           O  
ATOM    471  ND2 ASN A  64      26.472  -1.360  16.939  1.00 73.76           N  
ATOM    472  N   GLY A  65      23.054   1.490  15.543  1.00 71.42           N  
ATOM    473  CA  GLY A  65      22.969   1.579  14.093  1.00 73.33           C  
ATOM    474  C   GLY A  65      22.309   0.380  13.432  1.00 73.61           C  
ATOM    475  O   GLY A  65      21.081   0.238  13.461  1.00 73.77           O  
ATOM    476  N   GLU A  66      23.131  -0.476  12.822  1.00 73.20           N  
ATOM    477  CA  GLU A  66      22.647  -1.682  12.143  1.00 72.06           C  
ATOM    478  C   GLU A  66      21.521  -2.338  12.948  1.00 69.52           C  
ATOM    479  O   GLU A  66      21.716  -2.708  14.106  1.00 68.79           O  
ATOM    480  CB  GLU A  66      23.816  -2.658  11.938  1.00 71.92           C  
ATOM    481  CG  GLU A  66      24.686  -2.883  13.171  1.00 70.99           C  
ATOM    482  CD  GLU A  66      24.183  -4.014  14.047  1.00 71.19           C  
ATOM    483  OE1 GLU A  66      24.175  -5.175  13.575  1.00 68.05           O  
ATOM    484  OE2 GLU A  66      23.807  -3.742  15.210  1.00 71.84           O  
HETATM  485  N   MSE A  67      20.344  -2.483  12.343  1.00 67.02           N  
HETATM  486  CA  MSE A  67      19.242  -3.054  13.088  1.00 65.60           C  
HETATM  487  C   MSE A  67      19.044  -4.544  13.094  1.00 61.13           C  
HETATM  488  O   MSE A  67      19.384  -5.252  12.154  1.00 57.51           O  
HETATM  489  CB  MSE A  67      17.929  -2.372  12.734  1.00 70.74           C  
HETATM  490  CG  MSE A  67      17.570  -2.289  11.296  1.00 76.49           C  
HETATM  491 SE   MSE A  67      16.154  -0.986  11.290  1.00 86.91          SE  
HETATM  492  CE  MSE A  67      17.169   0.549  10.674  1.00 82.78           C  
ATOM    493  N   CYS A  68      18.455  -4.983  14.200  1.00 57.63           N  
ATOM    494  CA  CYS A  68      18.199  -6.378  14.468  1.00 55.49           C  
ATOM    495  C   CYS A  68      16.746  -6.630  14.864  1.00 51.86           C  
ATOM    496  O   CYS A  68      15.961  -5.690  15.067  1.00 50.49           O  
ATOM    497  CB  CYS A  68      19.116  -6.828  15.605  1.00 57.62           C  
ATOM    498  SG  CYS A  68      20.569  -5.756  15.808  1.00 64.59           S  
ATOM    499  N   VAL A  69      16.404  -7.912  14.973  1.00 47.26           N  
ATOM    500  CA  VAL A  69      15.066  -8.326  15.374  1.00 41.99           C  
ATOM    501  C   VAL A  69      15.126  -9.066  16.719  1.00 39.72           C  
ATOM    502  O   VAL A  69      15.919  -9.993  16.909  1.00 37.86           O  
ATOM    503  CB  VAL A  69      14.422  -9.238  14.312  1.00 39.35           C  
ATOM    504  CG1 VAL A  69      15.348 -10.378  13.973  1.00 36.77           C  
ATOM    505  CG2 VAL A  69      13.102  -9.766  14.832  1.00 35.30           C  
ATOM    506  N   ALA A  70      14.284  -8.631  17.648  1.00 38.05           N  
ATOM    507  CA  ALA A  70      14.204  -9.236  18.972  1.00 39.27           C  
ATOM    508  C   ALA A  70      13.257 -10.452  18.977  1.00 39.16           C  
ATOM    509  O   ALA A  70      12.085 -10.345  18.591  1.00 38.87           O  
ATOM    510  CB  ALA A  70      13.719  -8.194  19.989  1.00 37.58           C  
ATOM    511  N   SER A  71      13.759 -11.607  19.401  1.00 37.76           N  
ATOM    512  CA  SER A  71      12.895 -12.775  19.442  1.00 38.67           C  
ATOM    513  C   SER A  71      11.720 -12.416  20.341  1.00 38.44           C  
ATOM    514  O   SER A  71      11.902 -11.784  21.385  1.00 37.44           O  
ATOM    515  CB  SER A  71      13.627 -13.991  20.009  1.00 37.48           C  
ATOM    516  OG  SER A  71      12.713 -15.060  20.187  1.00 34.84           O  
ATOM    517  N   PRO A  72      10.496 -12.790  19.936  1.00 37.93           N  
ATOM    518  CA  PRO A  72       9.307 -12.488  20.741  1.00 38.25           C  
ATOM    519  C   PRO A  72       9.168 -13.392  21.972  1.00 40.71           C  
ATOM    520  O   PRO A  72       8.192 -13.281  22.715  1.00 42.24           O  
ATOM    521  CB  PRO A  72       8.174 -12.671  19.750  1.00 36.58           C  
ATOM    522  CG  PRO A  72       8.693 -13.744  18.868  1.00 36.84           C  
ATOM    523  CD  PRO A  72      10.120 -13.362  18.635  1.00 35.26           C  
ATOM    524  N   LEU A  73      10.146 -14.272  22.192  1.00 40.43           N  
ATOM    525  CA  LEU A  73      10.106 -15.167  23.345  1.00 40.80           C  
ATOM    526  C   LEU A  73      11.042 -14.714  24.474  1.00 42.28           C  
ATOM    527  O   LEU A  73      10.623 -14.018  25.398  1.00 42.51           O  
ATOM    528  CB  LEU A  73      10.448 -16.602  22.910  1.00 40.09           C  
ATOM    529  CG  LEU A  73       9.503 -17.277  21.896  1.00 39.35           C  
ATOM    530  CD1 LEU A  73       9.972 -18.692  21.614  1.00 34.34           C  
ATOM    531  CD2 LEU A  73       8.082 -17.297  22.430  1.00 37.71           C  
ATOM    532  N   TYR A  74      12.308 -15.108  24.405  1.00 44.09           N  
ATOM    533  CA  TYR A  74      13.279 -14.723  25.428  1.00 45.19           C  
ATOM    534  C   TYR A  74      14.035 -13.418  25.087  1.00 45.66           C  
ATOM    535  O   TYR A  74      15.144 -13.159  25.568  1.00 44.09           O  
ATOM    536  CB  TYR A  74      14.243 -15.886  25.664  1.00 46.42           C  
ATOM    537  CG  TYR A  74      13.535 -17.107  26.196  1.00 47.52           C  
ATOM    538  CD1 TYR A  74      13.002 -17.115  27.484  1.00 48.80           C  
ATOM    539  CD2 TYR A  74      13.355 -18.239  25.399  1.00 47.84           C  
ATOM    540  CE1 TYR A  74      12.294 -18.228  27.976  1.00 48.84           C  
ATOM    541  CE2 TYR A  74      12.655 -19.362  25.874  1.00 48.75           C  
ATOM    542  CZ  TYR A  74      12.124 -19.348  27.166  1.00 50.31           C  
ATOM    543  OH  TYR A  74      11.413 -20.434  27.647  1.00 49.93           O  
ATOM    544  N   LYS A  75      13.393 -12.609  24.248  1.00 46.15           N  
ATOM    545  CA  LYS A  75      13.868 -11.297  23.809  1.00 47.02           C  
ATOM    546  C   LYS A  75      15.284 -11.089  23.261  1.00 46.79           C  
ATOM    547  O   LYS A  75      15.705  -9.936  23.123  1.00 47.00           O  
ATOM    548  CB  LYS A  75      13.648 -10.273  24.932  1.00 47.12           C  
ATOM    549  CG  LYS A  75      12.230 -10.173  25.443  1.00 49.29           C  
ATOM    550  CD  LYS A  75      11.264  -9.698  24.367  1.00 53.06           C  
ATOM    551  CE  LYS A  75       9.865  -9.451  24.948  1.00 54.29           C  
ATOM    552  NZ  LYS A  75       9.277 -10.669  25.594  1.00 52.64           N  
ATOM    553  N   GLN A  76      16.031 -12.147  22.948  1.00 46.22           N  
ATOM    554  CA  GLN A  76      17.374 -11.923  22.413  1.00 45.52           C  
ATOM    555  C   GLN A  76      17.333 -11.148  21.086  1.00 44.89           C  
ATOM    556  O   GLN A  76      16.373 -11.248  20.318  1.00 43.88           O  
ATOM    557  CB  GLN A  76      18.116 -13.243  22.211  1.00 48.74           C  
ATOM    558  CG  GLN A  76      18.566 -13.921  23.493  1.00 51.47           C  
ATOM    559  CD  GLN A  76      17.578 -14.957  23.992  1.00 53.44           C  
ATOM    560  OE1 GLN A  76      17.239 -15.895  23.277  1.00 55.43           O  
ATOM    561  NE2 GLN A  76      17.120 -14.798  25.228  1.00 51.61           N  
ATOM    562  N   HIS A  77      18.379 -10.369  20.823  1.00 44.16           N  
ATOM    563  CA  HIS A  77      18.450  -9.566  19.602  1.00 42.74           C  
ATOM    564  C   HIS A  77      19.307 -10.224  18.537  1.00 42.87           C  
ATOM    565  O   HIS A  77      20.437 -10.635  18.792  1.00 42.71           O  
ATOM    566  CB  HIS A  77      19.010  -8.182  19.920  1.00 41.87           C  
ATOM    567  CG  HIS A  77      18.078  -7.331  20.722  1.00 43.17           C  
ATOM    568  ND1 HIS A  77      17.005  -6.673  20.163  1.00 45.14           N  
ATOM    569  CD2 HIS A  77      18.028  -7.066  22.049  1.00 44.41           C  
ATOM    570  CE1 HIS A  77      16.331  -6.042  21.110  1.00 43.49           C  
ATOM    571  NE2 HIS A  77      16.931  -6.266  22.263  1.00 44.68           N  
ATOM    572  N   PHE A  78      18.768 -10.313  17.330  1.00 42.98           N  
ATOM    573  CA  PHE A  78      19.497 -10.919  16.223  1.00 43.13           C  
ATOM    574  C   PHE A  78      19.674  -9.958  15.052  1.00 44.04           C  
ATOM    575  O   PHE A  78      18.686  -9.470  14.512  1.00 45.40           O  
ATOM    576  CB  PHE A  78      18.743 -12.142  15.722  1.00 41.92           C  
ATOM    577  CG  PHE A  78      18.696 -13.276  16.699  1.00 40.26           C  
ATOM    578  CD1 PHE A  78      19.702 -14.237  16.713  1.00 39.20           C  
ATOM    579  CD2 PHE A  78      17.609 -13.428  17.557  1.00 38.74           C  
ATOM    580  CE1 PHE A  78      19.623 -15.348  17.565  1.00 39.13           C  
ATOM    581  CE2 PHE A  78      17.520 -14.530  18.410  1.00 37.75           C  
ATOM    582  CZ  PHE A  78      18.530 -15.492  18.410  1.00 38.12           C  
ATOM    583  N   SER A  79      20.920  -9.704  14.655  1.00 43.69           N  
ATOM    584  CA  SER A  79      21.218  -8.823  13.523  1.00 43.53           C  
ATOM    585  C   SER A  79      20.619  -9.295  12.197  1.00 44.92           C  
ATOM    586  O   SER A  79      20.932 -10.395  11.748  1.00 46.70           O  
ATOM    587  CB  SER A  79      22.717  -8.727  13.315  1.00 42.23           C  
ATOM    588  OG  SER A  79      22.976  -8.359  11.969  1.00 44.04           O  
ATOM    589  N   LEU A  80      19.807  -8.460  11.550  1.00 45.96           N  
ATOM    590  CA  LEU A  80      19.197  -8.829  10.264  1.00 47.73           C  
ATOM    591  C   LEU A  80      20.213  -9.038   9.139  1.00 49.58           C  
ATOM    592  O   LEU A  80      19.946  -9.770   8.176  1.00 50.70           O  
ATOM    593  CB  LEU A  80      18.175  -7.772   9.814  1.00 44.82           C  
ATOM    594  CG  LEU A  80      16.913  -7.585  10.662  1.00 44.06           C  
ATOM    595  CD1 LEU A  80      15.999  -6.580   9.986  1.00 43.84           C  
ATOM    596  CD2 LEU A  80      16.193  -8.917  10.843  1.00 42.26           C  
ATOM    597  N   LYS A  81      21.372  -8.399   9.249  1.00 51.73           N  
ATOM    598  CA  LYS A  81      22.379  -8.545   8.210  1.00 53.59           C  
ATOM    599  C   LYS A  81      23.208  -9.818   8.333  1.00 53.37           C  
ATOM    600  O   LYS A  81      23.266 -10.623   7.400  1.00 53.60           O  
ATOM    601  CB  LYS A  81      23.318  -7.338   8.185  1.00 54.39           C  
ATOM    602  CG  LYS A  81      24.379  -7.473   7.101  1.00 57.53           C  
ATOM    603  CD  LYS A  81      23.716  -7.775   5.747  1.00 60.91           C  
ATOM    604  CE  LYS A  81      24.694  -8.372   4.732  1.00 60.91           C  
ATOM    605  NZ  LYS A  81      24.002  -8.820   3.480  1.00 59.16           N  
ATOM    606  N   SER A  82      23.854  -9.990   9.480  1.00 53.05           N  
ATOM    607  CA  SER A  82      24.702 -11.148   9.699  1.00 53.04           C  
ATOM    608  C   SER A  82      23.976 -12.307  10.354  1.00 53.26           C  
ATOM    609  O   SER A  82      24.256 -13.462  10.052  1.00 54.72           O  
ATOM    610  CB  SER A  82      25.925 -10.756  10.535  1.00 52.20           C  
ATOM    611  OG  SER A  82      25.544 -10.054  11.704  1.00 53.06           O  
ATOM    612  N   GLY A  83      23.039 -11.999  11.243  1.00 52.65           N  
ATOM    613  CA  GLY A  83      22.295 -13.045  11.917  1.00 52.15           C  
ATOM    614  C   GLY A  83      22.776 -13.255  13.337  1.00 52.44           C  
ATOM    615  O   GLY A  83      22.119 -13.915  14.143  1.00 52.46           O  
ATOM    616  N   GLN A  84      23.930 -12.683  13.644  1.00 52.36           N  
ATOM    617  CA  GLN A  84      24.533 -12.792  14.970  1.00 53.73           C  
ATOM    618  C   GLN A  84      23.589 -12.346  16.082  1.00 52.82           C  
ATOM    619  O   GLN A  84      22.877 -11.363  15.944  1.00 51.76           O  
ATOM    620  CB  GLN A  84      25.806 -11.937  15.026  1.00 55.34           C  
ATOM    621  CG  GLN A  84      26.609 -12.044  16.314  1.00 57.17           C  
ATOM    622  CD  GLN A  84      27.142 -13.447  16.556  1.00 58.71           C  
ATOM    623  OE1 GLN A  84      27.511 -14.154  15.615  1.00 59.46           O  
ATOM    624  NE2 GLN A  84      27.200 -13.852  17.824  1.00 58.80           N  
ATOM    625  N   CYS A  85      23.580 -13.083  17.186  1.00 53.69           N  
ATOM    626  CA  CYS A  85      22.749 -12.720  18.323  1.00 55.68           C  
ATOM    627  C   CYS A  85      23.606 -11.762  19.124  1.00 56.57           C  
ATOM    628  O   CYS A  85      24.791 -12.024  19.306  1.00 58.04           O  
ATOM    629  CB  CYS A  85      22.426 -13.943  19.173  1.00 56.31           C  
ATOM    630  SG  CYS A  85      21.467 -13.538  20.636  1.00 60.14           S  
ATOM    631  N   LEU A  86      23.027 -10.661  19.602  1.00 56.68           N  
ATOM    632  CA  LEU A  86      23.805  -9.680  20.353  1.00 57.19           C  
ATOM    633  C   LEU A  86      24.079 -10.041  21.805  1.00 58.12           C  
ATOM    634  O   LEU A  86      25.082  -9.607  22.364  1.00 58.12           O  
ATOM    635  CB  LEU A  86      23.132  -8.305  20.311  1.00 56.39           C  
ATOM    636  CG  LEU A  86      22.906  -7.674  18.934  1.00 56.81           C  
ATOM    637  CD1 LEU A  86      22.351  -6.259  19.103  1.00 54.93           C  
ATOM    638  CD2 LEU A  86      24.217  -7.647  18.151  1.00 56.00           C  
ATOM    639  N   GLU A  87      23.213 -10.843  22.414  1.00 59.67           N  
ATOM    640  CA  GLU A  87      23.391 -11.192  23.820  1.00 61.83           C  
ATOM    641  C   GLU A  87      23.871 -12.610  24.092  1.00 63.15           C  
ATOM    642  O   GLU A  87      23.755 -13.120  25.209  1.00 62.97           O  
ATOM    643  CB  GLU A  87      22.086 -10.943  24.580  1.00 62.40           C  
ATOM    644  CG  GLU A  87      21.589  -9.498  24.513  1.00 63.68           C  
ATOM    645  CD  GLU A  87      20.521  -9.291  23.459  1.00 63.63           C  
ATOM    646  OE1 GLU A  87      20.699  -9.786  22.325  1.00 62.51           O  
ATOM    647  OE2 GLU A  87      19.510  -8.625  23.772  1.00 63.50           O  
ATOM    648  N   ASP A  88      24.429 -13.247  23.078  1.00 64.53           N  
ATOM    649  CA  ASP A  88      24.905 -14.604  23.243  1.00 66.27           C  
ATOM    650  C   ASP A  88      25.678 -14.920  21.982  1.00 67.35           C  
ATOM    651  O   ASP A  88      25.152 -15.529  21.053  1.00 68.30           O  
ATOM    652  CB  ASP A  88      23.716 -15.542  23.396  1.00 65.96           C  
ATOM    653  CG  ASP A  88      24.100 -16.862  23.993  1.00 67.51           C  
ATOM    654  OD1 ASP A  88      25.099 -17.449  23.527  1.00 66.82           O  
ATOM    655  OD2 ASP A  88      23.395 -17.309  24.928  1.00 68.28           O  
ATOM    656  N   GLU A  89      26.932 -14.489  21.954  1.00 68.44           N  
ATOM    657  CA  GLU A  89      27.785 -14.680  20.792  1.00 69.09           C  
ATOM    658  C   GLU A  89      27.785 -16.084  20.222  1.00 67.34           C  
ATOM    659  O   GLU A  89      28.288 -16.293  19.126  1.00 67.21           O  
ATOM    660  CB  GLU A  89      29.211 -14.241  21.130  1.00 72.21           C  
ATOM    661  CG  GLU A  89      29.343 -12.725  21.286  1.00 75.85           C  
ATOM    662  CD  GLU A  89      30.440 -12.322  22.252  1.00 78.47           C  
ATOM    663  OE1 GLU A  89      30.349 -12.699  23.445  1.00 79.39           O  
ATOM    664  OE2 GLU A  89      31.391 -11.628  21.817  1.00 78.69           O  
ATOM    665  N   ALA A  90      27.203 -17.039  20.941  1.00 65.78           N  
ATOM    666  CA  ALA A  90      27.158 -18.421  20.469  1.00 63.82           C  
ATOM    667  C   ALA A  90      26.062 -18.688  19.435  1.00 63.25           C  
ATOM    668  O   ALA A  90      26.177 -19.611  18.620  1.00 62.70           O  
ATOM    669  CB  ALA A  90      26.989 -19.359  21.641  1.00 64.18           C  
ATOM    670  N   HIS A  91      25.004 -17.882  19.469  1.00 61.91           N  
ATOM    671  CA  HIS A  91      23.879 -18.036  18.545  1.00 59.65           C  
ATOM    672  C   HIS A  91      23.890 -17.094  17.344  1.00 57.36           C  
ATOM    673  O   HIS A  91      24.245 -15.923  17.453  1.00 56.48           O  
ATOM    674  CB  HIS A  91      22.573 -17.901  19.320  1.00 59.70           C  
ATOM    675  CG  HIS A  91      22.266 -19.098  20.160  1.00 60.15           C  
ATOM    676  ND1 HIS A  91      21.776 -20.270  19.626  1.00 60.25           N  
ATOM    677  CD2 HIS A  91      22.435 -19.330  21.484  1.00 59.06           C  
ATOM    678  CE1 HIS A  91      21.656 -21.174  20.583  1.00 59.69           C  
ATOM    679  NE2 HIS A  91      22.051 -20.627  21.720  1.00 60.26           N  
ATOM    680  N   CYS A  92      23.494 -17.628  16.197  1.00 54.54           N  
ATOM    681  CA  CYS A  92      23.468 -16.868  14.958  1.00 52.65           C  
ATOM    682  C   CYS A  92      22.384 -17.457  14.053  1.00 50.54           C  
ATOM    683  O   CYS A  92      22.232 -18.676  13.984  1.00 51.37           O  
ATOM    684  CB  CYS A  92      24.842 -16.962  14.278  1.00 53.48           C  
ATOM    685  SG  CYS A  92      25.084 -15.885  12.842  1.00 57.97           S  
ATOM    686  N   LEU A  93      21.627 -16.603  13.370  1.00 47.36           N  
ATOM    687  CA  LEU A  93      20.565 -17.076  12.483  1.00 45.09           C  
ATOM    688  C   LEU A  93      21.065 -17.297  11.061  1.00 44.21           C  
ATOM    689  O   LEU A  93      21.930 -16.563  10.571  1.00 44.19           O  
ATOM    690  CB  LEU A  93      19.407 -16.072  12.438  1.00 45.11           C  
ATOM    691  CG  LEU A  93      18.635 -15.679  13.699  1.00 45.01           C  
ATOM    692  CD1 LEU A  93      17.482 -14.761  13.323  1.00 43.56           C  
ATOM    693  CD2 LEU A  93      18.111 -16.914  14.381  1.00 46.35           C  
ATOM    694  N   LYS A  94      20.519 -18.302  10.385  1.00 42.01           N  
ATOM    695  CA  LYS A  94      20.929 -18.559   9.012  1.00 41.46           C  
ATOM    696  C   LYS A  94      20.362 -17.428   8.156  1.00 42.28           C  
ATOM    697  O   LYS A  94      19.260 -16.925   8.414  1.00 40.10           O  
ATOM    698  CB  LYS A  94      20.413 -19.922   8.532  1.00 39.67           C  
ATOM    699  CG  LYS A  94      20.888 -20.296   7.142  1.00 37.59           C  
ATOM    700  CD  LYS A  94      20.516 -21.723   6.781  1.00 38.34           C  
ATOM    701  CE  LYS A  94      21.006 -22.098   5.374  1.00 38.00           C  
ATOM    702  NZ  LYS A  94      20.513 -23.432   4.888  1.00 36.42           N  
ATOM    703  N   THR A  95      21.133 -17.028   7.147  1.00 43.60           N  
ATOM    704  CA  THR A  95      20.754 -15.939   6.249  1.00 45.40           C  
ATOM    705  C   THR A  95      20.658 -16.360   4.790  1.00 45.11           C  
ATOM    706  O   THR A  95      21.281 -17.326   4.372  1.00 46.95           O  
ATOM    707  CB  THR A  95      21.772 -14.792   6.318  1.00 47.19           C  
ATOM    708  OG1 THR A  95      23.090 -15.325   6.133  1.00 49.65           O  
ATOM    709  CG2 THR A  95      21.690 -14.080   7.662  1.00 48.55           C  
ATOM    710  N   TRP A  96      19.873 -15.619   4.020  1.00 44.69           N  
ATOM    711  CA  TRP A  96      19.709 -15.885   2.596  1.00 44.59           C  
ATOM    712  C   TRP A  96      19.888 -14.581   1.823  1.00 44.19           C  
ATOM    713  O   TRP A  96      19.295 -13.564   2.178  1.00 41.97           O  
ATOM    714  CB  TRP A  96      18.319 -16.453   2.312  1.00 45.31           C  
ATOM    715  CG  TRP A  96      18.165 -17.910   2.638  1.00 46.03           C  
ATOM    716  CD1 TRP A  96      18.249 -18.960   1.766  1.00 45.64           C  
ATOM    717  CD2 TRP A  96      17.871 -18.474   3.919  1.00 44.92           C  
ATOM    718  NE1 TRP A  96      18.019 -20.141   2.426  1.00 45.32           N  
ATOM    719  CE2 TRP A  96      17.785 -19.873   3.750  1.00 44.54           C  
ATOM    720  CE3 TRP A  96      17.669 -17.934   5.194  1.00 46.16           C  
ATOM    721  CZ2 TRP A  96      17.504 -20.742   4.810  1.00 44.07           C  
ATOM    722  CZ3 TRP A  96      17.388 -18.801   6.256  1.00 48.39           C  
ATOM    723  CH2 TRP A  96      17.310 -20.191   6.052  1.00 45.49           C  
ATOM    724  N   ARG A  97      20.704 -14.618   0.774  1.00 45.01           N  
ATOM    725  CA  ARG A  97      20.951 -13.436  -0.034  1.00 47.72           C  
ATOM    726  C   ARG A  97      19.664 -13.061  -0.775  1.00 48.56           C  
ATOM    727  O   ARG A  97      19.081 -13.892  -1.468  1.00 49.02           O  
ATOM    728  CB  ARG A  97      22.075 -13.712  -1.041  1.00 52.24           C  
ATOM    729  CG  ARG A  97      23.395 -14.219  -0.440  1.00 55.10           C  
ATOM    730  CD  ARG A  97      24.554 -13.868  -1.366  1.00 58.41           C  
ATOM    731  NE  ARG A  97      24.595 -12.420  -1.572  1.00 61.13           N  
ATOM    732  CZ  ARG A  97      25.198 -11.808  -2.589  1.00 62.52           C  
ATOM    733  NH1 ARG A  97      25.833 -12.518  -3.516  1.00 62.00           N  
ATOM    734  NH2 ARG A  97      25.145 -10.483  -2.690  1.00 60.80           N  
ATOM    735  N   VAL A  98      19.220 -11.815  -0.646  1.00 48.07           N  
ATOM    736  CA  VAL A  98      17.982 -11.400  -1.300  1.00 48.16           C  
ATOM    737  C   VAL A  98      18.071 -10.072  -2.061  1.00 49.01           C  
ATOM    738  O   VAL A  98      18.738  -9.133  -1.625  1.00 49.68           O  
ATOM    739  CB  VAL A  98      16.844 -11.302  -0.256  1.00 47.83           C  
ATOM    740  CG1 VAL A  98      15.542 -10.904  -0.923  1.00 48.70           C  
ATOM    741  CG2 VAL A  98      16.674 -12.625   0.443  1.00 48.64           C  
ATOM    742  N   THR A  99      17.384 -10.001  -3.199  1.00 49.59           N  
ATOM    743  CA  THR A  99      17.364  -8.786  -4.013  1.00 51.05           C  
ATOM    744  C   THR A  99      15.946  -8.461  -4.472  1.00 51.99           C  
ATOM    745  O   THR A  99      15.075  -9.335  -4.509  1.00 52.27           O  
ATOM    746  CB  THR A  99      18.253  -8.911  -5.263  1.00 49.51           C  
ATOM    747  OG1 THR A  99      17.856 -10.060  -6.028  1.00 49.23           O  
ATOM    748  CG2 THR A  99      19.706  -9.033  -4.857  1.00 49.17           C  
ATOM    749  N   VAL A 100      15.731  -7.195  -4.826  1.00 52.33           N  
ATOM    750  CA  VAL A 100      14.428  -6.722  -5.290  1.00 50.99           C  
ATOM    751  C   VAL A 100      14.615  -5.914  -6.570  1.00 51.96           C  
ATOM    752  O   VAL A 100      15.105  -4.787  -6.535  1.00 51.35           O  
ATOM    753  CB  VAL A 100      13.765  -5.821  -4.231  1.00 48.44           C  
ATOM    754  CG1 VAL A 100      12.332  -5.528  -4.621  1.00 44.55           C  
ATOM    755  CG2 VAL A 100      13.854  -6.487  -2.866  1.00 47.69           C  
ATOM    756  N   ASP A 101      14.229  -6.492  -7.700  1.00 53.83           N  
ATOM    757  CA  ASP A 101      14.365  -5.806  -8.971  1.00 55.93           C  
ATOM    758  C   ASP A 101      13.273  -4.766  -9.176  1.00 56.09           C  
ATOM    759  O   ASP A 101      13.448  -3.621  -8.768  1.00 57.98           O  
ATOM    760  CB  ASP A 101      14.401  -6.824 -10.097  1.00 58.75           C  
ATOM    761  CG  ASP A 101      15.587  -7.767  -9.969  1.00 63.03           C  
ATOM    762  OD1 ASP A 101      16.731  -7.255  -9.857  1.00 61.65           O  
ATOM    763  OD2 ASP A 101      15.378  -9.007  -9.963  1.00 65.36           O  
ATOM    764  N   ASP A 102      12.157  -5.117  -9.800  1.00 55.15           N  
ATOM    765  CA  ASP A 102      11.103  -4.115  -9.951  1.00 54.32           C  
ATOM    766  C   ASP A 102      10.438  -4.072  -8.588  1.00 53.49           C  
ATOM    767  O   ASP A 102      10.781  -3.249  -7.740  1.00 54.35           O  
ATOM    768  CB  ASP A 102      10.117  -4.530 -11.039  1.00 56.43           C  
ATOM    769  CG  ASP A 102      10.260  -3.690 -12.308  1.00 57.46           C  
ATOM    770  OD1 ASP A 102      11.356  -3.123 -12.553  1.00 56.63           O  
ATOM    771  OD2 ASP A 102       9.270  -3.607 -13.064  1.00 57.19           O  
ATOM    772  N   ASN A 103       9.480  -4.957  -8.377  1.00 51.92           N  
ATOM    773  CA  ASN A 103       8.843  -5.067  -7.076  1.00 49.28           C  
ATOM    774  C   ASN A 103       8.879  -6.558  -6.827  1.00 47.81           C  
ATOM    775  O   ASN A 103       8.093  -7.113  -6.065  1.00 50.00           O  
ATOM    776  CB  ASN A 103       7.411  -4.535  -7.099  1.00 47.29           C  
ATOM    777  CG  ASN A 103       7.345  -3.051  -6.799  1.00 45.90           C  
ATOM    778  OD1 ASN A 103       7.940  -2.574  -5.831  1.00 41.64           O  
ATOM    779  ND2 ASN A 103       6.613  -2.312  -7.625  1.00 47.32           N  
ATOM    780  N   GLN A 104       9.827  -7.192  -7.500  1.00 46.32           N  
ATOM    781  CA  GLN A 104      10.019  -8.622  -7.415  1.00 45.44           C  
ATOM    782  C   GLN A 104      11.109  -8.925  -6.412  1.00 44.65           C  
ATOM    783  O   GLN A 104      12.252  -8.475  -6.554  1.00 45.97           O  
ATOM    784  CB  GLN A 104      10.416  -9.178  -8.786  1.00 44.82           C  
ATOM    785  CG  GLN A 104      10.578 -10.674  -8.826  1.00 43.09           C  
ATOM    786  CD  GLN A 104       9.328 -11.381  -8.368  1.00 47.09           C  
ATOM    787  OE1 GLN A 104       8.242 -11.152  -8.900  1.00 47.58           O  
ATOM    788  NE2 GLN A 104       9.467 -12.243  -7.366  1.00 48.24           N  
ATOM    789  N   VAL A 105      10.755  -9.674  -5.381  1.00 41.93           N  
ATOM    790  CA  VAL A 105      11.735 -10.045  -4.385  1.00 39.83           C  
ATOM    791  C   VAL A 105      12.202 -11.448  -4.740  1.00 40.48           C  
ATOM    792  O   VAL A 105      11.391 -12.347  -4.942  1.00 40.86           O  
ATOM    793  CB  VAL A 105      11.133 -10.033  -2.982  1.00 36.69           C  
ATOM    794  CG1 VAL A 105      12.168 -10.456  -1.978  1.00 34.34           C  
ATOM    795  CG2 VAL A 105      10.619  -8.645  -2.674  1.00 35.23           C  
ATOM    796  N   CYS A 106      13.510 -11.623  -4.852  1.00 40.42           N  
ATOM    797  CA  CYS A 106      14.063 -12.919  -5.196  1.00 41.61           C  
ATOM    798  C   CYS A 106      15.121 -13.333  -4.191  1.00 43.64           C  
ATOM    799  O   CYS A 106      15.609 -12.517  -3.407  1.00 43.89           O  
ATOM    800  CB  CYS A 106      14.721 -12.867  -6.582  1.00 40.26           C  
ATOM    801  SG  CYS A 106      13.638 -12.584  -7.986  1.00 40.46           S  
ATOM    802  N   TYR A 107      15.476 -14.607  -4.212  1.00 45.76           N  
ATOM    803  CA  TYR A 107      16.541 -15.083  -3.353  1.00 49.53           C  
ATOM    804  C   TYR A 107      17.591 -15.607  -4.327  1.00 53.22           C  
ATOM    805  O   TYR A 107      17.257 -16.099  -5.404  1.00 54.63           O  
ATOM    806  CB  TYR A 107      16.030 -16.161  -2.399  1.00 48.46           C  
ATOM    807  CG  TYR A 107      15.693 -17.495  -3.000  1.00 48.45           C  
ATOM    808  CD1 TYR A 107      16.676 -18.466  -3.193  1.00 49.71           C  
ATOM    809  CD2 TYR A 107      14.378 -17.831  -3.285  1.00 50.45           C  
ATOM    810  CE1 TYR A 107      16.345 -19.757  -3.646  1.00 49.95           C  
ATOM    811  CE2 TYR A 107      14.033 -19.117  -3.742  1.00 51.52           C  
ATOM    812  CZ  TYR A 107      15.019 -20.076  -3.915  1.00 50.49           C  
ATOM    813  OH  TYR A 107      14.662 -21.348  -4.317  1.00 49.10           O  
ATOM    814  N   LEU A 108      18.861 -15.477  -3.974  1.00 57.15           N  
ATOM    815  CA  LEU A 108      19.926 -15.921  -4.862  1.00 60.44           C  
ATOM    816  C   LEU A 108      20.348 -17.356  -4.552  1.00 63.17           C  
ATOM    817  O   LEU A 108      20.704 -17.672  -3.415  1.00 64.02           O  
ATOM    818  CB  LEU A 108      21.115 -14.958  -4.737  1.00 60.07           C  
ATOM    819  CG  LEU A 108      20.727 -13.482  -4.931  1.00 59.56           C  
ATOM    820  CD1 LEU A 108      21.899 -12.570  -4.604  1.00 58.96           C  
ATOM    821  CD2 LEU A 108      20.255 -13.266  -6.358  1.00 58.05           C  
ATOM    822  N   ALA A 109      20.296 -18.218  -5.567  1.00 65.39           N  
ATOM    823  CA  ALA A 109      20.672 -19.626  -5.414  1.00 68.54           C  
ATOM    824  C   ALA A 109      22.018 -19.950  -6.073  1.00 70.96           C  
ATOM    825  O   ALA A 109      22.834 -19.059  -6.312  1.00 71.50           O  
ATOM    826  CB  ALA A 109      19.577 -20.528  -5.991  1.00 67.34           C  
ATOM    827  N   LYS A 110      22.238 -21.232  -6.362  1.00 73.30           N  
ATOM    828  CA  LYS A 110      23.472 -21.695  -7.002  1.00 75.77           C  
ATOM    829  C   LYS A 110      23.102 -22.516  -8.244  1.00 77.96           C  
ATOM    830  O   LYS A 110      22.140 -22.171  -8.932  1.00 78.64           O  
ATOM    831  CB  LYS A 110      24.278 -22.543  -6.014  1.00 75.37           C  
ATOM    832  CG  LYS A 110      24.389 -21.914  -4.626  1.00 75.14           C  
ATOM    833  CD  LYS A 110      25.375 -22.653  -3.719  1.00 74.78           C  
ATOM    834  CE  LYS A 110      26.825 -22.395  -4.118  1.00 74.65           C  
ATOM    835  NZ  LYS A 110      27.784 -23.103  -3.222  1.00 73.42           N  
ATOM    836  N   GLU A 111      23.853 -23.581  -8.545  1.00 79.85           N  
ATOM    837  CA  GLU A 111      23.532 -24.421  -9.709  1.00 81.08           C  
ATOM    838  C   GLU A 111      24.472 -25.613  -9.981  1.00 81.88           C  
ATOM    839  O   GLU A 111      24.893 -26.297  -9.045  1.00 82.54           O  
ATOM    840  CB  GLU A 111      23.412 -23.544 -10.961  1.00 81.45           C  
ATOM    841  CG  GLU A 111      22.008 -23.546 -11.560  1.00 82.79           C  
ATOM    842  CD  GLU A 111      21.774 -22.394 -12.530  1.00 84.35           C  
ATOM    843  OE1 GLU A 111      20.713 -22.382 -13.193  1.00 84.51           O  
ATOM    844  OE2 GLU A 111      22.645 -21.497 -12.624  1.00 85.20           O  
ATOM    845  N   LEU A 112      24.779 -25.860 -11.258  1.00 82.18           N  
ATOM    846  CA  LEU A 112      25.652 -26.970 -11.690  1.00 82.02           C  
ATOM    847  C   LEU A 112      24.915 -28.314 -11.742  1.00 82.30           C  
ATOM    848  O   LEU A 112      24.795 -28.889 -12.851  1.00 81.82           O  
ATOM    849  CB  LEU A 112      26.882 -27.112 -10.774  1.00 81.00           C  
ATOM    850  CG  LEU A 112      28.184 -26.352 -11.041  1.00 79.12           C  
ATOM    851  CD1 LEU A 112      29.206 -26.747  -9.980  1.00 77.36           C  
ATOM    852  CD2 LEU A 112      28.708 -26.686 -12.427  1.00 78.72           C  
TER     853      LEU A 112                                                      
END
MOLECULE T0391.pdb
ATOM      1  N   LYS    14      20.058 -27.031  -4.627  1.00 60.80           N  
ATOM      2  CA  LYS    14      18.878 -26.160  -4.323  1.00 60.75           C  
ATOM      3  C   LYS    14      19.298 -24.755  -3.828  1.00 60.82           C  
ATOM      4  O   LYS    14      18.794 -24.243  -2.809  1.00 60.89           O  
ATOM      5  CB  LYS    14      17.912 -26.875  -3.349  1.00 60.75           C  
ATOM      6  CG  LYS    14      18.148 -26.678  -1.832  1.00 60.46           C  
ATOM      7  CD  LYS    14      19.239 -27.549  -1.251  1.00 60.49           C  
ATOM      8  CE  LYS    14      19.374 -27.296   0.246  1.00 60.57           C  
ATOM      9  NZ  LYS    14      20.401 -28.172   0.889  1.00 60.29           N  
ATOM     10  N   TYR    15      20.208 -24.127  -4.570  1.00 60.44           N  
ATOM     11  CA  TYR    15      20.748 -22.827  -4.172  1.00 60.31           C  
ATOM     12  C   TYR    15      20.596 -21.697  -5.214  1.00 60.11           C  
ATOM     13  O   TYR    15      21.466 -20.821  -5.310  1.00 60.31           O  
ATOM     14  CB  TYR    15      22.220 -22.960  -3.731  1.00 60.66           C  
ATOM     15  CG  TYR    15      22.442 -23.716  -2.429  1.00 60.97           C  
ATOM     16  CD1 TYR    15      22.806 -25.063  -2.440  1.00 60.98           C  
ATOM     17  CD2 TYR    15      22.302 -23.081  -1.190  1.00 60.95           C  
ATOM     18  CE1 TYR    15      23.019 -25.762  -1.253  1.00 61.49           C  
ATOM     19  CE2 TYR    15      22.510 -23.773   0.005  1.00 60.54           C  
ATOM     20  CZ  TYR    15      22.870 -25.113  -0.036  1.00 61.22           C  
ATOM     21  OH  TYR    15      23.090 -25.813   1.132  1.00 61.20           O  
ATOM     22  N   THR    16      19.512 -21.700  -5.992  1.00 59.68           N  
ATOM     23  CA  THR    16      19.188 -20.514  -6.815  1.00 59.63           C  
ATOM     24  C   THR    16      17.836 -19.878  -6.426  1.00 58.97           C  
ATOM     25  O   THR    16      17.024 -20.493  -5.734  1.00 58.66           O  
ATOM     26  CB  THR    16      19.340 -20.760  -8.367  1.00 59.50           C  
ATOM     27  OG1 THR    16      20.712 -21.057  -8.684  1.00 60.71           O  
ATOM     28  CG2 THR    16      18.927 -19.524  -9.191  1.00 59.37           C  
ATOM     29  N   SER    17      17.657 -18.629  -6.856  1.00 59.10           N  
ATOM     30  CA  SER    17      16.500 -17.778  -6.591  1.00 59.12           C  
ATOM     31  C   SER    17      15.164 -18.496  -6.522  1.00 59.74           C  
ATOM     32  O   SER    17      14.808 -19.277  -7.416  1.00 58.25           O  
ATOM     33  CB  SER    17      16.366 -16.691  -7.673  1.00 59.23           C  
ATOM     34  OG  SER    17      17.578 -15.976  -7.871  1.00 60.17           O  
ATOM     35  N   VAL    18      14.428 -18.199  -5.452  1.00 59.57           N  
ATOM     36  CA  VAL    18      13.002 -18.454  -5.422  1.00 59.94           C  
ATOM     37  C   VAL    18      12.366 -17.085  -5.284  1.00 60.39           C  
ATOM     38  O   VAL    18      12.744 -16.309  -4.419  1.00 59.98           O  
ATOM     39  CB  VAL    18      12.613 -19.377  -4.253  1.00 59.90           C  
ATOM     40  CG1 VAL    18      11.086 -19.572  -4.178  1.00 59.62           C  
ATOM     41  CG2 VAL    18      13.318 -20.729  -4.393  1.00 59.73           C  
ATOM     42  N   CYS    19      11.436 -16.772  -6.177  1.00 62.03           N  
ATOM     43  CA  CYS    19      10.675 -15.546  -6.087  1.00 62.30           C  
ATOM     44  C   CYS    19       9.657 -15.686  -4.943  1.00 62.67           C  
ATOM     45  O   CYS    19       8.778 -16.538  -4.994  1.00 63.44           O  
ATOM     46  CB  CYS    19       9.969 -15.293  -7.396  1.00 62.62           C  
ATOM     47  SG  CYS    19       9.161 -13.703  -7.475  1.00 64.96           S  
ATOM     48  N   VAL    20       9.769 -14.851  -3.922  1.00 61.58           N  
ATOM     49  CA  VAL    20       8.958 -15.045  -2.708  1.00 61.49           C  
ATOM     50  C   VAL    20       7.766 -14.103  -2.702  1.00 62.35           C  
ATOM     51  O   VAL    20       6.872 -14.191  -1.856  1.00 63.15           O  
ATOM     52  CB  VAL    20       9.817 -14.911  -1.438  1.00 61.03           C  
ATOM     53  CG1 VAL    20      10.940 -15.911  -1.487  1.00 60.15           C  
ATOM     54  CG2 VAL    20      10.377 -13.514  -1.277  1.00 59.18           C  
ATOM     55  N   GLY    21       7.748 -13.211  -3.677  1.00 62.13           N  
ATOM     56  CA  GLY    21       6.681 -12.283  -3.790  1.00 62.19           C  
ATOM     57  C   GLY    21       7.038 -10.922  -4.329  1.00 62.64           C  
ATOM     58  O   GLY    21       8.104 -10.689  -4.947  1.00 62.35           O  
ATOM     59  N   ARG    22       6.090 -10.026  -4.089  1.00 62.17           N  
ATOM     60  CA  ARG    22       6.044  -8.731  -4.705  1.00 62.01           C  
ATOM     61  C   ARG    22       6.671  -7.685  -3.777  1.00 61.91           C  
ATOM     62  O   ARG    22       6.357  -7.629  -2.585  1.00 60.50           O  
ATOM     63  CB  ARG    22       4.576  -8.423  -4.962  1.00 62.52           C  
ATOM     64  CG  ARG    22       4.336  -7.596  -6.112  1.00 62.38           C  
ATOM     65  CD  ARG    22       2.862  -7.377  -6.307  1.00 63.37           C  
ATOM     66  NE  ARG    22       2.766  -6.247  -7.197  1.00 63.29           N  
ATOM     67  CZ  ARG    22       1.689  -5.863  -7.852  1.00 63.14           C  
ATOM     68  NH1 ARG    22       0.531  -6.515  -7.735  1.00 64.35           N  
ATOM     69  NH2 ARG    22       1.798  -4.807  -8.631  1.00 63.71           N  
ATOM     70  N   GLU    23       7.582  -6.874  -4.323  1.00 62.10           N  
ATOM     71  CA  GLU    23       8.103  -5.723  -3.602  1.00 62.33           C  
ATOM     72  C   GLU    23       6.970  -4.911  -2.955  1.00 62.52           C  
ATOM     73  O   GLU    23       7.045  -4.564  -1.781  1.00 63.44           O  
ATOM     74  CB  GLU    23       8.955  -4.850  -4.518  1.00 62.11           C  
ATOM     75  CG  GLU    23       9.910  -3.962  -3.752  1.00 63.73           C  
ATOM     76  CD  GLU    23      11.098  -3.492  -4.568  1.00 66.02           C  
ATOM     77  OE1 GLU    23      10.913  -3.119  -5.754  1.00 65.65           O  
ATOM     78  OE2 GLU    23      12.214  -3.482  -4.000  1.00 68.05           O  
ATOM     79  N   GLU    24       5.899  -4.665  -3.694  1.00 62.66           N  
ATOM     80  CA  GLU    24       4.773  -3.927  -3.141  1.00 63.27           C  
ATOM     81  C   GLU    24       4.077  -4.577  -1.938  1.00 63.16           C  
ATOM     82  O   GLU    24       3.586  -3.872  -1.053  1.00 63.14           O  
ATOM     83  CB  GLU    24       3.737  -3.650  -4.220  1.00 63.14           C  
ATOM     84  CG  GLU    24       4.183  -2.647  -5.259  1.00 65.00           C  
ATOM     85  CD  GLU    24       3.009  -2.112  -6.065  1.00 65.66           C  
ATOM     86  OE1 GLU    24       1.919  -2.735  -5.998  1.00 65.11           O  
ATOM     87  OE2 GLU    24       3.167  -1.071  -6.749  1.00 66.96           O  
ATOM     88  N   ASP    25       4.034  -5.902  -1.911  0.70 63.36           N  
ATOM     90  CA  ASP    25       3.305  -6.600  -0.868  0.70 63.79           C  
ATOM     92  C   ASP    25       4.028  -6.560   0.493  0.70 64.46           C  
ATOM     94  O   ASP    25       3.372  -6.638   1.542  0.70 64.77           O  
ATOM     96  CB  ASP    25       2.955  -8.031  -1.327  0.70 63.62           C  
ATOM     98  CG  ASP    25       1.892  -8.063  -2.468  0.70 63.86           C  
ATOM    100  OD1 ASP    25       1.400  -6.997  -2.932  0.70 61.48           O  
ATOM    102  OD2 ASP    25       1.538  -9.184  -2.900  0.70 64.42           O  
ATOM    104  N   ILE    26       5.358  -6.389   0.475  1.00 64.67           N  
ATOM    105  CA  ILE    26       6.187  -6.428   1.701  1.00 65.33           C  
ATOM    106  C   ILE    26       6.448  -5.038   2.254  1.00 66.28           C  
ATOM    107  O   ILE    26       6.715  -4.879   3.435  1.00 65.81           O  
ATOM    108  CB  ILE    26       7.568  -7.115   1.511  1.00 65.79           C  
ATOM    109  CG1 ILE    26       8.114  -7.590   2.873  1.00 65.49           C  
ATOM    110  CG2 ILE    26       8.578  -6.164   0.865  1.00 65.24           C  
ATOM    111  CD1 ILE    26       9.526  -8.114   2.841  1.00 64.46           C  
ATOM    112  N   ARG    27       6.376  -4.026   1.393  1.00 67.72           N  
ATOM    113  CA  ARG    27       6.661  -2.672   1.844  1.00 68.35           C  
ATOM    114  C   ARG    27       5.635  -2.232   2.887  1.00 68.20           C  
ATOM    115  O   ARG    27       6.004  -1.667   3.921  1.00 68.03           O  
ATOM    116  CB  ARG    27       6.823  -1.716   0.661  1.00 68.79           C  
ATOM    117  CG  ARG    27       8.136  -2.014  -0.065  1.00 70.71           C  
ATOM    118  CD  ARG    27       8.676  -0.888  -0.957  1.00 74.28           C  
ATOM    119  NE  ARG    27      10.113  -1.118  -1.136  1.00 76.73           N  
ATOM    120  CZ  ARG    27      10.900  -0.543  -2.046  1.00 77.51           C  
ATOM    121  NH1 ARG    27      10.418   0.335  -2.925  1.00 77.15           N  
ATOM    122  NH2 ARG    27      12.190  -0.862  -2.073  1.00 77.51           N  
ATOM    123  N   LYS    28       4.372  -2.577   2.641  1.00 68.05           N  
ATOM    124  CA  LYS    28       3.278  -2.331   3.573  1.00 67.84           C  
ATOM    125  C   LYS    28       3.515  -2.907   4.993  1.00 67.37           C  
ATOM    126  O   LYS    28       3.664  -2.148   5.957  1.00 67.14           O  
ATOM    127  CB  LYS    28       1.968  -2.845   2.957  1.00 68.52           C  
ATOM    128  CG  LYS    28       0.709  -2.558   3.781  1.00 69.95           C  
ATOM    129  CD  LYS    28      -0.479  -2.274   2.855  1.00 72.90           C  
ATOM    130  CE  LYS    28      -1.783  -2.048   3.625  1.00 74.32           C  
ATOM    131  NZ  LYS    28      -2.286  -3.344   4.158  1.00 76.24           N  
ATOM    132  N   SER    29       3.569  -4.235   5.119  1.00 66.72           N  
ATOM    133  CA  SER    29       3.748  -4.885   6.425  1.00 66.15           C  
ATOM    134  C   SER    29       5.187  -4.873   6.935  1.00 64.97           C  
ATOM    135  O   SER    29       5.459  -5.154   8.118  1.00 65.03           O  
ATOM    136  CB  SER    29       3.311  -6.336   6.336  1.00 66.89           C  
ATOM    137  OG  SER    29       4.355  -7.108   5.765  1.00 69.45           O  
ATOM    138  N   GLU    30       6.122  -4.606   6.034  1.00 62.79           N  
ATOM    139  CA  GLU    30       7.546  -4.652   6.367  1.00 60.91           C  
ATOM    140  C   GLU    30       8.128  -6.009   6.779  1.00 58.63           C  
ATOM    141  O   GLU    30       9.300  -6.064   7.176  1.00 57.90           O  
ATOM    142  CB  GLU    30       7.939  -3.541   7.349  1.00 61.73           C  
ATOM    143  CG  GLU    30       8.166  -2.226   6.596  1.00 64.11           C  
ATOM    144  CD  GLU    30       8.775  -1.124   7.442  1.00 68.01           C  
ATOM    145  OE1 GLU    30       8.252  -0.881   8.554  1.00 68.86           O  
ATOM    146  OE2 GLU    30       9.756  -0.484   6.970  1.00 69.07           O  
ATOM    147  N   ARG    31       7.333  -7.073   6.654  1.00 55.43           N  
ATOM    148  CA  ARG    31       7.814  -8.461   6.773  1.00 54.94           C  
ATOM    149  C   ARG    31       6.873  -9.468   6.122  1.00 55.34           C  
ATOM    150  O   ARG    31       5.669  -9.251   6.054  1.00 53.56           O  
ATOM    151  CB  ARG    31       8.017  -8.868   8.213  1.00 53.83           C  
ATOM    152  CG  ARG    31       6.689  -9.135   8.913  1.00 56.18           C  
ATOM    153  CD  ARG    31       6.870  -9.241  10.351  1.00 54.41           C  
ATOM    154  NE  ARG    31       7.484  -8.051  10.931  1.00 47.57           N  
ATOM    155  CZ  ARG    31       7.953  -8.038  12.168  1.00 43.51           C  
ATOM    156  NH1 ARG    31       7.864  -9.153  12.893  1.00 42.00           N  
ATOM    157  NH2 ARG    31       8.477  -6.939  12.679  1.00 40.05           N  
ATOM    158  N   MET    32       7.432 -10.587   5.679  1.00 57.33           N  
ATOM    159  CA  MET    32       6.647 -11.708   5.128  1.00 60.41           C  
ATOM    160  C   MET    32       7.435 -12.995   5.296  1.00 59.05           C  
ATOM    161  O   MET    32       8.664 -12.974   5.342  1.00 60.30           O  
ATOM    162  CB  MET    32       6.358 -11.492   3.619  1.00 59.37           C  
ATOM    163  CG  MET    32       7.571 -11.596   2.693  1.00 63.82           C  
ATOM    164  SD  MET    32       7.112 -11.204   0.978  1.00 69.27           S  
ATOM    165  CE  MET    32       5.647 -10.216   1.194  1.00 68.77           C  
ATOM    166  N   THR    33       6.752 -14.125   5.326  1.00 57.39           N  
ATOM    167  CA  THR    33       7.468 -15.385   5.383  1.00 55.82           C  
ATOM    168  C   THR    33       7.420 -16.058   3.993  1.00 56.31           C  
ATOM    169  O   THR    33       6.532 -15.751   3.131  1.00 54.99           O  
ATOM    170  CB  THR    33       6.882 -16.321   6.457  1.00 56.65           C  
ATOM    171  OG1 THR    33       5.603 -16.815   5.987  1.00 56.10           O  
ATOM    172  CG2 THR    33       6.697 -15.553   7.836  1.00 55.74           C  
ATOM    173  N   ALA    34       8.335 -16.989   3.761  1.00 54.34           N  
ATOM    174  CA  ALA    34       8.184 -17.826   2.570  1.00 54.83           C  
ATOM    175  C   ALA    34       8.807 -19.181   2.790  1.00 53.98           C  
ATOM    176  O   ALA    34       9.635 -19.352   3.681  1.00 53.23           O  
ATOM    177  CB  ALA    34       8.816 -17.148   1.365  1.00 55.64           C  
ATOM    178  N   VAL    35       8.422 -20.150   1.969  1.00 52.71           N  
ATOM    179  CA  VAL    35       9.146 -21.419   1.963  1.00 51.53           C  
ATOM    180  C   VAL    35      10.059 -21.440   0.736  1.00 50.48           C  
ATOM    181  O   VAL    35       9.597 -21.267  -0.405  1.00 50.86           O  
ATOM    182  CB  VAL    35       8.199 -22.656   2.139  1.00 51.55           C  
ATOM    183  CG1 VAL    35       8.927 -23.938   1.867  1.00 51.62           C  
ATOM    184  CG2 VAL    35       7.649 -22.678   3.595  1.00 51.89           C  
ATOM    185  N   VAL    36      11.358 -21.607   0.993  1.00 47.93           N  
ATOM    186  CA  VAL    36      12.369 -21.552  -0.052  1.00 46.54           C  
ATOM    187  C   VAL    36      13.108 -22.885  -0.044  1.00 46.09           C  
ATOM    188  O   VAL    36      13.795 -23.191   0.917  1.00 45.92           O  
ATOM    189  CB  VAL    36      13.329 -20.352   0.148  1.00 46.45           C  
ATOM    190  CG1 VAL    36      14.517 -20.414  -0.842  1.00 45.45           C  
ATOM    191  CG2 VAL    36      12.561 -19.045  -0.018  1.00 43.17           C  
ATOM    192  N   HIS    37      12.900 -23.698  -1.086  1.00 45.65           N  
ATOM    193  CA  HIS    37      13.449 -25.056  -1.162  1.00 45.17           C  
ATOM    194  C   HIS    37      13.275 -25.825   0.164  1.00 45.04           C  
ATOM    195  O   HIS    37      14.256 -26.313   0.741  1.00 45.28           O  
ATOM    196  CB  HIS    37      14.941 -25.015  -1.540  1.00 45.31           C  
ATOM    197  CG  HIS    37      15.243 -24.292  -2.824  1.00 45.88           C  
ATOM    198  ND1 HIS    37      14.568 -24.534  -4.004  1.00 46.39           N  
ATOM    199  CD2 HIS    37      16.190 -23.367  -3.117  1.00 46.19           C  
ATOM    200  CE1 HIS    37      15.074 -23.775  -4.962  1.00 46.61           C  
ATOM    201  NE2 HIS    37      16.058 -23.055  -4.449  1.00 45.87           N  
ATOM    202  N   ASP    38      12.041 -25.892   0.661  1.00 44.85           N  
ATOM    203  CA  ASP    38      11.706 -26.553   1.941  1.00 45.31           C  
ATOM    204  C   ASP    38      12.339 -25.925   3.206  1.00 45.08           C  
ATOM    205  O   ASP    38      12.315 -26.535   4.284  1.00 45.02           O  
ATOM    206  CB  ASP    38      12.026 -28.055   1.910  1.00 45.77           C  
ATOM    207  CG  ASP    38      11.383 -28.776   0.726  1.00 49.13           C  
ATOM    208  OD1 ASP    38      10.128 -28.791   0.650  1.00 51.40           O  
ATOM    209  OD2 ASP    38      12.135 -29.334  -0.124  1.00 51.32           O  
ATOM    210  N   ARG    39      12.917 -24.729   3.081  1.00 43.95           N  
ATOM    211  CA  ARG    39      13.413 -24.021   4.257  1.00 43.30           C  
ATOM    212  C   ARG    39      12.521 -22.812   4.452  1.00 42.56           C  
ATOM    213  O   ARG    39      12.335 -22.011   3.534  1.00 42.90           O  
ATOM    214  CB  ARG    39      14.865 -23.605   4.108  1.00 43.37           C  
ATOM    215  CG  ARG    39      15.608 -23.594   5.429  1.00 43.77           C  
ATOM    216  CD  ARG    39      17.029 -23.142   5.261  1.00 45.03           C  
ATOM    217  NE  ARG    39      17.674 -23.029   6.560  1.00 45.90           N  
ATOM    218  CZ  ARG    39      18.700 -23.769   6.945  1.00 43.80           C  
ATOM    219  NH1 ARG    39      19.211 -24.648   6.103  1.00 43.43           N  
ATOM    220  NH2 ARG    39      19.216 -23.604   8.157  1.00 40.35           N  
ATOM    221  N   GLU    40      11.915 -22.727   5.625  1.00 41.87           N  
ATOM    222  CA  GLU    40      11.019 -21.619   5.932  1.00 40.70           C  
ATOM    223  C   GLU    40      11.814 -20.418   6.451  1.00 40.21           C  
ATOM    224  O   GLU    40      12.671 -20.553   7.321  1.00 39.91           O  
ATOM    225  CB  GLU    40       9.926 -22.041   6.911  1.00 41.02           C  
ATOM    226  CG  GLU    40       8.775 -21.074   6.870  1.00 41.02           C  
ATOM    227  CD  GLU    40       7.670 -21.402   7.819  1.00 45.48           C  
ATOM    228  OE1 GLU    40       7.862 -22.213   8.771  1.00 46.20           O  
ATOM    229  OE2 GLU    40       6.581 -20.845   7.575  1.00 44.48           O  
ATOM    230  N   VAL    41      11.578 -19.259   5.838  1.00 39.09           N  
ATOM    231  CA  VAL    41      12.354 -18.057   6.115  1.00 37.88           C  
ATOM    232  C   VAL    41      11.436 -16.887   6.414  1.00 37.27           C  
ATOM    233  O   VAL    41      10.267 -16.869   6.008  1.00 36.57           O  
ATOM    234  CB  VAL    41      13.326 -17.655   4.896  1.00 37.87           C  
ATOM    235  CG1 VAL    41      14.182 -18.804   4.466  1.00 36.47           C  
ATOM    236  CG2 VAL    41      12.531 -17.210   3.656  1.00 38.60           C  
ATOM    237  N   VAL    42      11.998 -15.867   7.049  1.00 36.63           N  
ATOM    238  CA  VAL    42      11.308 -14.631   7.203  1.00 35.76           C  
ATOM    239  C   VAL    42      12.103 -13.576   6.456  1.00 36.42           C  
ATOM    240  O   VAL    42      13.302 -13.561   6.538  1.00 34.56           O  
ATOM    241  CB  VAL    42      11.050 -14.279   8.729  1.00 36.00           C  
ATOM    242  CG1 VAL    42      12.356 -14.284   9.550  1.00 31.47           C  
ATOM    243  CG2 VAL    42      10.244 -12.935   8.858  1.00 36.12           C  
ATOM    244  N   ILE    43      11.423 -12.711   5.705  1.00 36.07           N  
ATOM    245  CA  ILE    43      12.088 -11.573   5.057  1.00 35.72           C  
ATOM    246  C   ILE    43      11.611 -10.312   5.753  1.00 35.08           C  
ATOM    247  O   ILE    43      10.425 -10.130   5.901  1.00 34.92           O  
ATOM    248  CB  ILE    43      11.748 -11.420   3.540  1.00 36.04           C  
ATOM    249  CG1 ILE    43      12.131 -12.678   2.760  1.00 38.38           C  
ATOM    250  CG2 ILE    43      12.503 -10.221   2.900  1.00 35.84           C  
ATOM    251  CD1 ILE    43      10.953 -13.665   2.645  1.00 41.98           C  
ATOM    252  N   PHE    44      12.540  -9.455   6.170  1.00 35.27           N  
ATOM    253  CA  PHE    44      12.207  -8.159   6.750  1.00 35.90           C  
ATOM    254  C   PHE    44      12.611  -7.070   5.764  1.00 36.03           C  
ATOM    255  O   PHE    44      13.695  -7.104   5.206  1.00 36.06           O  
ATOM    256  CB  PHE    44      12.996  -7.939   8.051  1.00 35.55           C  
ATOM    257  CG  PHE    44      12.675  -8.944   9.149  1.00 35.15           C  
ATOM    258  CD1 PHE    44      11.461  -8.863   9.856  1.00 33.52           C  
ATOM    259  CD2 PHE    44      13.555  -9.953   9.456  1.00 35.10           C  
ATOM    260  CE1 PHE    44      11.145  -9.775  10.840  1.00 31.22           C  
ATOM    261  CE2 PHE    44      13.260 -10.834  10.490  1.00 33.69           C  
ATOM    262  CZ  PHE    44      12.043 -10.747  11.155  1.00 34.12           C  
ATOM    263  N   TYR    45      11.744  -6.094   5.576  1.00 36.13           N  
ATOM    264  CA  TYR    45      12.120  -4.861   4.896  1.00 37.49           C  
ATOM    265  C   TYR    45      12.253  -3.757   5.917  1.00 37.07           C  
ATOM    266  O   TYR    45      11.271  -3.380   6.534  1.00 38.99           O  
ATOM    267  CB  TYR    45      11.055  -4.484   3.898  1.00 36.98           C  
ATOM    268  CG  TYR    45      11.334  -3.182   3.158  1.00 39.78           C  
ATOM    269  CD1 TYR    45      12.338  -3.109   2.209  1.00 40.79           C  
ATOM    270  CD2 TYR    45      10.595  -2.037   3.421  1.00 38.05           C  
ATOM    271  CE1 TYR    45      12.605  -1.935   1.531  1.00 41.88           C  
ATOM    272  CE2 TYR    45      10.858  -0.857   2.763  1.00 41.50           C  
ATOM    273  CZ  TYR    45      11.862  -0.805   1.807  1.00 40.93           C  
ATOM    274  OH  TYR    45      12.120   0.387   1.114  1.00 40.29           O  
ATOM    275  N   HIS    46      13.443  -3.229   6.111  1.00 36.34           N  
ATOM    276  CA  HIS    46      13.652  -2.224   7.156  1.00 36.95           C  
ATOM    277  C   HIS    46      14.640  -1.131   6.693  1.00 37.04           C  
ATOM    278  O   HIS    46      15.718  -1.438   6.160  1.00 36.11           O  
ATOM    279  CB  HIS    46      14.162  -2.927   8.432  1.00 37.03           C  
ATOM    280  CG  HIS    46      14.389  -2.016   9.605  1.00 38.48           C  
ATOM    281  ND1 HIS    46      13.356  -1.460  10.337  1.00 40.30           N  
ATOM    282  CD2 HIS    46      15.530  -1.603  10.200  1.00 36.98           C  
ATOM    283  CE1 HIS    46      13.855  -0.725  11.315  1.00 38.56           C  
ATOM    284  NE2 HIS    46      15.171  -0.791  11.249  1.00 38.82           N  
ATOM    285  N   LYS    47      14.275   0.138   6.920  1.00 36.95           N  
ATOM    286  CA  LYS    47      15.099   1.269   6.525  1.00 37.47           C  
ATOM    287  C   LYS    47      15.604   1.065   5.095  1.00 37.40           C  
ATOM    288  O   LYS    47      16.817   1.170   4.821  1.00 36.64           O  
ATOM    289  CB  LYS    47      16.293   1.452   7.465  1.00 38.17           C  
ATOM    290  CG  LYS    47      15.974   1.813   8.904  1.00 40.46           C  
ATOM    291  CD  LYS    47      17.211   2.484   9.503  1.00 45.27           C  
ATOM    292  CE  LYS    47      17.181   2.580  11.022  1.00 47.38           C  
ATOM    293  NZ  LYS    47      17.861   1.421  11.685  1.00 50.94           N  
ATOM    294  N   GLY    48      14.674   0.731   4.194  1.00 37.40           N  
ATOM    295  CA  GLY    48      15.000   0.560   2.776  1.00 37.40           C  
ATOM    296  C   GLY    48      15.856  -0.636   2.402  1.00 37.80           C  
ATOM    297  O   GLY    48      16.304  -0.738   1.278  1.00 38.04           O  
ATOM    298  N   GLU    49      16.085  -1.556   3.336  1.00 38.38           N  
ATOM    299  CA  GLU    49      16.829  -2.797   3.029  1.00 38.96           C  
ATOM    300  C   GLU    49      16.071  -4.079   3.366  1.00 37.40           C  
ATOM    301  O   GLU    49      15.276  -4.102   4.272  1.00 37.65           O  
ATOM    302  CB  GLU    49      18.154  -2.817   3.788  1.00 38.83           C  
ATOM    303  CG  GLU    49      18.937  -1.583   3.524  1.00 43.50           C  
ATOM    304  CD  GLU    49      20.402  -1.850   3.556  1.00 48.39           C  
ATOM    305  OE1 GLU    49      20.835  -2.546   4.503  1.00 49.17           O  
ATOM    306  OE2 GLU    49      21.094  -1.373   2.622  1.00 51.30           O  
ATOM    307  N   TYR    50      16.403  -5.145   2.652  1.00 37.51           N  
ATOM    308  CA  TYR    50      15.783  -6.447   2.770  1.00 37.42           C  
ATOM    309  C   TYR    50      16.698  -7.402   3.513  1.00 37.93           C  
ATOM    310  O   TYR    50      17.897  -7.407   3.283  1.00 36.23           O  
ATOM    311  CB  TYR    50      15.475  -6.971   1.367  1.00 38.36           C  
ATOM    312  CG  TYR    50      14.401  -6.171   0.692  1.00 38.71           C  
ATOM    313  CD1 TYR    50      13.052  -6.451   0.947  1.00 41.30           C  
ATOM    314  CD2 TYR    50      14.714  -5.109  -0.176  1.00 39.45           C  
ATOM    315  CE1 TYR    50      12.043  -5.728   0.367  1.00 39.50           C  
ATOM    316  CE2 TYR    50      13.689  -4.361  -0.778  1.00 41.37           C  
ATOM    317  CZ  TYR    50      12.347  -4.688  -0.495  1.00 41.85           C  
ATOM    318  OH  TYR    50      11.300  -3.995  -1.058  1.00 39.83           O  
ATOM    319  N   HIS    51      16.156  -8.162   4.451  1.00 37.00           N  
ATOM    320  CA  HIS    51      16.962  -9.128   5.154  1.00 37.66           C  
ATOM    321  C   HIS    51      16.187 -10.409   5.256  1.00 38.22           C  
ATOM    322  O   HIS    51      15.034 -10.396   5.749  1.00 40.63           O  
ATOM    323  CB  HIS    51      17.362  -8.635   6.576  1.00 38.17           C  
ATOM    324  CG  HIS    51      17.992  -7.280   6.598  1.00 36.35           C  
ATOM    325  ND1 HIS    51      19.324  -7.072   6.311  1.00 36.15           N  
ATOM    326  CD2 HIS    51      17.462  -6.060   6.834  1.00 36.39           C  
ATOM    327  CE1 HIS    51      19.587  -5.780   6.377  1.00 36.16           C  
ATOM    328  NE2 HIS    51      18.475  -5.144   6.699  1.00 36.78           N  
ATOM    329  N   ALA    52      16.783 -11.510   4.813  1.00 36.23           N  
ATOM    330  CA  ALA    52      16.191 -12.852   4.974  1.00 35.83           C  
ATOM    331  C   ALA    52      16.956 -13.725   5.994  1.00 35.84           C  
ATOM    332  O   ALA    52      18.162 -13.772   5.971  1.00 35.96           O  
ATOM    333  CB  ALA    52      16.112 -13.564   3.635  1.00 34.44           C  
ATOM    334  N   MET    53      16.230 -14.425   6.860  1.00 35.98           N  
ATOM    335  CA  MET    53      16.856 -15.383   7.786  1.00 35.97           C  
ATOM    336  C   MET    53      15.895 -16.513   8.097  1.00 34.34           C  
ATOM    337  O   MET    53      14.698 -16.423   7.816  1.00 34.06           O  
ATOM    338  CB  MET    53      17.275 -14.682   9.102  1.00 34.38           C  
ATOM    339  CG  MET    53      16.059 -14.042   9.793  1.00 36.38           C  
ATOM    340  SD  MET    53      16.365 -13.290  11.396  1.00 37.83           S  
ATOM    341  CE  MET    53      17.224 -11.779  10.901  1.00 31.98           C  
ATOM    342  N   ASP    54      16.437 -17.570   8.692  1.00 35.49           N  
ATOM    343  CA  ASP    54      15.663 -18.709   9.166  1.00 35.03           C  
ATOM    344  C   ASP    54      14.594 -18.178  10.077  1.00 35.41           C  
ATOM    345  O   ASP    54      14.838 -17.266  10.883  1.00 36.46           O  
ATOM    346  CB  ASP    54      16.555 -19.680   9.974  1.00 36.35           C  
ATOM    347  CG  ASP    54      17.394 -20.595   9.089  1.00 37.52           C  
ATOM    348  OD1 ASP    54      17.092 -20.730   7.865  1.00 42.19           O  
ATOM    349  OD2 ASP    54      18.379 -21.187   9.608  1.00 36.00           O  
ATOM    350  N   ILE    55      13.400 -18.736   9.977  1.00 33.76           N  
ATOM    351  CA  ILE    55      12.271 -18.163  10.687  1.00 33.72           C  
ATOM    352  C   ILE    55      12.256 -18.488  12.189  1.00 34.09           C  
ATOM    353  O   ILE    55      11.846 -17.651  12.987  1.00 35.22           O  
ATOM    354  CB  ILE    55      10.909 -18.575  10.023  1.00 32.75           C  
ATOM    355  CG1 ILE    55       9.729 -17.838  10.671  1.00 34.08           C  
ATOM    356  CG2 ILE    55      10.649 -20.098  10.162  1.00 32.55           C  
ATOM    357  CD1 ILE    55       8.426 -17.928   9.803  1.00 33.04           C  
ATOM    358  N   ARG    56      12.676 -19.701  12.554  1.00 34.32           N  
ATOM    359  CA  ARG    56      12.678 -20.122  13.949  0.50 34.27           C  
ATOM    361  C   ARG    56      13.979 -19.728  14.679  1.00 35.02           C  
ATOM    362  O   ARG    56      15.105 -19.999  14.216  1.00 34.05           O  
ATOM    363  CB  ARG    56      12.392 -21.611  14.064  0.50 33.71           C  
ATOM    365  CG  ARG    56      11.174 -22.056  13.253  0.50 33.20           C  
ATOM    367  CD  ARG    56       9.863 -21.458  13.767  0.50 34.41           C  
ATOM    369  NE  ARG    56       8.811 -21.580  12.749  0.50 33.94           N  
ATOM    371  CZ  ARG    56       7.540 -21.219  12.904  0.50 33.39           C  
ATOM    373  NH1 ARG    56       7.124 -20.701  14.053  0.50 33.15           N  
ATOM    375  NH2 ARG    56       6.684 -21.388  11.901  0.50 30.53           N  
ATOM    377  N   CYS    57      13.782 -19.059  15.804  1.00 34.89           N  
ATOM    378  CA  CYS    57      14.857 -18.517  16.622  1.00 34.84           C  
ATOM    379  C   CYS    57      15.820 -19.605  17.046  1.00 35.33           C  
ATOM    380  O   CYS    57      15.405 -20.619  17.585  1.00 34.76           O  
ATOM    381  CB  CYS    57      14.258 -17.828  17.853  1.00 35.43           C  
ATOM    382  SG  CYS    57      15.469 -17.137  18.937  1.00 35.67           S  
ATOM    383  N   TYR    58      17.109 -19.375  16.835  1.00 33.56           N  
ATOM    384  CA  TYR    58      18.141 -20.335  17.256  1.00 34.44           C  
ATOM    385  C   TYR    58      18.123 -20.742  18.712  1.00 34.87           C  
ATOM    386  O   TYR    58      18.677 -21.797  19.032  1.00 35.22           O  
ATOM    387  CB  TYR    58      19.564 -19.805  16.955  1.00 32.35           C  
ATOM    388  CG  TYR    58      20.078 -18.730  17.956  1.00 32.86           C  
ATOM    389  CD1 TYR    58      19.791 -17.386  17.764  1.00 32.31           C  
ATOM    390  CD2 TYR    58      20.892 -19.078  19.025  1.00 26.69           C  
ATOM    391  CE1 TYR    58      20.280 -16.385  18.653  1.00 36.22           C  
ATOM    392  CE2 TYR    58      21.337 -18.112  19.962  1.00 32.60           C  
ATOM    393  CZ  TYR    58      21.100 -16.767  19.710  1.00 32.41           C  
ATOM    394  OH  TYR    58      21.552 -15.812  20.596  1.00 35.59           O  
ATOM    395  N   HIS    59      17.583 -19.901  19.596  1.00 34.43           N  
ATOM    396  CA  HIS    59      17.668 -20.152  21.034  1.00 33.97           C  
ATOM    397  C   HIS    59      16.815 -21.395  21.360  1.00 34.28           C  
ATOM    398  O   HIS    59      17.331 -22.404  21.833  1.00 33.47           O  
ATOM    399  CB  HIS    59      17.194 -18.912  21.838  1.00 34.01           C  
ATOM    400  CG  HIS    59      17.046 -19.170  23.316  1.00 31.90           C  
ATOM    401  ND1 HIS    59      15.913 -18.854  24.030  1.00 32.75           N  
ATOM    402  CD2 HIS    59      17.922 -19.688  24.212  1.00 31.88           C  
ATOM    403  CE1 HIS    59      16.070 -19.221  25.292  1.00 36.93           C  
ATOM    404  NE2 HIS    59      17.286 -19.723  25.432  1.00 36.41           N  
ATOM    405  N   SER    60      15.504 -21.309  21.140  1.00 34.09           N  
ATOM    406  CA  SER    60      14.580 -22.404  21.464  1.00 35.56           C  
ATOM    407  C   SER    60      13.520 -22.620  20.402  1.00 35.00           C  
ATOM    408  O   SER    60      12.473 -23.273  20.676  1.00 34.15           O  
ATOM    409  CB  SER    60      13.793 -22.101  22.766  1.00 35.66           C  
ATOM    410  OG  SER    60      14.529 -22.465  23.868  1.00 40.94           O  
ATOM    411  N   GLY    61      13.725 -22.050  19.227  1.00 33.78           N  
ATOM    412  CA  GLY    61      12.734 -22.180  18.151  1.00 33.83           C  
ATOM    413  C   GLY    61      11.537 -21.216  18.082  1.00 33.58           C  
ATOM    414  O   GLY    61      10.581 -21.489  17.382  1.00 33.89           O  
ATOM    415  N   GLY    62      11.592 -20.060  18.752  1.00 34.29           N  
ATOM    416  CA  GLY    62      10.503 -19.064  18.703  1.00 33.30           C  
ATOM    417  C   GLY    62      10.292 -18.403  17.339  1.00 34.18           C  
ATOM    418  O   GLY    62      11.131 -18.485  16.449  1.00 34.46           O  
ATOM    419  N   PRO    63       9.131 -17.779  17.156  1.00 34.28           N  
ATOM    420  CA  PRO    63       8.647 -17.233  15.855  1.00 34.13           C  
ATOM    421  C   PRO    63       9.249 -15.820  15.609  1.00 35.32           C  
ATOM    422  O   PRO    63       8.683 -14.844  16.083  1.00 35.94           O  
ATOM    423  CB  PRO    63       7.098 -17.165  16.070  1.00 34.92           C  
ATOM    424  CG  PRO    63       6.909 -17.071  17.597  1.00 34.02           C  
ATOM    425  CD  PRO    63       8.162 -17.613  18.267  1.00 32.77           C  
ATOM    426  N   LEU    64      10.409 -15.724  14.939  1.00 33.85           N  
ATOM    427  CA  LEU    64      11.035 -14.426  14.722  1.00 35.10           C  
ATOM    428  C   LEU    64      10.190 -13.455  13.888  1.00 35.51           C  
ATOM    429  O   LEU    64      10.282 -12.231  14.090  1.00 35.60           O  
ATOM    430  CB  LEU    64      12.420 -14.584  14.076  1.00 33.19           C  
ATOM    431  CG  LEU    64      13.471 -15.228  14.956  1.00 33.67           C  
ATOM    432  CD1 LEU    64      14.780 -15.303  14.169  1.00 31.32           C  
ATOM    433  CD2 LEU    64      13.683 -14.567  16.368  1.00 32.77           C  
ATOM    434  N   HIS    65       9.310 -14.009  13.014  1.00 36.13           N  
ATOM    435  CA  HIS    65       8.382 -13.207  12.206  1.00 35.49           C  
ATOM    436  C   HIS    65       7.333 -12.496  13.062  1.00 36.08           C  
ATOM    437  O   HIS    65       6.658 -11.607  12.549  1.00 36.02           O  
ATOM    438  CB  HIS    65       7.719 -14.047  11.080  1.00 34.87           C  
ATOM    439  CG  HIS    65       6.740 -15.075  11.579  1.00 34.80           C  
ATOM    440  ND1 HIS    65       7.104 -16.108  12.425  1.00 32.82           N  
ATOM    441  CD2 HIS    65       5.425 -15.270  11.294  1.00 35.42           C  
ATOM    442  CE1 HIS    65       6.030 -16.818  12.735  1.00 35.35           C  
ATOM    443  NE2 HIS    65       5.003 -16.349  12.044  1.00 34.51           N  
ATOM    444  N   LEU    66       7.226 -12.856  14.351  1.00 35.16           N  
ATOM    445  CA  LEU    66       6.321 -12.166  15.276  1.00 34.56           C  
ATOM    446  C   LEU    66       7.126 -11.259  16.209  1.00 34.99           C  
ATOM    447  O   LEU    66       6.571 -10.695  17.130  1.00 34.13           O  
ATOM    448  CB  LEU    66       5.499 -13.148  16.118  1.00 35.06           C  
ATOM    449  CG  LEU    66       4.672 -14.209  15.366  1.00 36.17           C  
ATOM    450  CD1 LEU    66       3.790 -14.925  16.316  1.00 36.21           C  
ATOM    451  CD2 LEU    66       3.919 -13.613  14.176  1.00 33.70           C  
ATOM    452  N   GLY    67       8.431 -11.107  15.993  1.00 32.27           N  
ATOM    453  CA  GLY    67       9.167 -10.210  16.887  1.00 33.66           C  
ATOM    454  C   GLY    67       9.179  -8.750  16.492  1.00 34.02           C  
ATOM    455  O   GLY    67       8.704  -8.397  15.403  1.00 34.86           O  
ATOM    456  N   GLU    68       9.706  -7.884  17.364  1.00 34.92           N  
ATOM    457  CA  GLU    68       9.815  -6.470  17.032  0.50 34.77           C  
ATOM    459  C   GLU    68      11.234  -6.174  16.546  1.00 36.04           C  
ATOM    460  O   GLU    68      12.222  -6.826  16.990  1.00 34.69           O  
ATOM    461  CB  GLU    68       9.482  -5.582  18.246  0.50 34.98           C  
ATOM    463  CG  GLU    68       8.148  -5.870  18.980  0.50 33.52           C  
ATOM    465  CD  GLU    68       6.963  -5.201  18.371  0.50 31.29           C  
ATOM    467  OE1 GLU    68       6.995  -4.840  17.191  0.50 32.99           O  
ATOM    469  OE2 GLU    68       5.968  -5.014  19.089  0.50 35.61           O  
ATOM    471  N   ILE    69      11.358  -5.184  15.662  1.00 36.24           N  
ATOM    472  CA  ILE    69      12.690  -4.749  15.196  1.00 39.01           C  
ATOM    473  C   ILE    69      13.122  -3.516  16.002  1.00 40.20           C  
ATOM    474  O   ILE    69      12.326  -2.588  16.158  1.00 38.19           O  
ATOM    475  CB  ILE    69      12.670  -4.427  13.673  1.00 39.84           C  
ATOM    476  CG1 ILE    69      12.411  -5.733  12.873  1.00 41.79           C  
ATOM    477  CG2 ILE    69      14.002  -3.705  13.233  1.00 39.07           C  
ATOM    478  CD1 ILE    69      12.138  -5.498  11.381  1.00 39.19           C  
ATOM    479  N   GLU    70      14.336  -3.532  16.564  1.00 40.88           N  
ATOM    480  CA  GLU    70      14.914  -2.358  17.235  1.00 44.15           C  
ATOM    481  C   GLU    70      16.417  -2.296  17.027  1.00 42.63           C  
ATOM    482  O   GLU    70      17.083  -3.326  16.854  1.00 40.70           O  
ATOM    483  CB  GLU    70      14.727  -2.352  18.758  1.00 44.02           C  
ATOM    484  CG  GLU    70      13.479  -2.956  19.319  1.00 49.17           C  
ATOM    485  CD  GLU    70      13.403  -2.778  20.857  1.00 50.66           C  
ATOM    486  OE1 GLU    70      13.816  -1.656  21.361  1.00 57.14           O  
ATOM    487  OE2 GLU    70      12.923  -3.748  21.533  1.00 53.10           O  
ATOM    488  N   ASP    71      16.941  -1.081  17.146  1.00 42.60           N  
ATOM    489  CA  ASP    71      18.382  -0.850  17.089  1.00 43.31           C  
ATOM    490  C   ASP    71      19.025  -1.001  18.446  1.00 43.56           C  
ATOM    491  O   ASP    71      18.527  -0.452  19.446  1.00 44.12           O  
ATOM    492  CB  ASP    71      18.695   0.530  16.502  1.00 43.80           C  
ATOM    493  CG  ASP    71      18.390   0.615  15.022  1.00 45.66           C  
ATOM    494  OD1 ASP    71      17.523  -0.130  14.518  1.00 46.85           O  
ATOM    495  OD2 ASP    71      19.031   1.442  14.340  1.00 50.54           O  
ATOM    496  N   PHE    72      20.119  -1.763  18.480  1.00 42.87           N  
ATOM    497  CA  PHE    72      20.968  -1.887  19.651  1.00 42.59           C  
ATOM    498  C   PHE    72      22.398  -1.763  19.142  1.00 42.61           C  
ATOM    499  O   PHE    72      22.744  -2.358  18.120  1.00 41.94           O  
ATOM    500  CB  PHE    72      20.781  -3.235  20.371  1.00 43.24           C  
ATOM    501  CG  PHE    72      19.348  -3.523  20.793  1.00 45.32           C  
ATOM    502  CD1 PHE    72      18.843  -3.025  21.994  1.00 47.35           C  
ATOM    503  CD2 PHE    72      18.501  -4.280  19.983  1.00 44.73           C  
ATOM    504  CE1 PHE    72      17.503  -3.279  22.376  1.00 48.24           C  
ATOM    505  CE2 PHE    72      17.168  -4.525  20.359  1.00 39.75           C  
ATOM    506  CZ  PHE    72      16.683  -4.035  21.549  1.00 45.38           C  
ATOM    507  N   ASN    73      23.206  -0.973  19.850  1.00 43.10           N  
ATOM    508  CA  ASN    73      24.606  -0.660  19.467  1.00 43.65           C  
ATOM    509  C   ASN    73      24.686  -0.152  18.023  1.00 43.70           C  
ATOM    510  O   ASN    73      25.601  -0.496  17.283  1.00 43.14           O  
ATOM    511  CB  ASN    73      25.513  -1.889  19.657  1.00 43.42           C  
ATOM    512  CG  ASN    73      27.003  -1.519  19.856  1.00 46.43           C  
ATOM    513  OD1 ASN    73      27.353  -0.367  20.187  1.00 43.42           O  
ATOM    514  ND2 ASN    73      27.889  -2.518  19.667  1.00 48.36           N  
ATOM    515  N   GLY    74      23.677   0.609  17.606  1.00 44.40           N  
ATOM    516  CA  GLY    74      23.611   1.082  16.214  1.00 44.51           C  
ATOM    517  C   GLY    74      23.381   0.008  15.147  1.00 44.46           C  
ATOM    518  O   GLY    74      23.531   0.291  13.971  1.00 44.76           O  
ATOM    519  N   GLN    75      23.016  -1.212  15.556  1.00 43.78           N  
ATOM    520  CA  GLN    75      22.635  -2.297  14.632  1.00 42.82           C  
ATOM    521  C   GLN    75      21.157  -2.669  14.762  1.00 40.89           C  
ATOM    522  O   GLN    75      20.649  -2.890  15.865  1.00 40.71           O  
ATOM    523  CB  GLN    75      23.479  -3.545  14.896  1.00 42.81           C  
ATOM    524  CG  GLN    75      24.968  -3.400  14.622  1.00 46.95           C  
ATOM    525  CD  GLN    75      25.797  -4.451  15.386  1.00 50.89           C  
ATOM    526  OE1 GLN    75      26.011  -4.339  16.595  1.00 52.08           O  
ATOM    527  NE2 GLN    75      26.257  -5.474  14.673  1.00 51.59           N  
ATOM    528  N   SER    76      20.470  -2.740  13.621  1.00 39.88           N  
ATOM    529  CA  SER    76      19.081  -3.185  13.538  1.00 38.27           C  
ATOM    530  C   SER    76      18.980  -4.683  13.879  1.00 36.85           C  
ATOM    531  O   SER    76      19.722  -5.479  13.320  1.00 36.22           O  
ATOM    532  CB  SER    76      18.554  -2.935  12.130  1.00 38.31           C  
ATOM    533  OG  SER    76      18.478  -1.527  11.875  1.00 43.22           O  
ATOM    534  N   CYS    77      18.072  -5.043  14.789  1.00 35.33           N  
ATOM    535  CA  CYS    77      17.930  -6.402  15.313  1.00 34.59           C  
ATOM    536  C   CYS    77      16.462  -6.789  15.272  1.00 35.71           C  
ATOM    537  O   CYS    77      15.620  -5.957  15.526  1.00 35.64           O  
ATOM    538  CB  CYS    77      18.356  -6.451  16.776  1.00 33.34           C  
ATOM    539  SG  CYS    77      20.163  -6.333  16.976  1.00 35.65           S  
ATOM    540  N   ILE    78      16.190  -8.059  15.007  1.00 34.76           N  
ATOM    541  CA  ILE    78      14.973  -8.688  15.377  1.00 34.18           C  
ATOM    542  C   ILE    78      15.061  -9.169  16.864  1.00 34.62           C  
ATOM    543  O   ILE    78      16.054  -9.721  17.287  1.00 34.47           O  
ATOM    544  CB  ILE    78      14.535  -9.826  14.318  1.00 33.81           C  
ATOM    545  CG1 ILE    78      13.138 -10.355  14.634  1.00 32.87           C  
ATOM    546  CG2 ILE    78      15.569 -10.982  14.211  1.00 31.11           C  
ATOM    547  CD1 ILE    78      12.031  -9.303  14.448  1.00 29.85           C  
ATOM    548  N   VAL    79      14.017  -8.921  17.655  1.00 32.69           N  
ATOM    549  CA  VAL    79      13.972  -9.370  19.046  1.00 33.62           C  
ATOM    550  C   VAL    79      12.967 -10.495  19.058  1.00 33.60           C  
ATOM    551  O   VAL    79      11.792 -10.239  18.739  1.00 33.36           O  
ATOM    552  CB  VAL    79      13.518  -8.218  19.996  1.00 34.49           C  
ATOM    553  CG1 VAL    79      13.462  -8.703  21.467  1.00 35.62           C  
ATOM    554  CG2 VAL    79      14.427  -6.975  19.840  1.00 30.87           C  
ATOM    555  N   CYS    80      13.411 -11.721  19.355  1.00 34.05           N  
ATOM    556  CA  CYS    80      12.533 -12.854  19.471  1.00 34.02           C  
ATOM    557  C   CYS    80      11.430 -12.582  20.492  1.00 33.64           C  
ATOM    558  O   CYS    80      11.698 -12.131  21.600  1.00 32.90           O  
ATOM    559  CB  CYS    80      13.294 -14.109  19.911  1.00 34.77           C  
ATOM    560  SG  CYS    80      12.168 -15.548  19.926  1.00 35.45           S  
ATOM    561  N   PRO    81      10.148 -12.867  20.137  1.00 34.47           N  
ATOM    562  CA  PRO    81       9.161 -12.521  21.164  1.00 33.40           C  
ATOM    563  C   PRO    81       9.158 -13.389  22.422  1.00 32.58           C  
ATOM    564  O   PRO    81       8.508 -12.988  23.398  1.00 32.43           O  
ATOM    565  CB  PRO    81       7.805 -12.649  20.450  1.00 33.95           C  
ATOM    566  CG  PRO    81       8.086 -13.625  19.318  1.00 33.95           C  
ATOM    567  CD  PRO    81       9.559 -13.452  18.920  1.00 33.50           C  
ATOM    568  N   TRP    82       9.802 -14.554  22.398  1.00 32.23           N  
ATOM    569  CA  TRP    82       9.754 -15.550  23.533  1.00 31.38           C  
ATOM    570  C   TRP    82      10.749 -15.130  24.528  1.00 30.48           C  
ATOM    571  O   TRP    82      10.362 -14.756  25.596  1.00 29.33           O  
ATOM    572  CB  TRP    82       9.982 -16.993  23.023  1.00 32.45           C  
ATOM    573  CG  TRP    82       8.799 -17.617  22.294  1.00 34.89           C  
ATOM    574  CD1 TRP    82       7.596 -17.007  21.998  1.00 36.46           C  
ATOM    575  CD2 TRP    82       8.669 -18.981  21.835  1.00 35.91           C  
ATOM    576  NE1 TRP    82       6.751 -17.904  21.374  1.00 34.16           N  
ATOM    577  CE2 TRP    82       7.387 -19.107  21.242  1.00 35.08           C  
ATOM    578  CE3 TRP    82       9.521 -20.105  21.855  1.00 36.77           C  
ATOM    579  CZ2 TRP    82       6.925 -20.325  20.657  1.00 37.12           C  
ATOM    580  CZ3 TRP    82       9.077 -21.308  21.279  1.00 35.69           C  
ATOM    581  CH2 TRP    82       7.782 -21.405  20.693  1.00 37.21           C  
ATOM    582  N   HIS    83      12.068 -15.103  24.216  1.00 30.38           N  
ATOM    583  CA  HIS    83      12.919 -14.743  25.348  1.00 29.88           C  
ATOM    584  C   HIS    83      13.741 -13.485  25.057  1.00 31.78           C  
ATOM    585  O   HIS    83      14.746 -13.232  25.722  1.00 31.83           O  
ATOM    586  CB  HIS    83      13.781 -15.895  25.841  1.00 31.04           C  
ATOM    587  CG  HIS    83      13.026 -17.192  25.969  1.00 31.61           C  
ATOM    588  ND1 HIS    83      12.949 -18.098  24.940  1.00 32.84           N  
ATOM    589  CD2 HIS    83      12.222 -17.671  26.946  1.00 34.43           C  
ATOM    590  CE1 HIS    83      12.170 -19.111  25.295  1.00 32.77           C  
ATOM    591  NE2 HIS    83      11.701 -18.859  26.499  1.00 34.54           N  
ATOM    592  N   LYS    84      13.272 -12.695  24.087  1.00 31.89           N  
ATOM    593  CA  LYS    84      13.801 -11.347  23.806  1.00 31.70           C  
ATOM    594  C   LYS    84      15.293 -11.389  23.412  1.00 33.14           C  
ATOM    595  O   LYS    84      15.999 -10.409  23.572  1.00 32.10           O  
ATOM    596  CB  LYS    84      13.572 -10.417  24.989  1.00 31.06           C  
ATOM    597  CG  LYS    84      12.064 -10.399  25.517  1.00 30.64           C  
ATOM    598  CD  LYS    84      11.050 -10.263  24.434  1.00 32.36           C  
ATOM    599  CE  LYS    84       9.644  -9.933  25.085  1.00 38.66           C  
ATOM    600  NZ  LYS    84       8.482 -10.388  24.213  1.00 42.06           N  
ATOM    601  N   TYR    85      15.749 -12.497  22.829  1.00 33.63           N  
ATOM    602  CA  TYR    85      17.115 -12.501  22.289  1.00 34.59           C  
ATOM    603  C   TYR    85      17.175 -11.542  21.081  1.00 35.22           C  
ATOM    604  O   TYR    85      16.204 -11.416  20.329  1.00 34.27           O  
ATOM    605  CB  TYR    85      17.601 -13.871  21.873  1.00 34.05           C  
ATOM    606  CG  TYR    85      18.069 -14.735  23.013  1.00 33.39           C  
ATOM    607  CD1 TYR    85      17.518 -14.603  24.318  1.00 33.28           C  
ATOM    608  CD2 TYR    85      19.020 -15.705  22.782  1.00 33.67           C  
ATOM    609  CE1 TYR    85      17.960 -15.396  25.370  1.00 32.12           C  
ATOM    610  CE2 TYR    85      19.448 -16.533  23.802  1.00 36.57           C  
ATOM    611  CZ  TYR    85      18.910 -16.370  25.089  1.00 35.84           C  
ATOM    612  OH  TYR    85      19.383 -17.144  26.067  1.00 31.52           O  
ATOM    613  N   LYS    86      18.305 -10.876  20.931  1.00 34.93           N  
ATOM    614  CA  LYS    86      18.469  -9.853  19.904  1.00 36.39           C  
ATOM    615  C   LYS    86      19.354 -10.424  18.841  1.00 36.21           C  
ATOM    616  O   LYS    86      20.454 -10.888  19.121  1.00 35.92           O  
ATOM    617  CB  LYS    86      19.109  -8.620  20.483  1.00 36.57           C  
ATOM    618  CG  LYS    86      18.377  -8.041  21.744  1.00 38.21           C  
ATOM    619  CD  LYS    86      19.382  -6.992  22.306  1.00 41.31           C  
ATOM    620  CE  LYS    86      18.733  -6.100  23.324  1.00 46.04           C  
ATOM    621  NZ  LYS    86      18.598  -6.744  24.662  1.00 46.41           N  
ATOM    622  N   ILE    87      18.849 -10.420  17.612  1.00 35.80           N  
ATOM    623  CA  ILE    87      19.600 -10.980  16.491  1.00 34.37           C  
ATOM    624  C   ILE    87      19.777  -9.927  15.419  1.00 35.24           C  
ATOM    625  O   ILE    87      18.772  -9.368  14.953  1.00 33.39           O  
ATOM    626  CB  ILE    87      18.816 -12.178  15.906  1.00 35.19           C  
ATOM    627  CG1 ILE    87      18.756 -13.254  17.013  1.00 32.85           C  
ATOM    628  CG2 ILE    87      19.485 -12.672  14.587  1.00 32.28           C  
ATOM    629  CD1 ILE    87      17.647 -14.305  16.840  1.00 33.74           C  
ATOM    630  N   THR    88      21.023  -9.680  15.000  1.00 32.82           N  
ATOM    631  CA  THR    88      21.230  -8.635  13.996  1.00 34.57           C  
ATOM    632  C   THR    88      20.607  -9.068  12.656  1.00 34.38           C  
ATOM    633  O   THR    88      20.650 -10.224  12.304  1.00 34.53           O  
ATOM    634  CB  THR    88      22.724  -8.301  13.763  1.00 34.35           C  
ATOM    635  OG1 THR    88      23.409  -9.475  13.340  1.00 35.21           O  
ATOM    636  CG2 THR    88      23.392  -7.774  15.039  1.00 33.63           C  
ATOM    637  N   LEU    89      19.976  -8.125  11.981  1.00 34.00           N  
ATOM    638  CA  LEU    89      19.322  -8.356  10.695  1.00 35.35           C  
ATOM    639  C   LEU    89      20.380  -8.672   9.650  1.00 35.40           C  
ATOM    640  O   LEU    89      20.181  -9.579   8.837  1.00 36.23           O  
ATOM    641  CB  LEU    89      18.529  -7.081  10.287  1.00 33.99           C  
ATOM    642  CG  LEU    89      17.230  -6.790  11.094  1.00 32.97           C  
ATOM    643  CD1 LEU    89      16.426  -5.700  10.357  1.00 31.94           C  
ATOM    644  CD2 LEU    89      16.393  -8.003  11.336  1.00 30.27           C  
ATOM    645  N   ALA    90      21.509  -7.975   9.727  1.00 34.20           N  
ATOM    646  CA  ALA    90      22.519  -8.019   8.678  1.00 36.25           C  
ATOM    647  C   ALA    90      23.387  -9.263   8.793  1.00 36.66           C  
ATOM    648  O   ALA    90      23.758  -9.810   7.776  1.00 36.43           O  
ATOM    649  CB  ALA    90      23.415  -6.759   8.683  1.00 35.66           C  
ATOM    650  N   THR    91      23.685  -9.717  10.027  1.00 34.82           N  
ATOM    651  CA  THR    91      24.589 -10.858  10.183  1.00 35.01           C  
ATOM    652  C   THR    91      24.116 -12.087  10.991  1.00 35.56           C  
ATOM    653  O   THR    91      24.853 -13.077  11.052  1.00 36.37           O  
ATOM    654  CB  THR    91      25.960 -10.390  10.761  1.00 34.11           C  
ATOM    655  OG1 THR    91      25.737  -9.613  11.957  1.00 35.18           O  
ATOM    656  CG2 THR    91      26.699  -9.568   9.732  1.00 33.96           C  
ATOM    657  N   GLY    92      22.938 -12.026  11.618  1.00 33.49           N  
ATOM    658  CA  GLY    92      22.460 -13.150  12.383  1.00 34.48           C  
ATOM    659  C   GLY    92      23.227 -13.354  13.680  1.00 35.00           C  
ATOM    660  O   GLY    92      23.222 -14.444  14.230  1.00 34.54           O  
ATOM    661  N   GLU    93      23.805 -12.274  14.204  1.00 35.53           N  
ATOM    662  CA  GLU    93      24.569 -12.353  15.436  1.00 36.08           C  
ATOM    663  C   GLU    93      23.607 -12.161  16.603  1.00 37.33           C  
ATOM    664  O   GLU    93      22.883 -11.187  16.639  1.00 34.20           O  
ATOM    665  CB  GLU    93      25.642 -11.255  15.497  1.00 35.02           C  
ATOM    666  CG  GLU    93      26.854 -11.393  14.533  1.00 31.69           C  
ATOM    667  CD  GLU    93      27.731 -10.176  14.562  1.00 34.65           C  
ATOM    668  OE1 GLU    93      28.431  -9.935  15.578  1.00 37.63           O  
ATOM    669  OE2 GLU    93      27.761  -9.438  13.567  1.00 33.35           O  
ATOM    670  N   GLY    94      23.689 -13.064  17.584  1.00 39.26           N  
ATOM    671  CA  GLY    94      23.199 -12.833  18.957  1.00 39.94           C  
ATOM    672  C   GLY    94      23.965 -11.705  19.616  1.00 40.96           C  
ATOM    673  O   GLY    94      25.195 -11.754  19.743  1.00 41.85           O  
ATOM    674  N   LEU    95      23.262 -10.662  20.036  1.00 41.80           N  
ATOM    675  CA  LEU    95      23.912  -9.522  20.705  1.00 43.32           C  
ATOM    676  C   LEU    95      23.481  -9.430  22.157  1.00 44.62           C  
ATOM    677  O   LEU    95      22.305  -9.712  22.518  1.00 44.46           O  
ATOM    678  CB  LEU    95      23.514  -8.202  20.035  1.00 43.50           C  
ATOM    679  CG  LEU    95      23.999  -7.851  18.663  1.00 43.89           C  
ATOM    680  CD1 LEU    95      23.548  -6.420  18.448  1.00 42.62           C  
ATOM    681  CD2 LEU    95      25.548  -7.911  18.639  1.00 46.24           C  
ATOM    682  N   TYR    96      24.422  -9.008  22.993  1.00 45.03           N  
ATOM    683  CA  TYR    96      24.140  -8.751  24.398  1.00 45.51           C  
ATOM    684  C   TYR    96      25.061  -7.662  24.986  1.00 45.91           C  
ATOM    685  O   TYR    96      26.169  -7.340  24.467  1.00 45.16           O  
ATOM    686  CB  TYR    96      24.236 -10.057  25.240  1.00 45.83           C  
ATOM    687  CG  TYR    96      25.604 -10.654  25.208  1.00 44.27           C  
ATOM    688  CD1 TYR    96      26.031 -11.370  24.071  1.00 50.00           C  
ATOM    689  CD2 TYR    96      26.502 -10.491  26.263  1.00 46.02           C  
ATOM    690  CE1 TYR    96      27.349 -11.916  23.981  1.00 47.47           C  
ATOM    691  CE2 TYR    96      27.839 -11.074  26.200  1.00 46.29           C  
ATOM    692  CZ  TYR    96      28.231 -11.777  25.050  1.00 44.35           C  
ATOM    693  OH  TYR    96      29.492 -12.321  24.908  1.00 45.24           O  
ATOM    694  N   GLN    97      24.585  -7.086  26.087  1.00 46.30           N  
ATOM    695  CA  GLN    97      25.427  -6.235  26.908  1.00 46.58           C  
ATOM    696  C   GLN    97      26.028  -7.040  28.046  1.00 45.88           C  
ATOM    697  O   GLN    97      25.322  -7.760  28.753  1.00 44.56           O  
ATOM    698  CB  GLN    97      24.642  -5.078  27.499  1.00 47.22           C  
ATOM    699  CG  GLN    97      24.144  -4.011  26.589  1.00 48.64           C  
ATOM    700  CD  GLN    97      23.318  -3.005  27.411  1.00 52.59           C  
ATOM    701  OE1 GLN    97      23.868  -2.091  28.035  1.00 53.02           O  
ATOM    702  NE2 GLN    97      22.001  -3.214  27.457  1.00 51.22           N  
ATOM    703  N   SER    98      27.332  -6.892  28.210  1.00 45.90           N  
ATOM    704  CA  SER    98      28.032  -7.433  29.337  1.00 47.24           C  
ATOM    705  C   SER    98      28.166  -6.335  30.376  1.00 49.34           C  
ATOM    706  O   SER    98      28.757  -5.280  30.106  1.00 49.89           O  
ATOM    707  CB  SER    98      29.421  -7.930  28.921  1.00 47.10           C  
ATOM    708  OG  SER    98      30.102  -8.443  30.055  1.00 45.34           O  
ATOM    709  N   ILE    99      27.643  -6.611  31.572  1.00 51.39           N  
ATOM    710  CA  ILE    99      27.521  -5.639  32.677  1.00 52.93           C  
ATOM    711  C   ILE    99      28.393  -6.106  33.858  1.00 54.29           C  
ATOM    712  O   ILE    99      28.399  -7.298  34.199  1.00 54.71           O  
ATOM    713  CB  ILE    99      26.001  -5.470  33.104  1.00 52.30           C  
ATOM    714  CG1 ILE    99      25.131  -5.046  31.911  1.00 51.54           C  
ATOM    715  CG2 ILE    99      25.821  -4.493  34.288  1.00 53.70           C  
ATOM    716  CD1 ILE    99      23.807  -5.799  31.805  1.00 46.37           C  
ATOM    717  N   ASN   100      29.145  -5.184  34.459  1.00 55.52           N  
ATOM    718  CA  ASN   100      29.915  -5.522  35.654  1.00 56.83           C  
ATOM    719  C   ASN   100      29.368  -4.911  36.948  1.00 57.31           C  
ATOM    720  O   ASN   100      29.767  -3.798  37.320  1.00 57.84           O  
ATOM    721  CB  ASN   100      31.395  -5.180  35.492  1.00 57.18           C  
ATOM    722  CG  ASN   100      32.279  -5.978  36.445  1.00 58.52           C  
ATOM    723  OD1 ASN   100      32.301  -5.729  37.666  1.00 55.73           O  
ATOM    724  ND2 ASN   100      32.999  -6.966  35.887  1.00 59.65           N  
ATOM    725  N   PRO   101      28.505  -5.669  37.671  1.00 57.70           N  
ATOM    726  CA  PRO   101      27.715  -5.252  38.861  1.00 57.67           C  
ATOM    727  C   PRO   101      28.494  -4.456  39.916  1.00 57.26           C  
ATOM    728  O   PRO   101      29.706  -4.632  40.048  1.00 57.24           O  
ATOM    729  CB  PRO   101      27.268  -6.589  39.470  1.00 57.78           C  
ATOM    730  CG  PRO   101      28.071  -7.663  38.736  1.00 57.63           C  
ATOM    731  CD  PRO   101      28.294  -7.099  37.376  1.00 57.45           C  
ATOM    732  N   LYS   107      29.692   1.272  32.920  1.00 52.92           N  
ATOM    733  CA  LYS   107      29.148   1.413  31.570  1.00 53.38           C  
ATOM    734  C   LYS   107      29.016   0.059  30.807  1.00 53.00           C  
ATOM    735  O   LYS   107      30.028  -0.555  30.445  1.00 53.19           O  
ATOM    736  CB  LYS   107      30.007   2.402  30.785  1.00 53.22           C  
ATOM    737  CG  LYS   107      29.300   3.062  29.608  1.00 54.17           C  
ATOM    738  CD  LYS   107      30.302   3.782  28.676  1.00 54.72           C  
ATOM    739  CE  LYS   107      30.830   2.874  27.551  1.00 56.01           C  
ATOM    740  NZ  LYS   107      29.758   2.104  26.827  1.00 56.35           N  
ATOM    741  N   PRO   108      27.766  -0.424  30.589  1.00 52.64           N  
ATOM    742  CA  PRO   108      27.527  -1.639  29.776  1.00 52.07           C  
ATOM    743  C   PRO   108      28.149  -1.649  28.357  1.00 51.06           C  
ATOM    744  O   PRO   108      28.077  -0.662  27.610  1.00 51.00           O  
ATOM    745  CB  PRO   108      25.986  -1.740  29.709  1.00 52.11           C  
ATOM    746  CG  PRO   108      25.470  -0.398  30.166  1.00 52.53           C  
ATOM    747  CD  PRO   108      26.501   0.106  31.141  1.00 52.95           C  
ATOM    748  N   LYS   109      28.747  -2.780  28.007  1.00 49.63           N  
ATOM    749  CA  LYS   109      29.417  -2.927  26.728  1.00 48.39           C  
ATOM    750  C   LYS   109      28.752  -4.014  25.903  1.00 47.32           C  
ATOM    751  O   LYS   109      28.409  -5.079  26.408  1.00 46.47           O  
ATOM    752  CB  LYS   109      30.908  -3.231  26.929  1.00 48.48           C  
ATOM    753  CG  LYS   109      31.675  -2.169  27.706  1.00 48.27           C  
ATOM    754  CD  LYS   109      32.101  -0.976  26.816  1.00 48.40           C  
ATOM    755  CE  LYS   109      32.829   0.130  27.608  1.00 48.03           C  
ATOM    756  NZ  LYS   109      34.057  -0.306  28.331  1.00 48.01           N  
ATOM    757  N   TRP   110      28.577  -3.715  24.624  1.00 46.18           N  
ATOM    758  CA  TRP   110      27.922  -4.607  23.689  1.00 45.75           C  
ATOM    759  C   TRP   110      28.888  -5.683  23.197  1.00 44.56           C  
ATOM    760  O   TRP   110      30.046  -5.391  22.911  1.00 42.89           O  
ATOM    761  CB  TRP   110      27.375  -3.803  22.515  1.00 45.61           C  
ATOM    762  CG  TRP   110      26.203  -3.031  22.904  1.00 46.40           C  
ATOM    763  CD1 TRP   110      26.153  -1.699  23.258  1.00 45.90           C  
ATOM    764  CD2 TRP   110      24.869  -3.540  23.026  1.00 45.33           C  
ATOM    765  NE1 TRP   110      24.843  -1.349  23.573  1.00 45.91           N  
ATOM    766  CE2 TRP   110      24.038  -2.454  23.441  1.00 46.03           C  
ATOM    767  CE3 TRP   110      24.291  -4.803  22.822  1.00 45.31           C  
ATOM    768  CZ2 TRP   110      22.634  -2.600  23.654  1.00 46.18           C  
ATOM    769  CZ3 TRP   110      22.872  -4.949  23.031  1.00 46.50           C  
ATOM    770  CH2 TRP   110      22.082  -3.853  23.464  1.00 44.84           C  
ATOM    771  N   CYS   111      28.361  -6.904  23.104  1.00 43.73           N  
ATOM    772  CA  CYS   111      29.114  -8.133  22.804  1.00 43.51           C  
ATOM    773  C   CYS   111      28.372  -9.074  21.871  1.00 42.24           C  
ATOM    774  O   CYS   111      27.149  -9.058  21.816  1.00 41.79           O  
ATOM    775  CB  CYS   111      29.376  -8.905  24.099  1.00 43.86           C  
ATOM    776  SG  CYS   111      30.478  -8.046  25.204  1.00 46.60           S  
ATOM    777  N   SER   112      29.104  -9.937  21.181  1.00 40.36           N  
ATOM    778  CA  SER   112      28.489 -10.890  20.233  1.00 38.78           C  
ATOM    779  C   SER   112      29.045 -12.287  20.444  1.00 38.54           C  
ATOM    780  O   SER   112      30.236 -12.465  20.784  1.00 37.11           O  
ATOM    781  CB  SER   112      28.784 -10.442  18.777  1.00 38.60           C  
ATOM    782  OG  SER   112      28.526 -11.474  17.829  1.00 36.33           O  
ATOM    783  N   LYS   113      28.240 -13.294  20.134  1.00 39.27           N  
ATOM    784  CA  LYS   113      28.809 -14.664  20.073  1.00 39.20           C  
ATOM    785  C   LYS   113      28.966 -15.206  18.665  1.00 37.38           C  
ATOM    786  O   LYS   113      29.110 -16.411  18.469  1.00 37.70           O  
ATOM    787  CB  LYS   113      27.989 -15.639  20.921  1.00 42.14           C  
ATOM    788  CG  LYS   113      28.737 -16.266  22.147  1.00 43.01           C  
ATOM    789  CD  LYS   113      27.629 -16.659  23.119  1.00 49.68           C  
ATOM    790  CE  LYS   113      28.098 -16.891  24.541  1.00 52.37           C  
ATOM    791  NZ  LYS   113      26.895 -17.361  25.347  1.00 52.14           N  
ATOM    792  N   GLY   114      29.001 -14.319  17.685  1.00 35.65           N  
ATOM    793  CA  GLY   114      29.233 -14.768  16.320  1.00 33.82           C  
ATOM    794  C   GLY   114      27.873 -15.014  15.692  1.00 33.37           C  
ATOM    795  O   GLY   114      26.853 -14.701  16.302  1.00 33.36           O  
ATOM    796  N   VAL   115      27.846 -15.649  14.525  1.00 32.79           N  
ATOM    797  CA  VAL   115      26.561 -15.900  13.774  1.00 33.84           C  
ATOM    798  C   VAL   115      25.799 -17.031  14.496  1.00 34.57           C  
ATOM    799  O   VAL   115      26.361 -18.137  14.767  1.00 34.43           O  
ATOM    800  CB  VAL   115      26.845 -16.293  12.300  1.00 33.90           C  
ATOM    801  CG1 VAL   115      25.555 -16.622  11.522  1.00 31.20           C  
ATOM    802  CG2 VAL   115      27.703 -15.199  11.551  1.00 33.60           C  
ATOM    803  N   LYS   116      24.574 -16.720  14.899  1.00 33.94           N  
ATOM    804  CA  LYS   116      23.689 -17.683  15.526  1.00 34.60           C  
ATOM    805  C   LYS   116      22.534 -18.002  14.584  1.00 36.35           C  
ATOM    806  O   LYS   116      22.037 -19.147  14.525  1.00 36.12           O  
ATOM    807  CB  LYS   116      23.137 -17.076  16.830  1.00 34.93           C  
ATOM    808  CG  LYS   116      24.158 -16.962  17.967  1.00 36.71           C  
ATOM    809  CD  LYS   116      24.828 -18.295  18.150  1.00 37.08           C  
ATOM    810  CE  LYS   116      25.508 -18.443  19.482  1.00 39.69           C  
ATOM    811  NZ  LYS   116      25.820 -19.872  19.666  1.00 39.79           N  
ATOM    812  N   GLN   117      22.067 -16.972  13.876  1.00 36.23           N  
ATOM    813  CA  GLN   117      20.877 -17.109  13.025  1.00 37.34           C  
ATOM    814  C   GLN   117      21.271 -17.048  11.555  1.00 37.69           C  
ATOM    815  O   GLN   117      21.845 -16.036  11.090  1.00 37.71           O  
ATOM    816  CB  GLN   117      19.869 -15.988  13.312  1.00 36.96           C  
ATOM    817  CG  GLN   117      18.463 -16.279  12.769  1.00 36.32           C  
ATOM    818  CD  GLN   117      17.735 -17.310  13.592  1.00 35.64           C  
ATOM    819  OE1 GLN   117      18.100 -17.589  14.764  1.00 33.21           O  
ATOM    820  NE2 GLN   117      16.695 -17.910  12.990  1.00 32.46           N  
ATOM    821  N   ARG   118      20.991 -18.126  10.825  1.00 37.71           N  
ATOM    822  CA  ARG   118      21.418 -18.190   9.418  1.00 37.98           C  
ATOM    823  C   ARG   118      20.741 -17.092   8.573  1.00 37.27           C  
ATOM    824  O   ARG   118      19.476 -17.000   8.499  1.00 37.04           O  
ATOM    825  CB  ARG   118      21.179 -19.576   8.789  1.00 38.02           C  
ATOM    826  CG  ARG   118      21.819 -19.735   7.378  1.00 39.40           C  
ATOM    827  CD  ARG   118      21.777 -21.175   6.875  1.00 38.52           C  
ATOM    828  NE  ARG   118      22.687 -22.033   7.665  1.00 38.06           N  
ATOM    829  CZ  ARG   118      24.022 -22.129   7.515  1.00 37.93           C  
ATOM    830  NH1 ARG   118      24.691 -21.440   6.593  1.00 34.56           N  
ATOM    831  NH2 ARG   118      24.703 -22.923   8.333  1.00 38.47           N  
ATOM    832  N   ILE   119      21.582 -16.256   7.956  1.00 36.09           N  
ATOM    833  CA  ILE   119      21.119 -15.156   7.094  1.00 36.00           C  
ATOM    834  C   ILE   119      21.166 -15.659   5.666  1.00 36.74           C  
ATOM    835  O   ILE   119      22.181 -16.133   5.235  1.00 36.50           O  
ATOM    836  CB  ILE   119      22.024 -13.877   7.212  1.00 35.96           C  
ATOM    837  CG1 ILE   119      22.022 -13.307   8.650  1.00 34.90           C  
ATOM    838  CG2 ILE   119      21.682 -12.825   6.125  1.00 35.15           C  
ATOM    839  CD1 ILE   119      20.602 -12.885   9.187  1.00 30.88           C  
ATOM    840  N   HIS   120      20.053 -15.565   4.942  1.00 36.85           N  
ATOM    841  CA  HIS   120      20.040 -15.841   3.493  1.00 38.96           C  
ATOM    842  C   HIS   120      20.138 -14.559   2.630  1.00 39.25           C  
ATOM    843  O   HIS   120      20.005 -13.427   3.128  1.00 40.02           O  
ATOM    844  CB  HIS   120      18.777 -16.660   3.144  1.00 38.05           C  
ATOM    845  CG  HIS   120      18.561 -17.800   4.089  1.00 38.96           C  
ATOM    846  ND1 HIS   120      19.418 -18.878   4.150  1.00 36.58           N  
ATOM    847  CD2 HIS   120      17.627 -18.000   5.053  1.00 35.27           C  
ATOM    848  CE1 HIS   120      19.003 -19.709   5.090  1.00 38.50           C  
ATOM    849  NE2 HIS   120      17.934 -19.192   5.668  1.00 35.36           N  
ATOM    850  N   THR   121      20.333 -14.756   1.338  1.00 39.59           N  
ATOM    851  CA  THR   121      20.491 -13.659   0.402  1.00 40.27           C  
ATOM    852  C   THR   121      19.199 -13.159  -0.273  1.00 40.15           C  
ATOM    853  O   THR   121      18.438 -13.936  -0.858  1.00 39.80           O  
ATOM    854  CB  THR   121      21.500 -14.066  -0.671  1.00 40.22           C  
ATOM    855  OG1 THR   121      22.749 -14.397  -0.034  1.00 41.98           O  
ATOM    856  CG2 THR   121      21.706 -12.937  -1.682  1.00 41.72           C  
ATOM    857  N   VAL   122      19.007 -11.839  -0.253  1.00 41.00           N  
ATOM    858  CA  VAL   122      17.854 -11.203  -0.869  1.00 41.58           C  
ATOM    859  C   VAL   122      18.258 -10.178  -1.930  1.00 43.48           C  
ATOM    860  O   VAL   122      19.146  -9.338  -1.698  1.00 43.53           O  
ATOM    861  CB  VAL   122      16.981 -10.464   0.162  1.00 41.71           C  
ATOM    862  CG1 VAL   122      15.644 -10.073  -0.474  1.00 38.28           C  
ATOM    863  CG2 VAL   122      16.765 -11.303   1.363  1.00 40.94           C  
ATOM    864  N   LYS   123      17.587 -10.270  -3.081  1.00 44.58           N  
ATOM    865  CA  LYS   123      17.739  -9.350  -4.214  1.00 46.35           C  
ATOM    866  C   LYS   123      16.342  -8.962  -4.683  1.00 46.16           C  
ATOM    867  O   LYS   123      15.405  -9.785  -4.628  1.00 46.09           O  
ATOM    868  CB  LYS   123      18.475 -10.028  -5.365  1.00 45.73           C  
ATOM    869  CG  LYS   123      19.758 -10.697  -4.915  1.00 49.43           C  
ATOM    870  CD  LYS   123      20.670 -11.185  -6.033  1.00 49.00           C  
ATOM    871  CE  LYS   123      21.765 -12.074  -5.411  1.00 53.31           C  
ATOM    872  NZ  LYS   123      23.006 -11.341  -5.004  1.00 54.10           N  
ATOM    873  N   VAL   124      16.198  -7.705  -5.112  1.00 46.40           N  
ATOM    874  CA  VAL   124      15.000  -7.293  -5.832  1.00 46.88           C  
ATOM    875  C   VAL   124      15.379  -7.052  -7.277  1.00 46.74           C  
ATOM    876  O   VAL   124      16.504  -6.635  -7.570  1.00 46.43           O  
ATOM    877  CB  VAL   124      14.232  -6.080  -5.185  1.00 47.39           C  
ATOM    878  CG1 VAL   124      13.900  -6.365  -3.711  1.00 46.38           C  
ATOM    879  CG2 VAL   124      15.003  -4.779  -5.323  1.00 48.38           C  
ATOM    880  N   ASP   125      14.456  -7.392  -8.164  1.00 46.24           N  
ATOM    881  CA  ASP   125      14.604  -7.198  -9.603  1.00 46.97           C  
ATOM    882  C   ASP   125      13.200  -7.131 -10.144  1.00 46.60           C  
ATOM    883  O   ASP   125      12.381  -8.010  -9.868  1.00 46.64           O  
ATOM    884  CB  ASP   125      15.365  -8.366 -10.243  1.00 47.02           C  
ATOM    885  CG  ASP   125      15.581  -8.179 -11.735  1.00 48.06           C  
ATOM    886  OD1 ASP   125      16.409  -7.324 -12.127  1.00 47.94           O  
ATOM    887  OD2 ASP   125      14.925  -8.901 -12.522  1.00 49.86           O  
ATOM    888  N   ASN   126      12.915  -6.066 -10.880  1.00 46.65           N  
ATOM    889  CA  ASN   126      11.595  -5.865 -11.459  1.00 46.94           C  
ATOM    890  C   ASN   126      10.482  -5.772 -10.414  1.00 46.29           C  
ATOM    891  O   ASN   126       9.341  -6.151 -10.691  1.00 46.38           O  
ATOM    892  CB  ASN   126      11.265  -6.996 -12.440  1.00 47.56           C  
ATOM    893  CG  ASN   126      11.881  -6.790 -13.785  1.00 48.66           C  
ATOM    894  OD1 ASN   126      13.106  -6.718 -13.920  1.00 51.64           O  
ATOM    895  ND2 ASN   126      11.040  -6.693 -14.802  1.00 48.83           N  
ATOM    896  N   GLY   127      10.816  -5.281  -9.221  1.00 45.49           N  
ATOM    897  CA  GLY   127       9.850  -5.254  -8.121  1.00 44.79           C  
ATOM    898  C   GLY   127       9.414  -6.632  -7.616  1.00 43.72           C  
ATOM    899  O   GLY   127       8.267  -6.769  -7.095  1.00 44.18           O  
ATOM    900  N   ASN   128      10.302  -7.652  -7.804  1.00 41.82           N  
ATOM    901  CA  ASN   128      10.065  -8.957  -7.237  1.00 40.23           C  
ATOM    902  C   ASN   128      11.127  -9.241  -6.198  1.00 40.41           C  
ATOM    903  O   ASN   128      12.298  -8.871  -6.378  1.00 39.02           O  
ATOM    904  CB  ASN   128      10.104 -10.042  -8.298  1.00 40.14           C  
ATOM    905  CG  ASN   128       8.857 -10.065  -9.183  1.00 40.64           C  
ATOM    906  OD1 ASN   128       7.774  -9.582  -8.797  1.00 42.50           O  
ATOM    907  ND2 ASN   128       9.001 -10.667 -10.368  1.00 35.86           N  
ATOM    908  N   ILE   129      10.736  -9.889  -5.104  1.00 39.25           N  
ATOM    909  CA  ILE   129      11.724 -10.264  -4.089  1.00 39.89           C  
ATOM    910  C   ILE   129      12.189 -11.689  -4.363  1.00 39.72           C  
ATOM    911  O   ILE   129      11.367 -12.580  -4.538  1.00 40.66           O  
ATOM    912  CB  ILE   129      11.177 -10.050  -2.666  1.00 40.15           C  
ATOM    913  CG1 ILE   129      10.646  -8.609  -2.563  1.00 39.73           C  
ATOM    914  CG2 ILE   129      12.289 -10.383  -1.574  1.00 38.54           C  
ATOM    915  CD1 ILE   129       9.946  -8.267  -1.304  1.00 41.42           C  
ATOM    916  N   TYR   130      13.505 -11.885  -4.456  1.00 39.44           N  
ATOM    917  CA  TYR   130      14.075 -13.199  -4.695  1.00 39.04           C  
ATOM    918  C   TYR   130      14.927 -13.622  -3.518  1.00 39.32           C  
ATOM    919  O   TYR   130      15.779 -12.858  -3.059  1.00 40.79           O  
ATOM    920  CB  TYR   130      14.921 -13.200  -5.984  1.00 38.38           C  
ATOM    921  CG  TYR   130      14.096 -13.000  -7.267  1.00 37.81           C  
ATOM    922  CD1 TYR   130      13.542 -14.087  -7.933  1.00 36.33           C  
ATOM    923  CD2 TYR   130      13.858 -11.725  -7.789  1.00 36.31           C  
ATOM    924  CE1 TYR   130      12.789 -13.923  -9.121  1.00 38.63           C  
ATOM    925  CE2 TYR   130      13.089 -11.540  -8.988  1.00 38.25           C  
ATOM    926  CZ  TYR   130      12.559 -12.647  -9.645  1.00 38.04           C  
ATOM    927  OH  TYR   130      11.771 -12.507 -10.806  1.00 40.74           O  
ATOM    928  N   VAL   131      14.753 -14.852  -3.063  1.00 38.99           N  
ATOM    929  CA  VAL   131      15.594 -15.364  -1.979  1.00 39.24           C  
ATOM    930  C   VAL   131      16.495 -16.532  -2.447  1.00 39.70           C  
ATOM    931  O   VAL   131      16.069 -17.417  -3.165  1.00 38.44           O  
ATOM    932  CB  VAL   131      14.755 -15.722  -0.681  1.00 40.15           C  
ATOM    933  CG1 VAL   131      15.672 -16.298   0.427  1.00 38.58           C  
ATOM    934  CG2 VAL   131      14.018 -14.500  -0.156  1.00 38.05           C  
ATOM    935  N   THR   132      17.747 -16.518  -2.008  1.00 40.04           N  
ATOM    936  CA  THR   132      18.662 -17.596  -2.286  1.00 40.59           C  
ATOM    937  C   THR   132      19.160 -18.076  -0.934  1.00 41.95           C  
ATOM    938  O   THR   132      19.635 -17.260  -0.131  1.00 42.01           O  
ATOM    939  CB  THR   132      19.816 -17.068  -3.200  1.00 40.85           C  
ATOM    940  OG1 THR   132      19.228 -16.494  -4.379  1.00 36.46           O  
ATOM    941  CG2 THR   132      20.793 -18.173  -3.591  1.00 40.09           C  
ATOM    942  N   LEU   133      19.006 -19.376  -0.646  1.00 43.00           N  
ATOM    943  CA  LEU   133      19.478 -19.932   0.642  1.00 43.84           C  
ATOM    944  C   LEU   133      21.003 -19.800   0.731  1.00 45.22           C  
ATOM    945  O   LEU   133      21.701 -19.944  -0.277  1.00 45.17           O  
ATOM    946  CB  LEU   133      19.037 -21.390   0.842  1.00 42.75           C  
ATOM    947  CG  LEU   133      17.561 -21.744   1.009  1.00 43.41           C  
ATOM    948  CD1 LEU   133      17.355 -23.248   1.217  1.00 40.34           C  
ATOM    949  CD2 LEU   133      16.914 -20.945   2.158  1.00 38.38           C  
ATOM    950  N   SER   134      21.518 -19.499   1.921  1.00 46.77           N  
ATOM    951  CA  SER   134      22.947 -19.315   2.087  1.00 48.93           C  
ATOM    952  C   SER   134      23.636 -20.617   2.454  1.00 50.30           C  
ATOM    953  O   SER   134      23.052 -21.430   3.178  1.00 50.76           O  
ATOM    954  CB  SER   134      23.217 -18.359   3.212  1.00 48.46           C  
ATOM    955  OG  SER   134      23.246 -19.084   4.431  1.00 51.29           O  
ATOM    956  N   LYS   135      24.888 -20.776   1.999  1.00 51.51           N  
ATOM    957  CA  LYS   135      25.747 -21.898   2.405  1.00 52.31           C  
ATOM    958  C   LYS   135      26.749 -21.454   3.469  1.00 53.22           C  
ATOM    959  O   LYS   135      27.278 -22.269   4.220  1.00 53.31           O  
ATOM    960  CB  LYS   135      26.517 -22.448   1.204  1.00 52.38           C  
ATOM    961  CG  LYS   135      25.832 -22.306  -0.127  1.00 52.11           C  
ATOM    962  CD  LYS   135      26.629 -23.075  -1.207  1.00 52.26           C  
ATOM    963  CE  LYS   135      26.349 -22.568  -2.623  1.00 51.66           C  
ATOM    964  NZ  LYS   135      27.234 -23.237  -3.657  1.00 51.02           N  
ATOM    965  N   GLU   136      27.006 -20.152   3.518  1.00 54.27           N  
ATOM    966  CA  GLU   136      27.956 -19.560   4.457  1.00 55.33           C  
ATOM    967  C   GLU   136      27.206 -19.019   5.694  1.00 55.09           C  
ATOM    968  O   GLU   136      26.128 -18.427   5.545  1.00 56.28           O  
ATOM    969  CB  GLU   136      28.719 -18.437   3.723  1.00 55.83           C  
ATOM    970  CG  GLU   136      29.997 -17.945   4.391  1.00 57.12           C  
ATOM    971  CD  GLU   136      31.278 -18.520   3.788  1.00 61.09           C  
ATOM    972  OE1 GLU   136      32.107 -19.071   4.568  1.00 61.63           O  
ATOM    973  OE2 GLU   136      31.476 -18.395   2.549  1.00 61.99           O  
ATOM    974  N   PRO   137      27.715 -19.267   6.936  1.00 55.06           N  
ATOM    975  CA  PRO   137      28.830 -20.105   7.419  1.00 54.23           C  
ATOM    976  C   PRO   137      28.458 -21.596   7.460  1.00 53.34           C  
ATOM    977  O   PRO   137      27.266 -21.937   7.390  1.00 53.31           O  
ATOM    978  CB  PRO   137      29.047 -19.593   8.848  1.00 53.86           C  
ATOM    979  CG  PRO   137      27.741 -19.181   9.281  1.00 54.97           C  
ATOM    980  CD  PRO   137      27.050 -18.585   8.071  1.00 54.57           C  
ATOM    981  N   PHE   138      29.459 -22.466   7.614  1.00 51.43           N  
ATOM    982  CA  PHE   138      29.223 -23.905   7.498  1.00 50.12           C  
ATOM    983  C   PHE   138      28.121 -24.426   8.435  1.00 48.87           C  
ATOM    984  O   PHE   138      27.243 -25.166   7.987  1.00 48.71           O  
ATOM    985  CB  PHE   138      30.543 -24.770   7.566  1.00 50.26           C  
ATOM    986  CG  PHE   138      30.222 -26.220   7.875  1.00 49.81           C  
ATOM    987  CD1 PHE   138      29.654 -27.076   6.745  1.00 51.49           C  
ATOM    988  CD2 PHE   138      30.384 -26.741   9.264  1.00 51.50           C  
ATOM    989  CE1 PHE   138      29.370 -28.414   7.051  1.00 51.29           C  
ATOM    990  CE2 PHE   138      30.105 -28.080   9.579  1.00 50.91           C  
ATOM    991  CZ  PHE   138      29.521 -28.922   8.458  1.00 51.61           C  
ATOM    992  N   LYS   139      28.144 -24.002   9.701  1.00 48.30           N  
ATOM    993  CA  LYS   139      27.051 -24.305  10.665  1.00 47.27           C  
ATOM    994  C   LYS   139      26.547 -23.108  11.510  1.00 45.92           C  
ATOM    995  O   LYS   139      27.349 -22.313  11.982  1.00 44.08           O  
ATOM    996  CB  LYS   139      27.496 -25.468  11.566  1.00 47.34           C  
ATOM    997  CG  LYS   139      26.480 -25.899  12.624  1.00 48.98           C  
ATOM    998  CD  LYS   139      27.075 -27.027  13.507  1.00 49.64           C  
ATOM    999  CE  LYS   139      26.266 -27.148  14.818  1.00 54.05           C  
ATOM   1000  NZ  LYS   139      26.806 -28.256  15.668  1.00 56.44           N  
ATOM   1001  N   CYS   140      25.210 -22.982  11.655  1.00 45.92           N  
ATOM   1002  CA  CYS   140      24.511 -22.004  12.540  1.00 46.22           C  
ATOM   1003  C   CYS   140      23.654 -22.698  13.584  1.00 45.35           C  
ATOM   1004  O   CYS   140      23.116 -23.767  13.310  1.00 46.60           O  
ATOM   1005  CB  CYS   140      23.596 -21.043  11.775  1.00 45.85           C  
ATOM   1006  SG  CYS   140      24.500 -20.055  10.567  1.00 48.91           S  
ATOM   1007  N   ASP   141      23.543 -22.117  14.776  1.00 44.08           N  
ATOM   1008  CA  ASP   141      22.661 -22.691  15.792  1.00 44.62           C  
ATOM   1009  C   ASP   141      21.209 -22.781  15.266  1.00 44.81           C  
ATOM   1010  O   ASP   141      20.514 -23.715  15.642  1.00 45.32           O  
ATOM   1011  CB  ASP   141      22.668 -21.877  17.082  1.00 44.12           C  
ATOM   1012  CG  ASP   141      23.859 -22.159  17.927  1.00 46.44           C  
ATOM   1013  OD1 ASP   141      24.743 -22.891  17.458  1.00 44.54           O  
ATOM   1014  OD2 ASP   141      23.923 -21.655  19.069  1.00 46.27           O  
ATOM   1015  N   SER   142      20.778 -21.871  14.383  1.00 43.14           N  
ATOM   1016  CA  SER   142      19.386 -21.945  13.855  1.00 44.31           C  
ATOM   1017  C   SER   142      19.056 -23.136  12.964  1.00 44.24           C  
ATOM   1018  O   SER   142      17.855 -23.430  12.753  1.00 44.10           O  
ATOM   1019  CB  SER   142      18.968 -20.672  13.109  1.00 42.51           C  
ATOM   1020  OG  SER   142      19.724 -20.520  11.920  1.00 44.57           O  
ATOM   1021  N   ASP   143      20.096 -23.789  12.422  1.00 45.06           N  
ATOM   1022  CA  ASP   143      19.920 -24.950  11.547  1.00 45.46           C  
ATOM   1023  C   ASP   143      19.147 -26.078  12.227  1.00 46.54           C  
ATOM   1024  O   ASP   143      18.376 -26.748  11.569  1.00 46.75           O  
ATOM   1025  CB  ASP   143      21.271 -25.513  11.043  1.00 45.66           C  
ATOM   1026  CG  ASP   143      22.036 -24.532  10.155  1.00 44.83           C  
ATOM   1027  OD1 ASP   143      21.419 -23.599   9.598  1.00 42.43           O  
ATOM   1028  OD2 ASP   143      23.265 -24.707  10.002  1.00 42.61           O  
ATOM   1029  N   TYR   144      19.381 -26.312  13.524  1.00 47.69           N  
ATOM   1030  CA  TYR   144      18.623 -27.347  14.256  1.00 48.61           C  
ATOM   1031  C   TYR   144      17.099 -27.159  14.128  1.00 48.69           C  
ATOM   1032  O   TYR   144      16.365 -28.135  13.991  1.00 47.78           O  
ATOM   1033  CB  TYR   144      18.997 -27.374  15.736  1.00 49.29           C  
ATOM   1034  CG  TYR   144      18.236 -28.431  16.549  1.00 50.70           C  
ATOM   1035  CD1 TYR   144      18.607 -29.785  16.506  1.00 52.62           C  
ATOM   1036  CD2 TYR   144      17.137 -28.072  17.355  1.00 50.86           C  
ATOM   1037  CE1 TYR   144      17.910 -30.757  17.256  1.00 53.14           C  
ATOM   1038  CE2 TYR   144      16.437 -29.036  18.096  1.00 50.65           C  
ATOM   1039  CZ  TYR   144      16.825 -30.359  18.054  1.00 51.92           C  
ATOM   1040  OH  TYR   144      16.129 -31.298  18.797  1.00 51.39           O  
ATOM   1041  N   TYR   145      16.644 -25.905  14.171  1.00 48.97           N  
ATOM   1042  CA  TYR   145      15.207 -25.585  14.134  1.00 49.21           C  
ATOM   1043  C   TYR   145      14.692 -25.435  12.713  1.00 49.99           C  
ATOM   1044  O   TYR   145      13.494 -25.243  12.506  1.00 50.05           O  
ATOM   1045  CB  TYR   145      14.899 -24.356  15.003  1.00 50.10           C  
ATOM   1046  CG  TYR   145      15.084 -24.675  16.463  1.00 49.20           C  
ATOM   1047  CD1 TYR   145      14.246 -25.591  17.080  1.00 50.84           C  
ATOM   1048  CD2 TYR   145      16.103 -24.109  17.212  1.00 45.52           C  
ATOM   1049  CE1 TYR   145      14.402 -25.937  18.406  1.00 51.72           C  
ATOM   1050  CE2 TYR   145      16.267 -24.456  18.567  1.00 47.36           C  
ATOM   1051  CZ  TYR   145      15.403 -25.363  19.144  1.00 50.04           C  
ATOM   1052  OH  TYR   145      15.524 -25.798  20.451  1.00 53.65           O  
ATOM   1053  N   ALA   146      15.602 -25.555  11.741  1.00 49.88           N  
ATOM   1054  CA  ALA   146      15.292 -25.302  10.345  1.00 50.90           C  
ATOM   1055  C   ALA   146      14.972 -26.581   9.602  1.00 52.22           C  
ATOM   1056  O   ALA   146      14.408 -26.522   8.507  1.00 52.25           O  
ATOM   1057  CB  ALA   146      16.440 -24.593   9.653  1.00 50.05           C  
ATOM   1058  N   THR   147      15.340 -27.724  10.190  1.00 53.87           N  
ATOM   1059  CA  THR   147      15.284 -29.020   9.494  1.00 54.91           C  
ATOM   1060  C   THR   147      14.885 -30.235  10.356  1.00 55.97           C  
ATOM   1061  O   THR   147      15.363 -30.403  11.483  1.00 55.90           O  
ATOM   1062  CB  THR   147      16.649 -29.340   8.805  1.00 55.15           C  
ATOM   1063  OG1 THR   147      17.733 -29.043   9.703  1.00 54.95           O  
ATOM   1064  CG2 THR   147      16.822 -28.514   7.524  1.00 55.67           C  
ATOM   1065  N   GLY   148      14.020 -31.085   9.788  1.00 57.03           N  
ATOM   1066  CA  GLY   148      13.682 -32.405  10.340  1.00 58.17           C  
ATOM   1067  C   GLY   148      12.993 -32.442  11.697  1.00 59.08           C  
ATOM   1068  O   GLY   148      12.159 -31.584  12.016  1.00 59.21           O  
ATOM   1069  N   GLU   149      13.354 -33.452  12.490  1.00 59.79           N  
ATOM   1070  CA  GLU   149      12.780 -33.700  13.825  1.00 60.24           C  
ATOM   1071  C   GLU   149      13.243 -32.700  14.895  1.00 60.72           C  
ATOM   1072  O   GLU   149      14.424 -32.708  15.283  1.00 61.14           O  
ATOM   1073  CB  GLU   149      13.135 -35.121  14.287  1.00 60.50           C  
ATOM   1074  CG  GLU   149      12.122 -36.220  13.932  1.00 60.05           C  
ATOM   1075  CD  GLU   149      11.038 -36.365  14.988  1.00 59.99           C  
ATOM   1076  OE1 GLU   149      10.594 -37.506  15.238  1.00 58.25           O  
ATOM   1077  OE2 GLU   149      10.638 -35.330  15.575  1.00 60.64           O  
ATOM   1078  N   PHE   150      12.312 -31.853  15.361  1.00 60.39           N  
ATOM   1079  CA  PHE   150      12.536 -30.943  16.513  1.00 60.35           C  
ATOM   1080  C   PHE   150      11.287 -30.683  17.391  1.00 59.56           C  
ATOM   1081  O   PHE   150      10.146 -30.940  16.985  1.00 59.84           O  
ATOM   1082  CB  PHE   150      13.215 -29.610  16.101  1.00 60.16           C  
ATOM   1083  CG  PHE   150      12.466 -28.833  15.057  1.00 61.05           C  
ATOM   1084  CD1 PHE   150      11.587 -27.820  15.425  1.00 62.70           C  
ATOM   1085  CD2 PHE   150      12.659 -29.093  13.697  1.00 62.07           C  
ATOM   1086  CE1 PHE   150      10.890 -27.086  14.451  1.00 62.87           C  
ATOM   1087  CE2 PHE   150      11.957 -28.387  12.708  1.00 63.06           C  
ATOM   1088  CZ  PHE   150      11.069 -27.377  13.087  1.00 63.13           C  
ATOM   1089  N   LYS   151      11.531 -30.222  18.613  1.00 58.08           N  
ATOM   1090  CA  LYS   151      10.482 -29.702  19.473  1.00 56.42           C  
ATOM   1091  C   LYS   151      10.831 -28.252  19.769  1.00 55.24           C  
ATOM   1092  O   LYS   151      12.015 -27.902  19.798  1.00 54.83           O  
ATOM   1093  CB  LYS   151      10.362 -30.540  20.750  1.00 57.09           C  
ATOM   1094  CG  LYS   151       9.370 -31.678  20.611  1.00 56.58           C  
ATOM   1095  CD  LYS   151       8.705 -31.985  21.949  1.00 59.54           C  
ATOM   1096  CE  LYS   151       7.414 -32.786  21.781  1.00 59.45           C  
ATOM   1097  NZ  LYS   151       6.864 -33.245  23.089  1.00 61.73           N  
ATOM   1098  N   VAL   152       9.824 -27.397  19.929  1.00 53.60           N  
ATOM   1099  CA  VAL   152      10.101 -25.999  20.303  1.00 53.08           C  
ATOM   1100  C   VAL   152       9.768 -25.697  21.790  1.00 52.22           C  
ATOM   1101  O   VAL   152       8.860 -26.281  22.367  1.00 51.30           O  
ATOM   1102  CB  VAL   152       9.599 -24.922  19.235  1.00 52.74           C  
ATOM   1103  CG1 VAL   152      10.068 -25.286  17.829  1.00 52.40           C  
ATOM   1104  CG2 VAL   152       8.128 -24.765  19.228  1.00 52.79           C  
ATOM   1105  N   ILE   153      10.568 -24.835  22.417  1.00 52.29           N  
ATOM   1106  CA  ILE   153      10.422 -24.558  23.848  1.00 52.31           C  
ATOM   1107  C   ILE   153      10.173 -23.064  24.121  1.00 51.77           C  
ATOM   1108  O   ILE   153      10.922 -22.204  23.637  1.00 51.74           O  
ATOM   1109  CB  ILE   153      11.666 -24.997  24.592  1.00 52.99           C  
ATOM   1110  CG1 ILE   153      11.771 -26.531  24.594  1.00 52.49           C  
ATOM   1111  CG2 ILE   153      11.651 -24.415  26.010  1.00 55.15           C  
ATOM   1112  CD1 ILE   153      13.034 -27.088  25.334  1.00 53.41           C  
ATOM   1113  N   GLN   154       9.086 -22.744  24.829  1.00 50.54           N  
ATOM   1114  CA  GLN   154       8.852 -21.355  25.219  1.00 49.09           C  
ATOM   1115  C   GLN   154       9.033 -21.316  26.726  1.00 48.53           C  
ATOM   1116  O   GLN   154       8.355 -22.092  27.425  1.00 47.25           O  
ATOM   1117  CB  GLN   154       7.471 -20.847  24.760  1.00 48.43           C  
ATOM   1118  CG  GLN   154       7.220 -19.364  25.065  1.00 49.16           C  
ATOM   1119  CD  GLN   154       5.802 -18.889  24.709  1.00 50.58           C  
ATOM   1120  OE1 GLN   154       4.958 -19.678  24.258  1.00 53.72           O  
ATOM   1121  NE2 GLN   154       5.535 -17.587  24.925  1.00 50.75           N  
END
