
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  110 ( 1731),  selected  110 , name 2jo6_A
# Molecule2: number of CA atoms  136 ( 1099),  selected  136 , name T0391.pdb
# PARAMETERS: 2jo6_A.T0391.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      K      14           -
LGA    S     2_A      Y      15          4.074
LGA    Q     3_A      T      16          0.479
LGA    W     4_A      S      17          0.990
LGA    K     5_A      V      18          0.773
LGA    D     6_A      C      19          0.342
LGA    I     7_A      V      20          0.344
LGA    C     8_A      G      21          0.178
LGA    K     9_A      R      22          0.688
LGA    I    10_A      E      23          1.455
LGA    D    11_A      E      24          0.933
LGA    D    12_A      D      25          0.829
LGA    I    13_A      I      26          0.880
LGA    L    14_A      R      27          3.112
LGA    P    15_A      K      28          5.080
LGA    E    16_A      S      29           #
LGA    T    17_A      E      30          2.333
LGA    G    18_A      R      31          2.171
LGA    V    19_A      M      32          1.805
LGA    C    20_A      T      33          1.415
LGA    A    21_A      A      34          1.141
LGA    L    22_A      V      35          1.033
LGA    L    23_A      V      36          1.352
LGA    G    24_A      H      37          1.627
LGA    D    25_A      D      38          2.040
LGA    E    26_A      R      39          1.245
LGA    Q    27_A      E      40          1.227
LGA    V    28_A      V      41          0.968
LGA    A    29_A      V      42          1.188
LGA    I    30_A      I      43          0.429
LGA    F    31_A      F      44          0.733
LGA    R    32_A      Y      45          0.548
LGA    P    33_A      H      46          0.949
LGA    Y    34_A      K      47          2.288
LGA    H    35_A      G      48          4.116
LGA    S    36_A      -       -           -
LGA    D    37_A      -       -           -
LGA    Q    38_A      E      49          1.675
LGA    V    39_A      Y      50          0.224
LGA    F    40_A      H      51          0.748
LGA    A    41_A      A      52          0.671
LGA    I    42_A      M      53          1.012
LGA    S    43_A      D      54          1.114
LGA    N    44_A      I      55          0.742
LGA    I    45_A      R      56          0.681
LGA    D    46_A      C      57          1.887
LGA    P    47_A      Y      58          2.816
LGA    F    48_A      H      59          2.211
LGA    F    49_A      S      60          1.693
LGA    E    50_A      G      61          1.250
LGA    S    51_A      G      62          0.490
LGA    S    52_A      P      63          3.414
LGA    V    53_A      -       -           -
LGA    L    54_A      L      64          0.562
LGA    S    55_A      H      65          0.932
LGA    R    56_A      L      66          0.636
LGA    G    57_A      G      67          1.202
LGA    L    58_A      E      68          1.323
LGA    I    59_A      I      69          1.133
LGA    A    60_A      E      70          0.985
LGA    E    61_A      D      71          1.220
LGA    H    62_A      F      72          1.874
LGA    Q    63_A      N      73          2.035
LGA    G    64_A      G      74          1.855
LGA    E    65_A      Q      75          1.367
LGA    L    66_A      S      76          0.585
LGA    W    67_A      C      77          0.889
LGA    V    68_A      I      78          1.238
LGA    A    69_A      V      79          1.462
LGA    S    70_A      C      80          2.279
LGA    P    71_A      P      81          2.694
LGA    L    72_A      W      82          2.303
LGA    K    73_A      H      83          2.368
LGA    K    74_A      K      84          1.273
LGA    Q    75_A      Y      85          1.489
LGA    R    76_A      K      86          1.246
LGA    F    77_A      I      87          1.231
LGA    R    78_A      T      88          0.580
LGA    L    79_A      L      89          0.546
LGA    S    80_A      A      90          1.322
LGA    D    81_A      T      91          1.856
LGA    G    82_A      G      92          1.246
LGA    L    83_A      E      93          1.145
LGA    C    84_A      G      94          2.132
LGA    M    85_A      L      95          1.495
LGA    E    86_A      Y      96          5.790
LGA    D    87_A      Q      97           -
LGA    -       -      S      98           -
LGA    -       -      I      99           -
LGA    -       -      N     100           -
LGA    -       -      P     101           -
LGA    -       -      K     107           -
LGA    -       -      P     108           -
LGA    -       -      K     109           -
LGA    -       -      W     110           -
LGA    -       -      C     111           -
LGA    E    88_A      S     112          4.016
LGA    Q    89_A      K     113          2.707
LGA    F    90_A      G     114          4.832
LGA    S    91_A      V     115          1.875
LGA    V    92_A      K     116          3.065
LGA    -       -      Q     117           -
LGA    K    93_A      R     118          0.543
LGA    H    94_A      I     119          0.963
LGA    Y    95_A      H     120          0.303
LGA    E    96_A      T     121          0.538
LGA    A    97_A      V     122          0.430
LGA    R    98_A      K     123          0.881
LGA    V    99_A      V     124          0.972
LGA    K   100_A      D     125          1.232
LGA    D   101_A      N     126          0.847
LGA    G   102_A      G     127          0.804
LGA    V   103_A      N     128          0.743
LGA    V   104_A      I     129          0.726
LGA    Q   105_A      Y     130          0.543
LGA    L   106_A      V     131          0.708
LGA    R   107_A      T     132          1.015
LGA    G   108_A      L     133          1.560
LGA    G   109_A      S     134          4.637
LGA    S   110_A      K     135          2.455
LGA    -       -      E     136           -
LGA    -       -      P     137           -
LGA    -       -      F     138           -
LGA    -       -      K     139           -
LGA    -       -      C     140           -
LGA    -       -      D     141           -
LGA    -       -      S     142           -
LGA    -       -      D     143           -
LGA    -       -      Y     144           -
LGA    -       -      Y     145           -
LGA    -       -      A     146           -
LGA    -       -      T     147           -
LGA    -       -      G     148           -
LGA    -       -      E     149           -
LGA    -       -      F     150           -
LGA    -       -      K     151           -
LGA    -       -      V     152           -
LGA    -       -      I     153           -
LGA    -       -      Q     154           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  110  136    5.0    104    1.86    17.31     70.211     5.309

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.067338 * X  +   0.070444 * Y  +   0.995240 * Z  +  15.138758
  Y_new =   0.168143 * X  +  -0.984039 * Y  +   0.058275 * Z  + -11.763606
  Z_new =   0.983460 * X  +   0.163419 * Y  +  -0.078108 * Z  +   8.319879 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.016656   -1.124937  [ DEG:   115.5459    -64.4541 ]
  Theta =  -1.388665   -1.752927  [ DEG:   -79.5647   -100.4353 ]
  Phi   =   1.189879   -1.951714  [ DEG:    68.1750   -111.8250 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2jo6_A                                        
REMARK     2: T0391.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2jo6_A.T0391.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  110  136   5.0  104   1.86   17.31  70.211
REMARK  ---------------------------------------------------------- 
MOLECULE 2jo6_A
HEADER    OXIDOREDUCTASE                          21-FEB-07   2JO6              
TITLE     NMR STRUCTURE OF THE E.COLI PROTEIN NIRD, NORTHEAST                   
TITLE    2 STRUCTURAL GENOMICS TARGET ET100                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NITRITE REDUCTASE [NAD(P)H] SMALL SUBUNIT;                 
COMPND   3 CHAIN: A;                                                            
COMPND   4 EC: 1.7.1.4;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: NIRD;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: VECTOR;                               
SOURCE   8 EXPRESSION_SYSTEM_VECTOR: PET                                        
KEYWDS    ALL BETA, ISP DOMAIN, RIESKE IRON-SULFUR PROTEIN, 3-LAYER             
KEYWDS   2 SANDWICH, STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE              
KEYWDS   3 INITIATIVE, NORTHEAST STRUCTURAL GENOMICS CONSORTIUM, NESG           
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    T.A.RAMELOT,J.R.CORT,A.A.YEE,V.GUIDO,J.A.LUKIN,                       
AUTHOR   2 C.H.ARROWSMITH,M.A.KENNEDY,NORTHEAST STRUCTURAL GENOMICS             
AUTHOR   3 CONSORTIUM (NESG)                                                    
REVDAT   1   27-MAR-07 2JO6    0                                                
JRNL        AUTH   T.A.RAMELOT,J.R.CORT,A.A.YEE,C.H.ARROWSMITH,                 
JRNL        AUTH 2 M.A.KENNEDY                                                  
JRNL        TITL   NMR STRUCTURE OF E.COLI NIRD.                                
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2JO6 A    1   108  UNP    P0A9I8   NIRD_ECOLI       1    108             
SEQRES   1 A  113  GLN GLY HIS MET SER GLN TRP LYS ASP ILE CYS LYS ILE          
SEQRES   2 A  113  ASP ASP ILE LEU PRO GLU THR GLY VAL CYS ALA LEU LEU          
SEQRES   3 A  113  GLY ASP GLU GLN VAL ALA ILE PHE ARG PRO TYR HIS SER          
SEQRES   4 A  113  ASP GLN VAL PHE ALA ILE SER ASN ILE ASP PRO PHE PHE          
SEQRES   5 A  113  GLU SER SER VAL LEU SER ARG GLY LEU ILE ALA GLU HIS          
SEQRES   6 A  113  GLN GLY GLU LEU TRP VAL ALA SER PRO LEU LYS LYS GLN          
SEQRES   7 A  113  ARG PHE ARG LEU SER ASP GLY LEU CYS MET GLU ASP GLU          
SEQRES   8 A  113  GLN PHE SER VAL LYS HIS TYR GLU ALA ARG VAL LYS ASP          
SEQRES   9 A  113  GLY VAL VAL GLN LEU ARG GLY GLY SER                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      26.682 -22.126  -7.481  1.00  0.00           N  
ATOM      2  CA  MET A   1      25.284 -22.606  -7.495  1.00  0.00           C  
ATOM      3  C   MET A   1      24.420 -21.684  -6.648  1.00  0.00           C  
ATOM      4  O   MET A   1      24.659 -21.523  -5.450  1.00  0.00           O  
ATOM      5  CB  MET A   1      25.221 -24.050  -6.976  1.00  0.00           C  
ATOM      6  CG  MET A   1      23.872 -24.735  -7.167  1.00  0.00           C  
ATOM      7  SD  MET A   1      22.627 -24.219  -5.968  1.00  0.00           S  
ATOM      8  CE  MET A   1      23.380 -24.773  -4.441  1.00  0.00           C  
ATOM      9  HA  MET A   1      24.927 -22.579  -8.514  1.00  0.00           H  
ATOM     10  HB2 MET A   1      25.966 -24.634  -7.494  1.00  0.00           H  
ATOM     11  HB3 MET A   1      25.451 -24.049  -5.921  1.00  0.00           H  
ATOM     12  HG2 MET A   1      23.506 -24.506  -8.157  1.00  0.00           H  
ATOM     13  HG3 MET A   1      24.013 -25.803  -7.079  1.00  0.00           H  
ATOM     14  HE1 MET A   1      23.535 -25.841  -4.481  1.00  0.00           H  
ATOM     15  HE2 MET A   1      22.730 -24.533  -3.611  1.00  0.00           H  
ATOM     16  HE3 MET A   1      24.331 -24.276  -4.306  1.00  0.00           H  
ATOM     17  N   SER A   2      23.431 -21.064  -7.276  1.00  0.00           N  
ATOM     18  CA  SER A   2      22.576 -20.107  -6.593  1.00  0.00           C  
ATOM     19  C   SER A   2      21.140 -20.223  -7.086  1.00  0.00           C  
ATOM     20  O   SER A   2      20.870 -20.068  -8.277  1.00  0.00           O  
ATOM     21  CB  SER A   2      23.081 -18.682  -6.827  1.00  0.00           C  
ATOM     22  OG  SER A   2      24.476 -18.581  -6.584  1.00  0.00           O  
ATOM     23  H   SER A   2      23.261 -21.266  -8.224  1.00  0.00           H  
ATOM     24  HA  SER A   2      22.605 -20.325  -5.536  1.00  0.00           H  
ATOM     25  HB2 SER A   2      22.879 -18.389  -7.844  1.00  0.00           H  
ATOM     26  HB3 SER A   2      22.566 -18.012  -6.156  1.00  0.00           H  
ATOM     27  HG  SER A   2      24.955 -19.023  -7.296  1.00  0.00           H  
ATOM     28  N   GLN A   3      20.225 -20.492  -6.171  1.00  0.00           N  
ATOM     29  CA  GLN A   3      18.820 -20.589  -6.518  1.00  0.00           C  
ATOM     30  C   GLN A   3      18.052 -19.380  -5.986  1.00  0.00           C  
ATOM     31  O   GLN A   3      17.553 -19.378  -4.862  1.00  0.00           O  
ATOM     32  CB  GLN A   3      18.202 -21.919  -6.026  1.00  0.00           C  
ATOM     33  CG  GLN A   3      18.159 -22.119  -4.507  1.00  0.00           C  
ATOM     34  CD  GLN A   3      19.528 -22.130  -3.858  1.00  0.00           C  
ATOM     35  OE1 GLN A   3      20.041 -21.089  -3.449  1.00  0.00           O  
ATOM     36  NE2 GLN A   3      20.127 -23.305  -3.756  1.00  0.00           N  
ATOM     37  H   GLN A   3      20.499 -20.626  -5.236  1.00  0.00           H  
ATOM     38  HA  GLN A   3      18.762 -20.567  -7.597  1.00  0.00           H  
ATOM     39  HB2 GLN A   3      17.189 -21.980  -6.393  1.00  0.00           H  
ATOM     40  HB3 GLN A   3      18.769 -22.735  -6.453  1.00  0.00           H  
ATOM     41  HG2 GLN A   3      17.582 -21.317  -4.072  1.00  0.00           H  
ATOM     42  HG3 GLN A   3      17.672 -23.061  -4.300  1.00  0.00           H  
ATOM     43 HE21 GLN A   3      19.660 -24.096  -4.101  1.00  0.00           H  
ATOM     44 HE22 GLN A   3      21.018 -23.335  -3.348  1.00  0.00           H  
ATOM     45  N   TRP A   4      18.006 -18.325  -6.788  1.00  0.00           N  
ATOM     46  CA  TRP A   4      17.241 -17.141  -6.431  1.00  0.00           C  
ATOM     47  C   TRP A   4      15.754 -17.412  -6.602  1.00  0.00           C  
ATOM     48  O   TRP A   4      15.201 -17.258  -7.692  1.00  0.00           O  
ATOM     49  CB  TRP A   4      17.654 -15.937  -7.281  1.00  0.00           C  
ATOM     50  CG  TRP A   4      19.019 -15.409  -6.959  1.00  0.00           C  
ATOM     51  CD1 TRP A   4      20.183 -15.682  -7.617  1.00  0.00           C  
ATOM     52  CD2 TRP A   4      19.358 -14.509  -5.898  1.00  0.00           C  
ATOM     53  NE1 TRP A   4      21.225 -15.007  -7.028  1.00  0.00           N  
ATOM     54  CE2 TRP A   4      20.745 -14.278  -5.973  1.00  0.00           C  
ATOM     55  CE3 TRP A   4      18.624 -13.873  -4.893  1.00  0.00           C  
ATOM     56  CZ2 TRP A   4      21.410 -13.439  -5.080  1.00  0.00           C  
ATOM     57  CZ3 TRP A   4      19.285 -13.043  -4.007  1.00  0.00           C  
ATOM     58  CH2 TRP A   4      20.665 -12.830  -4.106  1.00  0.00           C  
ATOM     59  H   TRP A   4      18.497 -18.344  -7.634  1.00  0.00           H  
ATOM     60  HA  TRP A   4      17.437 -16.923  -5.392  1.00  0.00           H  
ATOM     61  HB2 TRP A   4      17.649 -16.224  -8.322  1.00  0.00           H  
ATOM     62  HB3 TRP A   4      16.943 -15.139  -7.130  1.00  0.00           H  
ATOM     63  HD1 TRP A   4      20.260 -16.337  -8.471  1.00  0.00           H  
ATOM     64  HE1 TRP A   4      22.171 -15.040  -7.320  1.00  0.00           H  
ATOM     65  HE3 TRP A   4      17.558 -14.024  -4.799  1.00  0.00           H  
ATOM     66  HZ2 TRP A   4      22.474 -13.265  -5.144  1.00  0.00           H  
ATOM     67  HZ3 TRP A   4      18.732 -12.545  -3.224  1.00  0.00           H  
ATOM     68  HH2 TRP A   4      21.138 -12.175  -3.393  1.00  0.00           H  
ATOM     69  N   LYS A   5      15.119 -17.845  -5.528  1.00  0.00           N  
ATOM     70  CA  LYS A   5      13.709 -18.179  -5.571  1.00  0.00           C  
ATOM     71  C   LYS A   5      12.857 -16.932  -5.410  1.00  0.00           C  
ATOM     72  O   LYS A   5      13.050 -16.152  -4.475  1.00  0.00           O  
ATOM     73  CB  LYS A   5      13.352 -19.192  -4.481  1.00  0.00           C  
ATOM     74  CG  LYS A   5      11.884 -19.592  -4.496  1.00  0.00           C  
ATOM     75  CD  LYS A   5      11.526 -20.498  -3.331  1.00  0.00           C  
ATOM     76  CE  LYS A   5      10.054 -20.880  -3.365  1.00  0.00           C  
ATOM     77  NZ  LYS A   5       9.167 -19.687  -3.268  1.00  0.00           N  
ATOM     78  H   LYS A   5      15.618 -17.946  -4.685  1.00  0.00           H  
ATOM     79  HA  LYS A   5      13.504 -18.617  -6.536  1.00  0.00           H  
ATOM     80  HB2 LYS A   5      13.950 -20.080  -4.622  1.00  0.00           H  
ATOM     81  HB3 LYS A   5      13.580 -18.762  -3.516  1.00  0.00           H  
ATOM     82  HG2 LYS A   5      11.279 -18.700  -4.441  1.00  0.00           H  
ATOM     83  HG3 LYS A   5      11.676 -20.111  -5.421  1.00  0.00           H  
ATOM     84  HD2 LYS A   5      12.123 -21.396  -3.386  1.00  0.00           H  
ATOM     85  HD3 LYS A   5      11.733 -19.981  -2.407  1.00  0.00           H  
ATOM     86  HE2 LYS A   5       9.851 -21.395  -4.292  1.00  0.00           H  
ATOM     87  HE3 LYS A   5       9.848 -21.539  -2.535  1.00  0.00           H  
ATOM     88  HZ1 LYS A   5       9.489 -18.939  -3.918  1.00  0.00           H  
ATOM     89  HZ2 LYS A   5       9.167 -19.313  -2.294  1.00  0.00           H  
ATOM     90  HZ3 LYS A   5       8.188 -19.949  -3.522  1.00  0.00           H  
ATOM     91  N   ASP A   6      11.924 -16.748  -6.333  1.00  0.00           N  
ATOM     92  CA  ASP A   6      10.956 -15.667  -6.239  1.00  0.00           C  
ATOM     93  C   ASP A   6      10.027 -15.916  -5.061  1.00  0.00           C  
ATOM     94  O   ASP A   6       9.450 -17.000  -4.931  1.00  0.00           O  
ATOM     95  CB  ASP A   6      10.128 -15.556  -7.523  1.00  0.00           C  
ATOM     96  CG  ASP A   6      10.977 -15.360  -8.761  1.00  0.00           C  
ATOM     97  OD1 ASP A   6      11.276 -14.202  -9.110  1.00  0.00           O  
ATOM     98  OD2 ASP A   6      11.349 -16.369  -9.399  1.00  0.00           O  
ATOM     99  H   ASP A   6      11.888 -17.358  -7.104  1.00  0.00           H  
ATOM    100  HA  ASP A   6      11.493 -14.744  -6.079  1.00  0.00           H  
ATOM    101  HB2 ASP A   6       9.552 -16.460  -7.648  1.00  0.00           H  
ATOM    102  HB3 ASP A   6       9.454 -14.716  -7.436  1.00  0.00           H  
ATOM    103  N   ILE A   7       9.907 -14.933  -4.190  1.00  0.00           N  
ATOM    104  CA  ILE A   7       9.018 -15.045  -3.046  1.00  0.00           C  
ATOM    105  C   ILE A   7       7.717 -14.313  -3.325  1.00  0.00           C  
ATOM    106  O   ILE A   7       6.660 -14.929  -3.471  1.00  0.00           O  
ATOM    107  CB  ILE A   7       9.660 -14.465  -1.767  1.00  0.00           C  
ATOM    108  CG1 ILE A   7      11.018 -15.123  -1.504  1.00  0.00           C  
ATOM    109  CG2 ILE A   7       8.735 -14.649  -0.571  1.00  0.00           C  
ATOM    110  CD1 ILE A   7      10.951 -16.629  -1.365  1.00  0.00           C  
ATOM    111  H   ILE A   7      10.437 -14.111  -4.312  1.00  0.00           H  
ATOM    112  HA  ILE A   7       8.809 -16.091  -2.882  1.00  0.00           H  
ATOM    113  HB  ILE A   7       9.807 -13.406  -1.914  1.00  0.00           H  
ATOM    114 HG12 ILE A   7      11.684 -14.896  -2.323  1.00  0.00           H  
ATOM    115 HG13 ILE A   7      11.431 -14.723  -0.590  1.00  0.00           H  
ATOM    116 HG21 ILE A   7       8.556 -15.702  -0.412  1.00  0.00           H  
ATOM    117 HG22 ILE A   7       7.797 -14.149  -0.761  1.00  0.00           H  
ATOM    118 HG23 ILE A   7       9.196 -14.226   0.310  1.00  0.00           H  
ATOM    119 HD11 ILE A   7      10.310 -16.885  -0.534  1.00  0.00           H  
ATOM    120 HD12 ILE A   7      11.943 -17.017  -1.189  1.00  0.00           H  
ATOM    121 HD13 ILE A   7      10.552 -17.055  -2.274  1.00  0.00           H  
ATOM    122  N   CYS A   8       7.821 -13.000  -3.422  1.00  0.00           N  
ATOM    123  CA  CYS A   8       6.682 -12.141  -3.683  1.00  0.00           C  
ATOM    124  C   CYS A   8       7.188 -10.758  -4.054  1.00  0.00           C  
ATOM    125  O   CYS A   8       8.391 -10.502  -3.992  1.00  0.00           O  
ATOM    126  CB  CYS A   8       5.782 -12.058  -2.447  1.00  0.00           C  
ATOM    127  SG  CYS A   8       6.633 -11.479  -0.960  1.00  0.00           S  
ATOM    128  H   CYS A   8       8.702 -12.584  -3.310  1.00  0.00           H  
ATOM    129  HA  CYS A   8       6.124 -12.554  -4.511  1.00  0.00           H  
ATOM    130  HB2 CYS A   8       4.971 -11.376  -2.646  1.00  0.00           H  
ATOM    131  HB3 CYS A   8       5.382 -13.038  -2.235  1.00  0.00           H  
ATOM    132  HG  CYS A   8       5.874 -11.780   0.088  1.00  0.00           H  
ATOM    133  N   LYS A   9       6.294  -9.867  -4.444  1.00  0.00           N  
ATOM    134  CA  LYS A   9       6.692  -8.501  -4.729  1.00  0.00           C  
ATOM    135  C   LYS A   9       6.866  -7.725  -3.431  1.00  0.00           C  
ATOM    136  O   LYS A   9       6.120  -7.925  -2.473  1.00  0.00           O  
ATOM    137  CB  LYS A   9       5.678  -7.817  -5.646  1.00  0.00           C  
ATOM    138  CG  LYS A   9       5.748  -8.310  -7.082  1.00  0.00           C  
ATOM    139  CD  LYS A   9       4.774  -7.566  -7.979  1.00  0.00           C  
ATOM    140  CE  LYS A   9       5.020  -7.873  -9.450  1.00  0.00           C  
ATOM    141  NZ  LYS A   9       4.774  -9.303  -9.782  1.00  0.00           N  
ATOM    142  H   LYS A   9       5.351 -10.128  -4.530  1.00  0.00           H  
ATOM    143  HA  LYS A   9       7.647  -8.541  -5.232  1.00  0.00           H  
ATOM    144  HB2 LYS A   9       4.684  -8.007  -5.269  1.00  0.00           H  
ATOM    145  HB3 LYS A   9       5.863  -6.753  -5.640  1.00  0.00           H  
ATOM    146  HG2 LYS A   9       6.750  -8.161  -7.455  1.00  0.00           H  
ATOM    147  HG3 LYS A   9       5.509  -9.364  -7.101  1.00  0.00           H  
ATOM    148  HD2 LYS A   9       3.767  -7.865  -7.725  1.00  0.00           H  
ATOM    149  HD3 LYS A   9       4.888  -6.505  -7.817  1.00  0.00           H  
ATOM    150  HE2 LYS A   9       4.361  -7.258 -10.046  1.00  0.00           H  
ATOM    151  HE3 LYS A   9       6.046  -7.629  -9.688  1.00  0.00           H  
ATOM    152  HZ1 LYS A   9       4.987  -9.477 -10.791  1.00  0.00           H  
ATOM    153  HZ2 LYS A   9       3.777  -9.547  -9.607  1.00  0.00           H  
ATOM    154  HZ3 LYS A   9       5.380  -9.923  -9.201  1.00  0.00           H  
ATOM    155  N   ILE A  10       7.853  -6.835  -3.411  1.00  0.00           N  
ATOM    156  CA  ILE A  10       8.213  -6.100  -2.201  1.00  0.00           C  
ATOM    157  C   ILE A  10       7.066  -5.200  -1.727  1.00  0.00           C  
ATOM    158  O   ILE A  10       7.068  -4.710  -0.600  1.00  0.00           O  
ATOM    159  CB  ILE A  10       9.495  -5.263  -2.429  1.00  0.00           C  
ATOM    160  CG1 ILE A  10      10.030  -4.713  -1.103  1.00  0.00           C  
ATOM    161  CG2 ILE A  10       9.228  -4.131  -3.414  1.00  0.00           C  
ATOM    162  CD1 ILE A  10      11.359  -4.007  -1.235  1.00  0.00           C  
ATOM    163  H   ILE A  10       8.360  -6.668  -4.240  1.00  0.00           H  
ATOM    164  HA  ILE A  10       8.422  -6.826  -1.429  1.00  0.00           H  
ATOM    165  HB  ILE A  10      10.242  -5.909  -2.866  1.00  0.00           H  
ATOM    166 HG12 ILE A  10       9.318  -4.007  -0.702  1.00  0.00           H  
ATOM    167 HG13 ILE A  10      10.153  -5.529  -0.407  1.00  0.00           H  
ATOM    168 HG21 ILE A  10      10.132  -3.556  -3.556  1.00  0.00           H  
ATOM    169 HG22 ILE A  10       8.452  -3.490  -3.024  1.00  0.00           H  
ATOM    170 HG23 ILE A  10       8.912  -4.545  -4.359  1.00  0.00           H  
ATOM    171 HD11 ILE A  10      11.676  -3.651  -0.266  1.00  0.00           H  
ATOM    172 HD12 ILE A  10      11.257  -3.173  -1.911  1.00  0.00           H  
ATOM    173 HD13 ILE A  10      12.096  -4.699  -1.624  1.00  0.00           H  
ATOM    174  N   ASP A  11       6.079  -5.011  -2.594  1.00  0.00           N  
ATOM    175  CA  ASP A  11       4.894  -4.221  -2.263  1.00  0.00           C  
ATOM    176  C   ASP A  11       4.079  -4.917  -1.172  1.00  0.00           C  
ATOM    177  O   ASP A  11       3.412  -4.266  -0.366  1.00  0.00           O  
ATOM    178  CB  ASP A  11       4.035  -4.030  -3.519  1.00  0.00           C  
ATOM    179  CG  ASP A  11       2.892  -3.050  -3.317  1.00  0.00           C  
ATOM    180  OD1 ASP A  11       1.805  -3.472  -2.870  1.00  0.00           O  
ATOM    181  OD2 ASP A  11       3.070  -1.855  -3.631  1.00  0.00           O  
ATOM    182  H   ASP A  11       6.145  -5.416  -3.480  1.00  0.00           H  
ATOM    183  HA  ASP A  11       5.220  -3.258  -1.903  1.00  0.00           H  
ATOM    184  HB2 ASP A  11       4.658  -3.662  -4.319  1.00  0.00           H  
ATOM    185  HB3 ASP A  11       3.617  -4.985  -3.806  1.00  0.00           H  
ATOM    186  N   ASP A  12       4.165  -6.245  -1.143  1.00  0.00           N  
ATOM    187  CA  ASP A  12       3.415  -7.053  -0.182  1.00  0.00           C  
ATOM    188  C   ASP A  12       3.993  -6.894   1.221  1.00  0.00           C  
ATOM    189  O   ASP A  12       3.275  -6.979   2.221  1.00  0.00           O  
ATOM    190  CB  ASP A  12       3.447  -8.527  -0.601  1.00  0.00           C  
ATOM    191  CG  ASP A  12       2.538  -9.401   0.242  1.00  0.00           C  
ATOM    192  OD1 ASP A  12       1.323  -9.440  -0.043  1.00  0.00           O  
ATOM    193  OD2 ASP A  12       3.031 -10.066   1.181  1.00  0.00           O  
ATOM    194  H   ASP A  12       4.757  -6.697  -1.782  1.00  0.00           H  
ATOM    195  HA  ASP A  12       2.392  -6.708  -0.181  1.00  0.00           H  
ATOM    196  HB2 ASP A  12       3.134  -8.609  -1.632  1.00  0.00           H  
ATOM    197  HB3 ASP A  12       4.457  -8.898  -0.509  1.00  0.00           H  
ATOM    198  N   ILE A  13       5.295  -6.650   1.286  1.00  0.00           N  
ATOM    199  CA  ILE A  13       5.981  -6.465   2.555  1.00  0.00           C  
ATOM    200  C   ILE A  13       5.977  -4.994   2.943  1.00  0.00           C  
ATOM    201  O   ILE A  13       6.672  -4.178   2.339  1.00  0.00           O  
ATOM    202  CB  ILE A  13       7.437  -6.975   2.495  1.00  0.00           C  
ATOM    203  CG1 ILE A  13       7.477  -8.402   1.942  1.00  0.00           C  
ATOM    204  CG2 ILE A  13       8.071  -6.925   3.879  1.00  0.00           C  
ATOM    205  CD1 ILE A  13       8.880  -8.940   1.743  1.00  0.00           C  
ATOM    206  H   ILE A  13       5.808  -6.579   0.453  1.00  0.00           H  
ATOM    207  HA  ILE A  13       5.452  -7.023   3.314  1.00  0.00           H  
ATOM    208  HB  ILE A  13       8.000  -6.324   1.842  1.00  0.00           H  
ATOM    209 HG12 ILE A  13       6.965  -9.061   2.627  1.00  0.00           H  
ATOM    210 HG13 ILE A  13       6.975  -8.424   0.986  1.00  0.00           H  
ATOM    211 HG21 ILE A  13       7.510  -7.553   4.555  1.00  0.00           H  
ATOM    212 HG22 ILE A  13       8.062  -5.908   4.242  1.00  0.00           H  
ATOM    213 HG23 ILE A  13       9.090  -7.277   3.820  1.00  0.00           H  
ATOM    214 HD11 ILE A  13       9.406  -8.934   2.687  1.00  0.00           H  
ATOM    215 HD12 ILE A  13       9.406  -8.320   1.033  1.00  0.00           H  
ATOM    216 HD13 ILE A  13       8.826  -9.951   1.368  1.00  0.00           H  
ATOM    217  N   LEU A  14       5.176  -4.670   3.948  1.00  0.00           N  
ATOM    218  CA  LEU A  14       5.024  -3.296   4.416  1.00  0.00           C  
ATOM    219  C   LEU A  14       6.352  -2.743   4.945  1.00  0.00           C  
ATOM    220  O   LEU A  14       7.252  -3.511   5.294  1.00  0.00           O  
ATOM    221  CB  LEU A  14       3.961  -3.249   5.518  1.00  0.00           C  
ATOM    222  CG  LEU A  14       2.598  -3.829   5.135  1.00  0.00           C  
ATOM    223  CD1 LEU A  14       1.675  -3.850   6.342  1.00  0.00           C  
ATOM    224  CD2 LEU A  14       1.976  -3.030   3.998  1.00  0.00           C  
ATOM    225  H   LEU A  14       4.669  -5.377   4.391  1.00  0.00           H  
ATOM    226  HA  LEU A  14       4.697  -2.691   3.583  1.00  0.00           H  
ATOM    227  HB2 LEU A  14       4.335  -3.795   6.371  1.00  0.00           H  
ATOM    228  HB3 LEU A  14       3.819  -2.219   5.806  1.00  0.00           H  
ATOM    229  HG  LEU A  14       2.728  -4.847   4.797  1.00  0.00           H  
ATOM    230 HD11 LEU A  14       1.537  -2.843   6.707  1.00  0.00           H  
ATOM    231 HD12 LEU A  14       2.113  -4.458   7.121  1.00  0.00           H  
ATOM    232 HD13 LEU A  14       0.718  -4.263   6.058  1.00  0.00           H  
ATOM    233 HD21 LEU A  14       1.020  -3.459   3.737  1.00  0.00           H  
ATOM    234 HD22 LEU A  14       2.629  -3.060   3.139  1.00  0.00           H  
ATOM    235 HD23 LEU A  14       1.838  -2.006   4.312  1.00  0.00           H  
ATOM    236  N   PRO A  15       6.490  -1.405   4.999  1.00  0.00           N  
ATOM    237  CA  PRO A  15       7.685  -0.742   5.538  1.00  0.00           C  
ATOM    238  C   PRO A  15       8.061  -1.263   6.921  1.00  0.00           C  
ATOM    239  O   PRO A  15       7.203  -1.386   7.797  1.00  0.00           O  
ATOM    240  CB  PRO A  15       7.272   0.728   5.611  1.00  0.00           C  
ATOM    241  CG  PRO A  15       6.236   0.875   4.555  1.00  0.00           C  
ATOM    242  CD  PRO A  15       5.488  -0.428   4.532  1.00  0.00           C  
ATOM    243  HA  PRO A  15       8.529  -0.849   4.873  1.00  0.00           H  
ATOM    244  HB2 PRO A  15       6.874   0.945   6.592  1.00  0.00           H  
ATOM    245  HB3 PRO A  15       8.127   1.357   5.416  1.00  0.00           H  
ATOM    246  HG2 PRO A  15       5.569   1.686   4.805  1.00  0.00           H  
ATOM    247  HG3 PRO A  15       6.706   1.054   3.600  1.00  0.00           H  
ATOM    248  HD2 PRO A  15       4.644  -0.391   5.205  1.00  0.00           H  
ATOM    249  HD3 PRO A  15       5.164  -0.661   3.529  1.00  0.00           H  
ATOM    250  N   GLU A  16       9.355  -1.538   7.093  1.00  0.00           N  
ATOM    251  CA  GLU A  16       9.900  -2.192   8.286  1.00  0.00           C  
ATOM    252  C   GLU A  16       8.971  -3.276   8.847  1.00  0.00           C  
ATOM    253  O   GLU A  16       8.389  -3.134   9.924  1.00  0.00           O  
ATOM    254  CB  GLU A  16      10.359  -1.198   9.372  1.00  0.00           C  
ATOM    255  CG  GLU A  16       9.420  -0.036   9.666  1.00  0.00           C  
ATOM    256  CD  GLU A  16       9.536   1.109   8.679  1.00  0.00           C  
ATOM    257  OE1 GLU A  16      10.566   1.203   7.978  1.00  0.00           O  
ATOM    258  OE2 GLU A  16       8.604   1.945   8.622  1.00  0.00           O  
ATOM    259  H   GLU A  16       9.978  -1.283   6.383  1.00  0.00           H  
ATOM    260  HA  GLU A  16      10.786  -2.710   7.940  1.00  0.00           H  
ATOM    261  HB2 GLU A  16      10.501  -1.743  10.291  1.00  0.00           H  
ATOM    262  HB3 GLU A  16      11.311  -0.785   9.070  1.00  0.00           H  
ATOM    263  HG2 GLU A  16       8.407  -0.399   9.647  1.00  0.00           H  
ATOM    264  HG3 GLU A  16       9.648   0.341  10.651  1.00  0.00           H  
ATOM    265  N   THR A  17       8.847  -4.363   8.084  1.00  0.00           N  
ATOM    266  CA  THR A  17       8.042  -5.516   8.476  1.00  0.00           C  
ATOM    267  C   THR A  17       8.768  -6.808   8.083  1.00  0.00           C  
ATOM    268  O   THR A  17       9.624  -6.797   7.194  1.00  0.00           O  
ATOM    269  CB  THR A  17       6.657  -5.501   7.788  1.00  0.00           C  
ATOM    270  OG1 THR A  17       6.145  -4.167   7.732  1.00  0.00           O  
ATOM    271  CG2 THR A  17       5.662  -6.384   8.529  1.00  0.00           C  
ATOM    272  H   THR A  17       9.324  -4.392   7.228  1.00  0.00           H  
ATOM    273  HA  THR A  17       7.903  -5.492   9.547  1.00  0.00           H  
ATOM    274  HB  THR A  17       6.768  -5.878   6.781  1.00  0.00           H  
ATOM    275  HG1 THR A  17       6.499  -3.731   6.943  1.00  0.00           H  
ATOM    276 HG21 THR A  17       4.703  -6.341   8.034  1.00  0.00           H  
ATOM    277 HG22 THR A  17       5.558  -6.036   9.546  1.00  0.00           H  
ATOM    278 HG23 THR A  17       6.020  -7.404   8.533  1.00  0.00           H  
ATOM    279  N   GLY A  18       8.429  -7.914   8.737  1.00  0.00           N  
ATOM    280  CA  GLY A  18       9.042  -9.186   8.410  1.00  0.00           C  
ATOM    281  C   GLY A  18       8.013 -10.253   8.092  1.00  0.00           C  
ATOM    282  O   GLY A  18       6.963 -10.317   8.732  1.00  0.00           O  
ATOM    283  H   GLY A  18       7.754  -7.868   9.446  1.00  0.00           H  
ATOM    284  HA2 GLY A  18       9.685  -9.056   7.554  1.00  0.00           H  
ATOM    285  HA3 GLY A  18       9.637  -9.514   9.250  1.00  0.00           H  
ATOM    286  N   VAL A  19       8.306 -11.082   7.098  1.00  0.00           N  
ATOM    287  CA  VAL A  19       7.409 -12.163   6.700  1.00  0.00           C  
ATOM    288  C   VAL A  19       8.181 -13.472   6.545  1.00  0.00           C  
ATOM    289  O   VAL A  19       9.392 -13.462   6.341  1.00  0.00           O  
ATOM    290  CB  VAL A  19       6.674 -11.851   5.375  1.00  0.00           C  
ATOM    291  CG1 VAL A  19       5.750 -10.654   5.537  1.00  0.00           C  
ATOM    292  CG2 VAL A  19       7.669 -11.609   4.247  1.00  0.00           C  
ATOM    293  H   VAL A  19       9.162 -10.971   6.622  1.00  0.00           H  
ATOM    294  HA  VAL A  19       6.669 -12.284   7.479  1.00  0.00           H  
ATOM    295  HB  VAL A  19       6.071 -12.706   5.113  1.00  0.00           H  
ATOM    296 HG11 VAL A  19       5.013 -10.870   6.297  1.00  0.00           H  
ATOM    297 HG12 VAL A  19       5.252 -10.453   4.600  1.00  0.00           H  
ATOM    298 HG13 VAL A  19       6.327  -9.790   5.831  1.00  0.00           H  
ATOM    299 HG21 VAL A  19       8.277 -12.491   4.109  1.00  0.00           H  
ATOM    300 HG22 VAL A  19       8.302 -10.770   4.497  1.00  0.00           H  
ATOM    301 HG23 VAL A  19       7.132 -11.397   3.334  1.00  0.00           H  
ATOM    302  N   CYS A  20       7.482 -14.594   6.639  1.00  0.00           N  
ATOM    303  CA  CYS A  20       8.123 -15.897   6.529  1.00  0.00           C  
ATOM    304  C   CYS A  20       7.960 -16.464   5.124  1.00  0.00           C  
ATOM    305  O   CYS A  20       6.861 -16.477   4.568  1.00  0.00           O  
ATOM    306  CB  CYS A  20       7.545 -16.874   7.558  1.00  0.00           C  
ATOM    307  SG  CYS A  20       8.273 -18.532   7.498  1.00  0.00           S  
ATOM    308  H   CYS A  20       6.515 -14.547   6.769  1.00  0.00           H  
ATOM    309  HA  CYS A  20       9.176 -15.762   6.727  1.00  0.00           H  
ATOM    310  HB2 CYS A  20       7.711 -16.480   8.550  1.00  0.00           H  
ATOM    311  HB3 CYS A  20       6.483 -16.974   7.389  1.00  0.00           H  
ATOM    312  HG  CYS A  20       8.813 -18.697   6.295  1.00  0.00           H  
ATOM    313  N   ALA A  21       9.064 -16.918   4.556  1.00  0.00           N  
ATOM    314  CA  ALA A  21       9.057 -17.563   3.256  1.00  0.00           C  
ATOM    315  C   ALA A  21       9.612 -18.975   3.377  1.00  0.00           C  
ATOM    316  O   ALA A  21      10.064 -19.379   4.452  1.00  0.00           O  
ATOM    317  CB  ALA A  21       9.871 -16.755   2.260  1.00  0.00           C  
ATOM    318  H   ALA A  21       9.921 -16.817   5.033  1.00  0.00           H  
ATOM    319  HA  ALA A  21       8.036 -17.610   2.906  1.00  0.00           H  
ATOM    320  HB1 ALA A  21       9.453 -15.762   2.173  1.00  0.00           H  
ATOM    321  HB2 ALA A  21       9.846 -17.241   1.295  1.00  0.00           H  
ATOM    322  HB3 ALA A  21      10.894 -16.686   2.601  1.00  0.00           H  
ATOM    323  N   LEU A  22       9.580 -19.720   2.283  1.00  0.00           N  
ATOM    324  CA  LEU A  22      10.070 -21.088   2.283  1.00  0.00           C  
ATOM    325  C   LEU A  22      11.124 -21.289   1.205  1.00  0.00           C  
ATOM    326  O   LEU A  22      10.848 -21.127   0.015  1.00  0.00           O  
ATOM    327  CB  LEU A  22       8.922 -22.079   2.069  1.00  0.00           C  
ATOM    328  CG  LEU A  22       7.886 -22.139   3.192  1.00  0.00           C  
ATOM    329  CD1 LEU A  22       6.778 -23.116   2.836  1.00  0.00           C  
ATOM    330  CD2 LEU A  22       8.541 -22.540   4.504  1.00  0.00           C  
ATOM    331  H   LEU A  22       9.226 -19.337   1.452  1.00  0.00           H  
ATOM    332  HA  LEU A  22      10.518 -21.279   3.248  1.00  0.00           H  
ATOM    333  HB2 LEU A  22       8.414 -21.812   1.153  1.00  0.00           H  
ATOM    334  HB3 LEU A  22       9.346 -23.064   1.949  1.00  0.00           H  
ATOM    335  HG  LEU A  22       7.443 -21.163   3.321  1.00  0.00           H  
ATOM    336 HD11 LEU A  22       6.291 -22.791   1.928  1.00  0.00           H  
ATOM    337 HD12 LEU A  22       6.058 -23.152   3.639  1.00  0.00           H  
ATOM    338 HD13 LEU A  22       7.200 -24.099   2.685  1.00  0.00           H  
ATOM    339 HD21 LEU A  22       9.301 -21.817   4.764  1.00  0.00           H  
ATOM    340 HD22 LEU A  22       8.992 -23.516   4.399  1.00  0.00           H  
ATOM    341 HD23 LEU A  22       7.794 -22.571   5.283  1.00  0.00           H  
ATOM    342  N   LEU A  23      12.333 -21.622   1.629  1.00  0.00           N  
ATOM    343  CA  LEU A  23      13.395 -21.994   0.710  1.00  0.00           C  
ATOM    344  C   LEU A  23      13.641 -23.491   0.831  1.00  0.00           C  
ATOM    345  O   LEU A  23      14.482 -23.935   1.615  1.00  0.00           O  
ATOM    346  CB  LEU A  23      14.678 -21.212   1.011  1.00  0.00           C  
ATOM    347  CG  LEU A  23      15.844 -21.474   0.052  1.00  0.00           C  
ATOM    348  CD1 LEU A  23      15.494 -21.020  -1.355  1.00  0.00           C  
ATOM    349  CD2 LEU A  23      17.099 -20.771   0.539  1.00  0.00           C  
ATOM    350  H   LEU A  23      12.516 -21.626   2.597  1.00  0.00           H  
ATOM    351  HA  LEU A  23      13.065 -21.771  -0.295  1.00  0.00           H  
ATOM    352  HB2 LEU A  23      14.446 -20.158   0.981  1.00  0.00           H  
ATOM    353  HB3 LEU A  23      15.002 -21.463   2.010  1.00  0.00           H  
ATOM    354  HG  LEU A  23      16.046 -22.536   0.021  1.00  0.00           H  
ATOM    355 HD11 LEU A  23      14.621 -21.554  -1.698  1.00  0.00           H  
ATOM    356 HD12 LEU A  23      16.324 -21.222  -2.015  1.00  0.00           H  
ATOM    357 HD13 LEU A  23      15.288 -19.960  -1.348  1.00  0.00           H  
ATOM    358 HD21 LEU A  23      17.359 -21.137   1.522  1.00  0.00           H  
ATOM    359 HD22 LEU A  23      16.919 -19.706   0.587  1.00  0.00           H  
ATOM    360 HD23 LEU A  23      17.910 -20.969  -0.145  1.00  0.00           H  
ATOM    361  N   GLY A  24      12.874 -24.267   0.080  1.00  0.00           N  
ATOM    362  CA  GLY A  24      12.910 -25.705   0.229  1.00  0.00           C  
ATOM    363  C   GLY A  24      12.215 -26.138   1.502  1.00  0.00           C  
ATOM    364  O   GLY A  24      10.986 -26.146   1.576  1.00  0.00           O  
ATOM    365  H   GLY A  24      12.275 -23.860  -0.580  1.00  0.00           H  
ATOM    366  HA2 GLY A  24      12.419 -26.162  -0.618  1.00  0.00           H  
ATOM    367  HA3 GLY A  24      13.937 -26.034   0.262  1.00  0.00           H  
ATOM    368  N   ASP A  25      13.000 -26.480   2.510  1.00  0.00           N  
ATOM    369  CA  ASP A  25      12.456 -26.820   3.819  1.00  0.00           C  
ATOM    370  C   ASP A  25      12.891 -25.794   4.851  1.00  0.00           C  
ATOM    371  O   ASP A  25      12.603 -25.926   6.041  1.00  0.00           O  
ATOM    372  CB  ASP A  25      12.906 -28.215   4.254  1.00  0.00           C  
ATOM    373  CG  ASP A  25      12.317 -29.309   3.394  1.00  0.00           C  
ATOM    374  OD1 ASP A  25      11.167 -29.724   3.652  1.00  0.00           O  
ATOM    375  OD2 ASP A  25      13.003 -29.769   2.453  1.00  0.00           O  
ATOM    376  H   ASP A  25      13.975 -26.510   2.370  1.00  0.00           H  
ATOM    377  HA  ASP A  25      11.378 -26.805   3.745  1.00  0.00           H  
ATOM    378  HB2 ASP A  25      13.982 -28.274   4.192  1.00  0.00           H  
ATOM    379  HB3 ASP A  25      12.600 -28.383   5.277  1.00  0.00           H  
ATOM    380  N   GLU A  26      13.582 -24.764   4.385  1.00  0.00           N  
ATOM    381  CA  GLU A  26      14.078 -23.719   5.265  1.00  0.00           C  
ATOM    382  C   GLU A  26      13.057 -22.597   5.396  1.00  0.00           C  
ATOM    383  O   GLU A  26      12.700 -21.950   4.407  1.00  0.00           O  
ATOM    384  CB  GLU A  26      15.398 -23.155   4.735  1.00  0.00           C  
ATOM    385  CG  GLU A  26      16.506 -24.187   4.613  1.00  0.00           C  
ATOM    386  CD  GLU A  26      16.852 -24.832   5.939  1.00  0.00           C  
ATOM    387  OE1 GLU A  26      17.614 -24.226   6.720  1.00  0.00           O  
ATOM    388  OE2 GLU A  26      16.365 -25.954   6.204  1.00  0.00           O  
ATOM    389  H   GLU A  26      13.757 -24.702   3.421  1.00  0.00           H  
ATOM    390  HA  GLU A  26      14.247 -24.156   6.237  1.00  0.00           H  
ATOM    391  HB2 GLU A  26      15.227 -22.728   3.757  1.00  0.00           H  
ATOM    392  HB3 GLU A  26      15.736 -22.376   5.402  1.00  0.00           H  
ATOM    393  HG2 GLU A  26      16.189 -24.958   3.927  1.00  0.00           H  
ATOM    394  HG3 GLU A  26      17.389 -23.703   4.225  1.00  0.00           H  
ATOM    395  N   GLN A  27      12.571 -22.384   6.611  1.00  0.00           N  
ATOM    396  CA  GLN A  27      11.694 -21.259   6.892  1.00  0.00           C  
ATOM    397  C   GLN A  27      12.522 -19.997   7.060  1.00  0.00           C  
ATOM    398  O   GLN A  27      13.180 -19.798   8.082  1.00  0.00           O  
ATOM    399  CB  GLN A  27      10.844 -21.523   8.136  1.00  0.00           C  
ATOM    400  CG  GLN A  27       9.723 -22.519   7.892  1.00  0.00           C  
ATOM    401  CD  GLN A  27       8.898 -22.799   9.129  1.00  0.00           C  
ATOM    402  OE1 GLN A  27       9.182 -23.730   9.879  1.00  0.00           O  
ATOM    403  NE2 GLN A  27       7.871 -21.996   9.354  1.00  0.00           N  
ATOM    404  H   GLN A  27      12.811 -22.998   7.335  1.00  0.00           H  
ATOM    405  HA  GLN A  27      11.040 -21.131   6.042  1.00  0.00           H  
ATOM    406  HB2 GLN A  27      11.480 -21.909   8.919  1.00  0.00           H  
ATOM    407  HB3 GLN A  27      10.405 -20.592   8.465  1.00  0.00           H  
ATOM    408  HG2 GLN A  27       9.071 -22.126   7.126  1.00  0.00           H  
ATOM    409  HG3 GLN A  27      10.157 -23.449   7.550  1.00  0.00           H  
ATOM    410 HE21 GLN A  27       7.700 -21.269   8.717  1.00  0.00           H  
ATOM    411 HE22 GLN A  27       7.323 -22.161  10.149  1.00  0.00           H  
ATOM    412  N   VAL A  28      12.500 -19.163   6.038  1.00  0.00           N  
ATOM    413  CA  VAL A  28      13.312 -17.961   6.013  1.00  0.00           C  
ATOM    414  C   VAL A  28      12.484 -16.750   6.414  1.00  0.00           C  
ATOM    415  O   VAL A  28      11.349 -16.590   5.966  1.00  0.00           O  
ATOM    416  CB  VAL A  28      13.915 -17.726   4.612  1.00  0.00           C  
ATOM    417  CG1 VAL A  28      14.848 -16.526   4.614  1.00  0.00           C  
ATOM    418  CG2 VAL A  28      14.639 -18.969   4.123  1.00  0.00           C  
ATOM    419  H   VAL A  28      11.906 -19.354   5.279  1.00  0.00           H  
ATOM    420  HA  VAL A  28      14.121 -18.087   6.718  1.00  0.00           H  
ATOM    421  HB  VAL A  28      13.105 -17.519   3.927  1.00  0.00           H  
ATOM    422 HG11 VAL A  28      14.300 -15.643   4.907  1.00  0.00           H  
ATOM    423 HG12 VAL A  28      15.255 -16.385   3.623  1.00  0.00           H  
ATOM    424 HG13 VAL A  28      15.655 -16.697   5.312  1.00  0.00           H  
ATOM    425 HG21 VAL A  28      15.028 -18.792   3.130  1.00  0.00           H  
ATOM    426 HG22 VAL A  28      13.951 -19.800   4.096  1.00  0.00           H  
ATOM    427 HG23 VAL A  28      15.455 -19.197   4.793  1.00  0.00           H  
ATOM    428  N   ALA A  29      13.049 -15.914   7.264  1.00  0.00           N  
ATOM    429  CA  ALA A  29      12.394 -14.692   7.683  1.00  0.00           C  
ATOM    430  C   ALA A  29      12.895 -13.522   6.850  1.00  0.00           C  
ATOM    431  O   ALA A  29      14.055 -13.118   6.965  1.00  0.00           O  
ATOM    432  CB  ALA A  29      12.634 -14.441   9.163  1.00  0.00           C  
ATOM    433  H   ALA A  29      13.948 -16.116   7.611  1.00  0.00           H  
ATOM    434  HA  ALA A  29      11.331 -14.808   7.525  1.00  0.00           H  
ATOM    435  HB1 ALA A  29      12.099 -13.553   9.470  1.00  0.00           H  
ATOM    436  HB2 ALA A  29      13.691 -14.303   9.337  1.00  0.00           H  
ATOM    437  HB3 ALA A  29      12.283 -15.287   9.734  1.00  0.00           H  
ATOM    438  N   ILE A  30      12.028 -13.005   5.998  1.00  0.00           N  
ATOM    439  CA  ILE A  30      12.370 -11.884   5.143  1.00  0.00           C  
ATOM    440  C   ILE A  30      11.995 -10.586   5.827  1.00  0.00           C  
ATOM    441  O   ILE A  30      10.813 -10.268   5.975  1.00  0.00           O  
ATOM    442  CB  ILE A  30      11.652 -11.949   3.781  1.00  0.00           C  
ATOM    443  CG1 ILE A  30      11.929 -13.283   3.089  1.00  0.00           C  
ATOM    444  CG2 ILE A  30      12.093 -10.788   2.895  1.00  0.00           C  
ATOM    445  CD1 ILE A  30      11.207 -13.436   1.770  1.00  0.00           C  
ATOM    446  H   ILE A  30      11.119 -13.376   5.957  1.00  0.00           H  
ATOM    447  HA  ILE A  30      13.437 -11.902   4.973  1.00  0.00           H  
ATOM    448  HB  ILE A  30      10.591 -11.854   3.954  1.00  0.00           H  
ATOM    449 HG12 ILE A  30      12.990 -13.372   2.898  1.00  0.00           H  
ATOM    450 HG13 ILE A  30      11.615 -14.090   3.735  1.00  0.00           H  
ATOM    451 HG21 ILE A  30      13.162 -10.830   2.753  1.00  0.00           H  
ATOM    452 HG22 ILE A  30      11.828  -9.853   3.369  1.00  0.00           H  
ATOM    453 HG23 ILE A  30      11.598 -10.859   1.939  1.00  0.00           H  
ATOM    454 HD11 ILE A  30      11.441 -14.398   1.339  1.00  0.00           H  
ATOM    455 HD12 ILE A  30      11.521 -12.653   1.096  1.00  0.00           H  
ATOM    456 HD13 ILE A  30      10.142 -13.364   1.934  1.00  0.00           H  
ATOM    457  N   PHE A  31      12.998  -9.848   6.255  1.00  0.00           N  
ATOM    458  CA  PHE A  31      12.771  -8.591   6.930  1.00  0.00           C  
ATOM    459  C   PHE A  31      13.093  -7.427   6.012  1.00  0.00           C  
ATOM    460  O   PHE A  31      14.226  -7.281   5.549  1.00  0.00           O  
ATOM    461  CB  PHE A  31      13.619  -8.489   8.201  1.00  0.00           C  
ATOM    462  CG  PHE A  31      13.236  -9.469   9.271  1.00  0.00           C  
ATOM    463  CD1 PHE A  31      12.111  -9.255  10.052  1.00  0.00           C  
ATOM    464  CD2 PHE A  31      14.002 -10.599   9.501  1.00  0.00           C  
ATOM    465  CE1 PHE A  31      11.758 -10.152  11.039  1.00  0.00           C  
ATOM    466  CE2 PHE A  31      13.654 -11.497  10.490  1.00  0.00           C  
ATOM    467  CZ  PHE A  31      12.530 -11.274  11.259  1.00  0.00           C  
ATOM    468  H   PHE A  31      13.921 -10.152   6.100  1.00  0.00           H  
ATOM    469  HA  PHE A  31      11.727  -8.543   7.199  1.00  0.00           H  
ATOM    470  HB2 PHE A  31      14.655  -8.664   7.948  1.00  0.00           H  
ATOM    471  HB3 PHE A  31      13.520  -7.493   8.610  1.00  0.00           H  
ATOM    472  HD1 PHE A  31      11.507  -8.376   9.882  1.00  0.00           H  
ATOM    473  HD2 PHE A  31      14.880 -10.775   8.899  1.00  0.00           H  
ATOM    474  HE1 PHE A  31      10.879  -9.976  11.641  1.00  0.00           H  
ATOM    475  HE2 PHE A  31      14.259 -12.375  10.659  1.00  0.00           H  
ATOM    476  HZ  PHE A  31      12.258 -11.977  12.033  1.00  0.00           H  
ATOM    477  N   ARG A  32      12.087  -6.616   5.738  1.00  0.00           N  
ATOM    478  CA  ARG A  32      12.301  -5.345   5.079  1.00  0.00           C  
ATOM    479  C   ARG A  32      12.340  -4.293   6.167  1.00  0.00           C  
ATOM    480  O   ARG A  32      11.304  -3.884   6.661  1.00  0.00           O  
ATOM    481  CB  ARG A  32      11.158  -5.057   4.094  1.00  0.00           C  
ATOM    482  CG  ARG A  32      11.271  -3.721   3.365  1.00  0.00           C  
ATOM    483  CD  ARG A  32      10.026  -3.444   2.530  1.00  0.00           C  
ATOM    484  NE  ARG A  32      10.134  -2.205   1.753  1.00  0.00           N  
ATOM    485  CZ  ARG A  32       9.151  -1.714   0.988  1.00  0.00           C  
ATOM    486  NH1 ARG A  32       7.979  -2.332   0.916  1.00  0.00           N  
ATOM    487  NH2 ARG A  32       9.335  -0.596   0.299  1.00  0.00           N  
ATOM    488  H   ARG A  32      11.178  -6.873   6.003  1.00  0.00           H  
ATOM    489  HA  ARG A  32      13.246  -5.372   4.558  1.00  0.00           H  
ATOM    490  HB2 ARG A  32      11.138  -5.842   3.352  1.00  0.00           H  
ATOM    491  HB3 ARG A  32      10.223  -5.067   4.637  1.00  0.00           H  
ATOM    492  HG2 ARG A  32      11.389  -2.932   4.090  1.00  0.00           H  
ATOM    493  HG3 ARG A  32      12.132  -3.749   2.712  1.00  0.00           H  
ATOM    494  HD2 ARG A  32       9.877  -4.268   1.848  1.00  0.00           H  
ATOM    495  HD3 ARG A  32       9.177  -3.371   3.191  1.00  0.00           H  
ATOM    496  HE  ARG A  32      10.987  -1.719   1.799  1.00  0.00           H  
ATOM    497 HH11 ARG A  32       7.813  -3.178   1.438  1.00  0.00           H  
ATOM    498 HH12 ARG A  32       7.249  -1.965   0.334  1.00  0.00           H  
ATOM    499 HH21 ARG A  32      10.213  -0.107   0.347  1.00  0.00           H  
ATOM    500 HH22 ARG A  32       8.596  -0.229  -0.274  1.00  0.00           H  
ATOM    501  N   PRO A  33      13.538  -3.861   6.567  1.00  0.00           N  
ATOM    502  CA  PRO A  33      13.717  -2.985   7.719  1.00  0.00           C  
ATOM    503  C   PRO A  33      13.677  -1.503   7.365  1.00  0.00           C  
ATOM    504  O   PRO A  33      13.941  -0.647   8.209  1.00  0.00           O  
ATOM    505  CB  PRO A  33      15.106  -3.383   8.202  1.00  0.00           C  
ATOM    506  CG  PRO A  33      15.852  -3.728   6.954  1.00  0.00           C  
ATOM    507  CD  PRO A  33      14.830  -4.233   5.962  1.00  0.00           C  
ATOM    508  HA  PRO A  33      12.993  -3.191   8.492  1.00  0.00           H  
ATOM    509  HB2 PRO A  33      15.559  -2.555   8.719  1.00  0.00           H  
ATOM    510  HB3 PRO A  33      15.032  -4.233   8.863  1.00  0.00           H  
ATOM    511  HG2 PRO A  33      16.341  -2.847   6.568  1.00  0.00           H  
ATOM    512  HG3 PRO A  33      16.580  -4.499   7.163  1.00  0.00           H  
ATOM    513  HD2 PRO A  33      14.958  -3.750   5.008  1.00  0.00           H  
ATOM    514  HD3 PRO A  33      14.909  -5.306   5.857  1.00  0.00           H  
ATOM    515  N   TYR A  34      13.346  -1.210   6.121  1.00  0.00           N  
ATOM    516  CA  TYR A  34      13.296   0.164   5.653  1.00  0.00           C  
ATOM    517  C   TYR A  34      12.111   0.371   4.726  1.00  0.00           C  
ATOM    518  O   TYR A  34      11.235  -0.487   4.606  1.00  0.00           O  
ATOM    519  CB  TYR A  34      14.578   0.531   4.897  1.00  0.00           C  
ATOM    520  CG  TYR A  34      15.812   0.696   5.756  1.00  0.00           C  
ATOM    521  CD1 TYR A  34      15.983   1.826   6.547  1.00  0.00           C  
ATOM    522  CD2 TYR A  34      16.814  -0.264   5.758  1.00  0.00           C  
ATOM    523  CE1 TYR A  34      17.118   1.994   7.314  1.00  0.00           C  
ATOM    524  CE2 TYR A  34      17.952  -0.103   6.526  1.00  0.00           C  
ATOM    525  CZ  TYR A  34      18.098   1.027   7.302  1.00  0.00           C  
ATOM    526  OH  TYR A  34      19.229   1.191   8.067  1.00  0.00           O  
ATOM    527  H   TYR A  34      13.118  -1.933   5.502  1.00  0.00           H  
ATOM    528  HA  TYR A  34      13.187   0.808   6.517  1.00  0.00           H  
ATOM    529  HB2 TYR A  34      14.789  -0.242   4.175  1.00  0.00           H  
ATOM    530  HB3 TYR A  34      14.416   1.462   4.371  1.00  0.00           H  
ATOM    531  HD1 TYR A  34      15.211   2.582   6.557  1.00  0.00           H  
ATOM    532  HD2 TYR A  34      16.698  -1.148   5.148  1.00  0.00           H  
ATOM    533  HE1 TYR A  34      17.233   2.879   7.921  1.00  0.00           H  
ATOM    534  HE2 TYR A  34      18.720  -0.862   6.517  1.00  0.00           H  
ATOM    535  HH  TYR A  34      18.979   1.517   8.935  1.00  0.00           H  
ATOM    536  N   HIS A  35      12.104   1.519   4.064  1.00  0.00           N  
ATOM    537  CA  HIS A  35      11.098   1.837   3.065  1.00  0.00           C  
ATOM    538  C   HIS A  35      11.673   1.619   1.677  1.00  0.00           C  
ATOM    539  O   HIS A  35      10.944   1.526   0.692  1.00  0.00           O  
ATOM    540  CB  HIS A  35      10.629   3.288   3.212  1.00  0.00           C  
ATOM    541  CG  HIS A  35       9.835   3.541   4.454  1.00  0.00           C  
ATOM    542  ND1 HIS A  35       8.608   4.156   4.441  1.00  0.00           N  
ATOM    543  CD2 HIS A  35      10.092   3.249   5.748  1.00  0.00           C  
ATOM    544  CE1 HIS A  35       8.142   4.228   5.671  1.00  0.00           C  
ATOM    545  NE2 HIS A  35       9.023   3.682   6.487  1.00  0.00           N  
ATOM    546  H   HIS A  35      12.813   2.181   4.251  1.00  0.00           H  
ATOM    547  HA  HIS A  35      10.256   1.174   3.209  1.00  0.00           H  
ATOM    548  HB2 HIS A  35      11.491   3.937   3.234  1.00  0.00           H  
ATOM    549  HB3 HIS A  35      10.013   3.547   2.363  1.00  0.00           H  
ATOM    550  HD1 HIS A  35       8.147   4.504   3.637  1.00  0.00           H  
ATOM    551  HD2 HIS A  35      10.981   2.768   6.131  1.00  0.00           H  
ATOM    552  HE1 HIS A  35       7.197   4.662   5.963  1.00  0.00           H  
ATOM    553  HE2 HIS A  35       8.813   3.363   7.398  1.00  0.00           H  
ATOM    554  N   SER A  36      12.989   1.525   1.616  1.00  0.00           N  
ATOM    555  CA  SER A  36      13.689   1.349   0.360  1.00  0.00           C  
ATOM    556  C   SER A  36      13.716  -0.126  -0.053  1.00  0.00           C  
ATOM    557  O   SER A  36      12.975  -0.952   0.489  1.00  0.00           O  
ATOM    558  CB  SER A  36      15.112   1.891   0.504  1.00  0.00           C  
ATOM    559  OG  SER A  36      15.104   3.168   1.126  1.00  0.00           O  
ATOM    560  H   SER A  36      13.509   1.589   2.443  1.00  0.00           H  
ATOM    561  HA  SER A  36      13.170   1.919  -0.396  1.00  0.00           H  
ATOM    562  HB2 SER A  36      15.695   1.212   1.109  1.00  0.00           H  
ATOM    563  HB3 SER A  36      15.562   1.982  -0.473  1.00  0.00           H  
ATOM    564  HG  SER A  36      15.542   3.812   0.549  1.00  0.00           H  
ATOM    565  N   ASP A  37      14.584  -0.444  -1.004  1.00  0.00           N  
ATOM    566  CA  ASP A  37      14.708  -1.794  -1.555  1.00  0.00           C  
ATOM    567  C   ASP A  37      15.623  -2.668  -0.698  1.00  0.00           C  
ATOM    568  O   ASP A  37      15.986  -3.779  -1.089  1.00  0.00           O  
ATOM    569  CB  ASP A  37      15.272  -1.708  -2.973  1.00  0.00           C  
ATOM    570  CG  ASP A  37      16.596  -0.968  -3.013  1.00  0.00           C  
ATOM    571  OD1 ASP A  37      16.592   0.270  -2.824  1.00  0.00           O  
ATOM    572  OD2 ASP A  37      17.648  -1.615  -3.216  1.00  0.00           O  
ATOM    573  H   ASP A  37      15.173   0.259  -1.361  1.00  0.00           H  
ATOM    574  HA  ASP A  37      13.724  -2.236  -1.591  1.00  0.00           H  
ATOM    575  HB2 ASP A  37      15.426  -2.706  -3.355  1.00  0.00           H  
ATOM    576  HB3 ASP A  37      14.568  -1.187  -3.606  1.00  0.00           H  
ATOM    577  N   GLN A  38      15.985  -2.169   0.469  1.00  0.00           N  
ATOM    578  CA  GLN A  38      16.888  -2.884   1.357  1.00  0.00           C  
ATOM    579  C   GLN A  38      16.127  -3.921   2.172  1.00  0.00           C  
ATOM    580  O   GLN A  38      15.297  -3.579   3.014  1.00  0.00           O  
ATOM    581  CB  GLN A  38      17.606  -1.899   2.279  1.00  0.00           C  
ATOM    582  CG  GLN A  38      18.397  -0.848   1.523  1.00  0.00           C  
ATOM    583  CD  GLN A  38      19.020   0.191   2.430  1.00  0.00           C  
ATOM    584  OE1 GLN A  38      19.378  -0.095   3.571  1.00  0.00           O  
ATOM    585  NE2 GLN A  38      19.134   1.412   1.930  1.00  0.00           N  
ATOM    586  H   GLN A  38      15.629  -1.304   0.748  1.00  0.00           H  
ATOM    587  HA  GLN A  38      17.620  -3.390   0.747  1.00  0.00           H  
ATOM    588  HB2 GLN A  38      16.874  -1.396   2.896  1.00  0.00           H  
ATOM    589  HB3 GLN A  38      18.287  -2.446   2.913  1.00  0.00           H  
ATOM    590  HG2 GLN A  38      19.186  -1.339   0.973  1.00  0.00           H  
ATOM    591  HG3 GLN A  38      17.736  -0.349   0.829  1.00  0.00           H  
ATOM    592 HE21 GLN A  38      18.814   1.570   1.013  1.00  0.00           H  
ATOM    593 HE22 GLN A  38      19.527   2.109   2.495  1.00  0.00           H  
ATOM    594  N   VAL A  39      16.399  -5.189   1.894  1.00  0.00           N  
ATOM    595  CA  VAL A  39      15.773  -6.293   2.608  1.00  0.00           C  
ATOM    596  C   VAL A  39      16.826  -7.307   3.036  1.00  0.00           C  
ATOM    597  O   VAL A  39      17.859  -7.452   2.380  1.00  0.00           O  
ATOM    598  CB  VAL A  39      14.701  -7.007   1.748  1.00  0.00           C  
ATOM    599  CG1 VAL A  39      13.517  -6.092   1.483  1.00  0.00           C  
ATOM    600  CG2 VAL A  39      15.293  -7.499   0.433  1.00  0.00           C  
ATOM    601  H   VAL A  39      17.048  -5.393   1.189  1.00  0.00           H  
ATOM    602  HA  VAL A  39      15.292  -5.892   3.489  1.00  0.00           H  
ATOM    603  HB  VAL A  39      14.346  -7.866   2.298  1.00  0.00           H  
ATOM    604 HG11 VAL A  39      12.788  -6.611   0.878  1.00  0.00           H  
ATOM    605 HG12 VAL A  39      13.855  -5.209   0.962  1.00  0.00           H  
ATOM    606 HG13 VAL A  39      13.066  -5.806   2.423  1.00  0.00           H  
ATOM    607 HG21 VAL A  39      14.524  -7.987  -0.147  1.00  0.00           H  
ATOM    608 HG22 VAL A  39      16.090  -8.198   0.636  1.00  0.00           H  
ATOM    609 HG23 VAL A  39      15.683  -6.658  -0.122  1.00  0.00           H  
ATOM    610  N   PHE A  40      16.572  -7.993   4.140  1.00  0.00           N  
ATOM    611  CA  PHE A  40      17.496  -8.999   4.646  1.00  0.00           C  
ATOM    612  C   PHE A  40      16.745 -10.277   4.991  1.00  0.00           C  
ATOM    613  O   PHE A  40      15.554 -10.238   5.299  1.00  0.00           O  
ATOM    614  CB  PHE A  40      18.237  -8.472   5.877  1.00  0.00           C  
ATOM    615  CG  PHE A  40      19.079  -7.256   5.601  1.00  0.00           C  
ATOM    616  CD1 PHE A  40      20.334  -7.380   5.024  1.00  0.00           C  
ATOM    617  CD2 PHE A  40      18.615  -5.989   5.915  1.00  0.00           C  
ATOM    618  CE1 PHE A  40      21.106  -6.264   4.765  1.00  0.00           C  
ATOM    619  CE2 PHE A  40      19.383  -4.869   5.660  1.00  0.00           C  
ATOM    620  CZ  PHE A  40      20.630  -5.008   5.083  1.00  0.00           C  
ATOM    621  H   PHE A  40      15.738  -7.823   4.634  1.00  0.00           H  
ATOM    622  HA  PHE A  40      18.213  -9.215   3.868  1.00  0.00           H  
ATOM    623  HB2 PHE A  40      17.515  -8.208   6.635  1.00  0.00           H  
ATOM    624  HB3 PHE A  40      18.884  -9.247   6.259  1.00  0.00           H  
ATOM    625  HD1 PHE A  40      20.707  -8.363   4.773  1.00  0.00           H  
ATOM    626  HD2 PHE A  40      17.640  -5.879   6.367  1.00  0.00           H  
ATOM    627  HE1 PHE A  40      22.082  -6.375   4.317  1.00  0.00           H  
ATOM    628  HE2 PHE A  40      19.010  -3.887   5.908  1.00  0.00           H  
ATOM    629  HZ  PHE A  40      21.233  -4.135   4.881  1.00  0.00           H  
ATOM    630  N   ALA A  41      17.435 -11.406   4.934  1.00  0.00           N  
ATOM    631  CA  ALA A  41      16.805 -12.691   5.191  1.00  0.00           C  
ATOM    632  C   ALA A  41      17.637 -13.539   6.140  1.00  0.00           C  
ATOM    633  O   ALA A  41      18.824 -13.775   5.906  1.00  0.00           O  
ATOM    634  CB  ALA A  41      16.579 -13.440   3.888  1.00  0.00           C  
ATOM    635  H   ALA A  41      18.392 -11.377   4.724  1.00  0.00           H  
ATOM    636  HA  ALA A  41      15.841 -12.506   5.642  1.00  0.00           H  
ATOM    637  HB1 ALA A  41      17.528 -13.616   3.404  1.00  0.00           H  
ATOM    638  HB2 ALA A  41      15.946 -12.854   3.240  1.00  0.00           H  
ATOM    639  HB3 ALA A  41      16.103 -14.388   4.097  1.00  0.00           H  
ATOM    640  N   ILE A  42      17.010 -13.991   7.211  1.00  0.00           N  
ATOM    641  CA  ILE A  42      17.654 -14.886   8.161  1.00  0.00           C  
ATOM    642  C   ILE A  42      16.740 -16.066   8.456  1.00  0.00           C  
ATOM    643  O   ILE A  42      15.668 -16.184   7.864  1.00  0.00           O  
ATOM    644  CB  ILE A  42      18.011 -14.177   9.489  1.00  0.00           C  
ATOM    645  CG1 ILE A  42      16.768 -13.522  10.103  1.00  0.00           C  
ATOM    646  CG2 ILE A  42      19.111 -13.148   9.266  1.00  0.00           C  
ATOM    647  CD1 ILE A  42      17.020 -12.886  11.454  1.00  0.00           C  
ATOM    648  H   ILE A  42      16.075 -13.725   7.365  1.00  0.00           H  
ATOM    649  HA  ILE A  42      18.566 -15.253   7.711  1.00  0.00           H  
ATOM    650  HB  ILE A  42      18.389 -14.922  10.173  1.00  0.00           H  
ATOM    651 HG12 ILE A  42      16.409 -12.752   9.438  1.00  0.00           H  
ATOM    652 HG13 ILE A  42      16.001 -14.271  10.227  1.00  0.00           H  
ATOM    653 HG21 ILE A  42      19.351 -12.669  10.204  1.00  0.00           H  
ATOM    654 HG22 ILE A  42      18.772 -12.406   8.559  1.00  0.00           H  
ATOM    655 HG23 ILE A  42      19.992 -13.641   8.877  1.00  0.00           H  
ATOM    656 HD11 ILE A  42      17.370 -13.637  12.146  1.00  0.00           H  
ATOM    657 HD12 ILE A  42      16.102 -12.454  11.825  1.00  0.00           H  
ATOM    658 HD13 ILE A  42      17.768 -12.113  11.355  1.00  0.00           H  
ATOM    659  N   SER A  43      17.165 -16.943   9.350  1.00  0.00           N  
ATOM    660  CA  SER A  43      16.327 -18.053   9.776  1.00  0.00           C  
ATOM    661  C   SER A  43      15.113 -17.521  10.528  1.00  0.00           C  
ATOM    662  O   SER A  43      15.247 -16.666  11.401  1.00  0.00           O  
ATOM    663  CB  SER A  43      17.121 -19.014  10.665  1.00  0.00           C  
ATOM    664  OG  SER A  43      16.383 -20.194  10.942  1.00  0.00           O  
ATOM    665  H   SER A  43      18.063 -16.843   9.730  1.00  0.00           H  
ATOM    666  HA  SER A  43      15.991 -18.578   8.893  1.00  0.00           H  
ATOM    667  HB2 SER A  43      18.035 -19.289  10.167  1.00  0.00           H  
ATOM    668  HB3 SER A  43      17.354 -18.524  11.599  1.00  0.00           H  
ATOM    669  HG  SER A  43      16.236 -20.265  11.899  1.00  0.00           H  
ATOM    670  N   ASN A  44      13.931 -18.015  10.179  1.00  0.00           N  
ATOM    671  CA  ASN A  44      12.700 -17.574  10.828  1.00  0.00           C  
ATOM    672  C   ASN A  44      12.496 -18.313  12.149  1.00  0.00           C  
ATOM    673  O   ASN A  44      11.653 -17.938  12.963  1.00  0.00           O  
ATOM    674  CB  ASN A  44      11.504 -17.771   9.881  1.00  0.00           C  
ATOM    675  CG  ASN A  44      10.165 -17.432  10.512  1.00  0.00           C  
ATOM    676  OD1 ASN A  44       9.780 -16.264  10.615  1.00  0.00           O  
ATOM    677  ND2 ASN A  44       9.428 -18.456  10.906  1.00  0.00           N  
ATOM    678  H   ASN A  44      13.884 -18.689   9.465  1.00  0.00           H  
ATOM    679  HA  ASN A  44      12.804 -16.521  11.039  1.00  0.00           H  
ATOM    680  HB2 ASN A  44      11.637 -17.140   9.015  1.00  0.00           H  
ATOM    681  HB3 ASN A  44      11.477 -18.803   9.561  1.00  0.00           H  
ATOM    682 HD21 ASN A  44       9.781 -19.361  10.770  1.00  0.00           H  
ATOM    683 HD22 ASN A  44       8.563 -18.273  11.323  1.00  0.00           H  
ATOM    684  N   ILE A  45      13.290 -19.354  12.360  1.00  0.00           N  
ATOM    685  CA  ILE A  45      13.271 -20.095  13.615  1.00  0.00           C  
ATOM    686  C   ILE A  45      14.671 -20.113  14.220  1.00  0.00           C  
ATOM    687  O   ILE A  45      15.653 -20.350  13.512  1.00  0.00           O  
ATOM    688  CB  ILE A  45      12.793 -21.552  13.417  1.00  0.00           C  
ATOM    689  CG1 ILE A  45      11.434 -21.584  12.714  1.00  0.00           C  
ATOM    690  CG2 ILE A  45      12.711 -22.274  14.757  1.00  0.00           C  
ATOM    691  CD1 ILE A  45      10.900 -22.983  12.486  1.00  0.00           C  
ATOM    692  H   ILE A  45      13.914 -19.627  11.657  1.00  0.00           H  
ATOM    693  HA  ILE A  45      12.594 -19.595  14.296  1.00  0.00           H  
ATOM    694  HB  ILE A  45      13.520 -22.064  12.804  1.00  0.00           H  
ATOM    695 HG12 ILE A  45      10.713 -21.050  13.316  1.00  0.00           H  
ATOM    696 HG13 ILE A  45      11.523 -21.100  11.753  1.00  0.00           H  
ATOM    697 HG21 ILE A  45      12.383 -23.292  14.599  1.00  0.00           H  
ATOM    698 HG22 ILE A  45      12.007 -21.765  15.398  1.00  0.00           H  
ATOM    699 HG23 ILE A  45      13.684 -22.279  15.225  1.00  0.00           H  
ATOM    700 HD11 ILE A  45      10.781 -23.482  13.436  1.00  0.00           H  
ATOM    701 HD12 ILE A  45      11.593 -23.537  11.872  1.00  0.00           H  
ATOM    702 HD13 ILE A  45       9.944 -22.924  11.988  1.00  0.00           H  
ATOM    703  N   ASP A  46      14.771 -19.848  15.513  1.00  0.00           N  
ATOM    704  CA  ASP A  46      16.064 -19.902  16.188  1.00  0.00           C  
ATOM    705  C   ASP A  46      16.260 -21.287  16.801  1.00  0.00           C  
ATOM    706  O   ASP A  46      15.292 -21.941  17.187  1.00  0.00           O  
ATOM    707  CB  ASP A  46      16.189 -18.810  17.260  1.00  0.00           C  
ATOM    708  CG  ASP A  46      15.474 -19.151  18.549  1.00  0.00           C  
ATOM    709  OD1 ASP A  46      16.077 -19.843  19.397  1.00  0.00           O  
ATOM    710  OD2 ASP A  46      14.314 -18.726  18.720  1.00  0.00           O  
ATOM    711  H   ASP A  46      13.961 -19.627  16.025  1.00  0.00           H  
ATOM    712  HA  ASP A  46      16.828 -19.748  15.439  1.00  0.00           H  
ATOM    713  HB2 ASP A  46      17.232 -18.658  17.485  1.00  0.00           H  
ATOM    714  HB3 ASP A  46      15.774 -17.891  16.873  1.00  0.00           H  
ATOM    715  N   PRO A  47      17.511 -21.766  16.880  1.00  0.00           N  
ATOM    716  CA  PRO A  47      17.800 -23.129  17.310  1.00  0.00           C  
ATOM    717  C   PRO A  47      18.020 -23.281  18.816  1.00  0.00           C  
ATOM    718  O   PRO A  47      18.082 -24.401  19.326  1.00  0.00           O  
ATOM    719  CB  PRO A  47      19.085 -23.435  16.548  1.00  0.00           C  
ATOM    720  CG  PRO A  47      19.794 -22.121  16.442  1.00  0.00           C  
ATOM    721  CD  PRO A  47      18.742 -21.038  16.527  1.00  0.00           C  
ATOM    722  HA  PRO A  47      17.026 -23.810  16.997  1.00  0.00           H  
ATOM    723  HB2 PRO A  47      19.670 -24.156  17.101  1.00  0.00           H  
ATOM    724  HB3 PRO A  47      18.843 -23.830  15.573  1.00  0.00           H  
ATOM    725  HG2 PRO A  47      20.497 -22.020  17.257  1.00  0.00           H  
ATOM    726  HG3 PRO A  47      20.311 -22.063  15.496  1.00  0.00           H  
ATOM    727  HD2 PRO A  47      19.000 -20.324  17.298  1.00  0.00           H  
ATOM    728  HD3 PRO A  47      18.637 -20.541  15.574  1.00  0.00           H  
ATOM    729  N   PHE A  48      18.132 -22.171  19.529  1.00  0.00           N  
ATOM    730  CA  PHE A  48      18.433 -22.224  20.951  1.00  0.00           C  
ATOM    731  C   PHE A  48      17.154 -22.257  21.781  1.00  0.00           C  
ATOM    732  O   PHE A  48      16.930 -23.181  22.565  1.00  0.00           O  
ATOM    733  CB  PHE A  48      19.299 -21.029  21.360  1.00  0.00           C  
ATOM    734  CG  PHE A  48      19.815 -21.116  22.771  1.00  0.00           C  
ATOM    735  CD1 PHE A  48      20.950 -21.857  23.058  1.00  0.00           C  
ATOM    736  CD2 PHE A  48      19.166 -20.462  23.807  1.00  0.00           C  
ATOM    737  CE1 PHE A  48      21.428 -21.942  24.353  1.00  0.00           C  
ATOM    738  CE2 PHE A  48      19.639 -20.545  25.103  1.00  0.00           C  
ATOM    739  CZ  PHE A  48      20.772 -21.287  25.375  1.00  0.00           C  
ATOM    740  H   PHE A  48      18.000 -21.302  19.093  1.00  0.00           H  
ATOM    741  HA  PHE A  48      18.985 -23.134  21.136  1.00  0.00           H  
ATOM    742  HB2 PHE A  48      20.150 -20.969  20.699  1.00  0.00           H  
ATOM    743  HB3 PHE A  48      18.716 -20.123  21.274  1.00  0.00           H  
ATOM    744  HD1 PHE A  48      21.464 -22.370  22.260  1.00  0.00           H  
ATOM    745  HD2 PHE A  48      18.279 -19.883  23.595  1.00  0.00           H  
ATOM    746  HE1 PHE A  48      22.314 -22.523  24.564  1.00  0.00           H  
ATOM    747  HE2 PHE A  48      19.124 -20.032  25.901  1.00  0.00           H  
ATOM    748  HZ  PHE A  48      21.144 -21.353  26.387  1.00  0.00           H  
ATOM    749  N   PHE A  49      16.313 -21.262  21.576  1.00  0.00           N  
ATOM    750  CA  PHE A  49      15.113 -21.083  22.380  1.00  0.00           C  
ATOM    751  C   PHE A  49      13.907 -21.594  21.607  1.00  0.00           C  
ATOM    752  O   PHE A  49      12.908 -22.028  22.189  1.00  0.00           O  
ATOM    753  CB  PHE A  49      14.951 -19.597  22.716  1.00  0.00           C  
ATOM    754  CG  PHE A  49      13.935 -19.298  23.782  1.00  0.00           C  
ATOM    755  CD1 PHE A  49      14.301 -19.290  25.117  1.00  0.00           C  
ATOM    756  CD2 PHE A  49      12.624 -18.998  23.448  1.00  0.00           C  
ATOM    757  CE1 PHE A  49      13.381 -18.988  26.100  1.00  0.00           C  
ATOM    758  CE2 PHE A  49      11.699 -18.702  24.428  1.00  0.00           C  
ATOM    759  CZ  PHE A  49      12.078 -18.696  25.755  1.00  0.00           C  
ATOM    760  H   PHE A  49      16.484 -20.634  20.830  1.00  0.00           H  
ATOM    761  HA  PHE A  49      15.225 -21.652  23.292  1.00  0.00           H  
ATOM    762  HB2 PHE A  49      15.900 -19.210  23.053  1.00  0.00           H  
ATOM    763  HB3 PHE A  49      14.657 -19.068  21.820  1.00  0.00           H  
ATOM    764  HD1 PHE A  49      15.321 -19.520  25.388  1.00  0.00           H  
ATOM    765  HD2 PHE A  49      12.325 -19.004  22.410  1.00  0.00           H  
ATOM    766  HE1 PHE A  49      13.678 -18.986  27.138  1.00  0.00           H  
ATOM    767  HE2 PHE A  49      10.678 -18.472  24.156  1.00  0.00           H  
ATOM    768  HZ  PHE A  49      11.358 -18.451  26.521  1.00  0.00           H  
ATOM    769  N   GLU A  50      14.034 -21.536  20.284  1.00  0.00           N  
ATOM    770  CA  GLU A  50      13.015 -22.001  19.356  1.00  0.00           C  
ATOM    771  C   GLU A  50      11.799 -21.091  19.352  1.00  0.00           C  
ATOM    772  O   GLU A  50      10.799 -21.351  20.025  1.00  0.00           O  
ATOM    773  CB  GLU A  50      12.590 -23.443  19.638  1.00  0.00           C  
ATOM    774  CG  GLU A  50      13.660 -24.475  19.340  1.00  0.00           C  
ATOM    775  CD  GLU A  50      13.175 -25.882  19.600  1.00  0.00           C  
ATOM    776  OE1 GLU A  50      12.517 -26.465  18.712  1.00  0.00           O  
ATOM    777  OE2 GLU A  50      13.442 -26.410  20.696  1.00  0.00           O  
ATOM    778  H   GLU A  50      14.853 -21.132  19.913  1.00  0.00           H  
ATOM    779  HA  GLU A  50      13.455 -21.968  18.368  1.00  0.00           H  
ATOM    780  HB2 GLU A  50      12.323 -23.527  20.680  1.00  0.00           H  
ATOM    781  HB3 GLU A  50      11.724 -23.673  19.036  1.00  0.00           H  
ATOM    782  HG2 GLU A  50      13.948 -24.391  18.302  1.00  0.00           H  
ATOM    783  HG3 GLU A  50      14.517 -24.280  19.969  1.00  0.00           H  
ATOM    784  N   SER A  51      11.903 -20.010  18.610  1.00  0.00           N  
ATOM    785  CA  SER A  51      10.755 -19.189  18.302  1.00  0.00           C  
ATOM    786  C   SER A  51      10.316 -19.510  16.885  1.00  0.00           C  
ATOM    787  O   SER A  51      11.056 -19.266  15.932  1.00  0.00           O  
ATOM    788  CB  SER A  51      11.101 -17.706  18.443  1.00  0.00           C  
ATOM    789  OG  SER A  51      11.582 -17.419  19.745  1.00  0.00           O  
ATOM    790  H   SER A  51      12.790 -19.735  18.278  1.00  0.00           H  
ATOM    791  HA  SER A  51       9.959 -19.444  18.990  1.00  0.00           H  
ATOM    792  HB2 SER A  51      11.866 -17.447  17.726  1.00  0.00           H  
ATOM    793  HB3 SER A  51      10.218 -17.110  18.259  1.00  0.00           H  
ATOM    794  HG  SER A  51      12.439 -17.849  19.869  1.00  0.00           H  
ATOM    795  N   SER A  52       9.129 -20.092  16.759  1.00  0.00           N  
ATOM    796  CA  SER A  52       8.661 -20.628  15.489  1.00  0.00           C  
ATOM    797  C   SER A  52       8.633 -19.564  14.398  1.00  0.00           C  
ATOM    798  O   SER A  52       8.894 -19.851  13.235  1.00  0.00           O  
ATOM    799  CB  SER A  52       7.273 -21.240  15.667  1.00  0.00           C  
ATOM    800  OG  SER A  52       7.232 -22.065  16.821  1.00  0.00           O  
ATOM    801  H   SER A  52       8.554 -20.178  17.547  1.00  0.00           H  
ATOM    802  HA  SER A  52       9.352 -21.399  15.193  1.00  0.00           H  
ATOM    803  HB2 SER A  52       6.545 -20.451  15.778  1.00  0.00           H  
ATOM    804  HB3 SER A  52       7.031 -21.837  14.802  1.00  0.00           H  
ATOM    805  HG  SER A  52       7.112 -22.985  16.555  1.00  0.00           H  
ATOM    806  N   VAL A  53       8.283 -18.348  14.775  1.00  0.00           N  
ATOM    807  CA  VAL A  53       8.348 -17.228  13.854  1.00  0.00           C  
ATOM    808  C   VAL A  53       9.110 -16.059  14.473  1.00  0.00           C  
ATOM    809  O   VAL A  53       8.759 -15.575  15.548  1.00  0.00           O  
ATOM    810  CB  VAL A  53       6.942 -16.752  13.414  1.00  0.00           C  
ATOM    811  CG1 VAL A  53       6.325 -17.740  12.435  1.00  0.00           C  
ATOM    812  CG2 VAL A  53       6.028 -16.563  14.616  1.00  0.00           C  
ATOM    813  H   VAL A  53       7.998 -18.200  15.696  1.00  0.00           H  
ATOM    814  HA  VAL A  53       8.881 -17.557  12.975  1.00  0.00           H  
ATOM    815  HB  VAL A  53       7.045 -15.801  12.912  1.00  0.00           H  
ATOM    816 HG11 VAL A  53       6.964 -17.836  11.569  1.00  0.00           H  
ATOM    817 HG12 VAL A  53       5.353 -17.382  12.128  1.00  0.00           H  
ATOM    818 HG13 VAL A  53       6.219 -18.702  12.914  1.00  0.00           H  
ATOM    819 HG21 VAL A  53       5.940 -17.497  15.151  1.00  0.00           H  
ATOM    820 HG22 VAL A  53       5.051 -16.249  14.280  1.00  0.00           H  
ATOM    821 HG23 VAL A  53       6.443 -15.810  15.270  1.00  0.00           H  
ATOM    822  N   LEU A  54      10.148 -15.610  13.784  1.00  0.00           N  
ATOM    823  CA  LEU A  54      10.861 -14.405  14.188  1.00  0.00           C  
ATOM    824  C   LEU A  54      10.261 -13.200  13.484  1.00  0.00           C  
ATOM    825  O   LEU A  54      10.544 -12.053  13.825  1.00  0.00           O  
ATOM    826  CB  LEU A  54      12.354 -14.521  13.876  1.00  0.00           C  
ATOM    827  CG  LEU A  54      13.096 -15.619  14.639  1.00  0.00           C  
ATOM    828  CD1 LEU A  54      14.573 -15.607  14.285  1.00  0.00           C  
ATOM    829  CD2 LEU A  54      12.906 -15.452  16.139  1.00  0.00           C  
ATOM    830  H   LEU A  54      10.461 -16.114  13.001  1.00  0.00           H  
ATOM    831  HA  LEU A  54      10.730 -14.287  15.255  1.00  0.00           H  
ATOM    832  HB2 LEU A  54      12.465 -14.709  12.817  1.00  0.00           H  
ATOM    833  HB3 LEU A  54      12.822 -13.575  14.106  1.00  0.00           H  
ATOM    834  HG  LEU A  54      12.693 -16.580  14.355  1.00  0.00           H  
ATOM    835 HD11 LEU A  54      14.690 -15.778  13.225  1.00  0.00           H  
ATOM    836 HD12 LEU A  54      15.082 -16.386  14.834  1.00  0.00           H  
ATOM    837 HD13 LEU A  54      14.997 -14.649  14.543  1.00  0.00           H  
ATOM    838 HD21 LEU A  54      13.435 -16.237  16.659  1.00  0.00           H  
ATOM    839 HD22 LEU A  54      11.854 -15.508  16.376  1.00  0.00           H  
ATOM    840 HD23 LEU A  54      13.294 -14.492  16.446  1.00  0.00           H  
ATOM    841  N   SER A  55       9.404 -13.484  12.509  1.00  0.00           N  
ATOM    842  CA  SER A  55       8.699 -12.449  11.767  1.00  0.00           C  
ATOM    843  C   SER A  55       7.576 -11.846  12.615  1.00  0.00           C  
ATOM    844  O   SER A  55       6.833 -10.974  12.163  1.00  0.00           O  
ATOM    845  CB  SER A  55       8.136 -13.037  10.470  1.00  0.00           C  
ATOM    846  OG  SER A  55       9.159 -13.661   9.710  1.00  0.00           O  
ATOM    847  H   SER A  55       9.251 -14.419  12.272  1.00  0.00           H  
ATOM    848  HA  SER A  55       9.409 -11.670  11.523  1.00  0.00           H  
ATOM    849  HB2 SER A  55       7.382 -13.772  10.705  1.00  0.00           H  
ATOM    850  HB3 SER A  55       7.696 -12.247   9.878  1.00  0.00           H  
ATOM    851  HG  SER A  55       9.336 -14.543  10.062  1.00  0.00           H  
ATOM    852  N   ARG A  56       7.460 -12.320  13.850  1.00  0.00           N  
ATOM    853  CA  ARG A  56       6.479 -11.794  14.785  1.00  0.00           C  
ATOM    854  C   ARG A  56       7.187 -10.896  15.798  1.00  0.00           C  
ATOM    855  O   ARG A  56       6.879 -10.912  16.988  1.00  0.00           O  
ATOM    856  CB  ARG A  56       5.759 -12.938  15.511  1.00  0.00           C  
ATOM    857  CG  ARG A  56       4.430 -12.522  16.126  1.00  0.00           C  
ATOM    858  CD  ARG A  56       3.914 -13.542  17.132  1.00  0.00           C  
ATOM    859  NE  ARG A  56       3.832 -14.895  16.579  1.00  0.00           N  
ATOM    860  CZ  ARG A  56       2.694 -15.584  16.464  1.00  0.00           C  
ATOM    861  NH1 ARG A  56       1.529 -15.014  16.742  1.00  0.00           N  
ATOM    862  NH2 ARG A  56       2.716 -16.842  16.042  1.00  0.00           N  
ATOM    863  H   ARG A  56       8.063 -13.033  14.143  1.00  0.00           H  
ATOM    864  HA  ARG A  56       5.761 -11.207  14.231  1.00  0.00           H  
ATOM    865  HB2 ARG A  56       5.576 -13.736  14.807  1.00  0.00           H  
ATOM    866  HB3 ARG A  56       6.398 -13.305  16.301  1.00  0.00           H  
ATOM    867  HG2 ARG A  56       4.559 -11.576  16.629  1.00  0.00           H  
ATOM    868  HG3 ARG A  56       3.701 -12.411  15.336  1.00  0.00           H  
ATOM    869  HD2 ARG A  56       4.581 -13.553  17.980  1.00  0.00           H  
ATOM    870  HD3 ARG A  56       2.930 -13.237  17.457  1.00  0.00           H  
ATOM    871  HE  ARG A  56       4.673 -15.323  16.320  1.00  0.00           H  
ATOM    872 HH11 ARG A  56       1.491 -14.052  17.039  1.00  0.00           H  
ATOM    873 HH12 ARG A  56       0.680 -15.544  16.663  1.00  0.00           H  
ATOM    874 HH21 ARG A  56       3.579 -17.283  15.807  1.00  0.00           H  
ATOM    875 HH22 ARG A  56       1.852 -17.361  15.963  1.00  0.00           H  
ATOM    876  N   GLY A  57       8.133 -10.108  15.310  1.00  0.00           N  
ATOM    877  CA  GLY A  57       8.921  -9.266  16.185  1.00  0.00           C  
ATOM    878  C   GLY A  57       9.067  -7.864  15.640  1.00  0.00           C  
ATOM    879  O   GLY A  57       8.799  -7.618  14.463  1.00  0.00           O  
ATOM    880  H   GLY A  57       8.296 -10.093  14.344  1.00  0.00           H  
ATOM    881  HA2 GLY A  57       8.442  -9.220  17.151  1.00  0.00           H  
ATOM    882  HA3 GLY A  57       9.903  -9.701  16.298  1.00  0.00           H  
ATOM    883  N   LEU A  58       9.491  -6.945  16.494  1.00  0.00           N  
ATOM    884  CA  LEU A  58       9.590  -5.543  16.116  1.00  0.00           C  
ATOM    885  C   LEU A  58      11.038  -5.163  15.844  1.00  0.00           C  
ATOM    886  O   LEU A  58      11.950  -5.600  16.546  1.00  0.00           O  
ATOM    887  CB  LEU A  58       9.011  -4.630  17.209  1.00  0.00           C  
ATOM    888  CG  LEU A  58       7.490  -4.707  17.426  1.00  0.00           C  
ATOM    889  CD1 LEU A  58       6.746  -4.613  16.102  1.00  0.00           C  
ATOM    890  CD2 LEU A  58       7.099  -5.973  18.176  1.00  0.00           C  
ATOM    891  H   LEU A  58       9.760  -7.220  17.397  1.00  0.00           H  
ATOM    892  HA  LEU A  58       9.020  -5.407  15.210  1.00  0.00           H  
ATOM    893  HB2 LEU A  58       9.494  -4.877  18.143  1.00  0.00           H  
ATOM    894  HB3 LEU A  58       9.260  -3.610  16.959  1.00  0.00           H  
ATOM    895  HG  LEU A  58       7.187  -3.861  18.028  1.00  0.00           H  
ATOM    896 HD11 LEU A  58       5.683  -4.661  16.284  1.00  0.00           H  
ATOM    897 HD12 LEU A  58       7.040  -5.433  15.465  1.00  0.00           H  
ATOM    898 HD13 LEU A  58       6.987  -3.677  15.619  1.00  0.00           H  
ATOM    899 HD21 LEU A  58       7.581  -5.983  19.141  1.00  0.00           H  
ATOM    900 HD22 LEU A  58       7.409  -6.838  17.608  1.00  0.00           H  
ATOM    901 HD23 LEU A  58       6.026  -5.994  18.308  1.00  0.00           H  
ATOM    902  N   ILE A  59      11.244  -4.351  14.819  1.00  0.00           N  
ATOM    903  CA  ILE A  59      12.578  -3.895  14.461  1.00  0.00           C  
ATOM    904  C   ILE A  59      12.939  -2.645  15.260  1.00  0.00           C  
ATOM    905  O   ILE A  59      12.189  -1.668  15.270  1.00  0.00           O  
ATOM    906  CB  ILE A  59      12.678  -3.592  12.949  1.00  0.00           C  
ATOM    907  CG1 ILE A  59      12.252  -4.820  12.137  1.00  0.00           C  
ATOM    908  CG2 ILE A  59      14.097  -3.169  12.578  1.00  0.00           C  
ATOM    909  CD1 ILE A  59      12.223  -4.586  10.642  1.00  0.00           C  
ATOM    910  H   ILE A  59      10.477  -4.046  14.291  1.00  0.00           H  
ATOM    911  HA  ILE A  59      13.278  -4.682  14.702  1.00  0.00           H  
ATOM    912  HB  ILE A  59      12.015  -2.773  12.723  1.00  0.00           H  
ATOM    913 HG12 ILE A  59      12.941  -5.629  12.330  1.00  0.00           H  
ATOM    914 HG13 ILE A  59      11.259  -5.119  12.445  1.00  0.00           H  
ATOM    915 HG21 ILE A  59      14.145  -2.960  11.519  1.00  0.00           H  
ATOM    916 HG22 ILE A  59      14.785  -3.967  12.820  1.00  0.00           H  
ATOM    917 HG23 ILE A  59      14.364  -2.282  13.132  1.00  0.00           H  
ATOM    918 HD11 ILE A  59      13.205  -4.288  10.304  1.00  0.00           H  
ATOM    919 HD12 ILE A  59      11.512  -3.805  10.414  1.00  0.00           H  
ATOM    920 HD13 ILE A  59      11.931  -5.496  10.139  1.00  0.00           H  
ATOM    921  N   ALA A  60      14.076  -2.692  15.939  1.00  0.00           N  
ATOM    922  CA  ALA A  60      14.528  -1.583  16.766  1.00  0.00           C  
ATOM    923  C   ALA A  60      16.033  -1.396  16.631  1.00  0.00           C  
ATOM    924  O   ALA A  60      16.772  -2.369  16.459  1.00  0.00           O  
ATOM    925  CB  ALA A  60      14.152  -1.832  18.218  1.00  0.00           C  
ATOM    926  H   ALA A  60      14.637  -3.500  15.879  1.00  0.00           H  
ATOM    927  HA  ALA A  60      14.028  -0.685  16.433  1.00  0.00           H  
ATOM    928  HB1 ALA A  60      14.440  -0.979  18.816  1.00  0.00           H  
ATOM    929  HB2 ALA A  60      14.665  -2.712  18.577  1.00  0.00           H  
ATOM    930  HB3 ALA A  60      13.085  -1.981  18.294  1.00  0.00           H  
ATOM    931  N   GLU A  61      16.488  -0.153  16.712  1.00  0.00           N  
ATOM    932  CA  GLU A  61      17.906   0.139  16.557  1.00  0.00           C  
ATOM    933  C   GLU A  61      18.663  -0.016  17.857  1.00  0.00           C  
ATOM    934  O   GLU A  61      18.108   0.135  18.947  1.00  0.00           O  
ATOM    935  CB  GLU A  61      18.150   1.560  16.055  1.00  0.00           C  
ATOM    936  CG  GLU A  61      17.935   1.747  14.572  1.00  0.00           C  
ATOM    937  CD  GLU A  61      16.473   1.935  14.214  1.00  0.00           C  
ATOM    938  OE1 GLU A  61      15.792   2.739  14.892  1.00  0.00           O  
ATOM    939  OE2 GLU A  61      15.993   1.289  13.263  1.00  0.00           O  
ATOM    940  H   GLU A  61      15.861   0.582  16.888  1.00  0.00           H  
ATOM    941  HA  GLU A  61      18.308  -0.555  15.837  1.00  0.00           H  
ATOM    942  HB2 GLU A  61      17.482   2.229  16.575  1.00  0.00           H  
ATOM    943  HB3 GLU A  61      19.169   1.836  16.285  1.00  0.00           H  
ATOM    944  HG2 GLU A  61      18.494   2.613  14.252  1.00  0.00           H  
ATOM    945  HG3 GLU A  61      18.314   0.874  14.064  1.00  0.00           H  
ATOM    946  N   HIS A  62      19.936  -0.322  17.717  1.00  0.00           N  
ATOM    947  CA  HIS A  62      20.883  -0.217  18.804  1.00  0.00           C  
ATOM    948  C   HIS A  62      22.281  -0.253  18.219  1.00  0.00           C  
ATOM    949  O   HIS A  62      22.582  -1.112  17.390  1.00  0.00           O  
ATOM    950  CB  HIS A  62      20.703  -1.328  19.840  1.00  0.00           C  
ATOM    951  CG  HIS A  62      21.181  -0.920  21.200  1.00  0.00           C  
ATOM    952  ND1 HIS A  62      22.331  -1.408  21.783  1.00  0.00           N  
ATOM    953  CD2 HIS A  62      20.658  -0.039  22.085  1.00  0.00           C  
ATOM    954  CE1 HIS A  62      22.493  -0.843  22.967  1.00  0.00           C  
ATOM    955  NE2 HIS A  62      21.492  -0.009  23.171  1.00  0.00           N  
ATOM    956  H   HIS A  62      20.254  -0.633  16.837  1.00  0.00           H  
ATOM    957  HA  HIS A  62      20.733   0.741  19.280  1.00  0.00           H  
ATOM    958  HB2 HIS A  62      19.655  -1.582  19.913  1.00  0.00           H  
ATOM    959  HB3 HIS A  62      21.265  -2.199  19.535  1.00  0.00           H  
ATOM    960  HD1 HIS A  62      22.933  -2.077  21.396  1.00  0.00           H  
ATOM    961  HD2 HIS A  62      19.750   0.535  21.956  1.00  0.00           H  
ATOM    962  HE1 HIS A  62      23.311  -1.029  23.648  1.00  0.00           H  
ATOM    963  HE2 HIS A  62      21.311   0.469  24.018  1.00  0.00           H  
ATOM    964  N   GLN A  63      23.104   0.714  18.617  1.00  0.00           N  
ATOM    965  CA  GLN A  63      24.473   0.856  18.115  1.00  0.00           C  
ATOM    966  C   GLN A  63      24.483   1.373  16.673  1.00  0.00           C  
ATOM    967  O   GLN A  63      25.538   1.446  16.045  1.00  0.00           O  
ATOM    968  CB  GLN A  63      25.245  -0.472  18.198  1.00  0.00           C  
ATOM    969  CG  GLN A  63      25.304  -1.075  19.596  1.00  0.00           C  
ATOM    970  CD  GLN A  63      26.032  -0.197  20.594  1.00  0.00           C  
ATOM    971  OE1 GLN A  63      25.710  -0.199  21.783  1.00  0.00           O  
ATOM    972  NE2 GLN A  63      27.034   0.536  20.132  1.00  0.00           N  
ATOM    973  H   GLN A  63      22.773   1.373  19.275  1.00  0.00           H  
ATOM    974  HA  GLN A  63      24.970   1.585  18.739  1.00  0.00           H  
ATOM    975  HB2 GLN A  63      24.773  -1.189  17.544  1.00  0.00           H  
ATOM    976  HB3 GLN A  63      26.257  -0.305  17.860  1.00  0.00           H  
ATOM    977  HG2 GLN A  63      24.296  -1.229  19.948  1.00  0.00           H  
ATOM    978  HG3 GLN A  63      25.812  -2.027  19.540  1.00  0.00           H  
ATOM    979 HE21 GLN A  63      27.258   0.471  19.175  1.00  0.00           H  
ATOM    980 HE22 GLN A  63      27.509   1.121  20.763  1.00  0.00           H  
ATOM    981  N   GLY A  64      23.314   1.748  16.150  1.00  0.00           N  
ATOM    982  CA  GLY A  64      23.235   2.184  14.770  1.00  0.00           C  
ATOM    983  C   GLY A  64      22.950   1.025  13.844  1.00  0.00           C  
ATOM    984  O   GLY A  64      23.014   1.153  12.624  1.00  0.00           O  
ATOM    985  H   GLY A  64      22.495   1.728  16.703  1.00  0.00           H  
ATOM    986  HA2 GLY A  64      22.447   2.917  14.674  1.00  0.00           H  
ATOM    987  HA3 GLY A  64      24.176   2.636  14.489  1.00  0.00           H  
ATOM    988  N   GLU A  65      22.624  -0.107  14.445  1.00  0.00           N  
ATOM    989  CA  GLU A  65      22.345  -1.329  13.711  1.00  0.00           C  
ATOM    990  C   GLU A  65      20.887  -1.706  13.901  1.00  0.00           C  
ATOM    991  O   GLU A  65      20.248  -1.266  14.864  1.00  0.00           O  
ATOM    992  CB  GLU A  65      23.246  -2.469  14.198  1.00  0.00           C  
ATOM    993  CG  GLU A  65      24.721  -2.283  13.872  1.00  0.00           C  
ATOM    994  CD  GLU A  65      25.014  -2.378  12.386  1.00  0.00           C  
ATOM    995  OE1 GLU A  65      24.709  -3.426  11.781  1.00  0.00           O  
ATOM    996  OE2 GLU A  65      25.574  -1.415  11.823  1.00  0.00           O  
ATOM    997  H   GLU A  65      22.537  -0.113  15.419  1.00  0.00           H  
ATOM    998  HA  GLU A  65      22.533  -1.145  12.664  1.00  0.00           H  
ATOM    999  HB2 GLU A  65      23.148  -2.552  15.272  1.00  0.00           H  
ATOM   1000  HB3 GLU A  65      22.913  -3.392  13.746  1.00  0.00           H  
ATOM   1001  HG2 GLU A  65      25.031  -1.309  14.222  1.00  0.00           H  
ATOM   1002  HG3 GLU A  65      25.288  -3.045  14.387  1.00  0.00           H  
ATOM   1003  N   LEU A  66      20.363  -2.516  13.000  1.00  0.00           N  
ATOM   1004  CA  LEU A  66      18.962  -2.890  13.047  1.00  0.00           C  
ATOM   1005  C   LEU A  66      18.797  -4.260  13.679  1.00  0.00           C  
ATOM   1006  O   LEU A  66      19.323  -5.256  13.176  1.00  0.00           O  
ATOM   1007  CB  LEU A  66      18.369  -2.883  11.641  1.00  0.00           C  
ATOM   1008  CG  LEU A  66      18.614  -1.599  10.851  1.00  0.00           C  
ATOM   1009  CD1 LEU A  66      17.901  -1.662   9.519  1.00  0.00           C  
ATOM   1010  CD2 LEU A  66      18.155  -0.384  11.640  1.00  0.00           C  
ATOM   1011  H   LEU A  66      20.931  -2.877  12.288  1.00  0.00           H  
ATOM   1012  HA  LEU A  66      18.444  -2.161  13.652  1.00  0.00           H  
ATOM   1013  HB2 LEU A  66      18.793  -3.709  11.088  1.00  0.00           H  
ATOM   1014  HB3 LEU A  66      17.303  -3.032  11.719  1.00  0.00           H  
ATOM   1015  HG  LEU A  66      19.673  -1.496  10.660  1.00  0.00           H  
ATOM   1016 HD11 LEU A  66      16.837  -1.668   9.688  1.00  0.00           H  
ATOM   1017 HD12 LEU A  66      18.190  -2.561   8.996  1.00  0.00           H  
ATOM   1018 HD13 LEU A  66      18.167  -0.798   8.928  1.00  0.00           H  
ATOM   1019 HD21 LEU A  66      17.099  -0.471  11.855  1.00  0.00           H  
ATOM   1020 HD22 LEU A  66      18.333   0.510  11.061  1.00  0.00           H  
ATOM   1021 HD23 LEU A  66      18.707  -0.327  12.568  1.00  0.00           H  
ATOM   1022  N   TRP A  67      18.075  -4.300  14.784  1.00  0.00           N  
ATOM   1023  CA  TRP A  67      17.840  -5.538  15.503  1.00  0.00           C  
ATOM   1024  C   TRP A  67      16.353  -5.852  15.517  1.00  0.00           C  
ATOM   1025  O   TRP A  67      15.535  -4.974  15.782  1.00  0.00           O  
ATOM   1026  CB  TRP A  67      18.338  -5.421  16.949  1.00  0.00           C  
ATOM   1027  CG  TRP A  67      19.780  -5.031  17.073  1.00  0.00           C  
ATOM   1028  CD1 TRP A  67      20.305  -3.778  16.937  1.00  0.00           C  
ATOM   1029  CD2 TRP A  67      20.880  -5.896  17.375  1.00  0.00           C  
ATOM   1030  NE1 TRP A  67      21.663  -3.812  17.127  1.00  0.00           N  
ATOM   1031  CE2 TRP A  67      22.042  -5.100  17.398  1.00  0.00           C  
ATOM   1032  CE3 TRP A  67      20.998  -7.265  17.628  1.00  0.00           C  
ATOM   1033  CZ2 TRP A  67      23.304  -5.629  17.661  1.00  0.00           C  
ATOM   1034  CZ3 TRP A  67      22.251  -7.789  17.890  1.00  0.00           C  
ATOM   1035  CH2 TRP A  67      23.389  -6.973  17.905  1.00  0.00           C  
ATOM   1036  H   TRP A  67      17.679  -3.467  15.129  1.00  0.00           H  
ATOM   1037  HA  TRP A  67      18.372  -6.331  15.002  1.00  0.00           H  
ATOM   1038  HB2 TRP A  67      17.750  -4.675  17.463  1.00  0.00           H  
ATOM   1039  HB3 TRP A  67      18.207  -6.374  17.443  1.00  0.00           H  
ATOM   1040  HD1 TRP A  67      19.723  -2.898  16.707  1.00  0.00           H  
ATOM   1041  HE1 TRP A  67      22.267  -3.034  17.077  1.00  0.00           H  
ATOM   1042  HE3 TRP A  67      20.131  -7.910  17.621  1.00  0.00           H  
ATOM   1043  HZ2 TRP A  67      24.190  -5.013  17.676  1.00  0.00           H  
ATOM   1044  HZ3 TRP A  67      22.359  -8.845  18.088  1.00  0.00           H  
ATOM   1045  HH2 TRP A  67      24.347  -7.425  18.113  1.00  0.00           H  
ATOM   1046  N   VAL A  68      15.996  -7.090  15.234  1.00  0.00           N  
ATOM   1047  CA  VAL A  68      14.612  -7.504  15.362  1.00  0.00           C  
ATOM   1048  C   VAL A  68      14.412  -8.176  16.715  1.00  0.00           C  
ATOM   1049  O   VAL A  68      15.081  -9.158  17.044  1.00  0.00           O  
ATOM   1050  CB  VAL A  68      14.160  -8.437  14.207  1.00  0.00           C  
ATOM   1051  CG1 VAL A  68      15.047  -9.668  14.099  1.00  0.00           C  
ATOM   1052  CG2 VAL A  68      12.701  -8.837  14.381  1.00  0.00           C  
ATOM   1053  H   VAL A  68      16.675  -7.737  14.932  1.00  0.00           H  
ATOM   1054  HA  VAL A  68      14.004  -6.610  15.331  1.00  0.00           H  
ATOM   1055  HB  VAL A  68      14.245  -7.886  13.281  1.00  0.00           H  
ATOM   1056 HG11 VAL A  68      14.698 -10.294  13.292  1.00  0.00           H  
ATOM   1057 HG12 VAL A  68      15.009 -10.221  15.026  1.00  0.00           H  
ATOM   1058 HG13 VAL A  68      16.063  -9.362  13.903  1.00  0.00           H  
ATOM   1059 HG21 VAL A  68      12.082  -7.951  14.379  1.00  0.00           H  
ATOM   1060 HG22 VAL A  68      12.580  -9.357  15.320  1.00  0.00           H  
ATOM   1061 HG23 VAL A  68      12.404  -9.485  13.569  1.00  0.00           H  
ATOM   1062  N   ALA A  69      13.528  -7.605  17.516  1.00  0.00           N  
ATOM   1063  CA  ALA A  69      13.299  -8.085  18.866  1.00  0.00           C  
ATOM   1064  C   ALA A  69      12.047  -8.941  18.927  1.00  0.00           C  
ATOM   1065  O   ALA A  69      10.957  -8.497  18.560  1.00  0.00           O  
ATOM   1066  CB  ALA A  69      13.191  -6.914  19.833  1.00  0.00           C  
ATOM   1067  H   ALA A  69      13.003  -6.840  17.183  1.00  0.00           H  
ATOM   1068  HA  ALA A  69      14.150  -8.684  19.155  1.00  0.00           H  
ATOM   1069  HB1 ALA A  69      12.334  -6.308  19.573  1.00  0.00           H  
ATOM   1070  HB2 ALA A  69      14.087  -6.314  19.774  1.00  0.00           H  
ATOM   1071  HB3 ALA A  69      13.076  -7.288  20.838  1.00  0.00           H  
ATOM   1072  N   SER A  70      12.211 -10.172  19.379  1.00  0.00           N  
ATOM   1073  CA  SER A  70      11.094 -11.088  19.525  1.00  0.00           C  
ATOM   1074  C   SER A  70      10.425 -10.887  20.884  1.00  0.00           C  
ATOM   1075  O   SER A  70      11.035 -11.133  21.926  1.00  0.00           O  
ATOM   1076  CB  SER A  70      11.585 -12.526  19.373  1.00  0.00           C  
ATOM   1077  OG  SER A  70      12.331 -12.674  18.178  1.00  0.00           O  
ATOM   1078  H   SER A  70      13.116 -10.475  19.625  1.00  0.00           H  
ATOM   1079  HA  SER A  70      10.379 -10.871  18.745  1.00  0.00           H  
ATOM   1080  HB2 SER A  70      12.214 -12.783  20.214  1.00  0.00           H  
ATOM   1081  HB3 SER A  70      10.736 -13.193  19.340  1.00  0.00           H  
ATOM   1082  HG  SER A  70      12.467 -11.811  17.776  1.00  0.00           H  
ATOM   1083  N   PRO A  71       9.154 -10.438  20.884  1.00  0.00           N  
ATOM   1084  CA  PRO A  71       8.408 -10.114  22.110  1.00  0.00           C  
ATOM   1085  C   PRO A  71       8.136 -11.337  22.980  1.00  0.00           C  
ATOM   1086  O   PRO A  71       7.624 -11.219  24.095  1.00  0.00           O  
ATOM   1087  CB  PRO A  71       7.086  -9.526  21.595  1.00  0.00           C  
ATOM   1088  CG  PRO A  71       7.327  -9.205  20.161  1.00  0.00           C  
ATOM   1089  CD  PRO A  71       8.340 -10.201  19.684  1.00  0.00           C  
ATOM   1090  HA  PRO A  71       8.927  -9.371  22.697  1.00  0.00           H  
ATOM   1091  HB2 PRO A  71       6.297 -10.254  21.709  1.00  0.00           H  
ATOM   1092  HB3 PRO A  71       6.844  -8.637  22.160  1.00  0.00           H  
ATOM   1093  HG2 PRO A  71       6.409  -9.307  19.601  1.00  0.00           H  
ATOM   1094  HG3 PRO A  71       7.716  -8.202  20.067  1.00  0.00           H  
ATOM   1095  HD2 PRO A  71       7.853 -11.110  19.361  1.00  0.00           H  
ATOM   1096  HD3 PRO A  71       8.937  -9.785  18.888  1.00  0.00           H  
ATOM   1097  N   LEU A  72       8.470 -12.512  22.459  1.00  0.00           N  
ATOM   1098  CA  LEU A  72       8.355 -13.749  23.215  1.00  0.00           C  
ATOM   1099  C   LEU A  72       9.263 -13.696  24.436  1.00  0.00           C  
ATOM   1100  O   LEU A  72       8.895 -14.155  25.514  1.00  0.00           O  
ATOM   1101  CB  LEU A  72       8.710 -14.968  22.350  1.00  0.00           C  
ATOM   1102  CG  LEU A  72       7.717 -15.305  21.228  1.00  0.00           C  
ATOM   1103  CD1 LEU A  72       7.822 -14.314  20.077  1.00  0.00           C  
ATOM   1104  CD2 LEU A  72       7.946 -16.721  20.728  1.00  0.00           C  
ATOM   1105  H   LEU A  72       8.800 -12.545  21.538  1.00  0.00           H  
ATOM   1106  HA  LEU A  72       7.331 -13.839  23.548  1.00  0.00           H  
ATOM   1107  HB2 LEU A  72       9.676 -14.792  21.902  1.00  0.00           H  
ATOM   1108  HB3 LEU A  72       8.787 -15.828  22.997  1.00  0.00           H  
ATOM   1109  HG  LEU A  72       6.713 -15.251  21.622  1.00  0.00           H  
ATOM   1110 HD11 LEU A  72       7.103 -14.574  19.314  1.00  0.00           H  
ATOM   1111 HD12 LEU A  72       8.817 -14.350  19.661  1.00  0.00           H  
ATOM   1112 HD13 LEU A  72       7.618 -13.319  20.439  1.00  0.00           H  
ATOM   1113 HD21 LEU A  72       7.796 -17.418  21.539  1.00  0.00           H  
ATOM   1114 HD22 LEU A  72       8.956 -16.813  20.355  1.00  0.00           H  
ATOM   1115 HD23 LEU A  72       7.248 -16.937  19.932  1.00  0.00           H  
ATOM   1116  N   LYS A  73      10.445 -13.117  24.255  1.00  0.00           N  
ATOM   1117  CA  LYS A  73      11.397 -12.930  25.345  1.00  0.00           C  
ATOM   1118  C   LYS A  73      12.156 -11.614  25.154  1.00  0.00           C  
ATOM   1119  O   LYS A  73      11.560 -10.538  25.233  1.00  0.00           O  
ATOM   1120  CB  LYS A  73      12.369 -14.118  25.434  1.00  0.00           C  
ATOM   1121  CG  LYS A  73      11.774 -15.377  26.058  1.00  0.00           C  
ATOM   1122  CD  LYS A  73      11.909 -15.389  27.581  1.00  0.00           C  
ATOM   1123  CE  LYS A  73      11.019 -14.358  28.259  1.00  0.00           C  
ATOM   1124  NZ  LYS A  73       9.573 -14.627  28.027  1.00  0.00           N  
ATOM   1125  H   LYS A  73      10.680 -12.786  23.362  1.00  0.00           H  
ATOM   1126  HA  LYS A  73      10.831 -12.870  26.263  1.00  0.00           H  
ATOM   1127  HB2 LYS A  73      12.707 -14.365  24.441  1.00  0.00           H  
ATOM   1128  HB3 LYS A  73      13.219 -13.826  26.029  1.00  0.00           H  
ATOM   1129  HG2 LYS A  73      10.725 -15.431  25.803  1.00  0.00           H  
ATOM   1130  HG3 LYS A  73      12.286 -16.238  25.656  1.00  0.00           H  
ATOM   1131  HD2 LYS A  73      11.641 -16.369  27.945  1.00  0.00           H  
ATOM   1132  HD3 LYS A  73      12.939 -15.182  27.836  1.00  0.00           H  
ATOM   1133  HE2 LYS A  73      11.212 -14.379  29.321  1.00  0.00           H  
ATOM   1134  HE3 LYS A  73      11.261 -13.379  27.870  1.00  0.00           H  
ATOM   1135  HZ1 LYS A  73       9.325 -15.589  28.348  1.00  0.00           H  
ATOM   1136  HZ2 LYS A  73       9.353 -14.550  27.011  1.00  0.00           H  
ATOM   1137  HZ3 LYS A  73       8.989 -13.936  28.546  1.00  0.00           H  
ATOM   1138  N   LYS A  74      13.459 -11.699  24.896  1.00  0.00           N  
ATOM   1139  CA  LYS A  74      14.275 -10.512  24.643  1.00  0.00           C  
ATOM   1140  C   LYS A  74      15.286 -10.777  23.535  1.00  0.00           C  
ATOM   1141  O   LYS A  74      16.322 -10.116  23.458  1.00  0.00           O  
ATOM   1142  CB  LYS A  74      15.008 -10.075  25.915  1.00  0.00           C  
ATOM   1143  CG  LYS A  74      14.107  -9.414  26.942  1.00  0.00           C  
ATOM   1144  CD  LYS A  74      14.878  -9.017  28.189  1.00  0.00           C  
ATOM   1145  CE  LYS A  74      13.995  -8.270  29.173  1.00  0.00           C  
ATOM   1146  NZ  LYS A  74      12.790  -9.055  29.554  1.00  0.00           N  
ATOM   1147  H   LYS A  74      13.889 -12.581  24.894  1.00  0.00           H  
ATOM   1148  HA  LYS A  74      13.613  -9.717  24.328  1.00  0.00           H  
ATOM   1149  HB2 LYS A  74      15.461 -10.943  26.371  1.00  0.00           H  
ATOM   1150  HB3 LYS A  74      15.786  -9.375  25.645  1.00  0.00           H  
ATOM   1151  HG2 LYS A  74      13.669  -8.528  26.507  1.00  0.00           H  
ATOM   1152  HG3 LYS A  74      13.324 -10.105  27.220  1.00  0.00           H  
ATOM   1153  HD2 LYS A  74      15.259  -9.910  28.667  1.00  0.00           H  
ATOM   1154  HD3 LYS A  74      15.702  -8.381  27.904  1.00  0.00           H  
ATOM   1155  HE2 LYS A  74      14.569  -8.057  30.063  1.00  0.00           H  
ATOM   1156  HE3 LYS A  74      13.680  -7.342  28.720  1.00  0.00           H  
ATOM   1157  HZ1 LYS A  74      13.071  -9.987  29.935  1.00  0.00           H  
ATOM   1158  HZ2 LYS A  74      12.177  -9.201  28.724  1.00  0.00           H  
ATOM   1159  HZ3 LYS A  74      12.248  -8.544  30.286  1.00  0.00           H  
ATOM   1160  N   GLN A  75      14.965 -11.729  22.669  1.00  0.00           N  
ATOM   1161  CA  GLN A  75      15.860 -12.119  21.584  1.00  0.00           C  
ATOM   1162  C   GLN A  75      15.968 -11.004  20.550  1.00  0.00           C  
ATOM   1163  O   GLN A  75      14.954 -10.512  20.048  1.00  0.00           O  
ATOM   1164  CB  GLN A  75      15.353 -13.404  20.924  1.00  0.00           C  
ATOM   1165  CG  GLN A  75      15.195 -14.560  21.900  1.00  0.00           C  
ATOM   1166  CD  GLN A  75      14.597 -15.805  21.268  1.00  0.00           C  
ATOM   1167  OE1 GLN A  75      13.895 -16.560  21.933  1.00  0.00           O  
ATOM   1168  NE2 GLN A  75      14.876 -16.035  19.992  1.00  0.00           N  
ATOM   1169  H   GLN A  75      14.099 -12.175  22.753  1.00  0.00           H  
ATOM   1170  HA  GLN A  75      16.837 -12.300  22.006  1.00  0.00           H  
ATOM   1171  HB2 GLN A  75      14.391 -13.208  20.473  1.00  0.00           H  
ATOM   1172  HB3 GLN A  75      16.049 -13.702  20.153  1.00  0.00           H  
ATOM   1173  HG2 GLN A  75      16.165 -14.812  22.298  1.00  0.00           H  
ATOM   1174  HG3 GLN A  75      14.550 -14.241  22.706  1.00  0.00           H  
ATOM   1175 HE21 GLN A  75      15.445 -15.397  19.518  1.00  0.00           H  
ATOM   1176 HE22 GLN A  75      14.502 -16.848  19.574  1.00  0.00           H  
ATOM   1177  N   ARG A  76      17.195 -10.598  20.250  1.00  0.00           N  
ATOM   1178  CA  ARG A  76      17.440  -9.546  19.272  1.00  0.00           C  
ATOM   1179  C   ARG A  76      18.383 -10.037  18.184  1.00  0.00           C  
ATOM   1180  O   ARG A  76      19.532 -10.400  18.452  1.00  0.00           O  
ATOM   1181  CB  ARG A  76      18.028  -8.300  19.939  1.00  0.00           C  
ATOM   1182  CG  ARG A  76      17.141  -7.705  21.018  1.00  0.00           C  
ATOM   1183  CD  ARG A  76      17.682  -6.376  21.518  1.00  0.00           C  
ATOM   1184  NE  ARG A  76      17.565  -5.314  20.514  1.00  0.00           N  
ATOM   1185  CZ  ARG A  76      17.423  -4.023  20.819  1.00  0.00           C  
ATOM   1186  NH1 ARG A  76      17.432  -3.641  22.090  1.00  0.00           N  
ATOM   1187  NH2 ARG A  76      17.283  -3.114  19.858  1.00  0.00           N  
ATOM   1188  H   ARG A  76      17.967 -11.031  20.697  1.00  0.00           H  
ATOM   1189  HA  ARG A  76      16.493  -9.289  18.821  1.00  0.00           H  
ATOM   1190  HB2 ARG A  76      18.976  -8.560  20.387  1.00  0.00           H  
ATOM   1191  HB3 ARG A  76      18.192  -7.547  19.182  1.00  0.00           H  
ATOM   1192  HG2 ARG A  76      16.152  -7.548  20.611  1.00  0.00           H  
ATOM   1193  HG3 ARG A  76      17.085  -8.395  21.846  1.00  0.00           H  
ATOM   1194  HD2 ARG A  76      17.128  -6.084  22.399  1.00  0.00           H  
ATOM   1195  HD3 ARG A  76      18.723  -6.501  21.774  1.00  0.00           H  
ATOM   1196  HE  ARG A  76      17.582  -5.582  19.571  1.00  0.00           H  
ATOM   1197 HH11 ARG A  76      17.545  -4.318  22.819  1.00  0.00           H  
ATOM   1198 HH12 ARG A  76      17.338  -2.665  22.330  1.00  0.00           H  
ATOM   1199 HH21 ARG A  76      17.290  -3.388  18.894  1.00  0.00           H  
ATOM   1200 HH22 ARG A  76      17.149  -2.142  20.098  1.00  0.00           H  
ATOM   1201  N   PHE A  77      17.891 -10.052  16.958  1.00  0.00           N  
ATOM   1202  CA  PHE A  77      18.676 -10.514  15.825  1.00  0.00           C  
ATOM   1203  C   PHE A  77      19.095  -9.339  14.949  1.00  0.00           C  
ATOM   1204  O   PHE A  77      18.252  -8.592  14.451  1.00  0.00           O  
ATOM   1205  CB  PHE A  77      17.874 -11.525  14.996  1.00  0.00           C  
ATOM   1206  CG  PHE A  77      17.473 -12.759  15.759  1.00  0.00           C  
ATOM   1207  CD1 PHE A  77      16.390 -12.736  16.625  1.00  0.00           C  
ATOM   1208  CD2 PHE A  77      18.179 -13.942  15.609  1.00  0.00           C  
ATOM   1209  CE1 PHE A  77      16.021 -13.866  17.328  1.00  0.00           C  
ATOM   1210  CE2 PHE A  77      17.813 -15.078  16.309  1.00  0.00           C  
ATOM   1211  CZ  PHE A  77      16.733 -15.039  17.170  1.00  0.00           C  
ATOM   1212  H   PHE A  77      16.969  -9.744  16.809  1.00  0.00           H  
ATOM   1213  HA  PHE A  77      19.562 -10.997  16.208  1.00  0.00           H  
ATOM   1214  HB2 PHE A  77      16.972 -11.049  14.639  1.00  0.00           H  
ATOM   1215  HB3 PHE A  77      18.469 -11.835  14.150  1.00  0.00           H  
ATOM   1216  HD1 PHE A  77      15.832 -11.820  16.750  1.00  0.00           H  
ATOM   1217  HD2 PHE A  77      19.023 -13.973  14.935  1.00  0.00           H  
ATOM   1218  HE1 PHE A  77      15.176 -13.834  18.000  1.00  0.00           H  
ATOM   1219  HE2 PHE A  77      18.372 -15.993  16.183  1.00  0.00           H  
ATOM   1220  HZ  PHE A  77      16.447 -15.924  17.718  1.00  0.00           H  
ATOM   1221  N   ARG A  78      20.400  -9.169  14.792  1.00  0.00           N  
ATOM   1222  CA  ARG A  78      20.952  -8.130  13.933  1.00  0.00           C  
ATOM   1223  C   ARG A  78      20.722  -8.483  12.465  1.00  0.00           C  
ATOM   1224  O   ARG A  78      21.234  -9.489  11.974  1.00  0.00           O  
ATOM   1225  CB  ARG A  78      22.446  -7.970  14.224  1.00  0.00           C  
ATOM   1226  CG  ARG A  78      23.167  -7.008  13.303  1.00  0.00           C  
ATOM   1227  CD  ARG A  78      24.644  -6.946  13.643  1.00  0.00           C  
ATOM   1228  NE  ARG A  78      25.409  -6.227  12.634  1.00  0.00           N  
ATOM   1229  CZ  ARG A  78      26.694  -5.902  12.764  1.00  0.00           C  
ATOM   1230  NH1 ARG A  78      27.367  -6.268  13.852  1.00  0.00           N  
ATOM   1231  NH2 ARG A  78      27.305  -5.219  11.805  1.00  0.00           N  
ATOM   1232  H   ARG A  78      21.017  -9.761  15.276  1.00  0.00           H  
ATOM   1233  HA  ARG A  78      20.445  -7.203  14.157  1.00  0.00           H  
ATOM   1234  HB2 ARG A  78      22.563  -7.614  15.236  1.00  0.00           H  
ATOM   1235  HB3 ARG A  78      22.920  -8.938  14.138  1.00  0.00           H  
ATOM   1236  HG2 ARG A  78      23.052  -7.342  12.282  1.00  0.00           H  
ATOM   1237  HG3 ARG A  78      22.737  -6.024  13.415  1.00  0.00           H  
ATOM   1238  HD2 ARG A  78      24.762  -6.446  14.592  1.00  0.00           H  
ATOM   1239  HD3 ARG A  78      25.025  -7.955  13.719  1.00  0.00           H  
ATOM   1240  HE  ARG A  78      24.932  -5.962  11.814  1.00  0.00           H  
ATOM   1241 HH11 ARG A  78      26.909  -6.788  14.577  1.00  0.00           H  
ATOM   1242 HH12 ARG A  78      28.334  -6.032  13.950  1.00  0.00           H  
ATOM   1243 HH21 ARG A  78      26.800  -4.947  10.978  1.00  0.00           H  
ATOM   1244 HH22 ARG A  78      28.274  -4.961  11.898  1.00  0.00           H  
ATOM   1245  N   LEU A  79      19.964  -7.639  11.777  1.00  0.00           N  
ATOM   1246  CA  LEU A  79      19.512  -7.927  10.416  1.00  0.00           C  
ATOM   1247  C   LEU A  79      20.616  -7.742   9.379  1.00  0.00           C  
ATOM   1248  O   LEU A  79      20.497  -8.228   8.258  1.00  0.00           O  
ATOM   1249  CB  LEU A  79      18.329  -7.023  10.065  1.00  0.00           C  
ATOM   1250  CG  LEU A  79      17.095  -7.197  10.949  1.00  0.00           C  
ATOM   1251  CD1 LEU A  79      16.024  -6.193  10.564  1.00  0.00           C  
ATOM   1252  CD2 LEU A  79      16.562  -8.615  10.839  1.00  0.00           C  
ATOM   1253  H   LEU A  79      19.691  -6.793  12.200  1.00  0.00           H  
ATOM   1254  HA  LEU A  79      19.181  -8.953  10.389  1.00  0.00           H  
ATOM   1255  HB2 LEU A  79      18.654  -5.996  10.136  1.00  0.00           H  
ATOM   1256  HB3 LEU A  79      18.042  -7.221   9.043  1.00  0.00           H  
ATOM   1257  HG  LEU A  79      17.369  -7.019  11.978  1.00  0.00           H  
ATOM   1258 HD11 LEU A  79      15.738  -6.349   9.534  1.00  0.00           H  
ATOM   1259 HD12 LEU A  79      16.411  -5.192  10.683  1.00  0.00           H  
ATOM   1260 HD13 LEU A  79      15.162  -6.324  11.201  1.00  0.00           H  
ATOM   1261 HD21 LEU A  79      15.693  -8.723  11.471  1.00  0.00           H  
ATOM   1262 HD22 LEU A  79      17.325  -9.313  11.152  1.00  0.00           H  
ATOM   1263 HD23 LEU A  79      16.286  -8.818   9.814  1.00  0.00           H  
ATOM   1264  N   SER A  80      21.677  -7.039   9.756  1.00  0.00           N  
ATOM   1265  CA  SER A  80      22.777  -6.733   8.842  1.00  0.00           C  
ATOM   1266  C   SER A  80      23.352  -8.005   8.211  1.00  0.00           C  
ATOM   1267  O   SER A  80      23.691  -8.027   7.026  1.00  0.00           O  
ATOM   1268  CB  SER A  80      23.857  -5.989   9.615  1.00  0.00           C  
ATOM   1269  OG  SER A  80      23.270  -5.217  10.654  1.00  0.00           O  
ATOM   1270  H   SER A  80      21.722  -6.702  10.672  1.00  0.00           H  
ATOM   1271  HA  SER A  80      22.397  -6.092   8.061  1.00  0.00           H  
ATOM   1272  HB2 SER A  80      24.545  -6.698  10.050  1.00  0.00           H  
ATOM   1273  HB3 SER A  80      24.390  -5.329   8.947  1.00  0.00           H  
ATOM   1274  HG  SER A  80      23.843  -4.450  10.861  1.00  0.00           H  
ATOM   1275  N   ASP A  81      23.450  -9.057   9.013  1.00  0.00           N  
ATOM   1276  CA  ASP A  81      23.896 -10.361   8.535  1.00  0.00           C  
ATOM   1277  C   ASP A  81      23.132 -11.451   9.265  1.00  0.00           C  
ATOM   1278  O   ASP A  81      22.444 -12.259   8.653  1.00  0.00           O  
ATOM   1279  CB  ASP A  81      25.404 -10.546   8.745  1.00  0.00           C  
ATOM   1280  CG  ASP A  81      25.887 -11.923   8.319  1.00  0.00           C  
ATOM   1281  OD1 ASP A  81      26.200 -12.111   7.120  1.00  0.00           O  
ATOM   1282  OD2 ASP A  81      25.958 -12.827   9.179  1.00  0.00           O  
ATOM   1283  H   ASP A  81      23.200  -8.957   9.951  1.00  0.00           H  
ATOM   1284  HA  ASP A  81      23.673 -10.428   7.480  1.00  0.00           H  
ATOM   1285  HB2 ASP A  81      25.935  -9.804   8.168  1.00  0.00           H  
ATOM   1286  HB3 ASP A  81      25.633 -10.412   9.792  1.00  0.00           H  
ATOM   1287  N   GLY A  82      23.232 -11.450  10.582  1.00  0.00           N  
ATOM   1288  CA  GLY A  82      22.520 -12.439  11.361  1.00  0.00           C  
ATOM   1289  C   GLY A  82      23.116 -12.636  12.732  1.00  0.00           C  
ATOM   1290  O   GLY A  82      23.174 -13.756  13.244  1.00  0.00           O  
ATOM   1291  H   GLY A  82      23.794 -10.777  11.023  1.00  0.00           H  
ATOM   1292  HA2 GLY A  82      21.493 -12.125  11.471  1.00  0.00           H  
ATOM   1293  HA3 GLY A  82      22.542 -13.380  10.832  1.00  0.00           H  
ATOM   1294  N   LEU A  83      23.564 -11.550  13.339  1.00  0.00           N  
ATOM   1295  CA  LEU A  83      24.142 -11.624  14.663  1.00  0.00           C  
ATOM   1296  C   LEU A  83      23.063 -11.466  15.723  1.00  0.00           C  
ATOM   1297  O   LEU A  83      22.615 -10.360  16.005  1.00  0.00           O  
ATOM   1298  CB  LEU A  83      25.203 -10.544  14.861  1.00  0.00           C  
ATOM   1299  CG  LEU A  83      25.867 -10.556  16.238  1.00  0.00           C  
ATOM   1300  CD1 LEU A  83      26.858 -11.703  16.344  1.00  0.00           C  
ATOM   1301  CD2 LEU A  83      26.541  -9.225  16.520  1.00  0.00           C  
ATOM   1302  H   LEU A  83      23.500 -10.684  12.889  1.00  0.00           H  
ATOM   1303  HA  LEU A  83      24.602 -12.595  14.772  1.00  0.00           H  
ATOM   1304  HB2 LEU A  83      25.968 -10.678  14.110  1.00  0.00           H  
ATOM   1305  HB3 LEU A  83      24.741  -9.579  14.715  1.00  0.00           H  
ATOM   1306  HG  LEU A  83      25.106 -10.709  16.990  1.00  0.00           H  
ATOM   1307 HD11 LEU A  83      27.636 -11.573  15.608  1.00  0.00           H  
ATOM   1308 HD12 LEU A  83      26.345 -12.637  16.166  1.00  0.00           H  
ATOM   1309 HD13 LEU A  83      27.294 -11.713  17.332  1.00  0.00           H  
ATOM   1310 HD21 LEU A  83      27.006  -9.258  17.494  1.00  0.00           H  
ATOM   1311 HD22 LEU A  83      25.799  -8.438  16.504  1.00  0.00           H  
ATOM   1312 HD23 LEU A  83      27.290  -9.032  15.768  1.00  0.00           H  
ATOM   1313  N   CYS A  84      22.619 -12.570  16.276  1.00  0.00           N  
ATOM   1314  CA  CYS A  84      21.746 -12.521  17.429  1.00  0.00           C  
ATOM   1315  C   CYS A  84      22.594 -12.226  18.654  1.00  0.00           C  
ATOM   1316  O   CYS A  84      23.564 -12.931  18.916  1.00  0.00           O  
ATOM   1317  CB  CYS A  84      20.994 -13.840  17.590  1.00  0.00           C  
ATOM   1318  SG  CYS A  84      19.977 -13.952  19.081  1.00  0.00           S  
ATOM   1319  H   CYS A  84      22.884 -13.438  15.906  1.00  0.00           H  
ATOM   1320  HA  CYS A  84      21.039 -11.716  17.284  1.00  0.00           H  
ATOM   1321  HB2 CYS A  84      20.341 -13.975  16.742  1.00  0.00           H  
ATOM   1322  HB3 CYS A  84      21.706 -14.647  17.616  1.00  0.00           H  
ATOM   1323  HG  CYS A  84      19.623 -12.721  19.444  1.00  0.00           H  
ATOM   1324  N   MET A  85      22.248 -11.178  19.385  1.00  0.00           N  
ATOM   1325  CA  MET A  85      23.059 -10.735  20.517  1.00  0.00           C  
ATOM   1326  C   MET A  85      23.088 -11.791  21.625  1.00  0.00           C  
ATOM   1327  O   MET A  85      23.921 -11.742  22.530  1.00  0.00           O  
ATOM   1328  CB  MET A  85      22.523  -9.408  21.061  1.00  0.00           C  
ATOM   1329  CG  MET A  85      23.500  -8.680  21.972  1.00  0.00           C  
ATOM   1330  SD  MET A  85      25.034  -8.241  21.131  1.00  0.00           S  
ATOM   1331  CE  MET A  85      25.902  -7.381  22.443  1.00  0.00           C  
ATOM   1332  H   MET A  85      21.430 -10.682  19.158  1.00  0.00           H  
ATOM   1333  HA  MET A  85      24.067 -10.583  20.158  1.00  0.00           H  
ATOM   1334  HB2 MET A  85      22.289  -8.760  20.229  1.00  0.00           H  
ATOM   1335  HB3 MET A  85      21.619  -9.601  21.621  1.00  0.00           H  
ATOM   1336  HG2 MET A  85      23.032  -7.777  22.332  1.00  0.00           H  
ATOM   1337  HG3 MET A  85      23.735  -9.321  22.810  1.00  0.00           H  
ATOM   1338  HE1 MET A  85      25.311  -6.538  22.771  1.00  0.00           H  
ATOM   1339  HE2 MET A  85      26.854  -7.033  22.074  1.00  0.00           H  
ATOM   1340  HE3 MET A  85      26.060  -8.056  23.271  1.00  0.00           H  
ATOM   1341  N   GLU A  86      22.166 -12.737  21.550  1.00  0.00           N  
ATOM   1342  CA  GLU A  86      22.096 -13.829  22.511  1.00  0.00           C  
ATOM   1343  C   GLU A  86      22.890 -15.039  22.009  1.00  0.00           C  
ATOM   1344  O   GLU A  86      23.430 -15.817  22.794  1.00  0.00           O  
ATOM   1345  CB  GLU A  86      20.635 -14.242  22.747  1.00  0.00           C  
ATOM   1346  CG  GLU A  86      19.752 -13.157  23.360  1.00  0.00           C  
ATOM   1347  CD  GLU A  86      19.598 -11.930  22.477  1.00  0.00           C  
ATOM   1348  OE1 GLU A  86      19.170 -12.074  21.315  1.00  0.00           O  
ATOM   1349  OE2 GLU A  86      19.935 -10.819  22.941  1.00  0.00           O  
ATOM   1350  H   GLU A  86      21.497 -12.691  20.835  1.00  0.00           H  
ATOM   1351  HA  GLU A  86      22.523 -13.489  23.442  1.00  0.00           H  
ATOM   1352  HB2 GLU A  86      20.203 -14.529  21.800  1.00  0.00           H  
ATOM   1353  HB3 GLU A  86      20.621 -15.097  23.406  1.00  0.00           H  
ATOM   1354  HG2 GLU A  86      18.770 -13.572  23.537  1.00  0.00           H  
ATOM   1355  HG3 GLU A  86      20.185 -12.853  24.302  1.00  0.00           H  
ATOM   1356  N   ASP A  87      22.958 -15.172  20.691  1.00  0.00           N  
ATOM   1357  CA  ASP A  87      23.545 -16.345  20.040  1.00  0.00           C  
ATOM   1358  C   ASP A  87      24.907 -16.008  19.421  1.00  0.00           C  
ATOM   1359  O   ASP A  87      25.465 -16.793  18.664  1.00  0.00           O  
ATOM   1360  CB  ASP A  87      22.580 -16.879  18.970  1.00  0.00           C  
ATOM   1361  CG  ASP A  87      22.995 -18.221  18.393  1.00  0.00           C  
ATOM   1362  OD1 ASP A  87      22.733 -19.257  19.039  1.00  0.00           O  
ATOM   1363  OD2 ASP A  87      23.569 -18.237  17.286  1.00  0.00           O  
ATOM   1364  H   ASP A  87      22.608 -14.449  20.129  1.00  0.00           H  
ATOM   1365  HA  ASP A  87      23.686 -17.104  20.794  1.00  0.00           H  
ATOM   1366  HB2 ASP A  87      21.599 -16.988  19.404  1.00  0.00           H  
ATOM   1367  HB3 ASP A  87      22.531 -16.168  18.161  1.00  0.00           H  
ATOM   1368  N   GLU A  88      25.428 -14.823  19.744  1.00  0.00           N  
ATOM   1369  CA  GLU A  88      26.644 -14.276  19.111  1.00  0.00           C  
ATOM   1370  C   GLU A  88      27.841 -15.245  19.074  1.00  0.00           C  
ATOM   1371  O   GLU A  88      28.805 -15.008  18.339  1.00  0.00           O  
ATOM   1372  CB  GLU A  88      27.045 -12.951  19.781  1.00  0.00           C  
ATOM   1373  CG  GLU A  88      26.919 -12.931  21.303  1.00  0.00           C  
ATOM   1374  CD  GLU A  88      27.916 -13.825  22.011  1.00  0.00           C  
ATOM   1375  OE1 GLU A  88      29.106 -13.453  22.095  1.00  0.00           O  
ATOM   1376  OE2 GLU A  88      27.514 -14.902  22.495  1.00  0.00           O  
ATOM   1377  H   GLU A  88      24.977 -14.288  20.430  1.00  0.00           H  
ATOM   1378  HA  GLU A  88      26.378 -14.055  18.088  1.00  0.00           H  
ATOM   1379  HB2 GLU A  88      28.073 -12.736  19.531  1.00  0.00           H  
ATOM   1380  HB3 GLU A  88      26.420 -12.163  19.384  1.00  0.00           H  
ATOM   1381  HG2 GLU A  88      27.069 -11.920  21.646  1.00  0.00           H  
ATOM   1382  HG3 GLU A  88      25.921 -13.252  21.568  1.00  0.00           H  
ATOM   1383  N   GLN A  89      27.789 -16.315  19.856  1.00  0.00           N  
ATOM   1384  CA  GLN A  89      28.810 -17.357  19.803  1.00  0.00           C  
ATOM   1385  C   GLN A  89      28.749 -18.116  18.473  1.00  0.00           C  
ATOM   1386  O   GLN A  89      29.781 -18.455  17.890  1.00  0.00           O  
ATOM   1387  CB  GLN A  89      28.631 -18.345  20.962  1.00  0.00           C  
ATOM   1388  CG  GLN A  89      28.877 -17.739  22.334  1.00  0.00           C  
ATOM   1389  CD  GLN A  89      30.301 -17.249  22.507  1.00  0.00           C  
ATOM   1390  OE1 GLN A  89      31.233 -17.784  21.909  1.00  0.00           O  
ATOM   1391  NE2 GLN A  89      30.480 -16.226  23.323  1.00  0.00           N  
ATOM   1392  H   GLN A  89      27.050 -16.404  20.492  1.00  0.00           H  
ATOM   1393  HA  GLN A  89      29.775 -16.882  19.890  1.00  0.00           H  
ATOM   1394  HB2 GLN A  89      27.622 -18.728  20.940  1.00  0.00           H  
ATOM   1395  HB3 GLN A  89      29.320 -19.166  20.828  1.00  0.00           H  
ATOM   1396  HG2 GLN A  89      28.206 -16.904  22.470  1.00  0.00           H  
ATOM   1397  HG3 GLN A  89      28.676 -18.488  23.087  1.00  0.00           H  
ATOM   1398 HE21 GLN A  89      29.692 -15.847  23.771  1.00  0.00           H  
ATOM   1399 HE22 GLN A  89      31.394 -15.884  23.446  1.00  0.00           H  
ATOM   1400  N   PHE A  90      27.537 -18.364  17.990  1.00  0.00           N  
ATOM   1401  CA  PHE A  90      27.339 -19.188  16.802  1.00  0.00           C  
ATOM   1402  C   PHE A  90      26.863 -18.352  15.616  1.00  0.00           C  
ATOM   1403  O   PHE A  90      27.404 -18.476  14.513  1.00  0.00           O  
ATOM   1404  CB  PHE A  90      26.324 -20.300  17.090  1.00  0.00           C  
ATOM   1405  CG  PHE A  90      26.715 -21.199  18.230  1.00  0.00           C  
ATOM   1406  CD1 PHE A  90      27.551 -22.284  18.020  1.00  0.00           C  
ATOM   1407  CD2 PHE A  90      26.242 -20.961  19.511  1.00  0.00           C  
ATOM   1408  CE1 PHE A  90      27.910 -23.112  19.066  1.00  0.00           C  
ATOM   1409  CE2 PHE A  90      26.597 -21.786  20.561  1.00  0.00           C  
ATOM   1410  CZ  PHE A  90      27.433 -22.863  20.338  1.00  0.00           C  
ATOM   1411  H   PHE A  90      26.750 -17.972  18.437  1.00  0.00           H  
ATOM   1412  HA  PHE A  90      28.287 -19.638  16.552  1.00  0.00           H  
ATOM   1413  HB2 PHE A  90      25.372 -19.854  17.333  1.00  0.00           H  
ATOM   1414  HB3 PHE A  90      26.213 -20.913  16.207  1.00  0.00           H  
ATOM   1415  HD1 PHE A  90      27.925 -22.480  17.026  1.00  0.00           H  
ATOM   1416  HD2 PHE A  90      25.589 -20.118  19.686  1.00  0.00           H  
ATOM   1417  HE1 PHE A  90      28.565 -23.953  18.889  1.00  0.00           H  
ATOM   1418  HE2 PHE A  90      26.223 -21.589  21.554  1.00  0.00           H  
ATOM   1419  HZ  PHE A  90      27.713 -23.509  21.156  1.00  0.00           H  
ATOM   1420  N   SER A  91      25.857 -17.509  15.864  1.00  0.00           N  
ATOM   1421  CA  SER A  91      25.224 -16.669  14.839  1.00  0.00           C  
ATOM   1422  C   SER A  91      24.277 -17.502  13.972  1.00  0.00           C  
ATOM   1423  O   SER A  91      24.544 -18.669  13.672  1.00  0.00           O  
ATOM   1424  CB  SER A  91      26.265 -15.941  13.979  1.00  0.00           C  
ATOM   1425  OG  SER A  91      27.137 -15.168  14.791  1.00  0.00           O  
ATOM   1426  H   SER A  91      25.490 -17.478  16.778  1.00  0.00           H  
ATOM   1427  HA  SER A  91      24.633 -15.929  15.360  1.00  0.00           H  
ATOM   1428  HB2 SER A  91      26.849 -16.666  13.431  1.00  0.00           H  
ATOM   1429  HB3 SER A  91      25.762 -15.282  13.282  1.00  0.00           H  
ATOM   1430  HG  SER A  91      27.349 -15.669  15.587  1.00  0.00           H  
ATOM   1431  N   VAL A  92      23.171 -16.897  13.559  1.00  0.00           N  
ATOM   1432  CA  VAL A  92      22.105 -17.641  12.902  1.00  0.00           C  
ATOM   1433  C   VAL A  92      22.269 -17.676  11.386  1.00  0.00           C  
ATOM   1434  O   VAL A  92      23.102 -16.970  10.811  1.00  0.00           O  
ATOM   1435  CB  VAL A  92      20.709 -17.080  13.249  1.00  0.00           C  
ATOM   1436  CG1 VAL A  92      20.434 -17.215  14.739  1.00  0.00           C  
ATOM   1437  CG2 VAL A  92      20.574 -15.628  12.804  1.00  0.00           C  
ATOM   1438  H   VAL A  92      23.076 -15.930  13.688  1.00  0.00           H  
ATOM   1439  HA  VAL A  92      22.150 -18.656  13.269  1.00  0.00           H  
ATOM   1440  HB  VAL A  92      19.970 -17.663  12.719  1.00  0.00           H  
ATOM   1441 HG11 VAL A  92      21.186 -16.673  15.295  1.00  0.00           H  
ATOM   1442 HG12 VAL A  92      20.464 -18.259  15.018  1.00  0.00           H  
ATOM   1443 HG13 VAL A  92      19.459 -16.809  14.964  1.00  0.00           H  
ATOM   1444 HG21 VAL A  92      19.597 -15.257  13.075  1.00  0.00           H  
ATOM   1445 HG22 VAL A  92      20.698 -15.567  11.733  1.00  0.00           H  
ATOM   1446 HG23 VAL A  92      21.333 -15.031  13.288  1.00  0.00           H  
ATOM   1447  N   LYS A  93      21.451 -18.511  10.759  1.00  0.00           N  
ATOM   1448  CA  LYS A  93      21.475 -18.721   9.319  1.00  0.00           C  
ATOM   1449  C   LYS A  93      21.115 -17.434   8.575  1.00  0.00           C  
ATOM   1450  O   LYS A  93      20.100 -16.804   8.872  1.00  0.00           O  
ATOM   1451  CB  LYS A  93      20.472 -19.823   8.968  1.00  0.00           C  
ATOM   1452  CG  LYS A  93      20.608 -20.390   7.567  1.00  0.00           C  
ATOM   1453  CD  LYS A  93      21.815 -21.300   7.441  1.00  0.00           C  
ATOM   1454  CE  LYS A  93      21.719 -22.183   6.206  1.00  0.00           C  
ATOM   1455  NZ  LYS A  93      20.536 -23.089   6.257  1.00  0.00           N  
ATOM   1456  H   LYS A  93      20.798 -19.009  11.290  1.00  0.00           H  
ATOM   1457  HA  LYS A  93      22.467 -19.036   9.034  1.00  0.00           H  
ATOM   1458  HB2 LYS A  93      20.593 -20.633   9.669  1.00  0.00           H  
ATOM   1459  HB3 LYS A  93      19.478 -19.420   9.071  1.00  0.00           H  
ATOM   1460  HG2 LYS A  93      19.719 -20.957   7.331  1.00  0.00           H  
ATOM   1461  HG3 LYS A  93      20.710 -19.574   6.867  1.00  0.00           H  
ATOM   1462  HD2 LYS A  93      22.705 -20.693   7.370  1.00  0.00           H  
ATOM   1463  HD3 LYS A  93      21.873 -21.928   8.318  1.00  0.00           H  
ATOM   1464  HE2 LYS A  93      21.641 -21.552   5.332  1.00  0.00           H  
ATOM   1465  HE3 LYS A  93      22.617 -22.780   6.138  1.00  0.00           H  
ATOM   1466  HZ1 LYS A  93      19.652 -22.545   6.143  1.00  0.00           H  
ATOM   1467  HZ2 LYS A  93      20.505 -23.589   7.174  1.00  0.00           H  
ATOM   1468  HZ3 LYS A  93      20.597 -23.800   5.495  1.00  0.00           H  
ATOM   1469  N   HIS A  94      21.944 -17.059   7.612  1.00  0.00           N  
ATOM   1470  CA  HIS A  94      21.711 -15.862   6.815  1.00  0.00           C  
ATOM   1471  C   HIS A  94      21.542 -16.225   5.344  1.00  0.00           C  
ATOM   1472  O   HIS A  94      22.303 -17.023   4.799  1.00  0.00           O  
ATOM   1473  CB  HIS A  94      22.871 -14.869   7.000  1.00  0.00           C  
ATOM   1474  CG  HIS A  94      22.873 -13.711   6.041  1.00  0.00           C  
ATOM   1475  ND1 HIS A  94      23.968 -13.384   5.272  1.00  0.00           N  
ATOM   1476  CD2 HIS A  94      21.920 -12.792   5.740  1.00  0.00           C  
ATOM   1477  CE1 HIS A  94      23.694 -12.319   4.544  1.00  0.00           C  
ATOM   1478  NE2 HIS A  94      22.459 -11.939   4.806  1.00  0.00           N  
ATOM   1479  H   HIS A  94      22.737 -17.602   7.427  1.00  0.00           H  
ATOM   1480  HA  HIS A  94      20.799 -15.403   7.167  1.00  0.00           H  
ATOM   1481  HB2 HIS A  94      22.825 -14.464   7.999  1.00  0.00           H  
ATOM   1482  HB3 HIS A  94      23.805 -15.396   6.881  1.00  0.00           H  
ATOM   1483  HD1 HIS A  94      24.828 -13.857   5.273  1.00  0.00           H  
ATOM   1484  HD2 HIS A  94      20.923 -12.742   6.156  1.00  0.00           H  
ATOM   1485  HE1 HIS A  94      24.368 -11.838   3.850  1.00  0.00           H  
ATOM   1486  HE2 HIS A  94      21.959 -11.268   4.292  1.00  0.00           H  
ATOM   1487  N   TYR A  95      20.526 -15.648   4.722  1.00  0.00           N  
ATOM   1488  CA  TYR A  95      20.274 -15.835   3.302  1.00  0.00           C  
ATOM   1489  C   TYR A  95      20.367 -14.493   2.599  1.00  0.00           C  
ATOM   1490  O   TYR A  95      20.157 -13.449   3.220  1.00  0.00           O  
ATOM   1491  CB  TYR A  95      18.890 -16.447   3.073  1.00  0.00           C  
ATOM   1492  CG  TYR A  95      18.714 -17.793   3.729  1.00  0.00           C  
ATOM   1493  CD1 TYR A  95      19.050 -18.960   3.058  1.00  0.00           C  
ATOM   1494  CD2 TYR A  95      18.223 -17.897   5.025  1.00  0.00           C  
ATOM   1495  CE1 TYR A  95      18.901 -20.194   3.659  1.00  0.00           C  
ATOM   1496  CE2 TYR A  95      18.077 -19.125   5.634  1.00  0.00           C  
ATOM   1497  CZ  TYR A  95      18.417 -20.271   4.947  1.00  0.00           C  
ATOM   1498  OH  TYR A  95      18.286 -21.497   5.554  1.00  0.00           O  
ATOM   1499  H   TYR A  95      19.927 -15.062   5.234  1.00  0.00           H  
ATOM   1500  HA  TYR A  95      21.031 -16.497   2.907  1.00  0.00           H  
ATOM   1501  HB2 TYR A  95      18.139 -15.782   3.472  1.00  0.00           H  
ATOM   1502  HB3 TYR A  95      18.728 -16.569   2.011  1.00  0.00           H  
ATOM   1503  HD1 TYR A  95      19.428 -18.895   2.049  1.00  0.00           H  
ATOM   1504  HD2 TYR A  95      17.957 -16.997   5.558  1.00  0.00           H  
ATOM   1505  HE1 TYR A  95      19.164 -21.092   3.118  1.00  0.00           H  
ATOM   1506  HE2 TYR A  95      17.693 -19.184   6.641  1.00  0.00           H  
ATOM   1507  HH  TYR A  95      17.496 -21.501   6.120  1.00  0.00           H  
ATOM   1508  N   GLU A  96      20.685 -14.509   1.320  1.00  0.00           N  
ATOM   1509  CA  GLU A  96      20.814 -13.267   0.582  1.00  0.00           C  
ATOM   1510  C   GLU A  96      19.480 -12.905  -0.050  1.00  0.00           C  
ATOM   1511  O   GLU A  96      18.815 -13.759  -0.635  1.00  0.00           O  
ATOM   1512  CB  GLU A  96      21.894 -13.379  -0.489  1.00  0.00           C  
ATOM   1513  CG  GLU A  96      22.556 -12.049  -0.805  1.00  0.00           C  
ATOM   1514  CD  GLU A  96      23.380 -11.526   0.357  1.00  0.00           C  
ATOM   1515  OE1 GLU A  96      22.789 -11.083   1.362  1.00  0.00           O  
ATOM   1516  OE2 GLU A  96      24.626 -11.577   0.274  1.00  0.00           O  
ATOM   1517  H   GLU A  96      20.821 -15.369   0.861  1.00  0.00           H  
ATOM   1518  HA  GLU A  96      21.089 -12.491   1.282  1.00  0.00           H  
ATOM   1519  HB2 GLU A  96      22.654 -14.068  -0.152  1.00  0.00           H  
ATOM   1520  HB3 GLU A  96      21.449 -13.760  -1.397  1.00  0.00           H  
ATOM   1521  HG2 GLU A  96      23.204 -12.178  -1.659  1.00  0.00           H  
ATOM   1522  HG3 GLU A  96      21.790 -11.325  -1.040  1.00  0.00           H  
ATOM   1523  N   ALA A  97      19.092 -11.646   0.077  1.00  0.00           N  
ATOM   1524  CA  ALA A  97      17.814 -11.190  -0.441  1.00  0.00           C  
ATOM   1525  C   ALA A  97      17.996  -9.984  -1.351  1.00  0.00           C  
ATOM   1526  O   ALA A  97      18.665  -9.016  -0.988  1.00  0.00           O  
ATOM   1527  CB  ALA A  97      16.873 -10.850   0.706  1.00  0.00           C  
ATOM   1528  H   ALA A  97      19.685 -11.006   0.522  1.00  0.00           H  
ATOM   1529  HA  ALA A  97      17.374 -11.996  -1.009  1.00  0.00           H  
ATOM   1530  HB1 ALA A  97      15.917 -10.546   0.307  1.00  0.00           H  
ATOM   1531  HB2 ALA A  97      17.293 -10.046   1.291  1.00  0.00           H  
ATOM   1532  HB3 ALA A  97      16.741 -11.720   1.333  1.00  0.00           H  
ATOM   1533  N   ARG A  98      17.404 -10.045  -2.532  1.00  0.00           N  
ATOM   1534  CA  ARG A  98      17.490  -8.940  -3.475  1.00  0.00           C  
ATOM   1535  C   ARG A  98      16.109  -8.599  -4.013  1.00  0.00           C  
ATOM   1536  O   ARG A  98      15.230  -9.458  -4.077  1.00  0.00           O  
ATOM   1537  CB  ARG A  98      18.428  -9.279  -4.641  1.00  0.00           C  
ATOM   1538  CG  ARG A  98      17.882 -10.339  -5.591  1.00  0.00           C  
ATOM   1539  CD  ARG A  98      18.800 -10.539  -6.786  1.00  0.00           C  
ATOM   1540  NE  ARG A  98      18.279 -11.532  -7.728  1.00  0.00           N  
ATOM   1541  CZ  ARG A  98      18.809 -11.768  -8.930  1.00  0.00           C  
ATOM   1542  NH1 ARG A  98      19.835 -11.048  -9.363  1.00  0.00           N  
ATOM   1543  NH2 ARG A  98      18.292 -12.708  -9.712  1.00  0.00           N  
ATOM   1544  H   ARG A  98      16.888 -10.847  -2.771  1.00  0.00           H  
ATOM   1545  HA  ARG A  98      17.880  -8.084  -2.946  1.00  0.00           H  
ATOM   1546  HB2 ARG A  98      18.613  -8.381  -5.209  1.00  0.00           H  
ATOM   1547  HB3 ARG A  98      19.365  -9.636  -4.238  1.00  0.00           H  
ATOM   1548  HG2 ARG A  98      17.793 -11.273  -5.059  1.00  0.00           H  
ATOM   1549  HG3 ARG A  98      16.909 -10.027  -5.941  1.00  0.00           H  
ATOM   1550  HD2 ARG A  98      18.910  -9.596  -7.300  1.00  0.00           H  
ATOM   1551  HD3 ARG A  98      19.765 -10.868  -6.430  1.00  0.00           H  
ATOM   1552  HE  ARG A  98      17.496 -12.060  -7.445  1.00  0.00           H  
ATOM   1553 HH11 ARG A  98      20.218 -10.314  -8.791  1.00  0.00           H  
ATOM   1554 HH12 ARG A  98      20.236 -11.234 -10.267  1.00  0.00           H  
ATOM   1555 HH21 ARG A  98      17.499 -13.245  -9.403  1.00  0.00           H  
ATOM   1556 HH22 ARG A  98      18.697 -12.889 -10.619  1.00  0.00           H  
ATOM   1557  N   VAL A  99      15.923  -7.343  -4.383  1.00  0.00           N  
ATOM   1558  CA  VAL A  99      14.681  -6.906  -4.999  1.00  0.00           C  
ATOM   1559  C   VAL A  99      14.849  -6.825  -6.512  1.00  0.00           C  
ATOM   1560  O   VAL A  99      15.382  -5.850  -7.043  1.00  0.00           O  
ATOM   1561  CB  VAL A  99      14.223  -5.540  -4.450  1.00  0.00           C  
ATOM   1562  CG1 VAL A  99      12.908  -5.112  -5.080  1.00  0.00           C  
ATOM   1563  CG2 VAL A  99      14.095  -5.596  -2.938  1.00  0.00           C  
ATOM   1564  H   VAL A  99      16.639  -6.689  -4.234  1.00  0.00           H  
ATOM   1565  HA  VAL A  99      13.920  -7.639  -4.772  1.00  0.00           H  
ATOM   1566  HB  VAL A  99      14.972  -4.803  -4.699  1.00  0.00           H  
ATOM   1567 HG11 VAL A  99      13.028  -5.046  -6.152  1.00  0.00           H  
ATOM   1568 HG12 VAL A  99      12.618  -4.148  -4.690  1.00  0.00           H  
ATOM   1569 HG13 VAL A  99      12.143  -5.839  -4.848  1.00  0.00           H  
ATOM   1570 HG21 VAL A  99      15.051  -5.852  -2.506  1.00  0.00           H  
ATOM   1571 HG22 VAL A  99      13.365  -6.345  -2.665  1.00  0.00           H  
ATOM   1572 HG23 VAL A  99      13.778  -4.633  -2.568  1.00  0.00           H  
ATOM   1573  N   LYS A 100      14.411  -7.868  -7.193  1.00  0.00           N  
ATOM   1574  CA  LYS A 100      14.546  -7.960  -8.636  1.00  0.00           C  
ATOM   1575  C   LYS A 100      13.230  -7.630  -9.311  1.00  0.00           C  
ATOM   1576  O   LYS A 100      12.256  -8.365  -9.154  1.00  0.00           O  
ATOM   1577  CB  LYS A 100      14.973  -9.366  -9.034  1.00  0.00           C  
ATOM   1578  CG  LYS A 100      15.213  -9.521 -10.527  1.00  0.00           C  
ATOM   1579  CD  LYS A 100      15.439 -10.970 -10.911  1.00  0.00           C  
ATOM   1580  CE  LYS A 100      15.560 -11.129 -12.416  1.00  0.00           C  
ATOM   1581  NZ  LYS A 100      14.340 -10.658 -13.129  1.00  0.00           N  
ATOM   1582  H   LYS A 100      13.965  -8.602  -6.708  1.00  0.00           H  
ATOM   1583  HA  LYS A 100      15.299  -7.254  -8.953  1.00  0.00           H  
ATOM   1584  HB2 LYS A 100      15.877  -9.612  -8.510  1.00  0.00           H  
ATOM   1585  HB3 LYS A 100      14.198 -10.060  -8.741  1.00  0.00           H  
ATOM   1586  HG2 LYS A 100      14.353  -9.151 -11.062  1.00  0.00           H  
ATOM   1587  HG3 LYS A 100      16.085  -8.946 -10.802  1.00  0.00           H  
ATOM   1588  HD2 LYS A 100      16.350 -11.319 -10.447  1.00  0.00           H  
ATOM   1589  HD3 LYS A 100      14.606 -11.562 -10.562  1.00  0.00           H  
ATOM   1590  HE2 LYS A 100      16.409 -10.555 -12.757  1.00  0.00           H  
ATOM   1591  HE3 LYS A 100      15.719 -12.173 -12.642  1.00  0.00           H  
ATOM   1592  HZ1 LYS A 100      14.166  -9.646 -12.927  1.00  0.00           H  
ATOM   1593  HZ2 LYS A 100      13.508 -11.207 -12.819  1.00  0.00           H  
ATOM   1594  HZ3 LYS A 100      14.460 -10.779 -14.156  1.00  0.00           H  
ATOM   1595  N   ASP A 101      13.198  -6.524 -10.047  1.00  0.00           N  
ATOM   1596  CA  ASP A 101      11.986  -6.091 -10.743  1.00  0.00           C  
ATOM   1597  C   ASP A 101      10.871  -5.824  -9.741  1.00  0.00           C  
ATOM   1598  O   ASP A 101       9.686  -5.872 -10.077  1.00  0.00           O  
ATOM   1599  CB  ASP A 101      11.536  -7.143 -11.770  1.00  0.00           C  
ATOM   1600  CG  ASP A 101      12.469  -7.239 -12.960  1.00  0.00           C  
ATOM   1601  OD1 ASP A 101      12.345  -6.402 -13.882  1.00  0.00           O  
ATOM   1602  OD2 ASP A 101      13.325  -8.151 -12.989  1.00  0.00           O  
ATOM   1603  H   ASP A 101      14.012  -5.978 -10.120  1.00  0.00           H  
ATOM   1604  HA  ASP A 101      12.214  -5.171 -11.261  1.00  0.00           H  
ATOM   1605  HB2 ASP A 101      11.498  -8.110 -11.291  1.00  0.00           H  
ATOM   1606  HB3 ASP A 101      10.549  -6.886 -12.128  1.00  0.00           H  
ATOM   1607  N   GLY A 102      11.264  -5.518  -8.514  1.00  0.00           N  
ATOM   1608  CA  GLY A 102      10.299  -5.307  -7.456  1.00  0.00           C  
ATOM   1609  C   GLY A 102       9.892  -6.600  -6.775  1.00  0.00           C  
ATOM   1610  O   GLY A 102       8.962  -6.612  -5.967  1.00  0.00           O  
ATOM   1611  H   GLY A 102      12.223  -5.418  -8.330  1.00  0.00           H  
ATOM   1612  HA2 GLY A 102      10.728  -4.642  -6.720  1.00  0.00           H  
ATOM   1613  HA3 GLY A 102       9.420  -4.843  -7.876  1.00  0.00           H  
ATOM   1614  N   VAL A 103      10.584  -7.690  -7.089  1.00  0.00           N  
ATOM   1615  CA  VAL A 103      10.255  -8.988  -6.519  1.00  0.00           C  
ATOM   1616  C   VAL A 103      11.368  -9.453  -5.590  1.00  0.00           C  
ATOM   1617  O   VAL A 103      12.543  -9.423  -5.953  1.00  0.00           O  
ATOM   1618  CB  VAL A 103      10.029 -10.050  -7.621  1.00  0.00           C  
ATOM   1619  CG1 VAL A 103       9.568 -11.371  -7.020  1.00  0.00           C  
ATOM   1620  CG2 VAL A 103       9.028  -9.553  -8.651  1.00  0.00           C  
ATOM   1621  H   VAL A 103      11.341  -7.623  -7.722  1.00  0.00           H  
ATOM   1622  HA  VAL A 103       9.341  -8.883  -5.951  1.00  0.00           H  
ATOM   1623  HB  VAL A 103      10.971 -10.221  -8.122  1.00  0.00           H  
ATOM   1624 HG11 VAL A 103       8.612 -11.230  -6.535  1.00  0.00           H  
ATOM   1625 HG12 VAL A 103      10.293 -11.710  -6.296  1.00  0.00           H  
ATOM   1626 HG13 VAL A 103       9.469 -12.107  -7.804  1.00  0.00           H  
ATOM   1627 HG21 VAL A 103       8.084  -9.350  -8.168  1.00  0.00           H  
ATOM   1628 HG22 VAL A 103       8.889 -10.307  -9.411  1.00  0.00           H  
ATOM   1629 HG23 VAL A 103       9.400  -8.647  -9.106  1.00  0.00           H  
ATOM   1630  N   VAL A 104      10.997  -9.872  -4.391  1.00  0.00           N  
ATOM   1631  CA  VAL A 104      11.964 -10.329  -3.407  1.00  0.00           C  
ATOM   1632  C   VAL A 104      12.439 -11.734  -3.747  1.00  0.00           C  
ATOM   1633  O   VAL A 104      11.633 -12.662  -3.847  1.00  0.00           O  
ATOM   1634  CB  VAL A 104      11.367 -10.334  -1.984  1.00  0.00           C  
ATOM   1635  CG1 VAL A 104      12.432 -10.677  -0.953  1.00  0.00           C  
ATOM   1636  CG2 VAL A 104      10.722  -8.994  -1.667  1.00  0.00           C  
ATOM   1637  H   VAL A 104      10.038  -9.894  -4.165  1.00  0.00           H  
ATOM   1638  HA  VAL A 104      12.807  -9.651  -3.423  1.00  0.00           H  
ATOM   1639  HB  VAL A 104      10.602 -11.098  -1.941  1.00  0.00           H  
ATOM   1640 HG11 VAL A 104      13.223  -9.943  -0.995  1.00  0.00           H  
ATOM   1641 HG12 VAL A 104      12.839 -11.655  -1.166  1.00  0.00           H  
ATOM   1642 HG13 VAL A 104      11.992 -10.677   0.033  1.00  0.00           H  
ATOM   1643 HG21 VAL A 104      11.468  -8.214  -1.728  1.00  0.00           H  
ATOM   1644 HG22 VAL A 104      10.309  -9.021  -0.670  1.00  0.00           H  
ATOM   1645 HG23 VAL A 104       9.934  -8.796  -2.379  1.00  0.00           H  
ATOM   1646  N   GLN A 105      13.738 -11.885  -3.944  1.00  0.00           N  
ATOM   1647  CA  GLN A 105      14.318 -13.191  -4.210  1.00  0.00           C  
ATOM   1648  C   GLN A 105      15.321 -13.558  -3.130  1.00  0.00           C  
ATOM   1649  O   GLN A 105      16.049 -12.695  -2.633  1.00  0.00           O  
ATOM   1650  CB  GLN A 105      15.003 -13.222  -5.575  1.00  0.00           C  
ATOM   1651  CG  GLN A 105      14.056 -13.018  -6.741  1.00  0.00           C  
ATOM   1652  CD  GLN A 105      14.715 -13.320  -8.069  1.00  0.00           C  
ATOM   1653  OE1 GLN A 105      15.925 -13.151  -8.230  1.00  0.00           O  
ATOM   1654  NE2 GLN A 105      13.925 -13.764  -9.029  1.00  0.00           N  
ATOM   1655  H   GLN A 105      14.324 -11.095  -3.909  1.00  0.00           H  
ATOM   1656  HA  GLN A 105      13.517 -13.917  -4.202  1.00  0.00           H  
ATOM   1657  HB2 GLN A 105      15.750 -12.443  -5.606  1.00  0.00           H  
ATOM   1658  HB3 GLN A 105      15.489 -14.180  -5.697  1.00  0.00           H  
ATOM   1659  HG2 GLN A 105      13.206 -13.673  -6.619  1.00  0.00           H  
ATOM   1660  HG3 GLN A 105      13.725 -11.991  -6.744  1.00  0.00           H  
ATOM   1661 HE21 GLN A 105      12.961 -13.868  -8.833  1.00  0.00           H  
ATOM   1662 HE22 GLN A 105      14.326 -13.991  -9.891  1.00  0.00           H  
ATOM   1663  N   LEU A 106      15.352 -14.833  -2.776  1.00  0.00           N  
ATOM   1664  CA  LEU A 106      16.265 -15.326  -1.755  1.00  0.00           C  
ATOM   1665  C   LEU A 106      17.279 -16.288  -2.362  1.00  0.00           C  
ATOM   1666  O   LEU A 106      16.932 -17.105  -3.212  1.00  0.00           O  
ATOM   1667  CB  LEU A 106      15.493 -16.047  -0.646  1.00  0.00           C  
ATOM   1668  CG  LEU A 106      14.420 -15.219   0.060  1.00  0.00           C  
ATOM   1669  CD1 LEU A 106      13.723 -16.058   1.118  1.00  0.00           C  
ATOM   1670  CD2 LEU A 106      15.026 -13.972   0.681  1.00  0.00           C  
ATOM   1671  H   LEU A 106      14.745 -15.466  -3.219  1.00  0.00           H  
ATOM   1672  HA  LEU A 106      16.787 -14.482  -1.332  1.00  0.00           H  
ATOM   1673  HB2 LEU A 106      15.020 -16.918  -1.076  1.00  0.00           H  
ATOM   1674  HB3 LEU A 106      16.203 -16.378   0.097  1.00  0.00           H  
ATOM   1675  HG  LEU A 106      13.678 -14.909  -0.664  1.00  0.00           H  
ATOM   1676 HD11 LEU A 106      13.272 -16.922   0.654  1.00  0.00           H  
ATOM   1677 HD12 LEU A 106      12.957 -15.466   1.600  1.00  0.00           H  
ATOM   1678 HD13 LEU A 106      14.444 -16.380   1.854  1.00  0.00           H  
ATOM   1679 HD21 LEU A 106      15.469 -13.362  -0.093  1.00  0.00           H  
ATOM   1680 HD22 LEU A 106      15.787 -14.259   1.392  1.00  0.00           H  
ATOM   1681 HD23 LEU A 106      14.256 -13.409   1.188  1.00  0.00           H  
ATOM   1682  N   ARG A 107      18.529 -16.175  -1.934  1.00  0.00           N  
ATOM   1683  CA  ARG A 107      19.559 -17.124  -2.333  1.00  0.00           C  
ATOM   1684  C   ARG A 107      20.144 -17.802  -1.105  1.00  0.00           C  
ATOM   1685  O   ARG A 107      20.485 -17.140  -0.120  1.00  0.00           O  
ATOM   1686  CB  ARG A 107      20.683 -16.442  -3.120  1.00  0.00           C  
ATOM   1687  CG  ARG A 107      21.730 -17.417  -3.635  1.00  0.00           C  
ATOM   1688  CD  ARG A 107      22.921 -16.707  -4.258  1.00  0.00           C  
ATOM   1689  NE  ARG A 107      23.922 -16.312  -3.267  1.00  0.00           N  
ATOM   1690  CZ  ARG A 107      25.141 -16.848  -3.193  1.00  0.00           C  
ATOM   1691  NH1 ARG A 107      25.512 -17.786  -4.062  1.00  0.00           N  
ATOM   1692  NH2 ARG A 107      25.995 -16.426  -2.267  1.00  0.00           N  
ATOM   1693  H   ARG A 107      18.766 -15.431  -1.333  1.00  0.00           H  
ATOM   1694  HA  ARG A 107      19.095 -17.873  -2.957  1.00  0.00           H  
ATOM   1695  HB2 ARG A 107      20.256 -15.930  -3.971  1.00  0.00           H  
ATOM   1696  HB3 ARG A 107      21.172 -15.722  -2.482  1.00  0.00           H  
ATOM   1697  HG2 ARG A 107      22.079 -18.019  -2.810  1.00  0.00           H  
ATOM   1698  HG3 ARG A 107      21.276 -18.056  -4.378  1.00  0.00           H  
ATOM   1699  HD2 ARG A 107      23.385 -17.370  -4.972  1.00  0.00           H  
ATOM   1700  HD3 ARG A 107      22.567 -15.823  -4.768  1.00  0.00           H  
ATOM   1701  HE  ARG A 107      23.675 -15.600  -2.631  1.00  0.00           H  
ATOM   1702 HH11 ARG A 107      24.875 -18.095  -4.778  1.00  0.00           H  
ATOM   1703 HH12 ARG A 107      26.435 -18.192  -4.014  1.00  0.00           H  
ATOM   1704 HH21 ARG A 107      25.725 -15.702  -1.623  1.00  0.00           H  
ATOM   1705 HH22 ARG A 107      26.910 -16.827  -2.203  1.00  0.00           H  
ATOM   1706  N   GLY A 108      20.250 -19.117  -1.169  1.00  0.00           N  
ATOM   1707  CA  GLY A 108      20.851 -19.871  -0.096  1.00  0.00           C  
ATOM   1708  C   GLY A 108      21.727 -20.975  -0.636  1.00  0.00           C  
ATOM   1709  O   GLY A 108      22.332 -20.814  -1.697  1.00  0.00           O  
ATOM   1710  H   GLY A 108      19.925 -19.587  -1.969  1.00  0.00           H  
ATOM   1711  HA2 GLY A 108      21.450 -19.208   0.512  1.00  0.00           H  
ATOM   1712  HA3 GLY A 108      20.073 -20.303   0.512  1.00  0.00           H  
ATOM   1713  N   GLY A 109      21.793 -22.092   0.082  1.00  0.00           N  
ATOM   1714  CA  GLY A 109      22.577 -23.230  -0.370  1.00  0.00           C  
ATOM   1715  C   GLY A 109      24.000 -22.848  -0.713  1.00  0.00           C  
ATOM   1716  O   GLY A 109      24.489 -23.162  -1.796  1.00  0.00           O  
ATOM   1717  H   GLY A 109      21.304 -22.145   0.927  1.00  0.00           H  
ATOM   1718  HA2 GLY A 109      22.593 -23.974   0.413  1.00  0.00           H  
ATOM   1719  HA3 GLY A 109      22.107 -23.653  -1.244  1.00  0.00           H  
ATOM   1720  N   SER A 110      24.657 -22.162   0.204  1.00  0.00           N  
ATOM   1721  CA  SER A 110      26.001 -21.677  -0.027  1.00  0.00           C  
ATOM   1722  C   SER A 110      27.020 -22.654   0.546  1.00  0.00           C  
ATOM   1723  O   SER A 110      27.543 -23.484  -0.227  1.00  0.00           O  
ATOM   1724  CB  SER A 110      26.165 -20.292   0.599  1.00  0.00           C  
ATOM   1725  OG  SER A 110      25.149 -19.411   0.141  1.00  0.00           O  
ATOM   1726  OXT SER A 110      27.268 -22.612   1.768  1.00  0.00           O  
ATOM   1727  H   SER A 110      24.233 -21.995   1.073  1.00  0.00           H  
ATOM   1728  HA  SER A 110      26.150 -21.602  -1.094  1.00  0.00           H  
ATOM   1729  HB2 SER A 110      26.100 -20.373   1.673  1.00  0.00           H  
ATOM   1730  HB3 SER A 110      27.129 -19.885   0.326  1.00  0.00           H  
ATOM   1731  HG  SER A 110      24.608 -19.865  -0.514  1.00  0.00           H  
TER    1732      SER A 110                                                      
END
MOLECULE T0391.pdb
ATOM      1  N   LYS    14      20.058 -27.031  -4.627  1.00 60.80           N  
ATOM      2  CA  LYS    14      18.878 -26.160  -4.323  1.00 60.75           C  
ATOM      3  C   LYS    14      19.298 -24.755  -3.828  1.00 60.82           C  
ATOM      4  O   LYS    14      18.794 -24.243  -2.809  1.00 60.89           O  
ATOM      5  CB  LYS    14      17.912 -26.875  -3.349  1.00 60.75           C  
ATOM      6  CG  LYS    14      18.148 -26.678  -1.832  1.00 60.46           C  
ATOM      7  CD  LYS    14      19.239 -27.549  -1.251  1.00 60.49           C  
ATOM      8  CE  LYS    14      19.374 -27.296   0.246  1.00 60.57           C  
ATOM      9  NZ  LYS    14      20.401 -28.172   0.889  1.00 60.29           N  
ATOM     10  N   TYR    15      20.208 -24.127  -4.570  1.00 60.44           N  
ATOM     11  CA  TYR    15      20.748 -22.827  -4.172  1.00 60.31           C  
ATOM     12  C   TYR    15      20.596 -21.697  -5.214  1.00 60.11           C  
ATOM     13  O   TYR    15      21.466 -20.821  -5.310  1.00 60.31           O  
ATOM     14  CB  TYR    15      22.220 -22.960  -3.731  1.00 60.66           C  
ATOM     15  CG  TYR    15      22.442 -23.716  -2.429  1.00 60.97           C  
ATOM     16  CD1 TYR    15      22.806 -25.063  -2.440  1.00 60.98           C  
ATOM     17  CD2 TYR    15      22.302 -23.081  -1.190  1.00 60.95           C  
ATOM     18  CE1 TYR    15      23.019 -25.762  -1.253  1.00 61.49           C  
ATOM     19  CE2 TYR    15      22.510 -23.773   0.005  1.00 60.54           C  
ATOM     20  CZ  TYR    15      22.870 -25.113  -0.036  1.00 61.22           C  
ATOM     21  OH  TYR    15      23.090 -25.813   1.132  1.00 61.20           O  
ATOM     22  N   THR    16      19.512 -21.700  -5.992  1.00 59.68           N  
ATOM     23  CA  THR    16      19.188 -20.514  -6.815  1.00 59.63           C  
ATOM     24  C   THR    16      17.836 -19.878  -6.426  1.00 58.97           C  
ATOM     25  O   THR    16      17.024 -20.493  -5.734  1.00 58.66           O  
ATOM     26  CB  THR    16      19.340 -20.760  -8.367  1.00 59.50           C  
ATOM     27  OG1 THR    16      20.712 -21.057  -8.684  1.00 60.71           O  
ATOM     28  CG2 THR    16      18.927 -19.524  -9.191  1.00 59.37           C  
ATOM     29  N   SER    17      17.657 -18.629  -6.856  1.00 59.10           N  
ATOM     30  CA  SER    17      16.500 -17.778  -6.591  1.00 59.12           C  
ATOM     31  C   SER    17      15.164 -18.496  -6.522  1.00 59.74           C  
ATOM     32  O   SER    17      14.808 -19.277  -7.416  1.00 58.25           O  
ATOM     33  CB  SER    17      16.366 -16.691  -7.673  1.00 59.23           C  
ATOM     34  OG  SER    17      17.578 -15.976  -7.871  1.00 60.17           O  
ATOM     35  N   VAL    18      14.428 -18.199  -5.452  1.00 59.57           N  
ATOM     36  CA  VAL    18      13.002 -18.454  -5.422  1.00 59.94           C  
ATOM     37  C   VAL    18      12.366 -17.085  -5.284  1.00 60.39           C  
ATOM     38  O   VAL    18      12.744 -16.309  -4.419  1.00 59.98           O  
ATOM     39  CB  VAL    18      12.613 -19.377  -4.253  1.00 59.90           C  
ATOM     40  CG1 VAL    18      11.086 -19.572  -4.178  1.00 59.62           C  
ATOM     41  CG2 VAL    18      13.318 -20.729  -4.393  1.00 59.73           C  
ATOM     42  N   CYS    19      11.436 -16.772  -6.177  1.00 62.03           N  
ATOM     43  CA  CYS    19      10.675 -15.546  -6.087  1.00 62.30           C  
ATOM     44  C   CYS    19       9.657 -15.686  -4.943  1.00 62.67           C  
ATOM     45  O   CYS    19       8.778 -16.538  -4.994  1.00 63.44           O  
ATOM     46  CB  CYS    19       9.969 -15.293  -7.396  1.00 62.62           C  
ATOM     47  SG  CYS    19       9.161 -13.703  -7.475  1.00 64.96           S  
ATOM     48  N   VAL    20       9.769 -14.851  -3.922  1.00 61.58           N  
ATOM     49  CA  VAL    20       8.958 -15.045  -2.708  1.00 61.49           C  
ATOM     50  C   VAL    20       7.766 -14.103  -2.702  1.00 62.35           C  
ATOM     51  O   VAL    20       6.872 -14.191  -1.856  1.00 63.15           O  
ATOM     52  CB  VAL    20       9.817 -14.911  -1.438  1.00 61.03           C  
ATOM     53  CG1 VAL    20      10.940 -15.911  -1.487  1.00 60.15           C  
ATOM     54  CG2 VAL    20      10.377 -13.514  -1.277  1.00 59.18           C  
ATOM     55  N   GLY    21       7.748 -13.211  -3.677  1.00 62.13           N  
ATOM     56  CA  GLY    21       6.681 -12.283  -3.790  1.00 62.19           C  
ATOM     57  C   GLY    21       7.038 -10.922  -4.329  1.00 62.64           C  
ATOM     58  O   GLY    21       8.104 -10.689  -4.947  1.00 62.35           O  
ATOM     59  N   ARG    22       6.090 -10.026  -4.089  1.00 62.17           N  
ATOM     60  CA  ARG    22       6.044  -8.731  -4.705  1.00 62.01           C  
ATOM     61  C   ARG    22       6.671  -7.685  -3.777  1.00 61.91           C  
ATOM     62  O   ARG    22       6.357  -7.629  -2.585  1.00 60.50           O  
ATOM     63  CB  ARG    22       4.576  -8.423  -4.962  1.00 62.52           C  
ATOM     64  CG  ARG    22       4.336  -7.596  -6.112  1.00 62.38           C  
ATOM     65  CD  ARG    22       2.862  -7.377  -6.307  1.00 63.37           C  
ATOM     66  NE  ARG    22       2.766  -6.247  -7.197  1.00 63.29           N  
ATOM     67  CZ  ARG    22       1.689  -5.863  -7.852  1.00 63.14           C  
ATOM     68  NH1 ARG    22       0.531  -6.515  -7.735  1.00 64.35           N  
ATOM     69  NH2 ARG    22       1.798  -4.807  -8.631  1.00 63.71           N  
ATOM     70  N   GLU    23       7.582  -6.874  -4.323  1.00 62.10           N  
ATOM     71  CA  GLU    23       8.103  -5.723  -3.602  1.00 62.33           C  
ATOM     72  C   GLU    23       6.970  -4.911  -2.955  1.00 62.52           C  
ATOM     73  O   GLU    23       7.045  -4.564  -1.781  1.00 63.44           O  
ATOM     74  CB  GLU    23       8.955  -4.850  -4.518  1.00 62.11           C  
ATOM     75  CG  GLU    23       9.910  -3.962  -3.752  1.00 63.73           C  
ATOM     76  CD  GLU    23      11.098  -3.492  -4.568  1.00 66.02           C  
ATOM     77  OE1 GLU    23      10.913  -3.119  -5.754  1.00 65.65           O  
ATOM     78  OE2 GLU    23      12.214  -3.482  -4.000  1.00 68.05           O  
ATOM     79  N   GLU    24       5.899  -4.665  -3.694  1.00 62.66           N  
ATOM     80  CA  GLU    24       4.773  -3.927  -3.141  1.00 63.27           C  
ATOM     81  C   GLU    24       4.077  -4.577  -1.938  1.00 63.16           C  
ATOM     82  O   GLU    24       3.586  -3.872  -1.053  1.00 63.14           O  
ATOM     83  CB  GLU    24       3.737  -3.650  -4.220  1.00 63.14           C  
ATOM     84  CG  GLU    24       4.183  -2.647  -5.259  1.00 65.00           C  
ATOM     85  CD  GLU    24       3.009  -2.112  -6.065  1.00 65.66           C  
ATOM     86  OE1 GLU    24       1.919  -2.735  -5.998  1.00 65.11           O  
ATOM     87  OE2 GLU    24       3.167  -1.071  -6.749  1.00 66.96           O  
ATOM     88  N   ASP    25       4.034  -5.902  -1.911  0.70 63.36           N  
ATOM     90  CA  ASP    25       3.305  -6.600  -0.868  0.70 63.79           C  
ATOM     92  C   ASP    25       4.028  -6.560   0.493  0.70 64.46           C  
ATOM     94  O   ASP    25       3.372  -6.638   1.542  0.70 64.77           O  
ATOM     96  CB  ASP    25       2.955  -8.031  -1.327  0.70 63.62           C  
ATOM     98  CG  ASP    25       1.892  -8.063  -2.468  0.70 63.86           C  
ATOM    100  OD1 ASP    25       1.400  -6.997  -2.932  0.70 61.48           O  
ATOM    102  OD2 ASP    25       1.538  -9.184  -2.900  0.70 64.42           O  
ATOM    104  N   ILE    26       5.358  -6.389   0.475  1.00 64.67           N  
ATOM    105  CA  ILE    26       6.187  -6.428   1.701  1.00 65.33           C  
ATOM    106  C   ILE    26       6.448  -5.038   2.254  1.00 66.28           C  
ATOM    107  O   ILE    26       6.715  -4.879   3.435  1.00 65.81           O  
ATOM    108  CB  ILE    26       7.568  -7.115   1.511  1.00 65.79           C  
ATOM    109  CG1 ILE    26       8.114  -7.590   2.873  1.00 65.49           C  
ATOM    110  CG2 ILE    26       8.578  -6.164   0.865  1.00 65.24           C  
ATOM    111  CD1 ILE    26       9.526  -8.114   2.841  1.00 64.46           C  
ATOM    112  N   ARG    27       6.376  -4.026   1.393  1.00 67.72           N  
ATOM    113  CA  ARG    27       6.661  -2.672   1.844  1.00 68.35           C  
ATOM    114  C   ARG    27       5.635  -2.232   2.887  1.00 68.20           C  
ATOM    115  O   ARG    27       6.004  -1.667   3.921  1.00 68.03           O  
ATOM    116  CB  ARG    27       6.823  -1.716   0.661  1.00 68.79           C  
ATOM    117  CG  ARG    27       8.136  -2.014  -0.065  1.00 70.71           C  
ATOM    118  CD  ARG    27       8.676  -0.888  -0.957  1.00 74.28           C  
ATOM    119  NE  ARG    27      10.113  -1.118  -1.136  1.00 76.73           N  
ATOM    120  CZ  ARG    27      10.900  -0.543  -2.046  1.00 77.51           C  
ATOM    121  NH1 ARG    27      10.418   0.335  -2.925  1.00 77.15           N  
ATOM    122  NH2 ARG    27      12.190  -0.862  -2.073  1.00 77.51           N  
ATOM    123  N   LYS    28       4.372  -2.577   2.641  1.00 68.05           N  
ATOM    124  CA  LYS    28       3.278  -2.331   3.573  1.00 67.84           C  
ATOM    125  C   LYS    28       3.515  -2.907   4.993  1.00 67.37           C  
ATOM    126  O   LYS    28       3.664  -2.148   5.957  1.00 67.14           O  
ATOM    127  CB  LYS    28       1.968  -2.845   2.957  1.00 68.52           C  
ATOM    128  CG  LYS    28       0.709  -2.558   3.781  1.00 69.95           C  
ATOM    129  CD  LYS    28      -0.479  -2.274   2.855  1.00 72.90           C  
ATOM    130  CE  LYS    28      -1.783  -2.048   3.625  1.00 74.32           C  
ATOM    131  NZ  LYS    28      -2.286  -3.344   4.158  1.00 76.24           N  
ATOM    132  N   SER    29       3.569  -4.235   5.119  1.00 66.72           N  
ATOM    133  CA  SER    29       3.748  -4.885   6.425  1.00 66.15           C  
ATOM    134  C   SER    29       5.187  -4.873   6.935  1.00 64.97           C  
ATOM    135  O   SER    29       5.459  -5.154   8.118  1.00 65.03           O  
ATOM    136  CB  SER    29       3.311  -6.336   6.336  1.00 66.89           C  
ATOM    137  OG  SER    29       4.355  -7.108   5.765  1.00 69.45           O  
ATOM    138  N   GLU    30       6.122  -4.606   6.034  1.00 62.79           N  
ATOM    139  CA  GLU    30       7.546  -4.652   6.367  1.00 60.91           C  
ATOM    140  C   GLU    30       8.128  -6.009   6.779  1.00 58.63           C  
ATOM    141  O   GLU    30       9.300  -6.064   7.176  1.00 57.90           O  
ATOM    142  CB  GLU    30       7.939  -3.541   7.349  1.00 61.73           C  
ATOM    143  CG  GLU    30       8.166  -2.226   6.596  1.00 64.11           C  
ATOM    144  CD  GLU    30       8.775  -1.124   7.442  1.00 68.01           C  
ATOM    145  OE1 GLU    30       8.252  -0.881   8.554  1.00 68.86           O  
ATOM    146  OE2 GLU    30       9.756  -0.484   6.970  1.00 69.07           O  
ATOM    147  N   ARG    31       7.333  -7.073   6.654  1.00 55.43           N  
ATOM    148  CA  ARG    31       7.814  -8.461   6.773  1.00 54.94           C  
ATOM    149  C   ARG    31       6.873  -9.468   6.122  1.00 55.34           C  
ATOM    150  O   ARG    31       5.669  -9.251   6.054  1.00 53.56           O  
ATOM    151  CB  ARG    31       8.017  -8.868   8.213  1.00 53.83           C  
ATOM    152  CG  ARG    31       6.689  -9.135   8.913  1.00 56.18           C  
ATOM    153  CD  ARG    31       6.870  -9.241  10.351  1.00 54.41           C  
ATOM    154  NE  ARG    31       7.484  -8.051  10.931  1.00 47.57           N  
ATOM    155  CZ  ARG    31       7.953  -8.038  12.168  1.00 43.51           C  
ATOM    156  NH1 ARG    31       7.864  -9.153  12.893  1.00 42.00           N  
ATOM    157  NH2 ARG    31       8.477  -6.939  12.679  1.00 40.05           N  
ATOM    158  N   MET    32       7.432 -10.587   5.679  1.00 57.33           N  
ATOM    159  CA  MET    32       6.647 -11.708   5.128  1.00 60.41           C  
ATOM    160  C   MET    32       7.435 -12.995   5.296  1.00 59.05           C  
ATOM    161  O   MET    32       8.664 -12.974   5.342  1.00 60.30           O  
ATOM    162  CB  MET    32       6.358 -11.492   3.619  1.00 59.37           C  
ATOM    163  CG  MET    32       7.571 -11.596   2.693  1.00 63.82           C  
ATOM    164  SD  MET    32       7.112 -11.204   0.978  1.00 69.27           S  
ATOM    165  CE  MET    32       5.647 -10.216   1.194  1.00 68.77           C  
ATOM    166  N   THR    33       6.752 -14.125   5.326  1.00 57.39           N  
ATOM    167  CA  THR    33       7.468 -15.385   5.383  1.00 55.82           C  
ATOM    168  C   THR    33       7.420 -16.058   3.993  1.00 56.31           C  
ATOM    169  O   THR    33       6.532 -15.751   3.131  1.00 54.99           O  
ATOM    170  CB  THR    33       6.882 -16.321   6.457  1.00 56.65           C  
ATOM    171  OG1 THR    33       5.603 -16.815   5.987  1.00 56.10           O  
ATOM    172  CG2 THR    33       6.697 -15.553   7.836  1.00 55.74           C  
ATOM    173  N   ALA    34       8.335 -16.989   3.761  1.00 54.34           N  
ATOM    174  CA  ALA    34       8.184 -17.826   2.570  1.00 54.83           C  
ATOM    175  C   ALA    34       8.807 -19.181   2.790  1.00 53.98           C  
ATOM    176  O   ALA    34       9.635 -19.352   3.681  1.00 53.23           O  
ATOM    177  CB  ALA    34       8.816 -17.148   1.365  1.00 55.64           C  
ATOM    178  N   VAL    35       8.422 -20.150   1.969  1.00 52.71           N  
ATOM    179  CA  VAL    35       9.146 -21.419   1.963  1.00 51.53           C  
ATOM    180  C   VAL    35      10.059 -21.440   0.736  1.00 50.48           C  
ATOM    181  O   VAL    35       9.597 -21.267  -0.405  1.00 50.86           O  
ATOM    182  CB  VAL    35       8.199 -22.656   2.139  1.00 51.55           C  
ATOM    183  CG1 VAL    35       8.927 -23.938   1.867  1.00 51.62           C  
ATOM    184  CG2 VAL    35       7.649 -22.678   3.595  1.00 51.89           C  
ATOM    185  N   VAL    36      11.358 -21.607   0.993  1.00 47.93           N  
ATOM    186  CA  VAL    36      12.369 -21.552  -0.052  1.00 46.54           C  
ATOM    187  C   VAL    36      13.108 -22.885  -0.044  1.00 46.09           C  
ATOM    188  O   VAL    36      13.795 -23.191   0.917  1.00 45.92           O  
ATOM    189  CB  VAL    36      13.329 -20.352   0.148  1.00 46.45           C  
ATOM    190  CG1 VAL    36      14.517 -20.414  -0.842  1.00 45.45           C  
ATOM    191  CG2 VAL    36      12.561 -19.045  -0.018  1.00 43.17           C  
ATOM    192  N   HIS    37      12.900 -23.698  -1.086  1.00 45.65           N  
ATOM    193  CA  HIS    37      13.449 -25.056  -1.162  1.00 45.17           C  
ATOM    194  C   HIS    37      13.275 -25.825   0.164  1.00 45.04           C  
ATOM    195  O   HIS    37      14.256 -26.313   0.741  1.00 45.28           O  
ATOM    196  CB  HIS    37      14.941 -25.015  -1.540  1.00 45.31           C  
ATOM    197  CG  HIS    37      15.243 -24.292  -2.824  1.00 45.88           C  
ATOM    198  ND1 HIS    37      14.568 -24.534  -4.004  1.00 46.39           N  
ATOM    199  CD2 HIS    37      16.190 -23.367  -3.117  1.00 46.19           C  
ATOM    200  CE1 HIS    37      15.074 -23.775  -4.962  1.00 46.61           C  
ATOM    201  NE2 HIS    37      16.058 -23.055  -4.449  1.00 45.87           N  
ATOM    202  N   ASP    38      12.041 -25.892   0.661  1.00 44.85           N  
ATOM    203  CA  ASP    38      11.706 -26.553   1.941  1.00 45.31           C  
ATOM    204  C   ASP    38      12.339 -25.925   3.206  1.00 45.08           C  
ATOM    205  O   ASP    38      12.315 -26.535   4.284  1.00 45.02           O  
ATOM    206  CB  ASP    38      12.026 -28.055   1.910  1.00 45.77           C  
ATOM    207  CG  ASP    38      11.383 -28.776   0.726  1.00 49.13           C  
ATOM    208  OD1 ASP    38      10.128 -28.791   0.650  1.00 51.40           O  
ATOM    209  OD2 ASP    38      12.135 -29.334  -0.124  1.00 51.32           O  
ATOM    210  N   ARG    39      12.917 -24.729   3.081  1.00 43.95           N  
ATOM    211  CA  ARG    39      13.413 -24.021   4.257  1.00 43.30           C  
ATOM    212  C   ARG    39      12.521 -22.812   4.452  1.00 42.56           C  
ATOM    213  O   ARG    39      12.335 -22.011   3.534  1.00 42.90           O  
ATOM    214  CB  ARG    39      14.865 -23.605   4.108  1.00 43.37           C  
ATOM    215  CG  ARG    39      15.608 -23.594   5.429  1.00 43.77           C  
ATOM    216  CD  ARG    39      17.029 -23.142   5.261  1.00 45.03           C  
ATOM    217  NE  ARG    39      17.674 -23.029   6.560  1.00 45.90           N  
ATOM    218  CZ  ARG    39      18.700 -23.769   6.945  1.00 43.80           C  
ATOM    219  NH1 ARG    39      19.211 -24.648   6.103  1.00 43.43           N  
ATOM    220  NH2 ARG    39      19.216 -23.604   8.157  1.00 40.35           N  
ATOM    221  N   GLU    40      11.915 -22.727   5.625  1.00 41.87           N  
ATOM    222  CA  GLU    40      11.019 -21.619   5.932  1.00 40.70           C  
ATOM    223  C   GLU    40      11.814 -20.418   6.451  1.00 40.21           C  
ATOM    224  O   GLU    40      12.671 -20.553   7.321  1.00 39.91           O  
ATOM    225  CB  GLU    40       9.926 -22.041   6.911  1.00 41.02           C  
ATOM    226  CG  GLU    40       8.775 -21.074   6.870  1.00 41.02           C  
ATOM    227  CD  GLU    40       7.670 -21.402   7.819  1.00 45.48           C  
ATOM    228  OE1 GLU    40       7.862 -22.213   8.771  1.00 46.20           O  
ATOM    229  OE2 GLU    40       6.581 -20.845   7.575  1.00 44.48           O  
ATOM    230  N   VAL    41      11.578 -19.259   5.838  1.00 39.09           N  
ATOM    231  CA  VAL    41      12.354 -18.057   6.115  1.00 37.88           C  
ATOM    232  C   VAL    41      11.436 -16.887   6.414  1.00 37.27           C  
ATOM    233  O   VAL    41      10.267 -16.869   6.008  1.00 36.57           O  
ATOM    234  CB  VAL    41      13.326 -17.655   4.896  1.00 37.87           C  
ATOM    235  CG1 VAL    41      14.182 -18.804   4.466  1.00 36.47           C  
ATOM    236  CG2 VAL    41      12.531 -17.210   3.656  1.00 38.60           C  
ATOM    237  N   VAL    42      11.998 -15.867   7.049  1.00 36.63           N  
ATOM    238  CA  VAL    42      11.308 -14.631   7.203  1.00 35.76           C  
ATOM    239  C   VAL    42      12.103 -13.576   6.456  1.00 36.42           C  
ATOM    240  O   VAL    42      13.302 -13.561   6.538  1.00 34.56           O  
ATOM    241  CB  VAL    42      11.050 -14.279   8.729  1.00 36.00           C  
ATOM    242  CG1 VAL    42      12.356 -14.284   9.550  1.00 31.47           C  
ATOM    243  CG2 VAL    42      10.244 -12.935   8.858  1.00 36.12           C  
ATOM    244  N   ILE    43      11.423 -12.711   5.705  1.00 36.07           N  
ATOM    245  CA  ILE    43      12.088 -11.573   5.057  1.00 35.72           C  
ATOM    246  C   ILE    43      11.611 -10.312   5.753  1.00 35.08           C  
ATOM    247  O   ILE    43      10.425 -10.130   5.901  1.00 34.92           O  
ATOM    248  CB  ILE    43      11.748 -11.420   3.540  1.00 36.04           C  
ATOM    249  CG1 ILE    43      12.131 -12.678   2.760  1.00 38.38           C  
ATOM    250  CG2 ILE    43      12.503 -10.221   2.900  1.00 35.84           C  
ATOM    251  CD1 ILE    43      10.953 -13.665   2.645  1.00 41.98           C  
ATOM    252  N   PHE    44      12.540  -9.455   6.170  1.00 35.27           N  
ATOM    253  CA  PHE    44      12.207  -8.159   6.750  1.00 35.90           C  
ATOM    254  C   PHE    44      12.611  -7.070   5.764  1.00 36.03           C  
ATOM    255  O   PHE    44      13.695  -7.104   5.206  1.00 36.06           O  
ATOM    256  CB  PHE    44      12.996  -7.939   8.051  1.00 35.55           C  
ATOM    257  CG  PHE    44      12.675  -8.944   9.149  1.00 35.15           C  
ATOM    258  CD1 PHE    44      11.461  -8.863   9.856  1.00 33.52           C  
ATOM    259  CD2 PHE    44      13.555  -9.953   9.456  1.00 35.10           C  
ATOM    260  CE1 PHE    44      11.145  -9.775  10.840  1.00 31.22           C  
ATOM    261  CE2 PHE    44      13.260 -10.834  10.490  1.00 33.69           C  
ATOM    262  CZ  PHE    44      12.043 -10.747  11.155  1.00 34.12           C  
ATOM    263  N   TYR    45      11.744  -6.094   5.576  1.00 36.13           N  
ATOM    264  CA  TYR    45      12.120  -4.861   4.896  1.00 37.49           C  
ATOM    265  C   TYR    45      12.253  -3.757   5.917  1.00 37.07           C  
ATOM    266  O   TYR    45      11.271  -3.380   6.534  1.00 38.99           O  
ATOM    267  CB  TYR    45      11.055  -4.484   3.898  1.00 36.98           C  
ATOM    268  CG  TYR    45      11.334  -3.182   3.158  1.00 39.78           C  
ATOM    269  CD1 TYR    45      12.338  -3.109   2.209  1.00 40.79           C  
ATOM    270  CD2 TYR    45      10.595  -2.037   3.421  1.00 38.05           C  
ATOM    271  CE1 TYR    45      12.605  -1.935   1.531  1.00 41.88           C  
ATOM    272  CE2 TYR    45      10.858  -0.857   2.763  1.00 41.50           C  
ATOM    273  CZ  TYR    45      11.862  -0.805   1.807  1.00 40.93           C  
ATOM    274  OH  TYR    45      12.120   0.387   1.114  1.00 40.29           O  
ATOM    275  N   HIS    46      13.443  -3.229   6.111  1.00 36.34           N  
ATOM    276  CA  HIS    46      13.652  -2.224   7.156  1.00 36.95           C  
ATOM    277  C   HIS    46      14.640  -1.131   6.693  1.00 37.04           C  
ATOM    278  O   HIS    46      15.718  -1.438   6.160  1.00 36.11           O  
ATOM    279  CB  HIS    46      14.162  -2.927   8.432  1.00 37.03           C  
ATOM    280  CG  HIS    46      14.389  -2.016   9.605  1.00 38.48           C  
ATOM    281  ND1 HIS    46      13.356  -1.460  10.337  1.00 40.30           N  
ATOM    282  CD2 HIS    46      15.530  -1.603  10.200  1.00 36.98           C  
ATOM    283  CE1 HIS    46      13.855  -0.725  11.315  1.00 38.56           C  
ATOM    284  NE2 HIS    46      15.171  -0.791  11.249  1.00 38.82           N  
ATOM    285  N   LYS    47      14.275   0.138   6.920  1.00 36.95           N  
ATOM    286  CA  LYS    47      15.099   1.269   6.525  1.00 37.47           C  
ATOM    287  C   LYS    47      15.604   1.065   5.095  1.00 37.40           C  
ATOM    288  O   LYS    47      16.817   1.170   4.821  1.00 36.64           O  
ATOM    289  CB  LYS    47      16.293   1.452   7.465  1.00 38.17           C  
ATOM    290  CG  LYS    47      15.974   1.813   8.904  1.00 40.46           C  
ATOM    291  CD  LYS    47      17.211   2.484   9.503  1.00 45.27           C  
ATOM    292  CE  LYS    47      17.181   2.580  11.022  1.00 47.38           C  
ATOM    293  NZ  LYS    47      17.861   1.421  11.685  1.00 50.94           N  
ATOM    294  N   GLY    48      14.674   0.731   4.194  1.00 37.40           N  
ATOM    295  CA  GLY    48      15.000   0.560   2.776  1.00 37.40           C  
ATOM    296  C   GLY    48      15.856  -0.636   2.402  1.00 37.80           C  
ATOM    297  O   GLY    48      16.304  -0.738   1.278  1.00 38.04           O  
ATOM    298  N   GLU    49      16.085  -1.556   3.336  1.00 38.38           N  
ATOM    299  CA  GLU    49      16.829  -2.797   3.029  1.00 38.96           C  
ATOM    300  C   GLU    49      16.071  -4.079   3.366  1.00 37.40           C  
ATOM    301  O   GLU    49      15.276  -4.102   4.272  1.00 37.65           O  
ATOM    302  CB  GLU    49      18.154  -2.817   3.788  1.00 38.83           C  
ATOM    303  CG  GLU    49      18.937  -1.583   3.524  1.00 43.50           C  
ATOM    304  CD  GLU    49      20.402  -1.850   3.556  1.00 48.39           C  
ATOM    305  OE1 GLU    49      20.835  -2.546   4.503  1.00 49.17           O  
ATOM    306  OE2 GLU    49      21.094  -1.373   2.622  1.00 51.30           O  
ATOM    307  N   TYR    50      16.403  -5.145   2.652  1.00 37.51           N  
ATOM    308  CA  TYR    50      15.783  -6.447   2.770  1.00 37.42           C  
ATOM    309  C   TYR    50      16.698  -7.402   3.513  1.00 37.93           C  
ATOM    310  O   TYR    50      17.897  -7.407   3.283  1.00 36.23           O  
ATOM    311  CB  TYR    50      15.475  -6.971   1.367  1.00 38.36           C  
ATOM    312  CG  TYR    50      14.401  -6.171   0.692  1.00 38.71           C  
ATOM    313  CD1 TYR    50      13.052  -6.451   0.947  1.00 41.30           C  
ATOM    314  CD2 TYR    50      14.714  -5.109  -0.176  1.00 39.45           C  
ATOM    315  CE1 TYR    50      12.043  -5.728   0.367  1.00 39.50           C  
ATOM    316  CE2 TYR    50      13.689  -4.361  -0.778  1.00 41.37           C  
ATOM    317  CZ  TYR    50      12.347  -4.688  -0.495  1.00 41.85           C  
ATOM    318  OH  TYR    50      11.300  -3.995  -1.058  1.00 39.83           O  
ATOM    319  N   HIS    51      16.156  -8.162   4.451  1.00 37.00           N  
ATOM    320  CA  HIS    51      16.962  -9.128   5.154  1.00 37.66           C  
ATOM    321  C   HIS    51      16.187 -10.409   5.256  1.00 38.22           C  
ATOM    322  O   HIS    51      15.034 -10.396   5.749  1.00 40.63           O  
ATOM    323  CB  HIS    51      17.362  -8.635   6.576  1.00 38.17           C  
ATOM    324  CG  HIS    51      17.992  -7.280   6.598  1.00 36.35           C  
ATOM    325  ND1 HIS    51      19.324  -7.072   6.311  1.00 36.15           N  
ATOM    326  CD2 HIS    51      17.462  -6.060   6.834  1.00 36.39           C  
ATOM    327  CE1 HIS    51      19.587  -5.780   6.377  1.00 36.16           C  
ATOM    328  NE2 HIS    51      18.475  -5.144   6.699  1.00 36.78           N  
ATOM    329  N   ALA    52      16.783 -11.510   4.813  1.00 36.23           N  
ATOM    330  CA  ALA    52      16.191 -12.852   4.974  1.00 35.83           C  
ATOM    331  C   ALA    52      16.956 -13.725   5.994  1.00 35.84           C  
ATOM    332  O   ALA    52      18.162 -13.772   5.971  1.00 35.96           O  
ATOM    333  CB  ALA    52      16.112 -13.564   3.635  1.00 34.44           C  
ATOM    334  N   MET    53      16.230 -14.425   6.860  1.00 35.98           N  
ATOM    335  CA  MET    53      16.856 -15.383   7.786  1.00 35.97           C  
ATOM    336  C   MET    53      15.895 -16.513   8.097  1.00 34.34           C  
ATOM    337  O   MET    53      14.698 -16.423   7.816  1.00 34.06           O  
ATOM    338  CB  MET    53      17.275 -14.682   9.102  1.00 34.38           C  
ATOM    339  CG  MET    53      16.059 -14.042   9.793  1.00 36.38           C  
ATOM    340  SD  MET    53      16.365 -13.290  11.396  1.00 37.83           S  
ATOM    341  CE  MET    53      17.224 -11.779  10.901  1.00 31.98           C  
ATOM    342  N   ASP    54      16.437 -17.570   8.692  1.00 35.49           N  
ATOM    343  CA  ASP    54      15.663 -18.709   9.166  1.00 35.03           C  
ATOM    344  C   ASP    54      14.594 -18.178  10.077  1.00 35.41           C  
ATOM    345  O   ASP    54      14.838 -17.266  10.883  1.00 36.46           O  
ATOM    346  CB  ASP    54      16.555 -19.680   9.974  1.00 36.35           C  
ATOM    347  CG  ASP    54      17.394 -20.595   9.089  1.00 37.52           C  
ATOM    348  OD1 ASP    54      17.092 -20.730   7.865  1.00 42.19           O  
ATOM    349  OD2 ASP    54      18.379 -21.187   9.608  1.00 36.00           O  
ATOM    350  N   ILE    55      13.400 -18.736   9.977  1.00 33.76           N  
ATOM    351  CA  ILE    55      12.271 -18.163  10.687  1.00 33.72           C  
ATOM    352  C   ILE    55      12.256 -18.488  12.189  1.00 34.09           C  
ATOM    353  O   ILE    55      11.846 -17.651  12.987  1.00 35.22           O  
ATOM    354  CB  ILE    55      10.909 -18.575  10.023  1.00 32.75           C  
ATOM    355  CG1 ILE    55       9.729 -17.838  10.671  1.00 34.08           C  
ATOM    356  CG2 ILE    55      10.649 -20.098  10.162  1.00 32.55           C  
ATOM    357  CD1 ILE    55       8.426 -17.928   9.803  1.00 33.04           C  
ATOM    358  N   ARG    56      12.676 -19.701  12.554  1.00 34.32           N  
ATOM    359  CA  ARG    56      12.678 -20.122  13.949  0.50 34.27           C  
ATOM    361  C   ARG    56      13.979 -19.728  14.679  1.00 35.02           C  
ATOM    362  O   ARG    56      15.105 -19.999  14.216  1.00 34.05           O  
ATOM    363  CB  ARG    56      12.392 -21.611  14.064  0.50 33.71           C  
ATOM    365  CG  ARG    56      11.174 -22.056  13.253  0.50 33.20           C  
ATOM    367  CD  ARG    56       9.863 -21.458  13.767  0.50 34.41           C  
ATOM    369  NE  ARG    56       8.811 -21.580  12.749  0.50 33.94           N  
ATOM    371  CZ  ARG    56       7.540 -21.219  12.904  0.50 33.39           C  
ATOM    373  NH1 ARG    56       7.124 -20.701  14.053  0.50 33.15           N  
ATOM    375  NH2 ARG    56       6.684 -21.388  11.901  0.50 30.53           N  
ATOM    377  N   CYS    57      13.782 -19.059  15.804  1.00 34.89           N  
ATOM    378  CA  CYS    57      14.857 -18.517  16.622  1.00 34.84           C  
ATOM    379  C   CYS    57      15.820 -19.605  17.046  1.00 35.33           C  
ATOM    380  O   CYS    57      15.405 -20.619  17.585  1.00 34.76           O  
ATOM    381  CB  CYS    57      14.258 -17.828  17.853  1.00 35.43           C  
ATOM    382  SG  CYS    57      15.469 -17.137  18.937  1.00 35.67           S  
ATOM    383  N   TYR    58      17.109 -19.375  16.835  1.00 33.56           N  
ATOM    384  CA  TYR    58      18.141 -20.335  17.256  1.00 34.44           C  
ATOM    385  C   TYR    58      18.123 -20.742  18.712  1.00 34.87           C  
ATOM    386  O   TYR    58      18.677 -21.797  19.032  1.00 35.22           O  
ATOM    387  CB  TYR    58      19.564 -19.805  16.955  1.00 32.35           C  
ATOM    388  CG  TYR    58      20.078 -18.730  17.956  1.00 32.86           C  
ATOM    389  CD1 TYR    58      19.791 -17.386  17.764  1.00 32.31           C  
ATOM    390  CD2 TYR    58      20.892 -19.078  19.025  1.00 26.69           C  
ATOM    391  CE1 TYR    58      20.280 -16.385  18.653  1.00 36.22           C  
ATOM    392  CE2 TYR    58      21.337 -18.112  19.962  1.00 32.60           C  
ATOM    393  CZ  TYR    58      21.100 -16.767  19.710  1.00 32.41           C  
ATOM    394  OH  TYR    58      21.552 -15.812  20.596  1.00 35.59           O  
ATOM    395  N   HIS    59      17.583 -19.901  19.596  1.00 34.43           N  
ATOM    396  CA  HIS    59      17.668 -20.152  21.034  1.00 33.97           C  
ATOM    397  C   HIS    59      16.815 -21.395  21.360  1.00 34.28           C  
ATOM    398  O   HIS    59      17.331 -22.404  21.833  1.00 33.47           O  
ATOM    399  CB  HIS    59      17.194 -18.912  21.838  1.00 34.01           C  
ATOM    400  CG  HIS    59      17.046 -19.170  23.316  1.00 31.90           C  
ATOM    401  ND1 HIS    59      15.913 -18.854  24.030  1.00 32.75           N  
ATOM    402  CD2 HIS    59      17.922 -19.688  24.212  1.00 31.88           C  
ATOM    403  CE1 HIS    59      16.070 -19.221  25.292  1.00 36.93           C  
ATOM    404  NE2 HIS    59      17.286 -19.723  25.432  1.00 36.41           N  
ATOM    405  N   SER    60      15.504 -21.309  21.140  1.00 34.09           N  
ATOM    406  CA  SER    60      14.580 -22.404  21.464  1.00 35.56           C  
ATOM    407  C   SER    60      13.520 -22.620  20.402  1.00 35.00           C  
ATOM    408  O   SER    60      12.473 -23.273  20.676  1.00 34.15           O  
ATOM    409  CB  SER    60      13.793 -22.101  22.766  1.00 35.66           C  
ATOM    410  OG  SER    60      14.529 -22.465  23.868  1.00 40.94           O  
ATOM    411  N   GLY    61      13.725 -22.050  19.227  1.00 33.78           N  
ATOM    412  CA  GLY    61      12.734 -22.180  18.151  1.00 33.83           C  
ATOM    413  C   GLY    61      11.537 -21.216  18.082  1.00 33.58           C  
ATOM    414  O   GLY    61      10.581 -21.489  17.382  1.00 33.89           O  
ATOM    415  N   GLY    62      11.592 -20.060  18.752  1.00 34.29           N  
ATOM    416  CA  GLY    62      10.503 -19.064  18.703  1.00 33.30           C  
ATOM    417  C   GLY    62      10.292 -18.403  17.339  1.00 34.18           C  
ATOM    418  O   GLY    62      11.131 -18.485  16.449  1.00 34.46           O  
ATOM    419  N   PRO    63       9.131 -17.779  17.156  1.00 34.28           N  
ATOM    420  CA  PRO    63       8.647 -17.233  15.855  1.00 34.13           C  
ATOM    421  C   PRO    63       9.249 -15.820  15.609  1.00 35.32           C  
ATOM    422  O   PRO    63       8.683 -14.844  16.083  1.00 35.94           O  
ATOM    423  CB  PRO    63       7.098 -17.165  16.070  1.00 34.92           C  
ATOM    424  CG  PRO    63       6.909 -17.071  17.597  1.00 34.02           C  
ATOM    425  CD  PRO    63       8.162 -17.613  18.267  1.00 32.77           C  
ATOM    426  N   LEU    64      10.409 -15.724  14.939  1.00 33.85           N  
ATOM    427  CA  LEU    64      11.035 -14.426  14.722  1.00 35.10           C  
ATOM    428  C   LEU    64      10.190 -13.455  13.888  1.00 35.51           C  
ATOM    429  O   LEU    64      10.282 -12.231  14.090  1.00 35.60           O  
ATOM    430  CB  LEU    64      12.420 -14.584  14.076  1.00 33.19           C  
ATOM    431  CG  LEU    64      13.471 -15.228  14.956  1.00 33.67           C  
ATOM    432  CD1 LEU    64      14.780 -15.303  14.169  1.00 31.32           C  
ATOM    433  CD2 LEU    64      13.683 -14.567  16.368  1.00 32.77           C  
ATOM    434  N   HIS    65       9.310 -14.009  13.014  1.00 36.13           N  
ATOM    435  CA  HIS    65       8.382 -13.207  12.206  1.00 35.49           C  
ATOM    436  C   HIS    65       7.333 -12.496  13.062  1.00 36.08           C  
ATOM    437  O   HIS    65       6.658 -11.607  12.549  1.00 36.02           O  
ATOM    438  CB  HIS    65       7.719 -14.047  11.080  1.00 34.87           C  
ATOM    439  CG  HIS    65       6.740 -15.075  11.579  1.00 34.80           C  
ATOM    440  ND1 HIS    65       7.104 -16.108  12.425  1.00 32.82           N  
ATOM    441  CD2 HIS    65       5.425 -15.270  11.294  1.00 35.42           C  
ATOM    442  CE1 HIS    65       6.030 -16.818  12.735  1.00 35.35           C  
ATOM    443  NE2 HIS    65       5.003 -16.349  12.044  1.00 34.51           N  
ATOM    444  N   LEU    66       7.226 -12.856  14.351  1.00 35.16           N  
ATOM    445  CA  LEU    66       6.321 -12.166  15.276  1.00 34.56           C  
ATOM    446  C   LEU    66       7.126 -11.259  16.209  1.00 34.99           C  
ATOM    447  O   LEU    66       6.571 -10.695  17.130  1.00 34.13           O  
ATOM    448  CB  LEU    66       5.499 -13.148  16.118  1.00 35.06           C  
ATOM    449  CG  LEU    66       4.672 -14.209  15.366  1.00 36.17           C  
ATOM    450  CD1 LEU    66       3.790 -14.925  16.316  1.00 36.21           C  
ATOM    451  CD2 LEU    66       3.919 -13.613  14.176  1.00 33.70           C  
ATOM    452  N   GLY    67       8.431 -11.107  15.993  1.00 32.27           N  
ATOM    453  CA  GLY    67       9.167 -10.210  16.887  1.00 33.66           C  
ATOM    454  C   GLY    67       9.179  -8.750  16.492  1.00 34.02           C  
ATOM    455  O   GLY    67       8.704  -8.397  15.403  1.00 34.86           O  
ATOM    456  N   GLU    68       9.706  -7.884  17.364  1.00 34.92           N  
ATOM    457  CA  GLU    68       9.815  -6.470  17.032  0.50 34.77           C  
ATOM    459  C   GLU    68      11.234  -6.174  16.546  1.00 36.04           C  
ATOM    460  O   GLU    68      12.222  -6.826  16.990  1.00 34.69           O  
ATOM    461  CB  GLU    68       9.482  -5.582  18.246  0.50 34.98           C  
ATOM    463  CG  GLU    68       8.148  -5.870  18.980  0.50 33.52           C  
ATOM    465  CD  GLU    68       6.963  -5.201  18.371  0.50 31.29           C  
ATOM    467  OE1 GLU    68       6.995  -4.840  17.191  0.50 32.99           O  
ATOM    469  OE2 GLU    68       5.968  -5.014  19.089  0.50 35.61           O  
ATOM    471  N   ILE    69      11.358  -5.184  15.662  1.00 36.24           N  
ATOM    472  CA  ILE    69      12.690  -4.749  15.196  1.00 39.01           C  
ATOM    473  C   ILE    69      13.122  -3.516  16.002  1.00 40.20           C  
ATOM    474  O   ILE    69      12.326  -2.588  16.158  1.00 38.19           O  
ATOM    475  CB  ILE    69      12.670  -4.427  13.673  1.00 39.84           C  
ATOM    476  CG1 ILE    69      12.411  -5.733  12.873  1.00 41.79           C  
ATOM    477  CG2 ILE    69      14.002  -3.705  13.233  1.00 39.07           C  
ATOM    478  CD1 ILE    69      12.138  -5.498  11.381  1.00 39.19           C  
ATOM    479  N   GLU    70      14.336  -3.532  16.564  1.00 40.88           N  
ATOM    480  CA  GLU    70      14.914  -2.358  17.235  1.00 44.15           C  
ATOM    481  C   GLU    70      16.417  -2.296  17.027  1.00 42.63           C  
ATOM    482  O   GLU    70      17.083  -3.326  16.854  1.00 40.70           O  
ATOM    483  CB  GLU    70      14.727  -2.352  18.758  1.00 44.02           C  
ATOM    484  CG  GLU    70      13.479  -2.956  19.319  1.00 49.17           C  
ATOM    485  CD  GLU    70      13.403  -2.778  20.857  1.00 50.66           C  
ATOM    486  OE1 GLU    70      13.816  -1.656  21.361  1.00 57.14           O  
ATOM    487  OE2 GLU    70      12.923  -3.748  21.533  1.00 53.10           O  
ATOM    488  N   ASP    71      16.941  -1.081  17.146  1.00 42.60           N  
ATOM    489  CA  ASP    71      18.382  -0.850  17.089  1.00 43.31           C  
ATOM    490  C   ASP    71      19.025  -1.001  18.446  1.00 43.56           C  
ATOM    491  O   ASP    71      18.527  -0.452  19.446  1.00 44.12           O  
ATOM    492  CB  ASP    71      18.695   0.530  16.502  1.00 43.80           C  
ATOM    493  CG  ASP    71      18.390   0.615  15.022  1.00 45.66           C  
ATOM    494  OD1 ASP    71      17.523  -0.130  14.518  1.00 46.85           O  
ATOM    495  OD2 ASP    71      19.031   1.442  14.340  1.00 50.54           O  
ATOM    496  N   PHE    72      20.119  -1.763  18.480  1.00 42.87           N  
ATOM    497  CA  PHE    72      20.968  -1.887  19.651  1.00 42.59           C  
ATOM    498  C   PHE    72      22.398  -1.763  19.142  1.00 42.61           C  
ATOM    499  O   PHE    72      22.744  -2.358  18.120  1.00 41.94           O  
ATOM    500  CB  PHE    72      20.781  -3.235  20.371  1.00 43.24           C  
ATOM    501  CG  PHE    72      19.348  -3.523  20.793  1.00 45.32           C  
ATOM    502  CD1 PHE    72      18.843  -3.025  21.994  1.00 47.35           C  
ATOM    503  CD2 PHE    72      18.501  -4.280  19.983  1.00 44.73           C  
ATOM    504  CE1 PHE    72      17.503  -3.279  22.376  1.00 48.24           C  
ATOM    505  CE2 PHE    72      17.168  -4.525  20.359  1.00 39.75           C  
ATOM    506  CZ  PHE    72      16.683  -4.035  21.549  1.00 45.38           C  
ATOM    507  N   ASN    73      23.206  -0.973  19.850  1.00 43.10           N  
ATOM    508  CA  ASN    73      24.606  -0.660  19.467  1.00 43.65           C  
ATOM    509  C   ASN    73      24.686  -0.152  18.023  1.00 43.70           C  
ATOM    510  O   ASN    73      25.601  -0.496  17.283  1.00 43.14           O  
ATOM    511  CB  ASN    73      25.513  -1.889  19.657  1.00 43.42           C  
ATOM    512  CG  ASN    73      27.003  -1.519  19.856  1.00 46.43           C  
ATOM    513  OD1 ASN    73      27.353  -0.367  20.187  1.00 43.42           O  
ATOM    514  ND2 ASN    73      27.889  -2.518  19.667  1.00 48.36           N  
ATOM    515  N   GLY    74      23.677   0.609  17.606  1.00 44.40           N  
ATOM    516  CA  GLY    74      23.611   1.082  16.214  1.00 44.51           C  
ATOM    517  C   GLY    74      23.381   0.008  15.147  1.00 44.46           C  
ATOM    518  O   GLY    74      23.531   0.291  13.971  1.00 44.76           O  
ATOM    519  N   GLN    75      23.016  -1.212  15.556  1.00 43.78           N  
ATOM    520  CA  GLN    75      22.635  -2.297  14.632  1.00 42.82           C  
ATOM    521  C   GLN    75      21.157  -2.669  14.762  1.00 40.89           C  
ATOM    522  O   GLN    75      20.649  -2.890  15.865  1.00 40.71           O  
ATOM    523  CB  GLN    75      23.479  -3.545  14.896  1.00 42.81           C  
ATOM    524  CG  GLN    75      24.968  -3.400  14.622  1.00 46.95           C  
ATOM    525  CD  GLN    75      25.797  -4.451  15.386  1.00 50.89           C  
ATOM    526  OE1 GLN    75      26.011  -4.339  16.595  1.00 52.08           O  
ATOM    527  NE2 GLN    75      26.257  -5.474  14.673  1.00 51.59           N  
ATOM    528  N   SER    76      20.470  -2.740  13.621  1.00 39.88           N  
ATOM    529  CA  SER    76      19.081  -3.185  13.538  1.00 38.27           C  
ATOM    530  C   SER    76      18.980  -4.683  13.879  1.00 36.85           C  
ATOM    531  O   SER    76      19.722  -5.479  13.320  1.00 36.22           O  
ATOM    532  CB  SER    76      18.554  -2.935  12.130  1.00 38.31           C  
ATOM    533  OG  SER    76      18.478  -1.527  11.875  1.00 43.22           O  
ATOM    534  N   CYS    77      18.072  -5.043  14.789  1.00 35.33           N  
ATOM    535  CA  CYS    77      17.930  -6.402  15.313  1.00 34.59           C  
ATOM    536  C   CYS    77      16.462  -6.789  15.272  1.00 35.71           C  
ATOM    537  O   CYS    77      15.620  -5.957  15.526  1.00 35.64           O  
ATOM    538  CB  CYS    77      18.356  -6.451  16.776  1.00 33.34           C  
ATOM    539  SG  CYS    77      20.163  -6.333  16.976  1.00 35.65           S  
ATOM    540  N   ILE    78      16.190  -8.059  15.007  1.00 34.76           N  
ATOM    541  CA  ILE    78      14.973  -8.688  15.377  1.00 34.18           C  
ATOM    542  C   ILE    78      15.061  -9.169  16.864  1.00 34.62           C  
ATOM    543  O   ILE    78      16.054  -9.721  17.287  1.00 34.47           O  
ATOM    544  CB  ILE    78      14.535  -9.826  14.318  1.00 33.81           C  
ATOM    545  CG1 ILE    78      13.138 -10.355  14.634  1.00 32.87           C  
ATOM    546  CG2 ILE    78      15.569 -10.982  14.211  1.00 31.11           C  
ATOM    547  CD1 ILE    78      12.031  -9.303  14.448  1.00 29.85           C  
ATOM    548  N   VAL    79      14.017  -8.921  17.655  1.00 32.69           N  
ATOM    549  CA  VAL    79      13.972  -9.370  19.046  1.00 33.62           C  
ATOM    550  C   VAL    79      12.967 -10.495  19.058  1.00 33.60           C  
ATOM    551  O   VAL    79      11.792 -10.239  18.739  1.00 33.36           O  
ATOM    552  CB  VAL    79      13.518  -8.218  19.996  1.00 34.49           C  
ATOM    553  CG1 VAL    79      13.462  -8.703  21.467  1.00 35.62           C  
ATOM    554  CG2 VAL    79      14.427  -6.975  19.840  1.00 30.87           C  
ATOM    555  N   CYS    80      13.411 -11.721  19.355  1.00 34.05           N  
ATOM    556  CA  CYS    80      12.533 -12.854  19.471  1.00 34.02           C  
ATOM    557  C   CYS    80      11.430 -12.582  20.492  1.00 33.64           C  
ATOM    558  O   CYS    80      11.698 -12.131  21.600  1.00 32.90           O  
ATOM    559  CB  CYS    80      13.294 -14.109  19.911  1.00 34.77           C  
ATOM    560  SG  CYS    80      12.168 -15.548  19.926  1.00 35.45           S  
ATOM    561  N   PRO    81      10.148 -12.867  20.137  1.00 34.47           N  
ATOM    562  CA  PRO    81       9.161 -12.521  21.164  1.00 33.40           C  
ATOM    563  C   PRO    81       9.158 -13.389  22.422  1.00 32.58           C  
ATOM    564  O   PRO    81       8.508 -12.988  23.398  1.00 32.43           O  
ATOM    565  CB  PRO    81       7.805 -12.649  20.450  1.00 33.95           C  
ATOM    566  CG  PRO    81       8.086 -13.625  19.318  1.00 33.95           C  
ATOM    567  CD  PRO    81       9.559 -13.452  18.920  1.00 33.50           C  
ATOM    568  N   TRP    82       9.802 -14.554  22.398  1.00 32.23           N  
ATOM    569  CA  TRP    82       9.754 -15.550  23.533  1.00 31.38           C  
ATOM    570  C   TRP    82      10.749 -15.130  24.528  1.00 30.48           C  
ATOM    571  O   TRP    82      10.362 -14.756  25.596  1.00 29.33           O  
ATOM    572  CB  TRP    82       9.982 -16.993  23.023  1.00 32.45           C  
ATOM    573  CG  TRP    82       8.799 -17.617  22.294  1.00 34.89           C  
ATOM    574  CD1 TRP    82       7.596 -17.007  21.998  1.00 36.46           C  
ATOM    575  CD2 TRP    82       8.669 -18.981  21.835  1.00 35.91           C  
ATOM    576  NE1 TRP    82       6.751 -17.904  21.374  1.00 34.16           N  
ATOM    577  CE2 TRP    82       7.387 -19.107  21.242  1.00 35.08           C  
ATOM    578  CE3 TRP    82       9.521 -20.105  21.855  1.00 36.77           C  
ATOM    579  CZ2 TRP    82       6.925 -20.325  20.657  1.00 37.12           C  
ATOM    580  CZ3 TRP    82       9.077 -21.308  21.279  1.00 35.69           C  
ATOM    581  CH2 TRP    82       7.782 -21.405  20.693  1.00 37.21           C  
ATOM    582  N   HIS    83      12.068 -15.103  24.216  1.00 30.38           N  
ATOM    583  CA  HIS    83      12.919 -14.743  25.348  1.00 29.88           C  
ATOM    584  C   HIS    83      13.741 -13.485  25.057  1.00 31.78           C  
ATOM    585  O   HIS    83      14.746 -13.232  25.722  1.00 31.83           O  
ATOM    586  CB  HIS    83      13.781 -15.895  25.841  1.00 31.04           C  
ATOM    587  CG  HIS    83      13.026 -17.192  25.969  1.00 31.61           C  
ATOM    588  ND1 HIS    83      12.949 -18.098  24.940  1.00 32.84           N  
ATOM    589  CD2 HIS    83      12.222 -17.671  26.946  1.00 34.43           C  
ATOM    590  CE1 HIS    83      12.170 -19.111  25.295  1.00 32.77           C  
ATOM    591  NE2 HIS    83      11.701 -18.859  26.499  1.00 34.54           N  
ATOM    592  N   LYS    84      13.272 -12.695  24.087  1.00 31.89           N  
ATOM    593  CA  LYS    84      13.801 -11.347  23.806  1.00 31.70           C  
ATOM    594  C   LYS    84      15.293 -11.389  23.412  1.00 33.14           C  
ATOM    595  O   LYS    84      15.999 -10.409  23.572  1.00 32.10           O  
ATOM    596  CB  LYS    84      13.572 -10.417  24.989  1.00 31.06           C  
ATOM    597  CG  LYS    84      12.064 -10.399  25.517  1.00 30.64           C  
ATOM    598  CD  LYS    84      11.050 -10.263  24.434  1.00 32.36           C  
ATOM    599  CE  LYS    84       9.644  -9.933  25.085  1.00 38.66           C  
ATOM    600  NZ  LYS    84       8.482 -10.388  24.213  1.00 42.06           N  
ATOM    601  N   TYR    85      15.749 -12.497  22.829  1.00 33.63           N  
ATOM    602  CA  TYR    85      17.115 -12.501  22.289  1.00 34.59           C  
ATOM    603  C   TYR    85      17.175 -11.542  21.081  1.00 35.22           C  
ATOM    604  O   TYR    85      16.204 -11.416  20.329  1.00 34.27           O  
ATOM    605  CB  TYR    85      17.601 -13.871  21.873  1.00 34.05           C  
ATOM    606  CG  TYR    85      18.069 -14.735  23.013  1.00 33.39           C  
ATOM    607  CD1 TYR    85      17.518 -14.603  24.318  1.00 33.28           C  
ATOM    608  CD2 TYR    85      19.020 -15.705  22.782  1.00 33.67           C  
ATOM    609  CE1 TYR    85      17.960 -15.396  25.370  1.00 32.12           C  
ATOM    610  CE2 TYR    85      19.448 -16.533  23.802  1.00 36.57           C  
ATOM    611  CZ  TYR    85      18.910 -16.370  25.089  1.00 35.84           C  
ATOM    612  OH  TYR    85      19.383 -17.144  26.067  1.00 31.52           O  
ATOM    613  N   LYS    86      18.305 -10.876  20.931  1.00 34.93           N  
ATOM    614  CA  LYS    86      18.469  -9.853  19.904  1.00 36.39           C  
ATOM    615  C   LYS    86      19.354 -10.424  18.841  1.00 36.21           C  
ATOM    616  O   LYS    86      20.454 -10.888  19.121  1.00 35.92           O  
ATOM    617  CB  LYS    86      19.109  -8.620  20.483  1.00 36.57           C  
ATOM    618  CG  LYS    86      18.377  -8.041  21.744  1.00 38.21           C  
ATOM    619  CD  LYS    86      19.382  -6.992  22.306  1.00 41.31           C  
ATOM    620  CE  LYS    86      18.733  -6.100  23.324  1.00 46.04           C  
ATOM    621  NZ  LYS    86      18.598  -6.744  24.662  1.00 46.41           N  
ATOM    622  N   ILE    87      18.849 -10.420  17.612  1.00 35.80           N  
ATOM    623  CA  ILE    87      19.600 -10.980  16.491  1.00 34.37           C  
ATOM    624  C   ILE    87      19.777  -9.927  15.419  1.00 35.24           C  
ATOM    625  O   ILE    87      18.772  -9.368  14.953  1.00 33.39           O  
ATOM    626  CB  ILE    87      18.816 -12.178  15.906  1.00 35.19           C  
ATOM    627  CG1 ILE    87      18.756 -13.254  17.013  1.00 32.85           C  
ATOM    628  CG2 ILE    87      19.485 -12.672  14.587  1.00 32.28           C  
ATOM    629  CD1 ILE    87      17.647 -14.305  16.840  1.00 33.74           C  
ATOM    630  N   THR    88      21.023  -9.680  15.000  1.00 32.82           N  
ATOM    631  CA  THR    88      21.230  -8.635  13.996  1.00 34.57           C  
ATOM    632  C   THR    88      20.607  -9.068  12.656  1.00 34.38           C  
ATOM    633  O   THR    88      20.650 -10.224  12.304  1.00 34.53           O  
ATOM    634  CB  THR    88      22.724  -8.301  13.763  1.00 34.35           C  
ATOM    635  OG1 THR    88      23.409  -9.475  13.340  1.00 35.21           O  
ATOM    636  CG2 THR    88      23.392  -7.774  15.039  1.00 33.63           C  
ATOM    637  N   LEU    89      19.976  -8.125  11.981  1.00 34.00           N  
ATOM    638  CA  LEU    89      19.322  -8.356  10.695  1.00 35.35           C  
ATOM    639  C   LEU    89      20.380  -8.672   9.650  1.00 35.40           C  
ATOM    640  O   LEU    89      20.181  -9.579   8.837  1.00 36.23           O  
ATOM    641  CB  LEU    89      18.529  -7.081  10.287  1.00 33.99           C  
ATOM    642  CG  LEU    89      17.230  -6.790  11.094  1.00 32.97           C  
ATOM    643  CD1 LEU    89      16.426  -5.700  10.357  1.00 31.94           C  
ATOM    644  CD2 LEU    89      16.393  -8.003  11.336  1.00 30.27           C  
ATOM    645  N   ALA    90      21.509  -7.975   9.727  1.00 34.20           N  
ATOM    646  CA  ALA    90      22.519  -8.019   8.678  1.00 36.25           C  
ATOM    647  C   ALA    90      23.387  -9.263   8.793  1.00 36.66           C  
ATOM    648  O   ALA    90      23.758  -9.810   7.776  1.00 36.43           O  
ATOM    649  CB  ALA    90      23.415  -6.759   8.683  1.00 35.66           C  
ATOM    650  N   THR    91      23.685  -9.717  10.027  1.00 34.82           N  
ATOM    651  CA  THR    91      24.589 -10.858  10.183  1.00 35.01           C  
ATOM    652  C   THR    91      24.116 -12.087  10.991  1.00 35.56           C  
ATOM    653  O   THR    91      24.853 -13.077  11.052  1.00 36.37           O  
ATOM    654  CB  THR    91      25.960 -10.390  10.761  1.00 34.11           C  
ATOM    655  OG1 THR    91      25.737  -9.613  11.957  1.00 35.18           O  
ATOM    656  CG2 THR    91      26.699  -9.568   9.732  1.00 33.96           C  
ATOM    657  N   GLY    92      22.938 -12.026  11.618  1.00 33.49           N  
ATOM    658  CA  GLY    92      22.460 -13.150  12.383  1.00 34.48           C  
ATOM    659  C   GLY    92      23.227 -13.354  13.680  1.00 35.00           C  
ATOM    660  O   GLY    92      23.222 -14.444  14.230  1.00 34.54           O  
ATOM    661  N   GLU    93      23.805 -12.274  14.204  1.00 35.53           N  
ATOM    662  CA  GLU    93      24.569 -12.353  15.436  1.00 36.08           C  
ATOM    663  C   GLU    93      23.607 -12.161  16.603  1.00 37.33           C  
ATOM    664  O   GLU    93      22.883 -11.187  16.639  1.00 34.20           O  
ATOM    665  CB  GLU    93      25.642 -11.255  15.497  1.00 35.02           C  
ATOM    666  CG  GLU    93      26.854 -11.393  14.533  1.00 31.69           C  
ATOM    667  CD  GLU    93      27.731 -10.176  14.562  1.00 34.65           C  
ATOM    668  OE1 GLU    93      28.431  -9.935  15.578  1.00 37.63           O  
ATOM    669  OE2 GLU    93      27.761  -9.438  13.567  1.00 33.35           O  
ATOM    670  N   GLY    94      23.689 -13.064  17.584  1.00 39.26           N  
ATOM    671  CA  GLY    94      23.199 -12.833  18.957  1.00 39.94           C  
ATOM    672  C   GLY    94      23.965 -11.705  19.616  1.00 40.96           C  
ATOM    673  O   GLY    94      25.195 -11.754  19.743  1.00 41.85           O  
ATOM    674  N   LEU    95      23.262 -10.662  20.036  1.00 41.80           N  
ATOM    675  CA  LEU    95      23.912  -9.522  20.705  1.00 43.32           C  
ATOM    676  C   LEU    95      23.481  -9.430  22.157  1.00 44.62           C  
ATOM    677  O   LEU    95      22.305  -9.712  22.518  1.00 44.46           O  
ATOM    678  CB  LEU    95      23.514  -8.202  20.035  1.00 43.50           C  
ATOM    679  CG  LEU    95      23.999  -7.851  18.663  1.00 43.89           C  
ATOM    680  CD1 LEU    95      23.548  -6.420  18.448  1.00 42.62           C  
ATOM    681  CD2 LEU    95      25.548  -7.911  18.639  1.00 46.24           C  
ATOM    682  N   TYR    96      24.422  -9.008  22.993  1.00 45.03           N  
ATOM    683  CA  TYR    96      24.140  -8.751  24.398  1.00 45.51           C  
ATOM    684  C   TYR    96      25.061  -7.662  24.986  1.00 45.91           C  
ATOM    685  O   TYR    96      26.169  -7.340  24.467  1.00 45.16           O  
ATOM    686  CB  TYR    96      24.236 -10.057  25.240  1.00 45.83           C  
ATOM    687  CG  TYR    96      25.604 -10.654  25.208  1.00 44.27           C  
ATOM    688  CD1 TYR    96      26.031 -11.370  24.071  1.00 50.00           C  
ATOM    689  CD2 TYR    96      26.502 -10.491  26.263  1.00 46.02           C  
ATOM    690  CE1 TYR    96      27.349 -11.916  23.981  1.00 47.47           C  
ATOM    691  CE2 TYR    96      27.839 -11.074  26.200  1.00 46.29           C  
ATOM    692  CZ  TYR    96      28.231 -11.777  25.050  1.00 44.35           C  
ATOM    693  OH  TYR    96      29.492 -12.321  24.908  1.00 45.24           O  
ATOM    694  N   GLN    97      24.585  -7.086  26.087  1.00 46.30           N  
ATOM    695  CA  GLN    97      25.427  -6.235  26.908  1.00 46.58           C  
ATOM    696  C   GLN    97      26.028  -7.040  28.046  1.00 45.88           C  
ATOM    697  O   GLN    97      25.322  -7.760  28.753  1.00 44.56           O  
ATOM    698  CB  GLN    97      24.642  -5.078  27.499  1.00 47.22           C  
ATOM    699  CG  GLN    97      24.144  -4.011  26.589  1.00 48.64           C  
ATOM    700  CD  GLN    97      23.318  -3.005  27.411  1.00 52.59           C  
ATOM    701  OE1 GLN    97      23.868  -2.091  28.035  1.00 53.02           O  
ATOM    702  NE2 GLN    97      22.001  -3.214  27.457  1.00 51.22           N  
ATOM    703  N   SER    98      27.332  -6.892  28.210  1.00 45.90           N  
ATOM    704  CA  SER    98      28.032  -7.433  29.337  1.00 47.24           C  
ATOM    705  C   SER    98      28.166  -6.335  30.376  1.00 49.34           C  
ATOM    706  O   SER    98      28.757  -5.280  30.106  1.00 49.89           O  
ATOM    707  CB  SER    98      29.421  -7.930  28.921  1.00 47.10           C  
ATOM    708  OG  SER    98      30.102  -8.443  30.055  1.00 45.34           O  
ATOM    709  N   ILE    99      27.643  -6.611  31.572  1.00 51.39           N  
ATOM    710  CA  ILE    99      27.521  -5.639  32.677  1.00 52.93           C  
ATOM    711  C   ILE    99      28.393  -6.106  33.858  1.00 54.29           C  
ATOM    712  O   ILE    99      28.399  -7.298  34.199  1.00 54.71           O  
ATOM    713  CB  ILE    99      26.001  -5.470  33.104  1.00 52.30           C  
ATOM    714  CG1 ILE    99      25.131  -5.046  31.911  1.00 51.54           C  
ATOM    715  CG2 ILE    99      25.821  -4.493  34.288  1.00 53.70           C  
ATOM    716  CD1 ILE    99      23.807  -5.799  31.805  1.00 46.37           C  
ATOM    717  N   ASN   100      29.145  -5.184  34.459  1.00 55.52           N  
ATOM    718  CA  ASN   100      29.915  -5.522  35.654  1.00 56.83           C  
ATOM    719  C   ASN   100      29.368  -4.911  36.948  1.00 57.31           C  
ATOM    720  O   ASN   100      29.767  -3.798  37.320  1.00 57.84           O  
ATOM    721  CB  ASN   100      31.395  -5.180  35.492  1.00 57.18           C  
ATOM    722  CG  ASN   100      32.279  -5.978  36.445  1.00 58.52           C  
ATOM    723  OD1 ASN   100      32.301  -5.729  37.666  1.00 55.73           O  
ATOM    724  ND2 ASN   100      32.999  -6.966  35.887  1.00 59.65           N  
ATOM    725  N   PRO   101      28.505  -5.669  37.671  1.00 57.70           N  
ATOM    726  CA  PRO   101      27.715  -5.252  38.861  1.00 57.67           C  
ATOM    727  C   PRO   101      28.494  -4.456  39.916  1.00 57.26           C  
ATOM    728  O   PRO   101      29.706  -4.632  40.048  1.00 57.24           O  
ATOM    729  CB  PRO   101      27.268  -6.589  39.470  1.00 57.78           C  
ATOM    730  CG  PRO   101      28.071  -7.663  38.736  1.00 57.63           C  
ATOM    731  CD  PRO   101      28.294  -7.099  37.376  1.00 57.45           C  
ATOM    732  N   LYS   107      29.692   1.272  32.920  1.00 52.92           N  
ATOM    733  CA  LYS   107      29.148   1.413  31.570  1.00 53.38           C  
ATOM    734  C   LYS   107      29.016   0.059  30.807  1.00 53.00           C  
ATOM    735  O   LYS   107      30.028  -0.555  30.445  1.00 53.19           O  
ATOM    736  CB  LYS   107      30.007   2.402  30.785  1.00 53.22           C  
ATOM    737  CG  LYS   107      29.300   3.062  29.608  1.00 54.17           C  
ATOM    738  CD  LYS   107      30.302   3.782  28.676  1.00 54.72           C  
ATOM    739  CE  LYS   107      30.830   2.874  27.551  1.00 56.01           C  
ATOM    740  NZ  LYS   107      29.758   2.104  26.827  1.00 56.35           N  
ATOM    741  N   PRO   108      27.766  -0.424  30.589  1.00 52.64           N  
ATOM    742  CA  PRO   108      27.527  -1.639  29.776  1.00 52.07           C  
ATOM    743  C   PRO   108      28.149  -1.649  28.357  1.00 51.06           C  
ATOM    744  O   PRO   108      28.077  -0.662  27.610  1.00 51.00           O  
ATOM    745  CB  PRO   108      25.986  -1.740  29.709  1.00 52.11           C  
ATOM    746  CG  PRO   108      25.470  -0.398  30.166  1.00 52.53           C  
ATOM    747  CD  PRO   108      26.501   0.106  31.141  1.00 52.95           C  
ATOM    748  N   LYS   109      28.747  -2.780  28.007  1.00 49.63           N  
ATOM    749  CA  LYS   109      29.417  -2.927  26.728  1.00 48.39           C  
ATOM    750  C   LYS   109      28.752  -4.014  25.903  1.00 47.32           C  
ATOM    751  O   LYS   109      28.409  -5.079  26.408  1.00 46.47           O  
ATOM    752  CB  LYS   109      30.908  -3.231  26.929  1.00 48.48           C  
ATOM    753  CG  LYS   109      31.675  -2.169  27.706  1.00 48.27           C  
ATOM    754  CD  LYS   109      32.101  -0.976  26.816  1.00 48.40           C  
ATOM    755  CE  LYS   109      32.829   0.130  27.608  1.00 48.03           C  
ATOM    756  NZ  LYS   109      34.057  -0.306  28.331  1.00 48.01           N  
ATOM    757  N   TRP   110      28.577  -3.715  24.624  1.00 46.18           N  
ATOM    758  CA  TRP   110      27.922  -4.607  23.689  1.00 45.75           C  
ATOM    759  C   TRP   110      28.888  -5.683  23.197  1.00 44.56           C  
ATOM    760  O   TRP   110      30.046  -5.391  22.911  1.00 42.89           O  
ATOM    761  CB  TRP   110      27.375  -3.803  22.515  1.00 45.61           C  
ATOM    762  CG  TRP   110      26.203  -3.031  22.904  1.00 46.40           C  
ATOM    763  CD1 TRP   110      26.153  -1.699  23.258  1.00 45.90           C  
ATOM    764  CD2 TRP   110      24.869  -3.540  23.026  1.00 45.33           C  
ATOM    765  NE1 TRP   110      24.843  -1.349  23.573  1.00 45.91           N  
ATOM    766  CE2 TRP   110      24.038  -2.454  23.441  1.00 46.03           C  
ATOM    767  CE3 TRP   110      24.291  -4.803  22.822  1.00 45.31           C  
ATOM    768  CZ2 TRP   110      22.634  -2.600  23.654  1.00 46.18           C  
ATOM    769  CZ3 TRP   110      22.872  -4.949  23.031  1.00 46.50           C  
ATOM    770  CH2 TRP   110      22.082  -3.853  23.464  1.00 44.84           C  
ATOM    771  N   CYS   111      28.361  -6.904  23.104  1.00 43.73           N  
ATOM    772  CA  CYS   111      29.114  -8.133  22.804  1.00 43.51           C  
ATOM    773  C   CYS   111      28.372  -9.074  21.871  1.00 42.24           C  
ATOM    774  O   CYS   111      27.149  -9.058  21.816  1.00 41.79           O  
ATOM    775  CB  CYS   111      29.376  -8.905  24.099  1.00 43.86           C  
ATOM    776  SG  CYS   111      30.478  -8.046  25.204  1.00 46.60           S  
ATOM    777  N   SER   112      29.104  -9.937  21.181  1.00 40.36           N  
ATOM    778  CA  SER   112      28.489 -10.890  20.233  1.00 38.78           C  
ATOM    779  C   SER   112      29.045 -12.287  20.444  1.00 38.54           C  
ATOM    780  O   SER   112      30.236 -12.465  20.784  1.00 37.11           O  
ATOM    781  CB  SER   112      28.784 -10.442  18.777  1.00 38.60           C  
ATOM    782  OG  SER   112      28.526 -11.474  17.829  1.00 36.33           O  
ATOM    783  N   LYS   113      28.240 -13.294  20.134  1.00 39.27           N  
ATOM    784  CA  LYS   113      28.809 -14.664  20.073  1.00 39.20           C  
ATOM    785  C   LYS   113      28.966 -15.206  18.665  1.00 37.38           C  
ATOM    786  O   LYS   113      29.110 -16.411  18.469  1.00 37.70           O  
ATOM    787  CB  LYS   113      27.989 -15.639  20.921  1.00 42.14           C  
ATOM    788  CG  LYS   113      28.737 -16.266  22.147  1.00 43.01           C  
ATOM    789  CD  LYS   113      27.629 -16.659  23.119  1.00 49.68           C  
ATOM    790  CE  LYS   113      28.098 -16.891  24.541  1.00 52.37           C  
ATOM    791  NZ  LYS   113      26.895 -17.361  25.347  1.00 52.14           N  
ATOM    792  N   GLY   114      29.001 -14.319  17.685  1.00 35.65           N  
ATOM    793  CA  GLY   114      29.233 -14.768  16.320  1.00 33.82           C  
ATOM    794  C   GLY   114      27.873 -15.014  15.692  1.00 33.37           C  
ATOM    795  O   GLY   114      26.853 -14.701  16.302  1.00 33.36           O  
ATOM    796  N   VAL   115      27.846 -15.649  14.525  1.00 32.79           N  
ATOM    797  CA  VAL   115      26.561 -15.900  13.774  1.00 33.84           C  
ATOM    798  C   VAL   115      25.799 -17.031  14.496  1.00 34.57           C  
ATOM    799  O   VAL   115      26.361 -18.137  14.767  1.00 34.43           O  
ATOM    800  CB  VAL   115      26.845 -16.293  12.300  1.00 33.90           C  
ATOM    801  CG1 VAL   115      25.555 -16.622  11.522  1.00 31.20           C  
ATOM    802  CG2 VAL   115      27.703 -15.199  11.551  1.00 33.60           C  
ATOM    803  N   LYS   116      24.574 -16.720  14.899  1.00 33.94           N  
ATOM    804  CA  LYS   116      23.689 -17.683  15.526  1.00 34.60           C  
ATOM    805  C   LYS   116      22.534 -18.002  14.584  1.00 36.35           C  
ATOM    806  O   LYS   116      22.037 -19.147  14.525  1.00 36.12           O  
ATOM    807  CB  LYS   116      23.137 -17.076  16.830  1.00 34.93           C  
ATOM    808  CG  LYS   116      24.158 -16.962  17.967  1.00 36.71           C  
ATOM    809  CD  LYS   116      24.828 -18.295  18.150  1.00 37.08           C  
ATOM    810  CE  LYS   116      25.508 -18.443  19.482  1.00 39.69           C  
ATOM    811  NZ  LYS   116      25.820 -19.872  19.666  1.00 39.79           N  
ATOM    812  N   GLN   117      22.067 -16.972  13.876  1.00 36.23           N  
ATOM    813  CA  GLN   117      20.877 -17.109  13.025  1.00 37.34           C  
ATOM    814  C   GLN   117      21.271 -17.048  11.555  1.00 37.69           C  
ATOM    815  O   GLN   117      21.845 -16.036  11.090  1.00 37.71           O  
ATOM    816  CB  GLN   117      19.869 -15.988  13.312  1.00 36.96           C  
ATOM    817  CG  GLN   117      18.463 -16.279  12.769  1.00 36.32           C  
ATOM    818  CD  GLN   117      17.735 -17.310  13.592  1.00 35.64           C  
ATOM    819  OE1 GLN   117      18.100 -17.589  14.764  1.00 33.21           O  
ATOM    820  NE2 GLN   117      16.695 -17.910  12.990  1.00 32.46           N  
ATOM    821  N   ARG   118      20.991 -18.126  10.825  1.00 37.71           N  
ATOM    822  CA  ARG   118      21.418 -18.190   9.418  1.00 37.98           C  
ATOM    823  C   ARG   118      20.741 -17.092   8.573  1.00 37.27           C  
ATOM    824  O   ARG   118      19.476 -17.000   8.499  1.00 37.04           O  
ATOM    825  CB  ARG   118      21.179 -19.576   8.789  1.00 38.02           C  
ATOM    826  CG  ARG   118      21.819 -19.735   7.378  1.00 39.40           C  
ATOM    827  CD  ARG   118      21.777 -21.175   6.875  1.00 38.52           C  
ATOM    828  NE  ARG   118      22.687 -22.033   7.665  1.00 38.06           N  
ATOM    829  CZ  ARG   118      24.022 -22.129   7.515  1.00 37.93           C  
ATOM    830  NH1 ARG   118      24.691 -21.440   6.593  1.00 34.56           N  
ATOM    831  NH2 ARG   118      24.703 -22.923   8.333  1.00 38.47           N  
ATOM    832  N   ILE   119      21.582 -16.256   7.956  1.00 36.09           N  
ATOM    833  CA  ILE   119      21.119 -15.156   7.094  1.00 36.00           C  
ATOM    834  C   ILE   119      21.166 -15.659   5.666  1.00 36.74           C  
ATOM    835  O   ILE   119      22.181 -16.133   5.235  1.00 36.50           O  
ATOM    836  CB  ILE   119      22.024 -13.877   7.212  1.00 35.96           C  
ATOM    837  CG1 ILE   119      22.022 -13.307   8.650  1.00 34.90           C  
ATOM    838  CG2 ILE   119      21.682 -12.825   6.125  1.00 35.15           C  
ATOM    839  CD1 ILE   119      20.602 -12.885   9.187  1.00 30.88           C  
ATOM    840  N   HIS   120      20.053 -15.565   4.942  1.00 36.85           N  
ATOM    841  CA  HIS   120      20.040 -15.841   3.493  1.00 38.96           C  
ATOM    842  C   HIS   120      20.138 -14.559   2.630  1.00 39.25           C  
ATOM    843  O   HIS   120      20.005 -13.427   3.128  1.00 40.02           O  
ATOM    844  CB  HIS   120      18.777 -16.660   3.144  1.00 38.05           C  
ATOM    845  CG  HIS   120      18.561 -17.800   4.089  1.00 38.96           C  
ATOM    846  ND1 HIS   120      19.418 -18.878   4.150  1.00 36.58           N  
ATOM    847  CD2 HIS   120      17.627 -18.000   5.053  1.00 35.27           C  
ATOM    848  CE1 HIS   120      19.003 -19.709   5.090  1.00 38.50           C  
ATOM    849  NE2 HIS   120      17.934 -19.192   5.668  1.00 35.36           N  
ATOM    850  N   THR   121      20.333 -14.756   1.338  1.00 39.59           N  
ATOM    851  CA  THR   121      20.491 -13.659   0.402  1.00 40.27           C  
ATOM    852  C   THR   121      19.199 -13.159  -0.273  1.00 40.15           C  
ATOM    853  O   THR   121      18.438 -13.936  -0.858  1.00 39.80           O  
ATOM    854  CB  THR   121      21.500 -14.066  -0.671  1.00 40.22           C  
ATOM    855  OG1 THR   121      22.749 -14.397  -0.034  1.00 41.98           O  
ATOM    856  CG2 THR   121      21.706 -12.937  -1.682  1.00 41.72           C  
ATOM    857  N   VAL   122      19.007 -11.839  -0.253  1.00 41.00           N  
ATOM    858  CA  VAL   122      17.854 -11.203  -0.869  1.00 41.58           C  
ATOM    859  C   VAL   122      18.258 -10.178  -1.930  1.00 43.48           C  
ATOM    860  O   VAL   122      19.146  -9.338  -1.698  1.00 43.53           O  
ATOM    861  CB  VAL   122      16.981 -10.464   0.162  1.00 41.71           C  
ATOM    862  CG1 VAL   122      15.644 -10.073  -0.474  1.00 38.28           C  
ATOM    863  CG2 VAL   122      16.765 -11.303   1.363  1.00 40.94           C  
ATOM    864  N   LYS   123      17.587 -10.270  -3.081  1.00 44.58           N  
ATOM    865  CA  LYS   123      17.739  -9.350  -4.214  1.00 46.35           C  
ATOM    866  C   LYS   123      16.342  -8.962  -4.683  1.00 46.16           C  
ATOM    867  O   LYS   123      15.405  -9.785  -4.628  1.00 46.09           O  
ATOM    868  CB  LYS   123      18.475 -10.028  -5.365  1.00 45.73           C  
ATOM    869  CG  LYS   123      19.758 -10.697  -4.915  1.00 49.43           C  
ATOM    870  CD  LYS   123      20.670 -11.185  -6.033  1.00 49.00           C  
ATOM    871  CE  LYS   123      21.765 -12.074  -5.411  1.00 53.31           C  
ATOM    872  NZ  LYS   123      23.006 -11.341  -5.004  1.00 54.10           N  
ATOM    873  N   VAL   124      16.198  -7.705  -5.112  1.00 46.40           N  
ATOM    874  CA  VAL   124      15.000  -7.293  -5.832  1.00 46.88           C  
ATOM    875  C   VAL   124      15.379  -7.052  -7.277  1.00 46.74           C  
ATOM    876  O   VAL   124      16.504  -6.635  -7.570  1.00 46.43           O  
ATOM    877  CB  VAL   124      14.232  -6.080  -5.185  1.00 47.39           C  
ATOM    878  CG1 VAL   124      13.900  -6.365  -3.711  1.00 46.38           C  
ATOM    879  CG2 VAL   124      15.003  -4.779  -5.323  1.00 48.38           C  
ATOM    880  N   ASP   125      14.456  -7.392  -8.164  1.00 46.24           N  
ATOM    881  CA  ASP   125      14.604  -7.198  -9.603  1.00 46.97           C  
ATOM    882  C   ASP   125      13.200  -7.131 -10.144  1.00 46.60           C  
ATOM    883  O   ASP   125      12.381  -8.010  -9.868  1.00 46.64           O  
ATOM    884  CB  ASP   125      15.365  -8.366 -10.243  1.00 47.02           C  
ATOM    885  CG  ASP   125      15.581  -8.179 -11.735  1.00 48.06           C  
ATOM    886  OD1 ASP   125      16.409  -7.324 -12.127  1.00 47.94           O  
ATOM    887  OD2 ASP   125      14.925  -8.901 -12.522  1.00 49.86           O  
ATOM    888  N   ASN   126      12.915  -6.066 -10.880  1.00 46.65           N  
ATOM    889  CA  ASN   126      11.595  -5.865 -11.459  1.00 46.94           C  
ATOM    890  C   ASN   126      10.482  -5.772 -10.414  1.00 46.29           C  
ATOM    891  O   ASN   126       9.341  -6.151 -10.691  1.00 46.38           O  
ATOM    892  CB  ASN   126      11.265  -6.996 -12.440  1.00 47.56           C  
ATOM    893  CG  ASN   126      11.881  -6.790 -13.785  1.00 48.66           C  
ATOM    894  OD1 ASN   126      13.106  -6.718 -13.920  1.00 51.64           O  
ATOM    895  ND2 ASN   126      11.040  -6.693 -14.802  1.00 48.83           N  
ATOM    896  N   GLY   127      10.816  -5.281  -9.221  1.00 45.49           N  
ATOM    897  CA  GLY   127       9.850  -5.254  -8.121  1.00 44.79           C  
ATOM    898  C   GLY   127       9.414  -6.632  -7.616  1.00 43.72           C  
ATOM    899  O   GLY   127       8.267  -6.769  -7.095  1.00 44.18           O  
ATOM    900  N   ASN   128      10.302  -7.652  -7.804  1.00 41.82           N  
ATOM    901  CA  ASN   128      10.065  -8.957  -7.237  1.00 40.23           C  
ATOM    902  C   ASN   128      11.127  -9.241  -6.198  1.00 40.41           C  
ATOM    903  O   ASN   128      12.298  -8.871  -6.378  1.00 39.02           O  
ATOM    904  CB  ASN   128      10.104 -10.042  -8.298  1.00 40.14           C  
ATOM    905  CG  ASN   128       8.857 -10.065  -9.183  1.00 40.64           C  
ATOM    906  OD1 ASN   128       7.774  -9.582  -8.797  1.00 42.50           O  
ATOM    907  ND2 ASN   128       9.001 -10.667 -10.368  1.00 35.86           N  
ATOM    908  N   ILE   129      10.736  -9.889  -5.104  1.00 39.25           N  
ATOM    909  CA  ILE   129      11.724 -10.264  -4.089  1.00 39.89           C  
ATOM    910  C   ILE   129      12.189 -11.689  -4.363  1.00 39.72           C  
ATOM    911  O   ILE   129      11.367 -12.580  -4.538  1.00 40.66           O  
ATOM    912  CB  ILE   129      11.177 -10.050  -2.666  1.00 40.15           C  
ATOM    913  CG1 ILE   129      10.646  -8.609  -2.563  1.00 39.73           C  
ATOM    914  CG2 ILE   129      12.289 -10.383  -1.574  1.00 38.54           C  
ATOM    915  CD1 ILE   129       9.946  -8.267  -1.304  1.00 41.42           C  
ATOM    916  N   TYR   130      13.505 -11.885  -4.456  1.00 39.44           N  
ATOM    917  CA  TYR   130      14.075 -13.199  -4.695  1.00 39.04           C  
ATOM    918  C   TYR   130      14.927 -13.622  -3.518  1.00 39.32           C  
ATOM    919  O   TYR   130      15.779 -12.858  -3.059  1.00 40.79           O  
ATOM    920  CB  TYR   130      14.921 -13.200  -5.984  1.00 38.38           C  
ATOM    921  CG  TYR   130      14.096 -13.000  -7.267  1.00 37.81           C  
ATOM    922  CD1 TYR   130      13.542 -14.087  -7.933  1.00 36.33           C  
ATOM    923  CD2 TYR   130      13.858 -11.725  -7.789  1.00 36.31           C  
ATOM    924  CE1 TYR   130      12.789 -13.923  -9.121  1.00 38.63           C  
ATOM    925  CE2 TYR   130      13.089 -11.540  -8.988  1.00 38.25           C  
ATOM    926  CZ  TYR   130      12.559 -12.647  -9.645  1.00 38.04           C  
ATOM    927  OH  TYR   130      11.771 -12.507 -10.806  1.00 40.74           O  
ATOM    928  N   VAL   131      14.753 -14.852  -3.063  1.00 38.99           N  
ATOM    929  CA  VAL   131      15.594 -15.364  -1.979  1.00 39.24           C  
ATOM    930  C   VAL   131      16.495 -16.532  -2.447  1.00 39.70           C  
ATOM    931  O   VAL   131      16.069 -17.417  -3.165  1.00 38.44           O  
ATOM    932  CB  VAL   131      14.755 -15.722  -0.681  1.00 40.15           C  
ATOM    933  CG1 VAL   131      15.672 -16.298   0.427  1.00 38.58           C  
ATOM    934  CG2 VAL   131      14.018 -14.500  -0.156  1.00 38.05           C  
ATOM    935  N   THR   132      17.747 -16.518  -2.008  1.00 40.04           N  
ATOM    936  CA  THR   132      18.662 -17.596  -2.286  1.00 40.59           C  
ATOM    937  C   THR   132      19.160 -18.076  -0.934  1.00 41.95           C  
ATOM    938  O   THR   132      19.635 -17.260  -0.131  1.00 42.01           O  
ATOM    939  CB  THR   132      19.816 -17.068  -3.200  1.00 40.85           C  
ATOM    940  OG1 THR   132      19.228 -16.494  -4.379  1.00 36.46           O  
ATOM    941  CG2 THR   132      20.793 -18.173  -3.591  1.00 40.09           C  
ATOM    942  N   LEU   133      19.006 -19.376  -0.646  1.00 43.00           N  
ATOM    943  CA  LEU   133      19.478 -19.932   0.642  1.00 43.84           C  
ATOM    944  C   LEU   133      21.003 -19.800   0.731  1.00 45.22           C  
ATOM    945  O   LEU   133      21.701 -19.944  -0.277  1.00 45.17           O  
ATOM    946  CB  LEU   133      19.037 -21.390   0.842  1.00 42.75           C  
ATOM    947  CG  LEU   133      17.561 -21.744   1.009  1.00 43.41           C  
ATOM    948  CD1 LEU   133      17.355 -23.248   1.217  1.00 40.34           C  
ATOM    949  CD2 LEU   133      16.914 -20.945   2.158  1.00 38.38           C  
ATOM    950  N   SER   134      21.518 -19.499   1.921  1.00 46.77           N  
ATOM    951  CA  SER   134      22.947 -19.315   2.087  1.00 48.93           C  
ATOM    952  C   SER   134      23.636 -20.617   2.454  1.00 50.30           C  
ATOM    953  O   SER   134      23.052 -21.430   3.178  1.00 50.76           O  
ATOM    954  CB  SER   134      23.217 -18.359   3.212  1.00 48.46           C  
ATOM    955  OG  SER   134      23.246 -19.084   4.431  1.00 51.29           O  
ATOM    956  N   LYS   135      24.888 -20.776   1.999  1.00 51.51           N  
ATOM    957  CA  LYS   135      25.747 -21.898   2.405  1.00 52.31           C  
ATOM    958  C   LYS   135      26.749 -21.454   3.469  1.00 53.22           C  
ATOM    959  O   LYS   135      27.278 -22.269   4.220  1.00 53.31           O  
ATOM    960  CB  LYS   135      26.517 -22.448   1.204  1.00 52.38           C  
ATOM    961  CG  LYS   135      25.832 -22.306  -0.127  1.00 52.11           C  
ATOM    962  CD  LYS   135      26.629 -23.075  -1.207  1.00 52.26           C  
ATOM    963  CE  LYS   135      26.349 -22.568  -2.623  1.00 51.66           C  
ATOM    964  NZ  LYS   135      27.234 -23.237  -3.657  1.00 51.02           N  
ATOM    965  N   GLU   136      27.006 -20.152   3.518  1.00 54.27           N  
ATOM    966  CA  GLU   136      27.956 -19.560   4.457  1.00 55.33           C  
ATOM    967  C   GLU   136      27.206 -19.019   5.694  1.00 55.09           C  
ATOM    968  O   GLU   136      26.128 -18.427   5.545  1.00 56.28           O  
ATOM    969  CB  GLU   136      28.719 -18.437   3.723  1.00 55.83           C  
ATOM    970  CG  GLU   136      29.997 -17.945   4.391  1.00 57.12           C  
ATOM    971  CD  GLU   136      31.278 -18.520   3.788  1.00 61.09           C  
ATOM    972  OE1 GLU   136      32.107 -19.071   4.568  1.00 61.63           O  
ATOM    973  OE2 GLU   136      31.476 -18.395   2.549  1.00 61.99           O  
ATOM    974  N   PRO   137      27.715 -19.267   6.936  1.00 55.06           N  
ATOM    975  CA  PRO   137      28.830 -20.105   7.419  1.00 54.23           C  
ATOM    976  C   PRO   137      28.458 -21.596   7.460  1.00 53.34           C  
ATOM    977  O   PRO   137      27.266 -21.937   7.390  1.00 53.31           O  
ATOM    978  CB  PRO   137      29.047 -19.593   8.848  1.00 53.86           C  
ATOM    979  CG  PRO   137      27.741 -19.181   9.281  1.00 54.97           C  
ATOM    980  CD  PRO   137      27.050 -18.585   8.071  1.00 54.57           C  
ATOM    981  N   PHE   138      29.459 -22.466   7.614  1.00 51.43           N  
ATOM    982  CA  PHE   138      29.223 -23.905   7.498  1.00 50.12           C  
ATOM    983  C   PHE   138      28.121 -24.426   8.435  1.00 48.87           C  
ATOM    984  O   PHE   138      27.243 -25.166   7.987  1.00 48.71           O  
ATOM    985  CB  PHE   138      30.543 -24.770   7.566  1.00 50.26           C  
ATOM    986  CG  PHE   138      30.222 -26.220   7.875  1.00 49.81           C  
ATOM    987  CD1 PHE   138      29.654 -27.076   6.745  1.00 51.49           C  
ATOM    988  CD2 PHE   138      30.384 -26.741   9.264  1.00 51.50           C  
ATOM    989  CE1 PHE   138      29.370 -28.414   7.051  1.00 51.29           C  
ATOM    990  CE2 PHE   138      30.105 -28.080   9.579  1.00 50.91           C  
ATOM    991  CZ  PHE   138      29.521 -28.922   8.458  1.00 51.61           C  
ATOM    992  N   LYS   139      28.144 -24.002   9.701  1.00 48.30           N  
ATOM    993  CA  LYS   139      27.051 -24.305  10.665  1.00 47.27           C  
ATOM    994  C   LYS   139      26.547 -23.108  11.510  1.00 45.92           C  
ATOM    995  O   LYS   139      27.349 -22.313  11.982  1.00 44.08           O  
ATOM    996  CB  LYS   139      27.496 -25.468  11.566  1.00 47.34           C  
ATOM    997  CG  LYS   139      26.480 -25.899  12.624  1.00 48.98           C  
ATOM    998  CD  LYS   139      27.075 -27.027  13.507  1.00 49.64           C  
ATOM    999  CE  LYS   139      26.266 -27.148  14.818  1.00 54.05           C  
ATOM   1000  NZ  LYS   139      26.806 -28.256  15.668  1.00 56.44           N  
ATOM   1001  N   CYS   140      25.210 -22.982  11.655  1.00 45.92           N  
ATOM   1002  CA  CYS   140      24.511 -22.004  12.540  1.00 46.22           C  
ATOM   1003  C   CYS   140      23.654 -22.698  13.584  1.00 45.35           C  
ATOM   1004  O   CYS   140      23.116 -23.767  13.310  1.00 46.60           O  
ATOM   1005  CB  CYS   140      23.596 -21.043  11.775  1.00 45.85           C  
ATOM   1006  SG  CYS   140      24.500 -20.055  10.567  1.00 48.91           S  
ATOM   1007  N   ASP   141      23.543 -22.117  14.776  1.00 44.08           N  
ATOM   1008  CA  ASP   141      22.661 -22.691  15.792  1.00 44.62           C  
ATOM   1009  C   ASP   141      21.209 -22.781  15.266  1.00 44.81           C  
ATOM   1010  O   ASP   141      20.514 -23.715  15.642  1.00 45.32           O  
ATOM   1011  CB  ASP   141      22.668 -21.877  17.082  1.00 44.12           C  
ATOM   1012  CG  ASP   141      23.859 -22.159  17.927  1.00 46.44           C  
ATOM   1013  OD1 ASP   141      24.743 -22.891  17.458  1.00 44.54           O  
ATOM   1014  OD2 ASP   141      23.923 -21.655  19.069  1.00 46.27           O  
ATOM   1015  N   SER   142      20.778 -21.871  14.383  1.00 43.14           N  
ATOM   1016  CA  SER   142      19.386 -21.945  13.855  1.00 44.31           C  
ATOM   1017  C   SER   142      19.056 -23.136  12.964  1.00 44.24           C  
ATOM   1018  O   SER   142      17.855 -23.430  12.753  1.00 44.10           O  
ATOM   1019  CB  SER   142      18.968 -20.672  13.109  1.00 42.51           C  
ATOM   1020  OG  SER   142      19.724 -20.520  11.920  1.00 44.57           O  
ATOM   1021  N   ASP   143      20.096 -23.789  12.422  1.00 45.06           N  
ATOM   1022  CA  ASP   143      19.920 -24.950  11.547  1.00 45.46           C  
ATOM   1023  C   ASP   143      19.147 -26.078  12.227  1.00 46.54           C  
ATOM   1024  O   ASP   143      18.376 -26.748  11.569  1.00 46.75           O  
ATOM   1025  CB  ASP   143      21.271 -25.513  11.043  1.00 45.66           C  
ATOM   1026  CG  ASP   143      22.036 -24.532  10.155  1.00 44.83           C  
ATOM   1027  OD1 ASP   143      21.419 -23.599   9.598  1.00 42.43           O  
ATOM   1028  OD2 ASP   143      23.265 -24.707  10.002  1.00 42.61           O  
ATOM   1029  N   TYR   144      19.381 -26.312  13.524  1.00 47.69           N  
ATOM   1030  CA  TYR   144      18.623 -27.347  14.256  1.00 48.61           C  
ATOM   1031  C   TYR   144      17.099 -27.159  14.128  1.00 48.69           C  
ATOM   1032  O   TYR   144      16.365 -28.135  13.991  1.00 47.78           O  
ATOM   1033  CB  TYR   144      18.997 -27.374  15.736  1.00 49.29           C  
ATOM   1034  CG  TYR   144      18.236 -28.431  16.549  1.00 50.70           C  
ATOM   1035  CD1 TYR   144      18.607 -29.785  16.506  1.00 52.62           C  
ATOM   1036  CD2 TYR   144      17.137 -28.072  17.355  1.00 50.86           C  
ATOM   1037  CE1 TYR   144      17.910 -30.757  17.256  1.00 53.14           C  
ATOM   1038  CE2 TYR   144      16.437 -29.036  18.096  1.00 50.65           C  
ATOM   1039  CZ  TYR   144      16.825 -30.359  18.054  1.00 51.92           C  
ATOM   1040  OH  TYR   144      16.129 -31.298  18.797  1.00 51.39           O  
ATOM   1041  N   TYR   145      16.644 -25.905  14.171  1.00 48.97           N  
ATOM   1042  CA  TYR   145      15.207 -25.585  14.134  1.00 49.21           C  
ATOM   1043  C   TYR   145      14.692 -25.435  12.713  1.00 49.99           C  
ATOM   1044  O   TYR   145      13.494 -25.243  12.506  1.00 50.05           O  
ATOM   1045  CB  TYR   145      14.899 -24.356  15.003  1.00 50.10           C  
ATOM   1046  CG  TYR   145      15.084 -24.675  16.463  1.00 49.20           C  
ATOM   1047  CD1 TYR   145      14.246 -25.591  17.080  1.00 50.84           C  
ATOM   1048  CD2 TYR   145      16.103 -24.109  17.212  1.00 45.52           C  
ATOM   1049  CE1 TYR   145      14.402 -25.937  18.406  1.00 51.72           C  
ATOM   1050  CE2 TYR   145      16.267 -24.456  18.567  1.00 47.36           C  
ATOM   1051  CZ  TYR   145      15.403 -25.363  19.144  1.00 50.04           C  
ATOM   1052  OH  TYR   145      15.524 -25.798  20.451  1.00 53.65           O  
ATOM   1053  N   ALA   146      15.602 -25.555  11.741  1.00 49.88           N  
ATOM   1054  CA  ALA   146      15.292 -25.302  10.345  1.00 50.90           C  
ATOM   1055  C   ALA   146      14.972 -26.581   9.602  1.00 52.22           C  
ATOM   1056  O   ALA   146      14.408 -26.522   8.507  1.00 52.25           O  
ATOM   1057  CB  ALA   146      16.440 -24.593   9.653  1.00 50.05           C  
ATOM   1058  N   THR   147      15.340 -27.724  10.190  1.00 53.87           N  
ATOM   1059  CA  THR   147      15.284 -29.020   9.494  1.00 54.91           C  
ATOM   1060  C   THR   147      14.885 -30.235  10.356  1.00 55.97           C  
ATOM   1061  O   THR   147      15.363 -30.403  11.483  1.00 55.90           O  
ATOM   1062  CB  THR   147      16.649 -29.340   8.805  1.00 55.15           C  
ATOM   1063  OG1 THR   147      17.733 -29.043   9.703  1.00 54.95           O  
ATOM   1064  CG2 THR   147      16.822 -28.514   7.524  1.00 55.67           C  
ATOM   1065  N   GLY   148      14.020 -31.085   9.788  1.00 57.03           N  
ATOM   1066  CA  GLY   148      13.682 -32.405  10.340  1.00 58.17           C  
ATOM   1067  C   GLY   148      12.993 -32.442  11.697  1.00 59.08           C  
ATOM   1068  O   GLY   148      12.159 -31.584  12.016  1.00 59.21           O  
ATOM   1069  N   GLU   149      13.354 -33.452  12.490  1.00 59.79           N  
ATOM   1070  CA  GLU   149      12.780 -33.700  13.825  1.00 60.24           C  
ATOM   1071  C   GLU   149      13.243 -32.700  14.895  1.00 60.72           C  
ATOM   1072  O   GLU   149      14.424 -32.708  15.283  1.00 61.14           O  
ATOM   1073  CB  GLU   149      13.135 -35.121  14.287  1.00 60.50           C  
ATOM   1074  CG  GLU   149      12.122 -36.220  13.932  1.00 60.05           C  
ATOM   1075  CD  GLU   149      11.038 -36.365  14.988  1.00 59.99           C  
ATOM   1076  OE1 GLU   149      10.594 -37.506  15.238  1.00 58.25           O  
ATOM   1077  OE2 GLU   149      10.638 -35.330  15.575  1.00 60.64           O  
ATOM   1078  N   PHE   150      12.312 -31.853  15.361  1.00 60.39           N  
ATOM   1079  CA  PHE   150      12.536 -30.943  16.513  1.00 60.35           C  
ATOM   1080  C   PHE   150      11.287 -30.683  17.391  1.00 59.56           C  
ATOM   1081  O   PHE   150      10.146 -30.940  16.985  1.00 59.84           O  
ATOM   1082  CB  PHE   150      13.215 -29.610  16.101  1.00 60.16           C  
ATOM   1083  CG  PHE   150      12.466 -28.833  15.057  1.00 61.05           C  
ATOM   1084  CD1 PHE   150      11.587 -27.820  15.425  1.00 62.70           C  
ATOM   1085  CD2 PHE   150      12.659 -29.093  13.697  1.00 62.07           C  
ATOM   1086  CE1 PHE   150      10.890 -27.086  14.451  1.00 62.87           C  
ATOM   1087  CE2 PHE   150      11.957 -28.387  12.708  1.00 63.06           C  
ATOM   1088  CZ  PHE   150      11.069 -27.377  13.087  1.00 63.13           C  
ATOM   1089  N   LYS   151      11.531 -30.222  18.613  1.00 58.08           N  
ATOM   1090  CA  LYS   151      10.482 -29.702  19.473  1.00 56.42           C  
ATOM   1091  C   LYS   151      10.831 -28.252  19.769  1.00 55.24           C  
ATOM   1092  O   LYS   151      12.015 -27.902  19.798  1.00 54.83           O  
ATOM   1093  CB  LYS   151      10.362 -30.540  20.750  1.00 57.09           C  
ATOM   1094  CG  LYS   151       9.370 -31.678  20.611  1.00 56.58           C  
ATOM   1095  CD  LYS   151       8.705 -31.985  21.949  1.00 59.54           C  
ATOM   1096  CE  LYS   151       7.414 -32.786  21.781  1.00 59.45           C  
ATOM   1097  NZ  LYS   151       6.864 -33.245  23.089  1.00 61.73           N  
ATOM   1098  N   VAL   152       9.824 -27.397  19.929  1.00 53.60           N  
ATOM   1099  CA  VAL   152      10.101 -25.999  20.303  1.00 53.08           C  
ATOM   1100  C   VAL   152       9.768 -25.697  21.790  1.00 52.22           C  
ATOM   1101  O   VAL   152       8.860 -26.281  22.367  1.00 51.30           O  
ATOM   1102  CB  VAL   152       9.599 -24.922  19.235  1.00 52.74           C  
ATOM   1103  CG1 VAL   152      10.068 -25.286  17.829  1.00 52.40           C  
ATOM   1104  CG2 VAL   152       8.128 -24.765  19.228  1.00 52.79           C  
ATOM   1105  N   ILE   153      10.568 -24.835  22.417  1.00 52.29           N  
ATOM   1106  CA  ILE   153      10.422 -24.558  23.848  1.00 52.31           C  
ATOM   1107  C   ILE   153      10.173 -23.064  24.121  1.00 51.77           C  
ATOM   1108  O   ILE   153      10.922 -22.204  23.637  1.00 51.74           O  
ATOM   1109  CB  ILE   153      11.666 -24.997  24.592  1.00 52.99           C  
ATOM   1110  CG1 ILE   153      11.771 -26.531  24.594  1.00 52.49           C  
ATOM   1111  CG2 ILE   153      11.651 -24.415  26.010  1.00 55.15           C  
ATOM   1112  CD1 ILE   153      13.034 -27.088  25.334  1.00 53.41           C  
ATOM   1113  N   GLN   154       9.086 -22.744  24.829  1.00 50.54           N  
ATOM   1114  CA  GLN   154       8.852 -21.355  25.219  1.00 49.09           C  
ATOM   1115  C   GLN   154       9.033 -21.316  26.726  1.00 48.53           C  
ATOM   1116  O   GLN   154       8.355 -22.092  27.425  1.00 47.25           O  
ATOM   1117  CB  GLN   154       7.471 -20.847  24.760  1.00 48.43           C  
ATOM   1118  CG  GLN   154       7.220 -19.364  25.065  1.00 49.16           C  
ATOM   1119  CD  GLN   154       5.802 -18.889  24.709  1.00 50.58           C  
ATOM   1120  OE1 GLN   154       4.958 -19.678  24.258  1.00 53.72           O  
ATOM   1121  NE2 GLN   154       5.535 -17.587  24.925  1.00 50.75           N  
END
