
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  133 (  965),  selected  133 , name 1g8k_F
# Molecule2: number of CA atoms  136 ( 1099),  selected  136 , name T0391.pdb
# PARAMETERS: 1g8k_F.T0391.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    R     1_F      -       -           -
LGA    T     2_F      -       -           -
LGA    T     3_F      -       -           -
LGA    L     4_F      -       -           -
LGA    A     5_F      K      14          3.233
LGA    Y     6_F      Y      15          1.896
LGA    P     7_F      T      16          4.592
LGA    A     8_F      S      17          2.634
LGA    T     9_F      V      18          1.517
LGA    A    10_F      C      19          1.246
LGA    V    11_F      V      20          0.737
LGA    S    12_F      G      21          0.992
LGA    V    13_F      R      22          2.066
LGA    A    14_F      E      23          1.410
LGA    K    15_F      E      24          2.587
LGA    N    16_F      D      25          2.431
LGA    L    17_F      I      26          1.624
LGA    A    18_F      R      27          1.993
LGA    A    19_F      K      28          5.168
LGA    N    20_F      S      29           #
LGA    E    21_F      E      30          2.435
LGA    P    22_F      R      31          1.251
LGA    V    23_F      M      32          0.281
LGA    S    24_F      T      33          1.162
LGA    F    25_F      A      34          1.145
LGA    T    26_F      V      35          1.912
LGA    Y    27_F      V      36          2.477
LGA    P    28_F      H      37          3.056
LGA    D    29_F      D      38          0.540
LGA    T    30_F      -       -           -
LGA    S    31_F      -       -           -
LGA    S    32_F      R      39          3.073
LGA    P    33_F      E      40          2.429
LGA    C    34_F      V      41          1.262
LGA    V    35_F      V      42          0.904
LGA    A    36_F      I      43          0.767
LGA    V    37_F      F      44          1.680
LGA    K    38_F      Y      45          1.349
LGA    L    39_F      H      46          0.496
LGA    G    40_F      K      47          2.604
LGA    A    41_F      -       -           -
LGA    P    42_F      -       -           -
LGA    V    43_F      -       -           -
LGA    P    44_F      -       -           -
LGA    G    45_F      -       -           -
LGA    G    46_F      -       -           -
LGA    V    47_F      -       -           -
LGA    G    48_F      -       -           -
LGA    P    49_F      -       -           -
LGA    D    50_F      G      48          4.104
LGA    D    51_F      -       -           -
LGA    D    52_F      E      49          0.670
LGA    I    53_F      Y      50          1.290
LGA    V    54_F      H      51          1.280
LGA    A    55_F      A      52          1.114
LGA    Y    56_F      M      53          0.956
LGA    S    57_F      D      54          0.778
LGA    V    58_F      I      55          2.120
LGA    L    59_F      R      56          2.199
LGA    C    60_F      C      57          2.479
LGA    T    61_F      Y      58          2.748
LGA    H    62_F      H      59          3.906
LGA    M    63_F      -       -           -
LGA    G    64_F      S      60          4.553
LGA    C    65_F      G      61          0.848
LGA    P    66_F      G      62          2.607
LGA    T    67_F      P      63          3.607
LGA    S    68_F      L      64          2.536
LGA    -       -      H      65           -
LGA    Y    69_F      L      66          4.232
LGA    D    70_F      G      67          3.074
LGA    S    71_F      E      68          3.359
LGA    S    72_F      I      69          4.846
LGA    S    73_F      E      70          1.727
LGA    -       -      D      71           -
LGA    -       -      F      72           -
LGA    -       -      N      73           -
LGA    -       -      G      74           -
LGA    -       -      Q      75           -
LGA    K    74_F      S      76           #
LGA    T    75_F      C      77          3.187
LGA    F    76_F      I      78          2.796
LGA    -       -      V      79           -
LGA    S    77_F      C      80          1.149
LGA    C    78_F      P      81           #
LGA    P    79_F      W      82          2.196
LGA    C    80_F      H      83          5.298
LGA    H    81_F      -       -           -
LGA    F    82_F      K      84          4.697
LGA    T    83_F      Y      85          2.543
LGA    E    84_F      K      86          1.899
LGA    F    85_F      I      87          0.543
LGA    D    86_F      T      88          2.243
LGA    A    87_F      L      89          2.015
LGA    E    88_F      -       -           -
LGA    K    89_F      A      90          3.592
LGA    A    90_F      T      91          2.598
LGA    G    91_F      G      92          2.251
LGA    Q    92_F      E      93          2.418
LGA    M    93_F      G      94          1.501
LGA    I    94_F      L      95          1.540
LGA    C    95_F      Y      96          2.546
LGA    G    96_F      Q      97           -
LGA    E    97_F      S      98           -
LGA    -       -      I      99           -
LGA    -       -      N     100           -
LGA    -       -      P     101           -
LGA    -       -      K     107           -
LGA    -       -      P     108           -
LGA    -       -      K     109           -
LGA    -       -      W     110           -
LGA    -       -      C     111           -
LGA    A    98_F      S     112           #
LGA    T    99_F      K     113          4.774
LGA    A   100_F      G     114          4.542
LGA    D   101_F      V     115          2.404
LGA    -       -      K     116           -
LGA    L   102_F      Q     117          1.559
LGA    P   103_F      R     118          1.072
LGA    R   104_F      I     119          0.965
LGA    V   105_F      H     120          1.504
LGA    L   106_F      T     121          0.670
LGA    L   107_F      V     122          1.574
LGA    R   108_F      K     123          2.464
LGA    Y   109_F      V     124          1.761
LGA    D   110_F      D     125          1.461
LGA    A   111_F      N     126          3.382
LGA    A   112_F      -       -           -
LGA    S   113_F      -       -           -
LGA    D   114_F      G     127          1.754
LGA    A   115_F      N     128          1.492
LGA    L   116_F      I     129          1.331
LGA    T   117_F      Y     130          1.203
LGA    A   118_F      V     131          0.966
LGA    V   119_F      T     132          1.457
LGA    G   120_F      L     133          2.324
LGA    V   121_F      S     134          1.585
LGA    -       -      K     135           -
LGA    D   122_F      E     136          3.898
LGA    G   123_F      P     137          3.923
LGA    -       -      F     138           -
LGA    L   124_F      K     139          4.032
LGA    I   125_F      C     140           #
LGA    -       -      D     141           -
LGA    -       -      S     142           -
LGA    Y   126_F      D     143          1.618
LGA    G   127_F      Y     144          1.611
LGA    -       -      Y     145           -
LGA    -       -      A     146           -
LGA    R   128_F      T     147          4.793
LGA    Q   129_F      G     148           -
LGA    A   130_F      E     149           -
LGA    N   131_F      F     150           -
LGA    V   132_F      K     151           -
LGA    I   133_F      V     152           -
LGA    -       -      I     153           -
LGA    -       -      Q     154           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  133  136    5.0    100    2.54    10.00     48.684     3.788

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.829426 * X  +  -0.552338 * Y  +  -0.083521 * Z  +  11.120933
  Y_new =  -0.411383 * X  +  -0.705097 * Y  +   0.577583 * Z  + -75.159302
  Z_new =  -0.377912 * X  +  -0.444703 * Y  +  -0.812048 * Z  +  48.559849 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.640570    0.501023  [ DEG:  -151.2935     28.7065 ]
  Theta =   0.387540    2.754053  [ DEG:    22.2044    157.7956 ]
  Phi   =  -0.460431    2.681162  [ DEG:   -26.3807    153.6193 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1g8k_F                                        
REMARK     2: T0391.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1g8k_F.T0391.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  133  136   5.0  100   2.54   10.00  48.684
REMARK  ---------------------------------------------------------- 
MOLECULE 1g8k_F
HEADER    OXIDOREDUCTASE                          17-NOV-00   1G8K              
TITLE     CRYSTAL STRUCTURE ANALYSIS OF ARSENITE OXIDASE FROM                   
TITLE    2 ALCALIGENES FAECALIS                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ARSENITE OXIDASE;                                          
COMPND   3 CHAIN: A, C, E, G;                                                   
COMPND   4 MOL_ID: 2;                                                           
COMPND   5 MOLECULE: ARSENITE OXIDASE;                                          
COMPND   6 CHAIN: B, D, F, H                                                    
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ALCALIGENES FAECALIS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: NCIB 8687;                                                   
SOURCE   5 MOL_ID: 2;                                                           
SOURCE   6 ORGANISM_SCIENTIFIC: ALCALIGENES FAECALIS;                           
SOURCE   7 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   8 STRAIN: NCIB 8687                                                    
KEYWDS    OXIDASE, ARSENITE, MOLYBDOPTERIN, [3FE-4S] CLUSTER, [2FE-             
KEYWDS   2 2S] CLUSTER, RIESKE                                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.J.ELLIS,T.CONRADS,R.HILLE,P.KUHN                                    
REVDAT   2   28-MAR-01 1G8K    1       JRNL                                     
REVDAT   1   13-DEC-00 1G8K    0                                                
JRNL        AUTH   P.J.ELLIS,T.CONRADS,R.HILLE,P.KUHN                           
JRNL        TITL   CRYSTAL STRUCTURE OF THE 100 KDA ARSENITE OXIDASE            
JRNL        TITL 2 FROM ALCALIGENES FAECALIS IN TWO CRYSTAL FORMS AT            
JRNL        TITL 3 1.64 A AND 2.03 A.                                           
JRNL        REF    STRUCTURE                     V.   9   125 2001              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 1.64 ANGSTROMS.                                          
DBREF  1G8K A    1   825  UNP    Q7SIF4   AOXB_ALCFA       1    825             
DBREF  1G8K B    1   133  UNP    Q7SIF3   ARSS_ALCFA       1    133             
DBREF  1G8K C    1   825  UNP    Q7SIF4   AOXB_ALCFA       1    825             
DBREF  1G8K D    1   133  UNP    Q7SIF3   ARSS_ALCFA       1    133             
DBREF  1G8K E    1   825  UNP    Q7SIF4   AOXB_ALCFA       1    825             
DBREF  1G8K F    1   133  UNP    Q7SIF3   ARSS_ALCFA       1    133             
DBREF  1G8K G    1   825  UNP    Q7SIF4   AOXB_ALCFA       1    825             
DBREF  1G8K H    1   133  UNP    Q7SIF3   ARSS_ALCFA       1    133             
SEQRES   1 A  825  GLY CYS PRO ASN ASP ARG ILE THR LEU PRO PRO ALA ASN          
SEQRES   2 A  825  ALA GLN ARG THR ASN MET THR CYS HIS PHE CYS ILE VAL          
SEQRES   3 A  825  GLY CYS GLY TYR HIS VAL TYR LYS TRP PRO GLU LEU GLU          
SEQRES   4 A  825  GLU GLY GLY ARG ALA PRO GLU GLN ASN ALA LEU GLY LEU          
SEQRES   5 A  825  ASP PHE ARG LYS GLN LEU PRO PRO LEU ALA VAL THR LEU          
SEQRES   6 A  825  THR PRO ALA MET THR ASN VAL VAL THR GLU HIS ASP GLY          
SEQRES   7 A  825  ALA ARG TYR ASP ILE MET VAL VAL PRO ASP LYS ALA CYS          
SEQRES   8 A  825  VAL VAL ASN SER GLY LEU SER SER THR ARG GLY GLY LYS          
SEQRES   9 A  825  MET ALA SER TYR MET TYR THR PRO THR GLY ASP GLY LYS          
SEQRES  10 A  825  GLU ARG LEU SER ALA PRO ARG LEU TYR ALA ALA ASP GLU          
SEQRES  11 A  825  TRP VAL ASP THR THR TRP ASP HIS ALA MET ALA LEU TYR          
SEQRES  12 A  825  ALA GLY LEU ILE LYS LYS THR LEU ASP LYS ASP GLY PRO          
SEQRES  13 A  825  GLN GLY VAL PHE PHE SER CYS PHE ASP HIS GLY GLY ALA          
SEQRES  14 A  825  GLY GLY GLY PHE GLU ASN THR TRP GLY THR GLY LYS LEU          
SEQRES  15 A  825  MET PHE SER ALA ILE GLN THR PRO MET VAL ARG ILE HIS          
SEQRES  16 A  825  ASN ARG PRO ALA TYR ASN SER GLU CYS HIS ALA THR ARG          
SEQRES  17 A  825  GLU MET GLY ILE GLY GLU LEU ASN ASN ALA TYR GLU ASP          
SEQRES  18 A  825  ALA GLN LEU ALA ASP VAL ILE TRP SER ILE GLY ASN ASN          
SEQRES  19 A  825  PRO TYR GLU SER GLN THR ASN TYR PHE LEU ASN HIS TRP          
SEQRES  20 A  825  LEU PRO ASN LEU GLN GLY ALA THR THR SER LYS LYS LYS          
SEQRES  21 A  825  GLU ARG PHE PRO ASN GLU ASN PHE PRO GLN ALA ARG ILE          
SEQRES  22 A  825  ILE PHE VAL ASP PRO ARG GLU THR PRO SER VAL ALA ILE          
SEQRES  23 A  825  ALA ARG HIS VAL ALA GLY ASN ASP ARG VAL LEU HIS LEU          
SEQRES  24 A  825  ALA ILE GLU PRO GLY THR ASP THR ALA LEU PHE ASN GLY          
SEQRES  25 A  825  LEU PHE THR TYR VAL VAL GLU GLN GLY TRP ILE ASP LYS          
SEQRES  26 A  825  PRO PHE ILE GLU ALA HIS THR LYS GLY PHE ASP ASP ALA          
SEQRES  27 A  825  VAL LYS THR ASN ARG LEU SER LEU ASP GLU CYS SER ASN          
SEQRES  28 A  825  ILE THR GLY VAL PRO VAL ASP MET LEU LYS ARG ALA ALA          
SEQRES  29 A  825  GLU TRP SER TYR LYS PRO LYS ALA SER GLY GLN ALA PRO          
SEQRES  30 A  825  ARG THR MET HIS ALA TYR GLU LYS GLY ILE ILE TRP GLY          
SEQRES  31 A  825  ASN ASP ASN TYR VAL ILE GLN SER ALA LEU LEU ASP LEU          
SEQRES  32 A  825  VAL ILE ALA THR HIS ASN VAL GLY ARG ARG GLY THR GLY          
SEQRES  33 A  825  CYS VAL ARG MET GLY GLY HIS GLN GLU GLY TYR THR ARG          
SEQRES  34 A  825  PRO PRO TYR PRO GLY ASP LYS LYS ILE TYR ILE ASP GLN          
SEQRES  35 A  825  GLU LEU ILE LYS GLY LYS GLY ARG ILE MET THR TRP TRP          
SEQRES  36 A  825  GLY CYS ASN ASN PHE GLN THR SER ASN ASN ALA GLN ALA          
SEQRES  37 A  825  LEU ARG GLU ALA ILE LEU GLN ARG SER ALA ILE VAL LYS          
SEQRES  38 A  825  GLN ALA MET GLN LYS ALA ARG GLY ALA THR THR GLU GLU          
SEQRES  39 A  825  MET VAL ASP VAL ILE TYR GLU ALA THR GLN ASN GLY GLY          
SEQRES  40 A  825  LEU PHE VAL THR SER ILE ASN LEU TYR PRO THR LYS LEU          
SEQRES  41 A  825  ALA GLU ALA ALA HIS LEU MET LEU PRO ALA ALA HIS PRO          
SEQRES  42 A  825  GLY GLU MET ASN LEU THR SER MET ASN GLY GLU ARG ARG          
SEQRES  43 A  825  ILE ARG LEU SER GLU LYS PHE MET ASP PRO PRO GLY THR          
SEQRES  44 A  825  ALA MET ALA ASP CYS LEU ILE ALA ALA ARG ILE ALA ASN          
SEQRES  45 A  825  ALA LEU ARG ASP MET TYR GLN LYS ASP GLY LYS ALA GLU          
SEQRES  46 A  825  MET ALA ALA GLN PHE GLU GLY PHE ASP TRP LYS THR GLU          
SEQRES  47 A  825  GLU ASP ALA PHE ASN ASP GLY PHE ARG ARG ALA GLY GLN          
SEQRES  48 A  825  PRO GLY ALA PRO ALA ILE ASP SER GLN GLY GLY SER THR          
SEQRES  49 A  825  GLY HIS LEU VAL THR TYR ASP ARG LEU ARG LYS SER GLY          
SEQRES  50 A  825  ASN ASN GLY VAL GLN LEU PRO VAL VAL SER TRP ASP GLU          
SEQRES  51 A  825  SER LYS GLY LEU VAL GLY THR GLU MET LEU TYR THR GLU          
SEQRES  52 A  825  GLY LYS PHE ASP THR ASP ASP GLY LYS ALA HIS PHE LYS          
SEQRES  53 A  825  PRO ALA PRO TRP ASN GLY LEU PRO ALA THR VAL GLN GLN          
SEQRES  54 A  825  GLN LYS ASP LYS TYR ARG PHE TRP LEU ASN ASN GLY ARG          
SEQRES  55 A  825  ASN ASN GLU VAL TRP GLN THR ALA TYR HIS ASP GLN TYR          
SEQRES  56 A  825  ASN SER LEU MET GLN GLU ARG TYR PRO MET ALA TYR ILE          
SEQRES  57 A  825  GLU MET ASN PRO ASP ASP CYS LYS GLN LEU ASP VAL THR          
SEQRES  58 A  825  GLY GLY ASP ILE VAL GLU VAL TYR ASN ASP PHE GLY SER          
SEQRES  59 A  825  THR PHE ALA MET VAL TYR PRO VAL ALA GLU ILE LYS ARG          
SEQRES  60 A  825  GLY GLN THR PHE MET LEU PHE GLY TYR VAL ASN GLY ILE          
SEQRES  61 A  825  GLN GLY ASP VAL THR THR ASP TRP THR ASP ARG ASP ILE          
SEQRES  62 A  825  ILE PRO TYR TYR LYS GLY THR TRP GLY ASP ILE ARG LYS          
SEQRES  63 A  825  VAL GLY SER MET SER GLU PHE LYS ARG THR VAL SER PHE          
SEQRES  64 A  825  LYS SER ARG ARG PHE GLY                                      
SEQRES   1 B  133  ARG THR THR LEU ALA TYR PRO ALA THR ALA VAL SER VAL          
SEQRES   2 B  133  ALA LYS ASN LEU ALA ALA ASN GLU PRO VAL SER PHE THR          
SEQRES   3 B  133  TYR PRO ASP THR SER SER PRO CYS VAL ALA VAL LYS LEU          
SEQRES   4 B  133  GLY ALA PRO VAL PRO GLY GLY VAL GLY PRO ASP ASP ASP          
SEQRES   5 B  133  ILE VAL ALA TYR SER VAL LEU CYS THR HIS MET GLY CYS          
SEQRES   6 B  133  PRO THR SER TYR ASP SER SER SER LYS THR PHE SER CYS          
SEQRES   7 B  133  PRO CYS HIS PHE THR GLU PHE ASP ALA GLU LYS ALA GLY          
SEQRES   8 B  133  GLN MET ILE CYS GLY GLU ALA THR ALA ASP LEU PRO ARG          
SEQRES   9 B  133  VAL LEU LEU ARG TYR ASP ALA ALA SER ASP ALA LEU THR          
SEQRES  10 B  133  ALA VAL GLY VAL ASP GLY LEU ILE TYR GLY ARG GLN ALA          
SEQRES  11 B  133  ASN VAL ILE                                                  
SEQRES   1 C  825  GLY CYS PRO ASN ASP ARG ILE THR LEU PRO PRO ALA ASN          
SEQRES   2 C  825  ALA GLN ARG THR ASN MET THR CYS HIS PHE CYS ILE VAL          
SEQRES   3 C  825  GLY CYS GLY TYR HIS VAL TYR LYS TRP PRO GLU LEU GLU          
SEQRES   4 C  825  GLU GLY GLY ARG ALA PRO GLU GLN ASN ALA LEU GLY LEU          
SEQRES   5 C  825  ASP PHE ARG LYS GLN LEU PRO PRO LEU ALA VAL THR LEU          
SEQRES   6 C  825  THR PRO ALA MET THR ASN VAL VAL THR GLU HIS ASP GLY          
SEQRES   7 C  825  ALA ARG TYR ASP ILE MET VAL VAL PRO ASP LYS ALA CYS          
SEQRES   8 C  825  VAL VAL ASN SER GLY LEU SER SER THR ARG GLY GLY LYS          
SEQRES   9 C  825  MET ALA SER TYR MET TYR THR PRO THR GLY ASP GLY LYS          
SEQRES  10 C  825  GLU ARG LEU SER ALA PRO ARG LEU TYR ALA ALA ASP GLU          
SEQRES  11 C  825  TRP VAL ASP THR THR TRP ASP HIS ALA MET ALA LEU TYR          
SEQRES  12 C  825  ALA GLY LEU ILE LYS LYS THR LEU ASP LYS ASP GLY PRO          
SEQRES  13 C  825  GLN GLY VAL PHE PHE SER CYS PHE ASP HIS GLY GLY ALA          
SEQRES  14 C  825  GLY GLY GLY PHE GLU ASN THR TRP GLY THR GLY LYS LEU          
SEQRES  15 C  825  MET PHE SER ALA ILE GLN THR PRO MET VAL ARG ILE HIS          
SEQRES  16 C  825  ASN ARG PRO ALA TYR ASN SER GLU CYS HIS ALA THR ARG          
SEQRES  17 C  825  GLU MET GLY ILE GLY GLU LEU ASN ASN ALA TYR GLU ASP          
SEQRES  18 C  825  ALA GLN LEU ALA ASP VAL ILE TRP SER ILE GLY ASN ASN          
SEQRES  19 C  825  PRO TYR GLU SER GLN THR ASN TYR PHE LEU ASN HIS TRP          
SEQRES  20 C  825  LEU PRO ASN LEU GLN GLY ALA THR THR SER LYS LYS LYS          
SEQRES  21 C  825  GLU ARG PHE PRO ASN GLU ASN PHE PRO GLN ALA ARG ILE          
SEQRES  22 C  825  ILE PHE VAL ASP PRO ARG GLU THR PRO SER VAL ALA ILE          
SEQRES  23 C  825  ALA ARG HIS VAL ALA GLY ASN ASP ARG VAL LEU HIS LEU          
SEQRES  24 C  825  ALA ILE GLU PRO GLY THR ASP THR ALA LEU PHE ASN GLY          
SEQRES  25 C  825  LEU PHE THR TYR VAL VAL GLU GLN GLY TRP ILE ASP LYS          
SEQRES  26 C  825  PRO PHE ILE GLU ALA HIS THR LYS GLY PHE ASP ASP ALA          
SEQRES  27 C  825  VAL LYS THR ASN ARG LEU SER LEU ASP GLU CYS SER ASN          
SEQRES  28 C  825  ILE THR GLY VAL PRO VAL ASP MET LEU LYS ARG ALA ALA          
SEQRES  29 C  825  GLU TRP SER TYR LYS PRO LYS ALA SER GLY GLN ALA PRO          
SEQRES  30 C  825  ARG THR MET HIS ALA TYR GLU LYS GLY ILE ILE TRP GLY          
SEQRES  31 C  825  ASN ASP ASN TYR VAL ILE GLN SER ALA LEU LEU ASP LEU          
SEQRES  32 C  825  VAL ILE ALA THR HIS ASN VAL GLY ARG ARG GLY THR GLY          
SEQRES  33 C  825  CYS VAL ARG MET GLY GLY HIS GLN GLU GLY TYR THR ARG          
SEQRES  34 C  825  PRO PRO TYR PRO GLY ASP LYS LYS ILE TYR ILE ASP GLN          
SEQRES  35 C  825  GLU LEU ILE LYS GLY LYS GLY ARG ILE MET THR TRP TRP          
SEQRES  36 C  825  GLY CYS ASN ASN PHE GLN THR SER ASN ASN ALA GLN ALA          
SEQRES  37 C  825  LEU ARG GLU ALA ILE LEU GLN ARG SER ALA ILE VAL LYS          
SEQRES  38 C  825  GLN ALA MET GLN LYS ALA ARG GLY ALA THR THR GLU GLU          
SEQRES  39 C  825  MET VAL ASP VAL ILE TYR GLU ALA THR GLN ASN GLY GLY          
SEQRES  40 C  825  LEU PHE VAL THR SER ILE ASN LEU TYR PRO THR LYS LEU          
SEQRES  41 C  825  ALA GLU ALA ALA HIS LEU MET LEU PRO ALA ALA HIS PRO          
SEQRES  42 C  825  GLY GLU MET ASN LEU THR SER MET ASN GLY GLU ARG ARG          
SEQRES  43 C  825  ILE ARG LEU SER GLU LYS PHE MET ASP PRO PRO GLY THR          
SEQRES  44 C  825  ALA MET ALA ASP CYS LEU ILE ALA ALA ARG ILE ALA ASN          
SEQRES  45 C  825  ALA LEU ARG ASP MET TYR GLN LYS ASP GLY LYS ALA GLU          
SEQRES  46 C  825  MET ALA ALA GLN PHE GLU GLY PHE ASP TRP LYS THR GLU          
SEQRES  47 C  825  GLU ASP ALA PHE ASN ASP GLY PHE ARG ARG ALA GLY GLN          
SEQRES  48 C  825  PRO GLY ALA PRO ALA ILE ASP SER GLN GLY GLY SER THR          
SEQRES  49 C  825  GLY HIS LEU VAL THR TYR ASP ARG LEU ARG LYS SER GLY          
SEQRES  50 C  825  ASN ASN GLY VAL GLN LEU PRO VAL VAL SER TRP ASP GLU          
SEQRES  51 C  825  SER LYS GLY LEU VAL GLY THR GLU MET LEU TYR THR GLU          
SEQRES  52 C  825  GLY LYS PHE ASP THR ASP ASP GLY LYS ALA HIS PHE LYS          
SEQRES  53 C  825  PRO ALA PRO TRP ASN GLY LEU PRO ALA THR VAL GLN GLN          
SEQRES  54 C  825  GLN LYS ASP LYS TYR ARG PHE TRP LEU ASN ASN GLY ARG          
SEQRES  55 C  825  ASN ASN GLU VAL TRP GLN THR ALA TYR HIS ASP GLN TYR          
SEQRES  56 C  825  ASN SER LEU MET GLN GLU ARG TYR PRO MET ALA TYR ILE          
SEQRES  57 C  825  GLU MET ASN PRO ASP ASP CYS LYS GLN LEU ASP VAL THR          
SEQRES  58 C  825  GLY GLY ASP ILE VAL GLU VAL TYR ASN ASP PHE GLY SER          
SEQRES  59 C  825  THR PHE ALA MET VAL TYR PRO VAL ALA GLU ILE LYS ARG          
SEQRES  60 C  825  GLY GLN THR PHE MET LEU PHE GLY TYR VAL ASN GLY ILE          
SEQRES  61 C  825  GLN GLY ASP VAL THR THR ASP TRP THR ASP ARG ASP ILE          
SEQRES  62 C  825  ILE PRO TYR TYR LYS GLY THR TRP GLY ASP ILE ARG LYS          
SEQRES  63 C  825  VAL GLY SER MET SER GLU PHE LYS ARG THR VAL SER PHE          
SEQRES  64 C  825  LYS SER ARG ARG PHE GLY                                      
SEQRES   1 D  133  ARG THR THR LEU ALA TYR PRO ALA THR ALA VAL SER VAL          
SEQRES   2 D  133  ALA LYS ASN LEU ALA ALA ASN GLU PRO VAL SER PHE THR          
SEQRES   3 D  133  TYR PRO ASP THR SER SER PRO CYS VAL ALA VAL LYS LEU          
SEQRES   4 D  133  GLY ALA PRO VAL PRO GLY GLY VAL GLY PRO ASP ASP ASP          
SEQRES   5 D  133  ILE VAL ALA TYR SER VAL LEU CYS THR HIS MET GLY CYS          
SEQRES   6 D  133  PRO THR SER TYR ASP SER SER SER LYS THR PHE SER CYS          
SEQRES   7 D  133  PRO CYS HIS PHE THR GLU PHE ASP ALA GLU LYS ALA GLY          
SEQRES   8 D  133  GLN MET ILE CYS GLY GLU ALA THR ALA ASP LEU PRO ARG          
SEQRES   9 D  133  VAL LEU LEU ARG TYR ASP ALA ALA SER ASP ALA LEU THR          
SEQRES  10 D  133  ALA VAL GLY VAL ASP GLY LEU ILE TYR GLY ARG GLN ALA          
SEQRES  11 D  133  ASN VAL ILE                                                  
SEQRES   1 E  825  GLY CYS PRO ASN ASP ARG ILE THR LEU PRO PRO ALA ASN          
SEQRES   2 E  825  ALA GLN ARG THR ASN MET THR CYS HIS PHE CYS ILE VAL          
SEQRES   3 E  825  GLY CYS GLY TYR HIS VAL TYR LYS TRP PRO GLU LEU GLU          
SEQRES   4 E  825  GLU GLY GLY ARG ALA PRO GLU GLN ASN ALA LEU GLY LEU          
SEQRES   5 E  825  ASP PHE ARG LYS GLN LEU PRO PRO LEU ALA VAL THR LEU          
SEQRES   6 E  825  THR PRO ALA MET THR ASN VAL VAL THR GLU HIS ASP GLY          
SEQRES   7 E  825  ALA ARG TYR ASP ILE MET VAL VAL PRO ASP LYS ALA CYS          
SEQRES   8 E  825  VAL VAL ASN SER GLY LEU SER SER THR ARG GLY GLY LYS          
SEQRES   9 E  825  MET ALA SER TYR MET TYR THR PRO THR GLY ASP GLY LYS          
SEQRES  10 E  825  GLU ARG LEU SER ALA PRO ARG LEU TYR ALA ALA ASP GLU          
SEQRES  11 E  825  TRP VAL ASP THR THR TRP ASP HIS ALA MET ALA LEU TYR          
SEQRES  12 E  825  ALA GLY LEU ILE LYS LYS THR LEU ASP LYS ASP GLY PRO          
SEQRES  13 E  825  GLN GLY VAL PHE PHE SER CYS PHE ASP HIS GLY GLY ALA          
SEQRES  14 E  825  GLY GLY GLY PHE GLU ASN THR TRP GLY THR GLY LYS LEU          
SEQRES  15 E  825  MET PHE SER ALA ILE GLN THR PRO MET VAL ARG ILE HIS          
SEQRES  16 E  825  ASN ARG PRO ALA TYR ASN SER GLU CYS HIS ALA THR ARG          
SEQRES  17 E  825  GLU MET GLY ILE GLY GLU LEU ASN ASN ALA TYR GLU ASP          
SEQRES  18 E  825  ALA GLN LEU ALA ASP VAL ILE TRP SER ILE GLY ASN ASN          
SEQRES  19 E  825  PRO TYR GLU SER GLN THR ASN TYR PHE LEU ASN HIS TRP          
SEQRES  20 E  825  LEU PRO ASN LEU GLN GLY ALA THR THR SER LYS LYS LYS          
SEQRES  21 E  825  GLU ARG PHE PRO ASN GLU ASN PHE PRO GLN ALA ARG ILE          
SEQRES  22 E  825  ILE PHE VAL ASP PRO ARG GLU THR PRO SER VAL ALA ILE          
SEQRES  23 E  825  ALA ARG HIS VAL ALA GLY ASN ASP ARG VAL LEU HIS LEU          
SEQRES  24 E  825  ALA ILE GLU PRO GLY THR ASP THR ALA LEU PHE ASN GLY          
SEQRES  25 E  825  LEU PHE THR TYR VAL VAL GLU GLN GLY TRP ILE ASP LYS          
SEQRES  26 E  825  PRO PHE ILE GLU ALA HIS THR LYS GLY PHE ASP ASP ALA          
SEQRES  27 E  825  VAL LYS THR ASN ARG LEU SER LEU ASP GLU CYS SER ASN          
SEQRES  28 E  825  ILE THR GLY VAL PRO VAL ASP MET LEU LYS ARG ALA ALA          
SEQRES  29 E  825  GLU TRP SER TYR LYS PRO LYS ALA SER GLY GLN ALA PRO          
SEQRES  30 E  825  ARG THR MET HIS ALA TYR GLU LYS GLY ILE ILE TRP GLY          
SEQRES  31 E  825  ASN ASP ASN TYR VAL ILE GLN SER ALA LEU LEU ASP LEU          
SEQRES  32 E  825  VAL ILE ALA THR HIS ASN VAL GLY ARG ARG GLY THR GLY          
SEQRES  33 E  825  CYS VAL ARG MET GLY GLY HIS GLN GLU GLY TYR THR ARG          
SEQRES  34 E  825  PRO PRO TYR PRO GLY ASP LYS LYS ILE TYR ILE ASP GLN          
SEQRES  35 E  825  GLU LEU ILE LYS GLY LYS GLY ARG ILE MET THR TRP TRP          
SEQRES  36 E  825  GLY CYS ASN ASN PHE GLN THR SER ASN ASN ALA GLN ALA          
SEQRES  37 E  825  LEU ARG GLU ALA ILE LEU GLN ARG SER ALA ILE VAL LYS          
SEQRES  38 E  825  GLN ALA MET GLN LYS ALA ARG GLY ALA THR THR GLU GLU          
SEQRES  39 E  825  MET VAL ASP VAL ILE TYR GLU ALA THR GLN ASN GLY GLY          
SEQRES  40 E  825  LEU PHE VAL THR SER ILE ASN LEU TYR PRO THR LYS LEU          
SEQRES  41 E  825  ALA GLU ALA ALA HIS LEU MET LEU PRO ALA ALA HIS PRO          
SEQRES  42 E  825  GLY GLU MET ASN LEU THR SER MET ASN GLY GLU ARG ARG          
SEQRES  43 E  825  ILE ARG LEU SER GLU LYS PHE MET ASP PRO PRO GLY THR          
SEQRES  44 E  825  ALA MET ALA ASP CYS LEU ILE ALA ALA ARG ILE ALA ASN          
SEQRES  45 E  825  ALA LEU ARG ASP MET TYR GLN LYS ASP GLY LYS ALA GLU          
SEQRES  46 E  825  MET ALA ALA GLN PHE GLU GLY PHE ASP TRP LYS THR GLU          
SEQRES  47 E  825  GLU ASP ALA PHE ASN ASP GLY PHE ARG ARG ALA GLY GLN          
SEQRES  48 E  825  PRO GLY ALA PRO ALA ILE ASP SER GLN GLY GLY SER THR          
SEQRES  49 E  825  GLY HIS LEU VAL THR TYR ASP ARG LEU ARG LYS SER GLY          
SEQRES  50 E  825  ASN ASN GLY VAL GLN LEU PRO VAL VAL SER TRP ASP GLU          
SEQRES  51 E  825  SER LYS GLY LEU VAL GLY THR GLU MET LEU TYR THR GLU          
SEQRES  52 E  825  GLY LYS PHE ASP THR ASP ASP GLY LYS ALA HIS PHE LYS          
SEQRES  53 E  825  PRO ALA PRO TRP ASN GLY LEU PRO ALA THR VAL GLN GLN          
SEQRES  54 E  825  GLN LYS ASP LYS TYR ARG PHE TRP LEU ASN ASN GLY ARG          
SEQRES  55 E  825  ASN ASN GLU VAL TRP GLN THR ALA TYR HIS ASP GLN TYR          
SEQRES  56 E  825  ASN SER LEU MET GLN GLU ARG TYR PRO MET ALA TYR ILE          
SEQRES  57 E  825  GLU MET ASN PRO ASP ASP CYS LYS GLN LEU ASP VAL THR          
SEQRES  58 E  825  GLY GLY ASP ILE VAL GLU VAL TYR ASN ASP PHE GLY SER          
SEQRES  59 E  825  THR PHE ALA MET VAL TYR PRO VAL ALA GLU ILE LYS ARG          
SEQRES  60 E  825  GLY GLN THR PHE MET LEU PHE GLY TYR VAL ASN GLY ILE          
SEQRES  61 E  825  GLN GLY ASP VAL THR THR ASP TRP THR ASP ARG ASP ILE          
SEQRES  62 E  825  ILE PRO TYR TYR LYS GLY THR TRP GLY ASP ILE ARG LYS          
SEQRES  63 E  825  VAL GLY SER MET SER GLU PHE LYS ARG THR VAL SER PHE          
SEQRES  64 E  825  LYS SER ARG ARG PHE GLY                                      
SEQRES   1 F  133  ARG THR THR LEU ALA TYR PRO ALA THR ALA VAL SER VAL          
SEQRES   2 F  133  ALA LYS ASN LEU ALA ALA ASN GLU PRO VAL SER PHE THR          
SEQRES   3 F  133  TYR PRO ASP THR SER SER PRO CYS VAL ALA VAL LYS LEU          
SEQRES   4 F  133  GLY ALA PRO VAL PRO GLY GLY VAL GLY PRO ASP ASP ASP          
SEQRES   5 F  133  ILE VAL ALA TYR SER VAL LEU CYS THR HIS MET GLY CYS          
SEQRES   6 F  133  PRO THR SER TYR ASP SER SER SER LYS THR PHE SER CYS          
SEQRES   7 F  133  PRO CYS HIS PHE THR GLU PHE ASP ALA GLU LYS ALA GLY          
SEQRES   8 F  133  GLN MET ILE CYS GLY GLU ALA THR ALA ASP LEU PRO ARG          
SEQRES   9 F  133  VAL LEU LEU ARG TYR ASP ALA ALA SER ASP ALA LEU THR          
SEQRES  10 F  133  ALA VAL GLY VAL ASP GLY LEU ILE TYR GLY ARG GLN ALA          
SEQRES  11 F  133  ASN VAL ILE                                                  
SEQRES   1 G  825  GLY CYS PRO ASN ASP ARG ILE THR LEU PRO PRO ALA ASN          
SEQRES   2 G  825  ALA GLN ARG THR ASN MET THR CYS HIS PHE CYS ILE VAL          
SEQRES   3 G  825  GLY CYS GLY TYR HIS VAL TYR LYS TRP PRO GLU LEU GLU          
SEQRES   4 G  825  GLU GLY GLY ARG ALA PRO GLU GLN ASN ALA LEU GLY LEU          
SEQRES   5 G  825  ASP PHE ARG LYS GLN LEU PRO PRO LEU ALA VAL THR LEU          
SEQRES   6 G  825  THR PRO ALA MET THR ASN VAL VAL THR GLU HIS ASP GLY          
SEQRES   7 G  825  ALA ARG TYR ASP ILE MET VAL VAL PRO ASP LYS ALA CYS          
SEQRES   8 G  825  VAL VAL ASN SER GLY LEU SER SER THR ARG GLY GLY LYS          
SEQRES   9 G  825  MET ALA SER TYR MET TYR THR PRO THR GLY ASP GLY LYS          
SEQRES  10 G  825  GLU ARG LEU SER ALA PRO ARG LEU TYR ALA ALA ASP GLU          
SEQRES  11 G  825  TRP VAL ASP THR THR TRP ASP HIS ALA MET ALA LEU TYR          
SEQRES  12 G  825  ALA GLY LEU ILE LYS LYS THR LEU ASP LYS ASP GLY PRO          
SEQRES  13 G  825  GLN GLY VAL PHE PHE SER CYS PHE ASP HIS GLY GLY ALA          
SEQRES  14 G  825  GLY GLY GLY PHE GLU ASN THR TRP GLY THR GLY LYS LEU          
SEQRES  15 G  825  MET PHE SER ALA ILE GLN THR PRO MET VAL ARG ILE HIS          
SEQRES  16 G  825  ASN ARG PRO ALA TYR ASN SER GLU CYS HIS ALA THR ARG          
SEQRES  17 G  825  GLU MET GLY ILE GLY GLU LEU ASN ASN ALA TYR GLU ASP          
SEQRES  18 G  825  ALA GLN LEU ALA ASP VAL ILE TRP SER ILE GLY ASN ASN          
SEQRES  19 G  825  PRO TYR GLU SER GLN THR ASN TYR PHE LEU ASN HIS TRP          
SEQRES  20 G  825  LEU PRO ASN LEU GLN GLY ALA THR THR SER LYS LYS LYS          
SEQRES  21 G  825  GLU ARG PHE PRO ASN GLU ASN PHE PRO GLN ALA ARG ILE          
SEQRES  22 G  825  ILE PHE VAL ASP PRO ARG GLU THR PRO SER VAL ALA ILE          
SEQRES  23 G  825  ALA ARG HIS VAL ALA GLY ASN ASP ARG VAL LEU HIS LEU          
SEQRES  24 G  825  ALA ILE GLU PRO GLY THR ASP THR ALA LEU PHE ASN GLY          
SEQRES  25 G  825  LEU PHE THR TYR VAL VAL GLU GLN GLY TRP ILE ASP LYS          
SEQRES  26 G  825  PRO PHE ILE GLU ALA HIS THR LYS GLY PHE ASP ASP ALA          
SEQRES  27 G  825  VAL LYS THR ASN ARG LEU SER LEU ASP GLU CYS SER ASN          
SEQRES  28 G  825  ILE THR GLY VAL PRO VAL ASP MET LEU LYS ARG ALA ALA          
SEQRES  29 G  825  GLU TRP SER TYR LYS PRO LYS ALA SER GLY GLN ALA PRO          
SEQRES  30 G  825  ARG THR MET HIS ALA TYR GLU LYS GLY ILE ILE TRP GLY          
SEQRES  31 G  825  ASN ASP ASN TYR VAL ILE GLN SER ALA LEU LEU ASP LEU          
SEQRES  32 G  825  VAL ILE ALA THR HIS ASN VAL GLY ARG ARG GLY THR GLY          
SEQRES  33 G  825  CYS VAL ARG MET GLY GLY HIS GLN GLU GLY TYR THR ARG          
SEQRES  34 G  825  PRO PRO TYR PRO GLY ASP LYS LYS ILE TYR ILE ASP GLN          
SEQRES  35 G  825  GLU LEU ILE LYS GLY LYS GLY ARG ILE MET THR TRP TRP          
SEQRES  36 G  825  GLY CYS ASN ASN PHE GLN THR SER ASN ASN ALA GLN ALA          
SEQRES  37 G  825  LEU ARG GLU ALA ILE LEU GLN ARG SER ALA ILE VAL LYS          
SEQRES  38 G  825  GLN ALA MET GLN LYS ALA ARG GLY ALA THR THR GLU GLU          
SEQRES  39 G  825  MET VAL ASP VAL ILE TYR GLU ALA THR GLN ASN GLY GLY          
SEQRES  40 G  825  LEU PHE VAL THR SER ILE ASN LEU TYR PRO THR LYS LEU          
SEQRES  41 G  825  ALA GLU ALA ALA HIS LEU MET LEU PRO ALA ALA HIS PRO          
SEQRES  42 G  825  GLY GLU MET ASN LEU THR SER MET ASN GLY GLU ARG ARG          
SEQRES  43 G  825  ILE ARG LEU SER GLU LYS PHE MET ASP PRO PRO GLY THR          
SEQRES  44 G  825  ALA MET ALA ASP CYS LEU ILE ALA ALA ARG ILE ALA ASN          
SEQRES  45 G  825  ALA LEU ARG ASP MET TYR GLN LYS ASP GLY LYS ALA GLU          
SEQRES  46 G  825  MET ALA ALA GLN PHE GLU GLY PHE ASP TRP LYS THR GLU          
SEQRES  47 G  825  GLU ASP ALA PHE ASN ASP GLY PHE ARG ARG ALA GLY GLN          
SEQRES  48 G  825  PRO GLY ALA PRO ALA ILE ASP SER GLN GLY GLY SER THR          
SEQRES  49 G  825  GLY HIS LEU VAL THR TYR ASP ARG LEU ARG LYS SER GLY          
SEQRES  50 G  825  ASN ASN GLY VAL GLN LEU PRO VAL VAL SER TRP ASP GLU          
SEQRES  51 G  825  SER LYS GLY LEU VAL GLY THR GLU MET LEU TYR THR GLU          
SEQRES  52 G  825  GLY LYS PHE ASP THR ASP ASP GLY LYS ALA HIS PHE LYS          
SEQRES  53 G  825  PRO ALA PRO TRP ASN GLY LEU PRO ALA THR VAL GLN GLN          
SEQRES  54 G  825  GLN LYS ASP LYS TYR ARG PHE TRP LEU ASN ASN GLY ARG          
SEQRES  55 G  825  ASN ASN GLU VAL TRP GLN THR ALA TYR HIS ASP GLN TYR          
SEQRES  56 G  825  ASN SER LEU MET GLN GLU ARG TYR PRO MET ALA TYR ILE          
SEQRES  57 G  825  GLU MET ASN PRO ASP ASP CYS LYS GLN LEU ASP VAL THR          
SEQRES  58 G  825  GLY GLY ASP ILE VAL GLU VAL TYR ASN ASP PHE GLY SER          
SEQRES  59 G  825  THR PHE ALA MET VAL TYR PRO VAL ALA GLU ILE LYS ARG          
SEQRES  60 G  825  GLY GLN THR PHE MET LEU PHE GLY TYR VAL ASN GLY ILE          
SEQRES  61 G  825  GLN GLY ASP VAL THR THR ASP TRP THR ASP ARG ASP ILE          
SEQRES  62 G  825  ILE PRO TYR TYR LYS GLY THR TRP GLY ASP ILE ARG LYS          
SEQRES  63 G  825  VAL GLY SER MET SER GLU PHE LYS ARG THR VAL SER PHE          
SEQRES  64 G  825  LYS SER ARG ARG PHE GLY                                      
SEQRES   1 H  133  ARG THR THR LEU ALA TYR PRO ALA THR ALA VAL SER VAL          
SEQRES   2 H  133  ALA LYS ASN LEU ALA ALA ASN GLU PRO VAL SER PHE THR          
SEQRES   3 H  133  TYR PRO ASP THR SER SER PRO CYS VAL ALA VAL LYS LEU          
SEQRES   4 H  133  GLY ALA PRO VAL PRO GLY GLY VAL GLY PRO ASP ASP ASP          
SEQRES   5 H  133  ILE VAL ALA TYR SER VAL LEU CYS THR HIS MET GLY CYS          
SEQRES   6 H  133  PRO THR SER TYR ASP SER SER SER LYS THR PHE SER CYS          
SEQRES   7 H  133  PRO CYS HIS PHE THR GLU PHE ASP ALA GLU LYS ALA GLY          
SEQRES   8 H  133  GLN MET ILE CYS GLY GLU ALA THR ALA ASP LEU PRO ARG          
SEQRES   9 H  133  VAL LEU LEU ARG TYR ASP ALA ALA SER ASP ALA LEU THR          
SEQRES  10 H  133  ALA VAL GLY VAL ASP GLY LEU ILE TYR GLY ARG GLN ALA          
SEQRES  11 H  133  ASN VAL ILE                                                  
HET     HG   6001       1                                                       
HET     HG   6002       1                                                       
HET     HG   6003       1                                                       
HET     HG   6004       1                                                       
HET     HG   6005       1                                                       
HET     HG   6006       1                                                       
HET     HG   6007       1                                                       
HET     HG   6008       1                                                       
HET     HG   6009       1                                                       
HET     HG   6010       1                                                       
HET     HG   6011       1                                                       
HET     HG   6012       1                                                       
HET     CA   5007       1                                                       
HET     CA   5008       1                                                       
HET     CA   5107       1                                                       
HET     CA   5108       1                                                       
HET     CA   5207       1                                                       
HET     CA   5208       1                                                       
HET     CA   5307       1                                                       
HET     CA   5308       1                                                       
HET    MGD   5001      47                                                       
HET    MGD   5002      47                                                       
HET      O   5003       1                                                       
HET    4MO   5004       1                                                       
HET    F3S   5005       7                                                       
HET    FES   5006       4                                                       
HET    MGD   5101      47                                                       
HET    MGD   5102      47                                                       
HET      O   5103       1                                                       
HET    4MO   5104       1                                                       
HET    F3S   5105       7                                                       
HET    FES   5106       4                                                       
HET    MGD   5201      47                                                       
HET    MGD   5202      47                                                       
HET      O   5203       1                                                       
HET    4MO   5204       1                                                       
HET    F3S   5205       7                                                       
HET    FES   5206       4                                                       
HET    MGD   5301      47                                                       
HET    MGD   5302      47                                                       
HET      O   5303       1                                                       
HET    4MO   5304       1                                                       
HET    F3S   5305       7                                                       
HET    FES   5306       4                                                       
HET    EDO   7001       4                                                       
HET    EDO   7002       4                                                       
HET    EDO   7003       4                                                       
HET    EDO   7004       4                                                       
HET    EDO   7005       4                                                       
HET    EDO   7006       4                                                       
HET    EDO   7007       4                                                       
HET    EDO   7008       4                                                       
HET    EDO   7009       4                                                       
HETNAM      HG MERCURY (II) ION                                                 
HETNAM      CA CALCIUM ION                                                      
HETNAM     MGD 2-AMINO-5,6-DIMERCAPTO-7-METHYL-3,7,8A,9-TETRAHYDRO-8-           
HETNAM   2 MGD  OXA-1,3,9,10-TETRAAZA-ANTHRACEN-4-ONE GUANOSINE                 
HETNAM   3 MGD  DINUCLEOTIDE                                                    
HETNAM       O OXYGEN ATOM                                                      
HETNAM     4MO MOLYBDENUM(IV) ION                                               
HETNAM     F3S FE3-S4 CLUSTER                                                   
HETNAM     FES FE2/S2 (INORGANIC) CLUSTER                                       
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     MGD MOLYBDOPTERIN GUANOSINE DINUCLEOTIDE                             
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   9   HG    12(HG 2+)                                                    
FORMUL  21   CA    8(CA 2+)                                                     
FORMUL  29  MGD    8(C20 H26 N10 O13 P2 S2)                                     
FORMUL  31    O    4(O)                                                         
FORMUL  32  4MO    4(MO 4+)                                                     
FORMUL  33  F3S    4(FE3 S4)                                                    
FORMUL  34  FES    4(FE2 S2)                                                    
FORMUL  53  EDO    9(C2 H6 O2)                                                  
FORMUL  62  HOH   *4087(H2 O)                                                   
CRYST1   90.740  109.520  117.640  97.71  90.00  96.43 P 1           4          
ATOM  21301  N   ARG F   1      31.129 -31.463  -7.139  1.00 25.10           N  
ATOM  21302  CA  ARG F   1      30.573 -30.140  -6.652  1.00 24.97           C  
ATOM  21303  C   ARG F   1      30.811 -29.912  -5.160  1.00 23.89           C  
ATOM  21304  O   ARG F   1      30.651 -30.826  -4.330  1.00 24.72           O  
ATOM  21305  CB  ARG F   1      29.059 -30.035  -6.976  1.00 25.82           C  
ATOM  21306  CG  ARG F   1      28.111 -30.894  -6.139  1.00 26.99           C  
ATOM  21307  CD  ARG F   1      26.675 -30.563  -6.586  1.00 28.00           C  
ATOM  21308  NE  ARG F   1      26.384 -29.146  -6.365  1.00 28.99           N  
ATOM  21309  CZ  ARG F   1      25.444 -28.444  -6.995  1.00 28.72           C  
ATOM  21310  NH1 ARG F   1      24.683 -29.023  -7.921  1.00 29.69           N  
ATOM  21311  NH2 ARG F   1      25.251 -27.162  -6.679  1.00 28.57           N  
ATOM  21312  N   THR F   2      31.193 -28.683  -4.818  1.00 22.33           N  
ATOM  21313  CA  THR F   2      31.488 -28.286  -3.455  1.00 21.53           C  
ATOM  21314  C   THR F   2      30.332 -27.481  -2.831  1.00 21.05           C  
ATOM  21315  O   THR F   2      30.331 -27.201  -1.614  1.00 21.04           O  
ATOM  21316  CB  THR F   2      32.742 -27.353  -3.375  1.00 21.42           C  
ATOM  21317  OG1 THR F   2      32.466 -26.098  -4.041  1.00 20.62           O  
ATOM  21318  CG2 THR F   2      33.985 -28.034  -4.038  1.00 21.46           C  
ATOM  21319  N   THR F   3      29.389 -27.066  -3.671  1.00 20.48           N  
ATOM  21320  CA  THR F   3      28.286 -26.230  -3.197  1.00 19.40           C  
ATOM  21321  C   THR F   3      26.999 -27.015  -3.091  1.00 19.12           C  
ATOM  21322  O   THR F   3      26.790 -28.058  -3.751  1.00 19.08           O  
ATOM  21323  CB  THR F   3      28.027 -25.030  -4.190  1.00 19.55           C  
ATOM  21324  OG1 THR F   3      27.635 -25.557  -5.459  1.00 18.93           O  
ATOM  21325  CG2 THR F   3      29.265 -24.154  -4.335  1.00 18.98           C  
ATOM  21326  N   LEU F   4      26.119 -26.531  -2.215  1.00 18.53           N  
ATOM  21327  CA  LEU F   4      24.817 -27.167  -2.101  1.00 16.99           C  
ATOM  21328  C   LEU F   4      23.949 -26.627  -3.253  1.00 17.05           C  
ATOM  21329  O   LEU F   4      24.232 -25.576  -3.823  1.00 16.96           O  
ATOM  21330  CB  LEU F   4      24.206 -26.784  -0.747  1.00 17.24           C  
ATOM  21331  CG  LEU F   4      24.995 -27.077   0.510  1.00 17.25           C  
ATOM  21332  CD1 LEU F   4      24.123 -26.686   1.737  1.00 17.36           C  
ATOM  21333  CD2 LEU F   4      25.295 -28.557   0.597  1.00 17.92           C  
ATOM  21334  N   ALA F   5      22.884 -27.340  -3.602  1.00 17.12           N  
ATOM  21335  CA  ALA F   5      22.012 -26.871  -4.673  1.00 17.41           C  
ATOM  21336  C   ALA F   5      20.809 -26.206  -4.010  1.00 17.54           C  
ATOM  21337  O   ALA F   5      19.880 -26.888  -3.626  1.00 18.21           O  
ATOM  21338  CB  ALA F   5      21.531 -28.044  -5.525  1.00 18.98           C  
ATOM  21339  N   TYR F   6      20.850 -24.886  -3.887  1.00 17.38           N  
ATOM  21340  CA  TYR F   6      19.728 -24.163  -3.294  1.00 17.05           C  
ATOM  21341  C   TYR F   6      18.694 -23.881  -4.357  1.00 17.52           C  
ATOM  21342  O   TYR F   6      19.027 -23.616  -5.510  1.00 18.53           O  
ATOM  21343  CB  TYR F   6      20.174 -22.792  -2.774  1.00 16.71           C  
ATOM  21344  CG  TYR F   6      21.022 -22.846  -1.554  1.00 16.19           C  
ATOM  21345  CD1 TYR F   6      22.428 -22.854  -1.644  1.00 14.68           C  
ATOM  21346  CD2 TYR F   6      20.434 -22.892  -0.291  1.00 15.54           C  
ATOM  21347  CE1 TYR F   6      23.252 -22.913  -0.495  1.00 15.68           C  
ATOM  21348  CE2 TYR F   6      21.218 -22.945   0.844  1.00 15.56           C  
ATOM  21349  CZ  TYR F   6      22.619 -22.963   0.758  1.00 16.11           C  
ATOM  21350  OH  TYR F   6      23.349 -23.066   1.907  1.00 15.80           O  
ATOM  21351  N   PRO F   7      17.420 -23.906  -3.993  1.00 16.93           N  
ATOM  21352  CA  PRO F   7      16.349 -23.611  -4.962  1.00 16.52           C  
ATOM  21353  C   PRO F   7      16.310 -22.091  -5.203  1.00 15.73           C  
ATOM  21354  O   PRO F   7      16.939 -21.356  -4.482  1.00 16.20           O  
ATOM  21355  CB  PRO F   7      15.077 -24.044  -4.236  1.00 16.95           C  
ATOM  21356  CG  PRO F   7      15.533 -24.790  -3.043  1.00 17.50           C  
ATOM  21357  CD  PRO F   7      16.891 -24.330  -2.688  1.00 16.77           C  
ATOM  21358  N   ALA F   8      15.585 -21.637  -6.228  1.00 16.19           N  
ATOM  21359  CA  ALA F   8      15.427 -20.181  -6.465  1.00 16.20           C  
ATOM  21360  C   ALA F   8      13.924 -20.076  -6.176  1.00 16.22           C  
ATOM  21361  O   ALA F   8      13.109 -20.508  -6.978  1.00 16.82           O  
ATOM  21362  CB  ALA F   8      15.748 -19.809  -7.947  1.00 15.93           C  
ATOM  21363  N   THR F   9      13.582 -19.474  -5.031  1.00 15.35           N  
ATOM  21364  CA  THR F   9      12.193 -19.415  -4.571  1.00 15.58           C  
ATOM  21365  C   THR F   9      11.653 -17.977  -4.595  1.00 15.21           C  
ATOM  21366  O   THR F   9      12.166 -17.103  -3.932  1.00 15.51           O  
ATOM  21367  CB  THR F   9      12.132 -19.954  -3.111  1.00 15.20           C  
ATOM  21368  OG1 THR F   9      12.578 -21.326  -3.081  1.00 15.33           O  
ATOM  21369  CG2 THR F   9      10.685 -19.882  -2.560  1.00 15.00           C  
ATOM  21370  N   ALA F  10      10.645 -17.752  -5.417  1.00 15.90           N  
ATOM  21371  CA  ALA F  10      10.027 -16.434  -5.501  1.00 16.43           C  
ATOM  21372  C   ALA F  10       9.439 -16.087  -4.127  1.00 16.48           C  
ATOM  21373  O   ALA F  10       8.766 -16.937  -3.515  1.00 17.60           O  
ATOM  21374  CB  ALA F  10       8.902 -16.461  -6.536  1.00 17.63           C  
ATOM  21375  N   VAL F  11       9.690 -14.875  -3.652  1.00 16.65           N  
ATOM  21376  CA  VAL F  11       9.113 -14.406  -2.375  1.00 17.38           C  
ATOM  21377  C   VAL F  11       7.916 -13.482  -2.736  1.00 18.84           C  
ATOM  21378  O   VAL F  11       6.729 -13.812  -2.452  1.00 19.68           O  
ATOM  21379  CB  VAL F  11      10.137 -13.664  -1.563  1.00 17.10           C  
ATOM  21380  CG1 VAL F  11       9.455 -13.072  -0.267  1.00 17.31           C  
ATOM  21381  CG2 VAL F  11      11.249 -14.645  -1.140  1.00 16.99           C  
ATOM  21382  N   SER F  12       8.207 -12.352  -3.370  1.00 18.42           N  
ATOM  21383  CA  SER F  12       7.155 -11.412  -3.816  1.00 19.63           C  
ATOM  21384  C   SER F  12       7.840 -10.358  -4.663  1.00 18.59           C  
ATOM  21385  O   SER F  12       9.040 -10.401  -4.845  1.00 19.22           O  
ATOM  21386  CB  SER F  12       6.543 -10.629  -2.623  1.00 20.36           C  
ATOM  21387  OG  SER F  12       5.356  -9.978  -3.098  1.00 25.70           O  
ATOM  21388  N   VAL F  13       7.084  -9.385  -5.151  1.00 16.35           N  
ATOM  21389  CA  VAL F  13       7.743  -8.271  -5.787  1.00 15.24           C  
ATOM  21390  C   VAL F  13       7.987  -7.225  -4.665  1.00 15.56           C  
ATOM  21391  O   VAL F  13       7.218  -7.102  -3.662  1.00 15.77           O  
ATOM  21392  CB  VAL F  13       6.907  -7.707  -6.969  1.00 14.21           C  
ATOM  21393  CG1 VAL F  13       6.818  -8.770  -8.049  1.00 12.93           C  
ATOM  21394  CG2 VAL F  13       5.436  -7.332  -6.507  1.00 14.15           C  
ATOM  21395  N   ALA F  14       9.067  -6.471  -4.807  1.00 15.01           N  
ATOM  21396  CA  ALA F  14       9.478  -5.500  -3.817  1.00 15.60           C  
ATOM  21397  C   ALA F  14       8.440  -4.415  -3.525  1.00 15.97           C  
ATOM  21398  O   ALA F  14       8.259  -4.043  -2.343  1.00 15.16           O  
ATOM  21399  CB  ALA F  14      10.780  -4.857  -4.247  1.00 15.54           C  
ATOM  21400  N   LYS F  15       7.771  -3.920  -4.567  1.00 15.84           N  
ATOM  21401  CA  LYS F  15       6.785  -2.849  -4.359  1.00 16.93           C  
ATOM  21402  C   LYS F  15       5.570  -3.329  -3.520  1.00 17.46           C  
ATOM  21403  O   LYS F  15       4.800  -2.505  -3.041  1.00 18.89           O  
ATOM  21404  CB  LYS F  15       6.312  -2.276  -5.708  1.00 16.09           C  
ATOM  21405  CG  LYS F  15       7.355  -1.304  -6.300  1.00 18.05           C  
ATOM  21406  CD  LYS F  15       6.822  -0.643  -7.608  1.00 17.98           C  
ATOM  21407  CE  LYS F  15       7.690   0.500  -8.047  1.00 19.57           C  
ATOM  21408  NZ  LYS F  15       9.145   0.122  -8.311  1.00 19.50           N  
ATOM  21409  N   ASN F  16       5.402  -4.633  -3.363  1.00 16.75           N  
ATOM  21410  CA  ASN F  16       4.296  -5.179  -2.574  1.00 18.08           C  
ATOM  21411  C   ASN F  16       4.605  -5.190  -1.086  1.00 18.81           C  
ATOM  21412  O   ASN F  16       3.686  -5.213  -0.259  1.00 20.04           O  
ATOM  21413  CB  ASN F  16       3.932  -6.589  -3.046  1.00 17.92           C  
ATOM  21414  CG  ASN F  16       3.090  -6.570  -4.308  1.00 17.20           C  
ATOM  21415  OD1 ASN F  16       2.868  -5.513  -4.908  1.00 18.69           O  
ATOM  21416  ND2 ASN F  16       2.610  -7.736  -4.721  1.00 18.44           N  
ATOM  21417  N   LEU F  17       5.881  -5.158  -0.713  1.00 18.58           N  
ATOM  21418  CA  LEU F  17       6.257  -5.145   0.707  1.00 18.45           C  
ATOM  21419  C   LEU F  17       6.064  -3.772   1.360  1.00 18.03           C  
ATOM  21420  O   LEU F  17       6.499  -2.742   0.824  1.00 17.78           O  
ATOM  21421  CB  LEU F  17       7.743  -5.562   0.874  1.00 18.13           C  
ATOM  21422  CG  LEU F  17       8.022  -7.064   1.038  1.00 19.45           C  
ATOM  21423  CD1 LEU F  17       7.487  -7.876  -0.140  1.00 20.33           C  
ATOM  21424  CD2 LEU F  17       9.546  -7.242   1.193  1.00 19.23           C  
ATOM  21425  N   ALA F  18       5.400  -3.729   2.528  1.00 18.17           N  
ATOM  21426  CA  ALA F  18       5.246  -2.446   3.229  1.00 17.65           C  
ATOM  21427  C   ALA F  18       6.374  -2.290   4.240  1.00 17.82           C  
ATOM  21428  O   ALA F  18       6.866  -3.294   4.783  1.00 18.52           O  
ATOM  21429  CB  ALA F  18       3.863  -2.399   3.965  1.00 17.28           C  
ATOM  21430  N   ALA F  19       6.759  -1.058   4.541  1.00 17.96           N  
ATOM  21431  CA  ALA F  19       7.828  -0.798   5.486  1.00 18.16           C  
ATOM  21432  C   ALA F  19       7.570  -1.448   6.848  1.00 18.87           C  
ATOM  21433  O   ALA F  19       6.490  -1.321   7.482  1.00 17.38           O  
ATOM  21434  CB  ALA F  19       8.083   0.746   5.651  1.00 19.87           C  
ATOM  21435  N   ASN F  20       8.584  -2.203   7.256  1.00 18.17           N  
ATOM  21436  CA  ASN F  20       8.588  -2.904   8.518  1.00 19.15           C  
ATOM  21437  C   ASN F  20       7.439  -3.860   8.798  1.00 19.35           C  
ATOM  21438  O   ASN F  20       7.083  -4.078   9.968  1.00 20.54           O  
ATOM  21439  CB  ASN F  20       8.726  -1.869   9.640  1.00 20.29           C  
ATOM  21440  CG  ASN F  20       9.545  -2.388  10.799  1.00 22.16           C  
ATOM  21441  OD1 ASN F  20      10.411  -3.266  10.637  1.00 22.56           O  
ATOM  21442  ND2 ASN F  20       9.292  -1.833  11.968  1.00 22.64           N  
ATOM  21443  N   GLU F  21       6.845  -4.416   7.743  1.00 18.77           N  
ATOM  21444  CA  GLU F  21       5.768  -5.412   7.847  1.00 19.18           C  
ATOM  21445  C   GLU F  21       6.332  -6.716   7.306  1.00 19.10           C  
ATOM  21446  O   GLU F  21       6.350  -6.948   6.092  1.00 20.22           O  
ATOM  21447  CB  GLU F  21       4.511  -5.048   7.018  1.00 19.61           C  
ATOM  21448  CG  GLU F  21       3.682  -3.929   7.622  0.50 21.88           C  
ATOM  21449  CD  GLU F  21       3.303  -4.234   9.055  0.50 22.12           C  
ATOM  21450  OE1 GLU F  21       2.932  -5.394   9.339  0.50 23.49           O  
ATOM  21451  OE2 GLU F  21       3.387  -3.320   9.894  0.50 23.95           O  
ATOM  21452  N   PRO F  22       6.749  -7.609   8.203  1.00 18.72           N  
ATOM  21453  CA  PRO F  22       7.334  -8.909   7.839  1.00 18.41           C  
ATOM  21454  C   PRO F  22       6.507  -9.821   6.985  1.00 17.95           C  
ATOM  21455  O   PRO F  22       5.265  -9.896   7.087  1.00 16.60           O  
ATOM  21456  CB  PRO F  22       7.718  -9.507   9.194  1.00 18.14           C  
ATOM  21457  CG  PRO F  22       6.590  -9.001  10.095  1.00 18.48           C  
ATOM  21458  CD  PRO F  22       6.432  -7.555   9.640  1.00 17.87           C  
ATOM  21459  N   VAL F  23       7.198 -10.495   6.071  1.00 17.25           N  
ATOM  21460  CA  VAL F  23       6.550 -11.453   5.198  1.00 17.22           C  
ATOM  21461  C   VAL F  23       7.111 -12.839   5.560  1.00 17.56           C  
ATOM  21462  O   VAL F  23       8.317 -13.032   5.594  1.00 18.11           O  
ATOM  21463  CB  VAL F  23       6.858 -11.184   3.716  1.00 17.15           C  
ATOM  21464  CG1 VAL F  23       6.484 -12.370   2.908  1.00 17.23           C  
ATOM  21465  CG2 VAL F  23       6.162  -9.898   3.262  1.00 18.44           C  
ATOM  21466  N   SER F  24       6.240 -13.781   5.853  1.00 17.34           N  
ATOM  21467  CA  SER F  24       6.673 -15.140   6.195  1.00 16.99           C  
ATOM  21468  C   SER F  24       6.726 -15.968   4.915  1.00 17.20           C  
ATOM  21469  O   SER F  24       5.861 -15.842   4.027  1.00 16.81           O  
ATOM  21470  CB  SER F  24       5.661 -15.799   7.158  1.00 18.45           C  
ATOM  21471  OG  SER F  24       5.710 -15.131   8.406  1.00 20.14           O  
ATOM  21472  N   PHE F  25       7.757 -16.818   4.811  1.00 15.60           N  
ATOM  21473  CA  PHE F  25       7.872 -17.727   3.667  1.00 15.38           C  
ATOM  21474  C   PHE F  25       8.805 -18.854   4.113  1.00 14.71           C  
ATOM  21475  O   PHE F  25       9.472 -18.699   5.103  1.00 16.04           O  
ATOM  21476  CB  PHE F  25       8.437 -17.038   2.418  1.00 14.76           C  
ATOM  21477  CG  PHE F  25       9.889 -16.593   2.546  1.00 14.65           C  
ATOM  21478  CD1 PHE F  25      10.223 -15.450   3.255  1.00 13.87           C  
ATOM  21479  CD2 PHE F  25      10.914 -17.311   1.898  1.00 14.46           C  
ATOM  21480  CE1 PHE F  25      11.533 -14.985   3.335  1.00 14.82           C  
ATOM  21481  CE2 PHE F  25      12.253 -16.865   1.962  1.00 13.32           C  
ATOM  21482  CZ  PHE F  25      12.582 -15.714   2.667  1.00 13.98           C  
ATOM  21483  N   THR F  26       8.849 -19.969   3.385  1.00 14.77           N  
ATOM  21484  CA  THR F  26       9.737 -21.083   3.750  1.00 14.40           C  
ATOM  21485  C   THR F  26      10.846 -21.160   2.705  1.00 14.31           C  
ATOM  21486  O   THR F  26      10.623 -20.901   1.511  1.00 14.60           O  
ATOM  21487  CB  THR F  26       9.024 -22.447   3.843  1.00 13.98           C  
ATOM  21488  OG1 THR F  26       8.320 -22.741   2.613  1.00 15.12           O  
ATOM  21489  CG2 THR F  26       7.963 -22.414   5.038  1.00 14.84           C  
ATOM  21490  N   TYR F  27      12.055 -21.461   3.178  1.00 13.06           N  
ATOM  21491  CA  TYR F  27      13.225 -21.554   2.273  1.00 13.37           C  
ATOM  21492  C   TYR F  27      14.330 -22.197   3.089  1.00 12.91           C  
ATOM  21493  O   TYR F  27      14.595 -21.776   4.215  1.00 13.45           O  
ATOM  21494  CB  TYR F  27      13.654 -20.165   1.840  1.00 12.27           C  
ATOM  21495  CG  TYR F  27      14.782 -20.235   0.810  1.00 12.47           C  
ATOM  21496  CD1 TYR F  27      16.090 -20.036   1.187  1.00 12.73           C  
ATOM  21497  CD2 TYR F  27      14.492 -20.572  -0.502  1.00 12.87           C  
ATOM  21498  CE1 TYR F  27      17.148 -20.168   0.258  1.00 13.67           C  
ATOM  21499  CE2 TYR F  27      15.496 -20.720  -1.429  1.00 12.37           C  
ATOM  21500  CZ  TYR F  27      16.820 -20.518  -1.051  1.00 13.01           C  
ATOM  21501  OH  TYR F  27      17.812 -20.635  -2.011  1.00 12.94           O  
ATOM  21502  N   PRO F  28      15.045 -23.188   2.530  1.00 12.94           N  
ATOM  21503  CA  PRO F  28      14.924 -23.760   1.179  1.00 13.25           C  
ATOM  21504  C   PRO F  28      13.973 -24.940   1.045  1.00 13.84           C  
ATOM  21505  O   PRO F  28      14.031 -25.698   0.041  1.00 13.74           O  
ATOM  21506  CB  PRO F  28      16.376 -24.126   0.861  1.00 12.95           C  
ATOM  21507  CG  PRO F  28      16.815 -24.771   2.146  1.00 13.83           C  
ATOM  21508  CD  PRO F  28      16.224 -23.758   3.238  1.00 12.84           C  
ATOM  21509  N   ASP F  29      13.130 -25.148   2.065  1.00 13.25           N  
ATOM  21510  CA  ASP F  29      12.114 -26.203   1.998  1.00 14.22           C  
ATOM  21511  C   ASP F  29      11.023 -25.835   3.014  1.00 14.51           C  
ATOM  21512  O   ASP F  29      11.208 -24.920   3.809  1.00 13.96           O  
ATOM  21513  CB  ASP F  29      12.714 -27.594   2.286  1.00 14.78           C  
ATOM  21514  CG  ASP F  29      13.425 -27.647   3.599  1.00 17.75           C  
ATOM  21515  OD1 ASP F  29      12.788 -27.401   4.661  1.00 17.62           O  
ATOM  21516  OD2 ASP F  29      14.636 -27.934   3.595  1.00 19.15           O  
ATOM  21517  N   THR F  30       9.895 -26.533   2.984  1.00 15.21           N  
ATOM  21518  CA  THR F  30       8.774 -26.178   3.879  1.00 16.07           C  
ATOM  21519  C   THR F  30       8.998 -26.385   5.367  1.00 16.20           C  
ATOM  21520  O   THR F  30       8.188 -25.951   6.203  1.00 16.41           O  
ATOM  21521  CB  THR F  30       7.492 -26.906   3.422  1.00 16.12           C  
ATOM  21522  OG1 THR F  30       7.749 -28.319   3.417  1.00 17.64           O  
ATOM  21523  CG2 THR F  30       7.065 -26.454   2.030  1.00 17.48           C  
ATOM  21524  N   SER F  31      10.103 -27.020   5.743  1.00 15.33           N  
ATOM  21525  CA  SER F  31      10.445 -27.203   7.143  1.00 15.55           C  
ATOM  21526  C   SER F  31      11.368 -26.075   7.649  1.00 14.43           C  
ATOM  21527  O   SER F  31      11.860 -26.149   8.781  1.00 14.39           O  
ATOM  21528  CB  SER F  31      11.193 -28.532   7.327  1.00 16.42           C  
ATOM  21529  OG  SER F  31      10.273 -29.600   7.136  1.00 20.92           O  
ATOM  21530  N   SER F  32      11.637 -25.077   6.817  1.00 12.91           N  
ATOM  21531  CA  SER F  32      12.550 -23.999   7.206  1.00 12.63           C  
ATOM  21532  C   SER F  32      11.860 -22.639   7.109  1.00 12.48           C  
ATOM  21533  O   SER F  32      11.799 -22.005   6.046  1.00 12.48           O  
ATOM  21534  CB  SER F  32      13.803 -24.056   6.286  1.00 12.65           C  
ATOM  21535  OG  SER F  32      14.718 -23.004   6.603  1.00 12.03           O  
ATOM  21536  N   PRO F  33      11.302 -22.159   8.243  1.00 11.92           N  
ATOM  21537  CA  PRO F  33      10.627 -20.868   8.208  1.00 12.78           C  
ATOM  21538  C   PRO F  33      11.528 -19.684   8.137  1.00 12.27           C  
ATOM  21539  O   PRO F  33      12.540 -19.617   8.855  1.00 12.73           O  
ATOM  21540  CB  PRO F  33       9.797 -20.874   9.521  1.00 11.76           C  
ATOM  21541  CG  PRO F  33      10.720 -21.653  10.497  1.00 12.49           C  
ATOM  21542  CD  PRO F  33      11.215 -22.804   9.563  1.00 12.82           C  
ATOM  21543  N   CYS F  34      11.120 -18.708   7.320  1.00 12.75           N  
ATOM  21544  CA  CYS F  34      11.891 -17.496   7.147  1.00 12.80           C  
ATOM  21545  C   CYS F  34      10.975 -16.269   7.162  1.00 13.48           C  
ATOM  21546  O   CYS F  34       9.747 -16.388   7.087  1.00 14.29           O  
ATOM  21547  CB  CYS F  34      12.632 -17.506   5.765  1.00 12.48           C  
ATOM  21548  SG  CYS F  34      13.813 -18.908   5.587  1.00 13.51           S  
ATOM  21549  N   VAL F  35      11.595 -15.123   7.278  1.00 13.86           N  
ATOM  21550  CA  VAL F  35      10.923 -13.813   7.234  1.00 14.02           C  
ATOM  21551  C   VAL F  35      11.710 -12.838   6.359  1.00 15.11           C  
ATOM  21552  O   VAL F  35      12.939 -12.771   6.472  1.00 15.55           O  
ATOM  21553  CB  VAL F  35      10.815 -13.207   8.689  1.00 14.76           C  
ATOM  21554  CG1 VAL F  35      10.558 -11.660   8.662  1.00 15.61           C  
ATOM  21555  CG2 VAL F  35       9.649 -13.933   9.383  1.00 15.67           C  
ATOM  21556  N   ALA F  36      11.019 -12.116   5.469  1.00 14.16           N  
ATOM  21557  CA  ALA F  36      11.658 -11.045   4.703  1.00 14.14           C  
ATOM  21558  C   ALA F  36      11.011  -9.710   5.199  1.00 14.93           C  
ATOM  21559  O   ALA F  36       9.824  -9.689   5.591  1.00 15.16           O  
ATOM  21560  CB  ALA F  36      11.386 -11.216   3.213  1.00 13.84           C  
ATOM  21561  N   VAL F  37      11.781  -8.632   5.228  1.00 13.82           N  
ATOM  21562  CA  VAL F  37      11.211  -7.363   5.655  1.00 15.20           C  
ATOM  21563  C   VAL F  37      11.905  -6.225   4.980  1.00 15.31           C  
ATOM  21564  O   VAL F  37      13.146  -6.241   4.804  1.00 14.87           O  
ATOM  21565  CB  VAL F  37      11.261  -7.233   7.222  1.00 15.47           C  
ATOM  21566  CG1 VAL F  37      12.713  -7.299   7.761  1.00 16.77           C  
ATOM  21567  CG2 VAL F  37      10.602  -5.929   7.634  1.00 16.88           C  
ATOM  21568  N   LYS F  38      11.112  -5.238   4.542  1.00 15.32           N  
ATOM  21569  CA  LYS F  38      11.667  -4.040   3.927  1.00 15.89           C  
ATOM  21570  C   LYS F  38      11.849  -3.149   5.162  1.00 17.10           C  
ATOM  21571  O   LYS F  38      10.844  -2.730   5.770  1.00 17.83           O  
ATOM  21572  CB  LYS F  38      10.636  -3.461   2.965  1.00 16.10           C  
ATOM  21573  CG  LYS F  38      10.974  -2.066   2.458  1.00 16.41           C  
ATOM  21574  CD  LYS F  38       9.849  -1.538   1.522  1.00 16.94           C  
ATOM  21575  CE  LYS F  38       9.887  -2.266   0.142  1.00 15.77           C  
ATOM  21576  NZ  LYS F  38       8.720  -1.858  -0.704  1.00 16.22           N  
ATOM  21577  N   LEU F  39      13.092  -2.860   5.545  1.00 16.74           N  
ATOM  21578  CA  LEU F  39      13.322  -2.144   6.795  1.00 17.85           C  
ATOM  21579  C   LEU F  39      12.941  -0.698   6.838  1.00 19.24           C  
ATOM  21580  O   LEU F  39      12.562  -0.194   7.911  1.00 19.74           O  
ATOM  21581  CB  LEU F  39      14.780  -2.332   7.251  1.00 17.92           C  
ATOM  21582  CG  LEU F  39      15.067  -3.815   7.588  1.00 17.16           C  
ATOM  21583  CD1 LEU F  39      16.566  -4.032   7.754  1.00 17.88           C  
ATOM  21584  CD2 LEU F  39      14.355  -4.232   8.905  1.00 17.74           C  
ATOM  21585  N   GLY F  40      12.988  -0.028   5.685  1.00 19.91           N  
ATOM  21586  CA  GLY F  40      12.646   1.396   5.662  1.00 21.00           C  
ATOM  21587  C   GLY F  40      13.835   2.328   5.544  1.00 21.32           C  
ATOM  21588  O   GLY F  40      13.682   3.472   5.132  1.00 22.47           O  
ATOM  21589  N   ALA F  41      15.016   1.881   5.930  1.00 21.30           N  
ATOM  21590  CA  ALA F  41      16.243   2.674   5.823  1.00 21.41           C  
ATOM  21591  C   ALA F  41      17.295   1.644   5.398  1.00 21.39           C  
ATOM  21592  O   ALA F  41      17.276   0.501   5.836  1.00 20.95           O  
ATOM  21593  CB  ALA F  41      16.651   3.317   7.207  1.00 22.59           C  
ATOM  21594  N   PRO F  42      18.227   2.048   4.536  1.00 21.49           N  
ATOM  21595  CA  PRO F  42      19.294   1.169   4.042  1.00 20.61           C  
ATOM  21596  C   PRO F  42      20.166   0.515   5.120  1.00 20.11           C  
ATOM  21597  O   PRO F  42      20.486   1.127   6.126  1.00 19.80           O  
ATOM  21598  CB  PRO F  42      20.101   2.091   3.115  1.00 21.36           C  
ATOM  21599  CG  PRO F  42      19.792   3.487   3.610  1.00 22.61           C  
ATOM  21600  CD  PRO F  42      18.321   3.400   3.957  1.00 21.55           C  
ATOM  21601  N   VAL F  43      20.538  -0.743   4.884  1.00 19.28           N  
ATOM  21602  CA  VAL F  43      21.426  -1.487   5.792  1.00 19.81           C  
ATOM  21603  C   VAL F  43      22.451  -2.234   4.902  1.00 21.54           C  
ATOM  21604  O   VAL F  43      22.156  -2.564   3.741  1.00 21.06           O  
ATOM  21605  CB  VAL F  43      20.640  -2.503   6.715  1.00 18.62           C  
ATOM  21606  CG1 VAL F  43      19.658  -1.719   7.618  1.00 19.15           C  
ATOM  21607  CG2 VAL F  43      19.919  -3.588   5.884  1.00 17.69           C  
ATOM  21608  N   PRO F  44      23.691  -2.451   5.413  1.00 22.81           N  
ATOM  21609  CA  PRO F  44      24.675  -3.165   4.572  1.00 23.42           C  
ATOM  21610  C   PRO F  44      24.051  -4.452   4.025  1.00 23.67           C  
ATOM  21611  O   PRO F  44      23.471  -5.255   4.776  1.00 24.48           O  
ATOM  21612  CB  PRO F  44      25.829  -3.447   5.538  1.00 23.79           C  
ATOM  21613  CG  PRO F  44      25.780  -2.229   6.506  1.00 23.94           C  
ATOM  21614  CD  PRO F  44      24.247  -2.116   6.741  1.00 23.14           C  
ATOM  21615  N   GLY F  45      24.100  -4.673   2.719  1.00 23.47           N  
ATOM  21616  CA  GLY F  45      23.492  -5.946   2.306  1.00 23.27           C  
ATOM  21617  C   GLY F  45      21.972  -6.025   2.067  1.00 22.21           C  
ATOM  21618  O   GLY F  45      21.447  -7.060   1.593  1.00 21.97           O  
ATOM  21619  N   GLY F  46      21.236  -4.969   2.395  1.00 21.02           N  
ATOM  21620  CA  GLY F  46      19.820  -5.010   2.041  1.00 18.53           C  
ATOM  21621  C   GLY F  46      19.718  -4.862   0.507  1.00 18.50           C  
ATOM  21622  O   GLY F  46      20.626  -4.290  -0.131  1.00 18.07           O  
ATOM  21623  N   VAL F  47      18.635  -5.362  -0.077  1.00 16.62           N  
ATOM  21624  CA  VAL F  47      18.384  -5.251  -1.509  1.00 17.34           C  
ATOM  21625  C   VAL F  47      17.137  -4.456  -1.833  1.00 17.84           C  
ATOM  21626  O   VAL F  47      16.438  -3.971  -0.930  1.00 17.41           O  
ATOM  21627  CB  VAL F  47      18.313  -6.646  -2.185  1.00 16.74           C  
ATOM  21628  CG1 VAL F  47      19.559  -7.420  -1.814  1.00 17.00           C  
ATOM  21629  CG2 VAL F  47      17.059  -7.420  -1.749  1.00 16.57           C  
ATOM  21630  N   GLY F  48      16.843  -4.314  -3.123  1.00 17.44           N  
ATOM  21631  CA  GLY F  48      15.711  -3.489  -3.510  1.00 18.00           C  
ATOM  21632  C   GLY F  48      16.198  -2.049  -3.731  1.00 18.57           C  
ATOM  21633  O   GLY F  48      17.351  -1.685  -3.406  1.00 18.22           O  
ATOM  21634  N   PRO F  49      15.323  -1.183  -4.265  1.00 19.06           N  
ATOM  21635  CA  PRO F  49      15.692   0.212  -4.540  1.00 20.20           C  
ATOM  21636  C   PRO F  49      16.210   1.035  -3.405  1.00 20.49           C  
ATOM  21637  O   PRO F  49      17.004   1.959  -3.627  1.00 21.65           O  
ATOM  21638  CB  PRO F  49      14.430   0.803  -5.182  1.00 20.04           C  
ATOM  21639  CG  PRO F  49      13.303  -0.110  -4.725  1.00 20.73           C  
ATOM  21640  CD  PRO F  49      13.937  -1.484  -4.673  1.00 19.73           C  
ATOM  21641  N   ASP F  50      15.796   0.712  -2.177  1.00 20.58           N  
ATOM  21642  CA  ASP F  50      16.285   1.462  -1.016  1.00 20.61           C  
ATOM  21643  C   ASP F  50      17.330   0.641  -0.232  1.00 20.48           C  
ATOM  21644  O   ASP F  50      17.681   0.995   0.880  1.00 19.40           O  
ATOM  21645  CB  ASP F  50      15.086   1.854  -0.076  1.00 21.55           C  
ATOM  21646  CG  ASP F  50      15.471   2.923   0.930  1.00 22.59           C  
ATOM  21647  OD1 ASP F  50      15.033   2.861   2.104  1.00 23.50           O  
ATOM  21648  OD2 ASP F  50      16.251   3.846   0.557  1.00 23.93           O  
ATOM  21649  N   ASP F  51      17.796  -0.474  -0.813  1.00 20.39           N  
ATOM  21650  CA  ASP F  51      18.789  -1.332  -0.173  1.00 20.01           C  
ATOM  21651  C   ASP F  51      18.431  -1.653   1.264  1.00 18.51           C  
ATOM  21652  O   ASP F  51      19.284  -1.693   2.165  1.00 18.05           O  
ATOM  21653  CB  ASP F  51      20.163  -0.670  -0.237  1.00 23.00           C  
ATOM  21654  CG  ASP F  51      20.589  -0.428  -1.682  1.00 26.06           C  
ATOM  21655  OD1 ASP F  51      20.593  -1.412  -2.455  1.00 27.82           O  
ATOM  21656  OD2 ASP F  51      20.859   0.740  -2.040  1.00 28.91           O  
ATOM  21657  N   ASP F  52      17.162  -1.938   1.474  1.00 17.64           N  
ATOM  21658  CA  ASP F  52      16.719  -2.166   2.835  1.00 16.39           C  
ATOM  21659  C   ASP F  52      15.898  -3.417   3.031  1.00 16.08           C  
ATOM  21660  O   ASP F  52      15.310  -3.613   4.107  1.00 14.98           O  
ATOM  21661  CB  ASP F  52      15.944  -0.934   3.289  1.00 17.54           C  
ATOM  21662  CG  ASP F  52      14.672  -0.756   2.523  1.00 19.46           C  
ATOM  21663  OD1 ASP F  52      13.806   0.072   2.968  1.00 20.13           O  
ATOM  21664  OD2 ASP F  52      14.524  -1.431   1.475  1.00 19.07           O  
ATOM  21665  N   ILE F  53      15.858  -4.301   2.037  1.00 14.29           N  
ATOM  21666  CA  ILE F  53      15.106  -5.528   2.168  1.00 13.41           C  
ATOM  21667  C   ILE F  53      16.049  -6.657   2.534  1.00 14.18           C  
ATOM  21668  O   ILE F  53      17.044  -6.932   1.819  1.00 13.98           O  
ATOM  21669  CB  ILE F  53      14.352  -5.905   0.870  1.00 12.95           C  
ATOM  21670  CG1 ILE F  53      13.475  -4.695   0.460  1.00 13.63           C  
ATOM  21671  CG2 ILE F  53      13.532  -7.161   1.072  1.00 12.27           C  
ATOM  21672  CD1 ILE F  53      12.834  -4.839  -0.904  1.00 13.28           C  
ATOM  21673  N   VAL F  54      15.747  -7.285   3.660  1.00 13.47           N  
ATOM  21674  CA  VAL F  54      16.574  -8.373   4.196  1.00 12.94           C  
ATOM  21675  C   VAL F  54      15.688  -9.580   4.532  1.00 13.55           C  
ATOM  21676  O   VAL F  54      14.440  -9.470   4.688  1.00 14.05           O  
ATOM  21677  CB  VAL F  54      17.345  -7.936   5.465  1.00 13.98           C  
ATOM  21678  CG1 VAL F  54      18.322  -6.801   5.196  1.00 13.73           C  
ATOM  21679  CG2 VAL F  54      16.323  -7.490   6.570  1.00 13.28           C  
ATOM  21680  N   ALA F  55      16.305 -10.770   4.621  1.00 12.51           N  
ATOM  21681  CA  ALA F  55      15.520 -11.963   5.010  1.00 11.74           C  
ATOM  21682  C   ALA F  55      16.399 -12.843   5.863  1.00 11.30           C  
ATOM  21683  O   ALA F  55      17.658 -12.815   5.725  1.00 11.93           O  
ATOM  21684  CB  ALA F  55      15.023 -12.724   3.807  1.00 11.59           C  
ATOM  21685  N   TYR F  56      15.760 -13.620   6.720  1.00 10.72           N  
ATOM  21686  CA  TYR F  56      16.447 -14.528   7.659  1.00 10.27           C  
ATOM  21687  C   TYR F  56      15.698 -15.791   7.910  1.00 11.29           C  
ATOM  21688  O   TYR F  56      14.474 -15.835   7.758  1.00 11.41           O  
ATOM  21689  CB  TYR F  56      16.594 -13.887   9.074  1.00 10.76           C  
ATOM  21690  CG  TYR F  56      17.409 -12.620   9.097  1.00 10.32           C  
ATOM  21691  CD1 TYR F  56      18.791 -12.679   9.344  1.00 11.63           C  
ATOM  21692  CD2 TYR F  56      16.820 -11.337   8.840  1.00  9.81           C  
ATOM  21693  CE1 TYR F  56      19.570 -11.528   9.334  1.00 10.90           C  
ATOM  21694  CE2 TYR F  56      17.600 -10.181   8.851  1.00 10.64           C  
ATOM  21695  CZ  TYR F  56      18.977 -10.289   9.092  1.00 11.03           C  
ATOM  21696  OH  TYR F  56      19.746  -9.147   9.136  1.00 11.65           O  
ATOM  21697  N   SER F  57      16.431 -16.809   8.336  1.00 10.64           N  
ATOM  21698  CA  SER F  57      15.809 -18.010   8.856  1.00 11.90           C  
ATOM  21699  C   SER F  57      15.348 -17.514  10.264  1.00 11.84           C  
ATOM  21700  O   SER F  57      16.096 -16.802  10.931  1.00 12.24           O  
ATOM  21701  CB  SER F  57      16.882 -19.066   9.068  1.00 12.49           C  
ATOM  21702  OG  SER F  57      16.425 -20.058   9.953  1.00 12.00           O  
ATOM  21703  N   VAL F  58      14.136 -17.874  10.720  1.00 12.57           N  
ATOM  21704  CA  VAL F  58      13.733 -17.442  12.043  1.00 13.43           C  
ATOM  21705  C   VAL F  58      13.988 -18.451  13.150  1.00 13.47           C  
ATOM  21706  O   VAL F  58      13.664 -18.164  14.322  1.00 15.12           O  
ATOM  21707  CB  VAL F  58      12.221 -16.993  12.100  1.00 13.84           C  
ATOM  21708  CG1 VAL F  58      12.054 -15.795  11.192  1.00 16.57           C  
ATOM  21709  CG2 VAL F  58      11.280 -18.129  11.788  1.00 15.01           C  
ATOM  21710  N   LEU F  59      14.549 -19.633  12.835  1.00 11.88           N  
ATOM  21711  CA  LEU F  59      14.820 -20.612  13.884  1.00 10.94           C  
ATOM  21712  C   LEU F  59      16.070 -20.185  14.666  1.00 11.26           C  
ATOM  21713  O   LEU F  59      17.131 -19.942  14.093  1.00 11.48           O  
ATOM  21714  CB  LEU F  59      15.025 -21.997  13.277  1.00 11.01           C  
ATOM  21715  CG  LEU F  59      13.835 -22.561  12.509  1.00 11.67           C  
ATOM  21716  CD1 LEU F  59      14.147 -23.992  12.097  1.00 12.32           C  
ATOM  21717  CD2 LEU F  59      12.564 -22.554  13.420  1.00 11.70           C  
ATOM  21718  N   CYS F  60      15.955 -20.092  15.983  1.00 10.70           N  
ATOM  21719  CA  CYS F  60      17.072 -19.618  16.778  1.00 10.34           C  
ATOM  21720  C   CYS F  60      18.222 -20.619  16.614  1.00  9.89           C  
ATOM  21721  O   CYS F  60      18.012 -21.798  16.663  1.00  9.95           O  
ATOM  21722  CB  CYS F  60      16.664 -19.550  18.261  1.00  9.57           C  
ATOM  21723  SG  CYS F  60      17.926 -18.988  19.368  1.00  9.80           S  
ATOM  21724  N   THR F  61      19.423 -20.085  16.369  1.00 11.58           N  
ATOM  21725  CA  THR F  61      20.626 -20.884  16.219  1.00 12.26           C  
ATOM  21726  C   THR F  61      21.150 -21.504  17.526  1.00 12.93           C  
ATOM  21727  O   THR F  61      22.134 -22.263  17.517  1.00 13.13           O  
ATOM  21728  CB  THR F  61      21.747 -20.013  15.530  1.00 11.53           C  
ATOM  21729  OG1 THR F  61      21.920 -18.780  16.224  1.00 13.79           O  
ATOM  21730  CG2 THR F  61      21.303 -19.687  14.116  1.00 14.08           C  
ATOM  21731  N   HIS F  62      20.555 -21.196  18.667  1.00 12.06           N  
ATOM  21732  CA  HIS F  62      20.996 -21.845  19.887  1.00 12.21           C  
ATOM  21733  C   HIS F  62      20.374 -23.272  19.950  1.00 11.91           C  
ATOM  21734  O   HIS F  62      21.089 -24.289  19.845  1.00 12.43           O  
ATOM  21735  CB  HIS F  62      20.556 -20.992  21.038  1.00 10.24           C  
ATOM  21736  CG  HIS F  62      20.945 -21.536  22.367  1.00 11.80           C  
ATOM  21737  ND1 HIS F  62      20.061 -21.587  23.433  1.00  9.55           N  
ATOM  21738  CD2 HIS F  62      22.110 -22.052  22.820  1.00  9.46           C  
ATOM  21739  CE1 HIS F  62      20.677 -22.103  24.481  1.00 10.44           C  
ATOM  21740  NE2 HIS F  62      21.925 -22.396  24.135  1.00 10.95           N  
ATOM  21741  N   MET F  63      19.046 -23.365  20.122  1.00 10.96           N  
ATOM  21742  CA  MET F  63      18.367 -24.654  20.155  1.00 10.70           C  
ATOM  21743  C   MET F  63      17.090 -24.726  19.304  1.00 10.83           C  
ATOM  21744  O   MET F  63      16.276 -25.598  19.503  1.00 11.56           O  
ATOM  21745  CB  MET F  63      18.061 -25.109  21.605  1.00 11.27           C  
ATOM  21746  CG  MET F  63      19.311 -25.145  22.519  1.00 11.83           C  
ATOM  21747  SD  MET F  63      18.874 -25.591  24.211  1.00 13.06           S  
ATOM  21748  CE  MET F  63      18.663 -27.383  24.046  1.00 12.23           C  
ATOM  21749  N   GLY F  64      16.912 -23.793  18.376  1.00 10.86           N  
ATOM  21750  CA  GLY F  64      15.868 -23.913  17.367  1.00 10.71           C  
ATOM  21751  C   GLY F  64      14.466 -23.417  17.626  1.00 11.38           C  
ATOM  21752  O   GLY F  64      13.574 -23.619  16.803  1.00 11.49           O  
ATOM  21753  N   CYS F  65      14.270 -22.763  18.761  1.00 11.35           N  
ATOM  21754  CA  CYS F  65      12.923 -22.232  18.976  1.00 11.75           C  
ATOM  21755  C   CYS F  65      12.686 -21.161  17.918  1.00 12.11           C  
ATOM  21756  O   CYS F  65      13.602 -20.390  17.545  1.00 11.41           O  
ATOM  21757  CB  CYS F  65      12.872 -21.578  20.372  1.00 12.80           C  
ATOM  21758  SG  CYS F  65      12.944 -22.863  21.637  1.00 14.16           S  
ATOM  21759  N   PRO F  66      11.453 -21.087  17.385  1.00 12.74           N  
ATOM  21760  CA  PRO F  66      11.145 -20.067  16.384  1.00 13.18           C  
ATOM  21761  C   PRO F  66      11.189 -18.686  17.082  1.00 13.69           C  
ATOM  21762  O   PRO F  66      10.678 -18.493  18.219  1.00 13.74           O  
ATOM  21763  CB  PRO F  66       9.731 -20.433  15.939  1.00 13.49           C  
ATOM  21764  CG  PRO F  66       9.740 -21.919  16.028  1.00 15.48           C  
ATOM  21765  CD  PRO F  66      10.410 -22.122  17.404  1.00 14.02           C  
ATOM  21766  N   THR F  67      11.868 -17.743  16.448  1.00 13.08           N  
ATOM  21767  CA  THR F  67      11.972 -16.397  16.977  1.00 13.06           C  
ATOM  21768  C   THR F  67      10.832 -15.576  16.395  1.00 13.29           C  
ATOM  21769  O   THR F  67      10.197 -15.951  15.399  1.00 13.83           O  
ATOM  21770  CB  THR F  67      13.328 -15.717  16.608  1.00 13.50           C  
ATOM  21771  OG1 THR F  67      13.454 -15.592  15.177  1.00 14.22           O  
ATOM  21772  CG2 THR F  67      14.476 -16.531  17.135  1.00 12.72           C  
ATOM  21773  N   SER F  68      10.552 -14.453  17.051  1.00 13.46           N  
ATOM  21774  CA  SER F  68       9.512 -13.581  16.566  1.00 14.35           C  
ATOM  21775  C   SER F  68      10.130 -12.237  16.251  1.00 13.91           C  
ATOM  21776  O   SER F  68      11.056 -11.764  16.938  1.00 14.79           O  
ATOM  21777  CB  SER F  68       8.404 -13.426  17.638  1.00 15.70           C  
ATOM  21778  OG  SER F  68       8.953 -12.735  18.737  1.00 20.00           O  
ATOM  21779  N   TYR F  69       9.612 -11.605  15.204  1.00 14.39           N  
ATOM  21780  CA  TYR F  69      10.089 -10.302  14.792  1.00 14.45           C  
ATOM  21781  C   TYR F  69       9.426  -9.206  15.629  1.00 15.41           C  
ATOM  21782  O   TYR F  69       8.169  -9.166  15.715  1.00 15.46           O  
ATOM  21783  CB  TYR F  69       9.743 -10.043  13.309  1.00 14.53           C  
ATOM  21784  CG  TYR F  69      10.327  -8.750  12.797  1.00 14.60           C  
ATOM  21785  CD1 TYR F  69       9.512  -7.694  12.348  1.00 14.04           C  
ATOM  21786  CD2 TYR F  69      11.729  -8.572  12.748  1.00 13.43           C  
ATOM  21787  CE1 TYR F  69      10.050  -6.533  11.876  1.00 13.58           C  
ATOM  21788  CE2 TYR F  69      12.298  -7.417  12.267  1.00 14.17           C  
ATOM  21789  CZ  TYR F  69      11.453  -6.389  11.822  1.00 14.26           C  
ATOM  21790  OH  TYR F  69      12.011  -5.274  11.325  1.00 14.90           O  
ATOM  21791  N   ASP F  70      10.235  -8.335  16.209  1.00 15.08           N  
ATOM  21792  CA  ASP F  70       9.747  -7.192  16.969  1.00 15.94           C  
ATOM  21793  C   ASP F  70       9.895  -5.968  16.082  1.00 16.25           C  
ATOM  21794  O   ASP F  70      11.017  -5.469  15.828  1.00 15.60           O  
ATOM  21795  CB  ASP F  70      10.531  -7.098  18.295  1.00 16.23           C  
ATOM  21796  CG  ASP F  70      10.085  -5.936  19.183  1.00 17.62           C  
ATOM  21797  OD1 ASP F  70      10.290  -6.028  20.387  1.00 18.73           O  
ATOM  21798  OD2 ASP F  70       9.560  -4.950  18.661  1.00 18.59           O  
ATOM  21799  N   SER F  71       8.764  -5.487  15.547  1.00 17.12           N  
ATOM  21800  CA  SER F  71       8.771  -4.284  14.704  1.00 18.60           C  
ATOM  21801  C   SER F  71       9.349  -3.012  15.367  1.00 18.46           C  
ATOM  21802  O   SER F  71       9.995  -2.195  14.695  1.00 19.18           O  
ATOM  21803  CB  SER F  71       7.344  -3.929  14.212  1.00 18.97           C  
ATOM  21804  OG  SER F  71       6.836  -4.858  13.268  1.00 22.41           O  
ATOM  21805  N   SER F  72       9.175  -2.864  16.680  1.00 17.90           N  
ATOM  21806  CA  SER F  72       9.635  -1.658  17.339  1.00 18.57           C  
ATOM  21807  C   SER F  72      11.132  -1.557  17.453  1.00 17.99           C  
ATOM  21808  O   SER F  72      11.657  -0.443  17.486  1.00 18.73           O  
ATOM  21809  CB  SER F  72       9.028  -1.494  18.749  1.00 19.13           C  
ATOM  21810  OG  SER F  72       9.630  -2.385  19.678  1.00 20.57           O  
ATOM  21811  N   SER F  73      11.819  -2.711  17.522  1.00 16.58           N  
ATOM  21812  CA  SER F  73      13.275  -2.708  17.652  1.00 15.14           C  
ATOM  21813  C   SER F  73      13.996  -3.253  16.412  1.00 15.11           C  
ATOM  21814  O   SER F  73      15.227  -3.169  16.354  1.00 15.30           O  
ATOM  21815  CB  SER F  73      13.695  -3.572  18.864  1.00 14.99           C  
ATOM  21816  OG  SER F  73      12.986  -4.797  18.841  1.00 14.68           O  
ATOM  21817  N   LYS F  74      13.218  -3.802  15.474  1.00 14.72           N  
ATOM  21818  CA  LYS F  74      13.739  -4.425  14.255  1.00 14.49           C  
ATOM  21819  C   LYS F  74      14.739  -5.526  14.652  1.00 13.98           C  
ATOM  21820  O   LYS F  74      15.907  -5.563  14.210  1.00 12.89           O  
ATOM  21821  CB  LYS F  74      14.405  -3.390  13.340  1.00 15.17           C  
ATOM  21822  CG  LYS F  74      13.367  -2.393  12.743  1.00 16.62           C  
ATOM  21823  CD  LYS F  74      14.013  -1.319  11.868  1.00 17.69           C  
ATOM  21824  CE  LYS F  74      12.925  -0.425  11.247  1.00 18.71           C  
ATOM  21825  NZ  LYS F  74      13.626   0.676  10.496  1.00 21.07           N  
ATOM  21826  N   THR F  75      14.239  -6.416  15.484  1.00 13.09           N  
ATOM  21827  CA  THR F  75      15.023  -7.535  15.962  1.00 12.56           C  
ATOM  21828  C   THR F  75      14.208  -8.809  15.960  1.00 12.24           C  
ATOM  21829  O   THR F  75      12.970  -8.786  15.795  1.00 12.63           O  
ATOM  21830  CB  THR F  75      15.542  -7.310  17.390  1.00 12.31           C  
ATOM  21831  OG1 THR F  75      14.396  -7.186  18.287  1.00 14.25           O  
ATOM  21832  CG2 THR F  75      16.513  -6.120  17.465  1.00 12.89           C  
ATOM  21833  N   PHE F  76      14.874  -9.954  16.116  1.00 11.26           N  
ATOM  21834  CA  PHE F  76      14.157 -11.224  16.225  1.00 11.28           C  
ATOM  21835  C   PHE F  76      14.472 -11.721  17.633  1.00 11.16           C  
ATOM  21836  O   PHE F  76      15.637 -11.781  18.063  1.00 11.25           O  
ATOM  21837  CB  PHE F  76      14.636 -12.302  15.243  1.00 11.27           C  
ATOM  21838  CG  PHE F  76      14.275 -12.011  13.836  1.00 11.28           C  
ATOM  21839  CD1 PHE F  76      15.101 -11.202  13.036  1.00 11.01           C  
ATOM  21840  CD2 PHE F  76      13.085 -12.502  13.303  1.00  9.92           C  
ATOM  21841  CE1 PHE F  76      14.708 -10.903  11.699  1.00 10.31           C  
ATOM  21842  CE2 PHE F  76      12.680 -12.231  12.021  1.00 10.99           C  
ATOM  21843  CZ  PHE F  76      13.501 -11.414  11.177  1.00 10.37           C  
ATOM  21844  N   SER F  77      13.423 -12.061  18.376  1.00 11.75           N  
ATOM  21845  CA  SER F  77      13.578 -12.477  19.766  1.00 11.20           C  
ATOM  21846  C   SER F  77      13.274 -13.948  19.988  1.00 10.54           C  
ATOM  21847  O   SER F  77      12.243 -14.436  19.521  1.00 10.63           O  
ATOM  21848  CB  SER F  77      12.582 -11.687  20.665  1.00 12.50           C  
ATOM  21849  OG  SER F  77      12.960 -10.304  20.802  1.00 20.30           O  
ATOM  21850  N   CYS F  78      14.118 -14.638  20.748  1.00 10.64           N  
ATOM  21851  CA  CYS F  78      13.826 -16.008  21.044  1.00 11.82           C  
ATOM  21852  C   CYS F  78      13.270 -16.122  22.450  1.00 12.42           C  
ATOM  21853  O   CYS F  78      13.926 -15.769  23.425  1.00 13.15           O  
ATOM  21854  CB  CYS F  78      15.065 -16.864  20.978  1.00 11.17           C  
ATOM  21855  SG  CYS F  78      14.684 -18.606  21.291  1.00 11.56           S  
ATOM  21856  N   PRO F  79      12.101 -16.735  22.564  1.00 13.86           N  
ATOM  21857  CA  PRO F  79      11.442 -16.912  23.871  1.00 14.62           C  
ATOM  21858  C   PRO F  79      11.972 -18.038  24.782  1.00 14.90           C  
ATOM  21859  O   PRO F  79      11.549 -18.142  25.955  1.00 15.44           O  
ATOM  21860  CB  PRO F  79      10.005 -17.202  23.467  1.00 14.12           C  
ATOM  21861  CG  PRO F  79      10.199 -18.077  22.211  1.00 15.20           C  
ATOM  21862  CD  PRO F  79      11.307 -17.289  21.461  1.00 13.50           C  
ATOM  21863  N   CYS F  80      12.870 -18.876  24.281  1.00 13.15           N  
ATOM  21864  CA  CYS F  80      13.363 -20.014  25.059  1.00 13.23           C  
ATOM  21865  C   CYS F  80      14.456 -19.659  26.016  1.00 12.51           C  
ATOM  21866  O   CYS F  80      14.313 -19.942  27.205  1.00 14.12           O  
ATOM  21867  CB  CYS F  80      13.755 -21.161  24.121  1.00 13.71           C  
ATOM  21868  SG  CYS F  80      12.265 -21.826  23.297  1.00 14.51           S  
ATOM  21869  N   HIS F  81      15.538 -19.052  25.528  1.00 11.11           N  
ATOM  21870  CA  HIS F  81      16.607 -18.625  26.432  1.00 10.52           C  
ATOM  21871  C   HIS F  81      17.022 -17.205  26.245  1.00 10.32           C  
ATOM  21872  O   HIS F  81      18.117 -16.817  26.654  1.00 10.17           O  
ATOM  21873  CB  HIS F  81      17.820 -19.592  26.475  1.00 11.15           C  
ATOM  21874  CG  HIS F  81      17.425 -21.047  26.393  1.00 11.49           C  
ATOM  21875  ND1 HIS F  81      17.310 -21.716  25.185  1.00 11.98           N  
ATOM  21876  CD2 HIS F  81      17.022 -21.918  27.344  1.00 11.69           C  
ATOM  21877  CE1 HIS F  81      16.836 -22.930  25.408  1.00 12.24           C  
ATOM  21878  NE2 HIS F  81      16.664 -23.079  26.716  1.00 11.07           N  
ATOM  21879  N   PHE F  82      16.129 -16.445  25.608  1.00 10.87           N  
ATOM  21880  CA  PHE F  82      16.232 -14.957  25.571  1.00 10.91           C  
ATOM  21881  C   PHE F  82      17.270 -14.289  24.676  1.00 11.34           C  
ATOM  21882  O   PHE F  82      17.624 -13.135  24.873  1.00 12.73           O  
ATOM  21883  CB  PHE F  82      16.360 -14.452  27.019  1.00 12.09           C  
ATOM  21884  CG  PHE F  82      15.297 -15.061  27.927  1.00 13.14           C  
ATOM  21885  CD1 PHE F  82      15.618 -16.069  28.843  1.00 12.90           C  
ATOM  21886  CD2 PHE F  82      13.960 -14.798  27.681  1.00 14.99           C  
ATOM  21887  CE1 PHE F  82      14.652 -16.829  29.484  1.00 13.83           C  
ATOM  21888  CE2 PHE F  82      12.943 -15.583  28.352  1.00 15.51           C  
ATOM  21889  CZ  PHE F  82      13.310 -16.588  29.231  1.00 13.39           C  
ATOM  21890  N   THR F  83      17.692 -15.047  23.676  1.00 10.95           N  
ATOM  21891  CA  THR F  83      18.634 -14.495  22.716  1.00 10.21           C  
ATOM  21892  C   THR F  83      17.865 -13.547  21.815  1.00  9.61           C  
ATOM  21893  O   THR F  83      16.690 -13.810  21.441  1.00 10.97           O  
ATOM  21894  CB  THR F  83      19.220 -15.640  21.920  1.00  9.71           C  
ATOM  21895  OG1 THR F  83      19.911 -16.505  22.827  1.00  9.76           O  
ATOM  21896  CG2 THR F  83      20.167 -15.135  20.847  1.00  9.74           C  
ATOM  21897  N   GLU F  84      18.495 -12.451  21.406  1.00  8.80           N  
ATOM  21898  CA  GLU F  84      17.826 -11.547  20.471  1.00  8.60           C  
ATOM  21899  C   GLU F  84      18.886 -11.210  19.349  1.00  9.34           C  
ATOM  21900  O   GLU F  84      20.050 -10.968  19.689  1.00 10.24           O  
ATOM  21901  CB  GLU F  84      17.412 -10.280  21.220  1.00 10.78           C  
ATOM  21902  CG  GLU F  84      16.663  -9.256  20.384  1.00 12.52           C  
ATOM  21903  CD  GLU F  84      15.826  -8.293  21.265  1.00 13.14           C  
ATOM  21904  OE1 GLU F  84      15.194  -7.379  20.685  1.00 14.37           O  
ATOM  21905  OE2 GLU F  84      15.852  -8.473  22.516  1.00 13.98           O  
ATOM  21906  N   PHE F  85      18.431 -11.164  18.102  1.00  9.12           N  
ATOM  21907  CA  PHE F  85      19.272 -10.888  16.913  1.00 10.42           C  
ATOM  21908  C   PHE F  85      18.862  -9.587  16.208  1.00 10.54           C  
ATOM  21909  O   PHE F  85      17.660  -9.294  16.057  1.00 12.40           O  
ATOM  21910  CB  PHE F  85      19.115 -12.052  15.949  1.00  9.40           C  
ATOM  21911  CG  PHE F  85      19.448 -13.381  16.544  1.00 10.79           C  
ATOM  21912  CD1 PHE F  85      20.764 -13.874  16.545  1.00 10.17           C  
ATOM  21913  CD2 PHE F  85      18.420 -14.218  17.066  1.00 10.32           C  
ATOM  21914  CE1 PHE F  85      21.079 -15.155  17.018  1.00 11.94           C  
ATOM  21915  CE2 PHE F  85      18.721 -15.545  17.575  1.00 12.19           C  
ATOM  21916  CZ  PHE F  85      20.049 -16.012  17.547  1.00 11.25           C  
ATOM  21917  N   ASP F  86      19.851  -8.852  15.733  1.00  9.88           N  
ATOM  21918  CA  ASP F  86      19.608  -7.543  15.095  1.00 10.20           C  
ATOM  21919  C   ASP F  86      19.351  -7.660  13.600  1.00 11.29           C  
ATOM  21920  O   ASP F  86      20.284  -7.990  12.865  1.00 11.85           O  
ATOM  21921  CB  ASP F  86      20.804  -6.655  15.339  1.00 10.52           C  
ATOM  21922  CG  ASP F  86      20.509  -5.167  15.023  1.00 10.47           C  
ATOM  21923  OD1 ASP F  86      19.613  -4.869  14.218  1.00 11.99           O  
ATOM  21924  OD2 ASP F  86      21.185  -4.322  15.590  1.00 11.69           O  
ATOM  21925  N   ALA F  87      18.113  -7.421  13.142  1.00 10.84           N  
ATOM  21926  CA  ALA F  87      17.787  -7.540  11.713  1.00 11.72           C  
ATOM  21927  C   ALA F  87      18.508  -6.497  10.862  1.00 12.14           C  
ATOM  21928  O   ALA F  87      18.630  -6.682   9.654  1.00 12.55           O  
ATOM  21929  CB  ALA F  87      16.252  -7.441  11.474  1.00 12.60           C  
ATOM  21930  N   GLU F  88      19.014  -5.435  11.493  1.00 11.90           N  
ATOM  21931  CA  GLU F  88      19.704  -4.361  10.800  1.00 12.84           C  
ATOM  21932  C   GLU F  88      21.230  -4.528  10.743  1.00 12.52           C  
ATOM  21933  O   GLU F  88      21.894  -3.695  10.148  1.00 13.39           O  
ATOM  21934  CB  GLU F  88      19.388  -3.027  11.456  1.00 13.39           C  
ATOM  21935  CG  GLU F  88      17.911  -2.648  11.290  1.00 13.71           C  
ATOM  21936  CD  GLU F  88      17.639  -1.273  11.904  1.00 16.59           C  
ATOM  21937  OE1 GLU F  88      17.494  -1.172  13.147  1.00 16.24           O  
ATOM  21938  OE2 GLU F  88      17.573  -0.278  11.135  1.00 17.71           O  
ATOM  21939  N   LYS F  89      21.765  -5.553  11.421  1.00 12.23           N  
ATOM  21940  CA  LYS F  89      23.196  -5.836  11.448  1.00 11.58           C  
ATOM  21941  C   LYS F  89      23.442  -7.279  11.034  1.00 11.32           C  
ATOM  21942  O   LYS F  89      24.165  -8.030  11.731  1.00 10.08           O  
ATOM  21943  CB  LYS F  89      23.775  -5.586  12.843  1.00 11.63           C  
ATOM  21944  CG  LYS F  89      23.783  -4.080  13.259  1.00 13.89           C  
ATOM  21945  CD  LYS F  89      24.743  -3.224  12.413  1.00 14.05           C  
ATOM  21946  CE  LYS F  89      24.867  -1.735  12.897  1.00 14.84           C  
ATOM  21947  NZ  LYS F  89      23.555  -1.021  12.823  1.00 15.25           N  
ATOM  21948  N   ALA F  90      22.736  -7.688   9.978  1.00 12.14           N  
ATOM  21949  CA  ALA F  90      22.894  -9.041   9.426  1.00 12.86           C  
ATOM  21950  C   ALA F  90      22.756 -10.168  10.467  1.00 13.07           C  
ATOM  21951  O   ALA F  90      23.557 -11.116  10.508  1.00 13.07           O  
ATOM  21952  CB  ALA F  90      24.315  -9.142   8.706  1.00 13.11           C  
ATOM  21953  N   GLY F  91      21.735 -10.070  11.333  1.00 11.61           N  
ATOM  21954  CA  GLY F  91      21.511 -11.110  12.297  1.00 11.50           C  
ATOM  21955  C   GLY F  91      22.437 -11.146  13.471  1.00 10.85           C  
ATOM  21956  O   GLY F  91      22.429 -12.116  14.198  1.00 11.61           O  
ATOM  21957  N   GLN F  92      23.249 -10.100  13.679  1.00 10.91           N  
ATOM  21958  CA  GLN F  92      24.187 -10.053  14.794  1.00 10.58           C  
ATOM  21959  C   GLN F  92      23.493 -10.342  16.131  1.00 10.77           C  
ATOM  21960  O   GLN F  92      22.466  -9.716  16.440  1.00 10.85           O  
ATOM  21961  CB  GLN F  92      24.808  -8.657  14.870  1.00 10.84           C  
ATOM  21962  CG  GLN F  92      25.867  -8.531  15.924  1.00 12.36           C  
ATOM  21963  CD  GLN F  92      26.542  -7.174  15.886  1.00 13.55           C  
ATOM  21964  OE1 GLN F  92      26.233  -6.271  16.661  1.00 14.34           O  
ATOM  21965  NE2 GLN F  92      27.484  -7.013  14.929  1.00 14.63           N  
ATOM  21966  N   MET F  93      24.017 -11.287  16.896  1.00  9.49           N  
ATOM  21967  CA  MET F  93      23.420 -11.555  18.202  1.00  9.87           C  
ATOM  21968  C   MET F  93      23.648 -10.392  19.148  1.00 10.36           C  
ATOM  21969  O   MET F  93      24.788 -10.050  19.491  1.00  9.75           O  
ATOM  21970  CB  MET F  93      23.983 -12.868  18.761  1.00 10.26           C  
ATOM  21971  CG  MET F  93      23.271 -13.309  20.053  1.00  9.99           C  
ATOM  21972  SD  MET F  93      23.869 -14.864  20.696  1.00 10.02           S  
ATOM  21973  CE  MET F  93      25.300 -14.370  21.472  1.00  9.77           C  
ATOM  21974  N   ILE F  94      22.547  -9.756  19.608  1.00 10.43           N  
ATOM  21975  CA  ILE F  94      22.686  -8.608  20.522  1.00 10.63           C  
ATOM  21976  C   ILE F  94      23.117  -9.060  21.946  1.00 10.73           C  
ATOM  21977  O   ILE F  94      23.979  -8.449  22.609  1.00 10.17           O  
ATOM  21978  CB  ILE F  94      21.298  -7.904  20.568  1.00  9.59           C  
ATOM  21979  CG1 ILE F  94      21.035  -7.284  19.197  1.00 10.55           C  
ATOM  21980  CG2 ILE F  94      21.315  -6.759  21.636  1.00 10.33           C  
ATOM  21981  CD1 ILE F  94      19.533  -6.899  18.941  1.00 11.31           C  
ATOM  21982  N   CYS F  95      22.470 -10.121  22.393  1.00 10.59           N  
ATOM  21983  CA  CYS F  95      22.717 -10.748  23.714  1.00 11.98           C  
ATOM  21984  C   CYS F  95      22.130 -12.135  23.548  1.00 11.60           C  
ATOM  21985  O   CYS F  95      21.153 -12.290  22.852  1.00 12.81           O  
ATOM  21986  CB  CYS F  95      21.960  -9.997  24.820  1.00 13.04           C  
ATOM  21987  SG  CYS F  95      21.935 -10.818  26.421  1.00 13.25           S  
ATOM  21988  N   GLY F  96      22.748 -13.144  24.146  1.00 11.45           N  
ATOM  21989  CA  GLY F  96      22.136 -14.471  24.031  1.00 10.91           C  
ATOM  21990  C   GLY F  96      23.083 -15.651  24.189  1.00  9.85           C  
ATOM  21991  O   GLY F  96      24.277 -15.469  24.461  1.00 10.38           O  
ATOM  21992  N   GLU F  97      22.537 -16.839  23.958  1.00  9.68           N  
ATOM  21993  CA  GLU F  97      23.322 -18.039  24.175  1.00  9.95           C  
ATOM  21994  C   GLU F  97      23.800 -18.758  22.910  1.00 10.38           C  
ATOM  21995  O   GLU F  97      24.488 -19.771  23.021  1.00 10.12           O  
ATOM  21996  CB  GLU F  97      22.490 -18.982  25.026  1.00 10.50           C  
ATOM  21997  CG  GLU F  97      22.136 -18.345  26.420  1.00 11.02           C  
ATOM  21998  CD  GLU F  97      23.306 -17.638  27.118  1.00 13.17           C  
ATOM  21999  OE1 GLU F  97      24.473 -18.121  27.048  1.00 11.69           O  
ATOM  22000  OE2 GLU F  97      23.068 -16.592  27.831  1.00 13.19           O  
ATOM  22001  N   ALA F  98      23.391 -18.242  21.773  1.00  9.93           N  
ATOM  22002  CA  ALA F  98      23.767 -18.786  20.459  1.00 10.11           C  
ATOM  22003  C   ALA F  98      25.253 -18.471  20.225  1.00 10.49           C  
ATOM  22004  O   ALA F  98      25.842 -17.598  20.869  1.00 10.25           O  
ATOM  22005  CB  ALA F  98      22.927 -18.118  19.368  1.00  9.47           C  
ATOM  22006  N   THR F  99      25.845 -19.261  19.329  1.00 10.90           N  
ATOM  22007  CA  THR F  99      27.269 -19.046  18.970  1.00 11.44           C  
ATOM  22008  C   THR F  99      27.361 -18.745  17.478  1.00 13.07           C  
ATOM  22009  O   THR F  99      28.474 -18.825  16.888  1.00 13.40           O  
ATOM  22010  CB  THR F  99      28.157 -20.284  19.295  1.00 10.35           C  
ATOM  22011  OG1 THR F  99      27.605 -21.468  18.700  1.00 10.34           O  
ATOM  22012  CG2 THR F  99      28.299 -20.403  20.798  1.00 11.31           C  
ATOM  22013  N   ALA F 100      26.236 -18.416  16.851  1.00 12.84           N  
ATOM  22014  CA  ALA F 100      26.210 -18.040  15.435  1.00 14.00           C  
ATOM  22015  C   ALA F 100      25.169 -16.920  15.293  1.00 14.20           C  
ATOM  22016  O   ALA F 100      24.164 -16.901  16.026  1.00 14.02           O  
ATOM  22017  CB  ALA F 100      25.800 -19.226  14.572  1.00 14.32           C  
ATOM  22018  N   ASP F 101      25.377 -16.015  14.360  1.00 13.35           N  
ATOM  22019  CA  ASP F 101      24.352 -15.011  14.108  1.00 13.26           C  
ATOM  22020  C   ASP F 101      23.169 -15.672  13.383  1.00 12.35           C  
ATOM  22021  O   ASP F 101      23.278 -16.805  12.857  1.00 10.97           O  
ATOM  22022  CB  ASP F 101      24.996 -13.884  13.316  1.00 16.72           C  
ATOM  22023  CG  ASP F 101      26.070 -13.190  14.148  1.00 18.25           C  
ATOM  22024  OD1 ASP F 101      25.981 -13.171  15.436  1.00 21.28           O  
ATOM  22025  OD2 ASP F 101      27.009 -12.648  13.548  1.00 23.22           O  
ATOM  22026  N   LEU F 102      22.007 -14.997  13.325  1.00 11.87           N  
ATOM  22027  CA  LEU F 102      20.813 -15.591  12.679  1.00 12.11           C  
ATOM  22028  C   LEU F 102      21.154 -15.787  11.177  1.00 12.12           C  
ATOM  22029  O   LEU F 102      21.613 -14.858  10.540  1.00 13.22           O  
ATOM  22030  CB  LEU F 102      19.649 -14.617  12.904  1.00 12.64           C  
ATOM  22031  CG  LEU F 102      18.279 -15.207  12.613  1.00 13.45           C  
ATOM  22032  CD1 LEU F 102      18.039 -16.364  13.643  1.00 11.86           C  
ATOM  22033  CD2 LEU F 102      17.216 -14.116  12.723  1.00 12.52           C  
ATOM  22034  N   PRO F 103      20.890 -16.983  10.591  1.00 12.16           N  
ATOM  22035  CA  PRO F 103      21.250 -17.160   9.174  1.00 12.35           C  
ATOM  22036  C   PRO F 103      20.565 -16.188   8.233  1.00 12.76           C  
ATOM  22037  O   PRO F 103      19.368 -15.997   8.334  1.00 13.27           O  
ATOM  22038  CB  PRO F 103      20.844 -18.613   8.866  1.00 11.82           C  
ATOM  22039  CG  PRO F 103      20.975 -19.292  10.237  1.00 11.63           C  
ATOM  22040  CD  PRO F 103      20.417 -18.230  11.199  1.00 12.47           C  
ATOM  22041  N   ARG F 104      21.316 -15.630   7.293  1.00 12.69           N  
ATOM  22042  CA  ARG F 104      20.733 -14.705   6.333  1.00 14.20           C  
ATOM  22043  C   ARG F 104      20.240 -15.424   5.104  1.00 14.47           C  
ATOM  22044  O   ARG F 104      20.951 -16.303   4.590  1.00 14.70           O  
ATOM  22045  CB  ARG F 104      21.780 -13.688   5.863  1.00 16.32           C  
ATOM  22046  CG  ARG F 104      22.106 -12.588   6.832  1.00 20.28           C  
ATOM  22047  CD  ARG F 104      22.767 -13.105   8.089  1.00 22.33           C  
ATOM  22048  NE  ARG F 104      24.144 -13.505   7.833  1.00 24.33           N  
ATOM  22049  CZ  ARG F 104      24.803 -14.424   8.536  1.00 24.66           C  
ATOM  22050  NH1 ARG F 104      24.215 -15.056   9.543  1.00 24.04           N  
ATOM  22051  NH2 ARG F 104      26.071 -14.706   8.222  1.00 25.45           N  
ATOM  22052  N   VAL F 105      19.027 -15.095   4.641  1.00 13.23           N  
ATOM  22053  CA  VAL F 105      18.550 -15.664   3.394  1.00 13.03           C  
ATOM  22054  C   VAL F 105      18.982 -14.664   2.312  1.00 13.79           C  
ATOM  22055  O   VAL F 105      18.604 -13.481   2.314  1.00 13.44           O  
ATOM  22056  CB  VAL F 105      17.014 -15.861   3.375  1.00 13.38           C  
ATOM  22057  CG1 VAL F 105      16.520 -16.237   1.937  1.00 14.13           C  
ATOM  22058  CG2 VAL F 105      16.669 -16.907   4.410  1.00 13.00           C  
ATOM  22059  N   LEU F 106      19.817 -15.134   1.386  1.00 13.28           N  
ATOM  22060  CA  LEU F 106      20.273 -14.284   0.296  1.00 13.86           C  
ATOM  22061  C   LEU F 106      19.165 -14.039  -0.725  1.00 12.99           C  
ATOM  22062  O   LEU F 106      18.564 -14.941  -1.228  1.00 13.38           O  
ATOM  22063  CB  LEU F 106      21.480 -14.943  -0.398  1.00 14.23           C  
ATOM  22064  CG  LEU F 106      22.569 -15.330   0.606  1.00 16.15           C  
ATOM  22065  CD1 LEU F 106      23.746 -15.910  -0.201  1.00 17.38           C  
ATOM  22066  CD2 LEU F 106      23.037 -14.141   1.420  1.00 17.33           C  
ATOM  22067  N   LEU F 107      18.896 -12.769  -0.987  1.00 13.80           N  
ATOM  22068  CA  LEU F 107      17.858 -12.370  -1.925  1.00 14.52           C  
ATOM  22069  C   LEU F 107      18.421 -11.708  -3.161  1.00 14.44           C  
ATOM  22070  O   LEU F 107      19.353 -10.898  -3.082  1.00 15.96           O  
ATOM  22071  CB  LEU F 107      16.922 -11.333  -1.296  1.00 14.16           C  
ATOM  22072  CG  LEU F 107      16.189 -11.753  -0.016  1.00 14.50           C  
ATOM  22073  CD1 LEU F 107      15.453 -10.474   0.509  1.00 15.55           C  
ATOM  22074  CD2 LEU F 107      15.204 -12.817  -0.285  1.00 14.60           C  
ATOM  22075  N   ARG F 108      17.827 -12.035  -4.293  1.00 15.03           N  
ATOM  22076  CA  ARG F 108      18.195 -11.386  -5.525  1.00 15.72           C  
ATOM  22077  C   ARG F 108      17.011 -10.429  -5.822  1.00 15.08           C  
ATOM  22078  O   ARG F 108      15.851 -10.829  -5.701  1.00 15.54           O  
ATOM  22079  CB  ARG F 108      18.306 -12.398  -6.669  1.00 18.12           C  
ATOM  22080  CG  ARG F 108      18.651 -11.739  -8.007  1.00 22.16           C  
ATOM  22081  CD  ARG F 108      18.756 -12.791  -9.114  1.00 25.58           C  
ATOM  22082  NE  ARG F 108      17.474 -13.314  -9.586  1.00 28.77           N  
ATOM  22083  CZ  ARG F 108      17.258 -14.593  -9.889  1.00 30.20           C  
ATOM  22084  NH1 ARG F 108      18.227 -15.495  -9.750  1.00 30.84           N  
ATOM  22085  NH2 ARG F 108      16.097 -14.958 -10.417  1.00 31.40           N  
ATOM  22086  N   TYR F 109      17.310  -9.194  -6.167  1.00 14.54           N  
ATOM  22087  CA  TYR F 109      16.281  -8.245  -6.576  1.00 14.67           C  
ATOM  22088  C   TYR F 109      16.470  -8.043  -8.087  1.00 14.58           C  
ATOM  22089  O   TYR F 109      17.576  -7.665  -8.520  1.00 14.32           O  
ATOM  22090  CB  TYR F 109      16.446  -6.911  -5.866  1.00 14.62           C  
ATOM  22091  CG  TYR F 109      15.457  -5.904  -6.408  1.00 16.49           C  
ATOM  22092  CD1 TYR F 109      15.904  -4.767  -7.062  1.00 16.38           C  
ATOM  22093  CD2 TYR F 109      14.065  -6.155  -6.368  1.00 15.27           C  
ATOM  22094  CE1 TYR F 109      15.001  -3.889  -7.704  1.00 16.00           C  
ATOM  22095  CE2 TYR F 109      13.149  -5.269  -6.997  1.00 14.88           C  
ATOM  22096  CZ  TYR F 109      13.637  -4.157  -7.660  1.00 16.53           C  
ATOM  22097  OH  TYR F 109      12.769  -3.314  -8.328  1.00 17.20           O  
ATOM  22098  N   ASP F 110      15.412  -8.299  -8.856  1.00 14.51           N  
ATOM  22099  CA  ASP F 110      15.449  -8.160 -10.308  1.00 15.04           C  
ATOM  22100  C   ASP F 110      14.668  -6.886 -10.716  1.00 15.41           C  
ATOM  22101  O   ASP F 110      13.453  -6.907 -10.674  1.00 15.18           O  
ATOM  22102  CB  ASP F 110      14.819  -9.426 -10.883  1.00 15.89           C  
ATOM  22103  CG  ASP F 110      14.847  -9.484 -12.392  1.00 16.78           C  
ATOM  22104  OD1 ASP F 110      14.928  -8.415 -13.010  1.00 17.82           O  
ATOM  22105  OD2 ASP F 110      14.755 -10.614 -12.929  1.00 18.03           O  
ATOM  22106  N   ALA F 111      15.370  -5.813 -11.071  1.00 14.92           N  
ATOM  22107  CA  ALA F 111      14.717  -4.564 -11.483  1.00 14.88           C  
ATOM  22108  C   ALA F 111      13.742  -4.706 -12.678  1.00 15.00           C  
ATOM  22109  O   ALA F 111      12.692  -4.000 -12.733  1.00 15.13           O  
ATOM  22110  CB  ALA F 111      15.794  -3.466 -11.775  1.00 15.92           C  
ATOM  22111  N   ALA F 112      14.021  -5.608 -13.631  1.00 13.53           N  
ATOM  22112  CA  ALA F 112      13.157  -5.760 -14.808  1.00 12.97           C  
ATOM  22113  C   ALA F 112      11.764  -6.258 -14.480  1.00 12.99           C  
ATOM  22114  O   ALA F 112      10.806  -5.967 -15.200  1.00 12.82           O  
ATOM  22115  CB  ALA F 112      13.797  -6.768 -15.799  1.00 13.37           C  
ATOM  22116  N   SER F 113      11.648  -7.043 -13.406  1.00 12.68           N  
ATOM  22117  CA  SER F 113      10.350  -7.630 -13.013  1.00 12.87           C  
ATOM  22118  C   SER F 113       9.862  -7.143 -11.642  1.00 13.22           C  
ATOM  22119  O   SER F 113       8.688  -7.376 -11.307  1.00 12.74           O  
ATOM  22120  CB  SER F 113      10.482  -9.142 -12.917  1.00 13.21           C  
ATOM  22121  OG  SER F 113      11.493  -9.404 -11.942  1.00 13.65           O  
ATOM  22122  N   ASP F 114      10.773  -6.536 -10.888  1.00 13.04           N  
ATOM  22123  CA  ASP F 114      10.585  -6.063  -9.494  1.00 13.94           C  
ATOM  22124  C   ASP F 114      10.585  -7.272  -8.531  1.00 13.85           C  
ATOM  22125  O   ASP F 114      10.277  -7.114  -7.338  1.00 14.60           O  
ATOM  22126  CB  ASP F 114       9.280  -5.218  -9.319  1.00 14.00           C  
ATOM  22127  CG  ASP F 114       9.256  -4.468  -7.963  1.00 15.24           C  
ATOM  22128  OD1 ASP F 114      10.286  -3.901  -7.574  1.00 15.32           O  
ATOM  22129  OD2 ASP F 114       8.197  -4.450  -7.294  1.00 17.00           O  
ATOM  22130  N   ALA F 115      10.905  -8.471  -9.040  1.00 12.70           N  
ATOM  22131  CA  ALA F 115      10.899  -9.698  -8.229  1.00 13.23           C  
ATOM  22132  C   ALA F 115      12.003  -9.860  -7.209  1.00 13.45           C  
ATOM  22133  O   ALA F 115      13.161  -9.487  -7.467  1.00 13.42           O  
ATOM  22134  CB  ALA F 115      10.897 -10.923  -9.130  1.00 13.26           C  
ATOM  22135  N   LEU F 116      11.643 -10.388  -6.032  1.00 13.04           N  
ATOM  22136  CA  LEU F 116      12.613 -10.738  -4.959  1.00 12.99           C  
ATOM  22137  C   LEU F 116      12.610 -12.281  -4.949  1.00 13.52           C  
ATOM  22138  O   LEU F 116      11.568 -12.929  -4.861  1.00 13.64           O  
ATOM  22139  CB  LEU F 116      12.151 -10.235  -3.577  1.00 13.96           C  
ATOM  22140  CG  LEU F 116      12.245  -8.718  -3.449  1.00 14.55           C  
ATOM  22141  CD1 LEU F 116      11.280  -8.190  -2.316  1.00 15.12           C  
ATOM  22142  CD2 LEU F 116      13.673  -8.356  -3.127  1.00 14.60           C  
ATOM  22143  N   THR F 117      13.795 -12.872  -5.057  1.00 13.50           N  
ATOM  22144  CA  THR F 117      13.926 -14.326  -5.088  1.00 13.92           C  
ATOM  22145  C   THR F 117      14.936 -14.746  -4.033  1.00 13.61           C  
ATOM  22146  O   THR F 117      16.001 -14.123  -3.937  1.00 14.80           O  
ATOM  22147  CB  THR F 117      14.445 -14.753  -6.502  1.00 13.98           C  
ATOM  22148  OG1 THR F 117      13.528 -14.275  -7.494  1.00 15.94           O  
ATOM  22149  CG2 THR F 117      14.480 -16.285  -6.633  1.00 14.95           C  
ATOM  22150  N   ALA F 118      14.630 -15.789  -3.258  1.00 13.67           N  
ATOM  22151  CA  ALA F 118      15.550 -16.298  -2.220  1.00 12.95           C  
ATOM  22152  C   ALA F 118      16.447 -17.252  -3.017  1.00 13.60           C  
ATOM  22153  O   ALA F 118      15.954 -18.166  -3.695  1.00 12.81           O  
ATOM  22154  CB  ALA F 118      14.785 -17.079  -1.152  1.00 13.13           C  
ATOM  22155  N   VAL F 119      17.755 -17.046  -2.915  1.00 13.48           N  
ATOM  22156  CA  VAL F 119      18.639 -17.888  -3.713  1.00 13.77           C  
ATOM  22157  C   VAL F 119      19.755 -18.607  -2.942  1.00 14.51           C  
ATOM  22158  O   VAL F 119      20.456 -19.443  -3.527  1.00 14.87           O  
ATOM  22159  CB  VAL F 119      19.299 -17.081  -4.890  1.00 14.10           C  
ATOM  22160  CG1 VAL F 119      18.212 -16.565  -5.864  1.00 14.88           C  
ATOM  22161  CG2 VAL F 119      20.132 -15.956  -4.375  1.00 14.72           C  
ATOM  22162  N   GLY F 120      19.928 -18.313  -1.665  1.00 12.86           N  
ATOM  22163  CA  GLY F 120      20.951 -19.014  -0.903  1.00 12.94           C  
ATOM  22164  C   GLY F 120      20.783 -18.678   0.558  1.00 13.43           C  
ATOM  22165  O   GLY F 120      19.884 -17.881   0.906  1.00 12.79           O  
ATOM  22166  N   VAL F 121      21.606 -19.285   1.408  1.00 12.44           N  
ATOM  22167  CA  VAL F 121      21.587 -18.993   2.836  1.00 12.91           C  
ATOM  22168  C   VAL F 121      23.033 -18.821   3.307  1.00 13.13           C  
ATOM  22169  O   VAL F 121      23.904 -19.612   2.934  1.00 13.90           O  
ATOM  22170  CB  VAL F 121      20.938 -20.134   3.619  1.00 12.48           C  
ATOM  22171  CG1 VAL F 121      20.943 -19.800   5.174  1.00 13.98           C  
ATOM  22172  CG2 VAL F 121      19.490 -20.331   3.125  1.00 13.26           C  
ATOM  22173  N   ASP F 122      23.290 -17.780   4.086  1.00 12.98           N  
ATOM  22174  CA  ASP F 122      24.631 -17.535   4.650  1.00 13.84           C  
ATOM  22175  C   ASP F 122      24.501 -17.876   6.143  1.00 13.83           C  
ATOM  22176  O   ASP F 122      23.882 -17.120   6.871  1.00 13.62           O  
ATOM  22177  CB  ASP F 122      25.043 -16.062   4.427  1.00 16.21           C  
ATOM  22178  CG  ASP F 122      26.377 -15.695   5.090  1.00 18.87           C  
ATOM  22179  OD1 ASP F 122      27.113 -16.607   5.526  1.00 20.95           O  
ATOM  22180  OD2 ASP F 122      26.715 -14.473   5.195  1.00 22.90           O  
ATOM  22181  N   GLY F 123      25.094 -18.994   6.572  1.00 12.81           N  
ATOM  22182  CA  GLY F 123      25.002 -19.442   7.964  1.00 13.86           C  
ATOM  22183  C   GLY F 123      24.291 -20.779   7.898  1.00 13.49           C  
ATOM  22184  O   GLY F 123      23.669 -21.074   6.867  1.00 15.41           O  
ATOM  22185  N   LEU F 124      24.351 -21.596   8.963  1.00 12.53           N  
ATOM  22186  CA  LEU F 124      23.723 -22.889   8.882  1.00 12.13           C  
ATOM  22187  C   LEU F 124      22.411 -22.839   9.689  1.00 11.70           C  
ATOM  22188  O   LEU F 124      22.469 -22.532  10.874  1.00 11.84           O  
ATOM  22189  CB  LEU F 124      24.639 -23.973   9.491  1.00 11.36           C  
ATOM  22190  CG  LEU F 124      24.115 -25.420   9.612  1.00 12.79           C  
ATOM  22191  CD1 LEU F 124      23.583 -26.011   8.266  1.00 12.91           C  
ATOM  22192  CD2 LEU F 124      25.218 -26.285  10.187  1.00 14.17           C  
ATOM  22193  N   ILE F 125      21.317 -23.130   9.015  1.00 11.11           N  
ATOM  22194  CA  ILE F 125      19.988 -23.156   9.667  1.00 11.12           C  
ATOM  22195  C   ILE F 125      19.998 -24.207  10.786  1.00 11.56           C  
ATOM  22196  O   ILE F 125      20.578 -25.323  10.700  1.00 11.23           O  
ATOM  22197  CB  ILE F 125      18.922 -23.498   8.591  1.00 11.82           C  
ATOM  22198  CG1 ILE F 125      18.752 -22.317   7.617  1.00 11.15           C  
ATOM  22199  CG2 ILE F 125      17.508 -23.869   9.265  1.00 11.64           C  
ATOM  22200  CD1 ILE F 125      18.123 -22.690   6.303  1.00 12.50           C  
ATOM  22201  N   TYR F 126      19.338 -23.882  11.909  1.00 10.81           N  
ATOM  22202  CA  TYR F 126      19.202 -24.835  12.993  1.00 11.00           C  
ATOM  22203  C   TYR F 126      18.640 -26.206  12.597  1.00 11.06           C  
ATOM  22204  O   TYR F 126      17.751 -26.314  11.756  1.00 12.45           O  
ATOM  22205  CB  TYR F 126      18.193 -24.264  14.053  1.00 10.86           C  
ATOM  22206  CG  TYR F 126      17.753 -25.335  15.026  1.00  9.98           C  
ATOM  22207  CD1 TYR F 126      16.551 -26.067  14.819  1.00 10.65           C  
ATOM  22208  CD2 TYR F 126      18.575 -25.683  16.083  1.00 10.41           C  
ATOM  22209  CE1 TYR F 126      16.192 -27.151  15.689  1.00 10.68           C  
ATOM  22210  CE2 TYR F 126      18.256 -26.756  16.967  1.00 10.68           C  
ATOM  22211  CZ  TYR F 126      17.049 -27.476  16.743  1.00 10.45           C  
ATOM  22212  OH  TYR F 126      16.766 -28.514  17.597  1.00 11.85           O  
ATOM  22213  N   GLY F 127      19.151 -27.233  13.267  1.00 12.40           N  
ATOM  22214  CA  GLY F 127      18.567 -28.545  13.180  1.00 12.75           C  
ATOM  22215  C   GLY F 127      18.710 -29.357  11.945  1.00 12.92           C  
ATOM  22216  O   GLY F 127      17.862 -30.184  11.653  1.00 13.34           O  
ATOM  22217  N   ARG F 128      19.770 -29.074  11.198  1.00 13.28           N  
ATOM  22218  CA  ARG F 128      19.978 -29.860   9.974  1.00 13.82           C  
ATOM  22219  C   ARG F 128      21.493 -29.953   9.761  1.00 14.58           C  
ATOM  22220  O   ARG F 128      22.284 -29.123  10.229  1.00 14.46           O  
ATOM  22221  CB  ARG F 128      19.239 -29.260   8.767  1.00 15.03           C  
ATOM  22222  CG  ARG F 128      19.402 -27.775   8.597  1.00 15.09           C  
ATOM  22223  CD  ARG F 128      18.541 -27.209   7.443  1.00 14.27           C  
ATOM  22224  NE  ARG F 128      17.067 -27.353   7.661  1.00 13.92           N  
ATOM  22225  CZ  ARG F 128      16.162 -27.269   6.685  1.00 14.49           C  
ATOM  22226  NH1 ARG F 128      16.545 -27.034   5.426  1.00 13.60           N  
ATOM  22227  NH2 ARG F 128      14.862 -27.501   6.927  1.00 13.44           N  
ATOM  22228  N   GLN F 129      21.880 -31.028   9.078  1.00 13.93           N  
ATOM  22229  CA  GLN F 129      23.285 -31.281   8.865  1.00 13.64           C  
ATOM  22230  C   GLN F 129      23.838 -30.412   7.722  1.00 13.35           C  
ATOM  22231  O   GLN F 129      25.045 -30.119   7.682  1.00 14.57           O  
ATOM  22232  CB  GLN F 129      23.439 -32.804   8.616  1.00 13.91           C  
ATOM  22233  CG  GLN F 129      24.862 -33.250   8.214  1.00 14.45           C  
ATOM  22234  CD  GLN F 129      25.084 -33.100   6.723  1.00 15.37           C  
ATOM  22235  OE1 GLN F 129      24.157 -33.308   5.919  1.00 15.52           O  
ATOM  22236  NE2 GLN F 129      26.324 -32.758   6.333  1.00 15.11           N  
ATOM  22237  N   ALA F 130      22.954 -29.967   6.827  1.00 13.19           N  
ATOM  22238  CA  ALA F 130      23.332 -29.079   5.730  1.00 13.02           C  
ATOM  22239  C   ALA F 130      22.090 -28.211   5.460  1.00 13.35           C  
ATOM  22240  O   ALA F 130      20.985 -28.640   5.760  1.00 13.17           O  
ATOM  22241  CB  ALA F 130      23.693 -29.918   4.477  1.00 13.76           C  
ATOM  22242  N   ASN F 131      22.261 -27.010   4.910  1.00 13.59           N  
ATOM  22243  CA  ASN F 131      21.097 -26.159   4.622  1.00 13.19           C  
ATOM  22244  C   ASN F 131      20.086 -26.810   3.695  1.00 14.32           C  
ATOM  22245  O   ASN F 131      18.881 -26.597   3.838  1.00 14.31           O  
ATOM  22246  CB  ASN F 131      21.535 -24.804   4.074  1.00 12.68           C  
ATOM  22247  CG  ASN F 131      21.953 -23.847   5.185  1.00 13.48           C  
ATOM  22248  OD1 ASN F 131      21.500 -23.996   6.341  1.00 14.22           O  
ATOM  22249  ND2 ASN F 131      22.779 -22.875   4.859  1.00 12.55           N  
ATOM  22250  N   VAL F 132      20.561 -27.653   2.768  1.00 13.94           N  
ATOM  22251  CA  VAL F 132      19.694 -28.375   1.857  1.00 15.14           C  
ATOM  22252  C   VAL F 132      19.711 -29.822   2.321  1.00 16.51           C  
ATOM  22253  O   VAL F 132      20.773 -30.431   2.457  1.00 16.17           O  
ATOM  22254  CB  VAL F 132      20.188 -28.263   0.390  1.00 15.18           C  
ATOM  22255  CG1 VAL F 132      19.412 -29.232  -0.549  1.00 16.10           C  
ATOM  22256  CG2 VAL F 132      19.974 -26.817  -0.076  1.00 15.50           C  
ATOM  22257  N   ILE F 133      18.540 -30.326   2.682  1.00 17.47           N  
ATOM  22258  CA  ILE F 133      18.411 -31.691   3.149  1.00 18.98           C  
ATOM  22259  C   ILE F 133      18.172 -32.596   1.936  1.00 19.92           C  
ATOM  22260  O   ILE F 133      17.137 -32.410   1.246  1.00 21.42           O  
ATOM  22261  CB  ILE F 133      17.214 -31.812   4.147  1.00 19.51           C  
ATOM  22262  CG1 ILE F 133      17.512 -31.025   5.423  1.00 20.08           C  
ATOM  22263  CG2 ILE F 133      16.911 -33.302   4.428  1.00 20.06           C  
ATOM  22264  CD1 ILE F 133      16.268 -30.890   6.327  1.00 20.04           C  
ATOM  22265  OXT ILE F 133      19.013 -33.488   1.655  1.00 20.68           O  
TER   22266      ILE F 133                                                      
END
MOLECULE T0391.pdb
ATOM      1  N   LYS    14      20.058 -27.031  -4.627  1.00 60.80           N  
ATOM      2  CA  LYS    14      18.878 -26.160  -4.323  1.00 60.75           C  
ATOM      3  C   LYS    14      19.298 -24.755  -3.828  1.00 60.82           C  
ATOM      4  O   LYS    14      18.794 -24.243  -2.809  1.00 60.89           O  
ATOM      5  CB  LYS    14      17.912 -26.875  -3.349  1.00 60.75           C  
ATOM      6  CG  LYS    14      18.148 -26.678  -1.832  1.00 60.46           C  
ATOM      7  CD  LYS    14      19.239 -27.549  -1.251  1.00 60.49           C  
ATOM      8  CE  LYS    14      19.374 -27.296   0.246  1.00 60.57           C  
ATOM      9  NZ  LYS    14      20.401 -28.172   0.889  1.00 60.29           N  
ATOM     10  N   TYR    15      20.208 -24.127  -4.570  1.00 60.44           N  
ATOM     11  CA  TYR    15      20.748 -22.827  -4.172  1.00 60.31           C  
ATOM     12  C   TYR    15      20.596 -21.697  -5.214  1.00 60.11           C  
ATOM     13  O   TYR    15      21.466 -20.821  -5.310  1.00 60.31           O  
ATOM     14  CB  TYR    15      22.220 -22.960  -3.731  1.00 60.66           C  
ATOM     15  CG  TYR    15      22.442 -23.716  -2.429  1.00 60.97           C  
ATOM     16  CD1 TYR    15      22.806 -25.063  -2.440  1.00 60.98           C  
ATOM     17  CD2 TYR    15      22.302 -23.081  -1.190  1.00 60.95           C  
ATOM     18  CE1 TYR    15      23.019 -25.762  -1.253  1.00 61.49           C  
ATOM     19  CE2 TYR    15      22.510 -23.773   0.005  1.00 60.54           C  
ATOM     20  CZ  TYR    15      22.870 -25.113  -0.036  1.00 61.22           C  
ATOM     21  OH  TYR    15      23.090 -25.813   1.132  1.00 61.20           O  
ATOM     22  N   THR    16      19.512 -21.700  -5.992  1.00 59.68           N  
ATOM     23  CA  THR    16      19.188 -20.514  -6.815  1.00 59.63           C  
ATOM     24  C   THR    16      17.836 -19.878  -6.426  1.00 58.97           C  
ATOM     25  O   THR    16      17.024 -20.493  -5.734  1.00 58.66           O  
ATOM     26  CB  THR    16      19.340 -20.760  -8.367  1.00 59.50           C  
ATOM     27  OG1 THR    16      20.712 -21.057  -8.684  1.00 60.71           O  
ATOM     28  CG2 THR    16      18.927 -19.524  -9.191  1.00 59.37           C  
ATOM     29  N   SER    17      17.657 -18.629  -6.856  1.00 59.10           N  
ATOM     30  CA  SER    17      16.500 -17.778  -6.591  1.00 59.12           C  
ATOM     31  C   SER    17      15.164 -18.496  -6.522  1.00 59.74           C  
ATOM     32  O   SER    17      14.808 -19.277  -7.416  1.00 58.25           O  
ATOM     33  CB  SER    17      16.366 -16.691  -7.673  1.00 59.23           C  
ATOM     34  OG  SER    17      17.578 -15.976  -7.871  1.00 60.17           O  
ATOM     35  N   VAL    18      14.428 -18.199  -5.452  1.00 59.57           N  
ATOM     36  CA  VAL    18      13.002 -18.454  -5.422  1.00 59.94           C  
ATOM     37  C   VAL    18      12.366 -17.085  -5.284  1.00 60.39           C  
ATOM     38  O   VAL    18      12.744 -16.309  -4.419  1.00 59.98           O  
ATOM     39  CB  VAL    18      12.613 -19.377  -4.253  1.00 59.90           C  
ATOM     40  CG1 VAL    18      11.086 -19.572  -4.178  1.00 59.62           C  
ATOM     41  CG2 VAL    18      13.318 -20.729  -4.393  1.00 59.73           C  
ATOM     42  N   CYS    19      11.436 -16.772  -6.177  1.00 62.03           N  
ATOM     43  CA  CYS    19      10.675 -15.546  -6.087  1.00 62.30           C  
ATOM     44  C   CYS    19       9.657 -15.686  -4.943  1.00 62.67           C  
ATOM     45  O   CYS    19       8.778 -16.538  -4.994  1.00 63.44           O  
ATOM     46  CB  CYS    19       9.969 -15.293  -7.396  1.00 62.62           C  
ATOM     47  SG  CYS    19       9.161 -13.703  -7.475  1.00 64.96           S  
ATOM     48  N   VAL    20       9.769 -14.851  -3.922  1.00 61.58           N  
ATOM     49  CA  VAL    20       8.958 -15.045  -2.708  1.00 61.49           C  
ATOM     50  C   VAL    20       7.766 -14.103  -2.702  1.00 62.35           C  
ATOM     51  O   VAL    20       6.872 -14.191  -1.856  1.00 63.15           O  
ATOM     52  CB  VAL    20       9.817 -14.911  -1.438  1.00 61.03           C  
ATOM     53  CG1 VAL    20      10.940 -15.911  -1.487  1.00 60.15           C  
ATOM     54  CG2 VAL    20      10.377 -13.514  -1.277  1.00 59.18           C  
ATOM     55  N   GLY    21       7.748 -13.211  -3.677  1.00 62.13           N  
ATOM     56  CA  GLY    21       6.681 -12.283  -3.790  1.00 62.19           C  
ATOM     57  C   GLY    21       7.038 -10.922  -4.329  1.00 62.64           C  
ATOM     58  O   GLY    21       8.104 -10.689  -4.947  1.00 62.35           O  
ATOM     59  N   ARG    22       6.090 -10.026  -4.089  1.00 62.17           N  
ATOM     60  CA  ARG    22       6.044  -8.731  -4.705  1.00 62.01           C  
ATOM     61  C   ARG    22       6.671  -7.685  -3.777  1.00 61.91           C  
ATOM     62  O   ARG    22       6.357  -7.629  -2.585  1.00 60.50           O  
ATOM     63  CB  ARG    22       4.576  -8.423  -4.962  1.00 62.52           C  
ATOM     64  CG  ARG    22       4.336  -7.596  -6.112  1.00 62.38           C  
ATOM     65  CD  ARG    22       2.862  -7.377  -6.307  1.00 63.37           C  
ATOM     66  NE  ARG    22       2.766  -6.247  -7.197  1.00 63.29           N  
ATOM     67  CZ  ARG    22       1.689  -5.863  -7.852  1.00 63.14           C  
ATOM     68  NH1 ARG    22       0.531  -6.515  -7.735  1.00 64.35           N  
ATOM     69  NH2 ARG    22       1.798  -4.807  -8.631  1.00 63.71           N  
ATOM     70  N   GLU    23       7.582  -6.874  -4.323  1.00 62.10           N  
ATOM     71  CA  GLU    23       8.103  -5.723  -3.602  1.00 62.33           C  
ATOM     72  C   GLU    23       6.970  -4.911  -2.955  1.00 62.52           C  
ATOM     73  O   GLU    23       7.045  -4.564  -1.781  1.00 63.44           O  
ATOM     74  CB  GLU    23       8.955  -4.850  -4.518  1.00 62.11           C  
ATOM     75  CG  GLU    23       9.910  -3.962  -3.752  1.00 63.73           C  
ATOM     76  CD  GLU    23      11.098  -3.492  -4.568  1.00 66.02           C  
ATOM     77  OE1 GLU    23      10.913  -3.119  -5.754  1.00 65.65           O  
ATOM     78  OE2 GLU    23      12.214  -3.482  -4.000  1.00 68.05           O  
ATOM     79  N   GLU    24       5.899  -4.665  -3.694  1.00 62.66           N  
ATOM     80  CA  GLU    24       4.773  -3.927  -3.141  1.00 63.27           C  
ATOM     81  C   GLU    24       4.077  -4.577  -1.938  1.00 63.16           C  
ATOM     82  O   GLU    24       3.586  -3.872  -1.053  1.00 63.14           O  
ATOM     83  CB  GLU    24       3.737  -3.650  -4.220  1.00 63.14           C  
ATOM     84  CG  GLU    24       4.183  -2.647  -5.259  1.00 65.00           C  
ATOM     85  CD  GLU    24       3.009  -2.112  -6.065  1.00 65.66           C  
ATOM     86  OE1 GLU    24       1.919  -2.735  -5.998  1.00 65.11           O  
ATOM     87  OE2 GLU    24       3.167  -1.071  -6.749  1.00 66.96           O  
ATOM     88  N   ASP    25       4.034  -5.902  -1.911  0.70 63.36           N  
ATOM     90  CA  ASP    25       3.305  -6.600  -0.868  0.70 63.79           C  
ATOM     92  C   ASP    25       4.028  -6.560   0.493  0.70 64.46           C  
ATOM     94  O   ASP    25       3.372  -6.638   1.542  0.70 64.77           O  
ATOM     96  CB  ASP    25       2.955  -8.031  -1.327  0.70 63.62           C  
ATOM     98  CG  ASP    25       1.892  -8.063  -2.468  0.70 63.86           C  
ATOM    100  OD1 ASP    25       1.400  -6.997  -2.932  0.70 61.48           O  
ATOM    102  OD2 ASP    25       1.538  -9.184  -2.900  0.70 64.42           O  
ATOM    104  N   ILE    26       5.358  -6.389   0.475  1.00 64.67           N  
ATOM    105  CA  ILE    26       6.187  -6.428   1.701  1.00 65.33           C  
ATOM    106  C   ILE    26       6.448  -5.038   2.254  1.00 66.28           C  
ATOM    107  O   ILE    26       6.715  -4.879   3.435  1.00 65.81           O  
ATOM    108  CB  ILE    26       7.568  -7.115   1.511  1.00 65.79           C  
ATOM    109  CG1 ILE    26       8.114  -7.590   2.873  1.00 65.49           C  
ATOM    110  CG2 ILE    26       8.578  -6.164   0.865  1.00 65.24           C  
ATOM    111  CD1 ILE    26       9.526  -8.114   2.841  1.00 64.46           C  
ATOM    112  N   ARG    27       6.376  -4.026   1.393  1.00 67.72           N  
ATOM    113  CA  ARG    27       6.661  -2.672   1.844  1.00 68.35           C  
ATOM    114  C   ARG    27       5.635  -2.232   2.887  1.00 68.20           C  
ATOM    115  O   ARG    27       6.004  -1.667   3.921  1.00 68.03           O  
ATOM    116  CB  ARG    27       6.823  -1.716   0.661  1.00 68.79           C  
ATOM    117  CG  ARG    27       8.136  -2.014  -0.065  1.00 70.71           C  
ATOM    118  CD  ARG    27       8.676  -0.888  -0.957  1.00 74.28           C  
ATOM    119  NE  ARG    27      10.113  -1.118  -1.136  1.00 76.73           N  
ATOM    120  CZ  ARG    27      10.900  -0.543  -2.046  1.00 77.51           C  
ATOM    121  NH1 ARG    27      10.418   0.335  -2.925  1.00 77.15           N  
ATOM    122  NH2 ARG    27      12.190  -0.862  -2.073  1.00 77.51           N  
ATOM    123  N   LYS    28       4.372  -2.577   2.641  1.00 68.05           N  
ATOM    124  CA  LYS    28       3.278  -2.331   3.573  1.00 67.84           C  
ATOM    125  C   LYS    28       3.515  -2.907   4.993  1.00 67.37           C  
ATOM    126  O   LYS    28       3.664  -2.148   5.957  1.00 67.14           O  
ATOM    127  CB  LYS    28       1.968  -2.845   2.957  1.00 68.52           C  
ATOM    128  CG  LYS    28       0.709  -2.558   3.781  1.00 69.95           C  
ATOM    129  CD  LYS    28      -0.479  -2.274   2.855  1.00 72.90           C  
ATOM    130  CE  LYS    28      -1.783  -2.048   3.625  1.00 74.32           C  
ATOM    131  NZ  LYS    28      -2.286  -3.344   4.158  1.00 76.24           N  
ATOM    132  N   SER    29       3.569  -4.235   5.119  1.00 66.72           N  
ATOM    133  CA  SER    29       3.748  -4.885   6.425  1.00 66.15           C  
ATOM    134  C   SER    29       5.187  -4.873   6.935  1.00 64.97           C  
ATOM    135  O   SER    29       5.459  -5.154   8.118  1.00 65.03           O  
ATOM    136  CB  SER    29       3.311  -6.336   6.336  1.00 66.89           C  
ATOM    137  OG  SER    29       4.355  -7.108   5.765  1.00 69.45           O  
ATOM    138  N   GLU    30       6.122  -4.606   6.034  1.00 62.79           N  
ATOM    139  CA  GLU    30       7.546  -4.652   6.367  1.00 60.91           C  
ATOM    140  C   GLU    30       8.128  -6.009   6.779  1.00 58.63           C  
ATOM    141  O   GLU    30       9.300  -6.064   7.176  1.00 57.90           O  
ATOM    142  CB  GLU    30       7.939  -3.541   7.349  1.00 61.73           C  
ATOM    143  CG  GLU    30       8.166  -2.226   6.596  1.00 64.11           C  
ATOM    144  CD  GLU    30       8.775  -1.124   7.442  1.00 68.01           C  
ATOM    145  OE1 GLU    30       8.252  -0.881   8.554  1.00 68.86           O  
ATOM    146  OE2 GLU    30       9.756  -0.484   6.970  1.00 69.07           O  
ATOM    147  N   ARG    31       7.333  -7.073   6.654  1.00 55.43           N  
ATOM    148  CA  ARG    31       7.814  -8.461   6.773  1.00 54.94           C  
ATOM    149  C   ARG    31       6.873  -9.468   6.122  1.00 55.34           C  
ATOM    150  O   ARG    31       5.669  -9.251   6.054  1.00 53.56           O  
ATOM    151  CB  ARG    31       8.017  -8.868   8.213  1.00 53.83           C  
ATOM    152  CG  ARG    31       6.689  -9.135   8.913  1.00 56.18           C  
ATOM    153  CD  ARG    31       6.870  -9.241  10.351  1.00 54.41           C  
ATOM    154  NE  ARG    31       7.484  -8.051  10.931  1.00 47.57           N  
ATOM    155  CZ  ARG    31       7.953  -8.038  12.168  1.00 43.51           C  
ATOM    156  NH1 ARG    31       7.864  -9.153  12.893  1.00 42.00           N  
ATOM    157  NH2 ARG    31       8.477  -6.939  12.679  1.00 40.05           N  
ATOM    158  N   MET    32       7.432 -10.587   5.679  1.00 57.33           N  
ATOM    159  CA  MET    32       6.647 -11.708   5.128  1.00 60.41           C  
ATOM    160  C   MET    32       7.435 -12.995   5.296  1.00 59.05           C  
ATOM    161  O   MET    32       8.664 -12.974   5.342  1.00 60.30           O  
ATOM    162  CB  MET    32       6.358 -11.492   3.619  1.00 59.37           C  
ATOM    163  CG  MET    32       7.571 -11.596   2.693  1.00 63.82           C  
ATOM    164  SD  MET    32       7.112 -11.204   0.978  1.00 69.27           S  
ATOM    165  CE  MET    32       5.647 -10.216   1.194  1.00 68.77           C  
ATOM    166  N   THR    33       6.752 -14.125   5.326  1.00 57.39           N  
ATOM    167  CA  THR    33       7.468 -15.385   5.383  1.00 55.82           C  
ATOM    168  C   THR    33       7.420 -16.058   3.993  1.00 56.31           C  
ATOM    169  O   THR    33       6.532 -15.751   3.131  1.00 54.99           O  
ATOM    170  CB  THR    33       6.882 -16.321   6.457  1.00 56.65           C  
ATOM    171  OG1 THR    33       5.603 -16.815   5.987  1.00 56.10           O  
ATOM    172  CG2 THR    33       6.697 -15.553   7.836  1.00 55.74           C  
ATOM    173  N   ALA    34       8.335 -16.989   3.761  1.00 54.34           N  
ATOM    174  CA  ALA    34       8.184 -17.826   2.570  1.00 54.83           C  
ATOM    175  C   ALA    34       8.807 -19.181   2.790  1.00 53.98           C  
ATOM    176  O   ALA    34       9.635 -19.352   3.681  1.00 53.23           O  
ATOM    177  CB  ALA    34       8.816 -17.148   1.365  1.00 55.64           C  
ATOM    178  N   VAL    35       8.422 -20.150   1.969  1.00 52.71           N  
ATOM    179  CA  VAL    35       9.146 -21.419   1.963  1.00 51.53           C  
ATOM    180  C   VAL    35      10.059 -21.440   0.736  1.00 50.48           C  
ATOM    181  O   VAL    35       9.597 -21.267  -0.405  1.00 50.86           O  
ATOM    182  CB  VAL    35       8.199 -22.656   2.139  1.00 51.55           C  
ATOM    183  CG1 VAL    35       8.927 -23.938   1.867  1.00 51.62           C  
ATOM    184  CG2 VAL    35       7.649 -22.678   3.595  1.00 51.89           C  
ATOM    185  N   VAL    36      11.358 -21.607   0.993  1.00 47.93           N  
ATOM    186  CA  VAL    36      12.369 -21.552  -0.052  1.00 46.54           C  
ATOM    187  C   VAL    36      13.108 -22.885  -0.044  1.00 46.09           C  
ATOM    188  O   VAL    36      13.795 -23.191   0.917  1.00 45.92           O  
ATOM    189  CB  VAL    36      13.329 -20.352   0.148  1.00 46.45           C  
ATOM    190  CG1 VAL    36      14.517 -20.414  -0.842  1.00 45.45           C  
ATOM    191  CG2 VAL    36      12.561 -19.045  -0.018  1.00 43.17           C  
ATOM    192  N   HIS    37      12.900 -23.698  -1.086  1.00 45.65           N  
ATOM    193  CA  HIS    37      13.449 -25.056  -1.162  1.00 45.17           C  
ATOM    194  C   HIS    37      13.275 -25.825   0.164  1.00 45.04           C  
ATOM    195  O   HIS    37      14.256 -26.313   0.741  1.00 45.28           O  
ATOM    196  CB  HIS    37      14.941 -25.015  -1.540  1.00 45.31           C  
ATOM    197  CG  HIS    37      15.243 -24.292  -2.824  1.00 45.88           C  
ATOM    198  ND1 HIS    37      14.568 -24.534  -4.004  1.00 46.39           N  
ATOM    199  CD2 HIS    37      16.190 -23.367  -3.117  1.00 46.19           C  
ATOM    200  CE1 HIS    37      15.074 -23.775  -4.962  1.00 46.61           C  
ATOM    201  NE2 HIS    37      16.058 -23.055  -4.449  1.00 45.87           N  
ATOM    202  N   ASP    38      12.041 -25.892   0.661  1.00 44.85           N  
ATOM    203  CA  ASP    38      11.706 -26.553   1.941  1.00 45.31           C  
ATOM    204  C   ASP    38      12.339 -25.925   3.206  1.00 45.08           C  
ATOM    205  O   ASP    38      12.315 -26.535   4.284  1.00 45.02           O  
ATOM    206  CB  ASP    38      12.026 -28.055   1.910  1.00 45.77           C  
ATOM    207  CG  ASP    38      11.383 -28.776   0.726  1.00 49.13           C  
ATOM    208  OD1 ASP    38      10.128 -28.791   0.650  1.00 51.40           O  
ATOM    209  OD2 ASP    38      12.135 -29.334  -0.124  1.00 51.32           O  
ATOM    210  N   ARG    39      12.917 -24.729   3.081  1.00 43.95           N  
ATOM    211  CA  ARG    39      13.413 -24.021   4.257  1.00 43.30           C  
ATOM    212  C   ARG    39      12.521 -22.812   4.452  1.00 42.56           C  
ATOM    213  O   ARG    39      12.335 -22.011   3.534  1.00 42.90           O  
ATOM    214  CB  ARG    39      14.865 -23.605   4.108  1.00 43.37           C  
ATOM    215  CG  ARG    39      15.608 -23.594   5.429  1.00 43.77           C  
ATOM    216  CD  ARG    39      17.029 -23.142   5.261  1.00 45.03           C  
ATOM    217  NE  ARG    39      17.674 -23.029   6.560  1.00 45.90           N  
ATOM    218  CZ  ARG    39      18.700 -23.769   6.945  1.00 43.80           C  
ATOM    219  NH1 ARG    39      19.211 -24.648   6.103  1.00 43.43           N  
ATOM    220  NH2 ARG    39      19.216 -23.604   8.157  1.00 40.35           N  
ATOM    221  N   GLU    40      11.915 -22.727   5.625  1.00 41.87           N  
ATOM    222  CA  GLU    40      11.019 -21.619   5.932  1.00 40.70           C  
ATOM    223  C   GLU    40      11.814 -20.418   6.451  1.00 40.21           C  
ATOM    224  O   GLU    40      12.671 -20.553   7.321  1.00 39.91           O  
ATOM    225  CB  GLU    40       9.926 -22.041   6.911  1.00 41.02           C  
ATOM    226  CG  GLU    40       8.775 -21.074   6.870  1.00 41.02           C  
ATOM    227  CD  GLU    40       7.670 -21.402   7.819  1.00 45.48           C  
ATOM    228  OE1 GLU    40       7.862 -22.213   8.771  1.00 46.20           O  
ATOM    229  OE2 GLU    40       6.581 -20.845   7.575  1.00 44.48           O  
ATOM    230  N   VAL    41      11.578 -19.259   5.838  1.00 39.09           N  
ATOM    231  CA  VAL    41      12.354 -18.057   6.115  1.00 37.88           C  
ATOM    232  C   VAL    41      11.436 -16.887   6.414  1.00 37.27           C  
ATOM    233  O   VAL    41      10.267 -16.869   6.008  1.00 36.57           O  
ATOM    234  CB  VAL    41      13.326 -17.655   4.896  1.00 37.87           C  
ATOM    235  CG1 VAL    41      14.182 -18.804   4.466  1.00 36.47           C  
ATOM    236  CG2 VAL    41      12.531 -17.210   3.656  1.00 38.60           C  
ATOM    237  N   VAL    42      11.998 -15.867   7.049  1.00 36.63           N  
ATOM    238  CA  VAL    42      11.308 -14.631   7.203  1.00 35.76           C  
ATOM    239  C   VAL    42      12.103 -13.576   6.456  1.00 36.42           C  
ATOM    240  O   VAL    42      13.302 -13.561   6.538  1.00 34.56           O  
ATOM    241  CB  VAL    42      11.050 -14.279   8.729  1.00 36.00           C  
ATOM    242  CG1 VAL    42      12.356 -14.284   9.550  1.00 31.47           C  
ATOM    243  CG2 VAL    42      10.244 -12.935   8.858  1.00 36.12           C  
ATOM    244  N   ILE    43      11.423 -12.711   5.705  1.00 36.07           N  
ATOM    245  CA  ILE    43      12.088 -11.573   5.057  1.00 35.72           C  
ATOM    246  C   ILE    43      11.611 -10.312   5.753  1.00 35.08           C  
ATOM    247  O   ILE    43      10.425 -10.130   5.901  1.00 34.92           O  
ATOM    248  CB  ILE    43      11.748 -11.420   3.540  1.00 36.04           C  
ATOM    249  CG1 ILE    43      12.131 -12.678   2.760  1.00 38.38           C  
ATOM    250  CG2 ILE    43      12.503 -10.221   2.900  1.00 35.84           C  
ATOM    251  CD1 ILE    43      10.953 -13.665   2.645  1.00 41.98           C  
ATOM    252  N   PHE    44      12.540  -9.455   6.170  1.00 35.27           N  
ATOM    253  CA  PHE    44      12.207  -8.159   6.750  1.00 35.90           C  
ATOM    254  C   PHE    44      12.611  -7.070   5.764  1.00 36.03           C  
ATOM    255  O   PHE    44      13.695  -7.104   5.206  1.00 36.06           O  
ATOM    256  CB  PHE    44      12.996  -7.939   8.051  1.00 35.55           C  
ATOM    257  CG  PHE    44      12.675  -8.944   9.149  1.00 35.15           C  
ATOM    258  CD1 PHE    44      11.461  -8.863   9.856  1.00 33.52           C  
ATOM    259  CD2 PHE    44      13.555  -9.953   9.456  1.00 35.10           C  
ATOM    260  CE1 PHE    44      11.145  -9.775  10.840  1.00 31.22           C  
ATOM    261  CE2 PHE    44      13.260 -10.834  10.490  1.00 33.69           C  
ATOM    262  CZ  PHE    44      12.043 -10.747  11.155  1.00 34.12           C  
ATOM    263  N   TYR    45      11.744  -6.094   5.576  1.00 36.13           N  
ATOM    264  CA  TYR    45      12.120  -4.861   4.896  1.00 37.49           C  
ATOM    265  C   TYR    45      12.253  -3.757   5.917  1.00 37.07           C  
ATOM    266  O   TYR    45      11.271  -3.380   6.534  1.00 38.99           O  
ATOM    267  CB  TYR    45      11.055  -4.484   3.898  1.00 36.98           C  
ATOM    268  CG  TYR    45      11.334  -3.182   3.158  1.00 39.78           C  
ATOM    269  CD1 TYR    45      12.338  -3.109   2.209  1.00 40.79           C  
ATOM    270  CD2 TYR    45      10.595  -2.037   3.421  1.00 38.05           C  
ATOM    271  CE1 TYR    45      12.605  -1.935   1.531  1.00 41.88           C  
ATOM    272  CE2 TYR    45      10.858  -0.857   2.763  1.00 41.50           C  
ATOM    273  CZ  TYR    45      11.862  -0.805   1.807  1.00 40.93           C  
ATOM    274  OH  TYR    45      12.120   0.387   1.114  1.00 40.29           O  
ATOM    275  N   HIS    46      13.443  -3.229   6.111  1.00 36.34           N  
ATOM    276  CA  HIS    46      13.652  -2.224   7.156  1.00 36.95           C  
ATOM    277  C   HIS    46      14.640  -1.131   6.693  1.00 37.04           C  
ATOM    278  O   HIS    46      15.718  -1.438   6.160  1.00 36.11           O  
ATOM    279  CB  HIS    46      14.162  -2.927   8.432  1.00 37.03           C  
ATOM    280  CG  HIS    46      14.389  -2.016   9.605  1.00 38.48           C  
ATOM    281  ND1 HIS    46      13.356  -1.460  10.337  1.00 40.30           N  
ATOM    282  CD2 HIS    46      15.530  -1.603  10.200  1.00 36.98           C  
ATOM    283  CE1 HIS    46      13.855  -0.725  11.315  1.00 38.56           C  
ATOM    284  NE2 HIS    46      15.171  -0.791  11.249  1.00 38.82           N  
ATOM    285  N   LYS    47      14.275   0.138   6.920  1.00 36.95           N  
ATOM    286  CA  LYS    47      15.099   1.269   6.525  1.00 37.47           C  
ATOM    287  C   LYS    47      15.604   1.065   5.095  1.00 37.40           C  
ATOM    288  O   LYS    47      16.817   1.170   4.821  1.00 36.64           O  
ATOM    289  CB  LYS    47      16.293   1.452   7.465  1.00 38.17           C  
ATOM    290  CG  LYS    47      15.974   1.813   8.904  1.00 40.46           C  
ATOM    291  CD  LYS    47      17.211   2.484   9.503  1.00 45.27           C  
ATOM    292  CE  LYS    47      17.181   2.580  11.022  1.00 47.38           C  
ATOM    293  NZ  LYS    47      17.861   1.421  11.685  1.00 50.94           N  
ATOM    294  N   GLY    48      14.674   0.731   4.194  1.00 37.40           N  
ATOM    295  CA  GLY    48      15.000   0.560   2.776  1.00 37.40           C  
ATOM    296  C   GLY    48      15.856  -0.636   2.402  1.00 37.80           C  
ATOM    297  O   GLY    48      16.304  -0.738   1.278  1.00 38.04           O  
ATOM    298  N   GLU    49      16.085  -1.556   3.336  1.00 38.38           N  
ATOM    299  CA  GLU    49      16.829  -2.797   3.029  1.00 38.96           C  
ATOM    300  C   GLU    49      16.071  -4.079   3.366  1.00 37.40           C  
ATOM    301  O   GLU    49      15.276  -4.102   4.272  1.00 37.65           O  
ATOM    302  CB  GLU    49      18.154  -2.817   3.788  1.00 38.83           C  
ATOM    303  CG  GLU    49      18.937  -1.583   3.524  1.00 43.50           C  
ATOM    304  CD  GLU    49      20.402  -1.850   3.556  1.00 48.39           C  
ATOM    305  OE1 GLU    49      20.835  -2.546   4.503  1.00 49.17           O  
ATOM    306  OE2 GLU    49      21.094  -1.373   2.622  1.00 51.30           O  
ATOM    307  N   TYR    50      16.403  -5.145   2.652  1.00 37.51           N  
ATOM    308  CA  TYR    50      15.783  -6.447   2.770  1.00 37.42           C  
ATOM    309  C   TYR    50      16.698  -7.402   3.513  1.00 37.93           C  
ATOM    310  O   TYR    50      17.897  -7.407   3.283  1.00 36.23           O  
ATOM    311  CB  TYR    50      15.475  -6.971   1.367  1.00 38.36           C  
ATOM    312  CG  TYR    50      14.401  -6.171   0.692  1.00 38.71           C  
ATOM    313  CD1 TYR    50      13.052  -6.451   0.947  1.00 41.30           C  
ATOM    314  CD2 TYR    50      14.714  -5.109  -0.176  1.00 39.45           C  
ATOM    315  CE1 TYR    50      12.043  -5.728   0.367  1.00 39.50           C  
ATOM    316  CE2 TYR    50      13.689  -4.361  -0.778  1.00 41.37           C  
ATOM    317  CZ  TYR    50      12.347  -4.688  -0.495  1.00 41.85           C  
ATOM    318  OH  TYR    50      11.300  -3.995  -1.058  1.00 39.83           O  
ATOM    319  N   HIS    51      16.156  -8.162   4.451  1.00 37.00           N  
ATOM    320  CA  HIS    51      16.962  -9.128   5.154  1.00 37.66           C  
ATOM    321  C   HIS    51      16.187 -10.409   5.256  1.00 38.22           C  
ATOM    322  O   HIS    51      15.034 -10.396   5.749  1.00 40.63           O  
ATOM    323  CB  HIS    51      17.362  -8.635   6.576  1.00 38.17           C  
ATOM    324  CG  HIS    51      17.992  -7.280   6.598  1.00 36.35           C  
ATOM    325  ND1 HIS    51      19.324  -7.072   6.311  1.00 36.15           N  
ATOM    326  CD2 HIS    51      17.462  -6.060   6.834  1.00 36.39           C  
ATOM    327  CE1 HIS    51      19.587  -5.780   6.377  1.00 36.16           C  
ATOM    328  NE2 HIS    51      18.475  -5.144   6.699  1.00 36.78           N  
ATOM    329  N   ALA    52      16.783 -11.510   4.813  1.00 36.23           N  
ATOM    330  CA  ALA    52      16.191 -12.852   4.974  1.00 35.83           C  
ATOM    331  C   ALA    52      16.956 -13.725   5.994  1.00 35.84           C  
ATOM    332  O   ALA    52      18.162 -13.772   5.971  1.00 35.96           O  
ATOM    333  CB  ALA    52      16.112 -13.564   3.635  1.00 34.44           C  
ATOM    334  N   MET    53      16.230 -14.425   6.860  1.00 35.98           N  
ATOM    335  CA  MET    53      16.856 -15.383   7.786  1.00 35.97           C  
ATOM    336  C   MET    53      15.895 -16.513   8.097  1.00 34.34           C  
ATOM    337  O   MET    53      14.698 -16.423   7.816  1.00 34.06           O  
ATOM    338  CB  MET    53      17.275 -14.682   9.102  1.00 34.38           C  
ATOM    339  CG  MET    53      16.059 -14.042   9.793  1.00 36.38           C  
ATOM    340  SD  MET    53      16.365 -13.290  11.396  1.00 37.83           S  
ATOM    341  CE  MET    53      17.224 -11.779  10.901  1.00 31.98           C  
ATOM    342  N   ASP    54      16.437 -17.570   8.692  1.00 35.49           N  
ATOM    343  CA  ASP    54      15.663 -18.709   9.166  1.00 35.03           C  
ATOM    344  C   ASP    54      14.594 -18.178  10.077  1.00 35.41           C  
ATOM    345  O   ASP    54      14.838 -17.266  10.883  1.00 36.46           O  
ATOM    346  CB  ASP    54      16.555 -19.680   9.974  1.00 36.35           C  
ATOM    347  CG  ASP    54      17.394 -20.595   9.089  1.00 37.52           C  
ATOM    348  OD1 ASP    54      17.092 -20.730   7.865  1.00 42.19           O  
ATOM    349  OD2 ASP    54      18.379 -21.187   9.608  1.00 36.00           O  
ATOM    350  N   ILE    55      13.400 -18.736   9.977  1.00 33.76           N  
ATOM    351  CA  ILE    55      12.271 -18.163  10.687  1.00 33.72           C  
ATOM    352  C   ILE    55      12.256 -18.488  12.189  1.00 34.09           C  
ATOM    353  O   ILE    55      11.846 -17.651  12.987  1.00 35.22           O  
ATOM    354  CB  ILE    55      10.909 -18.575  10.023  1.00 32.75           C  
ATOM    355  CG1 ILE    55       9.729 -17.838  10.671  1.00 34.08           C  
ATOM    356  CG2 ILE    55      10.649 -20.098  10.162  1.00 32.55           C  
ATOM    357  CD1 ILE    55       8.426 -17.928   9.803  1.00 33.04           C  
ATOM    358  N   ARG    56      12.676 -19.701  12.554  1.00 34.32           N  
ATOM    359  CA  ARG    56      12.678 -20.122  13.949  0.50 34.27           C  
ATOM    361  C   ARG    56      13.979 -19.728  14.679  1.00 35.02           C  
ATOM    362  O   ARG    56      15.105 -19.999  14.216  1.00 34.05           O  
ATOM    363  CB  ARG    56      12.392 -21.611  14.064  0.50 33.71           C  
ATOM    365  CG  ARG    56      11.174 -22.056  13.253  0.50 33.20           C  
ATOM    367  CD  ARG    56       9.863 -21.458  13.767  0.50 34.41           C  
ATOM    369  NE  ARG    56       8.811 -21.580  12.749  0.50 33.94           N  
ATOM    371  CZ  ARG    56       7.540 -21.219  12.904  0.50 33.39           C  
ATOM    373  NH1 ARG    56       7.124 -20.701  14.053  0.50 33.15           N  
ATOM    375  NH2 ARG    56       6.684 -21.388  11.901  0.50 30.53           N  
ATOM    377  N   CYS    57      13.782 -19.059  15.804  1.00 34.89           N  
ATOM    378  CA  CYS    57      14.857 -18.517  16.622  1.00 34.84           C  
ATOM    379  C   CYS    57      15.820 -19.605  17.046  1.00 35.33           C  
ATOM    380  O   CYS    57      15.405 -20.619  17.585  1.00 34.76           O  
ATOM    381  CB  CYS    57      14.258 -17.828  17.853  1.00 35.43           C  
ATOM    382  SG  CYS    57      15.469 -17.137  18.937  1.00 35.67           S  
ATOM    383  N   TYR    58      17.109 -19.375  16.835  1.00 33.56           N  
ATOM    384  CA  TYR    58      18.141 -20.335  17.256  1.00 34.44           C  
ATOM    385  C   TYR    58      18.123 -20.742  18.712  1.00 34.87           C  
ATOM    386  O   TYR    58      18.677 -21.797  19.032  1.00 35.22           O  
ATOM    387  CB  TYR    58      19.564 -19.805  16.955  1.00 32.35           C  
ATOM    388  CG  TYR    58      20.078 -18.730  17.956  1.00 32.86           C  
ATOM    389  CD1 TYR    58      19.791 -17.386  17.764  1.00 32.31           C  
ATOM    390  CD2 TYR    58      20.892 -19.078  19.025  1.00 26.69           C  
ATOM    391  CE1 TYR    58      20.280 -16.385  18.653  1.00 36.22           C  
ATOM    392  CE2 TYR    58      21.337 -18.112  19.962  1.00 32.60           C  
ATOM    393  CZ  TYR    58      21.100 -16.767  19.710  1.00 32.41           C  
ATOM    394  OH  TYR    58      21.552 -15.812  20.596  1.00 35.59           O  
ATOM    395  N   HIS    59      17.583 -19.901  19.596  1.00 34.43           N  
ATOM    396  CA  HIS    59      17.668 -20.152  21.034  1.00 33.97           C  
ATOM    397  C   HIS    59      16.815 -21.395  21.360  1.00 34.28           C  
ATOM    398  O   HIS    59      17.331 -22.404  21.833  1.00 33.47           O  
ATOM    399  CB  HIS    59      17.194 -18.912  21.838  1.00 34.01           C  
ATOM    400  CG  HIS    59      17.046 -19.170  23.316  1.00 31.90           C  
ATOM    401  ND1 HIS    59      15.913 -18.854  24.030  1.00 32.75           N  
ATOM    402  CD2 HIS    59      17.922 -19.688  24.212  1.00 31.88           C  
ATOM    403  CE1 HIS    59      16.070 -19.221  25.292  1.00 36.93           C  
ATOM    404  NE2 HIS    59      17.286 -19.723  25.432  1.00 36.41           N  
ATOM    405  N   SER    60      15.504 -21.309  21.140  1.00 34.09           N  
ATOM    406  CA  SER    60      14.580 -22.404  21.464  1.00 35.56           C  
ATOM    407  C   SER    60      13.520 -22.620  20.402  1.00 35.00           C  
ATOM    408  O   SER    60      12.473 -23.273  20.676  1.00 34.15           O  
ATOM    409  CB  SER    60      13.793 -22.101  22.766  1.00 35.66           C  
ATOM    410  OG  SER    60      14.529 -22.465  23.868  1.00 40.94           O  
ATOM    411  N   GLY    61      13.725 -22.050  19.227  1.00 33.78           N  
ATOM    412  CA  GLY    61      12.734 -22.180  18.151  1.00 33.83           C  
ATOM    413  C   GLY    61      11.537 -21.216  18.082  1.00 33.58           C  
ATOM    414  O   GLY    61      10.581 -21.489  17.382  1.00 33.89           O  
ATOM    415  N   GLY    62      11.592 -20.060  18.752  1.00 34.29           N  
ATOM    416  CA  GLY    62      10.503 -19.064  18.703  1.00 33.30           C  
ATOM    417  C   GLY    62      10.292 -18.403  17.339  1.00 34.18           C  
ATOM    418  O   GLY    62      11.131 -18.485  16.449  1.00 34.46           O  
ATOM    419  N   PRO    63       9.131 -17.779  17.156  1.00 34.28           N  
ATOM    420  CA  PRO    63       8.647 -17.233  15.855  1.00 34.13           C  
ATOM    421  C   PRO    63       9.249 -15.820  15.609  1.00 35.32           C  
ATOM    422  O   PRO    63       8.683 -14.844  16.083  1.00 35.94           O  
ATOM    423  CB  PRO    63       7.098 -17.165  16.070  1.00 34.92           C  
ATOM    424  CG  PRO    63       6.909 -17.071  17.597  1.00 34.02           C  
ATOM    425  CD  PRO    63       8.162 -17.613  18.267  1.00 32.77           C  
ATOM    426  N   LEU    64      10.409 -15.724  14.939  1.00 33.85           N  
ATOM    427  CA  LEU    64      11.035 -14.426  14.722  1.00 35.10           C  
ATOM    428  C   LEU    64      10.190 -13.455  13.888  1.00 35.51           C  
ATOM    429  O   LEU    64      10.282 -12.231  14.090  1.00 35.60           O  
ATOM    430  CB  LEU    64      12.420 -14.584  14.076  1.00 33.19           C  
ATOM    431  CG  LEU    64      13.471 -15.228  14.956  1.00 33.67           C  
ATOM    432  CD1 LEU    64      14.780 -15.303  14.169  1.00 31.32           C  
ATOM    433  CD2 LEU    64      13.683 -14.567  16.368  1.00 32.77           C  
ATOM    434  N   HIS    65       9.310 -14.009  13.014  1.00 36.13           N  
ATOM    435  CA  HIS    65       8.382 -13.207  12.206  1.00 35.49           C  
ATOM    436  C   HIS    65       7.333 -12.496  13.062  1.00 36.08           C  
ATOM    437  O   HIS    65       6.658 -11.607  12.549  1.00 36.02           O  
ATOM    438  CB  HIS    65       7.719 -14.047  11.080  1.00 34.87           C  
ATOM    439  CG  HIS    65       6.740 -15.075  11.579  1.00 34.80           C  
ATOM    440  ND1 HIS    65       7.104 -16.108  12.425  1.00 32.82           N  
ATOM    441  CD2 HIS    65       5.425 -15.270  11.294  1.00 35.42           C  
ATOM    442  CE1 HIS    65       6.030 -16.818  12.735  1.00 35.35           C  
ATOM    443  NE2 HIS    65       5.003 -16.349  12.044  1.00 34.51           N  
ATOM    444  N   LEU    66       7.226 -12.856  14.351  1.00 35.16           N  
ATOM    445  CA  LEU    66       6.321 -12.166  15.276  1.00 34.56           C  
ATOM    446  C   LEU    66       7.126 -11.259  16.209  1.00 34.99           C  
ATOM    447  O   LEU    66       6.571 -10.695  17.130  1.00 34.13           O  
ATOM    448  CB  LEU    66       5.499 -13.148  16.118  1.00 35.06           C  
ATOM    449  CG  LEU    66       4.672 -14.209  15.366  1.00 36.17           C  
ATOM    450  CD1 LEU    66       3.790 -14.925  16.316  1.00 36.21           C  
ATOM    451  CD2 LEU    66       3.919 -13.613  14.176  1.00 33.70           C  
ATOM    452  N   GLY    67       8.431 -11.107  15.993  1.00 32.27           N  
ATOM    453  CA  GLY    67       9.167 -10.210  16.887  1.00 33.66           C  
ATOM    454  C   GLY    67       9.179  -8.750  16.492  1.00 34.02           C  
ATOM    455  O   GLY    67       8.704  -8.397  15.403  1.00 34.86           O  
ATOM    456  N   GLU    68       9.706  -7.884  17.364  1.00 34.92           N  
ATOM    457  CA  GLU    68       9.815  -6.470  17.032  0.50 34.77           C  
ATOM    459  C   GLU    68      11.234  -6.174  16.546  1.00 36.04           C  
ATOM    460  O   GLU    68      12.222  -6.826  16.990  1.00 34.69           O  
ATOM    461  CB  GLU    68       9.482  -5.582  18.246  0.50 34.98           C  
ATOM    463  CG  GLU    68       8.148  -5.870  18.980  0.50 33.52           C  
ATOM    465  CD  GLU    68       6.963  -5.201  18.371  0.50 31.29           C  
ATOM    467  OE1 GLU    68       6.995  -4.840  17.191  0.50 32.99           O  
ATOM    469  OE2 GLU    68       5.968  -5.014  19.089  0.50 35.61           O  
ATOM    471  N   ILE    69      11.358  -5.184  15.662  1.00 36.24           N  
ATOM    472  CA  ILE    69      12.690  -4.749  15.196  1.00 39.01           C  
ATOM    473  C   ILE    69      13.122  -3.516  16.002  1.00 40.20           C  
ATOM    474  O   ILE    69      12.326  -2.588  16.158  1.00 38.19           O  
ATOM    475  CB  ILE    69      12.670  -4.427  13.673  1.00 39.84           C  
ATOM    476  CG1 ILE    69      12.411  -5.733  12.873  1.00 41.79           C  
ATOM    477  CG2 ILE    69      14.002  -3.705  13.233  1.00 39.07           C  
ATOM    478  CD1 ILE    69      12.138  -5.498  11.381  1.00 39.19           C  
ATOM    479  N   GLU    70      14.336  -3.532  16.564  1.00 40.88           N  
ATOM    480  CA  GLU    70      14.914  -2.358  17.235  1.00 44.15           C  
ATOM    481  C   GLU    70      16.417  -2.296  17.027  1.00 42.63           C  
ATOM    482  O   GLU    70      17.083  -3.326  16.854  1.00 40.70           O  
ATOM    483  CB  GLU    70      14.727  -2.352  18.758  1.00 44.02           C  
ATOM    484  CG  GLU    70      13.479  -2.956  19.319  1.00 49.17           C  
ATOM    485  CD  GLU    70      13.403  -2.778  20.857  1.00 50.66           C  
ATOM    486  OE1 GLU    70      13.816  -1.656  21.361  1.00 57.14           O  
ATOM    487  OE2 GLU    70      12.923  -3.748  21.533  1.00 53.10           O  
ATOM    488  N   ASP    71      16.941  -1.081  17.146  1.00 42.60           N  
ATOM    489  CA  ASP    71      18.382  -0.850  17.089  1.00 43.31           C  
ATOM    490  C   ASP    71      19.025  -1.001  18.446  1.00 43.56           C  
ATOM    491  O   ASP    71      18.527  -0.452  19.446  1.00 44.12           O  
ATOM    492  CB  ASP    71      18.695   0.530  16.502  1.00 43.80           C  
ATOM    493  CG  ASP    71      18.390   0.615  15.022  1.00 45.66           C  
ATOM    494  OD1 ASP    71      17.523  -0.130  14.518  1.00 46.85           O  
ATOM    495  OD2 ASP    71      19.031   1.442  14.340  1.00 50.54           O  
ATOM    496  N   PHE    72      20.119  -1.763  18.480  1.00 42.87           N  
ATOM    497  CA  PHE    72      20.968  -1.887  19.651  1.00 42.59           C  
ATOM    498  C   PHE    72      22.398  -1.763  19.142  1.00 42.61           C  
ATOM    499  O   PHE    72      22.744  -2.358  18.120  1.00 41.94           O  
ATOM    500  CB  PHE    72      20.781  -3.235  20.371  1.00 43.24           C  
ATOM    501  CG  PHE    72      19.348  -3.523  20.793  1.00 45.32           C  
ATOM    502  CD1 PHE    72      18.843  -3.025  21.994  1.00 47.35           C  
ATOM    503  CD2 PHE    72      18.501  -4.280  19.983  1.00 44.73           C  
ATOM    504  CE1 PHE    72      17.503  -3.279  22.376  1.00 48.24           C  
ATOM    505  CE2 PHE    72      17.168  -4.525  20.359  1.00 39.75           C  
ATOM    506  CZ  PHE    72      16.683  -4.035  21.549  1.00 45.38           C  
ATOM    507  N   ASN    73      23.206  -0.973  19.850  1.00 43.10           N  
ATOM    508  CA  ASN    73      24.606  -0.660  19.467  1.00 43.65           C  
ATOM    509  C   ASN    73      24.686  -0.152  18.023  1.00 43.70           C  
ATOM    510  O   ASN    73      25.601  -0.496  17.283  1.00 43.14           O  
ATOM    511  CB  ASN    73      25.513  -1.889  19.657  1.00 43.42           C  
ATOM    512  CG  ASN    73      27.003  -1.519  19.856  1.00 46.43           C  
ATOM    513  OD1 ASN    73      27.353  -0.367  20.187  1.00 43.42           O  
ATOM    514  ND2 ASN    73      27.889  -2.518  19.667  1.00 48.36           N  
ATOM    515  N   GLY    74      23.677   0.609  17.606  1.00 44.40           N  
ATOM    516  CA  GLY    74      23.611   1.082  16.214  1.00 44.51           C  
ATOM    517  C   GLY    74      23.381   0.008  15.147  1.00 44.46           C  
ATOM    518  O   GLY    74      23.531   0.291  13.971  1.00 44.76           O  
ATOM    519  N   GLN    75      23.016  -1.212  15.556  1.00 43.78           N  
ATOM    520  CA  GLN    75      22.635  -2.297  14.632  1.00 42.82           C  
ATOM    521  C   GLN    75      21.157  -2.669  14.762  1.00 40.89           C  
ATOM    522  O   GLN    75      20.649  -2.890  15.865  1.00 40.71           O  
ATOM    523  CB  GLN    75      23.479  -3.545  14.896  1.00 42.81           C  
ATOM    524  CG  GLN    75      24.968  -3.400  14.622  1.00 46.95           C  
ATOM    525  CD  GLN    75      25.797  -4.451  15.386  1.00 50.89           C  
ATOM    526  OE1 GLN    75      26.011  -4.339  16.595  1.00 52.08           O  
ATOM    527  NE2 GLN    75      26.257  -5.474  14.673  1.00 51.59           N  
ATOM    528  N   SER    76      20.470  -2.740  13.621  1.00 39.88           N  
ATOM    529  CA  SER    76      19.081  -3.185  13.538  1.00 38.27           C  
ATOM    530  C   SER    76      18.980  -4.683  13.879  1.00 36.85           C  
ATOM    531  O   SER    76      19.722  -5.479  13.320  1.00 36.22           O  
ATOM    532  CB  SER    76      18.554  -2.935  12.130  1.00 38.31           C  
ATOM    533  OG  SER    76      18.478  -1.527  11.875  1.00 43.22           O  
ATOM    534  N   CYS    77      18.072  -5.043  14.789  1.00 35.33           N  
ATOM    535  CA  CYS    77      17.930  -6.402  15.313  1.00 34.59           C  
ATOM    536  C   CYS    77      16.462  -6.789  15.272  1.00 35.71           C  
ATOM    537  O   CYS    77      15.620  -5.957  15.526  1.00 35.64           O  
ATOM    538  CB  CYS    77      18.356  -6.451  16.776  1.00 33.34           C  
ATOM    539  SG  CYS    77      20.163  -6.333  16.976  1.00 35.65           S  
ATOM    540  N   ILE    78      16.190  -8.059  15.007  1.00 34.76           N  
ATOM    541  CA  ILE    78      14.973  -8.688  15.377  1.00 34.18           C  
ATOM    542  C   ILE    78      15.061  -9.169  16.864  1.00 34.62           C  
ATOM    543  O   ILE    78      16.054  -9.721  17.287  1.00 34.47           O  
ATOM    544  CB  ILE    78      14.535  -9.826  14.318  1.00 33.81           C  
ATOM    545  CG1 ILE    78      13.138 -10.355  14.634  1.00 32.87           C  
ATOM    546  CG2 ILE    78      15.569 -10.982  14.211  1.00 31.11           C  
ATOM    547  CD1 ILE    78      12.031  -9.303  14.448  1.00 29.85           C  
ATOM    548  N   VAL    79      14.017  -8.921  17.655  1.00 32.69           N  
ATOM    549  CA  VAL    79      13.972  -9.370  19.046  1.00 33.62           C  
ATOM    550  C   VAL    79      12.967 -10.495  19.058  1.00 33.60           C  
ATOM    551  O   VAL    79      11.792 -10.239  18.739  1.00 33.36           O  
ATOM    552  CB  VAL    79      13.518  -8.218  19.996  1.00 34.49           C  
ATOM    553  CG1 VAL    79      13.462  -8.703  21.467  1.00 35.62           C  
ATOM    554  CG2 VAL    79      14.427  -6.975  19.840  1.00 30.87           C  
ATOM    555  N   CYS    80      13.411 -11.721  19.355  1.00 34.05           N  
ATOM    556  CA  CYS    80      12.533 -12.854  19.471  1.00 34.02           C  
ATOM    557  C   CYS    80      11.430 -12.582  20.492  1.00 33.64           C  
ATOM    558  O   CYS    80      11.698 -12.131  21.600  1.00 32.90           O  
ATOM    559  CB  CYS    80      13.294 -14.109  19.911  1.00 34.77           C  
ATOM    560  SG  CYS    80      12.168 -15.548  19.926  1.00 35.45           S  
ATOM    561  N   PRO    81      10.148 -12.867  20.137  1.00 34.47           N  
ATOM    562  CA  PRO    81       9.161 -12.521  21.164  1.00 33.40           C  
ATOM    563  C   PRO    81       9.158 -13.389  22.422  1.00 32.58           C  
ATOM    564  O   PRO    81       8.508 -12.988  23.398  1.00 32.43           O  
ATOM    565  CB  PRO    81       7.805 -12.649  20.450  1.00 33.95           C  
ATOM    566  CG  PRO    81       8.086 -13.625  19.318  1.00 33.95           C  
ATOM    567  CD  PRO    81       9.559 -13.452  18.920  1.00 33.50           C  
ATOM    568  N   TRP    82       9.802 -14.554  22.398  1.00 32.23           N  
ATOM    569  CA  TRP    82       9.754 -15.550  23.533  1.00 31.38           C  
ATOM    570  C   TRP    82      10.749 -15.130  24.528  1.00 30.48           C  
ATOM    571  O   TRP    82      10.362 -14.756  25.596  1.00 29.33           O  
ATOM    572  CB  TRP    82       9.982 -16.993  23.023  1.00 32.45           C  
ATOM    573  CG  TRP    82       8.799 -17.617  22.294  1.00 34.89           C  
ATOM    574  CD1 TRP    82       7.596 -17.007  21.998  1.00 36.46           C  
ATOM    575  CD2 TRP    82       8.669 -18.981  21.835  1.00 35.91           C  
ATOM    576  NE1 TRP    82       6.751 -17.904  21.374  1.00 34.16           N  
ATOM    577  CE2 TRP    82       7.387 -19.107  21.242  1.00 35.08           C  
ATOM    578  CE3 TRP    82       9.521 -20.105  21.855  1.00 36.77           C  
ATOM    579  CZ2 TRP    82       6.925 -20.325  20.657  1.00 37.12           C  
ATOM    580  CZ3 TRP    82       9.077 -21.308  21.279  1.00 35.69           C  
ATOM    581  CH2 TRP    82       7.782 -21.405  20.693  1.00 37.21           C  
ATOM    582  N   HIS    83      12.068 -15.103  24.216  1.00 30.38           N  
ATOM    583  CA  HIS    83      12.919 -14.743  25.348  1.00 29.88           C  
ATOM    584  C   HIS    83      13.741 -13.485  25.057  1.00 31.78           C  
ATOM    585  O   HIS    83      14.746 -13.232  25.722  1.00 31.83           O  
ATOM    586  CB  HIS    83      13.781 -15.895  25.841  1.00 31.04           C  
ATOM    587  CG  HIS    83      13.026 -17.192  25.969  1.00 31.61           C  
ATOM    588  ND1 HIS    83      12.949 -18.098  24.940  1.00 32.84           N  
ATOM    589  CD2 HIS    83      12.222 -17.671  26.946  1.00 34.43           C  
ATOM    590  CE1 HIS    83      12.170 -19.111  25.295  1.00 32.77           C  
ATOM    591  NE2 HIS    83      11.701 -18.859  26.499  1.00 34.54           N  
ATOM    592  N   LYS    84      13.272 -12.695  24.087  1.00 31.89           N  
ATOM    593  CA  LYS    84      13.801 -11.347  23.806  1.00 31.70           C  
ATOM    594  C   LYS    84      15.293 -11.389  23.412  1.00 33.14           C  
ATOM    595  O   LYS    84      15.999 -10.409  23.572  1.00 32.10           O  
ATOM    596  CB  LYS    84      13.572 -10.417  24.989  1.00 31.06           C  
ATOM    597  CG  LYS    84      12.064 -10.399  25.517  1.00 30.64           C  
ATOM    598  CD  LYS    84      11.050 -10.263  24.434  1.00 32.36           C  
ATOM    599  CE  LYS    84       9.644  -9.933  25.085  1.00 38.66           C  
ATOM    600  NZ  LYS    84       8.482 -10.388  24.213  1.00 42.06           N  
ATOM    601  N   TYR    85      15.749 -12.497  22.829  1.00 33.63           N  
ATOM    602  CA  TYR    85      17.115 -12.501  22.289  1.00 34.59           C  
ATOM    603  C   TYR    85      17.175 -11.542  21.081  1.00 35.22           C  
ATOM    604  O   TYR    85      16.204 -11.416  20.329  1.00 34.27           O  
ATOM    605  CB  TYR    85      17.601 -13.871  21.873  1.00 34.05           C  
ATOM    606  CG  TYR    85      18.069 -14.735  23.013  1.00 33.39           C  
ATOM    607  CD1 TYR    85      17.518 -14.603  24.318  1.00 33.28           C  
ATOM    608  CD2 TYR    85      19.020 -15.705  22.782  1.00 33.67           C  
ATOM    609  CE1 TYR    85      17.960 -15.396  25.370  1.00 32.12           C  
ATOM    610  CE2 TYR    85      19.448 -16.533  23.802  1.00 36.57           C  
ATOM    611  CZ  TYR    85      18.910 -16.370  25.089  1.00 35.84           C  
ATOM    612  OH  TYR    85      19.383 -17.144  26.067  1.00 31.52           O  
ATOM    613  N   LYS    86      18.305 -10.876  20.931  1.00 34.93           N  
ATOM    614  CA  LYS    86      18.469  -9.853  19.904  1.00 36.39           C  
ATOM    615  C   LYS    86      19.354 -10.424  18.841  1.00 36.21           C  
ATOM    616  O   LYS    86      20.454 -10.888  19.121  1.00 35.92           O  
ATOM    617  CB  LYS    86      19.109  -8.620  20.483  1.00 36.57           C  
ATOM    618  CG  LYS    86      18.377  -8.041  21.744  1.00 38.21           C  
ATOM    619  CD  LYS    86      19.382  -6.992  22.306  1.00 41.31           C  
ATOM    620  CE  LYS    86      18.733  -6.100  23.324  1.00 46.04           C  
ATOM    621  NZ  LYS    86      18.598  -6.744  24.662  1.00 46.41           N  
ATOM    622  N   ILE    87      18.849 -10.420  17.612  1.00 35.80           N  
ATOM    623  CA  ILE    87      19.600 -10.980  16.491  1.00 34.37           C  
ATOM    624  C   ILE    87      19.777  -9.927  15.419  1.00 35.24           C  
ATOM    625  O   ILE    87      18.772  -9.368  14.953  1.00 33.39           O  
ATOM    626  CB  ILE    87      18.816 -12.178  15.906  1.00 35.19           C  
ATOM    627  CG1 ILE    87      18.756 -13.254  17.013  1.00 32.85           C  
ATOM    628  CG2 ILE    87      19.485 -12.672  14.587  1.00 32.28           C  
ATOM    629  CD1 ILE    87      17.647 -14.305  16.840  1.00 33.74           C  
ATOM    630  N   THR    88      21.023  -9.680  15.000  1.00 32.82           N  
ATOM    631  CA  THR    88      21.230  -8.635  13.996  1.00 34.57           C  
ATOM    632  C   THR    88      20.607  -9.068  12.656  1.00 34.38           C  
ATOM    633  O   THR    88      20.650 -10.224  12.304  1.00 34.53           O  
ATOM    634  CB  THR    88      22.724  -8.301  13.763  1.00 34.35           C  
ATOM    635  OG1 THR    88      23.409  -9.475  13.340  1.00 35.21           O  
ATOM    636  CG2 THR    88      23.392  -7.774  15.039  1.00 33.63           C  
ATOM    637  N   LEU    89      19.976  -8.125  11.981  1.00 34.00           N  
ATOM    638  CA  LEU    89      19.322  -8.356  10.695  1.00 35.35           C  
ATOM    639  C   LEU    89      20.380  -8.672   9.650  1.00 35.40           C  
ATOM    640  O   LEU    89      20.181  -9.579   8.837  1.00 36.23           O  
ATOM    641  CB  LEU    89      18.529  -7.081  10.287  1.00 33.99           C  
ATOM    642  CG  LEU    89      17.230  -6.790  11.094  1.00 32.97           C  
ATOM    643  CD1 LEU    89      16.426  -5.700  10.357  1.00 31.94           C  
ATOM    644  CD2 LEU    89      16.393  -8.003  11.336  1.00 30.27           C  
ATOM    645  N   ALA    90      21.509  -7.975   9.727  1.00 34.20           N  
ATOM    646  CA  ALA    90      22.519  -8.019   8.678  1.00 36.25           C  
ATOM    647  C   ALA    90      23.387  -9.263   8.793  1.00 36.66           C  
ATOM    648  O   ALA    90      23.758  -9.810   7.776  1.00 36.43           O  
ATOM    649  CB  ALA    90      23.415  -6.759   8.683  1.00 35.66           C  
ATOM    650  N   THR    91      23.685  -9.717  10.027  1.00 34.82           N  
ATOM    651  CA  THR    91      24.589 -10.858  10.183  1.00 35.01           C  
ATOM    652  C   THR    91      24.116 -12.087  10.991  1.00 35.56           C  
ATOM    653  O   THR    91      24.853 -13.077  11.052  1.00 36.37           O  
ATOM    654  CB  THR    91      25.960 -10.390  10.761  1.00 34.11           C  
ATOM    655  OG1 THR    91      25.737  -9.613  11.957  1.00 35.18           O  
ATOM    656  CG2 THR    91      26.699  -9.568   9.732  1.00 33.96           C  
ATOM    657  N   GLY    92      22.938 -12.026  11.618  1.00 33.49           N  
ATOM    658  CA  GLY    92      22.460 -13.150  12.383  1.00 34.48           C  
ATOM    659  C   GLY    92      23.227 -13.354  13.680  1.00 35.00           C  
ATOM    660  O   GLY    92      23.222 -14.444  14.230  1.00 34.54           O  
ATOM    661  N   GLU    93      23.805 -12.274  14.204  1.00 35.53           N  
ATOM    662  CA  GLU    93      24.569 -12.353  15.436  1.00 36.08           C  
ATOM    663  C   GLU    93      23.607 -12.161  16.603  1.00 37.33           C  
ATOM    664  O   GLU    93      22.883 -11.187  16.639  1.00 34.20           O  
ATOM    665  CB  GLU    93      25.642 -11.255  15.497  1.00 35.02           C  
ATOM    666  CG  GLU    93      26.854 -11.393  14.533  1.00 31.69           C  
ATOM    667  CD  GLU    93      27.731 -10.176  14.562  1.00 34.65           C  
ATOM    668  OE1 GLU    93      28.431  -9.935  15.578  1.00 37.63           O  
ATOM    669  OE2 GLU    93      27.761  -9.438  13.567  1.00 33.35           O  
ATOM    670  N   GLY    94      23.689 -13.064  17.584  1.00 39.26           N  
ATOM    671  CA  GLY    94      23.199 -12.833  18.957  1.00 39.94           C  
ATOM    672  C   GLY    94      23.965 -11.705  19.616  1.00 40.96           C  
ATOM    673  O   GLY    94      25.195 -11.754  19.743  1.00 41.85           O  
ATOM    674  N   LEU    95      23.262 -10.662  20.036  1.00 41.80           N  
ATOM    675  CA  LEU    95      23.912  -9.522  20.705  1.00 43.32           C  
ATOM    676  C   LEU    95      23.481  -9.430  22.157  1.00 44.62           C  
ATOM    677  O   LEU    95      22.305  -9.712  22.518  1.00 44.46           O  
ATOM    678  CB  LEU    95      23.514  -8.202  20.035  1.00 43.50           C  
ATOM    679  CG  LEU    95      23.999  -7.851  18.663  1.00 43.89           C  
ATOM    680  CD1 LEU    95      23.548  -6.420  18.448  1.00 42.62           C  
ATOM    681  CD2 LEU    95      25.548  -7.911  18.639  1.00 46.24           C  
ATOM    682  N   TYR    96      24.422  -9.008  22.993  1.00 45.03           N  
ATOM    683  CA  TYR    96      24.140  -8.751  24.398  1.00 45.51           C  
ATOM    684  C   TYR    96      25.061  -7.662  24.986  1.00 45.91           C  
ATOM    685  O   TYR    96      26.169  -7.340  24.467  1.00 45.16           O  
ATOM    686  CB  TYR    96      24.236 -10.057  25.240  1.00 45.83           C  
ATOM    687  CG  TYR    96      25.604 -10.654  25.208  1.00 44.27           C  
ATOM    688  CD1 TYR    96      26.031 -11.370  24.071  1.00 50.00           C  
ATOM    689  CD2 TYR    96      26.502 -10.491  26.263  1.00 46.02           C  
ATOM    690  CE1 TYR    96      27.349 -11.916  23.981  1.00 47.47           C  
ATOM    691  CE2 TYR    96      27.839 -11.074  26.200  1.00 46.29           C  
ATOM    692  CZ  TYR    96      28.231 -11.777  25.050  1.00 44.35           C  
ATOM    693  OH  TYR    96      29.492 -12.321  24.908  1.00 45.24           O  
ATOM    694  N   GLN    97      24.585  -7.086  26.087  1.00 46.30           N  
ATOM    695  CA  GLN    97      25.427  -6.235  26.908  1.00 46.58           C  
ATOM    696  C   GLN    97      26.028  -7.040  28.046  1.00 45.88           C  
ATOM    697  O   GLN    97      25.322  -7.760  28.753  1.00 44.56           O  
ATOM    698  CB  GLN    97      24.642  -5.078  27.499  1.00 47.22           C  
ATOM    699  CG  GLN    97      24.144  -4.011  26.589  1.00 48.64           C  
ATOM    700  CD  GLN    97      23.318  -3.005  27.411  1.00 52.59           C  
ATOM    701  OE1 GLN    97      23.868  -2.091  28.035  1.00 53.02           O  
ATOM    702  NE2 GLN    97      22.001  -3.214  27.457  1.00 51.22           N  
ATOM    703  N   SER    98      27.332  -6.892  28.210  1.00 45.90           N  
ATOM    704  CA  SER    98      28.032  -7.433  29.337  1.00 47.24           C  
ATOM    705  C   SER    98      28.166  -6.335  30.376  1.00 49.34           C  
ATOM    706  O   SER    98      28.757  -5.280  30.106  1.00 49.89           O  
ATOM    707  CB  SER    98      29.421  -7.930  28.921  1.00 47.10           C  
ATOM    708  OG  SER    98      30.102  -8.443  30.055  1.00 45.34           O  
ATOM    709  N   ILE    99      27.643  -6.611  31.572  1.00 51.39           N  
ATOM    710  CA  ILE    99      27.521  -5.639  32.677  1.00 52.93           C  
ATOM    711  C   ILE    99      28.393  -6.106  33.858  1.00 54.29           C  
ATOM    712  O   ILE    99      28.399  -7.298  34.199  1.00 54.71           O  
ATOM    713  CB  ILE    99      26.001  -5.470  33.104  1.00 52.30           C  
ATOM    714  CG1 ILE    99      25.131  -5.046  31.911  1.00 51.54           C  
ATOM    715  CG2 ILE    99      25.821  -4.493  34.288  1.00 53.70           C  
ATOM    716  CD1 ILE    99      23.807  -5.799  31.805  1.00 46.37           C  
ATOM    717  N   ASN   100      29.145  -5.184  34.459  1.00 55.52           N  
ATOM    718  CA  ASN   100      29.915  -5.522  35.654  1.00 56.83           C  
ATOM    719  C   ASN   100      29.368  -4.911  36.948  1.00 57.31           C  
ATOM    720  O   ASN   100      29.767  -3.798  37.320  1.00 57.84           O  
ATOM    721  CB  ASN   100      31.395  -5.180  35.492  1.00 57.18           C  
ATOM    722  CG  ASN   100      32.279  -5.978  36.445  1.00 58.52           C  
ATOM    723  OD1 ASN   100      32.301  -5.729  37.666  1.00 55.73           O  
ATOM    724  ND2 ASN   100      32.999  -6.966  35.887  1.00 59.65           N  
ATOM    725  N   PRO   101      28.505  -5.669  37.671  1.00 57.70           N  
ATOM    726  CA  PRO   101      27.715  -5.252  38.861  1.00 57.67           C  
ATOM    727  C   PRO   101      28.494  -4.456  39.916  1.00 57.26           C  
ATOM    728  O   PRO   101      29.706  -4.632  40.048  1.00 57.24           O  
ATOM    729  CB  PRO   101      27.268  -6.589  39.470  1.00 57.78           C  
ATOM    730  CG  PRO   101      28.071  -7.663  38.736  1.00 57.63           C  
ATOM    731  CD  PRO   101      28.294  -7.099  37.376  1.00 57.45           C  
ATOM    732  N   LYS   107      29.692   1.272  32.920  1.00 52.92           N  
ATOM    733  CA  LYS   107      29.148   1.413  31.570  1.00 53.38           C  
ATOM    734  C   LYS   107      29.016   0.059  30.807  1.00 53.00           C  
ATOM    735  O   LYS   107      30.028  -0.555  30.445  1.00 53.19           O  
ATOM    736  CB  LYS   107      30.007   2.402  30.785  1.00 53.22           C  
ATOM    737  CG  LYS   107      29.300   3.062  29.608  1.00 54.17           C  
ATOM    738  CD  LYS   107      30.302   3.782  28.676  1.00 54.72           C  
ATOM    739  CE  LYS   107      30.830   2.874  27.551  1.00 56.01           C  
ATOM    740  NZ  LYS   107      29.758   2.104  26.827  1.00 56.35           N  
ATOM    741  N   PRO   108      27.766  -0.424  30.589  1.00 52.64           N  
ATOM    742  CA  PRO   108      27.527  -1.639  29.776  1.00 52.07           C  
ATOM    743  C   PRO   108      28.149  -1.649  28.357  1.00 51.06           C  
ATOM    744  O   PRO   108      28.077  -0.662  27.610  1.00 51.00           O  
ATOM    745  CB  PRO   108      25.986  -1.740  29.709  1.00 52.11           C  
ATOM    746  CG  PRO   108      25.470  -0.398  30.166  1.00 52.53           C  
ATOM    747  CD  PRO   108      26.501   0.106  31.141  1.00 52.95           C  
ATOM    748  N   LYS   109      28.747  -2.780  28.007  1.00 49.63           N  
ATOM    749  CA  LYS   109      29.417  -2.927  26.728  1.00 48.39           C  
ATOM    750  C   LYS   109      28.752  -4.014  25.903  1.00 47.32           C  
ATOM    751  O   LYS   109      28.409  -5.079  26.408  1.00 46.47           O  
ATOM    752  CB  LYS   109      30.908  -3.231  26.929  1.00 48.48           C  
ATOM    753  CG  LYS   109      31.675  -2.169  27.706  1.00 48.27           C  
ATOM    754  CD  LYS   109      32.101  -0.976  26.816  1.00 48.40           C  
ATOM    755  CE  LYS   109      32.829   0.130  27.608  1.00 48.03           C  
ATOM    756  NZ  LYS   109      34.057  -0.306  28.331  1.00 48.01           N  
ATOM    757  N   TRP   110      28.577  -3.715  24.624  1.00 46.18           N  
ATOM    758  CA  TRP   110      27.922  -4.607  23.689  1.00 45.75           C  
ATOM    759  C   TRP   110      28.888  -5.683  23.197  1.00 44.56           C  
ATOM    760  O   TRP   110      30.046  -5.391  22.911  1.00 42.89           O  
ATOM    761  CB  TRP   110      27.375  -3.803  22.515  1.00 45.61           C  
ATOM    762  CG  TRP   110      26.203  -3.031  22.904  1.00 46.40           C  
ATOM    763  CD1 TRP   110      26.153  -1.699  23.258  1.00 45.90           C  
ATOM    764  CD2 TRP   110      24.869  -3.540  23.026  1.00 45.33           C  
ATOM    765  NE1 TRP   110      24.843  -1.349  23.573  1.00 45.91           N  
ATOM    766  CE2 TRP   110      24.038  -2.454  23.441  1.00 46.03           C  
ATOM    767  CE3 TRP   110      24.291  -4.803  22.822  1.00 45.31           C  
ATOM    768  CZ2 TRP   110      22.634  -2.600  23.654  1.00 46.18           C  
ATOM    769  CZ3 TRP   110      22.872  -4.949  23.031  1.00 46.50           C  
ATOM    770  CH2 TRP   110      22.082  -3.853  23.464  1.00 44.84           C  
ATOM    771  N   CYS   111      28.361  -6.904  23.104  1.00 43.73           N  
ATOM    772  CA  CYS   111      29.114  -8.133  22.804  1.00 43.51           C  
ATOM    773  C   CYS   111      28.372  -9.074  21.871  1.00 42.24           C  
ATOM    774  O   CYS   111      27.149  -9.058  21.816  1.00 41.79           O  
ATOM    775  CB  CYS   111      29.376  -8.905  24.099  1.00 43.86           C  
ATOM    776  SG  CYS   111      30.478  -8.046  25.204  1.00 46.60           S  
ATOM    777  N   SER   112      29.104  -9.937  21.181  1.00 40.36           N  
ATOM    778  CA  SER   112      28.489 -10.890  20.233  1.00 38.78           C  
ATOM    779  C   SER   112      29.045 -12.287  20.444  1.00 38.54           C  
ATOM    780  O   SER   112      30.236 -12.465  20.784  1.00 37.11           O  
ATOM    781  CB  SER   112      28.784 -10.442  18.777  1.00 38.60           C  
ATOM    782  OG  SER   112      28.526 -11.474  17.829  1.00 36.33           O  
ATOM    783  N   LYS   113      28.240 -13.294  20.134  1.00 39.27           N  
ATOM    784  CA  LYS   113      28.809 -14.664  20.073  1.00 39.20           C  
ATOM    785  C   LYS   113      28.966 -15.206  18.665  1.00 37.38           C  
ATOM    786  O   LYS   113      29.110 -16.411  18.469  1.00 37.70           O  
ATOM    787  CB  LYS   113      27.989 -15.639  20.921  1.00 42.14           C  
ATOM    788  CG  LYS   113      28.737 -16.266  22.147  1.00 43.01           C  
ATOM    789  CD  LYS   113      27.629 -16.659  23.119  1.00 49.68           C  
ATOM    790  CE  LYS   113      28.098 -16.891  24.541  1.00 52.37           C  
ATOM    791  NZ  LYS   113      26.895 -17.361  25.347  1.00 52.14           N  
ATOM    792  N   GLY   114      29.001 -14.319  17.685  1.00 35.65           N  
ATOM    793  CA  GLY   114      29.233 -14.768  16.320  1.00 33.82           C  
ATOM    794  C   GLY   114      27.873 -15.014  15.692  1.00 33.37           C  
ATOM    795  O   GLY   114      26.853 -14.701  16.302  1.00 33.36           O  
ATOM    796  N   VAL   115      27.846 -15.649  14.525  1.00 32.79           N  
ATOM    797  CA  VAL   115      26.561 -15.900  13.774  1.00 33.84           C  
ATOM    798  C   VAL   115      25.799 -17.031  14.496  1.00 34.57           C  
ATOM    799  O   VAL   115      26.361 -18.137  14.767  1.00 34.43           O  
ATOM    800  CB  VAL   115      26.845 -16.293  12.300  1.00 33.90           C  
ATOM    801  CG1 VAL   115      25.555 -16.622  11.522  1.00 31.20           C  
ATOM    802  CG2 VAL   115      27.703 -15.199  11.551  1.00 33.60           C  
ATOM    803  N   LYS   116      24.574 -16.720  14.899  1.00 33.94           N  
ATOM    804  CA  LYS   116      23.689 -17.683  15.526  1.00 34.60           C  
ATOM    805  C   LYS   116      22.534 -18.002  14.584  1.00 36.35           C  
ATOM    806  O   LYS   116      22.037 -19.147  14.525  1.00 36.12           O  
ATOM    807  CB  LYS   116      23.137 -17.076  16.830  1.00 34.93           C  
ATOM    808  CG  LYS   116      24.158 -16.962  17.967  1.00 36.71           C  
ATOM    809  CD  LYS   116      24.828 -18.295  18.150  1.00 37.08           C  
ATOM    810  CE  LYS   116      25.508 -18.443  19.482  1.00 39.69           C  
ATOM    811  NZ  LYS   116      25.820 -19.872  19.666  1.00 39.79           N  
ATOM    812  N   GLN   117      22.067 -16.972  13.876  1.00 36.23           N  
ATOM    813  CA  GLN   117      20.877 -17.109  13.025  1.00 37.34           C  
ATOM    814  C   GLN   117      21.271 -17.048  11.555  1.00 37.69           C  
ATOM    815  O   GLN   117      21.845 -16.036  11.090  1.00 37.71           O  
ATOM    816  CB  GLN   117      19.869 -15.988  13.312  1.00 36.96           C  
ATOM    817  CG  GLN   117      18.463 -16.279  12.769  1.00 36.32           C  
ATOM    818  CD  GLN   117      17.735 -17.310  13.592  1.00 35.64           C  
ATOM    819  OE1 GLN   117      18.100 -17.589  14.764  1.00 33.21           O  
ATOM    820  NE2 GLN   117      16.695 -17.910  12.990  1.00 32.46           N  
ATOM    821  N   ARG   118      20.991 -18.126  10.825  1.00 37.71           N  
ATOM    822  CA  ARG   118      21.418 -18.190   9.418  1.00 37.98           C  
ATOM    823  C   ARG   118      20.741 -17.092   8.573  1.00 37.27           C  
ATOM    824  O   ARG   118      19.476 -17.000   8.499  1.00 37.04           O  
ATOM    825  CB  ARG   118      21.179 -19.576   8.789  1.00 38.02           C  
ATOM    826  CG  ARG   118      21.819 -19.735   7.378  1.00 39.40           C  
ATOM    827  CD  ARG   118      21.777 -21.175   6.875  1.00 38.52           C  
ATOM    828  NE  ARG   118      22.687 -22.033   7.665  1.00 38.06           N  
ATOM    829  CZ  ARG   118      24.022 -22.129   7.515  1.00 37.93           C  
ATOM    830  NH1 ARG   118      24.691 -21.440   6.593  1.00 34.56           N  
ATOM    831  NH2 ARG   118      24.703 -22.923   8.333  1.00 38.47           N  
ATOM    832  N   ILE   119      21.582 -16.256   7.956  1.00 36.09           N  
ATOM    833  CA  ILE   119      21.119 -15.156   7.094  1.00 36.00           C  
ATOM    834  C   ILE   119      21.166 -15.659   5.666  1.00 36.74           C  
ATOM    835  O   ILE   119      22.181 -16.133   5.235  1.00 36.50           O  
ATOM    836  CB  ILE   119      22.024 -13.877   7.212  1.00 35.96           C  
ATOM    837  CG1 ILE   119      22.022 -13.307   8.650  1.00 34.90           C  
ATOM    838  CG2 ILE   119      21.682 -12.825   6.125  1.00 35.15           C  
ATOM    839  CD1 ILE   119      20.602 -12.885   9.187  1.00 30.88           C  
ATOM    840  N   HIS   120      20.053 -15.565   4.942  1.00 36.85           N  
ATOM    841  CA  HIS   120      20.040 -15.841   3.493  1.00 38.96           C  
ATOM    842  C   HIS   120      20.138 -14.559   2.630  1.00 39.25           C  
ATOM    843  O   HIS   120      20.005 -13.427   3.128  1.00 40.02           O  
ATOM    844  CB  HIS   120      18.777 -16.660   3.144  1.00 38.05           C  
ATOM    845  CG  HIS   120      18.561 -17.800   4.089  1.00 38.96           C  
ATOM    846  ND1 HIS   120      19.418 -18.878   4.150  1.00 36.58           N  
ATOM    847  CD2 HIS   120      17.627 -18.000   5.053  1.00 35.27           C  
ATOM    848  CE1 HIS   120      19.003 -19.709   5.090  1.00 38.50           C  
ATOM    849  NE2 HIS   120      17.934 -19.192   5.668  1.00 35.36           N  
ATOM    850  N   THR   121      20.333 -14.756   1.338  1.00 39.59           N  
ATOM    851  CA  THR   121      20.491 -13.659   0.402  1.00 40.27           C  
ATOM    852  C   THR   121      19.199 -13.159  -0.273  1.00 40.15           C  
ATOM    853  O   THR   121      18.438 -13.936  -0.858  1.00 39.80           O  
ATOM    854  CB  THR   121      21.500 -14.066  -0.671  1.00 40.22           C  
ATOM    855  OG1 THR   121      22.749 -14.397  -0.034  1.00 41.98           O  
ATOM    856  CG2 THR   121      21.706 -12.937  -1.682  1.00 41.72           C  
ATOM    857  N   VAL   122      19.007 -11.839  -0.253  1.00 41.00           N  
ATOM    858  CA  VAL   122      17.854 -11.203  -0.869  1.00 41.58           C  
ATOM    859  C   VAL   122      18.258 -10.178  -1.930  1.00 43.48           C  
ATOM    860  O   VAL   122      19.146  -9.338  -1.698  1.00 43.53           O  
ATOM    861  CB  VAL   122      16.981 -10.464   0.162  1.00 41.71           C  
ATOM    862  CG1 VAL   122      15.644 -10.073  -0.474  1.00 38.28           C  
ATOM    863  CG2 VAL   122      16.765 -11.303   1.363  1.00 40.94           C  
ATOM    864  N   LYS   123      17.587 -10.270  -3.081  1.00 44.58           N  
ATOM    865  CA  LYS   123      17.739  -9.350  -4.214  1.00 46.35           C  
ATOM    866  C   LYS   123      16.342  -8.962  -4.683  1.00 46.16           C  
ATOM    867  O   LYS   123      15.405  -9.785  -4.628  1.00 46.09           O  
ATOM    868  CB  LYS   123      18.475 -10.028  -5.365  1.00 45.73           C  
ATOM    869  CG  LYS   123      19.758 -10.697  -4.915  1.00 49.43           C  
ATOM    870  CD  LYS   123      20.670 -11.185  -6.033  1.00 49.00           C  
ATOM    871  CE  LYS   123      21.765 -12.074  -5.411  1.00 53.31           C  
ATOM    872  NZ  LYS   123      23.006 -11.341  -5.004  1.00 54.10           N  
ATOM    873  N   VAL   124      16.198  -7.705  -5.112  1.00 46.40           N  
ATOM    874  CA  VAL   124      15.000  -7.293  -5.832  1.00 46.88           C  
ATOM    875  C   VAL   124      15.379  -7.052  -7.277  1.00 46.74           C  
ATOM    876  O   VAL   124      16.504  -6.635  -7.570  1.00 46.43           O  
ATOM    877  CB  VAL   124      14.232  -6.080  -5.185  1.00 47.39           C  
ATOM    878  CG1 VAL   124      13.900  -6.365  -3.711  1.00 46.38           C  
ATOM    879  CG2 VAL   124      15.003  -4.779  -5.323  1.00 48.38           C  
ATOM    880  N   ASP   125      14.456  -7.392  -8.164  1.00 46.24           N  
ATOM    881  CA  ASP   125      14.604  -7.198  -9.603  1.00 46.97           C  
ATOM    882  C   ASP   125      13.200  -7.131 -10.144  1.00 46.60           C  
ATOM    883  O   ASP   125      12.381  -8.010  -9.868  1.00 46.64           O  
ATOM    884  CB  ASP   125      15.365  -8.366 -10.243  1.00 47.02           C  
ATOM    885  CG  ASP   125      15.581  -8.179 -11.735  1.00 48.06           C  
ATOM    886  OD1 ASP   125      16.409  -7.324 -12.127  1.00 47.94           O  
ATOM    887  OD2 ASP   125      14.925  -8.901 -12.522  1.00 49.86           O  
ATOM    888  N   ASN   126      12.915  -6.066 -10.880  1.00 46.65           N  
ATOM    889  CA  ASN   126      11.595  -5.865 -11.459  1.00 46.94           C  
ATOM    890  C   ASN   126      10.482  -5.772 -10.414  1.00 46.29           C  
ATOM    891  O   ASN   126       9.341  -6.151 -10.691  1.00 46.38           O  
ATOM    892  CB  ASN   126      11.265  -6.996 -12.440  1.00 47.56           C  
ATOM    893  CG  ASN   126      11.881  -6.790 -13.785  1.00 48.66           C  
ATOM    894  OD1 ASN   126      13.106  -6.718 -13.920  1.00 51.64           O  
ATOM    895  ND2 ASN   126      11.040  -6.693 -14.802  1.00 48.83           N  
ATOM    896  N   GLY   127      10.816  -5.281  -9.221  1.00 45.49           N  
ATOM    897  CA  GLY   127       9.850  -5.254  -8.121  1.00 44.79           C  
ATOM    898  C   GLY   127       9.414  -6.632  -7.616  1.00 43.72           C  
ATOM    899  O   GLY   127       8.267  -6.769  -7.095  1.00 44.18           O  
ATOM    900  N   ASN   128      10.302  -7.652  -7.804  1.00 41.82           N  
ATOM    901  CA  ASN   128      10.065  -8.957  -7.237  1.00 40.23           C  
ATOM    902  C   ASN   128      11.127  -9.241  -6.198  1.00 40.41           C  
ATOM    903  O   ASN   128      12.298  -8.871  -6.378  1.00 39.02           O  
ATOM    904  CB  ASN   128      10.104 -10.042  -8.298  1.00 40.14           C  
ATOM    905  CG  ASN   128       8.857 -10.065  -9.183  1.00 40.64           C  
ATOM    906  OD1 ASN   128       7.774  -9.582  -8.797  1.00 42.50           O  
ATOM    907  ND2 ASN   128       9.001 -10.667 -10.368  1.00 35.86           N  
ATOM    908  N   ILE   129      10.736  -9.889  -5.104  1.00 39.25           N  
ATOM    909  CA  ILE   129      11.724 -10.264  -4.089  1.00 39.89           C  
ATOM    910  C   ILE   129      12.189 -11.689  -4.363  1.00 39.72           C  
ATOM    911  O   ILE   129      11.367 -12.580  -4.538  1.00 40.66           O  
ATOM    912  CB  ILE   129      11.177 -10.050  -2.666  1.00 40.15           C  
ATOM    913  CG1 ILE   129      10.646  -8.609  -2.563  1.00 39.73           C  
ATOM    914  CG2 ILE   129      12.289 -10.383  -1.574  1.00 38.54           C  
ATOM    915  CD1 ILE   129       9.946  -8.267  -1.304  1.00 41.42           C  
ATOM    916  N   TYR   130      13.505 -11.885  -4.456  1.00 39.44           N  
ATOM    917  CA  TYR   130      14.075 -13.199  -4.695  1.00 39.04           C  
ATOM    918  C   TYR   130      14.927 -13.622  -3.518  1.00 39.32           C  
ATOM    919  O   TYR   130      15.779 -12.858  -3.059  1.00 40.79           O  
ATOM    920  CB  TYR   130      14.921 -13.200  -5.984  1.00 38.38           C  
ATOM    921  CG  TYR   130      14.096 -13.000  -7.267  1.00 37.81           C  
ATOM    922  CD1 TYR   130      13.542 -14.087  -7.933  1.00 36.33           C  
ATOM    923  CD2 TYR   130      13.858 -11.725  -7.789  1.00 36.31           C  
ATOM    924  CE1 TYR   130      12.789 -13.923  -9.121  1.00 38.63           C  
ATOM    925  CE2 TYR   130      13.089 -11.540  -8.988  1.00 38.25           C  
ATOM    926  CZ  TYR   130      12.559 -12.647  -9.645  1.00 38.04           C  
ATOM    927  OH  TYR   130      11.771 -12.507 -10.806  1.00 40.74           O  
ATOM    928  N   VAL   131      14.753 -14.852  -3.063  1.00 38.99           N  
ATOM    929  CA  VAL   131      15.594 -15.364  -1.979  1.00 39.24           C  
ATOM    930  C   VAL   131      16.495 -16.532  -2.447  1.00 39.70           C  
ATOM    931  O   VAL   131      16.069 -17.417  -3.165  1.00 38.44           O  
ATOM    932  CB  VAL   131      14.755 -15.722  -0.681  1.00 40.15           C  
ATOM    933  CG1 VAL   131      15.672 -16.298   0.427  1.00 38.58           C  
ATOM    934  CG2 VAL   131      14.018 -14.500  -0.156  1.00 38.05           C  
ATOM    935  N   THR   132      17.747 -16.518  -2.008  1.00 40.04           N  
ATOM    936  CA  THR   132      18.662 -17.596  -2.286  1.00 40.59           C  
ATOM    937  C   THR   132      19.160 -18.076  -0.934  1.00 41.95           C  
ATOM    938  O   THR   132      19.635 -17.260  -0.131  1.00 42.01           O  
ATOM    939  CB  THR   132      19.816 -17.068  -3.200  1.00 40.85           C  
ATOM    940  OG1 THR   132      19.228 -16.494  -4.379  1.00 36.46           O  
ATOM    941  CG2 THR   132      20.793 -18.173  -3.591  1.00 40.09           C  
ATOM    942  N   LEU   133      19.006 -19.376  -0.646  1.00 43.00           N  
ATOM    943  CA  LEU   133      19.478 -19.932   0.642  1.00 43.84           C  
ATOM    944  C   LEU   133      21.003 -19.800   0.731  1.00 45.22           C  
ATOM    945  O   LEU   133      21.701 -19.944  -0.277  1.00 45.17           O  
ATOM    946  CB  LEU   133      19.037 -21.390   0.842  1.00 42.75           C  
ATOM    947  CG  LEU   133      17.561 -21.744   1.009  1.00 43.41           C  
ATOM    948  CD1 LEU   133      17.355 -23.248   1.217  1.00 40.34           C  
ATOM    949  CD2 LEU   133      16.914 -20.945   2.158  1.00 38.38           C  
ATOM    950  N   SER   134      21.518 -19.499   1.921  1.00 46.77           N  
ATOM    951  CA  SER   134      22.947 -19.315   2.087  1.00 48.93           C  
ATOM    952  C   SER   134      23.636 -20.617   2.454  1.00 50.30           C  
ATOM    953  O   SER   134      23.052 -21.430   3.178  1.00 50.76           O  
ATOM    954  CB  SER   134      23.217 -18.359   3.212  1.00 48.46           C  
ATOM    955  OG  SER   134      23.246 -19.084   4.431  1.00 51.29           O  
ATOM    956  N   LYS   135      24.888 -20.776   1.999  1.00 51.51           N  
ATOM    957  CA  LYS   135      25.747 -21.898   2.405  1.00 52.31           C  
ATOM    958  C   LYS   135      26.749 -21.454   3.469  1.00 53.22           C  
ATOM    959  O   LYS   135      27.278 -22.269   4.220  1.00 53.31           O  
ATOM    960  CB  LYS   135      26.517 -22.448   1.204  1.00 52.38           C  
ATOM    961  CG  LYS   135      25.832 -22.306  -0.127  1.00 52.11           C  
ATOM    962  CD  LYS   135      26.629 -23.075  -1.207  1.00 52.26           C  
ATOM    963  CE  LYS   135      26.349 -22.568  -2.623  1.00 51.66           C  
ATOM    964  NZ  LYS   135      27.234 -23.237  -3.657  1.00 51.02           N  
ATOM    965  N   GLU   136      27.006 -20.152   3.518  1.00 54.27           N  
ATOM    966  CA  GLU   136      27.956 -19.560   4.457  1.00 55.33           C  
ATOM    967  C   GLU   136      27.206 -19.019   5.694  1.00 55.09           C  
ATOM    968  O   GLU   136      26.128 -18.427   5.545  1.00 56.28           O  
ATOM    969  CB  GLU   136      28.719 -18.437   3.723  1.00 55.83           C  
ATOM    970  CG  GLU   136      29.997 -17.945   4.391  1.00 57.12           C  
ATOM    971  CD  GLU   136      31.278 -18.520   3.788  1.00 61.09           C  
ATOM    972  OE1 GLU   136      32.107 -19.071   4.568  1.00 61.63           O  
ATOM    973  OE2 GLU   136      31.476 -18.395   2.549  1.00 61.99           O  
ATOM    974  N   PRO   137      27.715 -19.267   6.936  1.00 55.06           N  
ATOM    975  CA  PRO   137      28.830 -20.105   7.419  1.00 54.23           C  
ATOM    976  C   PRO   137      28.458 -21.596   7.460  1.00 53.34           C  
ATOM    977  O   PRO   137      27.266 -21.937   7.390  1.00 53.31           O  
ATOM    978  CB  PRO   137      29.047 -19.593   8.848  1.00 53.86           C  
ATOM    979  CG  PRO   137      27.741 -19.181   9.281  1.00 54.97           C  
ATOM    980  CD  PRO   137      27.050 -18.585   8.071  1.00 54.57           C  
ATOM    981  N   PHE   138      29.459 -22.466   7.614  1.00 51.43           N  
ATOM    982  CA  PHE   138      29.223 -23.905   7.498  1.00 50.12           C  
ATOM    983  C   PHE   138      28.121 -24.426   8.435  1.00 48.87           C  
ATOM    984  O   PHE   138      27.243 -25.166   7.987  1.00 48.71           O  
ATOM    985  CB  PHE   138      30.543 -24.770   7.566  1.00 50.26           C  
ATOM    986  CG  PHE   138      30.222 -26.220   7.875  1.00 49.81           C  
ATOM    987  CD1 PHE   138      29.654 -27.076   6.745  1.00 51.49           C  
ATOM    988  CD2 PHE   138      30.384 -26.741   9.264  1.00 51.50           C  
ATOM    989  CE1 PHE   138      29.370 -28.414   7.051  1.00 51.29           C  
ATOM    990  CE2 PHE   138      30.105 -28.080   9.579  1.00 50.91           C  
ATOM    991  CZ  PHE   138      29.521 -28.922   8.458  1.00 51.61           C  
ATOM    992  N   LYS   139      28.144 -24.002   9.701  1.00 48.30           N  
ATOM    993  CA  LYS   139      27.051 -24.305  10.665  1.00 47.27           C  
ATOM    994  C   LYS   139      26.547 -23.108  11.510  1.00 45.92           C  
ATOM    995  O   LYS   139      27.349 -22.313  11.982  1.00 44.08           O  
ATOM    996  CB  LYS   139      27.496 -25.468  11.566  1.00 47.34           C  
ATOM    997  CG  LYS   139      26.480 -25.899  12.624  1.00 48.98           C  
ATOM    998  CD  LYS   139      27.075 -27.027  13.507  1.00 49.64           C  
ATOM    999  CE  LYS   139      26.266 -27.148  14.818  1.00 54.05           C  
ATOM   1000  NZ  LYS   139      26.806 -28.256  15.668  1.00 56.44           N  
ATOM   1001  N   CYS   140      25.210 -22.982  11.655  1.00 45.92           N  
ATOM   1002  CA  CYS   140      24.511 -22.004  12.540  1.00 46.22           C  
ATOM   1003  C   CYS   140      23.654 -22.698  13.584  1.00 45.35           C  
ATOM   1004  O   CYS   140      23.116 -23.767  13.310  1.00 46.60           O  
ATOM   1005  CB  CYS   140      23.596 -21.043  11.775  1.00 45.85           C  
ATOM   1006  SG  CYS   140      24.500 -20.055  10.567  1.00 48.91           S  
ATOM   1007  N   ASP   141      23.543 -22.117  14.776  1.00 44.08           N  
ATOM   1008  CA  ASP   141      22.661 -22.691  15.792  1.00 44.62           C  
ATOM   1009  C   ASP   141      21.209 -22.781  15.266  1.00 44.81           C  
ATOM   1010  O   ASP   141      20.514 -23.715  15.642  1.00 45.32           O  
ATOM   1011  CB  ASP   141      22.668 -21.877  17.082  1.00 44.12           C  
ATOM   1012  CG  ASP   141      23.859 -22.159  17.927  1.00 46.44           C  
ATOM   1013  OD1 ASP   141      24.743 -22.891  17.458  1.00 44.54           O  
ATOM   1014  OD2 ASP   141      23.923 -21.655  19.069  1.00 46.27           O  
ATOM   1015  N   SER   142      20.778 -21.871  14.383  1.00 43.14           N  
ATOM   1016  CA  SER   142      19.386 -21.945  13.855  1.00 44.31           C  
ATOM   1017  C   SER   142      19.056 -23.136  12.964  1.00 44.24           C  
ATOM   1018  O   SER   142      17.855 -23.430  12.753  1.00 44.10           O  
ATOM   1019  CB  SER   142      18.968 -20.672  13.109  1.00 42.51           C  
ATOM   1020  OG  SER   142      19.724 -20.520  11.920  1.00 44.57           O  
ATOM   1021  N   ASP   143      20.096 -23.789  12.422  1.00 45.06           N  
ATOM   1022  CA  ASP   143      19.920 -24.950  11.547  1.00 45.46           C  
ATOM   1023  C   ASP   143      19.147 -26.078  12.227  1.00 46.54           C  
ATOM   1024  O   ASP   143      18.376 -26.748  11.569  1.00 46.75           O  
ATOM   1025  CB  ASP   143      21.271 -25.513  11.043  1.00 45.66           C  
ATOM   1026  CG  ASP   143      22.036 -24.532  10.155  1.00 44.83           C  
ATOM   1027  OD1 ASP   143      21.419 -23.599   9.598  1.00 42.43           O  
ATOM   1028  OD2 ASP   143      23.265 -24.707  10.002  1.00 42.61           O  
ATOM   1029  N   TYR   144      19.381 -26.312  13.524  1.00 47.69           N  
ATOM   1030  CA  TYR   144      18.623 -27.347  14.256  1.00 48.61           C  
ATOM   1031  C   TYR   144      17.099 -27.159  14.128  1.00 48.69           C  
ATOM   1032  O   TYR   144      16.365 -28.135  13.991  1.00 47.78           O  
ATOM   1033  CB  TYR   144      18.997 -27.374  15.736  1.00 49.29           C  
ATOM   1034  CG  TYR   144      18.236 -28.431  16.549  1.00 50.70           C  
ATOM   1035  CD1 TYR   144      18.607 -29.785  16.506  1.00 52.62           C  
ATOM   1036  CD2 TYR   144      17.137 -28.072  17.355  1.00 50.86           C  
ATOM   1037  CE1 TYR   144      17.910 -30.757  17.256  1.00 53.14           C  
ATOM   1038  CE2 TYR   144      16.437 -29.036  18.096  1.00 50.65           C  
ATOM   1039  CZ  TYR   144      16.825 -30.359  18.054  1.00 51.92           C  
ATOM   1040  OH  TYR   144      16.129 -31.298  18.797  1.00 51.39           O  
ATOM   1041  N   TYR   145      16.644 -25.905  14.171  1.00 48.97           N  
ATOM   1042  CA  TYR   145      15.207 -25.585  14.134  1.00 49.21           C  
ATOM   1043  C   TYR   145      14.692 -25.435  12.713  1.00 49.99           C  
ATOM   1044  O   TYR   145      13.494 -25.243  12.506  1.00 50.05           O  
ATOM   1045  CB  TYR   145      14.899 -24.356  15.003  1.00 50.10           C  
ATOM   1046  CG  TYR   145      15.084 -24.675  16.463  1.00 49.20           C  
ATOM   1047  CD1 TYR   145      14.246 -25.591  17.080  1.00 50.84           C  
ATOM   1048  CD2 TYR   145      16.103 -24.109  17.212  1.00 45.52           C  
ATOM   1049  CE1 TYR   145      14.402 -25.937  18.406  1.00 51.72           C  
ATOM   1050  CE2 TYR   145      16.267 -24.456  18.567  1.00 47.36           C  
ATOM   1051  CZ  TYR   145      15.403 -25.363  19.144  1.00 50.04           C  
ATOM   1052  OH  TYR   145      15.524 -25.798  20.451  1.00 53.65           O  
ATOM   1053  N   ALA   146      15.602 -25.555  11.741  1.00 49.88           N  
ATOM   1054  CA  ALA   146      15.292 -25.302  10.345  1.00 50.90           C  
ATOM   1055  C   ALA   146      14.972 -26.581   9.602  1.00 52.22           C  
ATOM   1056  O   ALA   146      14.408 -26.522   8.507  1.00 52.25           O  
ATOM   1057  CB  ALA   146      16.440 -24.593   9.653  1.00 50.05           C  
ATOM   1058  N   THR   147      15.340 -27.724  10.190  1.00 53.87           N  
ATOM   1059  CA  THR   147      15.284 -29.020   9.494  1.00 54.91           C  
ATOM   1060  C   THR   147      14.885 -30.235  10.356  1.00 55.97           C  
ATOM   1061  O   THR   147      15.363 -30.403  11.483  1.00 55.90           O  
ATOM   1062  CB  THR   147      16.649 -29.340   8.805  1.00 55.15           C  
ATOM   1063  OG1 THR   147      17.733 -29.043   9.703  1.00 54.95           O  
ATOM   1064  CG2 THR   147      16.822 -28.514   7.524  1.00 55.67           C  
ATOM   1065  N   GLY   148      14.020 -31.085   9.788  1.00 57.03           N  
ATOM   1066  CA  GLY   148      13.682 -32.405  10.340  1.00 58.17           C  
ATOM   1067  C   GLY   148      12.993 -32.442  11.697  1.00 59.08           C  
ATOM   1068  O   GLY   148      12.159 -31.584  12.016  1.00 59.21           O  
ATOM   1069  N   GLU   149      13.354 -33.452  12.490  1.00 59.79           N  
ATOM   1070  CA  GLU   149      12.780 -33.700  13.825  1.00 60.24           C  
ATOM   1071  C   GLU   149      13.243 -32.700  14.895  1.00 60.72           C  
ATOM   1072  O   GLU   149      14.424 -32.708  15.283  1.00 61.14           O  
ATOM   1073  CB  GLU   149      13.135 -35.121  14.287  1.00 60.50           C  
ATOM   1074  CG  GLU   149      12.122 -36.220  13.932  1.00 60.05           C  
ATOM   1075  CD  GLU   149      11.038 -36.365  14.988  1.00 59.99           C  
ATOM   1076  OE1 GLU   149      10.594 -37.506  15.238  1.00 58.25           O  
ATOM   1077  OE2 GLU   149      10.638 -35.330  15.575  1.00 60.64           O  
ATOM   1078  N   PHE   150      12.312 -31.853  15.361  1.00 60.39           N  
ATOM   1079  CA  PHE   150      12.536 -30.943  16.513  1.00 60.35           C  
ATOM   1080  C   PHE   150      11.287 -30.683  17.391  1.00 59.56           C  
ATOM   1081  O   PHE   150      10.146 -30.940  16.985  1.00 59.84           O  
ATOM   1082  CB  PHE   150      13.215 -29.610  16.101  1.00 60.16           C  
ATOM   1083  CG  PHE   150      12.466 -28.833  15.057  1.00 61.05           C  
ATOM   1084  CD1 PHE   150      11.587 -27.820  15.425  1.00 62.70           C  
ATOM   1085  CD2 PHE   150      12.659 -29.093  13.697  1.00 62.07           C  
ATOM   1086  CE1 PHE   150      10.890 -27.086  14.451  1.00 62.87           C  
ATOM   1087  CE2 PHE   150      11.957 -28.387  12.708  1.00 63.06           C  
ATOM   1088  CZ  PHE   150      11.069 -27.377  13.087  1.00 63.13           C  
ATOM   1089  N   LYS   151      11.531 -30.222  18.613  1.00 58.08           N  
ATOM   1090  CA  LYS   151      10.482 -29.702  19.473  1.00 56.42           C  
ATOM   1091  C   LYS   151      10.831 -28.252  19.769  1.00 55.24           C  
ATOM   1092  O   LYS   151      12.015 -27.902  19.798  1.00 54.83           O  
ATOM   1093  CB  LYS   151      10.362 -30.540  20.750  1.00 57.09           C  
ATOM   1094  CG  LYS   151       9.370 -31.678  20.611  1.00 56.58           C  
ATOM   1095  CD  LYS   151       8.705 -31.985  21.949  1.00 59.54           C  
ATOM   1096  CE  LYS   151       7.414 -32.786  21.781  1.00 59.45           C  
ATOM   1097  NZ  LYS   151       6.864 -33.245  23.089  1.00 61.73           N  
ATOM   1098  N   VAL   152       9.824 -27.397  19.929  1.00 53.60           N  
ATOM   1099  CA  VAL   152      10.101 -25.999  20.303  1.00 53.08           C  
ATOM   1100  C   VAL   152       9.768 -25.697  21.790  1.00 52.22           C  
ATOM   1101  O   VAL   152       8.860 -26.281  22.367  1.00 51.30           O  
ATOM   1102  CB  VAL   152       9.599 -24.922  19.235  1.00 52.74           C  
ATOM   1103  CG1 VAL   152      10.068 -25.286  17.829  1.00 52.40           C  
ATOM   1104  CG2 VAL   152       8.128 -24.765  19.228  1.00 52.79           C  
ATOM   1105  N   ILE   153      10.568 -24.835  22.417  1.00 52.29           N  
ATOM   1106  CA  ILE   153      10.422 -24.558  23.848  1.00 52.31           C  
ATOM   1107  C   ILE   153      10.173 -23.064  24.121  1.00 51.77           C  
ATOM   1108  O   ILE   153      10.922 -22.204  23.637  1.00 51.74           O  
ATOM   1109  CB  ILE   153      11.666 -24.997  24.592  1.00 52.99           C  
ATOM   1110  CG1 ILE   153      11.771 -26.531  24.594  1.00 52.49           C  
ATOM   1111  CG2 ILE   153      11.651 -24.415  26.010  1.00 55.15           C  
ATOM   1112  CD1 ILE   153      13.034 -27.088  25.334  1.00 53.41           C  
ATOM   1113  N   GLN   154       9.086 -22.744  24.829  1.00 50.54           N  
ATOM   1114  CA  GLN   154       8.852 -21.355  25.219  1.00 49.09           C  
ATOM   1115  C   GLN   154       9.033 -21.316  26.726  1.00 48.53           C  
ATOM   1116  O   GLN   154       8.355 -22.092  27.425  1.00 47.25           O  
ATOM   1117  CB  GLN   154       7.471 -20.847  24.760  1.00 48.43           C  
ATOM   1118  CG  GLN   154       7.220 -19.364  25.065  1.00 49.16           C  
ATOM   1119  CD  GLN   154       5.802 -18.889  24.709  1.00 50.58           C  
ATOM   1120  OE1 GLN   154       4.958 -19.678  24.258  1.00 53.72           O  
ATOM   1121  NE2 GLN   154       5.535 -17.587  24.925  1.00 50.75           N  
END
