
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  137 ( 2164),  selected  137 , name 1qxn_A
# Molecule2: number of CA atoms  134 ( 1020),  selected  134 , name T0389.pdb
# PARAMETERS: 1qxn_A.T0389.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     1_A      -       -           -
LGA    D     2_A      -       -           -
LGA    M     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    E     5_A      -       -           -
LGA    K     6_A      -       -           -
LGA    F     7_A      -       -           -
LGA    D     8_A      -       -           -
LGA    A     9_A      -       -           -
LGA    T    10_A      -       -           -
LGA    F    11_A      -       -           -
LGA    K    12_A      -       -           -
LGA    A    13_A      -       -           -
LGA    Q    14_A      -       -           -
LGA    V    15_A      -       -           -
LGA    K    16_A      -       -           -
LGA    A    17_A      -       -           -
LGA    A    18_A      -       -           -
LGA    K    19_A      M       1           #
LGA    A    20_A      -       -           -
LGA    D    21_A      I       2          2.615
LGA    M    22_A      G       3          1.882
LGA    V    23_A      T       4          1.974
LGA    M    24_A      Q       5          0.925
LGA    L    25_A      I       6          1.038
LGA    S    26_A      V       7          1.254
LGA    P    27_A      T       8          2.602
LGA    K    28_A      E       9          2.851
LGA    D    29_A      R      10          1.456
LGA    A    30_A      L      11          1.743
LGA    Y    31_A      V      12          3.031
LGA    K    32_A      A      13          2.369
LGA    L    33_A      L      14          1.126
LGA    L    34_A      L      15          2.687
LGA    Q    35_A      E      16          3.701
LGA    E    36_A      S      17          2.164
LGA    N    37_A      G      18          3.961
LGA    -       -      T      19           -
LGA    P    38_A      E      20           #
LGA    D    39_A      K      21          1.501
LGA    I    40_A      V      22          1.562
LGA    T    41_A      L      23          1.298
LGA    L    42_A      L      24          0.890
LGA    I    43_A      I      25          1.119
LGA    D    44_A      D      26          1.159
LGA    V    45_A      S      27          0.833
LGA    R    46_A      R      28          0.991
LGA    D    47_A      P      29          0.700
LGA    P    48_A      F      30          1.463
LGA    D    49_A      V      31          1.576
LGA    E    50_A      E      32          1.836
LGA    L    51_A      Y      33          2.323
LGA    K    52_A      N      34          3.392
LGA    A    53_A      T      35          3.726
LGA    M    54_A      -       -           -
LGA    G    55_A      S      36          1.177
LGA    K    56_A      H      37          0.935
LGA    P    57_A      I      38          0.875
LGA    D    58_A      L      39          1.341
LGA    V    59_A      E      40          3.267
LGA    K    60_A      -       -           -
LGA    N    61_A      -       -           -
LGA    Y    62_A      A      41          2.944
LGA    K    63_A      I      42          2.071
LGA    H    64_A      N      43          1.763
LGA    M    65_A      I      44          1.833
LGA    S    66_A      N      45          1.701
LGA    R    67_A      C      46           #
LGA    -       -      S      47           -
LGA    -       -      K      48           -
LGA    -       -      L      49           -
LGA    G    68_A      M      50          2.643
LGA    K    69_A      K      51          4.309
LGA    L    70_A      R      52           -
LGA    -       -      R      53           -
LGA    E    71_A      L      54          3.898
LGA    -       -      Q      55           -
LGA    -       -      Q      56           -
LGA    -       -      D      57           -
LGA    -       -      K      58           -
LGA    P    72_A      V      59          3.465
LGA    L    73_A      L      60           #
LGA    L    74_A      I      61          2.736
LGA    A    75_A      T      62          2.401
LGA    K    76_A      E      63          3.212
LGA    -       -      L      64           -
LGA    -       -      I      65           -
LGA    S    77_A      Q      66          1.550
LGA    G    78_A      H      67           -
LGA    -       -      S      68           -
LGA    -       -      A      69           -
LGA    -       -      K      70           -
LGA    -       -      H      71           -
LGA    -       -      K      72           -
LGA    -       -      V      73           -
LGA    -       -      D      74           -
LGA    L    79_A      I      75          2.390
LGA    D    80_A      D      76          3.009
LGA    P    81_A      C      77          2.526
LGA    E    82_A      S      78          2.564
LGA    K    83_A      Q      79          2.264
LGA    P    84_A      K      80          1.660
LGA    V    85_A      V      81          0.798
LGA    V    86_A      V      82          0.833
LGA    V    87_A      V      83          0.493
LGA    F    88_A      Y      84          1.025
LGA    C    89_A      D      85          1.207
LGA    -       -      Q      86           -
LGA    K    90_A      S      87           #
LGA    T    91_A      S      88          3.245
LGA    A    92_A      Q      89           -
LGA    A    93_A      D      90           -
LGA    -       -      V      91           -
LGA    -       -      A      92           -
LGA    -       -      S      93           -
LGA    -       -      L      94           -
LGA    -       -      S      95           -
LGA    -       -      S      96           -
LGA    -       -      D      97           -
LGA    -       -      C      98           -
LGA    R    94_A      F      99          4.941
LGA    A    95_A      L     100          3.388
LGA    A    96_A      T     101          3.514
LGA    L    97_A      V     102          2.891
LGA    A    98_A      L     103          1.994
LGA    G    99_A      L     104          2.360
LGA    K   100_A      -       -           -
LGA    T   101_A      G     105          1.163
LGA    L   102_A      K     106          3.701
LGA    R   103_A      L     107          5.390
LGA    E   104_A      E     108          4.405
LGA    Y   105_A      K     109          1.769
LGA    G   106_A      S     110          4.948
LGA    F   107_A      F     111          2.302
LGA    K   108_A      N     112          1.335
LGA    T   109_A      S     113          1.183
LGA    I   110_A      V     114          1.204
LGA    Y   111_A      H     115          1.189
LGA    N   112_A      L     116          0.880
LGA    S   113_A      L     117          0.506
LGA    E   114_A      A     118          1.032
LGA    G   115_A      G     119          0.798
LGA    G   116_A      G     120          1.456
LGA    M   117_A      F     121          1.599
LGA    D   118_A      A     122          0.964
LGA    K   119_A      E     123          1.045
LGA    W   120_A      F     124          1.783
LGA    L   121_A      S     125          1.355
LGA    E   122_A      R     126          0.762
LGA    E   123_A      C     127          1.200
LGA    G   124_A      F     128          2.189
LGA    L   125_A      P     129          4.165
LGA    -       -      G     130           -
LGA    P   126_A      L     131          0.653
LGA    S   127_A      C     132          0.564
LGA    L   128_A      E     133          0.741
LGA    D   129_A      G     134          2.171
LGA    R   130_A      -       -           -
LGA    S   131_A      -       -           -
LGA    H   132_A      -       -           -
LGA    H   133_A      -       -           -
LGA    H   134_A      -       -           -
LGA    H   135_A      -       -           -
LGA    H   136_A      -       -           -
LGA    H   137_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  137  134    5.0     97    2.33    16.49     48.940     3.994

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.849389 * X  +   0.194075 * Y  +   0.490788 * Z  + -15.929564
  Y_new =   0.085633 * X  +   0.866931 * Y  +  -0.491017 * Z  +  12.327692
  Z_new =  -0.520773 * X  +   0.459092 * Y  +   0.719743 * Z  +   6.315011 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.567791   -2.573802  [ DEG:    32.5320   -147.4680 ]
  Theta =   0.547756    2.593836  [ DEG:    31.3841    148.6159 ]
  Phi   =   0.100477   -3.041115  [ DEG:     5.7569   -174.2431 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1qxn_A                                        
REMARK     2: T0389.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1qxn_A.T0389.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  137  134   5.0   97   2.33   16.49  48.940
REMARK  ---------------------------------------------------------- 
MOLECULE 1qxn_A
HEADER    TRANSFERASE                             08-SEP-03   1QXN              
TITLE     SOLUTION STRUCTURE OF THE 30 KDA POLYSULFIDE-SULFUR                   
TITLE    2 TRANSFERASE HOMODIMER FROM WOLINELLA SUCCINOGENES                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SULFIDE DEHYDROGENASE;                                     
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: SUD;                                                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: WOLINELLA SUCCINOGENES;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: DH5A;                                      
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PQE60_SUD-HIS6                            
KEYWDS    POLYSULFIDE-SULFUR TRANSFERASE, SUD, HOMODIMER                        
EXPDTA    NMR, 10 STRUCTURES                                                    
AUTHOR    Y.J.LIN,F.DANCEA,F.LOEHR,O.KLIMMEK,S.PFEIFFER-MAREK,                  
AUTHOR   2 M.NILGES,H.WIENK,A.KROEGER,H.RUETERJANS                              
REVDAT   1   24-FEB-04 1QXN    0                                                
JRNL        AUTH   Y.J.LIN,F.DANCEA,F.LOEHR,O.KLIMMEK,                          
JRNL        AUTH 2 S.PFEIFFER-MAREK,M.NILGES,H.WIENK,A.KROEGER,                 
JRNL        AUTH 3 H.RUETERJANS                                                 
JRNL        TITL   SOLUTION STRUCTURE OF THE 30 KDA                             
JRNL        TITL 2 POLYSULFIDE-SULFUR TRANSFERASE HOMODIMER FROM                
JRNL        TITL 3 WOLINELLA SUCCINOGENES                                       
JRNL        REF    BIOCHEMISTRY                  V.  43  1418 2004              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1QXN A    1   129  UNP    Q56748   Q56748_WOLSU    21    149             
DBREF  1QXN B    1   129  UNP    Q56748   Q56748_WOLSU    21    149             
SEQRES   1 A  137  ALA ASP MET GLY GLU LYS PHE ASP ALA THR PHE LYS ALA          
SEQRES   2 A  137  GLN VAL LYS ALA ALA LYS ALA ASP MET VAL MET LEU SER          
SEQRES   3 A  137  PRO LYS ASP ALA TYR LYS LEU LEU GLN GLU ASN PRO ASP          
SEQRES   4 A  137  ILE THR LEU ILE ASP VAL ARG ASP PRO ASP GLU LEU LYS          
SEQRES   5 A  137  ALA MET GLY LYS PRO ASP VAL LYS ASN TYR LYS HIS MET          
SEQRES   6 A  137  SER ARG GLY LYS LEU GLU PRO LEU LEU ALA LYS SER GLY          
SEQRES   7 A  137  LEU ASP PRO GLU LYS PRO VAL VAL VAL PHE CYS LYS THR          
SEQRES   8 A  137  ALA ALA ARG ALA ALA LEU ALA GLY LYS THR LEU ARG GLU          
SEQRES   9 A  137  TYR GLY PHE LYS THR ILE TYR ASN SER GLU GLY GLY MET          
SEQRES  10 A  137  ASP LYS TRP LEU GLU GLU GLY LEU PRO SER LEU ASP ARG          
SEQRES  11 A  137  SER HIS HIS HIS HIS HIS HIS                                  
SEQRES   1 B  137  ALA ASP MET GLY GLU LYS PHE ASP ALA THR PHE LYS ALA          
SEQRES   2 B  137  GLN VAL LYS ALA ALA LYS ALA ASP MET VAL MET LEU SER          
SEQRES   3 B  137  PRO LYS ASP ALA TYR LYS LEU LEU GLN GLU ASN PRO ASP          
SEQRES   4 B  137  ILE THR LEU ILE ASP VAL ARG ASP PRO ASP GLU LEU LYS          
SEQRES   5 B  137  ALA MET GLY LYS PRO ASP VAL LYS ASN TYR LYS HIS MET          
SEQRES   6 B  137  SER ARG GLY LYS LEU GLU PRO LEU LEU ALA LYS SER GLY          
SEQRES   7 B  137  LEU ASP PRO GLU LYS PRO VAL VAL VAL PHE CYS LYS THR          
SEQRES   8 B  137  ALA ALA ARG ALA ALA LEU ALA GLY LYS THR LEU ARG GLU          
SEQRES   9 B  137  TYR GLY PHE LYS THR ILE TYR ASN SER GLU GLY GLY MET          
SEQRES  10 B  137  ASP LYS TRP LEU GLU GLU GLY LEU PRO SER LEU ASP ARG          
SEQRES  11 B  137  SER HIS HIS HIS HIS HIS HIS                                  
HET    PS5  A 138       5                                                       
HET    PS5  B 139       5                                                       
HETNAM     PS5 PENTASULFIDE-SULFUR                                              
FORMUL   3  PS5    2(S5 2-)                                                     
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   ALA A   1     -32.116  -6.630  23.807  1.00  0.00           N  
ATOM      2  CA  ALA A   1     -32.291  -5.202  23.454  1.00  0.00           C  
ATOM      3  C   ALA A   1     -30.998  -4.455  23.721  1.00  0.00           C  
ATOM      4  O   ALA A   1     -30.964  -3.487  24.480  1.00  0.00           O  
ATOM      5  CB  ALA A   1     -33.443  -4.595  24.243  1.00  0.00           C  
ATOM      6  HA  ALA A   1     -32.525  -5.134  22.400  1.00  0.00           H  
ATOM      7  HB1 ALA A   1     -34.069  -5.385  24.629  1.00  0.00           H  
ATOM      8  HB2 ALA A   1     -33.051  -4.011  25.064  1.00  0.00           H  
ATOM      9  HB3 ALA A   1     -34.027  -3.957  23.595  1.00  0.00           H  
ATOM     10  H1  ALA A   1     -32.853  -6.932  24.475  1.00  0.00           H  
ATOM     11  H2  ALA A   1     -32.175  -7.223  22.949  1.00  0.00           H  
ATOM     12  H3  ALA A   1     -31.180  -6.772  24.253  1.00  0.00           H  
ATOM     13  N   ASP A   2     -29.913  -5.023  23.217  1.00  0.00           N  
ATOM     14  CA  ASP A   2     -28.575  -4.550  23.521  1.00  0.00           C  
ATOM     15  C   ASP A   2     -27.575  -5.194  22.574  1.00  0.00           C  
ATOM     16  O   ASP A   2     -26.520  -5.673  22.992  1.00  0.00           O  
ATOM     17  CB  ASP A   2     -28.210  -4.884  24.979  1.00  0.00           C  
ATOM     18  CG  ASP A   2     -28.423  -6.353  25.334  1.00  0.00           C  
ATOM     19  OD1 ASP A   2     -29.543  -6.877  25.111  1.00  0.00           O  
ATOM     20  OD2 ASP A   2     -27.478  -6.982  25.853  1.00  0.00           O  
ATOM     21  H   ASP A   2     -30.007  -5.861  22.716  1.00  0.00           H  
ATOM     22  HA  ASP A   2     -28.558  -3.479  23.384  1.00  0.00           H  
ATOM     23  HB2 ASP A   2     -27.170  -4.646  25.143  1.00  0.00           H  
ATOM     24  HB3 ASP A   2     -28.817  -4.283  25.639  1.00  0.00           H  
ATOM     25  N   MET A   3     -27.941  -5.267  21.302  1.00  0.00           N  
ATOM     26  CA  MET A   3     -27.113  -5.931  20.297  1.00  0.00           C  
ATOM     27  C   MET A   3     -25.973  -5.038  19.812  1.00  0.00           C  
ATOM     28  O   MET A   3     -25.398  -5.278  18.749  1.00  0.00           O  
ATOM     29  CB  MET A   3     -27.972  -6.360  19.109  1.00  0.00           C  
ATOM     30  CG  MET A   3     -28.001  -7.861  18.892  1.00  0.00           C  
ATOM     31  SD  MET A   3     -27.949  -8.787  20.440  1.00  0.00           S  
ATOM     32  CE  MET A   3     -29.566  -9.550  20.417  1.00  0.00           C  
ATOM     33  H   MET A   3     -28.823  -4.911  21.035  1.00  0.00           H  
ATOM     34  HA  MET A   3     -26.689  -6.813  20.752  1.00  0.00           H  
ATOM     35  HB2 MET A   3     -28.984  -6.022  19.273  1.00  0.00           H  
ATOM     36  HB3 MET A   3     -27.587  -5.893  18.214  1.00  0.00           H  
ATOM     37  HG2 MET A   3     -28.907  -8.117  18.366  1.00  0.00           H  
ATOM     38  HG3 MET A   3     -27.146  -8.140  18.293  1.00  0.00           H  
ATOM     39  HE1 MET A   3     -30.318  -8.790  20.260  1.00  0.00           H  
ATOM     40  HE2 MET A   3     -29.612 -10.270  19.613  1.00  0.00           H  
ATOM     41  HE3 MET A   3     -29.745 -10.047  21.359  1.00  0.00           H  
ATOM     42  N   GLY A   4     -25.651  -4.020  20.602  1.00  0.00           N  
ATOM     43  CA  GLY A   4     -24.578  -3.103  20.253  1.00  0.00           C  
ATOM     44  C   GLY A   4     -23.241  -3.795  20.082  1.00  0.00           C  
ATOM     45  O   GLY A   4     -22.484  -3.483  19.166  1.00  0.00           O  
ATOM     46  H   GLY A   4     -26.145  -3.891  21.436  1.00  0.00           H  
ATOM     47  HA2 GLY A   4     -24.833  -2.605  19.330  1.00  0.00           H  
ATOM     48  HA3 GLY A   4     -24.489  -2.362  21.033  1.00  0.00           H  
ATOM     49  N   GLU A   5     -22.983  -4.776  20.930  1.00  0.00           N  
ATOM     50  CA  GLU A   5     -21.758  -5.558  20.845  1.00  0.00           C  
ATOM     51  C   GLU A   5     -21.794  -6.476  19.625  1.00  0.00           C  
ATOM     52  O   GLU A   5     -20.772  -6.719  18.985  1.00  0.00           O  
ATOM     53  CB  GLU A   5     -21.565  -6.377  22.124  1.00  0.00           C  
ATOM     54  CG  GLU A   5     -20.284  -7.195  22.144  1.00  0.00           C  
ATOM     55  CD  GLU A   5     -20.446  -8.504  22.889  1.00  0.00           C  
ATOM     56  OE1 GLU A   5     -21.050  -8.501  23.982  1.00  0.00           O  
ATOM     57  OE2 GLU A   5     -19.968  -9.543  22.386  1.00  0.00           O  
ATOM     58  H   GLU A   5     -23.662  -4.998  21.601  1.00  0.00           H  
ATOM     59  HA  GLU A   5     -20.930  -4.871  20.739  1.00  0.00           H  
ATOM     60  HB2 GLU A   5     -21.549  -5.704  22.969  1.00  0.00           H  
ATOM     61  HB3 GLU A   5     -22.400  -7.053  22.231  1.00  0.00           H  
ATOM     62  HG2 GLU A   5     -19.991  -7.409  21.129  1.00  0.00           H  
ATOM     63  HG3 GLU A   5     -19.510  -6.617  22.629  1.00  0.00           H  
ATOM     64  N   LYS A   6     -22.965  -7.036  19.356  1.00  0.00           N  
ATOM     65  CA  LYS A   6     -23.129  -7.997  18.273  1.00  0.00           C  
ATOM     66  C   LYS A   6     -22.780  -7.405  16.906  1.00  0.00           C  
ATOM     67  O   LYS A   6     -21.981  -7.984  16.168  1.00  0.00           O  
ATOM     68  CB  LYS A   6     -24.554  -8.543  18.261  1.00  0.00           C  
ATOM     69  CG  LYS A   6     -24.805  -9.573  19.349  1.00  0.00           C  
ATOM     70  CD  LYS A   6     -25.130 -10.936  18.769  1.00  0.00           C  
ATOM     71  CE  LYS A   6     -25.959 -11.766  19.735  1.00  0.00           C  
ATOM     72  NZ  LYS A   6     -27.050 -12.503  19.046  1.00  0.00           N  
ATOM     73  H   LYS A   6     -23.727  -6.839  19.943  1.00  0.00           H  
ATOM     74  HA  LYS A   6     -22.453  -8.815  18.467  1.00  0.00           H  
ATOM     75  HB2 LYS A   6     -25.245  -7.724  18.401  1.00  0.00           H  
ATOM     76  HB3 LYS A   6     -24.745  -9.006  17.305  1.00  0.00           H  
ATOM     77  HG2 LYS A   6     -23.920  -9.658  19.961  1.00  0.00           H  
ATOM     78  HG3 LYS A   6     -25.633  -9.242  19.959  1.00  0.00           H  
ATOM     79  HD2 LYS A   6     -25.688 -10.803  17.853  1.00  0.00           H  
ATOM     80  HD3 LYS A   6     -24.207 -11.455  18.559  1.00  0.00           H  
ATOM     81  HE2 LYS A   6     -25.313 -12.478  20.227  1.00  0.00           H  
ATOM     82  HE3 LYS A   6     -26.394 -11.108  20.474  1.00  0.00           H  
ATOM     83  HZ1 LYS A   6     -27.592 -11.854  18.434  1.00  0.00           H  
ATOM     84  HZ2 LYS A   6     -26.653 -13.265  18.455  1.00  0.00           H  
ATOM     85  HZ3 LYS A   6     -27.699 -12.924  19.745  1.00  0.00           H  
ATOM     86  N   PHE A   7     -23.427  -6.307  16.518  1.00  0.00           N  
ATOM     87  CA  PHE A   7     -23.202  -5.762  15.180  1.00  0.00           C  
ATOM     88  C   PHE A   7     -21.869  -5.015  15.088  1.00  0.00           C  
ATOM     89  O   PHE A   7     -21.347  -4.814  13.989  1.00  0.00           O  
ATOM     90  CB  PHE A   7     -24.373  -4.890  14.691  1.00  0.00           C  
ATOM     91  CG  PHE A   7     -24.946  -3.919  15.689  1.00  0.00           C  
ATOM     92  CD1 PHE A   7     -24.162  -2.925  16.247  1.00  0.00           C  
ATOM     93  CD2 PHE A   7     -26.288  -3.983  16.039  1.00  0.00           C  
ATOM     94  CE1 PHE A   7     -24.700  -2.014  17.133  1.00  0.00           C  
ATOM     95  CE2 PHE A   7     -26.830  -3.077  16.931  1.00  0.00           C  
ATOM     96  CZ  PHE A   7     -26.035  -2.090  17.477  1.00  0.00           C  
ATOM     97  H   PHE A   7     -24.106  -5.905  17.107  1.00  0.00           H  
ATOM     98  HA  PHE A   7     -23.133  -6.615  14.520  1.00  0.00           H  
ATOM     99  HB2 PHE A   7     -24.041  -4.315  13.842  1.00  0.00           H  
ATOM    100  HB3 PHE A   7     -25.174  -5.543  14.374  1.00  0.00           H  
ATOM    101  HD1 PHE A   7     -23.116  -2.864  15.981  1.00  0.00           H  
ATOM    102  HD2 PHE A   7     -26.912  -4.758  15.614  1.00  0.00           H  
ATOM    103  HE1 PHE A   7     -24.076  -1.244  17.561  1.00  0.00           H  
ATOM    104  HE2 PHE A   7     -27.873  -3.141  17.198  1.00  0.00           H  
ATOM    105  HZ  PHE A   7     -26.455  -1.379  18.171  1.00  0.00           H  
ATOM    106  N   ASP A   8     -21.355  -4.576  16.237  1.00  0.00           N  
ATOM    107  CA  ASP A   8     -20.101  -3.807  16.289  1.00  0.00           C  
ATOM    108  C   ASP A   8     -18.979  -4.537  15.549  1.00  0.00           C  
ATOM    109  O   ASP A   8     -18.257  -3.935  14.749  1.00  0.00           O  
ATOM    110  CB  ASP A   8     -19.678  -3.556  17.745  1.00  0.00           C  
ATOM    111  CG  ASP A   8     -18.166  -3.569  17.939  1.00  0.00           C  
ATOM    112  OD1 ASP A   8     -17.499  -2.568  17.592  1.00  0.00           O  
ATOM    113  OD2 ASP A   8     -17.637  -4.581  18.450  1.00  0.00           O  
ATOM    114  H   ASP A   8     -21.874  -4.731  17.056  1.00  0.00           H  
ATOM    115  HA  ASP A   8     -20.275  -2.858  15.806  1.00  0.00           H  
ATOM    116  HB2 ASP A   8     -20.050  -2.593  18.057  1.00  0.00           H  
ATOM    117  HB3 ASP A   8     -20.106  -4.322  18.373  1.00  0.00           H  
ATOM    118  N   ALA A   9     -18.854  -5.837  15.809  1.00  0.00           N  
ATOM    119  CA  ALA A   9     -17.837  -6.660  15.165  1.00  0.00           C  
ATOM    120  C   ALA A   9     -17.965  -6.613  13.645  1.00  0.00           C  
ATOM    121  O   ALA A   9     -16.968  -6.530  12.928  1.00  0.00           O  
ATOM    122  CB  ALA A   9     -17.933  -8.095  15.662  1.00  0.00           C  
ATOM    123  H   ALA A   9     -19.469  -6.254  16.449  1.00  0.00           H  
ATOM    124  HA  ALA A   9     -16.868  -6.272  15.447  1.00  0.00           H  
ATOM    125  HB1 ALA A   9     -18.881  -8.243  16.156  1.00  0.00           H  
ATOM    126  HB2 ALA A   9     -17.855  -8.772  14.825  1.00  0.00           H  
ATOM    127  HB3 ALA A   9     -17.130  -8.290  16.357  1.00  0.00           H  
ATOM    128  N   THR A  10     -19.198  -6.674  13.159  1.00  0.00           N  
ATOM    129  CA  THR A  10     -19.454  -6.648  11.729  1.00  0.00           C  
ATOM    130  C   THR A  10     -19.099  -5.285  11.126  1.00  0.00           C  
ATOM    131  O   THR A  10     -18.490  -5.213  10.060  1.00  0.00           O  
ATOM    132  CB  THR A  10     -20.922  -6.987  11.431  1.00  0.00           C  
ATOM    133  OG1 THR A  10     -21.624  -7.206  12.664  1.00  0.00           O  
ATOM    134  CG2 THR A  10     -21.025  -8.227  10.558  1.00  0.00           C  
ATOM    135  H   THR A  10     -19.952  -6.750  13.781  1.00  0.00           H  
ATOM    136  HA  THR A  10     -18.834  -7.404  11.268  1.00  0.00           H  
ATOM    137  HB  THR A  10     -21.373  -6.155  10.908  1.00  0.00           H  
ATOM    138  HG1 THR A  10     -21.860  -6.352  13.049  1.00  0.00           H  
ATOM    139 HG21 THR A  10     -20.077  -8.749  10.561  1.00  0.00           H  
ATOM    140 HG22 THR A  10     -21.794  -8.878  10.947  1.00  0.00           H  
ATOM    141 HG23 THR A  10     -21.273  -7.937   9.548  1.00  0.00           H  
ATOM    142  N   PHE A  11     -19.475  -4.204  11.814  1.00  0.00           N  
ATOM    143  CA  PHE A  11     -19.178  -2.848  11.344  1.00  0.00           C  
ATOM    144  C   PHE A  11     -17.673  -2.668  11.163  1.00  0.00           C  
ATOM    145  O   PHE A  11     -17.214  -2.149  10.145  1.00  0.00           O  
ATOM    146  CB  PHE A  11     -19.722  -1.803  12.330  1.00  0.00           C  
ATOM    147  CG  PHE A  11     -20.201  -0.531  11.677  1.00  0.00           C  
ATOM    148  CD1 PHE A  11     -19.364   0.197  10.846  1.00  0.00           C  
ATOM    149  CD2 PHE A  11     -21.487  -0.063  11.897  1.00  0.00           C  
ATOM    150  CE1 PHE A  11     -19.799   1.364  10.248  1.00  0.00           C  
ATOM    151  CE2 PHE A  11     -21.929   1.105  11.301  1.00  0.00           C  
ATOM    152  CZ  PHE A  11     -21.082   1.818  10.474  1.00  0.00           C  
ATOM    153  H   PHE A  11     -19.967  -4.321  12.658  1.00  0.00           H  
ATOM    154  HA  PHE A  11     -19.660  -2.716  10.388  1.00  0.00           H  
ATOM    155  HB2 PHE A  11     -20.555  -2.228  12.868  1.00  0.00           H  
ATOM    156  HB3 PHE A  11     -18.943  -1.544  13.031  1.00  0.00           H  
ATOM    157  HD1 PHE A  11     -18.357  -0.157  10.666  1.00  0.00           H  
ATOM    158  HD2 PHE A  11     -22.149  -0.617  12.544  1.00  0.00           H  
ATOM    159  HE1 PHE A  11     -19.135   1.920   9.603  1.00  0.00           H  
ATOM    160  HE2 PHE A  11     -22.933   1.458  11.481  1.00  0.00           H  
ATOM    161  HZ  PHE A  11     -21.422   2.733  10.009  1.00  0.00           H  
ATOM    162  N   LYS A  12     -16.916  -3.144  12.141  1.00  0.00           N  
ATOM    163  CA  LYS A  12     -15.461  -3.085  12.096  1.00  0.00           C  
ATOM    164  C   LYS A  12     -14.901  -3.971  10.982  1.00  0.00           C  
ATOM    165  O   LYS A  12     -13.838  -3.691  10.429  1.00  0.00           O  
ATOM    166  CB  LYS A  12     -14.877  -3.509  13.447  1.00  0.00           C  
ATOM    167  CG  LYS A  12     -13.421  -3.105  13.644  1.00  0.00           C  
ATOM    168  CD  LYS A  12     -13.148  -1.708  13.109  1.00  0.00           C  
ATOM    169  CE  LYS A  12     -12.324  -0.888  14.085  1.00  0.00           C  
ATOM    170  NZ  LYS A  12     -13.151   0.125  14.788  1.00  0.00           N  
ATOM    171  H   LYS A  12     -17.350  -3.575  12.911  1.00  0.00           H  
ATOM    172  HA  LYS A  12     -15.180  -2.062  11.900  1.00  0.00           H  
ATOM    173  HB2 LYS A  12     -15.460  -3.058  14.236  1.00  0.00           H  
ATOM    174  HB3 LYS A  12     -14.945  -4.583  13.530  1.00  0.00           H  
ATOM    175  HG2 LYS A  12     -13.192  -3.125  14.699  1.00  0.00           H  
ATOM    176  HG3 LYS A  12     -12.790  -3.810  13.124  1.00  0.00           H  
ATOM    177  HD2 LYS A  12     -12.606  -1.790  12.177  1.00  0.00           H  
ATOM    178  HD3 LYS A  12     -14.089  -1.208  12.936  1.00  0.00           H  
ATOM    179  HE2 LYS A  12     -11.888  -1.553  14.814  1.00  0.00           H  
ATOM    180  HE3 LYS A  12     -11.537  -0.386  13.541  1.00  0.00           H  
ATOM    181  HZ1 LYS A  12     -14.035  -0.310  15.132  1.00  0.00           H  
ATOM    182  HZ2 LYS A  12     -12.625   0.508  15.604  1.00  0.00           H  
ATOM    183  HZ3 LYS A  12     -13.390   0.909  14.137  1.00  0.00           H  
ATOM    184  N   ALA A  13     -15.646  -5.005  10.625  1.00  0.00           N  
ATOM    185  CA  ALA A  13     -15.247  -5.901   9.549  1.00  0.00           C  
ATOM    186  C   ALA A  13     -15.406  -5.229   8.188  1.00  0.00           C  
ATOM    187  O   ALA A  13     -14.540  -5.348   7.318  1.00  0.00           O  
ATOM    188  CB  ALA A  13     -16.061  -7.186   9.607  1.00  0.00           C  
ATOM    189  H   ALA A  13     -16.511  -5.137  11.064  1.00  0.00           H  
ATOM    190  HA  ALA A  13     -14.205  -6.154   9.694  1.00  0.00           H  
ATOM    191  HB1 ALA A  13     -15.970  -7.624  10.590  1.00  0.00           H  
ATOM    192  HB2 ALA A  13     -17.101  -6.965   9.406  1.00  0.00           H  
ATOM    193  HB3 ALA A  13     -15.692  -7.883   8.868  1.00  0.00           H  
ATOM    194  N   GLN A  14     -16.512  -4.521   8.018  1.00  0.00           N  
ATOM    195  CA  GLN A  14     -16.793  -3.826   6.769  1.00  0.00           C  
ATOM    196  C   GLN A  14     -15.888  -2.609   6.600  1.00  0.00           C  
ATOM    197  O   GLN A  14     -15.338  -2.377   5.524  1.00  0.00           O  
ATOM    198  CB  GLN A  14     -18.260  -3.389   6.726  1.00  0.00           C  
ATOM    199  CG  GLN A  14     -19.237  -4.543   6.570  1.00  0.00           C  
ATOM    200  CD  GLN A  14     -20.277  -4.282   5.501  1.00  0.00           C  
ATOM    201  OE1 GLN A  14     -19.972  -4.281   4.306  1.00  0.00           O  
ATOM    202  NE2 GLN A  14     -21.510  -4.055   5.922  1.00  0.00           N  
ATOM    203  H   GLN A  14     -17.150  -4.461   8.764  1.00  0.00           H  
ATOM    204  HA  GLN A  14     -16.607  -4.513   5.959  1.00  0.00           H  
ATOM    205  HB2 GLN A  14     -18.495  -2.866   7.640  1.00  0.00           H  
ATOM    206  HB3 GLN A  14     -18.395  -2.716   5.892  1.00  0.00           H  
ATOM    207  HG2 GLN A  14     -18.686  -5.432   6.307  1.00  0.00           H  
ATOM    208  HG3 GLN A  14     -19.743  -4.697   7.511  1.00  0.00           H  
ATOM    209 HE21 GLN A  14     -21.678  -4.068   6.888  1.00  0.00           H  
ATOM    210 HE22 GLN A  14     -22.211  -3.890   5.247  1.00  0.00           H  
ATOM    211  N   VAL A  15     -15.844  -1.772   7.629  1.00  0.00           N  
ATOM    212  CA  VAL A  15     -15.135  -0.498   7.555  1.00  0.00           C  
ATOM    213  C   VAL A  15     -13.624  -0.685   7.373  1.00  0.00           C  
ATOM    214  O   VAL A  15     -12.980   0.095   6.665  1.00  0.00           O  
ATOM    215  CB  VAL A  15     -15.430   0.367   8.806  1.00  0.00           C  
ATOM    216  CG1 VAL A  15     -14.253   1.260   9.173  1.00  0.00           C  
ATOM    217  CG2 VAL A  15     -16.679   1.207   8.580  1.00  0.00           C  
ATOM    218  H   VAL A  15     -16.395  -1.967   8.422  1.00  0.00           H  
ATOM    219  HA  VAL A  15     -15.516   0.030   6.692  1.00  0.00           H  
ATOM    220  HB  VAL A  15     -15.619  -0.294   9.637  1.00  0.00           H  
ATOM    221 HG11 VAL A  15     -13.561   1.297   8.344  1.00  0.00           H  
ATOM    222 HG12 VAL A  15     -14.609   2.255   9.390  1.00  0.00           H  
ATOM    223 HG13 VAL A  15     -13.754   0.856  10.041  1.00  0.00           H  
ATOM    224 HG21 VAL A  15     -16.593   1.736   7.641  1.00  0.00           H  
ATOM    225 HG22 VAL A  15     -17.544   0.562   8.550  1.00  0.00           H  
ATOM    226 HG23 VAL A  15     -16.786   1.916   9.385  1.00  0.00           H  
ATOM    227  N   LYS A  16     -13.056  -1.686   8.039  1.00  0.00           N  
ATOM    228  CA  LYS A  16     -11.616  -1.920   7.972  1.00  0.00           C  
ATOM    229  C   LYS A  16     -11.198  -2.419   6.593  1.00  0.00           C  
ATOM    230  O   LYS A  16     -10.109  -2.102   6.114  1.00  0.00           O  
ATOM    231  CB  LYS A  16     -11.184  -2.917   9.046  1.00  0.00           C  
ATOM    232  CG  LYS A  16     -10.684  -2.249  10.317  1.00  0.00           C  
ATOM    233  CD  LYS A  16      -9.815  -3.189  11.133  1.00  0.00           C  
ATOM    234  CE  LYS A  16      -8.351  -2.787  11.068  1.00  0.00           C  
ATOM    235  NZ  LYS A  16      -7.454  -3.971  11.022  1.00  0.00           N  
ATOM    236  H   LYS A  16     -13.610  -2.260   8.613  1.00  0.00           H  
ATOM    237  HA  LYS A  16     -11.126  -0.975   8.157  1.00  0.00           H  
ATOM    238  HB2 LYS A  16     -12.026  -3.543   9.300  1.00  0.00           H  
ATOM    239  HB3 LYS A  16     -10.390  -3.534   8.652  1.00  0.00           H  
ATOM    240  HG2 LYS A  16     -10.106  -1.377  10.050  1.00  0.00           H  
ATOM    241  HG3 LYS A  16     -11.536  -1.951  10.913  1.00  0.00           H  
ATOM    242  HD2 LYS A  16     -10.138  -3.162  12.162  1.00  0.00           H  
ATOM    243  HD3 LYS A  16      -9.921  -4.191  10.745  1.00  0.00           H  
ATOM    244  HE2 LYS A  16      -8.194  -2.191  10.181  1.00  0.00           H  
ATOM    245  HE3 LYS A  16      -8.115  -2.200  11.943  1.00  0.00           H  
ATOM    246  HZ1 LYS A  16      -7.623  -4.583  11.852  1.00  0.00           H  
ATOM    247  HZ2 LYS A  16      -7.632  -4.521  10.154  1.00  0.00           H  
ATOM    248  HZ3 LYS A  16      -6.457  -3.668  11.021  1.00  0.00           H  
ATOM    249  N   ALA A  17     -12.084  -3.174   5.950  1.00  0.00           N  
ATOM    250  CA  ALA A  17     -11.825  -3.697   4.612  1.00  0.00           C  
ATOM    251  C   ALA A  17     -11.599  -2.570   3.607  1.00  0.00           C  
ATOM    252  O   ALA A  17     -10.938  -2.755   2.586  1.00  0.00           O  
ATOM    253  CB  ALA A  17     -12.975  -4.587   4.163  1.00  0.00           C  
ATOM    254  H   ALA A  17     -12.944  -3.371   6.378  1.00  0.00           H  
ATOM    255  HA  ALA A  17     -10.932  -4.305   4.662  1.00  0.00           H  
ATOM    256  HB1 ALA A  17     -13.907  -4.193   4.545  1.00  0.00           H  
ATOM    257  HB2 ALA A  17     -13.009  -4.613   3.083  1.00  0.00           H  
ATOM    258  HB3 ALA A  17     -12.824  -5.587   4.542  1.00  0.00           H  
ATOM    259  N   ALA A  18     -12.168  -1.406   3.895  1.00  0.00           N  
ATOM    260  CA  ALA A  18     -12.053  -0.253   3.013  1.00  0.00           C  
ATOM    261  C   ALA A  18     -10.621   0.283   2.948  1.00  0.00           C  
ATOM    262  O   ALA A  18     -10.142   0.641   1.874  1.00  0.00           O  
ATOM    263  CB  ALA A  18     -13.009   0.844   3.458  1.00  0.00           C  
ATOM    264  H   ALA A  18     -12.694  -1.328   4.719  1.00  0.00           H  
ATOM    265  HA  ALA A  18     -12.350  -0.565   2.024  1.00  0.00           H  
ATOM    266  HB1 ALA A  18     -13.916   0.398   3.837  1.00  0.00           H  
ATOM    267  HB2 ALA A  18     -12.544   1.434   4.237  1.00  0.00           H  
ATOM    268  HB3 ALA A  18     -13.245   1.480   2.618  1.00  0.00           H  
ATOM    269  N   LYS A  19      -9.907   0.239   4.067  1.00  0.00           N  
ATOM    270  CA  LYS A  19      -8.496   0.615   4.094  1.00  0.00           C  
ATOM    271  C   LYS A  19      -7.620  -0.507   3.533  1.00  0.00           C  
ATOM    272  O   LYS A  19      -6.486  -0.283   3.114  1.00  0.00           O  
ATOM    273  CB  LYS A  19      -8.069   1.005   5.517  1.00  0.00           C  
ATOM    274  CG  LYS A  19      -7.465  -0.123   6.340  1.00  0.00           C  
ATOM    275  CD  LYS A  19      -6.876   0.399   7.640  1.00  0.00           C  
ATOM    276  CE  LYS A  19      -6.003  -0.646   8.313  1.00  0.00           C  
ATOM    277  NZ  LYS A  19      -4.570  -0.248   8.340  1.00  0.00           N  
ATOM    278  H   LYS A  19     -10.289  -0.152   4.883  1.00  0.00           H  
ATOM    279  HA  LYS A  19      -8.381   1.480   3.454  1.00  0.00           H  
ATOM    280  HB2 LYS A  19      -7.339   1.797   5.453  1.00  0.00           H  
ATOM    281  HB3 LYS A  19      -8.935   1.376   6.045  1.00  0.00           H  
ATOM    282  HG2 LYS A  19      -8.236  -0.842   6.570  1.00  0.00           H  
ATOM    283  HG3 LYS A  19      -6.683  -0.599   5.766  1.00  0.00           H  
ATOM    284  HD2 LYS A  19      -6.277   1.273   7.429  1.00  0.00           H  
ATOM    285  HD3 LYS A  19      -7.683   0.664   8.308  1.00  0.00           H  
ATOM    286  HE2 LYS A  19      -6.349  -0.785   9.325  1.00  0.00           H  
ATOM    287  HE3 LYS A  19      -6.098  -1.576   7.769  1.00  0.00           H  
ATOM    288  HZ1 LYS A  19      -4.474   0.789   8.252  1.00  0.00           H  
ATOM    289  HZ2 LYS A  19      -4.134  -0.547   9.240  1.00  0.00           H  
ATOM    290  HZ3 LYS A  19      -4.058  -0.702   7.556  1.00  0.00           H  
ATOM    291  N   ALA A  20      -8.159  -1.717   3.564  1.00  0.00           N  
ATOM    292  CA  ALA A  20      -7.438  -2.897   3.102  1.00  0.00           C  
ATOM    293  C   ALA A  20      -7.462  -3.009   1.581  1.00  0.00           C  
ATOM    294  O   ALA A  20      -6.709  -3.787   0.991  1.00  0.00           O  
ATOM    295  CB  ALA A  20      -8.020  -4.152   3.737  1.00  0.00           C  
ATOM    296  H   ALA A  20      -9.074  -1.801   3.908  1.00  0.00           H  
ATOM    297  HA  ALA A  20      -6.411  -2.805   3.427  1.00  0.00           H  
ATOM    298  HB1 ALA A  20      -9.073  -4.004   3.925  1.00  0.00           H  
ATOM    299  HB2 ALA A  20      -7.888  -4.989   3.066  1.00  0.00           H  
ATOM    300  HB3 ALA A  20      -7.513  -4.352   4.667  1.00  0.00           H  
ATOM    301  N   ASP A  21      -8.407  -2.314   0.961  1.00  0.00           N  
ATOM    302  CA  ASP A  21      -8.628  -2.414  -0.480  1.00  0.00           C  
ATOM    303  C   ASP A  21      -7.414  -1.943  -1.284  1.00  0.00           C  
ATOM    304  O   ASP A  21      -7.176  -2.419  -2.393  1.00  0.00           O  
ATOM    305  CB  ASP A  21      -9.856  -1.588  -0.872  1.00  0.00           C  
ATOM    306  CG  ASP A  21     -10.484  -2.043  -2.177  1.00  0.00           C  
ATOM    307  OD1 ASP A  21     -10.652  -3.264  -2.370  1.00  0.00           O  
ATOM    308  OD2 ASP A  21     -10.829  -1.175  -3.013  1.00  0.00           O  
ATOM    309  H   ASP A  21      -9.034  -1.785   1.497  1.00  0.00           H  
ATOM    310  HA  ASP A  21      -8.817  -3.451  -0.715  1.00  0.00           H  
ATOM    311  HB2 ASP A  21     -10.598  -1.670  -0.093  1.00  0.00           H  
ATOM    312  HB3 ASP A  21      -9.565  -0.555  -0.978  1.00  0.00           H  
ATOM    313  N   MET A  22      -6.704  -0.950  -0.765  1.00  0.00           N  
ATOM    314  CA  MET A  22      -5.588  -0.356  -1.497  1.00  0.00           C  
ATOM    315  C   MET A  22      -4.254  -0.551  -0.776  1.00  0.00           C  
ATOM    316  O   MET A  22      -4.173  -1.242   0.241  1.00  0.00           O  
ATOM    317  CB  MET A  22      -5.842   1.137  -1.717  1.00  0.00           C  
ATOM    318  CG  MET A  22      -6.107   1.907  -0.433  1.00  0.00           C  
ATOM    319  SD  MET A  22      -7.139   3.361  -0.698  1.00  0.00           S  
ATOM    320  CE  MET A  22      -5.989   4.429  -1.558  1.00  0.00           C  
ATOM    321  H   MET A  22      -6.977  -0.568   0.095  1.00  0.00           H  
ATOM    322  HA  MET A  22      -5.534  -0.842  -2.460  1.00  0.00           H  
ATOM    323  HB2 MET A  22      -4.978   1.569  -2.200  1.00  0.00           H  
ATOM    324  HB3 MET A  22      -6.700   1.252  -2.364  1.00  0.00           H  
ATOM    325  HG2 MET A  22      -6.604   1.252   0.266  1.00  0.00           H  
ATOM    326  HG3 MET A  22      -5.161   2.225  -0.017  1.00  0.00           H  
ATOM    327  HE1 MET A  22      -5.191   3.835  -1.979  1.00  0.00           H  
ATOM    328  HE2 MET A  22      -6.506   4.951  -2.349  1.00  0.00           H  
ATOM    329  HE3 MET A  22      -5.576   5.146  -0.864  1.00  0.00           H  
ATOM    330  N   VAL A  23      -3.214   0.093  -1.302  1.00  0.00           N  
ATOM    331  CA  VAL A  23      -1.885   0.033  -0.707  1.00  0.00           C  
ATOM    332  C   VAL A  23      -1.793   0.987   0.476  1.00  0.00           C  
ATOM    333  O   VAL A  23      -1.878   2.203   0.313  1.00  0.00           O  
ATOM    334  CB  VAL A  23      -0.782   0.399  -1.724  1.00  0.00           C  
ATOM    335  CG1 VAL A  23       0.600   0.209  -1.115  1.00  0.00           C  
ATOM    336  CG2 VAL A  23      -0.923  -0.419  -2.996  1.00  0.00           C  
ATOM    337  H   VAL A  23      -3.348   0.645  -2.099  1.00  0.00           H  
ATOM    338  HA  VAL A  23      -1.716  -0.978  -0.362  1.00  0.00           H  
ATOM    339  HB  VAL A  23      -0.893   1.442  -1.981  1.00  0.00           H  
ATOM    340 HG11 VAL A  23       0.519  -0.383  -0.218  1.00  0.00           H  
ATOM    341 HG12 VAL A  23       1.240  -0.294  -1.825  1.00  0.00           H  
ATOM    342 HG13 VAL A  23       1.021   1.175  -0.873  1.00  0.00           H  
ATOM    343 HG21 VAL A  23      -1.549  -1.278  -2.806  1.00  0.00           H  
ATOM    344 HG22 VAL A  23      -1.371   0.190  -3.768  1.00  0.00           H  
ATOM    345 HG23 VAL A  23       0.052  -0.748  -3.321  1.00  0.00           H  
ATOM    346  N   MET A  24      -1.654   0.432   1.664  1.00  0.00           N  
ATOM    347  CA  MET A  24      -1.586   1.237   2.870  1.00  0.00           C  
ATOM    348  C   MET A  24      -0.151   1.657   3.149  1.00  0.00           C  
ATOM    349  O   MET A  24       0.740   0.819   3.293  1.00  0.00           O  
ATOM    350  CB  MET A  24      -2.149   0.469   4.063  1.00  0.00           C  
ATOM    351  CG  MET A  24      -3.622   0.738   4.315  1.00  0.00           C  
ATOM    352  SD  MET A  24      -3.921   1.495   5.920  1.00  0.00           S  
ATOM    353  CE  MET A  24      -4.527   3.107   5.430  1.00  0.00           C  
ATOM    354  H   MET A  24      -1.621  -0.548   1.730  1.00  0.00           H  
ATOM    355  HA  MET A  24      -2.183   2.122   2.709  1.00  0.00           H  
ATOM    356  HB2 MET A  24      -2.023  -0.588   3.889  1.00  0.00           H  
ATOM    357  HB3 MET A  24      -1.598   0.749   4.948  1.00  0.00           H  
ATOM    358  HG2 MET A  24      -3.989   1.400   3.545  1.00  0.00           H  
ATOM    359  HG3 MET A  24      -4.157  -0.198   4.270  1.00  0.00           H  
ATOM    360  HE1 MET A  24      -3.826   3.565   4.748  1.00  0.00           H  
ATOM    361  HE2 MET A  24      -5.486   2.997   4.942  1.00  0.00           H  
ATOM    362  HE3 MET A  24      -4.640   3.730   6.305  1.00  0.00           H  
ATOM    363  N   LEU A  25       0.067   2.956   3.200  1.00  0.00           N  
ATOM    364  CA  LEU A  25       1.378   3.520   3.440  1.00  0.00           C  
ATOM    365  C   LEU A  25       1.365   4.332   4.725  1.00  0.00           C  
ATOM    366  O   LEU A  25       0.364   4.367   5.442  1.00  0.00           O  
ATOM    367  CB  LEU A  25       1.795   4.414   2.267  1.00  0.00           C  
ATOM    368  CG  LEU A  25       2.848   3.823   1.325  1.00  0.00           C  
ATOM    369  CD1 LEU A  25       3.539   4.929   0.547  1.00  0.00           C  
ATOM    370  CD2 LEU A  25       3.869   3.001   2.100  1.00  0.00           C  
ATOM    371  H   LEU A  25      -0.684   3.578   3.059  1.00  0.00           H  
ATOM    372  HA  LEU A  25       2.084   2.711   3.540  1.00  0.00           H  
ATOM    373  HB2 LEU A  25       0.913   4.641   1.686  1.00  0.00           H  
ATOM    374  HB3 LEU A  25       2.187   5.339   2.670  1.00  0.00           H  
ATOM    375  HG  LEU A  25       2.360   3.170   0.616  1.00  0.00           H  
ATOM    376 HD11 LEU A  25       3.153   5.889   0.862  1.00  0.00           H  
ATOM    377 HD12 LEU A  25       4.601   4.890   0.734  1.00  0.00           H  
ATOM    378 HD13 LEU A  25       3.354   4.797  -0.509  1.00  0.00           H  
ATOM    379 HD21 LEU A  25       3.994   3.422   3.087  1.00  0.00           H  
ATOM    380 HD22 LEU A  25       3.522   1.982   2.184  1.00  0.00           H  
ATOM    381 HD23 LEU A  25       4.814   3.017   1.580  1.00  0.00           H  
ATOM    382  N   SER A  26       2.423   5.086   4.934  1.00  0.00           N  
ATOM    383  CA  SER A  26       2.490   6.019   6.041  1.00  0.00           C  
ATOM    384  C   SER A  26       2.844   7.398   5.508  1.00  0.00           C  
ATOM    385  O   SER A  26       3.542   7.503   4.504  1.00  0.00           O  
ATOM    386  CB  SER A  26       3.527   5.550   7.064  1.00  0.00           C  
ATOM    387  OG  SER A  26       4.135   4.334   6.651  1.00  0.00           O  
ATOM    388  H   SER A  26       3.134   5.094   4.260  1.00  0.00           H  
ATOM    389  HA  SER A  26       1.516   6.060   6.508  1.00  0.00           H  
ATOM    390  HB2 SER A  26       4.293   6.303   7.167  1.00  0.00           H  
ATOM    391  HB3 SER A  26       3.045   5.394   8.018  1.00  0.00           H  
ATOM    392  HG  SER A  26       5.000   4.530   6.250  1.00  0.00           H  
ATOM    393  N   PRO A  27       2.285   8.467   6.099  1.00  0.00           N  
ATOM    394  CA  PRO A  27       2.451   9.846   5.624  1.00  0.00           C  
ATOM    395  C   PRO A  27       3.898  10.228   5.294  1.00  0.00           C  
ATOM    396  O   PRO A  27       4.136  11.008   4.373  1.00  0.00           O  
ATOM    397  CB  PRO A  27       1.933  10.695   6.800  1.00  0.00           C  
ATOM    398  CG  PRO A  27       1.613   9.732   7.895  1.00  0.00           C  
ATOM    399  CD  PRO A  27       1.344   8.424   7.218  1.00  0.00           C  
ATOM    400  HA  PRO A  27       1.834  10.033   4.757  1.00  0.00           H  
ATOM    401  HB2 PRO A  27       2.701  11.392   7.104  1.00  0.00           H  
ATOM    402  HB3 PRO A  27       1.054  11.241   6.490  1.00  0.00           H  
ATOM    403  HG2 PRO A  27       2.457   9.642   8.563  1.00  0.00           H  
ATOM    404  HG3 PRO A  27       0.739  10.067   8.432  1.00  0.00           H  
ATOM    405  HD2 PRO A  27       1.554   7.602   7.878  1.00  0.00           H  
ATOM    406  HD3 PRO A  27       0.325   8.381   6.866  1.00  0.00           H  
ATOM    407  N   LYS A  28       4.866   9.632   5.984  1.00  0.00           N  
ATOM    408  CA  LYS A  28       6.275   9.881   5.684  1.00  0.00           C  
ATOM    409  C   LYS A  28       6.693   9.158   4.407  1.00  0.00           C  
ATOM    410  O   LYS A  28       7.344   9.737   3.537  1.00  0.00           O  
ATOM    411  CB  LYS A  28       7.161   9.439   6.853  1.00  0.00           C  
ATOM    412  CG  LYS A  28       6.614   9.827   8.218  1.00  0.00           C  
ATOM    413  CD  LYS A  28       7.724  10.241   9.174  1.00  0.00           C  
ATOM    414  CE  LYS A  28       8.367   9.039   9.855  1.00  0.00           C  
ATOM    415  NZ  LYS A  28       7.381   7.966  10.154  1.00  0.00           N  
ATOM    416  H   LYS A  28       4.640   8.963   6.660  1.00  0.00           H  
ATOM    417  HA  LYS A  28       6.397  10.944   5.535  1.00  0.00           H  
ATOM    418  HB2 LYS A  28       7.267   8.364   6.823  1.00  0.00           H  
ATOM    419  HB3 LYS A  28       8.137   9.890   6.739  1.00  0.00           H  
ATOM    420  HG2 LYS A  28       5.930  10.655   8.099  1.00  0.00           H  
ATOM    421  HG3 LYS A  28       6.088   8.980   8.637  1.00  0.00           H  
ATOM    422  HD2 LYS A  28       8.482  10.774   8.618  1.00  0.00           H  
ATOM    423  HD3 LYS A  28       7.308  10.893   9.929  1.00  0.00           H  
ATOM    424  HE2 LYS A  28       9.131   8.640   9.205  1.00  0.00           H  
ATOM    425  HE3 LYS A  28       8.820   9.367  10.779  1.00  0.00           H  
ATOM    426  HZ1 LYS A  28       6.520   8.375  10.586  1.00  0.00           H  
ATOM    427  HZ2 LYS A  28       7.114   7.467   9.279  1.00  0.00           H  
ATOM    428  HZ3 LYS A  28       7.792   7.276  10.821  1.00  0.00           H  
ATOM    429  N   ASP A  29       6.262   7.907   4.287  1.00  0.00           N  
ATOM    430  CA  ASP A  29       6.530   7.090   3.101  1.00  0.00           C  
ATOM    431  C   ASP A  29       5.814   7.664   1.890  1.00  0.00           C  
ATOM    432  O   ASP A  29       6.307   7.601   0.768  1.00  0.00           O  
ATOM    433  CB  ASP A  29       6.043   5.656   3.321  1.00  0.00           C  
ATOM    434  CG  ASP A  29       6.795   4.938   4.420  1.00  0.00           C  
ATOM    435  OD1 ASP A  29       6.428   5.107   5.602  1.00  0.00           O  
ATOM    436  OD2 ASP A  29       7.739   4.187   4.109  1.00  0.00           O  
ATOM    437  H   ASP A  29       5.711   7.530   5.002  1.00  0.00           H  
ATOM    438  HA  ASP A  29       7.594   7.085   2.921  1.00  0.00           H  
ATOM    439  HB2 ASP A  29       4.995   5.678   3.590  1.00  0.00           H  
ATOM    440  HB3 ASP A  29       6.156   5.096   2.401  1.00  0.00           H  
ATOM    441  N   ALA A  30       4.665   8.260   2.153  1.00  0.00           N  
ATOM    442  CA  ALA A  30       3.874   8.896   1.117  1.00  0.00           C  
ATOM    443  C   ALA A  30       4.522  10.196   0.665  1.00  0.00           C  
ATOM    444  O   ALA A  30       4.698  10.423  -0.525  1.00  0.00           O  
ATOM    445  CB  ALA A  30       2.459   9.147   1.610  1.00  0.00           C  
ATOM    446  H   ALA A  30       4.371   8.302   3.089  1.00  0.00           H  
ATOM    447  HA  ALA A  30       3.823   8.220   0.275  1.00  0.00           H  
ATOM    448  HB1 ALA A  30       2.178   8.376   2.310  1.00  0.00           H  
ATOM    449  HB2 ALA A  30       2.412  10.110   2.096  1.00  0.00           H  
ATOM    450  HB3 ALA A  30       1.780   9.135   0.769  1.00  0.00           H  
ATOM    451  N   TYR A  31       4.915  11.030   1.622  1.00  0.00           N  
ATOM    452  CA  TYR A  31       5.575  12.291   1.303  1.00  0.00           C  
ATOM    453  C   TYR A  31       6.905  12.044   0.595  1.00  0.00           C  
ATOM    454  O   TYR A  31       7.315  12.830  -0.257  1.00  0.00           O  
ATOM    455  CB  TYR A  31       5.795  13.121   2.572  1.00  0.00           C  
ATOM    456  CG  TYR A  31       6.560  14.403   2.331  1.00  0.00           C  
ATOM    457  CD1 TYR A  31       5.963  15.474   1.681  1.00  0.00           C  
ATOM    458  CD2 TYR A  31       7.881  14.537   2.740  1.00  0.00           C  
ATOM    459  CE1 TYR A  31       6.656  16.644   1.447  1.00  0.00           C  
ATOM    460  CE2 TYR A  31       8.584  15.703   2.507  1.00  0.00           C  
ATOM    461  CZ  TYR A  31       7.969  16.753   1.859  1.00  0.00           C  
ATOM    462  OH  TYR A  31       8.671  17.912   1.621  1.00  0.00           O  
ATOM    463  H   TYR A  31       4.784  10.784   2.565  1.00  0.00           H  
ATOM    464  HA  TYR A  31       4.926  12.840   0.636  1.00  0.00           H  
ATOM    465  HB2 TYR A  31       4.837  13.385   2.992  1.00  0.00           H  
ATOM    466  HB3 TYR A  31       6.345  12.533   3.290  1.00  0.00           H  
ATOM    467  HD1 TYR A  31       4.937  15.385   1.362  1.00  0.00           H  
ATOM    468  HD2 TYR A  31       8.361  13.712   3.248  1.00  0.00           H  
ATOM    469  HE1 TYR A  31       6.168  17.466   0.942  1.00  0.00           H  
ATOM    470  HE2 TYR A  31       9.609  15.788   2.833  1.00  0.00           H  
ATOM    471  HH  TYR A  31       8.246  18.652   2.079  1.00  0.00           H  
ATOM    472  N   LYS A  32       7.569  10.953   0.961  1.00  0.00           N  
ATOM    473  CA  LYS A  32       8.854  10.592   0.377  1.00  0.00           C  
ATOM    474  C   LYS A  32       8.772  10.535  -1.148  1.00  0.00           C  
ATOM    475  O   LYS A  32       9.562  11.173  -1.847  1.00  0.00           O  
ATOM    476  CB  LYS A  32       9.318   9.242   0.928  1.00  0.00           C  
ATOM    477  CG  LYS A  32      10.828   9.070   0.930  1.00  0.00           C  
ATOM    478  CD  LYS A  32      11.501  10.035   1.892  1.00  0.00           C  
ATOM    479  CE  LYS A  32      12.661  10.762   1.229  1.00  0.00           C  
ATOM    480  NZ  LYS A  32      13.380  11.650   2.179  1.00  0.00           N  
ATOM    481  H   LYS A  32       7.181  10.373   1.654  1.00  0.00           H  
ATOM    482  HA  LYS A  32       9.570  11.349   0.658  1.00  0.00           H  
ATOM    483  HB2 LYS A  32       8.964   9.142   1.944  1.00  0.00           H  
ATOM    484  HB3 LYS A  32       8.887   8.455   0.328  1.00  0.00           H  
ATOM    485  HG2 LYS A  32      11.064   8.059   1.227  1.00  0.00           H  
ATOM    486  HG3 LYS A  32      11.201   9.249  -0.068  1.00  0.00           H  
ATOM    487  HD2 LYS A  32      10.776  10.762   2.224  1.00  0.00           H  
ATOM    488  HD3 LYS A  32      11.873   9.480   2.742  1.00  0.00           H  
ATOM    489  HE2 LYS A  32      13.353  10.030   0.844  1.00  0.00           H  
ATOM    490  HE3 LYS A  32      12.276  11.358   0.414  1.00  0.00           H  
ATOM    491  HZ1 LYS A  32      13.685  11.112   3.018  1.00  0.00           H  
ATOM    492  HZ2 LYS A  32      14.224  12.055   1.719  1.00  0.00           H  
ATOM    493  HZ3 LYS A  32      12.757  12.428   2.486  1.00  0.00           H  
ATOM    494  N   LEU A  33       7.807   9.783  -1.659  1.00  0.00           N  
ATOM    495  CA  LEU A  33       7.623   9.653  -3.100  1.00  0.00           C  
ATOM    496  C   LEU A  33       7.011  10.920  -3.700  1.00  0.00           C  
ATOM    497  O   LEU A  33       7.232  11.221  -4.870  1.00  0.00           O  
ATOM    498  CB  LEU A  33       6.762   8.431  -3.449  1.00  0.00           C  
ATOM    499  CG  LEU A  33       5.697   8.043  -2.425  1.00  0.00           C  
ATOM    500  CD1 LEU A  33       4.320   8.489  -2.895  1.00  0.00           C  
ATOM    501  CD2 LEU A  33       5.718   6.538  -2.189  1.00  0.00           C  
ATOM    502  H   LEU A  33       7.202   9.305  -1.051  1.00  0.00           H  
ATOM    503  HA  LEU A  33       8.602   9.517  -3.534  1.00  0.00           H  
ATOM    504  HB2 LEU A  33       6.264   8.628  -4.387  1.00  0.00           H  
ATOM    505  HB3 LEU A  33       7.419   7.585  -3.585  1.00  0.00           H  
ATOM    506  HG  LEU A  33       5.909   8.535  -1.486  1.00  0.00           H  
ATOM    507 HD11 LEU A  33       4.409   9.437  -3.409  1.00  0.00           H  
ATOM    508 HD12 LEU A  33       3.911   7.753  -3.571  1.00  0.00           H  
ATOM    509 HD13 LEU A  33       3.666   8.601  -2.042  1.00  0.00           H  
ATOM    510 HD21 LEU A  33       6.001   6.034  -3.101  1.00  0.00           H  
ATOM    511 HD22 LEU A  33       6.433   6.305  -1.414  1.00  0.00           H  
ATOM    512 HD23 LEU A  33       4.736   6.207  -1.884  1.00  0.00           H  
ATOM    513  N   LEU A  34       6.270  11.665  -2.886  1.00  0.00           N  
ATOM    514  CA  LEU A  34       5.648  12.912  -3.335  1.00  0.00           C  
ATOM    515  C   LEU A  34       6.699  13.962  -3.678  1.00  0.00           C  
ATOM    516  O   LEU A  34       6.594  14.657  -4.688  1.00  0.00           O  
ATOM    517  CB  LEU A  34       4.728  13.481  -2.251  1.00  0.00           C  
ATOM    518  CG  LEU A  34       3.480  12.657  -1.935  1.00  0.00           C  
ATOM    519  CD1 LEU A  34       2.758  13.233  -0.726  1.00  0.00           C  
ATOM    520  CD2 LEU A  34       2.558  12.601  -3.137  1.00  0.00           C  
ATOM    521  H   LEU A  34       6.161  11.382  -1.954  1.00  0.00           H  
ATOM    522  HA  LEU A  34       5.064  12.696  -4.216  1.00  0.00           H  
ATOM    523  HB2 LEU A  34       5.302  13.582  -1.342  1.00  0.00           H  
ATOM    524  HB3 LEU A  34       4.410  14.463  -2.563  1.00  0.00           H  
ATOM    525  HG  LEU A  34       3.778  11.646  -1.694  1.00  0.00           H  
ATOM    526 HD11 LEU A  34       3.457  13.352   0.089  1.00  0.00           H  
ATOM    527 HD12 LEU A  34       2.336  14.195  -0.981  1.00  0.00           H  
ATOM    528 HD13 LEU A  34       1.966  12.561  -0.426  1.00  0.00           H  
ATOM    529 HD21 LEU A  34       3.143  12.655  -4.044  1.00  0.00           H  
ATOM    530 HD22 LEU A  34       2.004  11.673  -3.125  1.00  0.00           H  
ATOM    531 HD23 LEU A  34       1.868  13.430  -3.103  1.00  0.00           H  
ATOM    532  N   GLN A  35       7.648  14.148  -2.770  1.00  0.00           N  
ATOM    533  CA  GLN A  35       8.643  15.201  -2.910  1.00  0.00           C  
ATOM    534  C   GLN A  35       9.702  14.843  -3.946  1.00  0.00           C  
ATOM    535  O   GLN A  35      10.317  15.726  -4.540  1.00  0.00           O  
ATOM    536  CB  GLN A  35       9.305  15.494  -1.559  1.00  0.00           C  
ATOM    537  CG  GLN A  35       9.954  14.279  -0.913  1.00  0.00           C  
ATOM    538  CD  GLN A  35      11.273  14.607  -0.251  1.00  0.00           C  
ATOM    539  OE1 GLN A  35      11.313  15.186   0.834  1.00  0.00           O  
ATOM    540  NE2 GLN A  35      12.365  14.235  -0.896  1.00  0.00           N  
ATOM    541  H   GLN A  35       7.630  13.612  -1.945  1.00  0.00           H  
ATOM    542  HA  GLN A  35       8.131  16.091  -3.241  1.00  0.00           H  
ATOM    543  HB2 GLN A  35      10.066  16.247  -1.702  1.00  0.00           H  
ATOM    544  HB3 GLN A  35       8.557  15.877  -0.883  1.00  0.00           H  
ATOM    545  HG2 GLN A  35       9.283  13.884  -0.165  1.00  0.00           H  
ATOM    546  HG3 GLN A  35      10.125  13.531  -1.672  1.00  0.00           H  
ATOM    547 HE21 GLN A  35      12.263  13.775  -1.756  1.00  0.00           H  
ATOM    548 HE22 GLN A  35      13.237  14.435  -0.487  1.00  0.00           H  
ATOM    549  N   GLU A  36       9.953  13.552  -4.124  1.00  0.00           N  
ATOM    550  CA  GLU A  36      10.985  13.106  -5.043  1.00  0.00           C  
ATOM    551  C   GLU A  36      10.427  12.982  -6.453  1.00  0.00           C  
ATOM    552  O   GLU A  36      11.102  13.295  -7.435  1.00  0.00           O  
ATOM    553  CB  GLU A  36      11.552  11.765  -4.574  1.00  0.00           C  
ATOM    554  CG  GLU A  36      12.495  11.109  -5.569  1.00  0.00           C  
ATOM    555  CD  GLU A  36      12.484   9.599  -5.475  1.00  0.00           C  
ATOM    556  OE1 GLU A  36      11.499   9.035  -4.957  1.00  0.00           O  
ATOM    557  OE2 GLU A  36      13.463   8.966  -5.919  1.00  0.00           O  
ATOM    558  H   GLU A  36       9.466  12.882  -3.601  1.00  0.00           H  
ATOM    559  HA  GLU A  36      11.774  13.843  -5.043  1.00  0.00           H  
ATOM    560  HB2 GLU A  36      12.092  11.919  -3.651  1.00  0.00           H  
ATOM    561  HB3 GLU A  36      10.729  11.089  -4.391  1.00  0.00           H  
ATOM    562  HG2 GLU A  36      12.199  11.395  -6.569  1.00  0.00           H  
ATOM    563  HG3 GLU A  36      13.499  11.458  -5.379  1.00  0.00           H  
ATOM    564  N   ASN A  37       9.187  12.537  -6.542  1.00  0.00           N  
ATOM    565  CA  ASN A  37       8.524  12.381  -7.824  1.00  0.00           C  
ATOM    566  C   ASN A  37       7.327  13.316  -7.901  1.00  0.00           C  
ATOM    567  O   ASN A  37       6.257  13.014  -7.372  1.00  0.00           O  
ATOM    568  CB  ASN A  37       8.064  10.932  -8.036  1.00  0.00           C  
ATOM    569  CG  ASN A  37       9.080   9.905  -7.573  1.00  0.00           C  
ATOM    570  OD1 ASN A  37       9.881   9.403  -8.362  1.00  0.00           O  
ATOM    571  ND2 ASN A  37       9.043   9.574  -6.293  1.00  0.00           N  
ATOM    572  H   ASN A  37       8.695  12.317  -5.722  1.00  0.00           H  
ATOM    573  HA  ASN A  37       9.227  12.646  -8.599  1.00  0.00           H  
ATOM    574  HB2 ASN A  37       7.145  10.769  -7.491  1.00  0.00           H  
ATOM    575  HB3 ASN A  37       7.881  10.778  -9.086  1.00  0.00           H  
ATOM    576 HD21 ASN A  37       8.364  10.002  -5.723  1.00  0.00           H  
ATOM    577 HD22 ASN A  37       9.707   8.931  -5.956  1.00  0.00           H  
ATOM    578  N   PRO A  38       7.501  14.486  -8.533  1.00  0.00           N  
ATOM    579  CA  PRO A  38       6.443  15.497  -8.644  1.00  0.00           C  
ATOM    580  C   PRO A  38       5.273  15.041  -9.518  1.00  0.00           C  
ATOM    581  O   PRO A  38       4.301  15.773  -9.705  1.00  0.00           O  
ATOM    582  CB  PRO A  38       7.153  16.699  -9.277  1.00  0.00           C  
ATOM    583  CG  PRO A  38       8.341  16.126  -9.965  1.00  0.00           C  
ATOM    584  CD  PRO A  38       8.758  14.933  -9.156  1.00  0.00           C  
ATOM    585  HA  PRO A  38       6.068  15.775  -7.670  1.00  0.00           H  
ATOM    586  HB2 PRO A  38       6.488  17.187  -9.975  1.00  0.00           H  
ATOM    587  HB3 PRO A  38       7.444  17.395  -8.503  1.00  0.00           H  
ATOM    588  HG2 PRO A  38       8.072  15.824 -10.967  1.00  0.00           H  
ATOM    589  HG3 PRO A  38       9.134  16.856  -9.994  1.00  0.00           H  
ATOM    590  HD2 PRO A  38       9.165  14.165  -9.797  1.00  0.00           H  
ATOM    591  HD3 PRO A  38       9.479  15.219  -8.405  1.00  0.00           H  
ATOM    592  N   ASP A  39       5.335  13.800  -9.979  1.00  0.00           N  
ATOM    593  CA  ASP A  39       4.256  13.207 -10.753  1.00  0.00           C  
ATOM    594  C   ASP A  39       3.280  12.484  -9.829  1.00  0.00           C  
ATOM    595  O   ASP A  39       2.076  12.439 -10.089  1.00  0.00           O  
ATOM    596  CB  ASP A  39       4.827  12.240 -11.791  1.00  0.00           C  
ATOM    597  CG  ASP A  39       3.773  11.686 -12.731  1.00  0.00           C  
ATOM    598  OD1 ASP A  39       3.245  12.456 -13.562  1.00  0.00           O  
ATOM    599  OD2 ASP A  39       3.486  10.472 -12.657  1.00  0.00           O  
ATOM    600  H   ASP A  39       6.106  13.246  -9.742  1.00  0.00           H  
ATOM    601  HA  ASP A  39       3.734  14.003 -11.256  1.00  0.00           H  
ATOM    602  HB2 ASP A  39       5.568  12.757 -12.382  1.00  0.00           H  
ATOM    603  HB3 ASP A  39       5.298  11.411 -11.280  1.00  0.00           H  
ATOM    604  N   ILE A  40       3.795  12.015  -8.699  1.00  0.00           N  
ATOM    605  CA  ILE A  40       2.961  11.399  -7.680  1.00  0.00           C  
ATOM    606  C   ILE A  40       2.315  12.475  -6.823  1.00  0.00           C  
ATOM    607  O   ILE A  40       2.995  13.200  -6.110  1.00  0.00           O  
ATOM    608  CB  ILE A  40       3.773  10.443  -6.780  1.00  0.00           C  
ATOM    609  CG1 ILE A  40       4.614   9.493  -7.638  1.00  0.00           C  
ATOM    610  CG2 ILE A  40       2.841   9.663  -5.864  1.00  0.00           C  
ATOM    611  CD1 ILE A  40       5.441   8.510  -6.835  1.00  0.00           C  
ATOM    612  H   ILE A  40       4.746  12.155  -8.511  1.00  0.00           H  
ATOM    613  HA  ILE A  40       2.187  10.830  -8.175  1.00  0.00           H  
ATOM    614  HB  ILE A  40       4.429  11.038  -6.163  1.00  0.00           H  
ATOM    615 HG12 ILE A  40       3.958   8.925  -8.279  1.00  0.00           H  
ATOM    616 HG13 ILE A  40       5.288  10.077  -8.247  1.00  0.00           H  
ATOM    617 HG21 ILE A  40       1.979   9.333  -6.424  1.00  0.00           H  
ATOM    618 HG22 ILE A  40       3.363   8.805  -5.469  1.00  0.00           H  
ATOM    619 HG23 ILE A  40       2.522  10.296  -5.050  1.00  0.00           H  
ATOM    620 HD11 ILE A  40       6.084   9.051  -6.154  1.00  0.00           H  
ATOM    621 HD12 ILE A  40       4.785   7.862  -6.273  1.00  0.00           H  
ATOM    622 HD13 ILE A  40       6.047   7.919  -7.507  1.00  0.00           H  
ATOM    623  N   THR A  41       1.013  12.632  -6.976  1.00  0.00           N  
ATOM    624  CA  THR A  41       0.278  13.692  -6.298  1.00  0.00           C  
ATOM    625  C   THR A  41      -0.428  13.178  -5.042  1.00  0.00           C  
ATOM    626  O   THR A  41      -0.993  12.084  -5.046  1.00  0.00           O  
ATOM    627  CB  THR A  41      -0.765  14.311  -7.249  1.00  0.00           C  
ATOM    628  OG1 THR A  41      -0.646  13.726  -8.555  1.00  0.00           O  
ATOM    629  CG2 THR A  41      -0.582  15.814  -7.355  1.00  0.00           C  
ATOM    630  H   THR A  41       0.540  12.057  -7.614  1.00  0.00           H  
ATOM    631  HA  THR A  41       0.981  14.463  -6.018  1.00  0.00           H  
ATOM    632  HB  THR A  41      -1.753  14.110  -6.859  1.00  0.00           H  
ATOM    633  HG1 THR A  41       0.277  13.495  -8.721  1.00  0.00           H  
ATOM    634 HG21 THR A  41      -0.416  16.225  -6.370  1.00  0.00           H  
ATOM    635 HG22 THR A  41       0.269  16.029  -7.983  1.00  0.00           H  
ATOM    636 HG23 THR A  41      -1.467  16.255  -7.786  1.00  0.00           H  
ATOM    637  N   LEU A  42      -0.515  14.017  -4.013  1.00  0.00           N  
ATOM    638  CA  LEU A  42      -1.298  13.675  -2.833  1.00  0.00           C  
ATOM    639  C   LEU A  42      -2.631  14.400  -2.889  1.00  0.00           C  
ATOM    640  O   LEU A  42      -2.686  15.612  -3.118  1.00  0.00           O  
ATOM    641  CB  LEU A  42      -0.562  14.029  -1.526  1.00  0.00           C  
ATOM    642  CG  LEU A  42      -1.463  14.268  -0.308  1.00  0.00           C  
ATOM    643  CD1 LEU A  42      -1.842  12.949   0.346  1.00  0.00           C  
ATOM    644  CD2 LEU A  42      -0.778  15.173   0.701  1.00  0.00           C  
ATOM    645  H   LEU A  42      -0.141  14.923  -4.085  1.00  0.00           H  
ATOM    646  HA  LEU A  42      -1.483  12.610  -2.857  1.00  0.00           H  
ATOM    647  HB2 LEU A  42       0.109  13.216  -1.284  1.00  0.00           H  
ATOM    648  HB3 LEU A  42       0.022  14.919  -1.695  1.00  0.00           H  
ATOM    649  HG  LEU A  42      -2.373  14.754  -0.629  1.00  0.00           H  
ATOM    650 HD11 LEU A  42      -2.197  12.261  -0.407  1.00  0.00           H  
ATOM    651 HD12 LEU A  42      -0.979  12.527   0.840  1.00  0.00           H  
ATOM    652 HD13 LEU A  42      -2.623  13.119   1.073  1.00  0.00           H  
ATOM    653 HD21 LEU A  42      -0.468  16.086   0.216  1.00  0.00           H  
ATOM    654 HD22 LEU A  42      -1.469  15.406   1.500  1.00  0.00           H  
ATOM    655 HD23 LEU A  42       0.088  14.669   1.110  1.00  0.00           H  
ATOM    656  N   ILE A  43      -3.692  13.668  -2.626  1.00  0.00           N  
ATOM    657  CA  ILE A  43      -5.018  14.243  -2.579  1.00  0.00           C  
ATOM    658  C   ILE A  43      -5.544  14.191  -1.157  1.00  0.00           C  
ATOM    659  O   ILE A  43      -5.699  13.116  -0.575  1.00  0.00           O  
ATOM    660  CB  ILE A  43      -5.988  13.520  -3.537  1.00  0.00           C  
ATOM    661  CG1 ILE A  43      -5.601  13.824  -4.983  1.00  0.00           C  
ATOM    662  CG2 ILE A  43      -7.431  13.940  -3.274  1.00  0.00           C  
ATOM    663  CD1 ILE A  43      -6.342  12.985  -6.002  1.00  0.00           C  
ATOM    664  H   ILE A  43      -3.574  12.713  -2.406  1.00  0.00           H  
ATOM    665  HA  ILE A  43      -4.941  15.277  -2.887  1.00  0.00           H  
ATOM    666  HB  ILE A  43      -5.907  12.457  -3.364  1.00  0.00           H  
ATOM    667 HG12 ILE A  43      -5.809  14.864  -5.188  1.00  0.00           H  
ATOM    668 HG13 ILE A  43      -4.544  13.643  -5.109  1.00  0.00           H  
ATOM    669 HG21 ILE A  43      -7.445  14.799  -2.621  1.00  0.00           H  
ATOM    670 HG22 ILE A  43      -7.908  14.191  -4.210  1.00  0.00           H  
ATOM    671 HG23 ILE A  43      -7.963  13.124  -2.807  1.00  0.00           H  
ATOM    672 HD11 ILE A  43      -7.140  12.445  -5.512  1.00  0.00           H  
ATOM    673 HD12 ILE A  43      -6.757  13.628  -6.764  1.00  0.00           H  
ATOM    674 HD13 ILE A  43      -5.659  12.282  -6.457  1.00  0.00           H  
ATOM    675  N   ASP A  44      -5.783  15.357  -0.591  1.00  0.00           N  
ATOM    676  CA  ASP A  44      -6.261  15.446   0.774  1.00  0.00           C  
ATOM    677  C   ASP A  44      -7.762  15.658   0.776  1.00  0.00           C  
ATOM    678  O   ASP A  44      -8.296  16.459  -0.004  1.00  0.00           O  
ATOM    679  CB  ASP A  44      -5.545  16.579   1.521  1.00  0.00           C  
ATOM    680  CG  ASP A  44      -6.405  17.246   2.575  1.00  0.00           C  
ATOM    681  OD1 ASP A  44      -6.803  16.569   3.542  1.00  0.00           O  
ATOM    682  OD2 ASP A  44      -6.675  18.458   2.430  1.00  0.00           O  
ATOM    683  H   ASP A  44      -5.622  16.182  -1.097  1.00  0.00           H  
ATOM    684  HA  ASP A  44      -6.039  14.508   1.264  1.00  0.00           H  
ATOM    685  HB2 ASP A  44      -4.667  16.182   2.004  1.00  0.00           H  
ATOM    686  HB3 ASP A  44      -5.247  17.328   0.807  1.00  0.00           H  
ATOM    687  N   VAL A  45      -8.427  14.967   1.679  1.00  0.00           N  
ATOM    688  CA  VAL A  45      -9.857  15.101   1.842  1.00  0.00           C  
ATOM    689  C   VAL A  45     -10.175  15.423   3.289  1.00  0.00           C  
ATOM    690  O   VAL A  45     -10.246  14.532   4.130  1.00  0.00           O  
ATOM    691  CB  VAL A  45     -10.623  13.822   1.429  1.00  0.00           C  
ATOM    692  CG1 VAL A  45     -11.632  14.136   0.337  1.00  0.00           C  
ATOM    693  CG2 VAL A  45      -9.669  12.722   0.978  1.00  0.00           C  
ATOM    694  H   VAL A  45      -7.927  14.379   2.285  1.00  0.00           H  
ATOM    695  HA  VAL A  45     -10.192  15.917   1.217  1.00  0.00           H  
ATOM    696  HB  VAL A  45     -11.166  13.464   2.290  1.00  0.00           H  
ATOM    697 HG11 VAL A  45     -11.913  15.178   0.394  1.00  0.00           H  
ATOM    698 HG12 VAL A  45     -11.193  13.935  -0.628  1.00  0.00           H  
ATOM    699 HG13 VAL A  45     -12.510  13.520   0.470  1.00  0.00           H  
ATOM    700 HG21 VAL A  45      -9.085  13.072   0.139  1.00  0.00           H  
ATOM    701 HG22 VAL A  45      -9.006  12.465   1.792  1.00  0.00           H  
ATOM    702 HG23 VAL A  45     -10.235  11.851   0.685  1.00  0.00           H  
ATOM    703  N   ARG A  46     -10.391  16.696   3.562  1.00  0.00           N  
ATOM    704  CA  ARG A  46     -10.736  17.152   4.896  1.00  0.00           C  
ATOM    705  C   ARG A  46     -11.463  18.481   4.804  1.00  0.00           C  
ATOM    706  O   ARG A  46     -11.483  19.111   3.743  1.00  0.00           O  
ATOM    707  CB  ARG A  46      -9.490  17.296   5.777  1.00  0.00           C  
ATOM    708  CG  ARG A  46      -9.521  16.446   7.045  1.00  0.00           C  
ATOM    709  CD  ARG A  46     -10.871  16.502   7.747  1.00  0.00           C  
ATOM    710  NE  ARG A  46     -10.746  16.843   9.165  1.00  0.00           N  
ATOM    711  CZ  ARG A  46     -11.738  17.331   9.915  1.00  0.00           C  
ATOM    712  NH1 ARG A  46     -12.935  17.554   9.391  1.00  0.00           N  
ATOM    713  NH2 ARG A  46     -11.522  17.599  11.198  1.00  0.00           N  
ATOM    714  H   ARG A  46     -10.334  17.350   2.839  1.00  0.00           H  
ATOM    715  HA  ARG A  46     -11.399  16.421   5.337  1.00  0.00           H  
ATOM    716  HB2 ARG A  46      -8.622  17.011   5.202  1.00  0.00           H  
ATOM    717  HB3 ARG A  46      -9.392  18.331   6.069  1.00  0.00           H  
ATOM    718  HG2 ARG A  46      -9.312  15.419   6.781  1.00  0.00           H  
ATOM    719  HG3 ARG A  46      -8.758  16.804   7.722  1.00  0.00           H  
ATOM    720  HD2 ARG A  46     -11.485  17.247   7.260  1.00  0.00           H  
ATOM    721  HD3 ARG A  46     -11.348  15.536   7.661  1.00  0.00           H  
ATOM    722  HE  ARG A  46      -9.864  16.699   9.592  1.00  0.00           H  
ATOM    723 HH11 ARG A  46     -13.120  17.351   8.418  1.00  0.00           H  
ATOM    724 HH12 ARG A  46     -13.665  17.931   9.959  1.00  0.00           H  
ATOM    725 HH21 ARG A  46     -10.608  17.433  11.599  1.00  0.00           H  
ATOM    726 HH22 ARG A  46     -12.262  17.978  11.778  1.00  0.00           H  
ATOM    727  N   ASP A  47     -12.135  18.839   5.880  1.00  0.00           N  
ATOM    728  CA  ASP A  47     -12.976  20.021   5.914  1.00  0.00           C  
ATOM    729  C   ASP A  47     -12.144  21.284   6.138  1.00  0.00           C  
ATOM    730  O   ASP A  47     -10.969  21.208   6.508  1.00  0.00           O  
ATOM    731  CB  ASP A  47     -14.031  19.859   7.007  1.00  0.00           C  
ATOM    732  CG  ASP A  47     -14.829  18.577   6.848  1.00  0.00           C  
ATOM    733  OD1 ASP A  47     -14.272  17.489   7.123  1.00  0.00           O  
ATOM    734  OD2 ASP A  47     -16.018  18.655   6.468  1.00  0.00           O  
ATOM    735  H   ASP A  47     -12.133  18.244   6.655  1.00  0.00           H  
ATOM    736  HA  ASP A  47     -13.471  20.102   4.957  1.00  0.00           H  
ATOM    737  HB2 ASP A  47     -13.543  19.839   7.971  1.00  0.00           H  
ATOM    738  HB3 ASP A  47     -14.714  20.694   6.970  1.00  0.00           H  
ATOM    739  N   PRO A  48     -12.689  22.446   5.749  1.00  0.00           N  
ATOM    740  CA  PRO A  48     -11.939  23.706   5.723  1.00  0.00           C  
ATOM    741  C   PRO A  48     -11.633  24.298   7.099  1.00  0.00           C  
ATOM    742  O   PRO A  48     -10.722  25.113   7.222  1.00  0.00           O  
ATOM    743  CB  PRO A  48     -12.854  24.654   4.941  1.00  0.00           C  
ATOM    744  CG  PRO A  48     -14.216  24.074   5.079  1.00  0.00           C  
ATOM    745  CD  PRO A  48     -14.017  22.589   5.124  1.00  0.00           C  
ATOM    746  HA  PRO A  48     -11.012  23.592   5.182  1.00  0.00           H  
ATOM    747  HB2 PRO A  48     -12.803  25.643   5.373  1.00  0.00           H  
ATOM    748  HB3 PRO A  48     -12.544  24.688   3.908  1.00  0.00           H  
ATOM    749  HG2 PRO A  48     -14.674  24.420   5.995  1.00  0.00           H  
ATOM    750  HG3 PRO A  48     -14.822  24.345   4.228  1.00  0.00           H  
ATOM    751  HD2 PRO A  48     -14.781  22.124   5.730  1.00  0.00           H  
ATOM    752  HD3 PRO A  48     -14.020  22.176   4.126  1.00  0.00           H  
ATOM    753  N   ASP A  49     -12.407  23.950   8.120  1.00  0.00           N  
ATOM    754  CA  ASP A  49     -12.184  24.547   9.434  1.00  0.00           C  
ATOM    755  C   ASP A  49     -11.002  23.911  10.148  1.00  0.00           C  
ATOM    756  O   ASP A  49     -10.198  24.615  10.754  1.00  0.00           O  
ATOM    757  CB  ASP A  49     -13.421  24.487  10.324  1.00  0.00           C  
ATOM    758  CG  ASP A  49     -13.501  25.695  11.242  1.00  0.00           C  
ATOM    759  OD1 ASP A  49     -13.301  26.834  10.756  1.00  0.00           O  
ATOM    760  OD2 ASP A  49     -13.731  25.520  12.454  1.00  0.00           O  
ATOM    761  H   ASP A  49     -13.154  23.314   7.980  1.00  0.00           H  
ATOM    762  HA  ASP A  49     -11.943  25.588   9.264  1.00  0.00           H  
ATOM    763  HB2 ASP A  49     -14.307  24.461   9.707  1.00  0.00           H  
ATOM    764  HB3 ASP A  49     -13.378  23.595  10.932  1.00  0.00           H  
ATOM    765  N   GLU A  50     -10.833  22.601  10.007  1.00  0.00           N  
ATOM    766  CA  GLU A  50      -9.671  21.940  10.587  1.00  0.00           C  
ATOM    767  C   GLU A  50      -8.415  22.338   9.821  1.00  0.00           C  
ATOM    768  O   GLU A  50      -7.370  22.608  10.411  1.00  0.00           O  
ATOM    769  CB  GLU A  50      -9.826  20.416  10.574  1.00  0.00           C  
ATOM    770  CG  GLU A  50      -8.518  19.669  10.821  1.00  0.00           C  
ATOM    771  CD  GLU A  50      -8.686  18.479  11.741  1.00  0.00           C  
ATOM    772  OE1 GLU A  50      -8.674  18.671  12.973  1.00  0.00           O  
ATOM    773  OE2 GLU A  50      -8.851  17.351  11.230  1.00  0.00           O  
ATOM    774  H   GLU A  50     -11.457  22.084   9.454  1.00  0.00           H  
ATOM    775  HA  GLU A  50      -9.582  22.278  11.610  1.00  0.00           H  
ATOM    776  HB2 GLU A  50     -10.530  20.130  11.342  1.00  0.00           H  
ATOM    777  HB3 GLU A  50     -10.214  20.111   9.613  1.00  0.00           H  
ATOM    778  HG2 GLU A  50      -8.133  19.321   9.875  1.00  0.00           H  
ATOM    779  HG3 GLU A  50      -7.810  20.353  11.266  1.00  0.00           H  
ATOM    780  N   LEU A  51      -8.555  22.434   8.503  1.00  0.00           N  
ATOM    781  CA  LEU A  51      -7.465  22.865   7.635  1.00  0.00           C  
ATOM    782  C   LEU A  51      -7.004  24.265   8.021  1.00  0.00           C  
ATOM    783  O   LEU A  51      -5.821  24.594   7.935  1.00  0.00           O  
ATOM    784  CB  LEU A  51      -7.926  22.849   6.174  1.00  0.00           C  
ATOM    785  CG  LEU A  51      -7.236  21.813   5.282  1.00  0.00           C  
ATOM    786  CD1 LEU A  51      -7.685  20.405   5.642  1.00  0.00           C  
ATOM    787  CD2 LEU A  51      -7.515  22.099   3.816  1.00  0.00           C  
ATOM    788  H   LEU A  51      -9.431  22.250   8.107  1.00  0.00           H  
ATOM    789  HA  LEU A  51      -6.642  22.176   7.757  1.00  0.00           H  
ATOM    790  HB2 LEU A  51      -8.989  22.657   6.157  1.00  0.00           H  
ATOM    791  HB3 LEU A  51      -7.749  23.827   5.751  1.00  0.00           H  
ATOM    792  HG  LEU A  51      -6.169  21.872   5.437  1.00  0.00           H  
ATOM    793 HD11 LEU A  51      -8.761  20.384   5.742  1.00  0.00           H  
ATOM    794 HD12 LEU A  51      -7.381  19.722   4.865  1.00  0.00           H  
ATOM    795 HD13 LEU A  51      -7.231  20.111   6.577  1.00  0.00           H  
ATOM    796 HD21 LEU A  51      -8.398  22.717   3.731  1.00  0.00           H  
ATOM    797 HD22 LEU A  51      -6.670  22.617   3.383  1.00  0.00           H  
ATOM    798 HD23 LEU A  51      -7.674  21.168   3.291  1.00  0.00           H  
ATOM    799  N   LYS A  52      -7.958  25.078   8.446  1.00  0.00           N  
ATOM    800  CA  LYS A  52      -7.691  26.448   8.849  1.00  0.00           C  
ATOM    801  C   LYS A  52      -7.106  26.504  10.260  1.00  0.00           C  
ATOM    802  O   LYS A  52      -6.212  27.302  10.540  1.00  0.00           O  
ATOM    803  CB  LYS A  52      -8.995  27.251   8.798  1.00  0.00           C  
ATOM    804  CG  LYS A  52      -8.808  28.758   8.737  1.00  0.00           C  
ATOM    805  CD  LYS A  52     -10.125  29.470   8.450  1.00  0.00           C  
ATOM    806  CE  LYS A  52     -11.152  29.227   9.548  1.00  0.00           C  
ATOM    807  NZ  LYS A  52     -12.398  28.607   9.019  1.00  0.00           N  
ATOM    808  H   LYS A  52      -8.880  24.748   8.486  1.00  0.00           H  
ATOM    809  HA  LYS A  52      -6.984  26.874   8.154  1.00  0.00           H  
ATOM    810  HB2 LYS A  52      -9.555  26.946   7.926  1.00  0.00           H  
ATOM    811  HB3 LYS A  52      -9.576  27.020   9.680  1.00  0.00           H  
ATOM    812  HG2 LYS A  52      -8.423  29.101   9.685  1.00  0.00           H  
ATOM    813  HG3 LYS A  52      -8.102  28.994   7.952  1.00  0.00           H  
ATOM    814  HD2 LYS A  52      -9.938  30.531   8.376  1.00  0.00           H  
ATOM    815  HD3 LYS A  52     -10.521  29.107   7.512  1.00  0.00           H  
ATOM    816  HE2 LYS A  52     -10.721  28.571  10.289  1.00  0.00           H  
ATOM    817  HE3 LYS A  52     -11.397  30.175  10.008  1.00  0.00           H  
ATOM    818  HZ1 LYS A  52     -12.229  28.206   8.072  1.00  0.00           H  
ATOM    819  HZ2 LYS A  52     -12.721  27.843   9.658  1.00  0.00           H  
ATOM    820  HZ3 LYS A  52     -13.155  29.323   8.947  1.00  0.00           H  
ATOM    821  N   ALA A  53      -7.704  25.743  11.171  1.00  0.00           N  
ATOM    822  CA  ALA A  53      -7.342  25.808  12.583  1.00  0.00           C  
ATOM    823  C   ALA A  53      -6.084  25.008  12.903  1.00  0.00           C  
ATOM    824  O   ALA A  53      -5.235  25.464  13.669  1.00  0.00           O  
ATOM    825  CB  ALA A  53      -8.500  25.325  13.446  1.00  0.00           C  
ATOM    826  H   ALA A  53      -8.472  25.194  10.902  1.00  0.00           H  
ATOM    827  HA  ALA A  53      -7.160  26.845  12.828  1.00  0.00           H  
ATOM    828  HB1 ALA A  53      -9.369  25.165  12.825  1.00  0.00           H  
ATOM    829  HB2 ALA A  53      -8.226  24.400  13.929  1.00  0.00           H  
ATOM    830  HB3 ALA A  53      -8.726  26.069  14.196  1.00  0.00           H  
ATOM    831  N   MET A  54      -6.023  23.772  12.426  1.00  0.00           N  
ATOM    832  CA  MET A  54      -4.924  22.881  12.790  1.00  0.00           C  
ATOM    833  C   MET A  54      -3.848  22.845  11.710  1.00  0.00           C  
ATOM    834  O   MET A  54      -2.654  22.811  12.017  1.00  0.00           O  
ATOM    835  CB  MET A  54      -5.453  21.471  13.045  1.00  0.00           C  
ATOM    836  CG  MET A  54      -6.134  21.321  14.393  1.00  0.00           C  
ATOM    837  SD  MET A  54      -5.044  20.624  15.649  1.00  0.00           S  
ATOM    838  CE  MET A  54      -5.533  18.900  15.587  1.00  0.00           C  
ATOM    839  H   MET A  54      -6.779  23.428  11.898  1.00  0.00           H  
ATOM    840  HA  MET A  54      -4.489  23.255  13.703  1.00  0.00           H  
ATOM    841  HB2 MET A  54      -6.166  21.218  12.274  1.00  0.00           H  
ATOM    842  HB3 MET A  54      -4.627  20.776  13.002  1.00  0.00           H  
ATOM    843  HG2 MET A  54      -6.464  22.294  14.725  1.00  0.00           H  
ATOM    844  HG3 MET A  54      -6.988  20.673  14.278  1.00  0.00           H  
ATOM    845  HE1 MET A  54      -5.798  18.638  14.574  1.00  0.00           H  
ATOM    846  HE2 MET A  54      -4.713  18.280  15.916  1.00  0.00           H  
ATOM    847  HE3 MET A  54      -6.384  18.744  16.234  1.00  0.00           H  
ATOM    848  N   GLY A  55      -4.267  22.915  10.456  1.00  0.00           N  
ATOM    849  CA  GLY A  55      -3.324  22.945   9.360  1.00  0.00           C  
ATOM    850  C   GLY A  55      -3.545  21.817   8.371  1.00  0.00           C  
ATOM    851  O   GLY A  55      -4.356  20.923   8.611  1.00  0.00           O  
ATOM    852  H   GLY A  55      -5.224  22.976  10.274  1.00  0.00           H  
ATOM    853  HA2 GLY A  55      -3.423  23.888   8.842  1.00  0.00           H  
ATOM    854  HA3 GLY A  55      -2.321  22.870   9.759  1.00  0.00           H  
ATOM    855  N   LYS A  56      -2.810  21.860   7.270  1.00  0.00           N  
ATOM    856  CA  LYS A  56      -2.893  20.839   6.229  1.00  0.00           C  
ATOM    857  C   LYS A  56      -1.503  20.596   5.642  1.00  0.00           C  
ATOM    858  O   LYS A  56      -0.605  21.405   5.854  1.00  0.00           O  
ATOM    859  CB  LYS A  56      -3.860  21.283   5.127  1.00  0.00           C  
ATOM    860  CG  LYS A  56      -3.665  22.724   4.683  1.00  0.00           C  
ATOM    861  CD  LYS A  56      -3.129  22.802   3.262  1.00  0.00           C  
ATOM    862  CE  LYS A  56      -2.791  24.230   2.873  1.00  0.00           C  
ATOM    863  NZ  LYS A  56      -3.699  24.749   1.820  1.00  0.00           N  
ATOM    864  H   LYS A  56      -2.175  22.600   7.154  1.00  0.00           H  
ATOM    865  HA  LYS A  56      -3.254  19.925   6.676  1.00  0.00           H  
ATOM    866  HB2 LYS A  56      -3.725  20.646   4.266  1.00  0.00           H  
ATOM    867  HB3 LYS A  56      -4.873  21.175   5.488  1.00  0.00           H  
ATOM    868  HG2 LYS A  56      -4.614  23.238   4.728  1.00  0.00           H  
ATOM    869  HG3 LYS A  56      -2.962  23.204   5.349  1.00  0.00           H  
ATOM    870  HD2 LYS A  56      -2.236  22.199   3.191  1.00  0.00           H  
ATOM    871  HD3 LYS A  56      -3.879  22.422   2.584  1.00  0.00           H  
ATOM    872  HE2 LYS A  56      -2.875  24.857   3.748  1.00  0.00           H  
ATOM    873  HE3 LYS A  56      -1.775  24.258   2.508  1.00  0.00           H  
ATOM    874  HZ1 LYS A  56      -4.394  24.019   1.546  1.00  0.00           H  
ATOM    875  HZ2 LYS A  56      -4.214  25.584   2.170  1.00  0.00           H  
ATOM    876  HZ3 LYS A  56      -3.150  25.020   0.977  1.00  0.00           H  
ATOM    877  N   PRO A  57      -1.281  19.469   4.941  1.00  0.00           N  
ATOM    878  CA  PRO A  57       0.035  19.135   4.385  1.00  0.00           C  
ATOM    879  C   PRO A  57       0.555  20.181   3.404  1.00  0.00           C  
ATOM    880  O   PRO A  57      -0.132  20.557   2.455  1.00  0.00           O  
ATOM    881  CB  PRO A  57      -0.182  17.805   3.655  1.00  0.00           C  
ATOM    882  CG  PRO A  57      -1.661  17.650   3.531  1.00  0.00           C  
ATOM    883  CD  PRO A  57      -2.268  18.409   4.678  1.00  0.00           C  
ATOM    884  HA  PRO A  57       0.764  18.995   5.170  1.00  0.00           H  
ATOM    885  HB2 PRO A  57       0.294  17.849   2.683  1.00  0.00           H  
ATOM    886  HB3 PRO A  57       0.256  17.003   4.234  1.00  0.00           H  
ATOM    887  HG2 PRO A  57      -1.995  18.062   2.592  1.00  0.00           H  
ATOM    888  HG3 PRO A  57      -1.925  16.604   3.595  1.00  0.00           H  
ATOM    889  HD2 PRO A  57      -3.219  18.830   4.391  1.00  0.00           H  
ATOM    890  HD3 PRO A  57      -2.380  17.767   5.540  1.00  0.00           H  
ATOM    891  N   ASP A  58       1.813  20.553   3.578  1.00  0.00           N  
ATOM    892  CA  ASP A  58       2.483  21.444   2.645  1.00  0.00           C  
ATOM    893  C   ASP A  58       3.273  20.615   1.647  1.00  0.00           C  
ATOM    894  O   ASP A  58       4.397  20.188   1.921  1.00  0.00           O  
ATOM    895  CB  ASP A  58       3.409  22.415   3.386  1.00  0.00           C  
ATOM    896  CG  ASP A  58       4.140  23.365   2.451  1.00  0.00           C  
ATOM    897  OD1 ASP A  58       3.696  23.550   1.299  1.00  0.00           O  
ATOM    898  OD2 ASP A  58       5.164  23.947   2.870  1.00  0.00           O  
ATOM    899  H   ASP A  58       2.335  20.149   4.305  1.00  0.00           H  
ATOM    900  HA  ASP A  58       1.725  22.004   2.114  1.00  0.00           H  
ATOM    901  HB2 ASP A  58       2.823  23.002   4.077  1.00  0.00           H  
ATOM    902  HB3 ASP A  58       4.143  21.848   3.939  1.00  0.00           H  
ATOM    903  N   VAL A  59       2.666  20.353   0.505  1.00  0.00           N  
ATOM    904  CA  VAL A  59       3.291  19.543  -0.523  1.00  0.00           C  
ATOM    905  C   VAL A  59       3.222  20.252  -1.869  1.00  0.00           C  
ATOM    906  O   VAL A  59       2.275  20.993  -2.144  1.00  0.00           O  
ATOM    907  CB  VAL A  59       2.644  18.143  -0.636  1.00  0.00           C  
ATOM    908  CG1 VAL A  59       3.290  17.169   0.327  1.00  0.00           C  
ATOM    909  CG2 VAL A  59       1.155  18.204  -0.372  1.00  0.00           C  
ATOM    910  H   VAL A  59       1.764  20.703   0.352  1.00  0.00           H  
ATOM    911  HA  VAL A  59       4.330  19.414  -0.253  1.00  0.00           H  
ATOM    912  HB  VAL A  59       2.794  17.778  -1.641  1.00  0.00           H  
ATOM    913 HG11 VAL A  59       4.211  17.588   0.701  1.00  0.00           H  
ATOM    914 HG12 VAL A  59       2.615  16.986   1.153  1.00  0.00           H  
ATOM    915 HG13 VAL A  59       3.495  16.240  -0.182  1.00  0.00           H  
ATOM    916 HG21 VAL A  59       0.849  19.236  -0.270  1.00  0.00           H  
ATOM    917 HG22 VAL A  59       0.628  17.748  -1.199  1.00  0.00           H  
ATOM    918 HG23 VAL A  59       0.928  17.669   0.538  1.00  0.00           H  
ATOM    919  N   LYS A  60       4.263  20.070  -2.671  1.00  0.00           N  
ATOM    920  CA  LYS A  60       4.372  20.737  -3.964  1.00  0.00           C  
ATOM    921  C   LYS A  60       3.255  20.304  -4.907  1.00  0.00           C  
ATOM    922  O   LYS A  60       2.708  21.110  -5.662  1.00  0.00           O  
ATOM    923  CB  LYS A  60       5.730  20.439  -4.610  1.00  0.00           C  
ATOM    924  CG  LYS A  60       6.375  19.141  -4.145  1.00  0.00           C  
ATOM    925  CD  LYS A  60       7.174  18.486  -5.261  1.00  0.00           C  
ATOM    926  CE  LYS A  60       8.672  18.571  -5.006  1.00  0.00           C  
ATOM    927  NZ  LYS A  60       9.274  19.780  -5.629  1.00  0.00           N  
ATOM    928  H   LYS A  60       5.002  19.504  -2.362  1.00  0.00           H  
ATOM    929  HA  LYS A  60       4.291  21.800  -3.795  1.00  0.00           H  
ATOM    930  HB2 LYS A  60       5.596  20.382  -5.680  1.00  0.00           H  
ATOM    931  HB3 LYS A  60       6.406  21.251  -4.387  1.00  0.00           H  
ATOM    932  HG2 LYS A  60       7.035  19.352  -3.318  1.00  0.00           H  
ATOM    933  HG3 LYS A  60       5.600  18.459  -3.824  1.00  0.00           H  
ATOM    934  HD2 LYS A  60       6.891  17.446  -5.331  1.00  0.00           H  
ATOM    935  HD3 LYS A  60       6.948  18.986  -6.192  1.00  0.00           H  
ATOM    936  HE2 LYS A  60       8.843  18.604  -3.940  1.00  0.00           H  
ATOM    937  HE3 LYS A  60       9.144  17.691  -5.418  1.00  0.00           H  
ATOM    938  HZ1 LYS A  60       8.733  20.058  -6.478  1.00  0.00           H  
ATOM    939  HZ2 LYS A  60       9.262  20.576  -4.954  1.00  0.00           H  
ATOM    940  HZ3 LYS A  60      10.259  19.591  -5.905  1.00  0.00           H  
ATOM    941  N   ASN A  61       2.938  19.024  -4.870  1.00  0.00           N  
ATOM    942  CA  ASN A  61       1.916  18.450  -5.728  1.00  0.00           C  
ATOM    943  C   ASN A  61       0.705  18.040  -4.904  1.00  0.00           C  
ATOM    944  O   ASN A  61       0.569  16.887  -4.492  1.00  0.00           O  
ATOM    945  CB  ASN A  61       2.471  17.246  -6.503  1.00  0.00           C  
ATOM    946  CG  ASN A  61       3.507  16.438  -5.742  1.00  0.00           C  
ATOM    947  OD1 ASN A  61       3.664  16.553  -4.523  1.00  0.00           O  
ATOM    948  ND2 ASN A  61       4.219  15.606  -6.469  1.00  0.00           N  
ATOM    949  H   ASN A  61       3.418  18.432  -4.251  1.00  0.00           H  
ATOM    950  HA  ASN A  61       1.610  19.210  -6.431  1.00  0.00           H  
ATOM    951  HB2 ASN A  61       1.660  16.581  -6.750  1.00  0.00           H  
ATOM    952  HB3 ASN A  61       2.925  17.599  -7.418  1.00  0.00           H  
ATOM    953 HD21 ASN A  61       4.044  15.564  -7.430  1.00  0.00           H  
ATOM    954 HD22 ASN A  61       4.871  15.039  -6.014  1.00  0.00           H  
ATOM    955  N   TYR A  62      -0.081  19.032  -4.528  1.00  0.00           N  
ATOM    956  CA  TYR A  62      -1.175  18.833  -3.597  1.00  0.00           C  
ATOM    957  C   TYR A  62      -2.510  19.213  -4.227  1.00  0.00           C  
ATOM    958  O   TYR A  62      -2.694  20.354  -4.651  1.00  0.00           O  
ATOM    959  CB  TYR A  62      -0.910  19.705  -2.367  1.00  0.00           C  
ATOM    960  CG  TYR A  62      -2.067  19.848  -1.406  1.00  0.00           C  
ATOM    961  CD1 TYR A  62      -2.914  18.785  -1.128  1.00  0.00           C  
ATOM    962  CD2 TYR A  62      -2.304  21.058  -0.779  1.00  0.00           C  
ATOM    963  CE1 TYR A  62      -3.968  18.929  -0.250  1.00  0.00           C  
ATOM    964  CE2 TYR A  62      -3.354  21.212   0.100  1.00  0.00           C  
ATOM    965  CZ  TYR A  62      -4.186  20.148   0.362  1.00  0.00           C  
ATOM    966  OH  TYR A  62      -5.240  20.321   1.235  1.00  0.00           O  
ATOM    967  H   TYR A  62       0.151  19.950  -4.784  1.00  0.00           H  
ATOM    968  HA  TYR A  62      -1.194  17.796  -3.302  1.00  0.00           H  
ATOM    969  HB2 TYR A  62      -0.084  19.289  -1.819  1.00  0.00           H  
ATOM    970  HB3 TYR A  62      -0.638  20.698  -2.701  1.00  0.00           H  
ATOM    971  HD1 TYR A  62      -2.740  17.835  -1.609  1.00  0.00           H  
ATOM    972  HD2 TYR A  62      -1.653  21.894  -0.986  1.00  0.00           H  
ATOM    973  HE1 TYR A  62      -4.614  18.091  -0.052  1.00  0.00           H  
ATOM    974  HE2 TYR A  62      -3.518  22.163   0.580  1.00  0.00           H  
ATOM    975  HH  TYR A  62      -5.498  19.463   1.624  1.00  0.00           H  
ATOM    976  N   LYS A  63      -3.471  18.296  -4.204  1.00  0.00           N  
ATOM    977  CA  LYS A  63      -4.813  18.596  -4.675  1.00  0.00           C  
ATOM    978  C   LYS A  63      -5.823  18.328  -3.561  1.00  0.00           C  
ATOM    979  O   LYS A  63      -6.054  17.175  -3.189  1.00  0.00           O  
ATOM    980  CB  LYS A  63      -5.180  17.746  -5.899  1.00  0.00           C  
ATOM    981  CG  LYS A  63      -4.067  17.582  -6.914  1.00  0.00           C  
ATOM    982  CD  LYS A  63      -4.617  17.189  -8.277  1.00  0.00           C  
ATOM    983  CE  LYS A  63      -4.115  15.825  -8.723  1.00  0.00           C  
ATOM    984  NZ  LYS A  63      -3.641  15.848 -10.133  1.00  0.00           N  
ATOM    985  H   LYS A  63      -3.315  17.410  -3.803  1.00  0.00           H  
ATOM    986  HA  LYS A  63      -4.849  19.641  -4.943  1.00  0.00           H  
ATOM    987  HB2 LYS A  63      -5.474  16.763  -5.565  1.00  0.00           H  
ATOM    988  HB3 LYS A  63      -6.014  18.209  -6.399  1.00  0.00           H  
ATOM    989  HG2 LYS A  63      -3.551  18.522  -7.005  1.00  0.00           H  
ATOM    990  HG3 LYS A  63      -3.384  16.819  -6.573  1.00  0.00           H  
ATOM    991  HD2 LYS A  63      -5.695  17.164  -8.224  1.00  0.00           H  
ATOM    992  HD3 LYS A  63      -4.311  17.929  -9.002  1.00  0.00           H  
ATOM    993  HE2 LYS A  63      -3.301  15.527  -8.081  1.00  0.00           H  
ATOM    994  HE3 LYS A  63      -4.922  15.113  -8.633  1.00  0.00           H  
ATOM    995  HZ1 LYS A  63      -3.448  16.831 -10.432  1.00  0.00           H  
ATOM    996  HZ2 LYS A  63      -2.765  15.293 -10.232  1.00  0.00           H  
ATOM    997  HZ3 LYS A  63      -4.362  15.446 -10.766  1.00  0.00           H  
ATOM    998  N   HIS A  64      -6.459  19.377  -3.058  1.00  0.00           N  
ATOM    999  CA  HIS A  64      -7.487  19.221  -2.036  1.00  0.00           C  
ATOM   1000  C   HIS A  64      -8.843  19.113  -2.719  1.00  0.00           C  
ATOM   1001  O   HIS A  64      -9.276  20.043  -3.398  1.00  0.00           O  
ATOM   1002  CB  HIS A  64      -7.467  20.409  -1.066  1.00  0.00           C  
ATOM   1003  CG  HIS A  64      -8.533  20.368  -0.007  1.00  0.00           C  
ATOM   1004  ND1 HIS A  64      -9.268  21.475   0.356  1.00  0.00           N  
ATOM   1005  CD2 HIS A  64      -8.991  19.350   0.763  1.00  0.00           C  
ATOM   1006  CE1 HIS A  64     -10.131  21.142   1.298  1.00  0.00           C  
ATOM   1007  NE2 HIS A  64      -9.985  19.861   1.565  1.00  0.00           N  
ATOM   1008  H   HIS A  64      -6.267  20.277  -3.404  1.00  0.00           H  
ATOM   1009  HA  HIS A  64      -7.288  18.309  -1.494  1.00  0.00           H  
ATOM   1010  HB2 HIS A  64      -6.509  20.439  -0.567  1.00  0.00           H  
ATOM   1011  HB3 HIS A  64      -7.597  21.321  -1.631  1.00  0.00           H  
ATOM   1012  HD1 HIS A  64      -9.152  22.385  -0.010  1.00  0.00           H  
ATOM   1013  HD2 HIS A  64      -8.633  18.330   0.755  1.00  0.00           H  
ATOM   1014  HE1 HIS A  64     -10.841  21.807   1.770  1.00  0.00           H  
ATOM   1015  HE2 HIS A  64     -10.378  19.406   2.345  1.00  0.00           H  
ATOM   1016  N   MET A  65      -9.461  17.950  -2.623  1.00  0.00           N  
ATOM   1017  CA  MET A  65     -10.710  17.698  -3.329  1.00  0.00           C  
ATOM   1018  C   MET A  65     -11.856  17.509  -2.347  1.00  0.00           C  
ATOM   1019  O   MET A  65     -11.923  16.501  -1.651  1.00  0.00           O  
ATOM   1020  CB  MET A  65     -10.562  16.461  -4.212  1.00  0.00           C  
ATOM   1021  CG  MET A  65     -10.454  16.781  -5.693  1.00  0.00           C  
ATOM   1022  SD  MET A  65      -8.817  17.370  -6.164  1.00  0.00           S  
ATOM   1023  CE  MET A  65      -9.163  19.093  -6.511  1.00  0.00           C  
ATOM   1024  H   MET A  65      -9.040  17.213  -2.120  1.00  0.00           H  
ATOM   1025  HA  MET A  65     -10.919  18.552  -3.954  1.00  0.00           H  
ATOM   1026  HB2 MET A  65      -9.673  15.927  -3.915  1.00  0.00           H  
ATOM   1027  HB3 MET A  65     -11.421  15.824  -4.065  1.00  0.00           H  
ATOM   1028  HG2 MET A  65     -10.671  15.887  -6.255  1.00  0.00           H  
ATOM   1029  HG3 MET A  65     -11.180  17.544  -5.936  1.00  0.00           H  
ATOM   1030  HE1 MET A  65     -10.226  19.269  -6.431  1.00  0.00           H  
ATOM   1031  HE2 MET A  65      -8.640  19.715  -5.800  1.00  0.00           H  
ATOM   1032  HE3 MET A  65      -8.833  19.332  -7.510  1.00  0.00           H  
ATOM   1033  N   SER A  66     -12.684  18.532  -2.204  1.00  0.00           N  
ATOM   1034  CA  SER A  66     -13.739  18.516  -1.205  1.00  0.00           C  
ATOM   1035  C   SER A  66     -15.060  17.968  -1.766  1.00  0.00           C  
ATOM   1036  O   SER A  66     -15.252  16.752  -1.828  1.00  0.00           O  
ATOM   1037  CB  SER A  66     -13.930  19.926  -0.647  1.00  0.00           C  
ATOM   1038  OG  SER A  66     -13.080  20.850  -1.312  1.00  0.00           O  
ATOM   1039  H   SER A  66     -12.532  19.353  -2.716  1.00  0.00           H  
ATOM   1040  HA  SER A  66     -13.416  17.869  -0.402  1.00  0.00           H  
ATOM   1041  HB2 SER A  66     -14.956  20.232  -0.785  1.00  0.00           H  
ATOM   1042  HB3 SER A  66     -13.690  19.930   0.405  1.00  0.00           H  
ATOM   1043  HG  SER A  66     -12.915  21.609  -0.730  1.00  0.00           H  
ATOM   1044  N   ARG A  67     -16.015  18.869  -2.016  1.00  0.00           N  
ATOM   1045  CA  ARG A  67     -17.382  18.486  -2.380  1.00  0.00           C  
ATOM   1046  C   ARG A  67     -17.964  17.592  -1.286  1.00  0.00           C  
ATOM   1047  O   ARG A  67     -17.787  17.890  -0.104  1.00  0.00           O  
ATOM   1048  CB  ARG A  67     -17.424  17.802  -3.750  1.00  0.00           C  
ATOM   1049  CG  ARG A  67     -18.508  18.352  -4.666  1.00  0.00           C  
ATOM   1050  CD  ARG A  67     -18.257  19.810  -5.018  1.00  0.00           C  
ATOM   1051  NE  ARG A  67     -19.302  20.694  -4.501  1.00  0.00           N  
ATOM   1052  CZ  ARG A  67     -19.845  21.702  -5.193  1.00  0.00           C  
ATOM   1053  NH1 ARG A  67     -19.456  21.948  -6.438  1.00  0.00           N  
ATOM   1054  NH2 ARG A  67     -20.769  22.468  -4.625  1.00  0.00           N  
ATOM   1055  H   ARG A  67     -15.829  19.815  -1.833  1.00  0.00           H  
ATOM   1056  HA  ARG A  67     -17.968  19.394  -2.424  1.00  0.00           H  
ATOM   1057  HB2 ARG A  67     -16.469  17.937  -4.237  1.00  0.00           H  
ATOM   1058  HB3 ARG A  67     -17.602  16.746  -3.609  1.00  0.00           H  
ATOM   1059  HG2 ARG A  67     -18.525  17.772  -5.576  1.00  0.00           H  
ATOM   1060  HG3 ARG A  67     -19.462  18.271  -4.165  1.00  0.00           H  
ATOM   1061  HD2 ARG A  67     -17.307  20.110  -4.596  1.00  0.00           H  
ATOM   1062  HD3 ARG A  67     -18.215  19.905  -6.093  1.00  0.00           H  
ATOM   1063  HE  ARG A  67     -19.614  20.531  -3.577  1.00  0.00           H  
ATOM   1064 HH11 ARG A  67     -18.752  21.383  -6.868  1.00  0.00           H  
ATOM   1065 HH12 ARG A  67     -19.871  22.709  -6.961  1.00  0.00           H  
ATOM   1066 HH21 ARG A  67     -21.058  22.295  -3.679  1.00  0.00           H  
ATOM   1067 HH22 ARG A  67     -21.189  23.229  -5.140  1.00  0.00           H  
ATOM   1068  N   GLY A  68     -18.561  16.460  -1.641  1.00  0.00           N  
ATOM   1069  CA  GLY A  68     -19.013  15.543  -0.619  1.00  0.00           C  
ATOM   1070  C   GLY A  68     -17.977  14.475  -0.361  1.00  0.00           C  
ATOM   1071  O   GLY A  68     -17.574  14.242   0.780  1.00  0.00           O  
ATOM   1072  H   GLY A  68     -18.636  16.189  -2.583  1.00  0.00           H  
ATOM   1073  HA2 GLY A  68     -19.195  16.093   0.294  1.00  0.00           H  
ATOM   1074  HA3 GLY A  68     -19.931  15.076  -0.943  1.00  0.00           H  
ATOM   1075  N   LYS A  69     -17.439  13.923  -1.439  1.00  0.00           N  
ATOM   1076  CA  LYS A  69     -16.329  12.992  -1.347  1.00  0.00           C  
ATOM   1077  C   LYS A  69     -15.480  13.036  -2.610  1.00  0.00           C  
ATOM   1078  O   LYS A  69     -14.986  12.008  -3.067  1.00  0.00           O  
ATOM   1079  CB  LYS A  69     -16.813  11.566  -1.070  1.00  0.00           C  
ATOM   1080  CG  LYS A  69     -16.741  11.179   0.404  1.00  0.00           C  
ATOM   1081  CD  LYS A  69     -15.302  11.035   0.889  1.00  0.00           C  
ATOM   1082  CE  LYS A  69     -14.712  12.367   1.335  1.00  0.00           C  
ATOM   1083  NZ  LYS A  69     -15.102  12.726   2.724  1.00  0.00           N  
ATOM   1084  H   LYS A  69     -17.737  14.226  -2.334  1.00  0.00           H  
ATOM   1085  HA  LYS A  69     -15.714  13.312  -0.519  1.00  0.00           H  
ATOM   1086  HB2 LYS A  69     -17.840  11.478  -1.393  1.00  0.00           H  
ATOM   1087  HB3 LYS A  69     -16.206  10.874  -1.632  1.00  0.00           H  
ATOM   1088  HG2 LYS A  69     -17.231  11.942   0.990  1.00  0.00           H  
ATOM   1089  HG3 LYS A  69     -17.253  10.236   0.541  1.00  0.00           H  
ATOM   1090  HD2 LYS A  69     -15.284  10.349   1.724  1.00  0.00           H  
ATOM   1091  HD3 LYS A  69     -14.701  10.637   0.084  1.00  0.00           H  
ATOM   1092  HE2 LYS A  69     -13.636  12.303   1.282  1.00  0.00           H  
ATOM   1093  HE3 LYS A  69     -15.059  13.139   0.664  1.00  0.00           H  
ATOM   1094  HZ1 LYS A  69     -16.141  12.797   2.803  1.00  0.00           H  
ATOM   1095  HZ2 LYS A  69     -14.763  12.003   3.393  1.00  0.00           H  
ATOM   1096  HZ3 LYS A  69     -14.686  13.642   2.985  1.00  0.00           H  
ATOM   1097  N   LEU A  70     -15.231  14.261  -3.083  1.00  0.00           N  
ATOM   1098  CA  LEU A  70     -14.324  14.529  -4.206  1.00  0.00           C  
ATOM   1099  C   LEU A  70     -14.881  14.057  -5.556  1.00  0.00           C  
ATOM   1100  O   LEU A  70     -14.230  14.223  -6.586  1.00  0.00           O  
ATOM   1101  CB  LEU A  70     -12.938  13.916  -3.917  1.00  0.00           C  
ATOM   1102  CG  LEU A  70     -12.459  12.810  -4.866  1.00  0.00           C  
ATOM   1103  CD1 LEU A  70     -11.255  13.280  -5.663  1.00  0.00           C  
ATOM   1104  CD2 LEU A  70     -12.110  11.555  -4.093  1.00  0.00           C  
ATOM   1105  H   LEU A  70     -15.608  15.024  -2.596  1.00  0.00           H  
ATOM   1106  HA  LEU A  70     -14.207  15.601  -4.258  1.00  0.00           H  
ATOM   1107  HB2 LEU A  70     -12.211  14.708  -3.939  1.00  0.00           H  
ATOM   1108  HB3 LEU A  70     -12.965  13.509  -2.917  1.00  0.00           H  
ATOM   1109  HG  LEU A  70     -13.250  12.567  -5.562  1.00  0.00           H  
ATOM   1110 HD11 LEU A  70     -10.544  13.750  -4.997  1.00  0.00           H  
ATOM   1111 HD12 LEU A  70     -10.788  12.433  -6.145  1.00  0.00           H  
ATOM   1112 HD13 LEU A  70     -11.570  13.991  -6.410  1.00  0.00           H  
ATOM   1113 HD21 LEU A  70     -12.381  11.684  -3.054  1.00  0.00           H  
ATOM   1114 HD22 LEU A  70     -12.652  10.715  -4.504  1.00  0.00           H  
ATOM   1115 HD23 LEU A  70     -11.049  11.369  -4.167  1.00  0.00           H  
ATOM   1116  N   GLU A  71     -16.054  13.437  -5.536  1.00  0.00           N  
ATOM   1117  CA  GLU A  71     -16.667  12.871  -6.744  1.00  0.00           C  
ATOM   1118  C   GLU A  71     -16.618  13.832  -7.955  1.00  0.00           C  
ATOM   1119  O   GLU A  71     -15.982  13.515  -8.958  1.00  0.00           O  
ATOM   1120  CB  GLU A  71     -18.112  12.421  -6.463  1.00  0.00           C  
ATOM   1121  CG  GLU A  71     -18.470  12.357  -4.982  1.00  0.00           C  
ATOM   1122  CD  GLU A  71     -19.126  13.632  -4.485  1.00  0.00           C  
ATOM   1123  OE1 GLU A  71     -20.323  13.836  -4.766  1.00  0.00           O  
ATOM   1124  OE2 GLU A  71     -18.435  14.442  -3.825  1.00  0.00           O  
ATOM   1125  H   GLU A  71     -16.499  13.309  -4.672  1.00  0.00           H  
ATOM   1126  HA  GLU A  71     -16.091  11.996  -7.002  1.00  0.00           H  
ATOM   1127  HB2 GLU A  71     -18.789  13.113  -6.942  1.00  0.00           H  
ATOM   1128  HB3 GLU A  71     -18.259  11.438  -6.889  1.00  0.00           H  
ATOM   1129  HG2 GLU A  71     -19.153  11.536  -4.825  1.00  0.00           H  
ATOM   1130  HG3 GLU A  71     -17.568  12.187  -4.413  1.00  0.00           H  
ATOM   1131  N   PRO A  72     -17.288  15.006  -7.908  1.00  0.00           N  
ATOM   1132  CA  PRO A  72     -17.303  15.947  -9.031  1.00  0.00           C  
ATOM   1133  C   PRO A  72     -15.993  16.707  -9.194  1.00  0.00           C  
ATOM   1134  O   PRO A  72     -15.774  17.364 -10.207  1.00  0.00           O  
ATOM   1135  CB  PRO A  72     -18.437  16.929  -8.687  1.00  0.00           C  
ATOM   1136  CG  PRO A  72     -19.128  16.344  -7.502  1.00  0.00           C  
ATOM   1137  CD  PRO A  72     -18.097  15.520  -6.798  1.00  0.00           C  
ATOM   1138  HA  PRO A  72     -17.537  15.446  -9.957  1.00  0.00           H  
ATOM   1139  HB2 PRO A  72     -18.016  17.895  -8.457  1.00  0.00           H  
ATOM   1140  HB3 PRO A  72     -19.107  17.016  -9.529  1.00  0.00           H  
ATOM   1141  HG2 PRO A  72     -19.482  17.136  -6.856  1.00  0.00           H  
ATOM   1142  HG3 PRO A  72     -19.952  15.723  -7.823  1.00  0.00           H  
ATOM   1143  HD2 PRO A  72     -17.507  16.138  -6.138  1.00  0.00           H  
ATOM   1144  HD3 PRO A  72     -18.563  14.713  -6.251  1.00  0.00           H  
ATOM   1145  N   LEU A  73     -15.161  16.687  -8.160  1.00  0.00           N  
ATOM   1146  CA  LEU A  73     -13.927  17.460  -8.161  1.00  0.00           C  
ATOM   1147  C   LEU A  73     -12.765  16.648  -8.719  1.00  0.00           C  
ATOM   1148  O   LEU A  73     -11.715  17.200  -9.037  1.00  0.00           O  
ATOM   1149  CB  LEU A  73     -13.603  17.927  -6.738  1.00  0.00           C  
ATOM   1150  CG  LEU A  73     -13.727  19.432  -6.487  1.00  0.00           C  
ATOM   1151  CD1 LEU A  73     -12.657  20.194  -7.252  1.00  0.00           C  
ATOM   1152  CD2 LEU A  73     -15.114  19.928  -6.870  1.00  0.00           C  
ATOM   1153  H   LEU A  73     -15.402  16.181  -7.357  1.00  0.00           H  
ATOM   1154  HA  LEU A  73     -14.078  18.327  -8.789  1.00  0.00           H  
ATOM   1155  HB2 LEU A  73     -14.269  17.416  -6.056  1.00  0.00           H  
ATOM   1156  HB3 LEU A  73     -12.590  17.630  -6.508  1.00  0.00           H  
ATOM   1157  HG  LEU A  73     -13.583  19.626  -5.435  1.00  0.00           H  
ATOM   1158 HD11 LEU A  73     -12.729  19.957  -8.304  1.00  0.00           H  
ATOM   1159 HD12 LEU A  73     -12.799  21.255  -7.111  1.00  0.00           H  
ATOM   1160 HD13 LEU A  73     -11.682  19.909  -6.884  1.00  0.00           H  
ATOM   1161 HD21 LEU A  73     -15.557  19.247  -7.581  1.00  0.00           H  
ATOM   1162 HD22 LEU A  73     -15.734  19.981  -5.988  1.00  0.00           H  
ATOM   1163 HD23 LEU A  73     -15.035  20.909  -7.314  1.00  0.00           H  
ATOM   1164  N   LEU A  74     -12.951  15.338  -8.803  1.00  0.00           N  
ATOM   1165  CA  LEU A  74     -11.910  14.435  -9.286  1.00  0.00           C  
ATOM   1166  C   LEU A  74     -11.457  14.835 -10.691  1.00  0.00           C  
ATOM   1167  O   LEU A  74     -10.268  15.015 -10.952  1.00  0.00           O  
ATOM   1168  CB  LEU A  74     -12.446  13.003  -9.284  1.00  0.00           C  
ATOM   1169  CG  LEU A  74     -11.450  11.913  -9.674  1.00  0.00           C  
ATOM   1170  CD1 LEU A  74     -10.362  11.773  -8.626  1.00  0.00           C  
ATOM   1171  CD2 LEU A  74     -12.174  10.592  -9.855  1.00  0.00           C  
ATOM   1172  H   LEU A  74     -13.808  14.957  -8.506  1.00  0.00           H  
ATOM   1173  HA  LEU A  74     -11.070  14.503  -8.610  1.00  0.00           H  
ATOM   1174  HB2 LEU A  74     -12.813  12.784  -8.291  1.00  0.00           H  
ATOM   1175  HB3 LEU A  74     -13.280  12.959  -9.971  1.00  0.00           H  
ATOM   1176  HG  LEU A  74     -10.985  12.172 -10.613  1.00  0.00           H  
ATOM   1177 HD11 LEU A  74      -9.950  12.745  -8.402  1.00  0.00           H  
ATOM   1178 HD12 LEU A  74     -10.781  11.343  -7.728  1.00  0.00           H  
ATOM   1179 HD13 LEU A  74      -9.582  11.129  -9.003  1.00  0.00           H  
ATOM   1180 HD21 LEU A  74     -13.152  10.652  -9.401  1.00  0.00           H  
ATOM   1181 HD22 LEU A  74     -12.278  10.379 -10.909  1.00  0.00           H  
ATOM   1182 HD23 LEU A  74     -11.607   9.804  -9.384  1.00  0.00           H  
ATOM   1183  N   ALA A  75     -12.418  14.958 -11.593  1.00  0.00           N  
ATOM   1184  CA  ALA A  75     -12.133  15.325 -12.975  1.00  0.00           C  
ATOM   1185  C   ALA A  75     -11.667  16.774 -13.080  1.00  0.00           C  
ATOM   1186  O   ALA A  75     -11.073  17.176 -14.081  1.00  0.00           O  
ATOM   1187  CB  ALA A  75     -13.371  15.109 -13.828  1.00  0.00           C  
ATOM   1188  H   ALA A  75     -13.342  14.771 -11.325  1.00  0.00           H  
ATOM   1189  HA  ALA A  75     -11.353  14.675 -13.342  1.00  0.00           H  
ATOM   1190  HB1 ALA A  75     -14.233  14.999 -13.188  1.00  0.00           H  
ATOM   1191  HB2 ALA A  75     -13.510  15.958 -14.480  1.00  0.00           H  
ATOM   1192  HB3 ALA A  75     -13.246  14.215 -14.422  1.00  0.00           H  
ATOM   1193  N   LYS A  76     -12.025  17.570 -12.082  1.00  0.00           N  
ATOM   1194  CA  LYS A  76     -11.743  19.003 -12.089  1.00  0.00           C  
ATOM   1195  C   LYS A  76     -10.270  19.290 -11.832  1.00  0.00           C  
ATOM   1196  O   LYS A  76      -9.737  20.297 -12.301  1.00  0.00           O  
ATOM   1197  CB  LYS A  76     -12.588  19.722 -11.035  1.00  0.00           C  
ATOM   1198  CG  LYS A  76     -14.082  19.655 -11.291  1.00  0.00           C  
ATOM   1199  CD  LYS A  76     -14.824  20.745 -10.536  1.00  0.00           C  
ATOM   1200  CE  LYS A  76     -15.771  21.513 -11.444  1.00  0.00           C  
ATOM   1201  NZ  LYS A  76     -15.107  22.687 -12.070  1.00  0.00           N  
ATOM   1202  H   LYS A  76     -12.552  17.197 -11.352  1.00  0.00           H  
ATOM   1203  HA  LYS A  76     -12.004  19.385 -13.063  1.00  0.00           H  
ATOM   1204  HB2 LYS A  76     -12.393  19.278 -10.070  1.00  0.00           H  
ATOM   1205  HB3 LYS A  76     -12.298  20.762 -11.005  1.00  0.00           H  
ATOM   1206  HG2 LYS A  76     -14.263  19.775 -12.350  1.00  0.00           H  
ATOM   1207  HG3 LYS A  76     -14.448  18.691 -10.967  1.00  0.00           H  
ATOM   1208  HD2 LYS A  76     -15.394  20.292  -9.738  1.00  0.00           H  
ATOM   1209  HD3 LYS A  76     -14.102  21.432 -10.118  1.00  0.00           H  
ATOM   1210  HE2 LYS A  76     -16.117  20.851 -12.222  1.00  0.00           H  
ATOM   1211  HE3 LYS A  76     -16.611  21.854 -10.860  1.00  0.00           H  
ATOM   1212  HZ1 LYS A  76     -14.143  22.801 -11.692  1.00  0.00           H  
ATOM   1213  HZ2 LYS A  76     -15.051  22.555 -13.106  1.00  0.00           H  
ATOM   1214  HZ3 LYS A  76     -15.651  23.555 -11.869  1.00  0.00           H  
ATOM   1215  N   SER A  77      -9.615  18.424 -11.075  1.00  0.00           N  
ATOM   1216  CA  SER A  77      -8.214  18.621 -10.753  1.00  0.00           C  
ATOM   1217  C   SER A  77      -7.337  18.218 -11.930  1.00  0.00           C  
ATOM   1218  O   SER A  77      -6.289  18.818 -12.173  1.00  0.00           O  
ATOM   1219  CB  SER A  77      -7.841  17.805  -9.520  1.00  0.00           C  
ATOM   1220  OG  SER A  77      -8.827  16.825  -9.247  1.00  0.00           O  
ATOM   1221  H   SER A  77     -10.083  17.639 -10.711  1.00  0.00           H  
ATOM   1222  HA  SER A  77      -8.062  19.669 -10.543  1.00  0.00           H  
ATOM   1223  HB2 SER A  77      -6.896  17.310  -9.691  1.00  0.00           H  
ATOM   1224  HB3 SER A  77      -7.755  18.462  -8.667  1.00  0.00           H  
ATOM   1225  HG  SER A  77      -9.209  16.989  -8.376  1.00  0.00           H  
ATOM   1226  N   GLY A  78      -7.741  17.158 -12.618  1.00  0.00           N  
ATOM   1227  CA  GLY A  78      -6.950  16.648 -13.715  1.00  0.00           C  
ATOM   1228  C   GLY A  78      -6.186  15.404 -13.320  1.00  0.00           C  
ATOM   1229  O   GLY A  78      -5.047  15.485 -12.852  1.00  0.00           O  
ATOM   1230  H   GLY A  78      -8.558  16.689 -12.346  1.00  0.00           H  
ATOM   1231  HA2 GLY A  78      -7.605  16.411 -14.540  1.00  0.00           H  
ATOM   1232  HA3 GLY A  78      -6.247  17.406 -14.026  1.00  0.00           H  
ATOM   1233  N   LEU A  79      -6.831  14.258 -13.453  1.00  0.00           N  
ATOM   1234  CA  LEU A  79      -6.222  12.997 -13.060  1.00  0.00           C  
ATOM   1235  C   LEU A  79      -6.327  11.966 -14.176  1.00  0.00           C  
ATOM   1236  O   LEU A  79      -7.318  11.926 -14.909  1.00  0.00           O  
ATOM   1237  CB  LEU A  79      -6.877  12.467 -11.785  1.00  0.00           C  
ATOM   1238  CG  LEU A  79      -6.344  13.086 -10.495  1.00  0.00           C  
ATOM   1239  CD1 LEU A  79      -7.490  13.462  -9.571  1.00  0.00           C  
ATOM   1240  CD2 LEU A  79      -5.385  12.130  -9.804  1.00  0.00           C  
ATOM   1241  H   LEU A  79      -7.754  14.262 -13.790  1.00  0.00           H  
ATOM   1242  HA  LEU A  79      -5.178  13.183 -12.860  1.00  0.00           H  
ATOM   1243  HB2 LEU A  79      -7.939  12.657 -11.844  1.00  0.00           H  
ATOM   1244  HB3 LEU A  79      -6.719  11.400 -11.740  1.00  0.00           H  
ATOM   1245  HG  LEU A  79      -5.800  13.988 -10.737  1.00  0.00           H  
ATOM   1246 HD11 LEU A  79      -8.165  12.622  -9.476  1.00  0.00           H  
ATOM   1247 HD12 LEU A  79      -7.099  13.721  -8.599  1.00  0.00           H  
ATOM   1248 HD13 LEU A  79      -8.024  14.306  -9.983  1.00  0.00           H  
ATOM   1249 HD21 LEU A  79      -5.056  11.379 -10.507  1.00  0.00           H  
ATOM   1250 HD22 LEU A  79      -4.531  12.679  -9.437  1.00  0.00           H  
ATOM   1251 HD23 LEU A  79      -5.887  11.652  -8.976  1.00  0.00           H  
ATOM   1252  N   ASP A  80      -5.303  11.132 -14.292  1.00  0.00           N  
ATOM   1253  CA  ASP A  80      -5.266  10.079 -15.300  1.00  0.00           C  
ATOM   1254  C   ASP A  80      -4.929   8.755 -14.624  1.00  0.00           C  
ATOM   1255  O   ASP A  80      -4.239   8.743 -13.606  1.00  0.00           O  
ATOM   1256  CB  ASP A  80      -4.217  10.407 -16.373  1.00  0.00           C  
ATOM   1257  CG  ASP A  80      -4.632   9.953 -17.758  1.00  0.00           C  
ATOM   1258  OD1 ASP A  80      -5.827  10.048 -18.085  1.00  0.00           O  
ATOM   1259  OD2 ASP A  80      -3.758   9.500 -18.529  1.00  0.00           O  
ATOM   1260  H   ASP A  80      -4.542  11.207 -13.681  1.00  0.00           H  
ATOM   1261  HA  ASP A  80      -6.242  10.011 -15.758  1.00  0.00           H  
ATOM   1262  HB2 ASP A  80      -4.058  11.475 -16.399  1.00  0.00           H  
ATOM   1263  HB3 ASP A  80      -3.289   9.918 -16.117  1.00  0.00           H  
ATOM   1264  N   PRO A  81      -5.472   7.628 -15.119  1.00  0.00           N  
ATOM   1265  CA  PRO A  81      -5.290   6.308 -14.492  1.00  0.00           C  
ATOM   1266  C   PRO A  81      -3.867   5.757 -14.608  1.00  0.00           C  
ATOM   1267  O   PRO A  81      -3.601   4.633 -14.184  1.00  0.00           O  
ATOM   1268  CB  PRO A  81      -6.266   5.411 -15.259  1.00  0.00           C  
ATOM   1269  CG  PRO A  81      -6.456   6.090 -16.570  1.00  0.00           C  
ATOM   1270  CD  PRO A  81      -6.378   7.560 -16.278  1.00  0.00           C  
ATOM   1271  HA  PRO A  81      -5.572   6.331 -13.450  1.00  0.00           H  
ATOM   1272  HB2 PRO A  81      -5.834   4.428 -15.384  1.00  0.00           H  
ATOM   1273  HB3 PRO A  81      -7.197   5.339 -14.714  1.00  0.00           H  
ATOM   1274  HG2 PRO A  81      -5.671   5.799 -17.251  1.00  0.00           H  
ATOM   1275  HG3 PRO A  81      -7.423   5.838 -16.978  1.00  0.00           H  
ATOM   1276  HD2 PRO A  81      -5.968   8.091 -17.123  1.00  0.00           H  
ATOM   1277  HD3 PRO A  81      -7.356   7.943 -16.025  1.00  0.00           H  
ATOM   1278  N   GLU A  82      -2.935   6.580 -15.074  1.00  0.00           N  
ATOM   1279  CA  GLU A  82      -1.535   6.188 -15.119  1.00  0.00           C  
ATOM   1280  C   GLU A  82      -0.711   7.092 -14.206  1.00  0.00           C  
ATOM   1281  O   GLU A  82       0.510   7.193 -14.337  1.00  0.00           O  
ATOM   1282  CB  GLU A  82      -1.007   6.251 -16.557  1.00  0.00           C  
ATOM   1283  CG  GLU A  82      -1.105   7.632 -17.190  1.00  0.00           C  
ATOM   1284  CD  GLU A  82       0.172   8.048 -17.893  1.00  0.00           C  
ATOM   1285  OE1 GLU A  82       1.024   7.179 -18.167  1.00  0.00           O  
ATOM   1286  OE2 GLU A  82       0.330   9.253 -18.179  1.00  0.00           O  
ATOM   1287  H   GLU A  82      -3.167   7.497 -15.315  1.00  0.00           H  
ATOM   1288  HA  GLU A  82      -1.463   5.171 -14.761  1.00  0.00           H  
ATOM   1289  HB2 GLU A  82       0.030   5.951 -16.559  1.00  0.00           H  
ATOM   1290  HB3 GLU A  82      -1.574   5.561 -17.164  1.00  0.00           H  
ATOM   1291  HG2 GLU A  82      -1.908   7.626 -17.911  1.00  0.00           H  
ATOM   1292  HG3 GLU A  82      -1.325   8.353 -16.415  1.00  0.00           H  
ATOM   1293  N   LYS A  83      -1.394   7.761 -13.288  1.00  0.00           N  
ATOM   1294  CA  LYS A  83      -0.747   8.669 -12.356  1.00  0.00           C  
ATOM   1295  C   LYS A  83      -0.805   8.109 -10.940  1.00  0.00           C  
ATOM   1296  O   LYS A  83      -1.887   7.794 -10.441  1.00  0.00           O  
ATOM   1297  CB  LYS A  83      -1.420  10.044 -12.395  1.00  0.00           C  
ATOM   1298  CG  LYS A  83      -1.196  10.798 -13.695  1.00  0.00           C  
ATOM   1299  CD  LYS A  83       0.259  11.197 -13.860  1.00  0.00           C  
ATOM   1300  CE  LYS A  83       0.886  10.522 -15.068  1.00  0.00           C  
ATOM   1301  NZ  LYS A  83       2.025   9.645 -14.689  1.00  0.00           N  
ATOM   1302  H   LYS A  83      -2.367   7.646 -13.240  1.00  0.00           H  
ATOM   1303  HA  LYS A  83       0.284   8.774 -12.654  1.00  0.00           H  
ATOM   1304  HB2 LYS A  83      -2.484   9.913 -12.258  1.00  0.00           H  
ATOM   1305  HB3 LYS A  83      -1.033  10.643 -11.585  1.00  0.00           H  
ATOM   1306  HG2 LYS A  83      -1.483  10.166 -14.522  1.00  0.00           H  
ATOM   1307  HG3 LYS A  83      -1.807  11.690 -13.692  1.00  0.00           H  
ATOM   1308  HD2 LYS A  83       0.318  12.268 -13.987  1.00  0.00           H  
ATOM   1309  HD3 LYS A  83       0.803  10.907 -12.973  1.00  0.00           H  
ATOM   1310  HE2 LYS A  83       0.134   9.926 -15.561  1.00  0.00           H  
ATOM   1311  HE3 LYS A  83       1.239  11.284 -15.747  1.00  0.00           H  
ATOM   1312  HZ1 LYS A  83       2.477   9.999 -13.812  1.00  0.00           H  
ATOM   1313  HZ2 LYS A  83       1.695   8.671 -14.531  1.00  0.00           H  
ATOM   1314  HZ3 LYS A  83       2.741   9.639 -15.449  1.00  0.00           H  
ATOM   1315  N   PRO A  84       0.344   8.016 -10.255  1.00  0.00           N  
ATOM   1316  CA  PRO A  84       0.395   7.548  -8.875  1.00  0.00           C  
ATOM   1317  C   PRO A  84      -0.097   8.621  -7.911  1.00  0.00           C  
ATOM   1318  O   PRO A  84       0.313   9.780  -7.995  1.00  0.00           O  
ATOM   1319  CB  PRO A  84       1.884   7.250  -8.637  1.00  0.00           C  
ATOM   1320  CG  PRO A  84       2.573   7.500  -9.941  1.00  0.00           C  
ATOM   1321  CD  PRO A  84       1.674   8.404 -10.730  1.00  0.00           C  
ATOM   1322  HA  PRO A  84      -0.187   6.647  -8.738  1.00  0.00           H  
ATOM   1323  HB2 PRO A  84       2.259   7.905  -7.865  1.00  0.00           H  
ATOM   1324  HB3 PRO A  84       1.997   6.223  -8.323  1.00  0.00           H  
ATOM   1325  HG2 PRO A  84       3.522   7.982  -9.765  1.00  0.00           H  
ATOM   1326  HG3 PRO A  84       2.719   6.567 -10.463  1.00  0.00           H  
ATOM   1327  HD2 PRO A  84       1.884   9.440 -10.505  1.00  0.00           H  
ATOM   1328  HD3 PRO A  84       1.782   8.211 -11.787  1.00  0.00           H  
ATOM   1329  N   VAL A  85      -1.019   8.251  -7.038  1.00  0.00           N  
ATOM   1330  CA  VAL A  85      -1.606   9.205  -6.111  1.00  0.00           C  
ATOM   1331  C   VAL A  85      -1.773   8.592  -4.730  1.00  0.00           C  
ATOM   1332  O   VAL A  85      -1.993   7.388  -4.594  1.00  0.00           O  
ATOM   1333  CB  VAL A  85      -2.983   9.711  -6.596  1.00  0.00           C  
ATOM   1334  CG1 VAL A  85      -2.839  11.000  -7.389  1.00  0.00           C  
ATOM   1335  CG2 VAL A  85      -3.695   8.651  -7.423  1.00  0.00           C  
ATOM   1336  H   VAL A  85      -1.342   7.325  -7.041  1.00  0.00           H  
ATOM   1337  HA  VAL A  85      -0.941  10.053  -6.038  1.00  0.00           H  
ATOM   1338  HB  VAL A  85      -3.587   9.917  -5.726  1.00  0.00           H  
ATOM   1339 HG11 VAL A  85      -1.859  11.421  -7.220  1.00  0.00           H  
ATOM   1340 HG12 VAL A  85      -2.965  10.791  -8.442  1.00  0.00           H  
ATOM   1341 HG13 VAL A  85      -3.593  11.703  -7.069  1.00  0.00           H  
ATOM   1342 HG21 VAL A  85      -3.033   8.296  -8.199  1.00  0.00           H  
ATOM   1343 HG22 VAL A  85      -3.977   7.828  -6.784  1.00  0.00           H  
ATOM   1344 HG23 VAL A  85      -4.580   9.079  -7.872  1.00  0.00           H  
ATOM   1345  N   VAL A  86      -1.717   9.431  -3.711  1.00  0.00           N  
ATOM   1346  CA  VAL A  86      -1.917   8.989  -2.340  1.00  0.00           C  
ATOM   1347  C   VAL A  86      -2.992   9.850  -1.679  1.00  0.00           C  
ATOM   1348  O   VAL A  86      -3.111  11.035  -1.981  1.00  0.00           O  
ATOM   1349  CB  VAL A  86      -0.594   9.056  -1.531  1.00  0.00           C  
ATOM   1350  CG1 VAL A  86       0.069  10.413  -1.684  1.00  0.00           C  
ATOM   1351  CG2 VAL A  86      -0.820   8.733  -0.058  1.00  0.00           C  
ATOM   1352  H   VAL A  86      -1.576  10.389  -3.882  1.00  0.00           H  
ATOM   1353  HA  VAL A  86      -2.254   7.962  -2.366  1.00  0.00           H  
ATOM   1354  HB  VAL A  86       0.082   8.312  -1.935  1.00  0.00           H  
ATOM   1355 HG11 VAL A  86      -0.014  10.742  -2.709  1.00  0.00           H  
ATOM   1356 HG12 VAL A  86      -0.420  11.127  -1.037  1.00  0.00           H  
ATOM   1357 HG13 VAL A  86       1.111  10.340  -1.413  1.00  0.00           H  
ATOM   1358 HG21 VAL A  86      -1.878   8.632   0.129  1.00  0.00           H  
ATOM   1359 HG22 VAL A  86      -0.319   7.806   0.188  1.00  0.00           H  
ATOM   1360 HG23 VAL A  86      -0.420   9.532   0.551  1.00  0.00           H  
ATOM   1361  N   VAL A  87      -3.793   9.248  -0.812  1.00  0.00           N  
ATOM   1362  CA  VAL A  87      -4.871   9.965  -0.146  1.00  0.00           C  
ATOM   1363  C   VAL A  87      -4.586  10.105   1.347  1.00  0.00           C  
ATOM   1364  O   VAL A  87      -4.028   9.200   1.969  1.00  0.00           O  
ATOM   1365  CB  VAL A  87      -6.236   9.266  -0.347  1.00  0.00           C  
ATOM   1366  CG1 VAL A  87      -6.737   9.463  -1.770  1.00  0.00           C  
ATOM   1367  CG2 VAL A  87      -6.143   7.785  -0.015  1.00  0.00           C  
ATOM   1368  H   VAL A  87      -3.664   8.291  -0.625  1.00  0.00           H  
ATOM   1369  HA  VAL A  87      -4.929  10.953  -0.583  1.00  0.00           H  
ATOM   1370  HB  VAL A  87      -6.948   9.720   0.325  1.00  0.00           H  
ATOM   1371 HG11 VAL A  87      -5.966   9.170  -2.468  1.00  0.00           H  
ATOM   1372 HG12 VAL A  87      -7.615   8.853  -1.929  1.00  0.00           H  
ATOM   1373 HG13 VAL A  87      -6.987  10.501  -1.924  1.00  0.00           H  
ATOM   1374 HG21 VAL A  87      -5.322   7.344  -0.561  1.00  0.00           H  
ATOM   1375 HG22 VAL A  87      -5.977   7.664   1.045  1.00  0.00           H  
ATOM   1376 HG23 VAL A  87      -7.067   7.296  -0.292  1.00  0.00           H  
ATOM   1377  N   PHE A  88      -4.944  11.251   1.912  1.00  0.00           N  
ATOM   1378  CA  PHE A  88      -4.700  11.520   3.326  1.00  0.00           C  
ATOM   1379  C   PHE A  88      -6.014  11.502   4.110  1.00  0.00           C  
ATOM   1380  O   PHE A  88      -7.081  11.694   3.528  1.00  0.00           O  
ATOM   1381  CB  PHE A  88      -3.987  12.871   3.487  1.00  0.00           C  
ATOM   1382  CG  PHE A  88      -3.075  12.919   4.678  1.00  0.00           C  
ATOM   1383  CD1 PHE A  88      -2.248  11.849   4.972  1.00  0.00           C  
ATOM   1384  CD2 PHE A  88      -3.065  14.017   5.521  1.00  0.00           C  
ATOM   1385  CE1 PHE A  88      -1.429  11.872   6.078  1.00  0.00           C  
ATOM   1386  CE2 PHE A  88      -2.254  14.040   6.632  1.00  0.00           C  
ATOM   1387  CZ  PHE A  88      -1.437  12.966   6.912  1.00  0.00           C  
ATOM   1388  H   PHE A  88      -5.370  11.943   1.360  1.00  0.00           H  
ATOM   1389  HA  PHE A  88      -4.059  10.737   3.706  1.00  0.00           H  
ATOM   1390  HB2 PHE A  88      -3.394  13.065   2.606  1.00  0.00           H  
ATOM   1391  HB3 PHE A  88      -4.726  13.651   3.600  1.00  0.00           H  
ATOM   1392  HD1 PHE A  88      -2.231  10.993   4.312  1.00  0.00           H  
ATOM   1393  HD2 PHE A  88      -3.694  14.867   5.304  1.00  0.00           H  
ATOM   1394  HE1 PHE A  88      -0.789  11.030   6.295  1.00  0.00           H  
ATOM   1395  HE2 PHE A  88      -2.257  14.902   7.284  1.00  0.00           H  
ATOM   1396  HZ  PHE A  88      -0.801  12.984   7.786  1.00  0.00           H  
ATOM   1397  N   CYS A  89      -5.925  11.282   5.430  1.00  0.00           N  
ATOM   1398  CA  CYS A  89      -7.101  11.247   6.312  1.00  0.00           C  
ATOM   1399  C   CYS A  89      -7.990  10.036   6.013  1.00  0.00           C  
ATOM   1400  O   CYS A  89      -9.118  10.170   5.537  1.00  0.00           O  
ATOM   1401  CB  CYS A  89      -7.898  12.546   6.210  1.00  0.00           C  
ATOM   1402  SG  CYS A  89      -7.573  13.705   7.577  1.00  0.00           S  
ATOM   1403  H   CYS A  89      -5.047  11.156   5.839  1.00  0.00           H  
ATOM   1404  HA  CYS A  89      -6.733  11.150   7.324  1.00  0.00           H  
ATOM   1405  HB2 CYS A  89      -7.646  13.044   5.286  1.00  0.00           H  
ATOM   1406  HB3 CYS A  89      -8.953  12.315   6.216  1.00  0.00           H  
ATOM   1407  N   LYS A  90      -7.426   8.848   6.213  1.00  0.00           N  
ATOM   1408  CA  LYS A  90      -8.095   7.594   5.871  1.00  0.00           C  
ATOM   1409  C   LYS A  90      -9.391   7.363   6.657  1.00  0.00           C  
ATOM   1410  O   LYS A  90     -10.363   6.847   6.101  1.00  0.00           O  
ATOM   1411  CB  LYS A  90      -7.142   6.409   6.093  1.00  0.00           C  
ATOM   1412  CG  LYS A  90      -6.460   6.399   7.453  1.00  0.00           C  
ATOM   1413  CD  LYS A  90      -6.918   5.219   8.299  1.00  0.00           C  
ATOM   1414  CE  LYS A  90      -5.880   4.839   9.342  1.00  0.00           C  
ATOM   1415  NZ  LYS A  90      -6.068   5.572  10.623  1.00  0.00           N  
ATOM   1416  H   LYS A  90      -6.499   8.814   6.530  1.00  0.00           H  
ATOM   1417  HA  LYS A  90      -8.342   7.638   4.822  1.00  0.00           H  
ATOM   1418  HB2 LYS A  90      -7.702   5.492   5.992  1.00  0.00           H  
ATOM   1419  HB3 LYS A  90      -6.377   6.435   5.333  1.00  0.00           H  
ATOM   1420  HG2 LYS A  90      -5.390   6.332   7.311  1.00  0.00           H  
ATOM   1421  HG3 LYS A  90      -6.699   7.316   7.973  1.00  0.00           H  
ATOM   1422  HD2 LYS A  90      -7.837   5.485   8.800  1.00  0.00           H  
ATOM   1423  HD3 LYS A  90      -7.090   4.373   7.650  1.00  0.00           H  
ATOM   1424  HE2 LYS A  90      -5.953   3.779   9.533  1.00  0.00           H  
ATOM   1425  HE3 LYS A  90      -4.897   5.064   8.951  1.00  0.00           H  
ATOM   1426  HZ1 LYS A  90      -7.039   5.444  10.977  1.00  0.00           H  
ATOM   1427  HZ2 LYS A  90      -5.403   5.212  11.346  1.00  0.00           H  
ATOM   1428  HZ3 LYS A  90      -5.893   6.592  10.489  1.00  0.00           H  
ATOM   1429  N   THR A  91      -9.325   7.520   7.970  1.00  0.00           N  
ATOM   1430  CA  THR A  91     -10.407   7.084   8.842  1.00  0.00           C  
ATOM   1431  C   THR A  91     -11.616   8.024   8.827  1.00  0.00           C  
ATOM   1432  O   THR A  91     -12.615   7.735   8.161  1.00  0.00           O  
ATOM   1433  CB  THR A  91      -9.891   6.911  10.279  1.00  0.00           C  
ATOM   1434  OG1 THR A  91      -8.481   7.180  10.315  1.00  0.00           O  
ATOM   1435  CG2 THR A  91     -10.156   5.502  10.787  1.00  0.00           C  
ATOM   1436  H   THR A  91      -8.469   7.774   8.379  1.00  0.00           H  
ATOM   1437  HA  THR A  91     -10.729   6.114   8.493  1.00  0.00           H  
ATOM   1438  HB  THR A  91     -10.403   7.615  10.919  1.00  0.00           H  
ATOM   1439  HG1 THR A  91      -8.296   7.824  11.017  1.00  0.00           H  
ATOM   1440 HG21 THR A  91     -10.193   4.820   9.950  1.00  0.00           H  
ATOM   1441 HG22 THR A  91      -9.361   5.208  11.458  1.00  0.00           H  
ATOM   1442 HG23 THR A  91     -11.099   5.479  11.313  1.00  0.00           H  
ATOM   1443  N   ALA A  92     -11.579   9.059   9.662  1.00  0.00           N  
ATOM   1444  CA  ALA A  92     -12.731   9.944   9.858  1.00  0.00           C  
ATOM   1445  C   ALA A  92     -13.221  10.547   8.543  1.00  0.00           C  
ATOM   1446  O   ALA A  92     -14.393  10.405   8.179  1.00  0.00           O  
ATOM   1447  CB  ALA A  92     -12.383  11.046  10.848  1.00  0.00           C  
ATOM   1448  H   ALA A  92     -10.793   9.175  10.240  1.00  0.00           H  
ATOM   1449  HA  ALA A  92     -13.529   9.354  10.285  1.00  0.00           H  
ATOM   1450  HB1 ALA A  92     -11.429  11.478  10.584  1.00  0.00           H  
ATOM   1451  HB2 ALA A  92     -13.145  11.809  10.819  1.00  0.00           H  
ATOM   1452  HB3 ALA A  92     -12.326  10.629  11.844  1.00  0.00           H  
ATOM   1453  N   ALA A  93     -12.322  11.231   7.846  1.00  0.00           N  
ATOM   1454  CA  ALA A  93     -12.646  11.879   6.579  1.00  0.00           C  
ATOM   1455  C   ALA A  93     -13.013  10.856   5.508  1.00  0.00           C  
ATOM   1456  O   ALA A  93     -13.783  11.155   4.587  1.00  0.00           O  
ATOM   1457  CB  ALA A  93     -11.481  12.731   6.125  1.00  0.00           C  
ATOM   1458  H   ALA A  93     -11.411  11.314   8.199  1.00  0.00           H  
ATOM   1459  HA  ALA A  93     -13.494  12.528   6.745  1.00  0.00           H  
ATOM   1460  HB1 ALA A  93     -10.804  12.882   6.952  1.00  0.00           H  
ATOM   1461  HB2 ALA A  93     -10.962  12.232   5.320  1.00  0.00           H  
ATOM   1462  HB3 ALA A  93     -11.847  13.687   5.779  1.00  0.00           H  
ATOM   1463  N   ARG A  94     -12.474   9.647   5.662  1.00  0.00           N  
ATOM   1464  CA  ARG A  94     -12.735   8.531   4.757  1.00  0.00           C  
ATOM   1465  C   ARG A  94     -11.995   8.695   3.437  1.00  0.00           C  
ATOM   1466  O   ARG A  94     -12.597   8.599   2.364  1.00  0.00           O  
ATOM   1467  CB  ARG A  94     -14.242   8.349   4.502  1.00  0.00           C  
ATOM   1468  CG  ARG A  94     -14.803   7.002   4.947  1.00  0.00           C  
ATOM   1469  CD  ARG A  94     -13.720   5.945   5.108  1.00  0.00           C  
ATOM   1470  NE  ARG A  94     -13.427   5.677   6.517  1.00  0.00           N  
ATOM   1471  CZ  ARG A  94     -13.306   4.457   7.042  1.00  0.00           C  
ATOM   1472  NH1 ARG A  94     -13.439   3.378   6.277  1.00  0.00           N  
ATOM   1473  NH2 ARG A  94     -13.046   4.320   8.338  1.00  0.00           N  
ATOM   1474  H   ARG A  94     -11.888   9.497   6.432  1.00  0.00           H  
ATOM   1475  HA  ARG A  94     -12.363   7.639   5.240  1.00  0.00           H  
ATOM   1476  HB2 ARG A  94     -14.778   9.123   5.030  1.00  0.00           H  
ATOM   1477  HB3 ARG A  94     -14.426   8.457   3.443  1.00  0.00           H  
ATOM   1478  HG2 ARG A  94     -15.305   7.129   5.894  1.00  0.00           H  
ATOM   1479  HG3 ARG A  94     -15.515   6.662   4.207  1.00  0.00           H  
ATOM   1480  HD2 ARG A  94     -14.051   5.031   4.638  1.00  0.00           H  
ATOM   1481  HD3 ARG A  94     -12.819   6.293   4.622  1.00  0.00           H  
ATOM   1482  HE  ARG A  94     -13.313   6.462   7.108  1.00  0.00           H  
ATOM   1483 HH11 ARG A  94     -13.633   3.477   5.300  1.00  0.00           H  
ATOM   1484 HH12 ARG A  94     -13.341   2.458   6.671  1.00  0.00           H  
ATOM   1485 HH21 ARG A  94     -12.943   5.129   8.920  1.00  0.00           H  
ATOM   1486 HH22 ARG A  94     -12.955   3.406   8.743  1.00  0.00           H  
ATOM   1487  N   ALA A  95     -10.669   8.800   3.515  1.00  0.00           N  
ATOM   1488  CA  ALA A  95      -9.832   8.807   2.317  1.00  0.00           C  
ATOM   1489  C   ALA A  95      -9.949   7.476   1.596  1.00  0.00           C  
ATOM   1490  O   ALA A  95      -9.702   7.377   0.398  1.00  0.00           O  
ATOM   1491  CB  ALA A  95      -8.378   9.082   2.663  1.00  0.00           C  
ATOM   1492  H   ALA A  95     -10.239   8.774   4.397  1.00  0.00           H  
ATOM   1493  HA  ALA A  95     -10.183   9.595   1.666  1.00  0.00           H  
ATOM   1494  HB1 ALA A  95      -8.077   8.452   3.488  1.00  0.00           H  
ATOM   1495  HB2 ALA A  95      -7.759   8.869   1.804  1.00  0.00           H  
ATOM   1496  HB3 ALA A  95      -8.263  10.117   2.940  1.00  0.00           H  
ATOM   1497  N   ALA A  96     -10.380   6.463   2.338  1.00  0.00           N  
ATOM   1498  CA  ALA A  96     -10.602   5.140   1.783  1.00  0.00           C  
ATOM   1499  C   ALA A  96     -11.631   5.193   0.656  1.00  0.00           C  
ATOM   1500  O   ALA A  96     -11.507   4.481  -0.331  1.00  0.00           O  
ATOM   1501  CB  ALA A  96     -11.054   4.180   2.871  1.00  0.00           C  
ATOM   1502  H   ALA A  96     -10.579   6.627   3.283  1.00  0.00           H  
ATOM   1503  HA  ALA A  96      -9.663   4.783   1.384  1.00  0.00           H  
ATOM   1504  HB1 ALA A  96     -11.116   4.709   3.812  1.00  0.00           H  
ATOM   1505  HB2 ALA A  96     -12.025   3.779   2.619  1.00  0.00           H  
ATOM   1506  HB3 ALA A  96     -10.343   3.372   2.958  1.00  0.00           H  
ATOM   1507  N   LEU A  97     -12.606   6.092   0.780  1.00  0.00           N  
ATOM   1508  CA  LEU A  97     -13.602   6.277  -0.272  1.00  0.00           C  
ATOM   1509  C   LEU A  97     -12.994   7.012  -1.451  1.00  0.00           C  
ATOM   1510  O   LEU A  97     -13.438   6.853  -2.578  1.00  0.00           O  
ATOM   1511  CB  LEU A  97     -14.819   7.057   0.240  1.00  0.00           C  
ATOM   1512  CG  LEU A  97     -16.033   6.204   0.625  1.00  0.00           C  
ATOM   1513  CD1 LEU A  97     -16.690   5.617  -0.616  1.00  0.00           C  
ATOM   1514  CD2 LEU A  97     -15.633   5.100   1.590  1.00  0.00           C  
ATOM   1515  H   LEU A  97     -12.625   6.676   1.566  1.00  0.00           H  
ATOM   1516  HA  LEU A  97     -13.923   5.299  -0.599  1.00  0.00           H  
ATOM   1517  HB2 LEU A  97     -14.516   7.629   1.105  1.00  0.00           H  
ATOM   1518  HB3 LEU A  97     -15.127   7.747  -0.541  1.00  0.00           H  
ATOM   1519  HG  LEU A  97     -16.759   6.832   1.120  1.00  0.00           H  
ATOM   1520 HD11 LEU A  97     -16.183   5.978  -1.498  1.00  0.00           H  
ATOM   1521 HD12 LEU A  97     -16.629   4.540  -0.580  1.00  0.00           H  
ATOM   1522 HD13 LEU A  97     -17.729   5.917  -0.650  1.00  0.00           H  
ATOM   1523 HD21 LEU A  97     -14.578   4.887   1.479  1.00  0.00           H  
ATOM   1524 HD22 LEU A  97     -15.831   5.417   2.604  1.00  0.00           H  
ATOM   1525 HD23 LEU A  97     -16.203   4.208   1.373  1.00  0.00           H  
ATOM   1526  N   ALA A  98     -12.021   7.868  -1.167  1.00  0.00           N  
ATOM   1527  CA  ALA A  98     -11.386   8.686  -2.188  1.00  0.00           C  
ATOM   1528  C   ALA A  98     -10.414   7.875  -3.039  1.00  0.00           C  
ATOM   1529  O   ALA A  98     -10.255   8.129  -4.231  1.00  0.00           O  
ATOM   1530  CB  ALA A  98     -10.662   9.853  -1.537  1.00  0.00           C  
ATOM   1531  H   ALA A  98     -11.751   7.990  -0.236  1.00  0.00           H  
ATOM   1532  HA  ALA A  98     -12.162   9.086  -2.824  1.00  0.00           H  
ATOM   1533  HB1 ALA A  98     -10.200   9.523  -0.618  1.00  0.00           H  
ATOM   1534  HB2 ALA A  98      -9.904  10.225  -2.208  1.00  0.00           H  
ATOM   1535  HB3 ALA A  98     -11.369  10.641  -1.320  1.00  0.00           H  
ATOM   1536  N   GLY A  99      -9.664   6.999  -2.385  1.00  0.00           N  
ATOM   1537  CA  GLY A  99      -8.599   6.287  -3.066  1.00  0.00           C  
ATOM   1538  C   GLY A  99      -9.024   4.939  -3.614  1.00  0.00           C  
ATOM   1539  O   GLY A  99      -8.632   4.563  -4.721  1.00  0.00           O  
ATOM   1540  H   GLY A  99      -9.764   6.920  -1.410  1.00  0.00           H  
ATOM   1541  HA2 GLY A  99      -8.246   6.896  -3.884  1.00  0.00           H  
ATOM   1542  HA3 GLY A  99      -7.786   6.138  -2.372  1.00  0.00           H  
ATOM   1543  N   LYS A 100      -9.727   4.160  -2.799  1.00  0.00           N  
ATOM   1544  CA  LYS A 100     -10.085   2.792  -3.172  1.00  0.00           C  
ATOM   1545  C   LYS A 100     -11.000   2.774  -4.394  1.00  0.00           C  
ATOM   1546  O   LYS A 100     -10.998   1.817  -5.168  1.00  0.00           O  
ATOM   1547  CB  LYS A 100     -10.726   2.053  -1.988  1.00  0.00           C  
ATOM   1548  CG  LYS A 100     -12.245   1.956  -2.045  1.00  0.00           C  
ATOM   1549  CD  LYS A 100     -12.770   0.920  -1.062  1.00  0.00           C  
ATOM   1550  CE  LYS A 100     -13.814   0.022  -1.702  1.00  0.00           C  
ATOM   1551  NZ  LYS A 100     -13.420  -0.415  -3.068  1.00  0.00           N  
ATOM   1552  H   LYS A 100      -9.934   4.483  -1.896  1.00  0.00           H  
ATOM   1553  HA  LYS A 100      -9.167   2.287  -3.434  1.00  0.00           H  
ATOM   1554  HB2 LYS A 100     -10.328   1.051  -1.952  1.00  0.00           H  
ATOM   1555  HB3 LYS A 100     -10.454   2.569  -1.078  1.00  0.00           H  
ATOM   1556  HG2 LYS A 100     -12.669   2.918  -1.800  1.00  0.00           H  
ATOM   1557  HG3 LYS A 100     -12.542   1.674  -3.045  1.00  0.00           H  
ATOM   1558  HD2 LYS A 100     -11.945   0.312  -0.722  1.00  0.00           H  
ATOM   1559  HD3 LYS A 100     -13.214   1.433  -0.222  1.00  0.00           H  
ATOM   1560  HE2 LYS A 100     -13.951  -0.851  -1.082  1.00  0.00           H  
ATOM   1561  HE3 LYS A 100     -14.747   0.565  -1.764  1.00  0.00           H  
ATOM   1562  HZ1 LYS A 100     -12.392  -0.602  -3.108  1.00  0.00           H  
ATOM   1563  HZ2 LYS A 100     -13.928  -1.291  -3.323  1.00  0.00           H  
ATOM   1564  HZ3 LYS A 100     -13.659   0.325  -3.763  1.00  0.00           H  
ATOM   1565  N   THR A 101     -11.706   3.872  -4.608  1.00  0.00           N  
ATOM   1566  CA  THR A 101     -12.539   4.036  -5.770  1.00  0.00           C  
ATOM   1567  C   THR A 101     -11.691   4.100  -7.026  1.00  0.00           C  
ATOM   1568  O   THR A 101     -11.996   3.464  -8.030  1.00  0.00           O  
ATOM   1569  CB  THR A 101     -13.298   5.347  -5.646  1.00  0.00           C  
ATOM   1570  OG1 THR A 101     -12.532   6.232  -4.831  1.00  0.00           O  
ATOM   1571  CG2 THR A 101     -14.677   5.144  -5.046  1.00  0.00           C  
ATOM   1572  H   THR A 101     -11.619   4.631  -3.999  1.00  0.00           H  
ATOM   1573  HA  THR A 101     -13.242   3.220  -5.827  1.00  0.00           H  
ATOM   1574  HB  THR A 101     -13.397   5.773  -6.619  1.00  0.00           H  
ATOM   1575  HG1 THR A 101     -13.084   6.566  -4.109  1.00  0.00           H  
ATOM   1576 HG21 THR A 101     -14.606   4.483  -4.195  1.00  0.00           H  
ATOM   1577 HG22 THR A 101     -15.075   6.098  -4.731  1.00  0.00           H  
ATOM   1578 HG23 THR A 101     -15.330   4.708  -5.786  1.00  0.00           H  
ATOM   1579  N   LEU A 102     -10.674   4.949  -6.978  1.00  0.00           N  
ATOM   1580  CA  LEU A 102      -9.825   5.206  -8.126  1.00  0.00           C  
ATOM   1581  C   LEU A 102      -9.162   3.924  -8.629  1.00  0.00           C  
ATOM   1582  O   LEU A 102      -9.122   3.665  -9.833  1.00  0.00           O  
ATOM   1583  CB  LEU A 102      -8.768   6.254  -7.777  1.00  0.00           C  
ATOM   1584  CG  LEU A 102      -9.291   7.691  -7.706  1.00  0.00           C  
ATOM   1585  CD1 LEU A 102      -8.171   8.656  -7.352  1.00  0.00           C  
ATOM   1586  CD2 LEU A 102      -9.938   8.087  -9.022  1.00  0.00           C  
ATOM   1587  H   LEU A 102     -10.533   5.472  -6.156  1.00  0.00           H  
ATOM   1588  HA  LEU A 102     -10.459   5.603  -8.905  1.00  0.00           H  
ATOM   1589  HB2 LEU A 102      -8.339   6.000  -6.818  1.00  0.00           H  
ATOM   1590  HB3 LEU A 102      -7.989   6.215  -8.522  1.00  0.00           H  
ATOM   1591  HG  LEU A 102     -10.042   7.755  -6.932  1.00  0.00           H  
ATOM   1592 HD11 LEU A 102      -7.269   8.367  -7.872  1.00  0.00           H  
ATOM   1593 HD12 LEU A 102      -8.452   9.656  -7.648  1.00  0.00           H  
ATOM   1594 HD13 LEU A 102      -7.997   8.631  -6.287  1.00  0.00           H  
ATOM   1595 HD21 LEU A 102      -9.799   7.295  -9.745  1.00  0.00           H  
ATOM   1596 HD22 LEU A 102     -10.994   8.250  -8.869  1.00  0.00           H  
ATOM   1597 HD23 LEU A 102      -9.482   8.995  -9.392  1.00  0.00           H  
ATOM   1598  N   ARG A 103      -8.691   3.091  -7.704  1.00  0.00           N  
ATOM   1599  CA  ARG A 103      -8.091   1.811  -8.078  1.00  0.00           C  
ATOM   1600  C   ARG A 103      -9.161   0.839  -8.568  1.00  0.00           C  
ATOM   1601  O   ARG A 103      -8.899  -0.003  -9.424  1.00  0.00           O  
ATOM   1602  CB  ARG A 103      -7.300   1.197  -6.916  1.00  0.00           C  
ATOM   1603  CG  ARG A 103      -7.949   1.374  -5.557  1.00  0.00           C  
ATOM   1604  CD  ARG A 103      -7.646   0.208  -4.639  1.00  0.00           C  
ATOM   1605  NE  ARG A 103      -8.697  -0.804  -4.671  1.00  0.00           N  
ATOM   1606  CZ  ARG A 103      -8.635  -1.929  -5.381  1.00  0.00           C  
ATOM   1607  NH1 ARG A 103      -7.545  -2.229  -6.079  1.00  0.00           N  
ATOM   1608  NH2 ARG A 103      -9.657  -2.774  -5.354  1.00  0.00           N  
ATOM   1609  H   ARG A 103      -8.785   3.324  -6.754  1.00  0.00           H  
ATOM   1610  HA  ARG A 103      -7.409   2.002  -8.895  1.00  0.00           H  
ATOM   1611  HB2 ARG A 103      -7.185   0.139  -7.096  1.00  0.00           H  
ATOM   1612  HB3 ARG A 103      -6.321   1.655  -6.884  1.00  0.00           H  
ATOM   1613  HG2 ARG A 103      -7.572   2.276  -5.106  1.00  0.00           H  
ATOM   1614  HG3 ARG A 103      -9.017   1.450  -5.683  1.00  0.00           H  
ATOM   1615  HD2 ARG A 103      -6.714  -0.239  -4.946  1.00  0.00           H  
ATOM   1616  HD3 ARG A 103      -7.551   0.582  -3.632  1.00  0.00           H  
ATOM   1617  HE  ARG A 103      -9.508  -0.635  -4.126  1.00  0.00           H  
ATOM   1618 HH11 ARG A 103      -6.750  -1.608  -6.074  1.00  0.00           H  
ATOM   1619 HH12 ARG A 103      -7.506  -3.079  -6.613  1.00  0.00           H  
ATOM   1620 HH21 ARG A 103     -10.468  -2.566  -4.795  1.00  0.00           H  
ATOM   1621 HH22 ARG A 103      -9.631  -3.618  -5.896  1.00  0.00           H  
ATOM   1622  N   GLU A 104     -10.386   1.025  -8.085  1.00  0.00           N  
ATOM   1623  CA  GLU A 104     -11.524   0.230  -8.536  1.00  0.00           C  
ATOM   1624  C   GLU A 104     -11.966   0.663  -9.935  1.00  0.00           C  
ATOM   1625  O   GLU A 104     -12.749  -0.027 -10.590  1.00  0.00           O  
ATOM   1626  CB  GLU A 104     -12.694   0.364  -7.559  1.00  0.00           C  
ATOM   1627  CG  GLU A 104     -12.839  -0.818  -6.617  1.00  0.00           C  
ATOM   1628  CD  GLU A 104     -14.286  -1.211  -6.392  1.00  0.00           C  
ATOM   1629  OE1 GLU A 104     -15.149  -0.310  -6.324  1.00  0.00           O  
ATOM   1630  OE2 GLU A 104     -14.566  -2.424  -6.262  1.00  0.00           O  
ATOM   1631  H   GLU A 104     -10.542   1.757  -7.450  1.00  0.00           H  
ATOM   1632  HA  GLU A 104     -11.214  -0.804  -8.574  1.00  0.00           H  
ATOM   1633  HB2 GLU A 104     -12.552   1.256  -6.965  1.00  0.00           H  
ATOM   1634  HB3 GLU A 104     -13.610   0.463  -8.123  1.00  0.00           H  
ATOM   1635  HG2 GLU A 104     -12.315  -1.664  -7.037  1.00  0.00           H  
ATOM   1636  HG3 GLU A 104     -12.400  -0.560  -5.665  1.00  0.00           H  
ATOM   1637  N   TYR A 105     -11.405   1.770 -10.412  1.00  0.00           N  
ATOM   1638  CA  TYR A 105     -11.687   2.247 -11.761  1.00  0.00           C  
ATOM   1639  C   TYR A 105     -10.549   1.853 -12.697  1.00  0.00           C  
ATOM   1640  O   TYR A 105     -10.786   1.373 -13.805  1.00  0.00           O  
ATOM   1641  CB  TYR A 105     -11.891   3.767 -11.773  1.00  0.00           C  
ATOM   1642  CG  TYR A 105     -13.014   4.240 -10.867  1.00  0.00           C  
ATOM   1643  CD1 TYR A 105     -14.125   3.437 -10.618  1.00  0.00           C  
ATOM   1644  CD2 TYR A 105     -12.955   5.485 -10.250  1.00  0.00           C  
ATOM   1645  CE1 TYR A 105     -15.142   3.865  -9.784  1.00  0.00           C  
ATOM   1646  CE2 TYR A 105     -13.968   5.916  -9.414  1.00  0.00           C  
ATOM   1647  CZ  TYR A 105     -15.057   5.101  -9.184  1.00  0.00           C  
ATOM   1648  OH  TYR A 105     -16.063   5.522  -8.347  1.00  0.00           O  
ATOM   1649  H   TYR A 105     -10.741   2.242  -9.867  1.00  0.00           H  
ATOM   1650  HA  TYR A 105     -12.594   1.768 -12.097  1.00  0.00           H  
ATOM   1651  HB2 TYR A 105     -10.979   4.248 -11.453  1.00  0.00           H  
ATOM   1652  HB3 TYR A 105     -12.124   4.081 -12.782  1.00  0.00           H  
ATOM   1653  HD1 TYR A 105     -14.188   2.467 -11.088  1.00  0.00           H  
ATOM   1654  HD2 TYR A 105     -12.101   6.121 -10.431  1.00  0.00           H  
ATOM   1655  HE1 TYR A 105     -15.999   3.230  -9.604  1.00  0.00           H  
ATOM   1656  HE2 TYR A 105     -13.906   6.889  -8.948  1.00  0.00           H  
ATOM   1657  HH  TYR A 105     -15.895   5.193  -7.460  1.00  0.00           H  
ATOM   1658  N   GLY A 106      -9.319   1.973 -12.212  1.00  0.00           N  
ATOM   1659  CA  GLY A 106      -8.178   1.529 -12.992  1.00  0.00           C  
ATOM   1660  C   GLY A 106      -6.954   2.400 -12.808  1.00  0.00           C  
ATOM   1661  O   GLY A 106      -6.221   2.653 -13.763  1.00  0.00           O  
ATOM   1662  H   GLY A 106      -9.192   2.303 -11.296  1.00  0.00           H  
ATOM   1663  HA2 GLY A 106      -7.932   0.519 -12.700  1.00  0.00           H  
ATOM   1664  HA3 GLY A 106      -8.452   1.528 -14.037  1.00  0.00           H  
ATOM   1665  N   PHE A 107      -6.690   2.814 -11.577  1.00  0.00           N  
ATOM   1666  CA  PHE A 107      -5.505   3.606 -11.286  1.00  0.00           C  
ATOM   1667  C   PHE A 107      -4.322   2.697 -10.982  1.00  0.00           C  
ATOM   1668  O   PHE A 107      -4.485   1.638 -10.378  1.00  0.00           O  
ATOM   1669  CB  PHE A 107      -5.763   4.558 -10.116  1.00  0.00           C  
ATOM   1670  CG  PHE A 107      -6.184   5.931 -10.556  1.00  0.00           C  
ATOM   1671  CD1 PHE A 107      -7.339   6.107 -11.296  1.00  0.00           C  
ATOM   1672  CD2 PHE A 107      -5.424   7.043 -10.231  1.00  0.00           C  
ATOM   1673  CE1 PHE A 107      -7.735   7.363 -11.704  1.00  0.00           C  
ATOM   1674  CE2 PHE A 107      -5.814   8.306 -10.637  1.00  0.00           C  
ATOM   1675  CZ  PHE A 107      -6.971   8.465 -11.377  1.00  0.00           C  
ATOM   1676  H   PHE A 107      -7.281   2.549 -10.844  1.00  0.00           H  
ATOM   1677  HA  PHE A 107      -5.275   4.188 -12.168  1.00  0.00           H  
ATOM   1678  HB2 PHE A 107      -6.548   4.152  -9.497  1.00  0.00           H  
ATOM   1679  HB3 PHE A 107      -4.860   4.655  -9.530  1.00  0.00           H  
ATOM   1680  HD1 PHE A 107      -7.938   5.246 -11.554  1.00  0.00           H  
ATOM   1681  HD2 PHE A 107      -4.521   6.917  -9.653  1.00  0.00           H  
ATOM   1682  HE1 PHE A 107      -8.640   7.483 -12.280  1.00  0.00           H  
ATOM   1683  HE2 PHE A 107      -5.214   9.166 -10.381  1.00  0.00           H  
ATOM   1684  HZ  PHE A 107      -7.279   9.452 -11.696  1.00  0.00           H  
ATOM   1685  N   LYS A 108      -3.159   3.067 -11.505  1.00  0.00           N  
ATOM   1686  CA  LYS A 108      -1.961   2.239 -11.402  1.00  0.00           C  
ATOM   1687  C   LYS A 108      -1.547   2.015  -9.947  1.00  0.00           C  
ATOM   1688  O   LYS A 108      -1.656   0.904  -9.425  1.00  0.00           O  
ATOM   1689  CB  LYS A 108      -0.812   2.881 -12.186  1.00  0.00           C  
ATOM   1690  CG  LYS A 108      -0.750   2.444 -13.640  1.00  0.00           C  
ATOM   1691  CD  LYS A 108       0.475   3.004 -14.341  1.00  0.00           C  
ATOM   1692  CE  LYS A 108       1.543   1.941 -14.542  1.00  0.00           C  
ATOM   1693  NZ  LYS A 108       2.890   2.436 -14.152  1.00  0.00           N  
ATOM   1694  H   LYS A 108      -3.125   3.884 -12.046  1.00  0.00           H  
ATOM   1695  HA  LYS A 108      -2.190   1.282 -11.846  1.00  0.00           H  
ATOM   1696  HB2 LYS A 108      -0.931   3.955 -12.160  1.00  0.00           H  
ATOM   1697  HB3 LYS A 108       0.122   2.620 -11.712  1.00  0.00           H  
ATOM   1698  HG2 LYS A 108      -0.714   1.365 -13.680  1.00  0.00           H  
ATOM   1699  HG3 LYS A 108      -1.638   2.794 -14.149  1.00  0.00           H  
ATOM   1700  HD2 LYS A 108       0.183   3.390 -15.307  1.00  0.00           H  
ATOM   1701  HD3 LYS A 108       0.886   3.805 -13.744  1.00  0.00           H  
ATOM   1702  HE2 LYS A 108       1.297   1.081 -13.935  1.00  0.00           H  
ATOM   1703  HE3 LYS A 108       1.558   1.654 -15.583  1.00  0.00           H  
ATOM   1704  HZ1 LYS A 108       3.080   3.355 -14.614  1.00  0.00           H  
ATOM   1705  HZ2 LYS A 108       2.942   2.565 -13.118  1.00  0.00           H  
ATOM   1706  HZ3 LYS A 108       3.624   1.756 -14.442  1.00  0.00           H  
ATOM   1707  N   THR A 109      -1.013   3.050  -9.318  1.00  0.00           N  
ATOM   1708  CA  THR A 109      -0.518   2.931  -7.955  1.00  0.00           C  
ATOM   1709  C   THR A 109      -1.148   3.980  -7.045  1.00  0.00           C  
ATOM   1710  O   THR A 109      -0.833   5.167  -7.131  1.00  0.00           O  
ATOM   1711  CB  THR A 109       1.017   3.065  -7.907  1.00  0.00           C  
ATOM   1712  OG1 THR A 109       1.590   2.616  -9.145  1.00  0.00           O  
ATOM   1713  CG2 THR A 109       1.590   2.255  -6.755  1.00  0.00           C  
ATOM   1714  H   THR A 109      -0.904   3.895  -9.793  1.00  0.00           H  
ATOM   1715  HA  THR A 109      -0.782   1.951  -7.590  1.00  0.00           H  
ATOM   1716  HB  THR A 109       1.271   4.106  -7.757  1.00  0.00           H  
ATOM   1717  HG1 THR A 109       2.213   1.895  -8.967  1.00  0.00           H  
ATOM   1718 HG21 THR A 109       0.913   1.449  -6.509  1.00  0.00           H  
ATOM   1719 HG22 THR A 109       2.547   1.845  -7.046  1.00  0.00           H  
ATOM   1720 HG23 THR A 109       1.719   2.894  -5.893  1.00  0.00           H  
ATOM   1721  N   ILE A 110      -2.043   3.528  -6.183  1.00  0.00           N  
ATOM   1722  CA  ILE A 110      -2.720   4.417  -5.257  1.00  0.00           C  
ATOM   1723  C   ILE A 110      -2.389   4.041  -3.813  1.00  0.00           C  
ATOM   1724  O   ILE A 110      -2.390   2.862  -3.446  1.00  0.00           O  
ATOM   1725  CB  ILE A 110      -4.253   4.412  -5.488  1.00  0.00           C  
ATOM   1726  CG1 ILE A 110      -4.892   5.653  -4.867  1.00  0.00           C  
ATOM   1727  CG2 ILE A 110      -4.900   3.147  -4.941  1.00  0.00           C  
ATOM   1728  CD1 ILE A 110      -5.852   6.359  -5.796  1.00  0.00           C  
ATOM   1729  H   ILE A 110      -2.252   2.571  -6.173  1.00  0.00           H  
ATOM   1730  HA  ILE A 110      -2.356   5.418  -5.443  1.00  0.00           H  
ATOM   1731  HB  ILE A 110      -4.424   4.432  -6.554  1.00  0.00           H  
ATOM   1732 HG12 ILE A 110      -5.440   5.365  -3.982  1.00  0.00           H  
ATOM   1733 HG13 ILE A 110      -4.116   6.353  -4.596  1.00  0.00           H  
ATOM   1734 HG21 ILE A 110      -4.544   2.964  -3.937  1.00  0.00           H  
ATOM   1735 HG22 ILE A 110      -5.976   3.269  -4.924  1.00  0.00           H  
ATOM   1736 HG23 ILE A 110      -4.644   2.310  -5.572  1.00  0.00           H  
ATOM   1737 HD11 ILE A 110      -5.981   5.772  -6.697  1.00  0.00           H  
ATOM   1738 HD12 ILE A 110      -6.805   6.481  -5.306  1.00  0.00           H  
ATOM   1739 HD13 ILE A 110      -5.455   7.330  -6.054  1.00  0.00           H  
ATOM   1740  N   TYR A 111      -2.044   5.035  -3.012  1.00  0.00           N  
ATOM   1741  CA  TYR A 111      -1.652   4.795  -1.631  1.00  0.00           C  
ATOM   1742  C   TYR A 111      -2.653   5.426  -0.673  1.00  0.00           C  
ATOM   1743  O   TYR A 111      -3.127   6.538  -0.904  1.00  0.00           O  
ATOM   1744  CB  TYR A 111      -0.257   5.371  -1.338  1.00  0.00           C  
ATOM   1745  CG  TYR A 111       0.767   5.181  -2.440  1.00  0.00           C  
ATOM   1746  CD1 TYR A 111       0.835   6.061  -3.518  1.00  0.00           C  
ATOM   1747  CD2 TYR A 111       1.675   4.130  -2.395  1.00  0.00           C  
ATOM   1748  CE1 TYR A 111       1.777   5.895  -4.515  1.00  0.00           C  
ATOM   1749  CE2 TYR A 111       2.622   3.961  -3.388  1.00  0.00           C  
ATOM   1750  CZ  TYR A 111       2.667   4.846  -4.445  1.00  0.00           C  
ATOM   1751  OH  TYR A 111       3.609   4.681  -5.439  1.00  0.00           O  
ATOM   1752  H   TYR A 111      -2.012   5.955  -3.361  1.00  0.00           H  
ATOM   1753  HA  TYR A 111      -1.635   3.727  -1.468  1.00  0.00           H  
ATOM   1754  HB2 TYR A 111      -0.349   6.431  -1.161  1.00  0.00           H  
ATOM   1755  HB3 TYR A 111       0.131   4.901  -0.445  1.00  0.00           H  
ATOM   1756  HD1 TYR A 111       0.135   6.884  -3.569  1.00  0.00           H  
ATOM   1757  HD2 TYR A 111       1.640   3.440  -1.560  1.00  0.00           H  
ATOM   1758  HE1 TYR A 111       1.813   6.589  -5.343  1.00  0.00           H  
ATOM   1759  HE2 TYR A 111       3.318   3.136  -3.335  1.00  0.00           H  
ATOM   1760  HH  TYR A 111       4.488   4.599  -5.043  1.00  0.00           H  
ATOM   1761  N   ASN A 112      -2.863   4.783   0.459  1.00  0.00           N  
ATOM   1762  CA  ASN A 112      -3.669   5.356   1.526  1.00  0.00           C  
ATOM   1763  C   ASN A 112      -2.768   5.641   2.711  1.00  0.00           C  
ATOM   1764  O   ASN A 112      -1.810   4.913   2.943  1.00  0.00           O  
ATOM   1765  CB  ASN A 112      -4.805   4.416   1.935  1.00  0.00           C  
ATOM   1766  CG  ASN A 112      -6.009   5.166   2.474  1.00  0.00           C  
ATOM   1767  OD1 ASN A 112      -5.876   6.089   3.275  1.00  0.00           O  
ATOM   1768  ND2 ASN A 112      -7.198   4.781   2.033  1.00  0.00           N  
ATOM   1769  H   ASN A 112      -2.376   3.944   0.629  1.00  0.00           H  
ATOM   1770  HA  ASN A 112      -4.084   6.288   1.170  1.00  0.00           H  
ATOM   1771  HB2 ASN A 112      -5.118   3.843   1.074  1.00  0.00           H  
ATOM   1772  HB3 ASN A 112      -4.449   3.741   2.699  1.00  0.00           H  
ATOM   1773 HD21 ASN A 112      -7.235   4.041   1.383  1.00  0.00           H  
ATOM   1774 HD22 ASN A 112      -7.989   5.247   2.376  1.00  0.00           H  
ATOM   1775  N   SER A 113      -2.998   6.747   3.385  1.00  0.00           N  
ATOM   1776  CA  SER A 113      -2.114   7.168   4.457  1.00  0.00           C  
ATOM   1777  C   SER A 113      -2.634   6.733   5.823  1.00  0.00           C  
ATOM   1778  O   SER A 113      -3.634   7.262   6.314  1.00  0.00           O  
ATOM   1779  CB  SER A 113      -1.943   8.679   4.425  1.00  0.00           C  
ATOM   1780  OG  SER A 113      -1.559   9.122   3.137  1.00  0.00           O  
ATOM   1781  H   SER A 113      -3.733   7.336   3.107  1.00  0.00           H  
ATOM   1782  HA  SER A 113      -1.153   6.706   4.290  1.00  0.00           H  
ATOM   1783  HB2 SER A 113      -2.880   9.148   4.688  1.00  0.00           H  
ATOM   1784  HB3 SER A 113      -1.182   8.969   5.135  1.00  0.00           H  
ATOM   1785  HG  SER A 113      -2.323   9.093   2.546  1.00  0.00           H  
ATOM   1786  N   GLU A 114      -1.918   5.801   6.445  1.00  0.00           N  
ATOM   1787  CA  GLU A 114      -2.255   5.327   7.779  1.00  0.00           C  
ATOM   1788  C   GLU A 114      -2.170   6.476   8.781  1.00  0.00           C  
ATOM   1789  O   GLU A 114      -1.424   7.437   8.580  1.00  0.00           O  
ATOM   1790  CB  GLU A 114      -1.318   4.186   8.189  1.00  0.00           C  
ATOM   1791  CG  GLU A 114      -1.680   3.533   9.514  1.00  0.00           C  
ATOM   1792  CD  GLU A 114      -2.578   2.323   9.354  1.00  0.00           C  
ATOM   1793  OE1 GLU A 114      -3.764   2.494   9.003  1.00  0.00           O  
ATOM   1794  OE2 GLU A 114      -2.107   1.193   9.599  1.00  0.00           O  
ATOM   1795  H   GLU A 114      -1.118   5.445   6.003  1.00  0.00           H  
ATOM   1796  HA  GLU A 114      -3.271   4.960   7.753  1.00  0.00           H  
ATOM   1797  HB2 GLU A 114      -1.341   3.425   7.423  1.00  0.00           H  
ATOM   1798  HB3 GLU A 114      -0.313   4.573   8.266  1.00  0.00           H  
ATOM   1799  HG2 GLU A 114      -0.770   3.222  10.007  1.00  0.00           H  
ATOM   1800  HG3 GLU A 114      -2.187   4.260  10.130  1.00  0.00           H  
ATOM   1801  N   GLY A 115      -2.986   6.406   9.814  1.00  0.00           N  
ATOM   1802  CA  GLY A 115      -3.046   7.476  10.780  1.00  0.00           C  
ATOM   1803  C   GLY A 115      -4.074   8.512  10.397  1.00  0.00           C  
ATOM   1804  O   GLY A 115      -5.277   8.250  10.455  1.00  0.00           O  
ATOM   1805  H   GLY A 115      -3.591   5.643   9.896  1.00  0.00           H  
ATOM   1806  HA2 GLY A 115      -3.302   7.064  11.746  1.00  0.00           H  
ATOM   1807  HA3 GLY A 115      -2.076   7.949  10.843  1.00  0.00           H  
ATOM   1808  N   GLY A 116      -3.604   9.673   9.979  1.00  0.00           N  
ATOM   1809  CA  GLY A 116      -4.493  10.736   9.568  1.00  0.00           C  
ATOM   1810  C   GLY A 116      -3.797  12.077   9.589  1.00  0.00           C  
ATOM   1811  O   GLY A 116      -2.567  12.133   9.599  1.00  0.00           O  
ATOM   1812  H   GLY A 116      -2.634   9.808   9.936  1.00  0.00           H  
ATOM   1813  HA2 GLY A 116      -4.844  10.536   8.567  1.00  0.00           H  
ATOM   1814  HA3 GLY A 116      -5.338  10.768  10.240  1.00  0.00           H  
ATOM   1815  N   MET A 117      -4.576  13.156   9.606  1.00  0.00           N  
ATOM   1816  CA  MET A 117      -4.022  14.511   9.634  1.00  0.00           C  
ATOM   1817  C   MET A 117      -3.174  14.721  10.883  1.00  0.00           C  
ATOM   1818  O   MET A 117      -2.175  15.446  10.859  1.00  0.00           O  
ATOM   1819  CB  MET A 117      -5.148  15.550   9.585  1.00  0.00           C  
ATOM   1820  CG  MET A 117      -4.679  16.943   9.188  1.00  0.00           C  
ATOM   1821  SD  MET A 117      -3.944  16.984   7.542  1.00  0.00           S  
ATOM   1822  CE  MET A 117      -5.397  17.246   6.526  1.00  0.00           C  
ATOM   1823  H   MET A 117      -5.551  13.041   9.605  1.00  0.00           H  
ATOM   1824  HA  MET A 117      -3.395  14.631   8.763  1.00  0.00           H  
ATOM   1825  HB2 MET A 117      -5.889  15.226   8.869  1.00  0.00           H  
ATOM   1826  HB3 MET A 117      -5.605  15.615  10.561  1.00  0.00           H  
ATOM   1827  HG2 MET A 117      -5.527  17.610   9.201  1.00  0.00           H  
ATOM   1828  HG3 MET A 117      -3.944  17.279   9.903  1.00  0.00           H  
ATOM   1829  HE1 MET A 117      -6.123  16.474   6.730  1.00  0.00           H  
ATOM   1830  HE2 MET A 117      -5.826  18.212   6.753  1.00  0.00           H  
ATOM   1831  HE3 MET A 117      -5.119  17.214   5.482  1.00  0.00           H  
ATOM   1832  N   ASP A 118      -3.571  14.062  11.964  1.00  0.00           N  
ATOM   1833  CA  ASP A 118      -2.858  14.150  13.229  1.00  0.00           C  
ATOM   1834  C   ASP A 118      -1.433  13.627  13.098  1.00  0.00           C  
ATOM   1835  O   ASP A 118      -0.522  14.134  13.751  1.00  0.00           O  
ATOM   1836  CB  ASP A 118      -3.616  13.381  14.322  1.00  0.00           C  
ATOM   1837  CG  ASP A 118      -3.321  11.889  14.331  1.00  0.00           C  
ATOM   1838  OD1 ASP A 118      -3.576  11.221  13.309  1.00  0.00           O  
ATOM   1839  OD2 ASP A 118      -2.842  11.378  15.369  1.00  0.00           O  
ATOM   1840  H   ASP A 118      -4.365  13.499  11.909  1.00  0.00           H  
ATOM   1841  HA  ASP A 118      -2.815  15.192  13.507  1.00  0.00           H  
ATOM   1842  HB2 ASP A 118      -3.345  13.784  15.286  1.00  0.00           H  
ATOM   1843  HB3 ASP A 118      -4.679  13.516  14.171  1.00  0.00           H  
ATOM   1844  N   LYS A 119      -1.236  12.618  12.255  1.00  0.00           N  
ATOM   1845  CA  LYS A 119       0.079  12.037  12.054  1.00  0.00           C  
ATOM   1846  C   LYS A 119       0.971  12.953  11.233  1.00  0.00           C  
ATOM   1847  O   LYS A 119       2.174  13.005  11.454  1.00  0.00           O  
ATOM   1848  CB  LYS A 119      -0.038  10.681  11.354  1.00  0.00           C  
ATOM   1849  CG  LYS A 119       0.211   9.499  12.274  1.00  0.00           C  
ATOM   1850  CD  LYS A 119      -1.051   9.115  13.026  1.00  0.00           C  
ATOM   1851  CE  LYS A 119      -0.732   8.534  14.390  1.00  0.00           C  
ATOM   1852  NZ  LYS A 119      -0.894   9.541  15.470  1.00  0.00           N  
ATOM   1853  H   LYS A 119      -1.990  12.240  11.751  1.00  0.00           H  
ATOM   1854  HA  LYS A 119       0.528  11.889  13.024  1.00  0.00           H  
ATOM   1855  HB2 LYS A 119      -1.031  10.585  10.942  1.00  0.00           H  
ATOM   1856  HB3 LYS A 119       0.682  10.642  10.549  1.00  0.00           H  
ATOM   1857  HG2 LYS A 119       0.538   8.657  11.683  1.00  0.00           H  
ATOM   1858  HG3 LYS A 119       0.979   9.764  12.987  1.00  0.00           H  
ATOM   1859  HD2 LYS A 119      -1.663   9.995  13.156  1.00  0.00           H  
ATOM   1860  HD3 LYS A 119      -1.593   8.380  12.449  1.00  0.00           H  
ATOM   1861  HE2 LYS A 119      -1.398   7.707  14.579  1.00  0.00           H  
ATOM   1862  HE3 LYS A 119       0.290   8.181  14.387  1.00  0.00           H  
ATOM   1863  HZ1 LYS A 119      -1.712  10.159  15.274  1.00  0.00           H  
ATOM   1864  HZ2 LYS A 119      -1.039   9.067  16.384  1.00  0.00           H  
ATOM   1865  HZ3 LYS A 119      -0.032  10.131  15.535  1.00  0.00           H  
ATOM   1866  N   TRP A 120       0.380  13.694  10.302  1.00  0.00           N  
ATOM   1867  CA  TRP A 120       1.155  14.614   9.481  1.00  0.00           C  
ATOM   1868  C   TRP A 120       1.790  15.690  10.353  1.00  0.00           C  
ATOM   1869  O   TRP A 120       3.005  15.894  10.309  1.00  0.00           O  
ATOM   1870  CB  TRP A 120       0.286  15.248   8.391  1.00  0.00           C  
ATOM   1871  CG  TRP A 120       1.082  15.794   7.246  1.00  0.00           C  
ATOM   1872  CD1 TRP A 120       1.530  17.068   7.119  1.00  0.00           C  
ATOM   1873  CD2 TRP A 120       1.515  15.099   6.062  1.00  0.00           C  
ATOM   1874  NE1 TRP A 120       2.247  17.206   5.957  1.00  0.00           N  
ATOM   1875  CE2 TRP A 120       2.244  16.017   5.287  1.00  0.00           C  
ATOM   1876  CE3 TRP A 120       1.368  13.794   5.589  1.00  0.00           C  
ATOM   1877  CZ2 TRP A 120       2.823  15.674   4.068  1.00  0.00           C  
ATOM   1878  CZ3 TRP A 120       1.939  13.454   4.377  1.00  0.00           C  
ATOM   1879  CH2 TRP A 120       2.660  14.391   3.629  1.00  0.00           C  
ATOM   1880  H   TRP A 120      -0.590  13.637  10.183  1.00  0.00           H  
ATOM   1881  HA  TRP A 120       1.945  14.043   9.011  1.00  0.00           H  
ATOM   1882  HB2 TRP A 120      -0.391  14.504   8.002  1.00  0.00           H  
ATOM   1883  HB3 TRP A 120      -0.284  16.059   8.819  1.00  0.00           H  
ATOM   1884  HD1 TRP A 120       1.352  17.841   7.845  1.00  0.00           H  
ATOM   1885  HE1 TRP A 120       2.688  18.028   5.655  1.00  0.00           H  
ATOM   1886  HE3 TRP A 120       0.814  13.055   6.152  1.00  0.00           H  
ATOM   1887  HZ2 TRP A 120       3.382  16.388   3.480  1.00  0.00           H  
ATOM   1888  HZ3 TRP A 120       1.833  12.448   3.995  1.00  0.00           H  
ATOM   1889  HH2 TRP A 120       3.090  14.083   2.688  1.00  0.00           H  
ATOM   1890  N   LEU A 121       0.971  16.376  11.146  1.00  0.00           N  
ATOM   1891  CA  LEU A 121       1.458  17.429  12.027  1.00  0.00           C  
ATOM   1892  C   LEU A 121       2.442  16.879  13.062  1.00  0.00           C  
ATOM   1893  O   LEU A 121       3.415  17.544  13.415  1.00  0.00           O  
ATOM   1894  CB  LEU A 121       0.275  18.088  12.752  1.00  0.00           C  
ATOM   1895  CG  LEU A 121      -0.420  19.238  12.011  1.00  0.00           C  
ATOM   1896  CD1 LEU A 121      -1.689  19.642  12.746  1.00  0.00           C  
ATOM   1897  CD2 LEU A 121       0.514  20.429  11.872  1.00  0.00           C  
ATOM   1898  H   LEU A 121       0.007  16.192  11.147  1.00  0.00           H  
ATOM   1899  HA  LEU A 121       1.960  18.169  11.421  1.00  0.00           H  
ATOM   1900  HB2 LEU A 121      -0.461  17.323  12.950  1.00  0.00           H  
ATOM   1901  HB3 LEU A 121       0.633  18.468  13.698  1.00  0.00           H  
ATOM   1902  HG  LEU A 121      -0.705  18.914  11.019  1.00  0.00           H  
ATOM   1903 HD11 LEU A 121      -1.484  19.715  13.803  1.00  0.00           H  
ATOM   1904 HD12 LEU A 121      -2.030  20.598  12.377  1.00  0.00           H  
ATOM   1905 HD13 LEU A 121      -2.453  18.899  12.576  1.00  0.00           H  
ATOM   1906 HD21 LEU A 121       1.197  20.449  12.709  1.00  0.00           H  
ATOM   1907 HD22 LEU A 121       1.072  20.342  10.953  1.00  0.00           H  
ATOM   1908 HD23 LEU A 121      -0.064  21.341  11.858  1.00  0.00           H  
ATOM   1909  N   GLU A 122       2.105  15.733  13.650  1.00  0.00           N  
ATOM   1910  CA  GLU A 122       2.880  15.197  14.767  1.00  0.00           C  
ATOM   1911  C   GLU A 122       4.214  14.588  14.320  1.00  0.00           C  
ATOM   1912  O   GLU A 122       5.185  14.606  15.075  1.00  0.00           O  
ATOM   1913  CB  GLU A 122       2.048  14.173  15.554  1.00  0.00           C  
ATOM   1914  CG  GLU A 122       2.445  12.722  15.327  1.00  0.00           C  
ATOM   1915  CD  GLU A 122       1.406  11.747  15.832  1.00  0.00           C  
ATOM   1916  OE1 GLU A 122       0.453  12.176  16.516  1.00  0.00           O  
ATOM   1917  OE2 GLU A 122       1.537  10.540  15.550  1.00  0.00           O  
ATOM   1918  H   GLU A 122       1.257  15.296  13.401  1.00  0.00           H  
ATOM   1919  HA  GLU A 122       3.100  16.025  15.424  1.00  0.00           H  
ATOM   1920  HB2 GLU A 122       2.150  14.384  16.608  1.00  0.00           H  
ATOM   1921  HB3 GLU A 122       1.010  14.283  15.276  1.00  0.00           H  
ATOM   1922  HG2 GLU A 122       2.582  12.563  14.269  1.00  0.00           H  
ATOM   1923  HG3 GLU A 122       3.377  12.532  15.842  1.00  0.00           H  
ATOM   1924  N   GLU A 123       4.249  13.996  13.131  1.00  0.00           N  
ATOM   1925  CA  GLU A 123       5.458  13.321  12.660  1.00  0.00           C  
ATOM   1926  C   GLU A 123       6.510  14.318  12.178  1.00  0.00           C  
ATOM   1927  O   GLU A 123       7.590  13.924  11.733  1.00  0.00           O  
ATOM   1928  CB  GLU A 123       5.125  12.327  11.548  1.00  0.00           C  
ATOM   1929  CG  GLU A 123       4.492  11.039  12.056  1.00  0.00           C  
ATOM   1930  CD  GLU A 123       5.437   9.861  11.998  1.00  0.00           C  
ATOM   1931  OE1 GLU A 123       6.464   9.880  12.708  1.00  0.00           O  
ATOM   1932  OE2 GLU A 123       5.165   8.909  11.237  1.00  0.00           O  
ATOM   1933  H   GLU A 123       3.434  13.964  12.584  1.00  0.00           H  
ATOM   1934  HA  GLU A 123       5.868  12.775  13.499  1.00  0.00           H  
ATOM   1935  HB2 GLU A 123       4.438  12.793  10.858  1.00  0.00           H  
ATOM   1936  HB3 GLU A 123       6.033  12.073  11.022  1.00  0.00           H  
ATOM   1937  HG2 GLU A 123       4.185  11.183  13.082  1.00  0.00           H  
ATOM   1938  HG3 GLU A 123       3.625  10.816  11.450  1.00  0.00           H  
ATOM   1939  N   GLY A 124       6.209  15.605  12.316  1.00  0.00           N  
ATOM   1940  CA  GLY A 124       7.158  16.637  11.944  1.00  0.00           C  
ATOM   1941  C   GLY A 124       7.191  16.877  10.451  1.00  0.00           C  
ATOM   1942  O   GLY A 124       8.154  17.431   9.919  1.00  0.00           O  
ATOM   1943  H   GLY A 124       5.349  15.857  12.713  1.00  0.00           H  
ATOM   1944  HA2 GLY A 124       6.886  17.557  12.439  1.00  0.00           H  
ATOM   1945  HA3 GLY A 124       8.143  16.342  12.272  1.00  0.00           H  
ATOM   1946  N   LEU A 125       6.145  16.437   9.771  1.00  0.00           N  
ATOM   1947  CA  LEU A 125       6.059  16.580   8.332  1.00  0.00           C  
ATOM   1948  C   LEU A 125       5.702  18.014   7.957  1.00  0.00           C  
ATOM   1949  O   LEU A 125       5.065  18.731   8.734  1.00  0.00           O  
ATOM   1950  CB  LEU A 125       5.023  15.609   7.767  1.00  0.00           C  
ATOM   1951  CG  LEU A 125       5.422  14.136   7.818  1.00  0.00           C  
ATOM   1952  CD1 LEU A 125       4.243  13.266   7.436  1.00  0.00           C  
ATOM   1953  CD2 LEU A 125       6.602  13.866   6.895  1.00  0.00           C  
ATOM   1954  H   LEU A 125       5.420  15.986  10.252  1.00  0.00           H  
ATOM   1955  HA  LEU A 125       7.026  16.343   7.916  1.00  0.00           H  
ATOM   1956  HB2 LEU A 125       4.105  15.732   8.323  1.00  0.00           H  
ATOM   1957  HB3 LEU A 125       4.839  15.874   6.736  1.00  0.00           H  
ATOM   1958  HG  LEU A 125       5.715  13.879   8.825  1.00  0.00           H  
ATOM   1959 HD11 LEU A 125       3.502  13.874   6.932  1.00  0.00           H  
ATOM   1960 HD12 LEU A 125       4.576  12.479   6.776  1.00  0.00           H  
ATOM   1961 HD13 LEU A 125       3.809  12.833   8.325  1.00  0.00           H  
ATOM   1962 HD21 LEU A 125       7.421  14.522   7.157  1.00  0.00           H  
ATOM   1963 HD22 LEU A 125       6.915  12.839   6.999  1.00  0.00           H  
ATOM   1964 HD23 LEU A 125       6.308  14.051   5.873  1.00  0.00           H  
ATOM   1965  N   PRO A 126       6.089  18.445   6.747  1.00  0.00           N  
ATOM   1966  CA  PRO A 126       5.796  19.793   6.245  1.00  0.00           C  
ATOM   1967  C   PRO A 126       4.303  20.077   6.219  1.00  0.00           C  
ATOM   1968  O   PRO A 126       3.563  19.503   5.417  1.00  0.00           O  
ATOM   1969  CB  PRO A 126       6.347  19.772   4.817  1.00  0.00           C  
ATOM   1970  CG  PRO A 126       6.431  18.326   4.475  1.00  0.00           C  
ATOM   1971  CD  PRO A 126       6.821  17.650   5.750  1.00  0.00           C  
ATOM   1972  HA  PRO A 126       6.301  20.552   6.823  1.00  0.00           H  
ATOM   1973  HB2 PRO A 126       5.669  20.297   4.159  1.00  0.00           H  
ATOM   1974  HB3 PRO A 126       7.319  20.240   4.796  1.00  0.00           H  
ATOM   1975  HG2 PRO A 126       5.463  17.969   4.137  1.00  0.00           H  
ATOM   1976  HG3 PRO A 126       7.182  18.165   3.717  1.00  0.00           H  
ATOM   1977  HD2 PRO A 126       6.493  16.621   5.753  1.00  0.00           H  
ATOM   1978  HD3 PRO A 126       7.887  17.715   5.907  1.00  0.00           H  
ATOM   1979  N   SER A 127       3.858  20.972   7.078  1.00  0.00           N  
ATOM   1980  CA  SER A 127       2.460  21.334   7.125  1.00  0.00           C  
ATOM   1981  C   SER A 127       2.312  22.834   6.914  1.00  0.00           C  
ATOM   1982  O   SER A 127       3.116  23.620   7.416  1.00  0.00           O  
ATOM   1983  CB  SER A 127       1.862  20.923   8.469  1.00  0.00           C  
ATOM   1984  OG  SER A 127       2.876  20.503   9.370  1.00  0.00           O  
ATOM   1985  H   SER A 127       4.477  21.420   7.692  1.00  0.00           H  
ATOM   1986  HA  SER A 127       1.948  20.814   6.330  1.00  0.00           H  
ATOM   1987  HB2 SER A 127       1.337  21.762   8.900  1.00  0.00           H  
ATOM   1988  HB3 SER A 127       1.173  20.105   8.319  1.00  0.00           H  
ATOM   1989  HG  SER A 127       3.437  19.841   8.943  1.00  0.00           H  
ATOM   1990  N   LEU A 128       1.224  23.229   6.280  1.00  0.00           N  
ATOM   1991  CA  LEU A 128       0.902  24.632   6.131  1.00  0.00           C  
ATOM   1992  C   LEU A 128      -0.056  25.033   7.234  1.00  0.00           C  
ATOM   1993  O   LEU A 128      -1.239  24.679   7.201  1.00  0.00           O  
ATOM   1994  CB  LEU A 128       0.276  24.894   4.761  1.00  0.00           C  
ATOM   1995  CG  LEU A 128       1.060  25.848   3.864  1.00  0.00           C  
ATOM   1996  CD1 LEU A 128       0.949  25.418   2.410  1.00  0.00           C  
ATOM   1997  CD2 LEU A 128       0.564  27.275   4.038  1.00  0.00           C  
ATOM   1998  H   LEU A 128       0.558  22.564   5.991  1.00  0.00           H  
ATOM   1999  HA  LEU A 128       1.814  25.203   6.225  1.00  0.00           H  
ATOM   2000  HB2 LEU A 128       0.177  23.948   4.249  1.00  0.00           H  
ATOM   2001  HB3 LEU A 128      -0.710  25.307   4.914  1.00  0.00           H  
ATOM   2002  HG  LEU A 128       2.103  25.819   4.142  1.00  0.00           H  
ATOM   2003 HD11 LEU A 128       1.208  24.373   2.324  1.00  0.00           H  
ATOM   2004 HD12 LEU A 128      -0.064  25.567   2.065  1.00  0.00           H  
ATOM   2005 HD13 LEU A 128       1.627  26.005   1.809  1.00  0.00           H  
ATOM   2006 HD21 LEU A 128       0.285  27.434   5.069  1.00  0.00           H  
ATOM   2007 HD22 LEU A 128       1.350  27.964   3.767  1.00  0.00           H  
ATOM   2008 HD23 LEU A 128      -0.293  27.438   3.402  1.00  0.00           H  
ATOM   2009  N   ASP A 129       0.474  25.685   8.246  1.00  0.00           N  
ATOM   2010  CA  ASP A 129      -0.307  26.046   9.415  1.00  0.00           C  
ATOM   2011  C   ASP A 129      -0.073  27.508   9.763  1.00  0.00           C  
ATOM   2012  O   ASP A 129       1.044  28.014   9.628  1.00  0.00           O  
ATOM   2013  CB  ASP A 129       0.056  25.127  10.596  1.00  0.00           C  
ATOM   2014  CG  ASP A 129       0.852  25.822  11.690  1.00  0.00           C  
ATOM   2015  OD1 ASP A 129       2.086  25.960  11.541  1.00  0.00           O  
ATOM   2016  OD2 ASP A 129       0.248  26.218  12.711  1.00  0.00           O  
ATOM   2017  H   ASP A 129       1.437  25.878   8.238  1.00  0.00           H  
ATOM   2018  HA  ASP A 129      -1.350  25.910   9.168  1.00  0.00           H  
ATOM   2019  HB2 ASP A 129      -0.855  24.748  11.035  1.00  0.00           H  
ATOM   2020  HB3 ASP A 129       0.639  24.297  10.225  1.00  0.00           H  
ATOM   2021  N   ARG A 130      -1.122  28.188  10.197  1.00  0.00           N  
ATOM   2022  CA  ARG A 130      -1.021  29.591  10.556  1.00  0.00           C  
ATOM   2023  C   ARG A 130      -0.537  29.722  11.996  1.00  0.00           C  
ATOM   2024  O   ARG A 130      -1.312  30.064  12.897  1.00  0.00           O  
ATOM   2025  CB  ARG A 130      -2.377  30.281  10.381  1.00  0.00           C  
ATOM   2026  CG  ARG A 130      -2.274  31.768  10.084  1.00  0.00           C  
ATOM   2027  CD  ARG A 130      -3.235  32.575  10.940  1.00  0.00           C  
ATOM   2028  NE  ARG A 130      -2.567  33.695  11.599  1.00  0.00           N  
ATOM   2029  CZ  ARG A 130      -3.201  34.716  12.171  1.00  0.00           C  
ATOM   2030  NH1 ARG A 130      -4.526  34.760  12.197  1.00  0.00           N  
ATOM   2031  NH2 ARG A 130      -2.502  35.696  12.725  1.00  0.00           N  
ATOM   2032  H   ARG A 130      -2.000  27.747  10.281  1.00  0.00           H  
ATOM   2033  HA  ARG A 130      -0.299  30.053   9.900  1.00  0.00           H  
ATOM   2034  HB2 ARG A 130      -2.905  29.810   9.565  1.00  0.00           H  
ATOM   2035  HB3 ARG A 130      -2.952  30.157  11.288  1.00  0.00           H  
ATOM   2036  HG2 ARG A 130      -1.266  32.097  10.286  1.00  0.00           H  
ATOM   2037  HG3 ARG A 130      -2.507  31.934   9.042  1.00  0.00           H  
ATOM   2038  HD2 ARG A 130      -4.024  32.957  10.309  1.00  0.00           H  
ATOM   2039  HD3 ARG A 130      -3.660  31.926  11.692  1.00  0.00           H  
ATOM   2040  HE  ARG A 130      -1.579  33.692  11.606  1.00  0.00           H  
ATOM   2041 HH11 ARG A 130      -5.072  34.020  11.784  1.00  0.00           H  
ATOM   2042 HH12 ARG A 130      -4.993  35.537  12.633  1.00  0.00           H  
ATOM   2043 HH21 ARG A 130      -1.499  35.669  12.710  1.00  0.00           H  
ATOM   2044 HH22 ARG A 130      -2.978  36.469  13.158  1.00  0.00           H  
ATOM   2045  N   SER A 131       0.729  29.378  12.204  1.00  0.00           N  
ATOM   2046  CA  SER A 131       1.334  29.378  13.526  1.00  0.00           C  
ATOM   2047  C   SER A 131       1.235  30.756  14.173  1.00  0.00           C  
ATOM   2048  O   SER A 131       1.930  31.693  13.782  1.00  0.00           O  
ATOM   2049  CB  SER A 131       2.794  28.941  13.411  1.00  0.00           C  
ATOM   2050  OG  SER A 131       3.059  28.412  12.116  1.00  0.00           O  
ATOM   2051  H   SER A 131       1.266  29.068  11.440  1.00  0.00           H  
ATOM   2052  HA  SER A 131       0.801  28.664  14.136  1.00  0.00           H  
ATOM   2053  HB2 SER A 131       3.438  29.790  13.581  1.00  0.00           H  
ATOM   2054  HB3 SER A 131       3.000  28.177  14.148  1.00  0.00           H  
ATOM   2055  HG  SER A 131       2.585  27.569  12.006  1.00  0.00           H  
ATOM   2056  N   HIS A 132       0.322  30.885  15.125  1.00  0.00           N  
ATOM   2057  CA  HIS A 132       0.078  32.159  15.781  1.00  0.00           C  
ATOM   2058  C   HIS A 132       0.275  32.033  17.288  1.00  0.00           C  
ATOM   2059  O   HIS A 132      -0.155  31.056  17.901  1.00  0.00           O  
ATOM   2060  CB  HIS A 132      -1.333  32.676  15.454  1.00  0.00           C  
ATOM   2061  CG  HIS A 132      -2.453  31.808  15.960  1.00  0.00           C  
ATOM   2062  ND1 HIS A 132      -2.917  30.698  15.282  1.00  0.00           N  
ATOM   2063  CD2 HIS A 132      -3.206  31.901  17.082  1.00  0.00           C  
ATOM   2064  CE1 HIS A 132      -3.908  30.151  15.967  1.00  0.00           C  
ATOM   2065  NE2 HIS A 132      -4.101  30.863  17.061  1.00  0.00           N  
ATOM   2066  H   HIS A 132      -0.233  30.108  15.364  1.00  0.00           H  
ATOM   2067  HA  HIS A 132       0.803  32.865  15.399  1.00  0.00           H  
ATOM   2068  HB2 HIS A 132      -1.456  33.654  15.892  1.00  0.00           H  
ATOM   2069  HB3 HIS A 132      -1.435  32.756  14.381  1.00  0.00           H  
ATOM   2070  HD1 HIS A 132      -2.565  30.354  14.428  1.00  0.00           H  
ATOM   2071  HD2 HIS A 132      -3.118  32.654  17.853  1.00  0.00           H  
ATOM   2072  HE1 HIS A 132      -4.467  29.273  15.679  1.00  0.00           H  
ATOM   2073  HE2 HIS A 132      -4.840  30.730  17.707  1.00  0.00           H  
ATOM   2074  N   HIS A 133       0.949  33.012  17.870  1.00  0.00           N  
ATOM   2075  CA  HIS A 133       1.234  33.005  19.298  1.00  0.00           C  
ATOM   2076  C   HIS A 133       0.548  34.182  19.988  1.00  0.00           C  
ATOM   2077  O   HIS A 133       0.609  34.327  21.209  1.00  0.00           O  
ATOM   2078  CB  HIS A 133       2.745  33.064  19.533  1.00  0.00           C  
ATOM   2079  CG  HIS A 133       3.178  32.450  20.829  1.00  0.00           C  
ATOM   2080  ND1 HIS A 133       3.614  33.193  21.902  1.00  0.00           N  
ATOM   2081  CD2 HIS A 133       3.240  31.155  21.221  1.00  0.00           C  
ATOM   2082  CE1 HIS A 133       3.929  32.386  22.895  1.00  0.00           C  
ATOM   2083  NE2 HIS A 133       3.712  31.143  22.511  1.00  0.00           N  
ATOM   2084  H   HIS A 133       1.284  33.758  17.315  1.00  0.00           H  
ATOM   2085  HA  HIS A 133       0.848  32.085  19.712  1.00  0.00           H  
ATOM   2086  HB2 HIS A 133       3.247  32.537  18.735  1.00  0.00           H  
ATOM   2087  HB3 HIS A 133       3.063  34.096  19.530  1.00  0.00           H  
ATOM   2088  HD1 HIS A 133       3.690  34.181  21.929  1.00  0.00           H  
ATOM   2089  HD2 HIS A 133       2.971  30.292  20.629  1.00  0.00           H  
ATOM   2090  HE1 HIS A 133       4.305  32.692  23.861  1.00  0.00           H  
ATOM   2091  HE2 HIS A 133       4.093  30.351  22.960  1.00  0.00           H  
ATOM   2092  N   HIS A 134      -0.107  35.018  19.194  1.00  0.00           N  
ATOM   2093  CA  HIS A 134      -0.808  36.187  19.714  1.00  0.00           C  
ATOM   2094  C   HIS A 134      -2.169  35.799  20.293  1.00  0.00           C  
ATOM   2095  O   HIS A 134      -3.213  36.195  19.773  1.00  0.00           O  
ATOM   2096  CB  HIS A 134      -0.983  37.227  18.602  1.00  0.00           C  
ATOM   2097  CG  HIS A 134      -1.231  38.620  19.102  1.00  0.00           C  
ATOM   2098  ND1 HIS A 134      -0.232  39.438  19.577  1.00  0.00           N  
ATOM   2099  CD2 HIS A 134      -2.374  39.338  19.186  1.00  0.00           C  
ATOM   2100  CE1 HIS A 134      -0.747  40.596  19.936  1.00  0.00           C  
ATOM   2101  NE2 HIS A 134      -2.044  40.561  19.708  1.00  0.00           N  
ATOM   2102  H   HIS A 134      -0.121  34.846  18.230  1.00  0.00           H  
ATOM   2103  HA  HIS A 134      -0.203  36.613  20.502  1.00  0.00           H  
ATOM   2104  HB2 HIS A 134      -0.088  37.250  18.000  1.00  0.00           H  
ATOM   2105  HB3 HIS A 134      -1.820  36.940  17.982  1.00  0.00           H  
ATOM   2106  HD1 HIS A 134       0.725  39.204  19.634  1.00  0.00           H  
ATOM   2107  HD2 HIS A 134      -3.362  39.010  18.895  1.00  0.00           H  
ATOM   2108  HE1 HIS A 134      -0.199  41.432  20.347  1.00  0.00           H  
ATOM   2109  HE2 HIS A 134      -2.689  41.263  19.975  1.00  0.00           H  
ATOM   2110  N   HIS A 135      -2.148  35.011  21.359  1.00  0.00           N  
ATOM   2111  CA  HIS A 135      -3.372  34.555  22.005  1.00  0.00           C  
ATOM   2112  C   HIS A 135      -3.059  34.013  23.398  1.00  0.00           C  
ATOM   2113  O   HIS A 135      -2.226  33.120  23.554  1.00  0.00           O  
ATOM   2114  CB  HIS A 135      -4.081  33.493  21.128  1.00  0.00           C  
ATOM   2115  CG  HIS A 135      -4.670  32.322  21.870  1.00  0.00           C  
ATOM   2116  ND1 HIS A 135      -5.863  32.379  22.565  1.00  0.00           N  
ATOM   2117  CD2 HIS A 135      -4.218  31.053  22.015  1.00  0.00           C  
ATOM   2118  CE1 HIS A 135      -6.112  31.199  23.102  1.00  0.00           C  
ATOM   2119  NE2 HIS A 135      -5.131  30.379  22.785  1.00  0.00           N  
ATOM   2120  H   HIS A 135      -1.278  34.719  21.719  1.00  0.00           H  
ATOM   2121  HA  HIS A 135      -4.022  35.411  22.110  1.00  0.00           H  
ATOM   2122  HB2 HIS A 135      -4.886  33.971  20.591  1.00  0.00           H  
ATOM   2123  HB3 HIS A 135      -3.370  33.106  20.412  1.00  0.00           H  
ATOM   2124  HD1 HIS A 135      -6.445  33.175  22.662  1.00  0.00           H  
ATOM   2125  HD2 HIS A 135      -3.306  30.647  21.600  1.00  0.00           H  
ATOM   2126  HE1 HIS A 135      -6.979  30.947  23.697  1.00  0.00           H  
ATOM   2127  HE2 HIS A 135      -4.972  29.505  23.216  1.00  0.00           H  
ATOM   2128  N   HIS A 136      -3.813  34.479  24.381  1.00  0.00           N  
ATOM   2129  CA  HIS A 136      -3.716  33.957  25.742  1.00  0.00           C  
ATOM   2130  C   HIS A 136      -5.005  33.227  26.071  1.00  0.00           C  
ATOM   2131  O   HIS A 136      -5.004  32.032  26.358  1.00  0.00           O  
ATOM   2132  CB  HIS A 136      -3.480  35.066  26.784  1.00  0.00           C  
ATOM   2133  CG  HIS A 136      -2.904  36.338  26.239  1.00  0.00           C  
ATOM   2134  ND1 HIS A 136      -3.645  37.486  26.079  1.00  0.00           N  
ATOM   2135  CD2 HIS A 136      -1.654  36.639  25.821  1.00  0.00           C  
ATOM   2136  CE1 HIS A 136      -2.878  38.436  25.585  1.00  0.00           C  
ATOM   2137  NE2 HIS A 136      -1.663  37.951  25.419  1.00  0.00           N  
ATOM   2138  H   HIS A 136      -4.516  35.129  24.170  1.00  0.00           H  
ATOM   2139  HA  HIS A 136      -2.895  33.254  25.775  1.00  0.00           H  
ATOM   2140  HB2 HIS A 136      -4.422  35.312  27.251  1.00  0.00           H  
ATOM   2141  HB3 HIS A 136      -2.802  34.694  27.538  1.00  0.00           H  
ATOM   2142  HD1 HIS A 136      -4.604  37.591  26.297  1.00  0.00           H  
ATOM   2143  HD2 HIS A 136      -0.805  35.970  25.808  1.00  0.00           H  
ATOM   2144  HE1 HIS A 136      -3.191  39.445  25.358  1.00  0.00           H  
ATOM   2145  HE2 HIS A 136      -0.963  38.377  24.873  1.00  0.00           H  
ATOM   2146  N   HIS A 137      -6.109  33.924  25.866  1.00  0.00           N  
ATOM   2147  CA  HIS A 137      -7.426  33.327  25.972  1.00  0.00           C  
ATOM   2148  C   HIS A 137      -8.127  33.451  24.634  1.00  0.00           C  
ATOM   2149  O   HIS A 137      -7.549  34.106  23.733  1.00  0.00           O  
ATOM   2150  CB  HIS A 137      -8.248  34.018  27.061  1.00  0.00           C  
ATOM   2151  CG  HIS A 137      -8.288  33.267  28.354  1.00  0.00           C  
ATOM   2152  ND1 HIS A 137      -8.081  31.907  28.449  1.00  0.00           N  
ATOM   2153  CD2 HIS A 137      -8.507  33.700  29.615  1.00  0.00           C  
ATOM   2154  CE1 HIS A 137      -8.173  31.539  29.712  1.00  0.00           C  
ATOM   2155  NE2 HIS A 137      -8.430  32.609  30.441  1.00  0.00           N  
ATOM   2156  OXT HIS A 137      -9.227  32.896  24.479  1.00  0.00           O  
ATOM   2157  H   HIS A 137      -6.038  34.838  25.524  1.00  0.00           H  
ATOM   2158  HA  HIS A 137      -7.306  32.284  26.217  1.00  0.00           H  
ATOM   2159  HB2 HIS A 137      -7.827  34.993  27.257  1.00  0.00           H  
ATOM   2160  HB3 HIS A 137      -9.264  34.134  26.712  1.00  0.00           H  
ATOM   2161  HD1 HIS A 137      -7.896  31.294  27.695  1.00  0.00           H  
ATOM   2162  HD2 HIS A 137      -8.713  34.718  29.917  1.00  0.00           H  
ATOM   2163  HE1 HIS A 137      -8.053  30.534  30.089  1.00  0.00           H  
ATOM   2164  HE2 HIS A 137      -8.707  32.596  31.390  1.00  0.00           H  
TER    2165      HIS A 137                                                      
END
MOLECULE T0389.pdb
ATOM      1  N   MET     1     -12.667  -2.302  -4.836  1.00 55.55           N
ATOM      2  CA  MET     1     -11.589  -1.542  -4.213  1.00 48.91           C
ATOM      3  C   MET     1     -10.667  -2.462  -3.418  1.00 39.03           C
ATOM      4  CB  MET     1     -12.164  -0.437  -3.316  1.00 53.74           C
ATOM      5  CG  MET     1     -11.124   0.477  -2.677  1.00 52.32           C
ATOM      6  SD  MET     1     -10.775   0.077  -0.956  1.00 54.50           S
ATOM      7  CE  MET     1     -12.164   0.851  -0.138  1.00 28.92           C
ATOM      8  O   MET     1     -11.122  -3.259  -2.597  1.00 39.35           O
ATOM      9  N   ILE     2      -9.368  -2.352  -3.675  1.00 32.95           N
ATOM     10  CA  ILE     2      -8.372  -3.158  -2.974  1.00 30.36           C
ATOM     11  C   ILE     2      -8.041  -2.529  -1.625  1.00 33.96           C
ATOM     12  CB  ILE     2      -7.083  -3.290  -3.800  1.00 28.62           C
ATOM     13  CG1 ILE     2      -7.403  -3.853  -5.190  1.00 40.56           C
ATOM     14  CG2 ILE     2      -6.082  -4.163  -3.075  1.00 22.68           C
ATOM     15  CD1 ILE     2      -6.203  -4.036  -6.084  1.00 40.80           C
ATOM     16  O   ILE     2      -8.323  -3.100  -0.574  1.00 30.04           O
ATOM     17  N   GLY     3      -7.450  -1.339  -1.667  1.00 32.32           N
ATOM     18  CA  GLY     3      -7.142  -0.596  -0.462  1.00 22.40           C
ATOM     19  C   GLY     3      -5.764  -0.925   0.066  1.00 28.54           C
ATOM     20  O   GLY     3      -5.538  -1.999   0.621  1.00 31.36           O
ATOM     21  N   THR     4      -4.831  -0.001  -0.113  1.00 29.91           N
ATOM     22  CA  THR     4      -3.493  -0.186   0.417  1.00 28.43           C
ATOM     23  C   THR     4      -3.037   1.082   1.112  1.00 25.62           C
ATOM     24  CB  THR     4      -2.492  -0.584  -0.678  1.00 33.32           C
ATOM     25  OG1 THR     4      -2.581   0.340  -1.765  1.00 41.72           O
ATOM     26  CG2 THR     4      -2.814  -1.976  -1.192  1.00 25.85           C
ATOM     27  O   THR     4      -3.677   2.128   0.997  1.00 20.81           O
ATOM     28  N   GLN     5      -1.937   0.984   1.848  1.00 25.25           N
ATOM     29  CA  GLN     5      -1.455   2.118   2.622  1.00 27.71           C
ATOM     30  C   GLN     5      -0.006   2.443   2.303  1.00 24.41           C
ATOM     31  CB  GLN     5      -1.603   1.867   4.131  1.00 30.89           C
ATOM     32  CG  GLN     5      -3.040   1.710   4.619  1.00 40.66           C
ATOM     33  CD  GLN     5      -3.456   0.258   4.771  1.00 44.87           C
ATOM     34  OE1 GLN     5      -2.697  -0.562   5.287  1.00 59.13           O
ATOM     35  NE2 GLN     5      -4.668  -0.063   4.335  1.00 32.63           N
ATOM     36  O   GLN     5       0.718   1.629   1.722  1.00 26.24           O
ATOM     37  N   ILE     6       0.391   3.651   2.686  1.00 21.74           N
ATOM     38  CA  ILE     6       1.781   4.080   2.665  1.00 26.93           C
ATOM     39  C   ILE     6       2.039   4.804   3.988  1.00 27.71           C
ATOM     40  CB  ILE     6       2.045   5.007   1.464  1.00 23.63           C
ATOM     41  CG1 ILE     6       3.531   5.361   1.368  1.00 23.13           C
ATOM     42  CG2 ILE     6       1.150   6.249   1.533  1.00 14.06           C
ATOM     43  CD1 ILE     6       3.920   6.017   0.047  1.00 15.88           C
ATOM     44  O   ILE     6       1.178   5.546   4.462  1.00 26.43           O
ATOM     45  N   VAL     7       3.190   4.569   4.615  1.00 28.81           N
ATOM     46  CA  VAL     7       3.473   5.258   5.874  1.00 27.28           C
ATOM     47  C   VAL     7       4.177   6.586   5.632  1.00 27.58           C
ATOM     48  CB  VAL     7       4.276   4.396   6.883  1.00 24.61           C
ATOM     49  CG1 VAL     7       3.589   3.057   7.105  1.00 23.84           C
ATOM     50  CG2 VAL     7       5.722   4.211   6.424  1.00 17.37           C
ATOM     51  O   VAL     7       4.771   6.805   4.574  1.00 31.93           O
ATOM     52  N   THR     8       4.095   7.468   6.622  1.00 25.79           N
ATOM     53  CA  THR     8       4.656   8.812   6.540  1.00 18.76           C
ATOM     54  C   THR     8       6.079   8.829   5.980  1.00 24.70           C
ATOM     55  CB  THR     8       4.626   9.492   7.924  1.00 32.05           C
ATOM     56  OG1 THR     8       3.268   9.629   8.357  1.00 35.84           O
ATOM     57  CG2 THR     8       5.259  10.861   7.865  1.00 41.25           C
ATOM     58  O   THR     8       6.363   9.530   5.010  1.00 27.45           O
ATOM     59  N   GLU     9       6.971   8.058   6.593  1.00 26.50           N
ATOM     60  CA  GLU     9       8.360   7.994   6.152  1.00 28.73           C
ATOM     61  C   GLU     9       8.492   7.664   4.671  1.00 31.92           C
ATOM     62  CB  GLU     9       9.141   6.960   6.967  1.00 36.59           C
ATOM     63  CG  GLU     9       9.497   7.401   8.372  1.00 49.60           C
ATOM     64  CD  GLU     9      10.430   6.420   9.050  1.00 64.99           C
ATOM     65  OE1 GLU     9      10.333   6.254  10.285  1.00 70.43           O
ATOM     66  OE2 GLU     9      11.257   5.807   8.340  1.00 71.66           O
ATOM     67  O   GLU     9       9.344   8.222   3.975  1.00 37.29           O
ATOM     68  N   ARG    10       7.666   6.740   4.194  1.00 27.84           N
ATOM     69  CA  ARG    10       7.731   6.326   2.796  1.00 30.93           C
ATOM     70  C   ARG    10       7.116   7.362   1.843  1.00 36.13           C
ATOM     71  CB  ARG    10       7.096   4.948   2.608  1.00 31.11           C
ATOM     72  CG  ARG    10       7.797   3.848   3.390  1.00 32.70           C
ATOM     73  CD  ARG    10       9.312   3.937   3.233  1.00 28.58           C
ATOM     74  NE  ARG    10       9.748   3.693   1.861  1.00 28.21           N
ATOM     75  CZ  ARG    10      10.905   4.115   1.357  1.00 34.98           C
ATOM     76  NH1 ARG    10      11.219   3.853   0.095  1.00 39.15           N
ATOM     77  NH2 ARG    10      11.749   4.810   2.110  1.00 32.83           N
ATOM     78  O   ARG    10       7.559   7.499   0.700  1.00 30.64           O
ATOM     79  N   LEU    11       6.104   8.093   2.310  1.00 29.78           N
ATOM     80  CA  LEU    11       5.545   9.187   1.518  1.00 23.47           C
ATOM     81  C   LEU    11       6.600  10.268   1.311  1.00 31.97           C
ATOM     82  CB  LEU    11       4.315   9.789   2.202  1.00 20.62           C
ATOM     83  CG  LEU    11       3.738  11.063   1.572  1.00 19.29           C
ATOM     84  CD1 LEU    11       3.365  10.846   0.103  1.00 20.17           C
ATOM     85  CD2 LEU    11       2.535  11.556   2.363  1.00 20.79           C
ATOM     86  O   LEU    11       6.774  10.788   0.209  1.00 33.78           O
ATOM     87  N   VAL    12       7.304  10.605   2.384  1.00 36.47           N
ATOM     88  CA  VAL    12       8.350  11.617   2.319  1.00 35.64           C
ATOM     89  C   VAL    12       9.499  11.145   1.431  1.00 31.72           C
ATOM     90  CB  VAL    12       8.861  11.981   3.725  1.00 34.77           C
ATOM     91  CG1 VAL    12      10.043  12.914   3.631  1.00 27.99           C
ATOM     92  CG2 VAL    12       7.740  12.616   4.539  1.00 33.81           C
ATOM     93  O   VAL    12      10.086  11.932   0.685  1.00 34.55           O
ATOM     94  N   ALA    13       9.812   9.855   1.507  1.00 32.57           N
ATOM     95  CA  ALA    13      10.798   9.258   0.611  1.00 33.94           C
ATOM     96  CB  ALA    13      10.978   7.789   0.927  1.00 28.20           C
ATOM     97  C   ALA    13      10.341   9.432  -0.829  1.00 35.69           C
ATOM     98  O   ALA    13      11.142   9.699  -1.722  1.00 39.08           O
ATOM     99  N   LEU    14       9.038   9.281  -1.035  1.00 38.07           N
ATOM    100  CA  LEU    14       8.427   9.402  -2.353  1.00 41.39           C
ATOM    101  C   LEU    14       8.460  10.838  -2.853  1.00 46.48           C
ATOM    102  CB  LEU    14       6.978   8.914  -2.305  1.00 34.61           C
ATOM    103  CG  LEU    14       6.193   8.940  -3.612  1.00 29.09           C
ATOM    104  CD1 LEU    14       6.848   8.053  -4.660  1.00 30.96           C
ATOM    105  CD2 LEU    14       4.778   8.493  -3.351  1.00 29.73           C
ATOM    106  O   LEU    14       8.775  11.095  -4.015  1.00 52.43           O
ATOM    107  N   LEU    15       8.119  11.771  -1.972  1.00 41.37           N
ATOM    108  CA  LEU    15       8.124  13.181  -2.326  1.00 36.74           C
ATOM    109  C   LEU    15       9.536  13.666  -2.628  1.00 36.74           C
ATOM    110  CB  LEU    15       7.486  14.022  -1.217  1.00 31.50           C
ATOM    111  CG  LEU    15       5.963  13.936  -1.119  1.00 32.92           C
ATOM    112  CD1 LEU    15       5.468  14.531   0.188  1.00 34.02           C
ATOM    113  CD2 LEU    15       5.310  14.624  -2.312  1.00 35.86           C
ATOM    114  O   LEU    15       9.742  14.407  -3.583  1.00 44.67           O
ATOM    115  N   GLU    16      10.506  13.235  -1.824  1.00 43.81           N
ATOM    116  CA  GLU    16      11.891  13.695  -1.968  1.00 47.85           C
ATOM    117  C   GLU    16      12.610  13.199  -3.221  1.00 58.37           C
ATOM    118  CB  GLU    16      12.712  13.346  -0.728  1.00 41.05           C
ATOM    119  CG  GLU    16      12.933  14.525   0.190  1.00 50.25           C
ATOM    120  CD  GLU    16      13.825  14.185   1.356  1.00 65.46           C
ATOM    121  OE1 GLU    16      13.853  12.997   1.744  1.00 69.66           O
ATOM    122  OE2 GLU    16      14.492  15.101   1.886  1.00 71.48           O
ATOM    123  O   GLU    16      13.700  13.671  -3.545  1.00 66.22           O
ATOM    124  N   SER    17      12.005  12.249  -3.922  1.00 63.43           N
ATOM    125  CA  SER    17      12.617  11.687  -5.118  1.00 63.80           C
ATOM    126  C   SER    17      11.997  12.278  -6.373  1.00 72.15           C
ATOM    127  CB  SER    17      12.462  10.164  -5.144  1.00 58.09           C
ATOM    128  OG  SER    17      11.170   9.787  -5.598  1.00 50.16           O
ATOM    129  O   SER    17      10.788  12.521  -6.434  1.00 66.74           O
ATOM    130  N   GLY    18      12.835  12.512  -7.374  1.00 83.22           N
ATOM    131  CA  GLY    18      12.354  12.915  -8.678  1.00 89.19           C
ATOM    132  C   GLY    18      11.966  11.670  -9.443  1.00 93.43           C
ATOM    133  O   GLY    18      11.991  11.647 -10.671  1.00100.51           O
ATOM    134  N   THR    19      11.610  10.627  -8.699  1.00 90.42           N
ATOM    135  CA  THR    19      11.266   9.331  -9.272  1.00 86.37           C
ATOM    136  C   THR    19       9.834   9.297  -9.796  1.00 83.10           C
ATOM    137  CB  THR    19      11.425   8.214  -8.229  1.00 84.81           C
ATOM    138  OG1 THR    19      12.783   8.176  -7.773  1.00 87.60           O
ATOM    139  CG2 THR    19      11.048   6.864  -8.823  1.00 83.70           C
ATOM    140  O   THR    19       9.580   8.869 -10.926  1.00 75.59           O
ATOM    141  N   GLU    20       8.901   9.749  -8.964  1.00 81.85           N
ATOM    142  CA  GLU    20       7.489   9.698  -9.307  1.00 75.24           C
ATOM    143  C   GLU    20       6.802  11.037  -9.056  1.00 68.06           C
ATOM    144  CB  GLU    20       6.794   8.590  -8.506  1.00 77.31           C
ATOM    145  CG  GLU    20       7.364   7.191  -8.732  1.00 78.54           C
ATOM    146  CD  GLU    20       6.812   6.520  -9.979  1.00 82.72           C
ATOM    147  OE1 GLU    20       5.853   7.055 -10.579  1.00 84.74           O
ATOM    148  OE2 GLU    20       7.331   5.448 -10.353  1.00 84.11           O
ATOM    149  O   GLU    20       7.222  11.808  -8.189  1.00 73.59           O
ATOM    150  N   LYS    21       5.753  11.306  -9.830  1.00 58.21           N
ATOM    151  CA  LYS    21       4.899  12.470  -9.614  1.00 51.59           C
ATOM    152  C   LYS    21       3.724  12.082  -8.718  1.00 41.64           C
ATOM    153  CB  LYS    21       4.406  13.042 -10.949  1.00 59.84           C
ATOM    154  CG  LYS    21       3.188  13.961 -10.842  1.00 73.25           C
ATOM    155  CD  LYS    21       3.407  15.113  -9.862  1.00 80.49           C
ATOM    156  CE  LYS    21       2.083  15.785  -9.492  1.00 77.21           C
ATOM    157  NZ  LYS    21       2.217  16.767  -8.373  1.00 73.38           N
ATOM    158  O   LYS    21       3.002  11.126  -8.995  1.00 40.62           O
ATOM    159  N   VAL    22       3.547  12.827  -7.634  1.00 34.84           N
ATOM    160  CA  VAL    22       2.559  12.483  -6.630  1.00 32.92           C
ATOM    161  CB  VAL    22       3.178  12.499  -5.223  1.00 33.83           C
ATOM    162  CG1 VAL    22       2.158  12.050  -4.189  1.00 32.39           C
ATOM    163  CG2 VAL    22       4.408  11.616  -5.181  1.00 29.83           C
ATOM    164  C   VAL    22       1.376  13.436  -6.637  1.00 35.42           C
ATOM    165  O   VAL    22       1.540  14.654  -6.733  1.00 32.38           O
ATOM    166  N   LEU    23       0.180  12.868  -6.539  1.00 29.16           N
ATOM    167  CA  LEU    23      -1.019  13.649  -6.315  1.00 22.29           C
ATOM    168  CB  LEU    23      -2.137  13.202  -7.248  1.00 24.35           C
ATOM    169  CG  LEU    23      -3.434  13.983  -7.039  1.00 28.17           C
ATOM    170  CD1 LEU    23      -3.195  15.456  -7.311  1.00 33.44           C
ATOM    171  CD2 LEU    23      -4.536  13.448  -7.925  1.00 26.20           C
ATOM    172  C   LEU    23      -1.438  13.457  -4.861  1.00 34.22           C
ATOM    173  O   LEU    23      -1.862  12.369  -4.474  1.00 38.14           O
ATOM    174  N   LEU    24      -1.299  14.514  -4.062  1.00 32.70           N
ATOM    175  CA  LEU    24      -1.611  14.484  -2.634  1.00 26.80           C
ATOM    176  CB  LEU    24      -0.582  15.331  -1.886  1.00 35.00           C
ATOM    177  CG  LEU    24      -0.148  15.018  -0.457  1.00 32.33           C
ATOM    178  CD1 LEU    24       0.273  13.578  -0.346  1.00 30.91           C
ATOM    179  CD2 LEU    24       1.003  15.943  -0.066  1.00 27.96           C
ATOM    180  C   LEU    24      -3.016  15.044  -2.403  1.00 31.48           C
ATOM    181  O   LEU    24      -3.297  16.178  -2.790  1.00 34.33           O
ATOM    182  N   ILE    25      -3.891  14.253  -1.777  1.00 32.49           N
ATOM    183  CA  ILE    25      -5.294  14.631  -1.567  1.00 26.03           C
ATOM    184  CB  ILE    25      -6.252  13.685  -2.331  1.00 24.67           C
ATOM    185  CG1 ILE    25      -6.097  13.880  -3.839  1.00 24.12           C
ATOM    186  CD1 ILE    25      -6.742  12.797  -4.655  1.00 30.90           C
ATOM    187  CG2 ILE    25      -7.705  13.907  -1.899  1.00 24.27           C
ATOM    188  C   ILE    25      -5.692  14.630  -0.094  1.00 29.64           C
ATOM    189  O   ILE    25      -5.531  13.627   0.597  1.00 37.44           O
ATOM    190  N   ASP    26      -6.215  15.760   0.371  1.00 29.68           N
ATOM    191  CA  ASP    26      -6.656  15.925   1.753  1.00 24.45           C
ATOM    192  CB  ASP    26      -6.211  17.295   2.279  1.00 30.07           C
ATOM    193  CG  ASP    26      -6.509  17.493   3.762  1.00 35.56           C
ATOM    194  OD1 ASP    26      -7.443  16.853   4.288  1.00 36.46           O
ATOM    195  OD2 ASP    26      -5.804  18.303   4.404  1.00 36.73           O
ATOM    196  C   ASP    26      -8.172  15.818   1.770  1.00 28.11           C
ATOM    197  O   ASP    26      -8.863  16.668   1.213  1.00 39.19           O
ATOM    198  N   SER    27      -8.691  14.773   2.404  1.00 26.21           N
ATOM    199  CA  SER    27     -10.122  14.491   2.344  1.00 30.84           C
ATOM    200  CB  SER    27     -10.362  12.995   2.144  1.00 29.15           C
ATOM    201  OG  SER    27      -9.935  12.266   3.282  1.00 32.12           O
ATOM    202  C   SER    27     -10.868  14.958   3.584  1.00 38.49           C
ATOM    203  O   SER    27     -11.964  14.477   3.869  1.00 51.88           O
ATOM    204  N   ARG    28     -10.277  15.888   4.323  1.00 33.93           N
ATOM    205  CA  ARG    28     -10.906  16.408   5.529  1.00 28.78           C
ATOM    206  CB  ARG    28      -9.846  16.751   6.568  1.00 24.59           C
ATOM    207  CG  ARG    28      -8.951  15.601   6.952  1.00 22.07           C
ATOM    208  CD  ARG    28      -7.786  16.128   7.764  1.00 31.07           C
ATOM    209  NE  ARG    28      -7.133  17.248   7.092  1.00 34.53           N
ATOM    210  CZ  ARG    28      -6.299  18.092   7.689  1.00 30.99           C
ATOM    211  NH1 ARG    28      -5.748  19.083   7.000  1.00 26.34           N
ATOM    212  NH2 ARG    28      -6.024  17.949   8.978  1.00 26.99           N
ATOM    213  C   ARG    28     -11.716  17.653   5.208  1.00 37.19           C
ATOM    214  O   ARG    28     -11.609  18.197   4.110  1.00 39.32           O
ATOM    215  N   PRO    29     -12.541  18.105   6.168  1.00 42.94           N
ATOM    216  CA  PRO    29     -13.241  19.391   6.066  1.00 45.51           C
ATOM    217  CB  PRO    29     -13.932  19.512   7.424  1.00 43.05           C
ATOM    218  CG  PRO    29     -14.140  18.106   7.856  1.00 37.04           C
ATOM    219  CD  PRO    29     -12.935  17.360   7.377  1.00 37.00           C
ATOM    220  C   PRO    29     -12.264  20.554   5.862  1.00 52.51           C
ATOM    221  O   PRO    29     -11.130  20.520   6.368  1.00 40.37           O
ATOM    222  N   PHE    30     -12.716  21.574   5.134  1.00 59.85           N
ATOM    223  CA  PHE    30     -11.850  22.671   4.693  1.00 63.12           C
ATOM    224  CB  PHE    30     -12.592  23.583   3.710  1.00 70.28           C
ATOM    225  CG  PHE    30     -13.681  24.401   4.344  1.00 83.28           C
ATOM    226  CD1 PHE    30     -13.490  25.750   4.603  1.00 87.85           C
ATOM    227  CE1 PHE    30     -14.490  26.509   5.189  1.00 90.43           C
ATOM    228  CZ  PHE    30     -15.696  25.921   5.524  1.00 93.98           C
ATOM    229  CE2 PHE    30     -15.899  24.576   5.272  1.00 94.92           C
ATOM    230  CD2 PHE    30     -14.895  23.823   4.686  1.00 89.84           C
ATOM    231  C   PHE    30     -11.235  23.499   5.826  1.00 54.89           C
ATOM    232  O   PHE    30     -10.140  24.036   5.678  1.00 53.57           O
ATOM    233  N   VAL    31     -11.935  23.614   6.949  1.00 49.26           N
ATOM    234  CA  VAL    31     -11.399  24.359   8.080  1.00 45.90           C
ATOM    235  CB  VAL    31     -12.383  24.412   9.250  1.00 44.22           C
ATOM    236  CG1 VAL    31     -11.872  25.376  10.309  1.00 49.72           C
ATOM    237  CG2 VAL    31     -13.758  24.824   8.767  1.00 46.00           C
ATOM    238  C   VAL    31     -10.111  23.706   8.553  1.00 47.30           C
ATOM    239  O   VAL    31      -9.142  24.387   8.882  1.00 49.53           O
ATOM    240  N   GLU    32     -10.113  22.377   8.585  1.00 48.26           N
ATOM    241  CA  GLU    32      -8.927  21.615   8.941  1.00 46.25           C
ATOM    242  CB  GLU    32      -9.251  20.127   9.001  1.00 45.40           C
ATOM    243  CG  GLU    32     -10.257  19.756  10.068  1.00 53.40           C
ATOM    244  CD  GLU    32     -10.411  18.258  10.211  1.00 67.62           C
ATOM    245  OE1 GLU    32      -9.380  17.564  10.336  1.00 74.98           O
ATOM    246  OE2 GLU    32     -11.561  17.773  10.199  1.00 72.48           O
ATOM    247  C   GLU    32      -7.837  21.856   7.913  1.00 45.03           C
ATOM    248  O   GLU    32      -6.712  22.221   8.257  1.00 43.27           O
ATOM    249  N   TYR    33      -8.181  21.644   6.647  1.00 41.98           N
ATOM    250  CA  TYR    33      -7.246  21.862   5.551  1.00 42.07           C
ATOM    251  CB  TYR    33      -7.939  21.628   4.206  1.00 41.75           C
ATOM    252  CG  TYR    33      -7.124  22.051   3.001  1.00 46.31           C
ATOM    253  CD1 TYR    33      -6.028  21.311   2.587  1.00 46.83           C
ATOM    254  CE1 TYR    33      -5.284  21.692   1.487  1.00 47.88           C
ATOM    255  CZ  TYR    33      -5.634  22.821   0.780  1.00 45.75           C
ATOM    256  OH  TYR    33      -4.886  23.194  -0.314  1.00 49.06           O
ATOM    257  CE2 TYR    33      -6.722  23.571   1.165  1.00 43.19           C
ATOM    258  CD2 TYR    33      -7.461  23.185   2.269  1.00 45.94           C
ATOM    259  C   TYR    33      -6.643  23.264   5.616  1.00 39.90           C
ATOM    260  O   TYR    33      -5.429  23.416   5.724  1.00 35.50           O
ATOM    261  N   ASN    34      -7.498  24.283   5.567  1.00 41.06           N
ATOM    262  CA  ASN    34      -7.050  25.671   5.610  1.00 44.50           C
ATOM    263  CB  ASN    34      -8.239  26.629   5.529  1.00 48.47           C
ATOM    264  CG  ASN    34      -8.921  26.596   4.175  1.00 65.44           C
ATOM    265  OD1 ASN    34      -8.309  26.239   3.166  1.00 71.56           O
ATOM    266  ND2 ASN    34     -10.195  26.970   4.144  1.00 71.13           N
ATOM    267  C   ASN    34      -6.226  25.965   6.853  1.00 51.02           C
ATOM    268  O   ASN    34      -5.295  26.771   6.815  1.00 53.72           O
ATOM    269  N   THR    35      -6.572  25.303   7.952  1.00 52.53           N
ATOM    270  CA  THR    35      -5.828  25.448   9.198  1.00 55.06           C
ATOM    271  CB  THR    35      -6.522  24.708  10.352  1.00 48.81           C
ATOM    272  OG1 THR    35      -7.653  25.470  10.792  1.00 50.83           O
ATOM    273  CG2 THR    35      -5.569  24.519  11.513  1.00 46.15           C
ATOM    274  C   THR    35      -4.397  24.935   9.047  1.00 58.99           C
ATOM    275  O   THR    35      -3.436  25.617   9.409  1.00 59.86           O
ATOM    276  N   SER    36      -4.266  23.728   8.508  1.00 57.80           N
ATOM    277  CA  SER    36      -2.962  23.130   8.255  1.00 44.32           C
ATOM    278  CB  SER    36      -2.239  22.839   9.569  1.00 41.58           C
ATOM    279  OG  SER    36      -0.905  22.417   9.343  1.00 42.17           O
ATOM    280  C   SER    36      -3.125  21.849   7.450  1.00 41.50           C
ATOM    281  O   SER    36      -4.073  21.089   7.648  1.00 41.29           O
ATOM    282  N   HIS    37      -2.199  21.617   6.533  1.00 39.31           N
ATOM    283  CA  HIS    37      -2.235  20.422   5.711  1.00 36.95           C
ATOM    284  CB  HIS    37      -3.221  20.597   4.557  1.00 37.03           C
ATOM    285  CG  HIS    37      -2.976  21.820   3.727  1.00 40.92           C
ATOM    286  ND1 HIS    37      -3.591  23.028   3.980  1.00 42.94           N
ATOM    287  CE1 HIS    37      -3.196  23.918   3.089  1.00 42.20           C
ATOM    288  NE2 HIS    37      -2.347  23.333   2.262  1.00 39.83           N
ATOM    289  CD2 HIS    37      -2.193  22.020   2.640  1.00 40.89           C
ATOM    290  C   HIS    37      -0.843  20.141   5.180  1.00 37.63           C
ATOM    291  O   HIS    37       0.064  20.947   5.354  1.00 36.89           O
ATOM    292  N   ILE    38      -0.671  18.994   4.539  1.00 41.55           N
ATOM    293  CA  ILE    38       0.616  18.639   3.958  1.00 37.60           C
ATOM    294  CB  ILE    38       0.675  17.134   3.639  1.00 30.71           C
ATOM    295  CG1 ILE    38       0.259  16.325   4.874  1.00 27.77           C
ATOM    296  CD1 ILE    38       0.168  14.832   4.637  1.00 22.41           C
ATOM    297  CG2 ILE    38       2.068  16.735   3.159  1.00 25.86           C
ATOM    298  C   ILE    38       0.872  19.480   2.705  1.00 35.63           C
ATOM    299  O   ILE    38      -0.035  19.695   1.901  1.00 32.64           O
ATOM    300  N   LEU    39       2.099  19.967   2.546  1.00 40.56           N
ATOM    301  CA  LEU    39       2.412  20.870   1.436  1.00 48.63           C
ATOM    302  CB  LEU    39       3.922  21.157   1.332  1.00 49.42           C
ATOM    303  CG  LEU    39       4.947  20.017   1.273  1.00 56.26           C
ATOM    304  CD1 LEU    39       4.808  19.181   0.011  1.00 57.74           C
ATOM    305  CD2 LEU    39       6.363  20.577   1.378  1.00 64.17           C
ATOM    306  C   LEU    39       1.857  20.374   0.104  1.00 47.80           C
ATOM    307  O   LEU    39       1.971  19.196  -0.236  1.00 55.06           O
ATOM    308  N   GLU    40       1.241  21.283  -0.639  1.00 45.55           N
ATOM    309  CA  GLU    40       0.723  20.961  -1.960  1.00 52.91           C
ATOM    310  CB  GLU    40       1.867  20.613  -2.918  1.00 61.40           C
ATOM    311  CG  GLU    40       2.642  21.827  -3.418  1.00 81.82           C
ATOM    312  CD  GLU    40       3.678  21.467  -4.467  1.00 94.83           C
ATOM    313  OE1 GLU    40       4.364  20.435  -4.296  1.00 97.63           O
ATOM    314  OE2 GLU    40       3.809  22.218  -5.460  1.00 98.12           O
ATOM    315  C   GLU    40      -0.298  19.832  -1.933  1.00 51.57           C
ATOM    316  O   GLU    40      -0.360  19.028  -2.862  1.00 61.01           O
ATOM    317  N   ALA    41      -1.093  19.763  -0.871  1.00 41.75           N
ATOM    318  CA  ALA    41      -2.187  18.803  -0.832  1.00 33.55           C
ATOM    319  CB  ALA    41      -2.421  18.295   0.577  1.00 30.22           C
ATOM    320  C   ALA    41      -3.436  19.466  -1.379  1.00 35.11           C
ATOM    321  O   ALA    41      -3.708  20.629  -1.081  1.00 33.51           O
ATOM    322  N   ILE    42      -4.180  18.722  -2.193  1.00 34.36           N
ATOM    323  CA  ILE    42      -5.415  19.206  -2.790  1.00 28.06           C
ATOM    324  CB  ILE    42      -5.636  18.595  -4.194  1.00 36.87           C
ATOM    325  CG1 ILE    42      -4.595  19.131  -5.181  1.00 40.30           C
ATOM    326  CD1 ILE    42      -4.813  18.677  -6.612  1.00 45.01           C
ATOM    327  CG2 ILE    42      -7.047  18.878  -4.701  1.00 36.92           C
ATOM    328  C   ILE    42      -6.594  18.864  -1.890  1.00 32.24           C
ATOM    329  O   ILE    42      -6.788  17.710  -1.512  1.00 33.40           O
ATOM    330  N   ASN    43      -7.380  19.872  -1.542  1.00 29.34           N
ATOM    331  CA  ASN    43      -8.510  19.653  -0.667  1.00 25.86           C
ATOM    332  CB  ASN    43      -8.889  20.947   0.044  1.00 33.60           C
ATOM    333  CG  ASN    43      -9.821  20.715   1.216  1.00 34.17           C
ATOM    334  OD1 ASN    43     -10.557  21.611   1.625  1.00 36.36           O
ATOM    335  ND2 ASN    43      -9.795  19.506   1.761  1.00 36.56           N
ATOM    336  C   ASN    43      -9.697  19.109  -1.438  1.00 34.70           C
ATOM    337  O   ASN    43     -10.195  19.753  -2.359  1.00 33.23           O
ATOM    338  N   ILE    44     -10.137  17.911  -1.072  1.00 41.22           N
ATOM    339  CA  ILE    44     -11.353  17.349  -1.648  1.00 51.00           C
ATOM    340  CB  ILE    44     -11.096  15.995  -2.361  1.00 33.87           C
ATOM    341  CG1 ILE    44     -10.543  16.248  -3.760  1.00 35.46           C
ATOM    342  CD1 ILE    44     -10.673  15.065  -4.684  1.00 40.96           C
ATOM    343  CG2 ILE    44     -12.368  15.184  -2.489  1.00 35.59           C
ATOM    344  C   ILE    44     -12.437  17.256  -0.575  1.00 57.35           C
ATOM    345  O   ILE    44     -12.371  16.422   0.326  1.00 55.31           O
ATOM    346  N   ASN    45     -13.419  18.146  -0.683  1.00 69.12           N
ATOM    347  CA  ASN    45     -14.475  18.302   0.313  1.00 80.69           C
ATOM    348  C   ASN    45     -15.091  16.983   0.775  1.00 77.66           C
ATOM    349  CB  ASN    45     -15.573  19.217  -0.236  1.00 92.37           C
ATOM    350  CG  ASN    45     -16.517  19.705   0.841  1.00 97.46           C
ATOM    351  OD1 ASN    45     -16.111  19.922   1.985  1.00 98.67           O
ATOM    352  ND2 ASN    45     -17.785  19.885   0.481  1.00 96.06           N
ATOM    353  O   ASN    45     -15.590  16.207  -0.040  1.00 82.94           O
ATOM    354  N   CYS    46     -15.073  16.750   2.085  1.00 67.08           N
ATOM    355  CA  CYS    46     -15.598  15.515   2.669  1.00 62.47           C
ATOM    356  C   CYS    46     -17.125  15.529   2.814  1.00 62.17           C
ATOM    357  CB  CYS    46     -14.951  15.277   4.040  1.00 59.73           C
ATOM    358  SG  CYS    46     -15.230  13.636   4.766  1.00106.57           S
ATOM    359  O   CYS    46     -17.658  15.093   3.832  1.00 71.02           O
ATOM    360  N   SER    47     -17.825  16.011   1.791  1.00 53.92           N
ATOM    361  CA  SER    47     -19.259  16.273   1.909  1.00 51.97           C
ATOM    362  C   SER    47     -20.132  15.032   1.738  1.00 45.27           C
ATOM    363  CB  SER    47     -19.687  17.360   0.918  1.00 54.06           C
ATOM    364  OG  SER    47     -21.041  17.724   1.118  1.00 54.99           O
ATOM    365  O   SER    47     -19.829  14.150   0.937  1.00 51.10           O
ATOM    366  N   LYS    48     -21.223  14.977   2.495  1.00 41.59           N
ATOM    367  CA  LYS    48     -22.188  13.888   2.374  1.00 41.93           C
ATOM    368  C   LYS    48     -22.929  13.983   1.048  1.00 35.27           C
ATOM    369  CB  LYS    48     -23.191  13.925   3.526  1.00 42.50           C
ATOM    370  CG  LYS    48     -24.331  12.935   3.373  1.00 48.77           C
ATOM    371  O   LYS    48     -23.354  12.976   0.480  1.00 26.58           O
ATOM    372  N   LEU    49     -23.087  15.211   0.566  1.00 38.61           N
ATOM    373  CA  LEU    49     -23.676  15.449  -0.741  1.00 38.50           C
ATOM    374  C   LEU    49     -22.740  14.992  -1.847  1.00 38.28           C
ATOM    375  CB  LEU    49     -24.007  16.929  -0.922  1.00 39.79           C
ATOM    376  CG  LEU    49     -25.456  17.296  -0.618  1.00 42.29           C
ATOM    377  CD1 LEU    49     -25.764  17.087   0.855  1.00 47.32           C
ATOM    378  CD2 LEU    49     -25.728  18.726  -1.038  1.00 42.96           C
ATOM    379  O   LEU    49     -23.153  14.307  -2.783  1.00 37.28           O
ATOM    380  N   MET    50     -21.475  15.376  -1.737  1.00 42.28           N
ATOM    381  CA  MET    50     -20.492  15.014  -2.745  1.00 37.99           C
ATOM    382  CB  MET    50     -19.161  15.716  -2.492  1.00 38.85           C
ATOM    383  CG  MET    50     -18.174  15.571  -3.644  1.00 43.10           C
ATOM    384  SD  MET    50     -18.756  16.316  -5.183  1.00 49.92           S
ATOM    385  CE  MET    50     -18.899  18.036  -4.706  1.00 35.64           C
ATOM    386  C   MET    50     -20.293  13.505  -2.805  1.00 34.27           C
ATOM    387  O   MET    50     -20.042  12.954  -3.872  1.00 43.24           O
ATOM    388  N   LYS    51     -20.409  12.838  -1.661  1.00 32.27           N
ATOM    389  CA  LYS    51     -20.316  11.383  -1.629  1.00 32.79           C
ATOM    390  C   LYS    51     -21.427  10.757  -2.471  1.00 30.43           C
ATOM    391  CB  LYS    51     -20.397  10.861  -0.194  1.00 36.87           C
ATOM    392  CG  LYS    51     -20.241   9.350  -0.097  1.00 39.71           C
ATOM    393  CD  LYS    51     -20.381   8.859   1.329  1.00 41.39           C
ATOM    394  CE  LYS    51     -21.813   8.935   1.803  1.00 42.82           C
ATOM    395  NZ  LYS    51     -21.967   8.281   3.129  1.00 51.50           N
ATOM    396  O   LYS    51     -21.196   9.813  -3.222  1.00 31.73           O
ATOM    397  N   ARG    52     -22.632  11.296  -2.335  1.00 24.42           N
ATOM    398  CA  ARG    52     -23.786  10.810  -3.082  1.00 34.25           C
ATOM    399  C   ARG    52     -23.603  10.993  -4.589  1.00 38.67           C
ATOM    400  CB  ARG    52     -25.062  11.518  -2.602  1.00 36.38           C
ATOM    401  CG  ARG    52     -26.269  11.362  -3.516  1.00 40.51           C
ATOM    402  CD  ARG    52     -26.730   9.923  -3.584  1.00 47.64           C
ATOM    403  NE  ARG    52     -27.173   9.434  -2.283  1.00 60.47           N
ATOM    404  CZ  ARG    52     -28.441   9.428  -1.878  1.00 68.99           C
ATOM    405  NH1 ARG    52     -28.748   8.961  -0.673  1.00 70.98           N
ATOM    406  NH2 ARG    52     -29.402   9.885  -2.677  1.00 59.63           N
ATOM    407  O   ARG    52     -23.931  10.106  -5.375  1.00 38.99           O
ATOM    408  N   ARG    53     -23.076  12.143  -4.991  1.00 37.78           N
ATOM    409  CA  ARG    53     -22.926  12.441  -6.408  1.00 27.97           C
ATOM    410  CB  ARG    53     -22.643  13.925  -6.619  1.00 30.07           C
ATOM    411  CG  ARG    53     -23.701  14.835  -6.027  1.00 32.32           C
ATOM    412  CD  ARG    53     -23.223  16.270  -6.028  1.00 34.30           C
ATOM    413  NE  ARG    53     -23.065  16.769  -7.386  1.00 37.14           N
ATOM    414  CZ  ARG    53     -22.296  17.799  -7.718  1.00 41.11           C
ATOM    415  NH1 ARG    53     -21.601  18.441  -6.787  1.00 41.03           N
ATOM    416  NH2 ARG    53     -22.215  18.181  -8.984  1.00 50.49           N
ATOM    417  C   ARG    53     -21.828  11.598  -7.034  1.00 26.58           C
ATOM    418  O   ARG    53     -21.929  11.219  -8.198  1.00 33.31           O
ATOM    419  N   LEU    54     -20.783  11.302  -6.263  1.00 23.11           N
ATOM    420  CA  LEU    54     -19.707  10.430  -6.739  1.00 26.22           C
ATOM    421  CB  LEU    54     -18.529  10.417  -5.767  1.00 26.60           C
ATOM    422  CG  LEU    54     -17.546  11.584  -5.815  1.00 28.36           C
ATOM    423  CD1 LEU    54     -16.705  11.573  -4.562  1.00 31.64           C
ATOM    424  CD2 LEU    54     -16.668  11.506  -7.047  1.00 25.92           C
ATOM    425  C   LEU    54     -20.201   9.007  -6.942  1.00 32.23           C
ATOM    426  O   LEU    54     -19.881   8.372  -7.947  1.00 39.27           O
ATOM    427  N   GLN    55     -20.975   8.501  -5.987  1.00 32.69           N
ATOM    428  CA  GLN    55     -21.512   7.149  -6.117  1.00 39.72           C
ATOM    429  CB  GLN    55     -21.870   6.542  -4.756  1.00 36.87           C
ATOM    430  CG  GLN    55     -22.697   7.409  -3.846  1.00 39.89           C
ATOM    431  CD  GLN    55     -22.716   6.873  -2.427  1.00 50.23           C
ATOM    432  OE1 GLN    55     -23.337   7.454  -1.535  1.00 61.14           O
ATOM    433  NE2 GLN    55     -22.026   5.759  -2.211  1.00 47.60           N
ATOM    434  C   GLN    55     -22.677   7.065  -7.106  1.00 42.85           C
ATOM    435  O   GLN    55     -22.957   6.000  -7.650  1.00 44.76           O
ATOM    436  N   GLN    56     -23.347   8.190  -7.344  1.00 46.82           N
ATOM    437  CA  GLN    56     -24.323   8.276  -8.426  1.00 45.42           C
ATOM    438  CB  GLN    56     -25.273   9.453  -8.211  1.00 50.60           C
ATOM    439  CG  GLN    56     -26.336   9.183  -7.174  1.00 59.55           C
ATOM    440  CD  GLN    56     -27.059   7.880  -7.431  1.00 68.75           C
ATOM    441  OE1 GLN    56     -27.391   7.554  -8.573  1.00 69.19           O
ATOM    442  NE2 GLN    56     -27.305   7.122  -6.369  1.00 73.71           N
ATOM    443  C   GLN    56     -23.606   8.424  -9.762  1.00 49.15           C
ATOM    444  O   GLN    56     -24.227   8.383 -10.825  1.00 50.61           O
ATOM    445  N   ASP    57     -22.290   8.595  -9.691  1.00 50.01           N
ATOM    446  CA  ASP    57     -21.457   8.794 -10.870  1.00 50.90           C
ATOM    447  C   ASP    57     -21.863  10.036 -11.669  1.00 48.47           C
ATOM    448  CB  ASP    57     -21.457   7.541 -11.753  1.00 63.04           C
ATOM    449  CG  ASP    57     -20.622   6.411 -11.164  1.00 74.02           C
ATOM    450  OD1 ASP    57     -19.612   6.702 -10.484  1.00 69.32           O
ATOM    451  OD2 ASP    57     -20.971   5.231 -11.387  1.00 83.00           O
ATOM    452  O   ASP    57     -21.687  10.082 -12.890  1.00 49.58           O
ATOM    453  N   LYS    58     -22.395  11.041 -10.973  1.00 43.80           N
ATOM    454  CA  LYS    58     -22.780  12.306 -11.604  1.00 39.90           C
ATOM    455  CB  LYS    58     -24.050  12.877 -10.971  1.00 36.58           C
ATOM    456  CG  LYS    58     -25.286  12.043 -11.247  1.00 39.76           C
ATOM    457  CD  LYS    58     -25.431  11.760 -12.733  1.00 49.52           C
ATOM    458  CE  LYS    58     -26.482  10.694 -12.996  1.00 56.22           C
ATOM    459  NZ  LYS    58     -26.491  10.267 -14.423  1.00 61.47           N
ATOM    460  C   LYS    58     -21.647  13.319 -11.523  1.00 42.27           C
ATOM    461  O   LYS    58     -21.711  14.387 -12.131  1.00 51.90           O
ATOM    462  N   VAL    59     -20.623  12.971 -10.751  1.00 33.26           N
ATOM    463  CA  VAL    59     -19.376  13.719 -10.688  1.00 29.60           C
ATOM    464  CB  VAL    59     -19.187  14.431  -9.324  1.00 28.62           C
ATOM    465  CG1 VAL    59     -17.858  15.162  -9.289  1.00 29.32           C
ATOM    466  CG2 VAL    59     -20.323  15.396  -9.049  1.00 29.12           C
ATOM    467  C   VAL    59     -18.260  12.698 -10.855  1.00 34.05           C
ATOM    468  O   VAL    59     -18.344  11.597 -10.305  1.00 35.30           O
ATOM    469  N   LEU    60     -17.229  13.042 -11.625  1.00 37.50           N
ATOM    470  CA  LEU    60     -16.067  12.166 -11.772  1.00 42.21           C
ATOM    471  CB  LEU    60     -15.575  12.135 -13.221  1.00 45.41           C
ATOM    472  CG  LEU    60     -16.498  11.491 -14.257  1.00 47.20           C
ATOM    473  CD1 LEU    60     -15.752  11.303 -15.561  1.00 52.01           C
ATOM    474  CD2 LEU    60     -17.049  10.161 -13.759  1.00 43.24           C
ATOM    475  C   LEU    60     -14.946  12.619 -10.847  1.00 41.66           C
ATOM    476  O   LEU    60     -14.722  13.816 -10.683  1.00 40.31           O
ATOM    477  N   ILE    61     -14.246  11.666 -10.239  1.00 38.19           N
ATOM    478  CA  ILE    61     -13.184  12.014  -9.309  1.00 32.87           C
ATOM    479  CB  ILE    61     -12.527  10.765  -8.670  1.00 29.11           C
ATOM    480  CG1 ILE    61     -11.690  11.173  -7.459  1.00 25.84           C
ATOM    481  CD1 ILE    61     -12.436  12.039  -6.466  1.00 29.15           C
ATOM    482  CG2 ILE    61     -11.687  10.010  -9.676  1.00 20.82           C
ATOM    483  C   ILE    61     -12.143  12.914  -9.978  1.00 30.86           C
ATOM    484  O   ILE    61     -11.636  13.849  -9.355  1.00 30.96           O
ATOM    485  N   THR    62     -11.843  12.647 -11.248  1.00 34.08           N
ATOM    486  CA  THR    62     -10.919  13.491 -12.012  1.00 35.89           C
ATOM    487  CB  THR    62     -10.602  12.902 -13.407  1.00 39.01           C
ATOM    488  OG1 THR    62     -11.811  12.457 -14.037  1.00 44.98           O
ATOM    489  CG2 THR    62      -9.630  11.731 -13.291  1.00 29.67           C
ATOM    490  C   THR    62     -11.467  14.907 -12.178  1.00 40.36           C
ATOM    491  O   THR    62     -10.713  15.877 -12.242  1.00 44.86           O
ATOM    492  N   GLU    63     -12.788  15.013 -12.247  1.00 40.84           N
ATOM    493  CA  GLU    63     -13.456  16.299 -12.348  1.00 38.96           C
ATOM    494  CB  GLU    63     -14.904  16.078 -12.780  1.00 48.16           C
ATOM    495  CG  GLU    63     -15.704  17.342 -13.020  1.00 66.32           C
ATOM    496  CD  GLU    63     -17.144  17.044 -13.401  1.00 78.42           C
ATOM    497  OE1 GLU    63     -17.461  15.858 -13.645  1.00 72.66           O
ATOM    498  OE2 GLU    63     -17.957  17.995 -13.457  1.00 87.86           O
ATOM    499  C   GLU    63     -13.399  17.044 -11.010  1.00 40.37           C
ATOM    500  O   GLU    63     -13.166  18.248 -10.961  1.00 45.37           O
ATOM    501  N   LEU    64     -13.607  16.315  -9.922  1.00 37.95           N
ATOM    502  CA  LEU    64     -13.612  16.904  -8.590  1.00 35.93           C
ATOM    503  CB  LEU    64     -14.094  15.865  -7.577  1.00 40.45           C
ATOM    504  CG  LEU    64     -14.491  16.330  -6.179  1.00 44.49           C
ATOM    505  CD1 LEU    64     -15.480  17.482  -6.245  1.00 40.87           C
ATOM    506  CD2 LEU    64     -15.073  15.151  -5.417  1.00 47.40           C
ATOM    507  C   LEU    64     -12.219  17.409  -8.215  1.00 38.16           C
ATOM    508  O   LEU    64     -12.072  18.501  -7.672  1.00 39.82           O
ATOM    509  N   ILE    65     -11.204  16.603  -8.514  1.00 37.64           N
ATOM    510  CA  ILE    65      -9.811  16.944  -8.235  1.00 39.92           C
ATOM    511  CB  ILE    65      -8.864  15.860  -8.779  1.00 35.24           C
ATOM    512  CG1 ILE    65      -8.873  14.636  -7.861  1.00 29.71           C
ATOM    513  CD1 ILE    65      -8.242  13.402  -8.481  1.00 28.25           C
ATOM    514  CG2 ILE    65      -7.453  16.416  -8.947  1.00 30.91           C
ATOM    515  C   ILE    65      -9.393  18.280  -8.838  1.00 46.48           C
ATOM    516  O   ILE    65      -8.794  19.118  -8.162  1.00 45.83           O
ATOM    517  N   GLN    66      -9.709  18.463 -10.118  1.00 56.22           N
ATOM    518  CA  GLN    66      -9.350  19.670 -10.857  1.00 54.55           C
ATOM    519  CB  GLN    66      -9.550  19.444 -12.353  1.00 60.28           C
ATOM    520  CG  GLN    66      -9.064  20.585 -13.211  1.00 72.01           C
ATOM    521  CD  GLN    66      -7.578  20.511 -13.468  1.00 85.30           C
ATOM    522  OE1 GLN    66      -6.823  21.403 -13.077  1.00 92.06           O
ATOM    523  NE2 GLN    66      -7.146  19.439 -14.124  1.00 86.93           N
ATOM    524  C   GLN    66     -10.155  20.893 -10.417  1.00 50.28           C
ATOM    525  O   GLN    66      -9.648  22.016 -10.437  1.00 55.72           O
ATOM    526  N   HIS    67     -11.411  20.675 -10.033  1.00 43.67           N
ATOM    527  CA  HIS    67     -12.275  21.762  -9.582  1.00 44.40           C
ATOM    528  CB  HIS    67     -13.738  21.313  -9.541  1.00 40.90           C
ATOM    529  C   HIS    67     -11.839  22.212  -8.200  1.00 49.95           C
ATOM    530  O   HIS    67     -12.064  23.357  -7.807  1.00 53.24           O
ATOM    531  N   SER    68     -11.210  21.291  -7.475  1.00 47.00           N
ATOM    532  CA  SER    68     -10.787  21.524  -6.102  1.00 45.77           C
ATOM    533  C   SER    68      -9.403  22.158  -6.042  1.00 53.15           C
ATOM    534  CB  SER    68     -10.788  20.205  -5.325  1.00 42.58           C
ATOM    535  OG  SER    68     -12.075  19.607  -5.330  1.00 48.44           O
ATOM    536  O   SER    68      -8.946  22.576  -4.981  1.00 61.48           O
ATOM    537  O   ALA    69      -7.891  24.743  -8.426  1.00 78.32           O
ATOM    538  N   ALA    69      -8.737  22.232  -7.184  1.00 59.34           N
ATOM    539  CA  ALA    69      -7.374  22.733  -7.216  1.00 73.24           C
ATOM    540  C   ALA    69      -7.323  24.234  -7.457  1.00 80.42           C
ATOM    541  CB  ALA    69      -6.559  21.992  -8.271  1.00 80.03           C
ATOM    542  N   LYS    70      -6.648  24.938  -6.555  1.00 88.75           N
ATOM    543  CA  LYS    70      -6.339  26.342  -6.763  1.00 91.54           C
ATOM    544  C   LYS    70      -5.386  26.422  -7.948  1.00 93.60           C
ATOM    545  CB  LYS    70      -5.701  26.941  -5.509  1.00 87.53           C
ATOM    546  CG  LYS    70      -6.579  26.853  -4.267  1.00 82.32           C
ATOM    547  O   LYS    70      -5.556  27.247  -8.846  1.00 95.71           O
ATOM    548  N   HIS    71      -4.388  25.543  -7.944  1.00 91.55           N
ATOM    549  CA  HIS    71      -3.513  25.361  -9.093  1.00 89.14           C
ATOM    550  C   HIS    71      -4.298  24.694 -10.219  1.00 90.61           C
ATOM    551  CB  HIS    71      -2.315  24.487  -8.708  1.00 81.33           C
ATOM    552  O   HIS    71      -5.423  24.235 -10.013  1.00 92.67           O
ATOM    553  N   LYS    72      -3.720  24.650 -11.414  1.00 87.36           N
ATOM    554  CA  LYS    72      -4.278  23.819 -12.472  1.00 83.80           C
ATOM    555  C   LYS    72      -3.679  22.426 -12.311  1.00 83.67           C
ATOM    556  CB  LYS    72      -3.963  24.393 -13.854  1.00 80.30           C
ATOM    557  O   LYS    72      -2.520  22.198 -12.662  1.00 86.83           O
ATOM    558  N   VAL    73      -4.462  21.504 -11.756  1.00 76.29           N
ATOM    559  CA  VAL    73      -3.961  20.177 -11.401  1.00 62.44           C
ATOM    560  C   VAL    73      -3.731  19.279 -12.615  1.00 55.24           C
ATOM    561  CB  VAL    73      -4.903  19.460 -10.407  1.00 53.77           C
ATOM    562  O   VAL    73      -4.500  19.301 -13.577  1.00 50.98           O
ATOM    563  N   ASP    74      -2.660  18.494 -12.564  1.00 56.44           N
ATOM    564  CA  ASP    74      -2.386  17.505 -13.597  1.00 58.76           C
ATOM    565  C   ASP    74      -3.122  16.221 -13.275  1.00 50.96           C
ATOM    566  CB  ASP    74      -0.886  17.215 -13.700  1.00 70.12           C
ATOM    567  CG  ASP    74      -0.582  15.975 -14.535  1.00 78.77           C
ATOM    568  OD1 ASP    74      -1.282  15.747 -15.546  1.00 84.78           O
ATOM    569  OD2 ASP    74       0.363  15.234 -14.181  1.00 76.70           O
ATOM    570  O   ASP    74      -2.873  15.590 -12.250  1.00 48.16           O
ATOM    571  N   ILE    75      -4.046  15.840 -14.144  1.00 51.11           N
ATOM    572  CA  ILE    75      -4.667  14.536 -14.022  1.00 50.32           C
ATOM    573  C   ILE    75      -3.983  13.601 -15.007  1.00 53.98           C
ATOM    574  CB  ILE    75      -6.189  14.585 -14.241  1.00 48.96           C
ATOM    575  CG1 ILE    75      -6.521  14.994 -15.681  1.00 54.90           C
ATOM    576  CG2 ILE    75      -6.833  15.531 -13.230  1.00 40.78           C
ATOM    577  CD1 ILE    75      -7.903  14.562 -16.139  1.00 53.82           C
ATOM    578  O   ILE    75      -3.904  13.873 -16.208  1.00 58.19           O
ATOM    579  N   ASP    76      -3.458  12.510 -14.472  1.00 46.59           N
ATOM    580  CA  ASP    76      -2.659  11.582 -15.243  1.00 39.95           C
ATOM    581  C   ASP    76      -2.639  10.291 -14.449  1.00 39.99           C
ATOM    582  CB  ASP    76      -1.253  12.145 -15.415  1.00 46.24           C
ATOM    583  CG  ASP    76      -0.300  11.160 -16.044  1.00 62.54           C
ATOM    584  OD1 ASP    76      -0.767  10.150 -16.611  1.00 58.76           O
ATOM    585  OD2 ASP    76       0.924  11.403 -15.971  1.00 78.13           O
ATOM    586  O   ASP    76      -2.167  10.268 -13.313  1.00 43.30           O
ATOM    587  N   CYS    77      -3.170   9.224 -15.038  1.00 32.09           N
ATOM    588  CA  CYS    77      -3.415   7.989 -14.299  1.00 29.25           C
ATOM    589  C   CYS    77      -2.139   7.293 -13.817  1.00 30.94           C
ATOM    590  CB  CYS    77      -4.292   7.029 -15.115  1.00 24.46           C
ATOM    591  SG  CYS    77      -3.488   6.287 -16.538  1.00 32.77           S
ATOM    592  O   CYS    77      -2.204   6.267 -13.143  1.00 34.92           O
ATOM    593  N   SER    78      -0.983   7.861 -14.148  1.00 32.37           N
ATOM    594  CA  SER    78       0.297   7.305 -13.715  1.00 33.84           C
ATOM    595  C   SER    78       0.796   7.964 -12.427  1.00 39.45           C
ATOM    596  CB  SER    78       1.338   7.474 -14.814  1.00 39.39           C
ATOM    597  OG  SER    78       1.506   8.846 -15.119  1.00 45.95           O
ATOM    598  O   SER    78       1.759   7.500 -11.814  1.00 39.60           O
ATOM    599  N   GLN    79       0.142   9.051 -12.025  1.00 38.96           N
ATOM    600  CA  GLN    79       0.479   9.743 -10.784  1.00 33.59           C
ATOM    601  C   GLN    79       0.225   8.863  -9.578  1.00 33.66           C
ATOM    602  CB  GLN    79      -0.364  11.005 -10.632  1.00 35.24           C
ATOM    603  CG  GLN    79       0.194  12.221 -11.328  1.00 45.10           C
ATOM    604  CD  GLN    79      -0.737  13.395 -11.211  1.00 52.62           C
ATOM    605  OE1 GLN    79      -0.378  14.437 -10.664  1.00 61.12           O
ATOM    606  NE2 GLN    79      -1.958  13.225 -11.700  1.00 49.63           N
ATOM    607  O   GLN    79      -0.851   8.277  -9.452  1.00 42.02           O
ATOM    608  N   LYS    80       1.206   8.776  -8.686  1.00 25.19           N
ATOM    609  CA  LYS    80       0.990   8.094  -7.424  1.00 23.95           C
ATOM    610  C   LYS    80       0.098   8.990  -6.581  1.00 26.27           C
ATOM    611  CB  LYS    80       2.309   7.823  -6.709  1.00 27.50           C
ATOM    612  CG  LYS    80       3.383   7.190  -7.587  1.00 35.39           C
ATOM    613  CD  LYS    80       2.995   5.798  -8.046  1.00 42.35           C
ATOM    614  CE  LYS    80       4.053   5.225  -8.976  1.00 58.22           C
ATOM    615  NZ  LYS    80       3.737   3.844  -9.433  1.00 69.00           N
ATOM    616  O   LYS    80       0.456  10.131  -6.291  1.00 30.53           O
ATOM    617  N   VAL    81      -1.074   8.480  -6.213  1.00 22.03           N
ATOM    618  CA  VAL    81      -2.047   9.257  -5.448  1.00 29.89           C
ATOM    619  CB  VAL    81      -3.468   9.155  -6.065  1.00 29.34           C
ATOM    620  CG1 VAL    81      -4.430  10.081  -5.349  1.00 27.61           C
ATOM    621  CG2 VAL    81      -3.430   9.479  -7.554  1.00 26.33           C
ATOM    622  C   VAL    81      -2.084   8.812  -3.983  1.00 32.41           C
ATOM    623  O   VAL    81      -2.341   7.647  -3.690  1.00 34.11           O
ATOM    624  N   VAL    82      -1.806   9.737  -3.071  1.00 30.28           N
ATOM    625  CA  VAL    82      -1.886   9.450  -1.647  1.00 24.58           C
ATOM    626  CB  VAL    82      -0.584   9.814  -0.917  1.00 27.13           C
ATOM    627  CG1 VAL    82      -0.712   9.520   0.570  1.00 27.30           C
ATOM    628  CG2 VAL    82       0.596   9.060  -1.518  1.00 18.42           C
ATOM    629  C   VAL    82      -3.029  10.247  -1.037  1.00 27.75           C
ATOM    630  O   VAL    82      -3.064  11.468  -1.140  1.00 27.86           O
ATOM    631  N   VAL    83      -3.970   9.548  -0.414  1.00 25.86           N
ATOM    632  CA  VAL    83      -5.099  10.198   0.224  1.00 26.95           C
ATOM    633  CB  VAL    83      -6.426   9.521  -0.152  1.00 33.42           C
ATOM    634  CG1 VAL    83      -7.609  10.406   0.243  1.00 31.46           C
ATOM    635  CG2 VAL    83      -6.454   9.226  -1.636  1.00 37.17           C
ATOM    636  C   VAL    83      -4.929  10.118   1.727  1.00 29.97           C
ATOM    637  O   VAL    83      -4.300   9.192   2.236  1.00 33.29           O
ATOM    638  N   TYR    84      -5.489  11.090   2.437  1.00 28.76           N
ATOM    639  CA  TYR    84      -5.437  11.088   3.892  1.00 22.70           C
ATOM    640  CB  TYR    84      -4.109  11.673   4.394  1.00 23.70           C
ATOM    641  CG  TYR    84      -3.922  13.174   4.208  1.00 22.59           C
ATOM    642  CD1 TYR    84      -4.302  14.067   5.204  1.00 25.05           C
ATOM    643  CE1 TYR    84      -4.120  15.433   5.057  1.00 24.38           C
ATOM    644  CZ  TYR    84      -3.543  15.924   3.908  1.00 29.29           C
ATOM    645  OH  TYR    84      -3.365  17.283   3.771  1.00 28.86           O
ATOM    646  CE2 TYR    84      -3.144  15.060   2.901  1.00 29.54           C
ATOM    647  CD2 TYR    84      -3.328  13.691   3.059  1.00 27.85           C
ATOM    648  C   TYR    84      -6.625  11.808   4.524  1.00 25.65           C
ATOM    649  O   TYR    84      -7.168  12.754   3.955  1.00 28.74           O
ATOM    650  N   ASP    85      -7.043  11.321   5.687  1.00 28.55           N
ATOM    651  CA  ASP    85      -7.975  12.047   6.542  1.00 29.47           C
ATOM    652  CB  ASP    85      -9.270  11.258   6.788  1.00 31.81           C
ATOM    653  CG  ASP    85      -9.031   9.917   7.460  1.00 41.96           C
ATOM    654  OD1 ASP    85      -7.857   9.555   7.677  1.00 44.75           O
ATOM    655  OD2 ASP    85     -10.029   9.224   7.767  1.00 44.78           O
ATOM    656  C   ASP    85      -7.261  12.385   7.847  1.00 32.18           C
ATOM    657  O   ASP    85      -6.040  12.518   7.871  1.00 29.69           O
ATOM    658  N   GLN    86      -8.004  12.518   8.936  1.00 37.70           N
ATOM    659  CA  GLN    86      -7.394  12.974  10.178  1.00 36.77           C
ATOM    660  CB  GLN    86      -8.448  13.568  11.124  1.00 38.36           C
ATOM    661  CG  GLN    86      -7.866  14.223  12.381  1.00 39.57           C
ATOM    662  CD  GLN    86      -6.771  15.242  12.079  1.00 48.25           C
ATOM    663  OE1 GLN    86      -6.795  15.917  11.048  1.00 56.78           O
ATOM    664  NE2 GLN    86      -5.805  15.359  12.989  1.00 44.21           N
ATOM    665  C   GLN    86      -6.548  11.906  10.883  1.00 33.44           C
ATOM    666  O   GLN    86      -5.439  12.195  11.344  1.00 33.95           O
ATOM    667  N   SER    87      -7.048  10.675  10.960  1.00 29.04           N
ATOM    668  CA  SER    87      -6.357   9.666  11.751  1.00 30.16           C
ATOM    669  C   SER    87      -6.733   8.222  11.443  1.00 31.65           C
ATOM    670  CB  SER    87      -6.600   9.929  13.235  1.00 42.21           C
ATOM    671  OG  SER    87      -7.980   9.814  13.535  1.00 47.86           O
ATOM    672  O   SER    87      -6.716   7.383  12.339  1.00 41.52           O
ATOM    673  N   SER    88      -7.066   7.918  10.194  1.00 25.57           N
ATOM    674  CA  SER    88      -7.368   6.535   9.838  1.00 29.73           C
ATOM    675  CB  SER    88      -8.165   6.458   8.536  1.00 32.47           C
ATOM    676  OG  SER    88      -9.444   7.050   8.689  1.00 28.42           O
ATOM    677  C   SER    88      -6.079   5.725   9.738  1.00 36.38           C
ATOM    678  O   SER    88      -5.134   6.126   9.059  1.00 36.76           O
ATOM    679  N   GLN    89      -6.040   4.590  10.429  1.00 40.94           N
ATOM    680  CA  GLN    89      -4.831   3.769  10.487  1.00 45.01           C
ATOM    681  CB  GLN    89      -4.840   2.883  11.737  1.00 46.68           C
ATOM    682  CG  GLN    89      -4.791   3.658  13.040  1.00 54.54           C
ATOM    683  CD  GLN    89      -3.625   4.627  13.098  1.00 61.94           C
ATOM    684  OE1 GLN    89      -2.534   4.332  12.606  1.00 68.37           O
ATOM    685  NE2 GLN    89      -3.848   5.792  13.702  1.00 61.72           N
ATOM    686  C   GLN    89      -4.640   2.913   9.233  1.00 45.74           C
ATOM    687  O   GLN    89      -3.521   2.760   8.741  1.00 45.36           O
ATOM    688  N   ASP    90      -5.735   2.349   8.732  1.00 44.80           N
ATOM    689  CA  ASP    90      -5.703   1.572   7.497  1.00 43.06           C
ATOM    690  CB  ASP    90      -5.192   0.149   7.745  1.00 46.67           C
ATOM    691  CG  ASP    90      -5.937  -0.558   8.859  1.00 46.76           C
ATOM    692  OD1 ASP    90      -7.177  -0.668   8.781  1.00 49.99           O
ATOM    693  OD2 ASP    90      -5.272  -1.019   9.811  1.00 53.06           O
ATOM    694  C   ASP    90      -7.075   1.539   6.849  1.00 32.85           C
ATOM    695  O   ASP    90      -8.063   1.953   7.447  1.00 28.16           O
ATOM    696  N   VAL    91      -7.128   1.050   5.618  1.00 31.60           N
ATOM    697  CA  VAL    91      -8.381   0.989   4.883  1.00 37.21           C
ATOM    698  CB  VAL    91      -8.144   0.520   3.436  1.00 30.78           C
ATOM    699  CG1 VAL    91      -9.463   0.413   2.677  1.00 30.65           C
ATOM    700  CG2 VAL    91      -7.200   1.476   2.735  1.00 27.13           C
ATOM    701  C   VAL    91      -9.409   0.084   5.568  1.00 38.53           C
ATOM    702  O   VAL    91     -10.610   0.355   5.526  1.00 41.48           O
ATOM    703  N   ALA    92      -8.934  -0.980   6.210  1.00 35.68           N
ATOM    704  CA  ALA    92      -9.822  -1.979   6.798  1.00 37.95           C
ATOM    705  CB  ALA    92      -9.032  -3.210   7.230  1.00 33.32           C
ATOM    706  C   ALA    92     -10.618  -1.417   7.967  1.00 49.30           C
ATOM    707  O   ALA    92     -11.691  -1.923   8.294  1.00 62.43           O
ATOM    708  N   SER    93     -10.094  -0.367   8.590  1.00 48.60           N
ATOM    709  CA  SER    93     -10.744   0.231   9.751  1.00 49.77           C
ATOM    710  CB  SER    93      -9.705   0.868  10.683  1.00 54.51           C
ATOM    711  OG  SER    93      -9.043   1.956  10.059  1.00 51.65           O
ATOM    712  C   SER    93     -11.811   1.251   9.351  1.00 53.89           C
ATOM    713  O   SER    93     -12.320   1.995  10.189  1.00 54.84           O
ATOM    714  N   LEU    94     -12.148   1.276   8.066  1.00 55.73           N
ATOM    715  CA  LEU    94     -13.170   2.180   7.551  1.00 48.66           C
ATOM    716  CB  LEU    94     -12.729   2.765   6.210  1.00 42.08           C
ATOM    717  CG  LEU    94     -11.468   3.615   6.262  1.00 35.36           C
ATOM    718  CD1 LEU    94     -11.105   4.100   4.870  1.00 27.43           C
ATOM    719  CD2 LEU    94     -11.684   4.780   7.217  1.00 36.03           C
ATOM    720  C   LEU    94     -14.495   1.451   7.372  1.00 48.47           C
ATOM    721  O   LEU    94     -14.514   0.230   7.178  1.00 40.01           O
ATOM    722  N   SER    95     -15.596   2.201   7.442  1.00 52.46           N
ATOM    723  CA  SER    95     -16.925   1.651   7.190  1.00 50.63           C
ATOM    724  C   SER    95     -17.159   1.596   5.690  1.00 56.42           C
ATOM    725  CB  SER    95     -18.010   2.498   7.851  1.00 50.78           C
ATOM    726  OG  SER    95     -18.616   3.374   6.917  1.00 50.30           O
ATOM    727  O   SER    95     -16.715   2.476   4.953  1.00 61.75           O
ATOM    728  N   SER    96     -17.871   0.568   5.244  1.00 56.64           N
ATOM    729  CA  SER    96     -18.013   0.286   3.819  1.00 55.58           C
ATOM    730  C   SER    96     -18.658   1.406   2.998  1.00 53.11           C
ATOM    731  CB  SER    96     -18.778  -1.023   3.621  1.00 62.80           C
ATOM    732  OG  SER    96     -19.796  -1.164   4.596  1.00 71.52           O
ATOM    733  O   SER    96     -18.521   1.436   1.772  1.00 47.25           O
ATOM    734  N   ASP    97     -19.340   2.330   3.669  1.00 55.96           N
ATOM    735  CA  ASP    97     -20.147   3.327   2.969  1.00 61.79           C
ATOM    736  C   ASP    97     -19.734   4.777   3.230  1.00 59.32           C
ATOM    737  CB  ASP    97     -21.625   3.146   3.328  1.00 72.30           C
ATOM    738  CG  ASP    97     -22.550   3.818   2.334  1.00 80.18           C
ATOM    739  OD1 ASP    97     -22.475   3.476   1.134  1.00 79.71           O
ATOM    740  OD2 ASP    97     -23.353   4.681   2.753  1.00 83.47           O
ATOM    741  O   ASP    97     -20.390   5.706   2.756  1.00 58.99           O
ATOM    742  N   CYS    98     -18.658   4.981   3.982  1.00 56.40           N
ATOM    743  CA  CYS    98     -18.234   6.340   4.303  1.00 47.18           C
ATOM    744  C   CYS    98     -17.609   7.024   3.093  1.00 41.73           C
ATOM    745  CB  CYS    98     -17.273   6.357   5.491  1.00 46.59           C
ATOM    746  SG  CYS    98     -15.637   5.727   5.117  1.00 45.29           S
ATOM    747  O   CYS    98     -17.382   6.397   2.057  1.00 37.79           O
ATOM    748  N   PHE    99     -17.336   8.315   3.233  1.00 41.90           N
ATOM    749  CA  PHE    99     -16.868   9.119   2.113  1.00 41.40           C
ATOM    750  CB  PHE    99     -16.879  10.598   2.481  1.00 36.21           C
ATOM    751  CG  PHE    99     -16.312  11.488   1.417  1.00 34.62           C
ATOM    752  CD1 PHE    99     -17.057  11.801   0.294  1.00 32.58           C
ATOM    753  CE1 PHE    99     -16.541  12.625  -0.685  1.00 37.40           C
ATOM    754  CZ  PHE    99     -15.265  13.148  -0.549  1.00 40.15           C
ATOM    755  CE2 PHE    99     -14.509  12.846   0.571  1.00 31.64           C
ATOM    756  CD2 PHE    99     -15.034  12.018   1.546  1.00 30.29           C
ATOM    757  C   PHE    99     -15.480   8.705   1.636  1.00 42.36           C
ATOM    758  O   PHE    99     -15.273   8.459   0.448  1.00 44.78           O
ATOM    759  N   LEU   100     -14.535   8.637   2.566  1.00 34.66           N
ATOM    760  CA  LEU   100     -13.169   8.226   2.259  1.00 35.24           C
ATOM    761  CB  LEU   100     -12.367   8.110   3.552  1.00 38.29           C
ATOM    762  CG  LEU   100     -10.927   7.639   3.387  1.00 36.62           C
ATOM    763  CD1 LEU   100     -10.255   8.408   2.258  1.00 34.17           C
ATOM    764  CD2 LEU   100     -10.178   7.813   4.692  1.00 36.62           C
ATOM    765  C   LEU   100     -13.117   6.900   1.493  1.00 34.33           C
ATOM    766  O   LEU   100     -12.376   6.755   0.520  1.00 34.59           O
ATOM    767  N   THR   101     -13.912   5.940   1.952  1.00 38.35           N
ATOM    768  CA  THR   101     -14.047   4.633   1.313  1.00 37.66           C
ATOM    769  CB  THR   101     -15.000   3.735   2.123  1.00 41.40           C
ATOM    770  OG1 THR   101     -14.321   3.245   3.286  1.00 40.00           O
ATOM    771  CG2 THR   101     -15.471   2.559   1.281  1.00 44.07           C
ATOM    772  C   THR   101     -14.579   4.752  -0.112  1.00 36.46           C
ATOM    773  O   THR   101     -14.073   4.110  -1.034  1.00 35.84           O
ATOM    774  N   VAL   102     -15.620   5.563  -0.278  1.00 35.16           N
ATOM    775  CA  VAL   102     -16.142   5.894  -1.597  1.00 33.01           C
ATOM    776  CB  VAL   102     -17.358   6.826  -1.492  1.00 29.72           C
ATOM    777  CG1 VAL   102     -17.696   7.412  -2.863  1.00 24.15           C
ATOM    778  CG2 VAL   102     -18.539   6.075  -0.910  1.00 26.78           C
ATOM    779  C   VAL   102     -15.080   6.582  -2.449  1.00 38.67           C
ATOM    780  O   VAL   102     -14.932   6.287  -3.633  1.00 44.93           O
ATOM    781  N   LEU   103     -14.346   7.504  -1.836  1.00 32.39           N
ATOM    782  CA  LEU   103     -13.302   8.248  -2.524  1.00 21.76           C
ATOM    783  CB  LEU   103     -12.702   9.295  -1.585  1.00 18.67           C
ATOM    784  CG  LEU   103     -11.684  10.243  -2.219  1.00 29.54           C
ATOM    785  CD1 LEU   103     -12.369  11.155  -3.225  1.00 33.17           C
ATOM    786  CD2 LEU   103     -10.969  11.053  -1.147  1.00 33.15           C
ATOM    787  C   LEU   103     -12.209   7.318  -3.059  1.00 29.60           C
ATOM    788  O   LEU   103     -11.760   7.469  -4.194  1.00 30.18           O
ATOM    789  N   LEU   104     -11.792   6.355  -2.239  1.00 34.80           N
ATOM    790  CA  LEU   104     -10.746   5.408  -2.631  1.00 37.26           C
ATOM    791  CB  LEU   104     -10.338   4.519  -1.447  1.00 31.68           C
ATOM    792  CG  LEU   104      -9.508   5.198  -0.353  1.00 31.71           C
ATOM    793  CD1 LEU   104      -9.511   4.384   0.941  1.00 25.38           C
ATOM    794  CD2 LEU   104      -8.082   5.450  -0.835  1.00 16.05           C
ATOM    795  C   LEU   104     -11.158   4.546  -3.825  1.00 32.47           C
ATOM    796  O   LEU   104     -10.351   4.270  -4.714  1.00 28.79           O
ATOM    797  N   GLY   105     -12.416   4.121  -3.840  1.00 33.19           N
ATOM    798  CA  GLY   105     -12.933   3.326  -4.937  1.00 32.37           C
ATOM    799  C   GLY   105     -12.839   4.080  -6.251  1.00 33.24           C
ATOM    800  O   GLY   105     -12.283   3.581  -7.227  1.00 35.42           O
ATOM    801  N   LYS   106     -13.382   5.292  -6.270  1.00 25.29           N
ATOM    802  CA  LYS   106     -13.349   6.124  -7.466  1.00 26.60           C
ATOM    803  C   LYS   106     -11.919   6.386  -7.925  1.00 23.49           C
ATOM    804  CB  LYS   106     -14.073   7.449  -7.212  1.00 28.36           C
ATOM    805  CG  LYS   106     -15.549   7.285  -6.949  1.00 23.75           C
ATOM    806  CD  LYS   106     -16.165   6.468  -8.058  1.00 36.12           C
ATOM    807  CE  LYS   106     -17.453   5.799  -7.621  1.00 44.68           C
ATOM    808  NZ  LYS   106     -18.068   5.065  -8.758  1.00 52.89           N
ATOM    809  O   LYS   106     -11.634   6.390  -9.121  1.00 29.67           O
ATOM    810  N   LEU   107     -11.024   6.607  -6.965  1.00 27.45           N
ATOM    811  CA  LEU   107      -9.634   6.912  -7.273  1.00 27.78           C
ATOM    812  CB  LEU   107      -8.902   7.415  -6.032  1.00 26.49           C
ATOM    813  CG  LEU   107      -9.120   8.866  -5.625  1.00 21.02           C
ATOM    814  CD1 LEU   107      -8.520   9.101  -4.249  1.00 20.09           C
ATOM    815  CD2 LEU   107      -8.500   9.805  -6.647  1.00 18.87           C
ATOM    816  C   LEU   107      -8.906   5.696  -7.827  1.00 27.48           C
ATOM    817  O   LEU   107      -8.111   5.816  -8.761  1.00 29.63           O
ATOM    818  N   GLU   108      -9.170   4.528  -7.247  1.00 24.78           N
ATOM    819  CA  GLU   108      -8.494   3.311  -7.684  1.00 33.49           C
ATOM    820  CB  GLU   108      -8.763   2.137  -6.741  1.00 30.59           C
ATOM    821  CG  GLU   108      -7.745   2.007  -5.626  1.00 34.19           C
ATOM    822  CD  GLU   108      -7.806   0.656  -4.941  1.00 42.70           C
ATOM    823  OE1 GLU   108      -8.359  -0.295  -5.543  1.00 43.25           O
ATOM    824  OE2 GLU   108      -7.297   0.549  -3.804  1.00 37.85           O
ATOM    825  C   GLU   108      -8.888   2.950  -9.106  1.00 37.32           C
ATOM    826  O   GLU   108      -8.174   2.203  -9.777  1.00 40.34           O
ATOM    827  N   LYS   109     -10.020   3.488  -9.558  1.00 27.96           N
ATOM    828  CA  LYS   109     -10.499   3.251 -10.917  1.00 26.39           C
ATOM    829  C   LYS   109      -9.851   4.188 -11.940  1.00 18.13           C
ATOM    830  CB  LYS   109     -12.026   3.373 -10.987  1.00 27.54           C
ATOM    831  CG  LYS   109     -12.787   2.140 -10.518  1.00 39.68           C
ATOM    832  CD  LYS   109     -14.001   1.886 -11.408  1.00 58.02           C
ATOM    833  CE  LYS   109     -14.878   0.764 -10.872  1.00 71.99           C
ATOM    834  NZ  LYS   109     -15.717   1.215  -9.719  1.00 82.27           N
ATOM    835  O   LYS   109      -9.703   3.835 -13.100  1.00 25.33           O
ATOM    836  N   SER   110      -9.469   5.382 -11.501  1.00 22.12           N
ATOM    837  CA  SER   110      -8.904   6.387 -12.394  1.00 22.40           C
ATOM    838  CB  SER   110      -9.524   7.765 -12.118  1.00 23.58           C
ATOM    839  OG  SER   110     -10.836   7.851 -12.651  1.00 27.93           O
ATOM    840  C   SER   110      -7.383   6.469 -12.297  1.00 28.42           C
ATOM    841  O   SER   110      -6.734   7.035 -13.183  1.00 22.84           O
ATOM    842  N   PHE   111      -6.824   5.911 -11.222  1.00 33.62           N
ATOM    843  CA  PHE   111      -5.373   5.888 -11.012  1.00 29.22           C
ATOM    844  CB  PHE   111      -4.973   6.876  -9.915  1.00 31.53           C
ATOM    845  CG  PHE   111      -5.332   8.299 -10.221  1.00 32.74           C
ATOM    846  CD1 PHE   111      -6.556   8.822  -9.817  1.00 28.97           C
ATOM    847  CE1 PHE   111      -6.892  10.137 -10.096  1.00 21.53           C
ATOM    848  CZ  PHE   111      -6.001  10.942 -10.787  1.00 22.95           C
ATOM    849  CE2 PHE   111      -4.774  10.429 -11.199  1.00 24.35           C
ATOM    850  CD2 PHE   111      -4.447   9.116 -10.912  1.00 27.86           C
ATOM    851  C   PHE   111      -4.851   4.494 -10.657  1.00 25.54           C
ATOM    852  O   PHE   111      -5.482   3.755  -9.902  1.00 27.19           O
ATOM    853  N   ASN   112      -3.682   4.154 -11.190  1.00 23.97           N
ATOM    854  CA  ASN   112      -3.085   2.834 -10.995  1.00 31.83           C
ATOM    855  CB  ASN   112      -1.892   2.642 -11.935  1.00 39.41           C
ATOM    856  CG  ASN   112      -2.288   2.637 -13.395  1.00 32.74           C
ATOM    857  OD1 ASN   112      -3.321   2.074 -13.774  1.00 29.58           O
ATOM    858  ND2 ASN   112      -1.456   3.257 -14.229  1.00 25.56           N
ATOM    859  C   ASN   112      -2.621   2.569  -9.570  1.00 27.70           C
ATOM    860  O   ASN   112      -2.783   1.465  -9.052  1.00 36.92           O
ATOM    861  N   SER   113      -2.017   3.581  -8.955  1.00 27.06           N
ATOM    862  CA  SER   113      -1.507   3.470  -7.592  1.00 28.53           C
ATOM    863  CB  SER   113       0.005   3.727  -7.555  1.00 36.90           C
ATOM    864  OG  SER   113       0.738   2.519  -7.673  1.00 53.38           O
ATOM    865  C   SER   113      -2.212   4.441  -6.666  1.00 24.37           C
ATOM    866  O   SER   113      -1.966   5.644  -6.718  1.00 29.81           O
ATOM    867  N   VAL   114      -3.088   3.911  -5.819  1.00 30.18           N
ATOM    868  CA  VAL   114      -3.810   4.722  -4.847  1.00 29.32           C
ATOM    869  CB  VAL   114      -5.326   4.729  -5.129  1.00 30.16           C
ATOM    870  CG1 VAL   114      -6.069   5.530  -4.054  1.00 29.59           C
ATOM    871  CG2 VAL   114      -5.604   5.285  -6.515  1.00 29.04           C
ATOM    872  C   VAL   114      -3.564   4.186  -3.441  1.00 22.61           C
ATOM    873  O   VAL   114      -3.823   3.018  -3.170  1.00 27.56           O
ATOM    874  N   HIS   115      -3.074   5.047  -2.552  1.00 24.69           N
ATOM    875  CA  HIS   115      -2.744   4.638  -1.187  1.00 28.03           C
ATOM    876  CB  HIS   115      -1.233   4.452  -1.051  1.00 24.44           C
ATOM    877  CG  HIS   115      -0.667   3.516  -2.067  1.00 24.97           C
ATOM    878  ND1 HIS   115      -0.853   2.151  -2.004  1.00 36.98           N
ATOM    879  CE1 HIS   115      -0.262   1.577  -3.036  1.00 37.25           C
ATOM    880  NE2 HIS   115       0.295   2.523  -3.773  1.00 28.51           N
ATOM    881  CD2 HIS   115       0.052   3.744  -3.192  1.00 21.83           C
ATOM    882  C   HIS   115      -3.261   5.580  -0.110  1.00 24.77           C
ATOM    883  O   HIS   115      -3.231   6.800  -0.261  1.00 24.97           O
ATOM    884  N   LEU   116      -3.739   4.992   0.981  1.00 22.93           N
ATOM    885  CA  LEU   116      -4.151   5.751   2.148  1.00 23.17           C
ATOM    886  CB  LEU   116      -5.210   4.967   2.928  1.00 22.44           C
ATOM    887  CG  LEU   116      -5.790   5.538   4.227  1.00 33.60           C
ATOM    888  CD1 LEU   116      -6.558   6.831   3.978  1.00 35.46           C
ATOM    889  CD2 LEU   116      -6.696   4.509   4.891  1.00 34.38           C
ATOM    890  C   LEU   116      -2.926   5.991   3.024  1.00 27.32           C
ATOM    891  O   LEU   116      -2.084   5.110   3.176  1.00 28.52           O
ATOM    892  N   LEU   117      -2.821   7.180   3.601  1.00 20.78           N
ATOM    893  CA  LEU   117      -1.708   7.467   4.490  1.00 22.95           C
ATOM    894  CB  LEU   117      -1.441   8.971   4.573  1.00 31.00           C
ATOM    895  CG  LEU   117      -0.196   9.387   5.365  1.00 28.22           C
ATOM    896  CD1 LEU   117       1.073   8.961   4.650  1.00 25.66           C
ATOM    897  CD2 LEU   117      -0.200  10.885   5.593  1.00 31.88           C
ATOM    898  C   LEU   117      -1.988   6.892   5.875  1.00 24.73           C
ATOM    899  O   LEU   117      -3.001   7.206   6.495  1.00 18.25           O
ATOM    900  N   ALA   118      -1.086   6.039   6.347  1.00 30.02           N
ATOM    901  CA  ALA   118      -1.235   5.397   7.643  1.00 28.97           C
ATOM    902  CB  ALA   118      -0.176   4.317   7.809  1.00 28.11           C
ATOM    903  C   ALA   118      -1.142   6.426   8.772  1.00 29.45           C
ATOM    904  O   ALA   118      -0.091   7.029   8.988  1.00 36.88           O
ATOM    905  N   GLY   119      -2.247   6.632   9.479  1.00 26.95           N
ATOM    906  CA  GLY   119      -2.270   7.547  10.608  1.00 22.59           C
ATOM    907  C   GLY   119      -2.792   8.930  10.267  1.00 21.17           C
ATOM    908  O   GLY   119      -3.057   9.739  11.151  1.00 30.70           O
ATOM    909  N   GLY   120      -2.931   9.208   8.977  1.00 19.11           N
ATOM    910  CA  GLY   120      -3.505  10.463   8.534  1.00 19.09           C
ATOM    911  C   GLY   120      -2.672  11.682   8.872  1.00 25.59           C
ATOM    912  O   GLY   120      -1.493  11.575   9.217  1.00 27.42           O
ATOM    913  N   PHE   121      -3.297  12.851   8.767  1.00 31.24           N
ATOM    914  CA  PHE   121      -2.609  14.112   8.999  1.00 33.12           C
ATOM    915  CB  PHE   121      -3.539  15.304   8.727  1.00 34.46           C
ATOM    916  CG  PHE   121      -2.867  16.635   8.891  1.00 34.02           C
ATOM    917  CD1 PHE   121      -1.989  17.104   7.925  1.00 26.81           C
ATOM    918  CE1 PHE   121      -1.356  18.318   8.078  1.00 21.42           C
ATOM    919  CZ  PHE   121      -1.586  19.078   9.208  1.00 24.76           C
ATOM    920  CE2 PHE   121      -2.454  18.622  10.181  1.00 26.53           C
ATOM    921  CD2 PHE   121      -3.089  17.404  10.021  1.00 32.65           C
ATOM    922  C   PHE   121      -2.058  14.178  10.419  1.00 32.13           C
ATOM    923  O   PHE   121      -1.028  14.804  10.663  1.00 26.92           O
ATOM    924  N   ALA   122      -2.757  13.521  11.344  1.00 36.55           N
ATOM    925  CA  ALA   122      -2.364  13.475  12.751  1.00 39.32           C
ATOM    926  CB  ALA   122      -3.326  12.594  13.546  1.00 42.38           C
ATOM    927  C   ALA   122      -0.936  12.980  12.925  1.00 40.07           C
ATOM    928  O   ALA   122      -0.118  13.634  13.573  1.00 47.62           O
ATOM    929  N   GLU   123      -0.637  11.819  12.356  1.00 39.23           N
ATOM    930  CA  GLU   123       0.718  11.301  12.432  1.00 34.22           C
ATOM    931  CB  GLU   123       0.788   9.824  12.062  1.00 38.22           C
ATOM    932  CG  GLU   123       2.210   9.299  12.072  1.00 58.96           C
ATOM    933  CD  GLU   123       2.283   7.791  12.133  1.00 79.25           C
ATOM    934  OE1 GLU   123       1.242   7.160  12.412  1.00 85.83           O
ATOM    935  OE2 GLU   123       3.383   7.239  11.907  1.00 86.33           O
ATOM    936  C   GLU   123       1.673  12.098  11.560  1.00 38.00           C
ATOM    937  O   GLU   123       2.773  12.424  11.993  1.00 48.50           O
ATOM    938  N   PHE   124       1.266  12.422  10.336  1.00 35.64           N
ATOM    939  CA  PHE   124       2.173  13.151   9.454  1.00 33.86           C
ATOM    940  CB  PHE   124       1.583  13.379   8.066  1.00 27.80           C
ATOM    941  CG  PHE   124       2.552  14.028   7.116  1.00 30.57           C
ATOM    942  CD1 PHE   124       3.429  13.258   6.365  1.00 27.33           C
ATOM    943  CE1 PHE   124       4.335  13.852   5.498  1.00 27.90           C
ATOM    944  CZ  PHE   124       4.382  15.231   5.384  1.00 28.09           C
ATOM    945  CE2 PHE   124       3.519  16.009   6.135  1.00 34.46           C
ATOM    946  CD2 PHE   124       2.615  15.406   7.002  1.00 31.74           C
ATOM    947  C   PHE   124       2.614  14.491  10.040  1.00 35.06           C
ATOM    948  O   PHE   124       3.802  14.819  10.037  1.00 32.65           O
ATOM    949  N   SER   125       1.652  15.268  10.523  1.00 32.61           N
ATOM    950  CA  SER   125       1.959  16.560  11.115  1.00 37.08           C
ATOM    951  C   SER   125       2.790  16.394  12.394  1.00 45.32           C
ATOM    952  CB  SER   125       0.674  17.339  11.396  1.00 32.14           C
ATOM    953  OG  SER   125      -0.150  16.649  12.316  1.00 39.87           O
ATOM    954  O   SER   125       3.545  17.290  12.779  1.00 40.44           O
ATOM    955  N   ARG   126       2.653  15.235  13.034  1.00 49.39           N
ATOM    956  CA  ARG   126       3.380  14.923  14.261  1.00 47.74           C
ATOM    957  C   ARG   126       4.867  14.679  13.992  1.00 46.97           C
ATOM    958  CB  ARG   126       2.751  13.702  14.945  1.00 54.45           C
ATOM    959  CG  ARG   126       3.395  13.301  16.268  1.00 69.39           C
ATOM    960  CD  ARG   126       2.634  12.166  16.952  1.00 76.01           C
ATOM    961  NE  ARG   126       2.514  10.989  16.093  1.00 84.08           N
ATOM    962  CZ  ARG   126       3.371   9.972  16.086  1.00 87.77           C
ATOM    963  NH1 ARG   126       4.420   9.976  16.898  1.00 87.98           N
ATOM    964  NH2 ARG   126       3.178   8.948  15.266  1.00 87.62           N
ATOM    965  O   ARG   126       5.716  14.975  14.835  1.00 46.55           O
ATOM    966  N   CYS   127       5.173  14.152  12.808  1.00 46.74           N
ATOM    967  CA  CYS   127       6.541  13.785  12.432  1.00 43.63           C
ATOM    968  CB  CYS   127       6.548  12.464  11.651  1.00 49.03           C
ATOM    969  SG  CYS   127       5.830  11.039  12.508  1.00 50.28           S
ATOM    970  C   CYS   127       7.248  14.860  11.600  1.00 40.55           C
ATOM    971  O   CYS   127       8.428  15.146  11.811  1.00 47.00           O
ATOM    972  N   PHE   128       6.530  15.438  10.644  1.00 33.20           N
ATOM    973  CA  PHE   128       7.105  16.447   9.764  1.00 27.30           C
ATOM    974  CB  PHE   128       7.208  15.914   8.341  1.00 24.79           C
ATOM    975  CG  PHE   128       8.040  14.673   8.228  1.00 34.58           C
ATOM    976  CD1 PHE   128       7.446  13.423   8.233  1.00 39.61           C
ATOM    977  CE1 PHE   128       8.218  12.272   8.133  1.00 43.30           C
ATOM    978  CZ  PHE   128       9.593  12.367   8.032  1.00 37.85           C
ATOM    979  CE2 PHE   128      10.196  13.610   8.032  1.00 32.24           C
ATOM    980  CD2 PHE   128       9.422  14.754   8.131  1.00 33.74           C
ATOM    981  C   PHE   128       6.281  17.715   9.782  1.00 34.76           C
ATOM    982  O   PHE   128       5.480  17.954   8.884  1.00 37.57           O
ATOM    983  N   PRO   129       6.476  18.534  10.819  1.00 44.79           N
ATOM    984  CA  PRO   129       5.737  19.788  10.969  1.00 41.52           C
ATOM    985  CB  PRO   129       6.122  20.254  12.380  1.00 37.72           C
ATOM    986  CG  PRO   129       6.759  19.052  13.043  1.00 40.79           C
ATOM    987  CD  PRO   129       7.405  18.305  11.936  1.00 45.11           C
ATOM    988  C   PRO   129       6.190  20.807   9.927  1.00 45.62           C
ATOM    989  O   PRO   129       5.386  21.643   9.495  1.00 42.72           O
ATOM    990  N   GLY   130       7.462  20.729   9.532  1.00 40.66           N
ATOM    991  CA  GLY   130       8.015  21.630   8.536  1.00 40.82           C
ATOM    992  C   GLY   130       7.479  21.374   7.138  1.00 42.73           C
ATOM    993  O   GLY   130       7.751  22.134   6.208  1.00 40.06           O
ATOM    994  N   LEU   131       6.702  20.304   6.992  1.00 46.45           N
ATOM    995  CA  LEU   131       6.125  19.943   5.702  1.00 38.75           C
ATOM    996  CB  LEU   131       6.449  18.487   5.372  1.00 40.26           C
ATOM    997  CG  LEU   131       7.953  18.241   5.246  1.00 41.66           C
ATOM    998  CD1 LEU   131       8.237  16.782   4.943  1.00 38.33           C
ATOM    999  CD2 LEU   131       8.553  19.156   4.181  1.00 41.19           C
ATOM   1000  C   LEU   131       4.618  20.195   5.640  1.00 31.58           C
ATOM   1001  O   LEU   131       3.929  19.700   4.746  1.00 26.81           O
ATOM   1002  N   CYS   132       4.116  20.975   6.591  1.00 38.06           N
ATOM   1003  CA  CYS   132       2.708  21.348   6.619  1.00 46.30           C
ATOM   1004  CB  CYS   132       2.057  20.898   7.932  1.00 50.21           C
ATOM   1005  SG  CYS   132       2.349  19.160   8.367  1.00 37.07           S
ATOM   1006  C   CYS   132       2.535  22.857   6.418  1.00 47.00           C
ATOM   1007  O   CYS   132       3.378  23.651   6.836  1.00 53.23           O
ATOM   1008  N   GLU   133       1.439  23.238   5.771  1.00 44.36           N
ATOM   1009  CA  GLU   133       1.173  24.631   5.441  1.00 48.73           C
ATOM   1010  C   GLU   133      -0.093  25.086   6.145  1.00 52.20           C
ATOM   1011  CB  GLU   133       1.006  24.796   3.929  1.00 53.88           C
ATOM   1012  CG  GLU   133       2.196  24.327   3.105  1.00 68.87           C
ATOM   1013  CD  GLU   133       1.926  24.361   1.606  1.00 85.09           C
ATOM   1014  OE1 GLU   133       0.743  24.482   1.208  1.00 87.01           O
ATOM   1015  OE2 GLU   133       2.899  24.263   0.824  1.00 92.18           O
ATOM   1016  O   GLU   133      -1.108  24.398   6.105  1.00 51.09           O
ATOM   1017  N   GLY   134      -0.034  26.251   6.781  1.00 65.46           N
ATOM   1018  CA  GLY   134      -1.159  26.755   7.548  1.00 68.23           C
ATOM   1019  C   GLY   134      -1.799  27.989   6.946  1.00 65.42           C
ATOM   1020  O   GLY   134      -2.452  28.761   7.650  1.00 62.45           O
END
