
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  171 ( 1361),  selected  171 , name 2gs3_A
# Molecule2: number of CA atoms  174 ( 1411),  selected  174 , name T0388.pdb
# PARAMETERS: 2gs3_A.T0388.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T    27_A      E       1           -
LGA    E    28_A      N       2           -
LGA    N    29_A      L       3           -
LGA    L    30_A      Y       4           -
LGA    Y    31_A      -       -           -
LGA    F    32_A      -       -           -
LGA    Q    33_A      -       -           -
LGA    S    34_A      F       5          6.191
LGA    M    35_A      Q       6           -
LGA    R    36_A      S       7          6.189
LGA    C    37_A      M       8          3.485
LGA    A    38_A      I       9          1.029
LGA    R    39_A      N      10          0.777
LGA    S    40_A      S      11          0.512
LGA    M    41_A      F      12          0.879
LGA    H    42_A      Y      13          1.794
LGA    E    43_A      A      14          1.381
LGA    F    44_A      F      15          0.634
LGA    S    45_A      E      16          1.002
LGA    A    46_A      V      17          0.380
LGA    K    47_A      K      18          0.536
LGA    D    48_A      D      19          0.785
LGA    I    49_A      A      20          0.740
LGA    D    50_A      K      21          1.496
LGA    G    51_A      G      22          1.281
LGA    H    52_A      R      23          1.379
LGA    M    53_A      T      24          1.044
LGA    V    54_A      V      25          1.006
LGA    N    55_A      S      26          0.655
LGA    L    56_A      L      27          0.632
LGA    D    57_A      E      28          0.883
LGA    K    58_A      K      29          0.613
LGA    Y    59_A      Y      30          0.564
LGA    R    60_A      K      31          0.857
LGA    G    61_A      G      32          1.061
LGA    F    62_A      K      33          0.578
LGA    V    63_A      V      34          0.420
LGA    C    64_A      S      35          0.254
LGA    I    65_A      L      36          0.457
LGA    V    66_A      V      37          0.493
LGA    T    67_A      V      38          0.516
LGA    N    68_A      N      39          0.315
LGA    V    69_A      V      40          0.233
LGA    A    70_A      A      41          0.285
LGA    S    71_A      S      42          0.315
LGA    Q    72_A      D      43          0.591
LGA    G    73_A      C      44          0.897
LGA    G    74_A      Q      45          0.843
LGA    K    75_A      L      46          0.496
LGA    T    76_A      T      47          0.347
LGA    E    77_A      D      48          0.329
LGA    V    78_A      R      49          0.311
LGA    N    79_A      N      50          0.216
LGA    Y    80_A      Y      51          0.204
LGA    T    81_A      L      52          0.328
LGA    Q    82_A      G      53          0.539
LGA    L    83_A      L      54          0.346
LGA    V    84_A      K      55          0.510
LGA    D    85_A      E      56          0.766
LGA    L    86_A      L      57          0.717
LGA    H    87_A      H      58          0.677
LGA    A    88_A      K      59          0.826
LGA    R    89_A      E      60          1.056
LGA    Y    90_A      F      61          0.993
LGA    A    91_A      G      62          0.789
LGA    E    92_A      P      63          5.040
LGA    C    93_A      S      64           #
LGA    G    94_A      H      65          1.102
LGA    L    95_A      F      66          1.207
LGA    R    96_A      S      67          0.428
LGA    I    97_A      V      68          0.888
LGA    L    98_A      L      69          0.617
LGA    A    99_A      A      70          0.315
LGA    F   100_A      F      71          0.350
LGA    P   101_A      P      72          0.372
LGA    C   102_A      C      73          0.089
LGA    N   103_A      N      74          0.159
LGA    Q   104_A      Q      75          0.177
LGA    F   105_A      F      76          0.407
LGA    G   106_A      G      77          0.674
LGA    K   107_A      E      78          0.358
LGA    Q   108_A      S      79          0.509
LGA    E   109_A      E      80          0.244
LGA    P   110_A      P      81          0.401
LGA    G   111_A      R      82          0.354
LGA    S   112_A      P      83          0.477
LGA    N   113_A      S      84          1.070
LGA    E   114_A      K      85          1.840
LGA    E   115_A      E      86          1.319
LGA    I   116_A      V      87          0.454
LGA    K   117_A      E      88          1.345
LGA    E   118_A      S      89          1.380
LGA    F   119_A      F      90          0.690
LGA    A   120_A      A      91          0.553
LGA    A   121_A      R      92          0.914
LGA    G   122_A      K      93          2.241
LGA    -       -      N      94           -
LGA    Y   123_A      Y      95          0.755
LGA    N   124_A      G      96          0.493
LGA    V   125_A      V      97          1.011
LGA    K   126_A      T      98          0.221
LGA    F   127_A      F      99          0.285
LGA    D   128_A      P     100          0.661
LGA    M   129_A      I     101          0.753
LGA    F   130_A      F     102          0.276
LGA    S   131_A      H     103          0.296
LGA    K   132_A      K     104          0.257
LGA    I   133_A      I     105          0.325
LGA    C   134_A      K     106          0.652
LGA    V   135_A      I     107          1.068
LGA    N   136_A      L     108          1.334
LGA    G   137_A      G     109          1.133
LGA    D   138_A      S     110          0.654
LGA    D   139_A      E     111          0.625
LGA    A   140_A      G     112          0.583
LGA    H   141_A      E     113          0.278
LGA    P   142_A      P     114          0.278
LGA    L   143_A      A     115          1.091
LGA    W   144_A      F     116          1.442
LGA    K   145_A      R     117          1.316
LGA    W   146_A      F     118          1.371
LGA    M   147_A      L     119          1.102
LGA    K   148_A      V     120          0.955
LGA    I   149_A      D     121          1.363
LGA    Q   150_A      S     122          1.037
LGA    P   151_A      -       -           -
LGA    K   152_A      -       -           -
LGA    G   153_A      S     123          1.383
LGA    K   154_A      K     124          2.211
LGA    G   155_A      K     125          2.701
LGA    I   156_A      -       -           -
LGA    L   157_A      -       -           -
LGA    G   158_A      -       -           -
LGA    N   159_A      -       -           -
LGA    A   160_A      E     126          2.237
LGA    I   161_A      P     127          1.140
LGA    K   162_A      R     128          0.875
LGA    W   163_A      W     129          0.461
LGA    N   164_A      N     130          0.176
LGA    F   165_A      F     131          0.257
LGA    T   166_A      W     132          0.407
LGA    K   167_A      K     133          0.435
LGA    F   168_A      Y     134          0.371
LGA    L   169_A      L     135          0.307
LGA    I   170_A      V     136          0.386
LGA    D   171_A      N     137          0.525
LGA    K   172_A      P     138          0.576
LGA    N   173_A      E     139          0.722
LGA    G   174_A      G     140          0.672
LGA    C   175_A      Q     141          0.584
LGA    V   176_A      V     142          0.429
LGA    V   177_A      V     143          0.730
LGA    K   178_A      K     144          0.397
LGA    R   179_A      F     145          0.622
LGA    Y   180_A      W     146          0.615
LGA    G   181_A      R     147          0.886
LGA    P   182_A      P     148          1.378
LGA    M   183_A      E     149          1.288
LGA    E   184_A      E     150          1.334
LGA    E   185_A      P     151          2.920
LGA    P   186_A      I     152          3.603
LGA    L   187_A      E     153          4.064
LGA    V   188_A      V     154          2.423
LGA    I   189_A      I     155          1.101
LGA    E   190_A      R     156          0.349
LGA    K   191_A      P     157          0.693
LGA    D   192_A      D     158          0.693
LGA    L   193_A      I     159          1.452
LGA    P   194_A      A     160          2.657
LGA    H   195_A      A     161          2.509
LGA    Y   196_A      L     162          1.412
LGA    F   197_A      V     163          1.657
LGA    -       -      R     164           -
LGA    -       -      Q     165           -
LGA    -       -      V     166           -
LGA    -       -      I     167           -
LGA    -       -      I     168           -
LGA    -       -      K     169           -
LGA    -       -      K     170           -
LGA    -       -      K     171           -
LGA    -       -      E     172           -
LGA    -       -      D     173           -
LGA    -       -      L     174           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  171  174    5.0    156    1.36    37.82     86.235    10.672

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.814771 * X  +   0.530473 * Y  +   0.233980 * Z  +  -3.568153
  Y_new =  -0.502723 * X  +   0.847431 * Y  +  -0.170678 * Z  +  94.426262
  Z_new =  -0.288822 * X  +   0.021436 * Y  +   0.957143 * Z  +  -2.375329 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.022392   -3.119200  [ DEG:     1.2830   -178.7170 ]
  Theta =   0.292996    2.848597  [ DEG:    16.7874    163.2126 ]
  Phi   =  -0.552834    2.588759  [ DEG:   -31.6750    148.3250 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gs3_A                                        
REMARK     2: T0388.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gs3_A.T0388.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  171  174   5.0  156   1.36   37.82  86.235
REMARK  ---------------------------------------------------------- 
MOLECULE 2gs3_A
HEADER    OXIDOREDUCTASE                          25-APR-06   2GS3              
TITLE     CRYSTAL STRUCTURE OF THE SELENOCYSTEINE TO GLYCINE MUTANT             
TITLE    2 OF HUMAN GLUTATHIONE PEROXIDASE 4(GPX4)                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHOSPHOLIPID HYDROPEROXIDE GLUTATHIONE                     
COMPND   3 PEROXIDASE;                                                          
COMPND   4 CHAIN: A;                                                            
COMPND   5 SYNONYM: PHGPX, GPX-4;                                               
COMPND   6 EC: 1.11.1.12;                                                       
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: GPX4;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    GPX4, GSHPX-4,PHOSPHOLIPID HYDROPEROXIDE, STRUCTURAL                  
KEYWDS   2 GENOMICS, STRUCTURAL GENOMICS CONSORTIUM, SGC                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.JOHANSSON,K.L.KAVANAGH,A.ROJKOVA,O.GILEADI,F.VON DELFT,             
AUTHOR   2 C.ARROWSMITH,J.WEIGELT,M.SUNDSTROM,A.EDWARDS,U.OPPERMANN,            
AUTHOR   3 STRUCTURAL GENOMICS CONSORTIUM (SGC)                                 
REVDAT   1   09-MAY-06 2GS3    0                                                
JRNL        AUTH   C.JOHANSSON,K.L.KAVANAGH,A.ROJKOVA,O.GILEADI,                
JRNL        AUTH 2 F.VON DELFT,C.ARROWSMITH,J.WEIGELT,M.SUNDSTROM,              
JRNL        AUTH 3 A.EDWARDS,U.OPPERMANN,                                       
JRNL        AUTH 4 STRUCTURAL GENOMICS CONSORTIUM (SGC)                         
JRNL        TITL   CRYSTAL STRUCTURE OF THE SELENOCYSTEINE TO GLYCINE           
JRNL        TITL 2 MUTANT OF HUMAN GLUTATHIONE PEROXIDASE 4(GPX4)               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2GS3 A   36   197  UNP    P36969   GPX4_HUMAN      36    197             
SEQRES   1 A  185  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 A  185  GLY THR GLU ASN LEU TYR PHE GLN SER MET ARG CYS ALA          
SEQRES   3 A  185  ARG SER MET HIS GLU PHE SER ALA LYS ASP ILE ASP GLY          
SEQRES   4 A  185  HIS MET VAL ASN LEU ASP LYS TYR ARG GLY PHE VAL CYS          
SEQRES   5 A  185  ILE VAL THR ASN VAL ALA SER GLN GLY GLY LYS THR GLU          
SEQRES   6 A  185  VAL ASN TYR THR GLN LEU VAL ASP LEU HIS ALA ARG TYR          
SEQRES   7 A  185  ALA GLU CYS GLY LEU ARG ILE LEU ALA PHE PRO CYS ASN          
SEQRES   8 A  185  GLN PHE GLY LYS GLN GLU PRO GLY SER ASN GLU GLU ILE          
SEQRES   9 A  185  LYS GLU PHE ALA ALA GLY TYR ASN VAL LYS PHE ASP MET          
SEQRES  10 A  185  PHE SER LYS ILE CYS VAL ASN GLY ASP ASP ALA HIS PRO          
SEQRES  11 A  185  LEU TRP LYS TRP MET LYS ILE GLN PRO LYS GLY LYS GLY          
SEQRES  12 A  185  ILE LEU GLY ASN ALA ILE LYS TRP ASN PHE THR LYS PHE          
SEQRES  13 A  185  LEU ILE ASP LYS ASN GLY CYS VAL VAL LYS ARG TYR GLY          
SEQRES  14 A  185  PRO MET GLU GLU PRO LEU VAL ILE GLU LYS ASP LEU PRO          
SEQRES  15 A  185  HIS TYR PHE                                                  
HET     CL    201       1                                                       
HETNAM      CL CHLORIDE ION                                                     
FORMUL   2   CL    CL 1-                                                        
FORMUL   3  HOH   *130(H2 O)                                                    
CRYST1   62.945   62.945  195.984  90.00  90.00  90.00 P 41 21 2     8          
ATOM      1  N   THR A  27      26.219  87.537  -4.779  1.00 67.43           N  
ATOM      2  CA  THR A  27      27.394  88.278  -4.216  1.00 70.80           C  
ATOM      3  C   THR A  27      27.270  89.780  -4.491  1.00 68.92           C  
ATOM      4  O   THR A  27      26.816  90.192  -5.561  1.00 68.89           O  
ATOM      5  CB  THR A  27      28.746  87.763  -4.793  1.00 73.47           C  
ATOM      6  OG1 THR A  27      28.902  88.189  -6.161  1.00 76.93           O  
ATOM      7  CG2 THR A  27      28.824  86.231  -4.711  1.00 71.30           C  
ATOM      8  N   GLU A  28      27.676  90.592  -3.520  1.00 64.77           N  
ATOM      9  CA  GLU A  28      27.618  92.036  -3.668  1.00 60.09           C  
ATOM     10  C   GLU A  28      28.776  92.509  -4.535  1.00 59.70           C  
ATOM     11  O   GLU A  28      29.945  92.259  -4.231  1.00 54.30           O  
ATOM     12  CB  GLU A  28      27.690  92.697  -2.305  1.00 58.06           C  
ATOM     13  CG  GLU A  28      27.350  94.157  -2.315  1.00 58.48           C  
ATOM     14  CD  GLU A  28      27.241  94.687  -0.905  1.00 44.99           C  
ATOM     15  OE1 GLU A  28      28.165  95.415  -0.482  1.00 41.27           O  
ATOM     16  OE2 GLU A  28      26.267  94.315  -0.215  1.00 57.51           O  
ATOM     17  N   ASN A  29      28.451  93.229  -5.599  1.00 57.68           N  
ATOM     18  CA  ASN A  29      29.416  93.501  -6.638  1.00 52.12           C  
ATOM     19  C   ASN A  29      29.496  94.969  -6.940  1.00 53.97           C  
ATOM     20  O   ASN A  29      28.485  95.663  -6.958  1.00 47.43           O  
ATOM     21  CB  ASN A  29      29.038  92.683  -7.859  1.00 62.05           C  
ATOM     22  CG  ASN A  29      29.184  91.194  -7.611  1.00 59.22           C  
ATOM     23  OD1 ASN A  29      30.231  90.749  -7.141  1.00 80.01           O  
ATOM     24  ND2 ASN A  29      28.143  90.416  -7.916  1.00 58.83           N  
ATOM     25  N   LEU A  30      30.721  95.464  -7.089  1.00 54.31           N  
ATOM     26  CA  LEU A  30      30.930  96.804  -7.599  1.00 53.80           C  
ATOM     27  C   LEU A  30      30.926  96.602  -9.113  1.00 48.89           C  
ATOM     28  O   LEU A  30      31.362  95.566  -9.631  1.00 47.04           O  
ATOM     29  CB  LEU A  30      32.238  97.428  -7.093  1.00 58.99           C  
ATOM     30  N   TYR A  31      30.343  97.554  -9.811  1.00 44.63           N  
ATOM     31  CA  TYR A  31      30.134  97.394 -11.228  1.00 38.91           C  
ATOM     32  C   TYR A  31      31.089  98.284 -11.986  1.00 29.39           C  
ATOM     33  O   TYR A  31      31.126  98.258 -13.198  1.00 30.71           O  
ATOM     34  CB  TYR A  31      28.684  97.695 -11.560  1.00 37.05           C  
ATOM     35  CG  TYR A  31      27.730  96.660 -11.051  1.00 31.89           C  
ATOM     36  CD1 TYR A  31      26.665  97.010 -10.236  1.00 40.04           C  
ATOM     37  CD2 TYR A  31      27.882  95.328 -11.397  1.00 31.51           C  
ATOM     38  CE1 TYR A  31      25.779  96.049  -9.794  1.00 39.20           C  
ATOM     39  CE2 TYR A  31      27.011  94.375 -10.969  1.00 44.36           C  
ATOM     40  CZ  TYR A  31      25.966  94.736 -10.155  1.00 36.52           C  
ATOM     41  OH  TYR A  31      25.113  93.742  -9.733  1.00 52.11           O  
ATOM     42  N   PHE A  32      31.845  99.082 -11.249  1.00 38.30           N  
ATOM     43  CA  PHE A  32      32.979  99.806 -11.759  1.00 44.23           C  
ATOM     44  C   PHE A  32      34.100  99.197 -10.899  1.00 51.21           C  
ATOM     45  O   PHE A  32      34.384  99.669  -9.800  1.00 39.31           O  
ATOM     46  CB  PHE A  32      32.716 101.298 -11.578  1.00 42.37           C  
ATOM     47  CG  PHE A  32      33.717 102.206 -12.226  1.00 43.65           C  
ATOM     48  CD1 PHE A  32      33.961 102.173 -13.590  1.00 30.17           C  
ATOM     49  CD2 PHE A  32      34.381 103.159 -11.461  1.00 57.05           C  
ATOM     50  CE1 PHE A  32      34.869 103.034 -14.165  1.00 35.53           C  
ATOM     51  CE2 PHE A  32      35.290 104.034 -12.033  1.00 62.45           C  
ATOM     52  CZ  PHE A  32      35.540 103.966 -13.390  1.00 51.23           C  
ATOM     53  N   GLN A  33      34.645  98.067 -11.395  1.00 57.92           N  
ATOM     54  CA  GLN A  33      35.543  97.157 -10.627  1.00 56.90           C  
ATOM     55  C   GLN A  33      36.826  97.836 -10.134  1.00 58.70           C  
ATOM     56  O   GLN A  33      37.488  97.340  -9.211  1.00 55.25           O  
ATOM     57  CB  GLN A  33      35.913  95.895 -11.437  1.00 58.59           C  
ATOM     58  CG  GLN A  33      36.638  96.136 -12.794  1.00 57.57           C  
ATOM     59  CD  GLN A  33      35.688  96.106 -13.988  1.00 57.50           C  
ATOM     60  OE1 GLN A  33      34.491  96.329 -13.824  1.00 40.61           O  
ATOM     61  NE2 GLN A  33      36.212  95.807 -15.188  1.00 44.28           N  
ATOM     62  N   SER A  34      37.173  98.940 -10.797  1.00 56.81           N  
ATOM     63  CA  SER A  34      38.125  99.927 -10.307  1.00 55.15           C  
ATOM     64  C   SER A  34      37.959 100.156  -8.806  1.00 60.86           C  
ATOM     65  O   SER A  34      38.931 100.148  -8.033  1.00 61.49           O  
ATOM     66  CB  SER A  34      37.890 101.254 -11.064  1.00 50.60           C  
ATOM     67  OG  SER A  34      38.255 102.408 -10.307  1.00 67.41           O  
ATOM     68  N   MET A  35      36.709 100.356  -8.409  1.00 62.41           N  
ATOM     69  CA  MET A  35      36.365 100.840  -7.075  1.00 61.89           C  
ATOM     70  C   MET A  35      36.843  99.969  -5.918  1.00 60.49           C  
ATOM     71  O   MET A  35      36.972 100.460  -4.788  1.00 61.80           O  
ATOM     72  CB  MET A  35      34.867 101.016  -6.995  1.00 61.62           C  
ATOM     73  CG  MET A  35      34.383 101.616  -5.720  1.00 65.72           C  
ATOM     74  SD  MET A  35      32.611 101.607  -5.835  1.00 62.65           S  
ATOM     75  CE  MET A  35      32.152  99.971  -5.187  1.00 53.24           C  
ATOM     76  N   ARG A  36      37.122  98.696  -6.178  1.00 58.04           N  
ATOM     77  CA  ARG A  36      37.763  97.863  -5.163  1.00 63.11           C  
ATOM     78  C   ARG A  36      39.115  98.440  -4.747  1.00 60.62           C  
ATOM     79  O   ARG A  36      39.656  98.028  -3.725  1.00 66.32           O  
ATOM     80  CB  ARG A  36      37.948  96.417  -5.648  1.00 63.98           C  
ATOM     81  CG  ARG A  36      38.354  95.440  -4.536  1.00 64.22           C  
ATOM     82  CD  ARG A  36      38.628  94.029  -5.055  1.00 69.47           C  
ATOM     83  NE  ARG A  36      37.472  93.411  -5.711  1.00 72.09           N  
ATOM     84  CZ  ARG A  36      36.371  92.980  -5.087  1.00 77.92           C  
ATOM     85  NH1 ARG A  36      36.227  93.101  -3.766  1.00 64.48           N  
ATOM     86  NH2 ARG A  36      35.395  92.424  -5.798  1.00 74.72           N  
ATOM     87  N   CYS A  37      39.657  99.373  -5.541  1.00 56.78           N  
ATOM     88  CA  CYS A  37      40.942 100.002  -5.239  0.50 52.44           C  
ATOM     90  C   CYS A  37      40.804 101.434  -4.708  1.00 47.62           C  
ATOM     91  O   CYS A  37      41.807 102.104  -4.508  1.00 43.11           O  
ATOM     92  CB  CYS A  37      41.851  99.993  -6.475  0.50 54.65           C  
ATOM     94  SG  CYS A  37      42.518  98.369  -6.906  0.50 61.57           S  
ATOM     96  N   ALA A  38      39.573 101.900  -4.470  1.00 42.03           N  
ATOM     97  CA  ALA A  38      39.361 103.252  -3.925  1.00 41.81           C  
ATOM     98  C   ALA A  38      40.043 103.340  -2.555  1.00 41.21           C  
ATOM     99  O   ALA A  38      40.061 102.355  -1.804  1.00 39.62           O  
ATOM    100  CB  ALA A  38      37.883 103.579  -3.793  1.00 40.83           C  
ATOM    101  N   ARG A  39      40.621 104.495  -2.244  1.00 39.47           N  
ATOM    102  CA  ARG A  39      41.399 104.643  -1.005  1.00 40.52           C  
ATOM    103  C   ARG A  39      40.680 105.382   0.114  1.00 38.23           C  
ATOM    104  O   ARG A  39      41.068 105.263   1.272  1.00 41.98           O  
ATOM    105  CB  ARG A  39      42.751 105.318  -1.293  1.00 40.46           C  
ATOM    106  CG  ARG A  39      43.726 104.443  -2.083  1.00 54.49           C  
ATOM    107  CD  ARG A  39      43.897 103.048  -1.457  1.00 64.19           C  
ATOM    108  N   SER A  40      39.604 106.088  -0.209  1.00 35.60           N  
ATOM    109  CA  SER A  40      39.012 107.020   0.726  1.00 32.83           C  
ATOM    110  C   SER A  40      37.536 107.223   0.463  1.00 33.42           C  
ATOM    111  O   SER A  40      37.103 107.224  -0.694  1.00 36.16           O  
ATOM    112  CB  SER A  40      39.762 108.369   0.603  1.00 32.40           C  
ATOM    113  OG  SER A  40      39.174 109.372   1.394  1.00 39.08           O  
ATOM    114  N   MET A  41      36.777 107.426   1.542  1.00 34.69           N  
ATOM    115  CA  MET A  41      35.389 107.895   1.478  1.00 38.84           C  
ATOM    116  C   MET A  41      35.258 109.181   0.672  1.00 34.96           C  
ATOM    117  O   MET A  41      34.194 109.445   0.105  1.00 38.48           O  
ATOM    118  CB  MET A  41      34.843 108.144   2.888  1.00 40.05           C  
ATOM    119  CG  MET A  41      33.481 108.841   2.957  1.00 48.99           C  
ATOM    120  SD  MET A  41      32.887 109.141   4.656  1.00 44.77           S  
ATOM    121  CE  MET A  41      33.703 110.689   5.023  1.00 39.00           C  
ATOM    122  N   HIS A  42      36.331 109.969   0.632  1.00 36.36           N  
ATOM    123  CA  HIS A  42      36.343 111.257  -0.066  1.00 33.91           C  
ATOM    124  C   HIS A  42      36.233 111.127  -1.578  1.00 33.25           C  
ATOM    125  O   HIS A  42      36.074 112.126  -2.249  1.00 35.16           O  
ATOM    126  CB  HIS A  42      37.587 112.084   0.283  1.00 39.66           C  
ATOM    127  CG  HIS A  42      37.804 112.251   1.756  1.00 38.25           C  
ATOM    128  ND1 HIS A  42      39.059 112.441   2.296  1.00 40.25           N  
ATOM    129  CD2 HIS A  42      36.941 112.232   2.797  1.00 39.30           C  
ATOM    130  CE1 HIS A  42      38.954 112.525   3.609  1.00 38.58           C  
ATOM    131  NE2 HIS A  42      37.683 112.404   3.942  1.00 38.49           N  
ATOM    132  N   GLU A  43      36.312 109.898  -2.095  1.00 34.26           N  
ATOM    133  CA  GLU A  43      36.139 109.642  -3.534  1.00 33.53           C  
ATOM    134  C   GLU A  43      34.667 109.390  -3.908  1.00 36.14           C  
ATOM    135  O   GLU A  43      34.329 109.193  -5.092  1.00 38.23           O  
ATOM    136  CB  GLU A  43      36.993 108.445  -3.948  1.00 38.25           C  
ATOM    137  CG  GLU A  43      38.482 108.663  -3.795  1.00 42.61           C  
ATOM    138  CD  GLU A  43      39.286 107.432  -4.144  1.00 48.44           C  
ATOM    139  OE1 GLU A  43      39.156 106.925  -5.279  1.00 50.66           O  
ATOM    140  OE2 GLU A  43      40.042 106.959  -3.276  1.00 50.83           O  
ATOM    141  N   PHE A  44      33.800 109.436  -2.915  1.00 33.26           N  
ATOM    142  CA  PHE A  44      32.368 109.142  -3.086  1.00 33.64           C  
ATOM    143  C   PHE A  44      31.491 110.373  -2.864  1.00 38.73           C  
ATOM    144  O   PHE A  44      31.930 111.403  -2.335  1.00 35.80           O  
ATOM    145  CB  PHE A  44      31.922 108.021  -2.126  1.00 36.87           C  
ATOM    146  CG  PHE A  44      32.592 106.711  -2.374  1.00 35.50           C  
ATOM    147  CD1 PHE A  44      31.999 105.759  -3.196  1.00 37.53           C  
ATOM    148  CD2 PHE A  44      33.834 106.426  -1.819  1.00 37.84           C  
ATOM    149  CE1 PHE A  44      32.624 104.548  -3.439  1.00 36.77           C  
ATOM    150  CE2 PHE A  44      34.473 105.217  -2.077  1.00 37.89           C  
ATOM    151  CZ  PHE A  44      33.856 104.272  -2.886  1.00 35.71           C  
ATOM    152  N   SER A  45      30.241 110.242  -3.289  1.00 37.04           N  
ATOM    153  CA  SER A  45      29.240 111.285  -3.168  1.00 36.67           C  
ATOM    154  C   SER A  45      27.934 110.612  -2.768  1.00 35.32           C  
ATOM    155  O   SER A  45      27.759 109.401  -2.974  1.00 37.84           O  
ATOM    156  CB  SER A  45      29.042 112.006  -4.488  1.00 37.54           C  
ATOM    157  OG  SER A  45      30.165 112.774  -4.858  1.00 38.45           O  
ATOM    158  N   ALA A  46      27.015 111.389  -2.199  1.00 33.69           N  
ATOM    159  CA  ALA A  46      25.696 110.860  -1.837  1.00 37.03           C  
ATOM    160  C   ALA A  46      24.671 112.001  -1.784  1.00 36.07           C  
ATOM    161  O   ALA A  46      25.041 113.160  -1.584  1.00 38.82           O  
ATOM    162  CB  ALA A  46      25.773 110.102  -0.488  1.00 35.58           C  
ATOM    163  N   LYS A  47      23.398 111.679  -2.002  1.00 35.68           N  
ATOM    164  CA  LYS A  47      22.335 112.665  -1.870  1.00 35.80           C  
ATOM    165  C   LYS A  47      21.997 112.915  -0.411  1.00 37.62           C  
ATOM    166  O   LYS A  47      21.757 111.983   0.336  1.00 35.70           O  
ATOM    167  CB  LYS A  47      21.069 112.249  -2.606  1.00 34.78           C  
ATOM    168  CG  LYS A  47      21.213 112.267  -4.099  1.00 51.42           C  
ATOM    169  CD  LYS A  47      19.883 112.160  -4.824  1.00 61.70           C  
ATOM    170  CE  LYS A  47      20.109 112.396  -6.323  1.00 70.13           C  
ATOM    171  NZ  LYS A  47      18.883 112.277  -7.155  1.00 79.29           N  
ATOM    172  N   ASP A  48      22.000 114.184  -0.002  1.00 35.23           N  
ATOM    173  CA  ASP A  48      21.546 114.519   1.347  1.00 36.81           C  
ATOM    174  C   ASP A  48      20.042 114.293   1.437  1.00 37.53           C  
ATOM    175  O   ASP A  48      19.389 113.976   0.442  1.00 34.66           O  
ATOM    176  CB  ASP A  48      21.977 115.929   1.812  1.00 39.54           C  
ATOM    177  CG  ASP A  48      21.239 117.077   1.115  1.00 42.30           C  
ATOM    178  OD1 ASP A  48      20.157 116.888   0.534  1.00 47.20           O  
ATOM    179  OD2 ASP A  48      21.763 118.213   1.168  1.00 50.75           O  
ATOM    180  N   ILE A  49      19.492 114.440   2.636  1.00 37.62           N  
ATOM    181  CA  ILE A  49      18.100 114.058   2.863  1.00 37.19           C  
ATOM    182  C   ILE A  49      17.139 114.997   2.152  1.00 38.54           C  
ATOM    183  O   ILE A  49      16.003 114.630   1.947  1.00 39.61           O  
ATOM    184  CB  ILE A  49      17.773 113.963   4.378  1.00 37.79           C  
ATOM    185  CG1 ILE A  49      16.539 113.079   4.606  1.00 37.20           C  
ATOM    186  CG2 ILE A  49      17.646 115.342   4.999  1.00 37.43           C  
ATOM    187  CD1 ILE A  49      16.570 112.334   5.916  1.00 39.18           C  
ATOM    188  N   ASP A  50      17.609 116.193   1.768  1.00 38.36           N  
ATOM    189  CA  ASP A  50      16.809 117.121   0.950  1.00 40.26           C  
ATOM    190  C   ASP A  50      16.897 116.863  -0.565  1.00 41.29           C  
ATOM    191  O   ASP A  50      16.228 117.536  -1.346  1.00 42.81           O  
ATOM    192  CB  ASP A  50      17.199 118.570   1.250  1.00 45.22           C  
ATOM    193  CG  ASP A  50      16.914 118.965   2.686  1.00 55.08           C  
ATOM    194  OD1 ASP A  50      15.779 118.739   3.166  1.00 53.40           O  
ATOM    195  OD2 ASP A  50      17.828 119.510   3.336  1.00 70.25           O  
ATOM    196  N   GLY A  51      17.710 115.894  -0.974  1.00 40.65           N  
ATOM    197  CA  GLY A  51      17.847 115.520  -2.381  1.00 39.35           C  
ATOM    198  C   GLY A  51      19.030 116.156  -3.093  1.00 39.16           C  
ATOM    199  O   GLY A  51      19.167 116.028  -4.310  1.00 42.74           O  
ATOM    200  N   HIS A  52      19.886 116.859  -2.361  1.00 38.57           N  
ATOM    201  CA  HIS A  52      21.023 117.519  -2.988  1.00 39.29           C  
ATOM    202  C   HIS A  52      22.283 116.662  -2.929  1.00 38.81           C  
ATOM    203  O   HIS A  52      22.603 116.104  -1.887  1.00 34.33           O  
ATOM    204  CB  HIS A  52      21.261 118.882  -2.341  1.00 43.94           C  
ATOM    205  CG  HIS A  52      20.075 119.791  -2.429  1.00 54.51           C  
ATOM    206  ND1 HIS A  52      19.411 120.261  -1.316  1.00 67.01           N  
ATOM    207  CD2 HIS A  52      19.400 120.269  -3.502  1.00 62.30           C  
ATOM    208  CE1 HIS A  52      18.396 121.015  -1.698  1.00 62.55           C  
ATOM    209  NE2 HIS A  52      18.365 121.035  -3.019  1.00 69.48           N  
ATOM    210  N   MET A  53      23.015 116.591  -4.048  1.00 40.32           N  
ATOM    211  CA  MET A  53      24.289 115.849  -4.094  1.00 39.50           C  
ATOM    212  C   MET A  53      25.339 116.498  -3.224  1.00 37.86           C  
ATOM    213  O   MET A  53      25.532 117.689  -3.274  1.00 40.39           O  
ATOM    214  CB  MET A  53      24.833 115.763  -5.526  1.00 40.70           C  
ATOM    215  CG  MET A  53      24.234 114.640  -6.308  1.00 56.87           C  
ATOM    216  SD  MET A  53      24.749 113.055  -5.620  1.00 56.81           S  
ATOM    217  CE  MET A  53      26.398 112.962  -6.290  1.00 48.81           C  
ATOM    218  N   VAL A  54      26.028 115.683  -2.441  1.00 31.96           N  
ATOM    219  CA  VAL A  54      27.079 116.113  -1.551  1.00 38.34           C  
ATOM    220  C   VAL A  54      28.319 115.325  -1.944  1.00 37.04           C  
ATOM    221  O   VAL A  54      28.275 114.107  -1.991  1.00 36.23           O  
ATOM    222  CB  VAL A  54      26.721 115.789  -0.069  1.00 41.20           C  
ATOM    223  CG1 VAL A  54      27.905 116.091   0.852  1.00 45.39           C  
ATOM    224  CG2 VAL A  54      25.480 116.566   0.357  1.00 47.57           C  
ATOM    225  N   ASN A  55      29.422 116.021  -2.201  1.00 30.14           N  
ATOM    226  CA  ASN A  55      30.711 115.356  -2.401  1.00 35.25           C  
ATOM    227  C   ASN A  55      31.316 115.086  -1.026  1.00 36.16           C  
ATOM    228  O   ASN A  55      31.523 116.022  -0.259  1.00 38.17           O  
ATOM    229  CB  ASN A  55      31.620 116.245  -3.211  1.00 37.43           C  
ATOM    230  CG  ASN A  55      32.943 115.583  -3.585  1.00 45.85           C  
ATOM    231  OD1 ASN A  55      33.446 114.700  -2.891  1.00 46.30           O  
ATOM    232  ND2 ASN A  55      33.526 116.037  -4.707  1.00 50.09           N  
ATOM    233  N   LEU A  56      31.613 113.827  -0.721  1.00 34.71           N  
ATOM    234  CA  LEU A  56      32.062 113.474   0.641  1.00 31.87           C  
ATOM    235  C   LEU A  56      33.487 113.905   0.952  1.00 36.39           C  
ATOM    236  O   LEU A  56      33.962 113.738   2.087  1.00 39.93           O  
ATOM    237  CB  LEU A  56      31.866 111.982   0.956  1.00 36.24           C  
ATOM    238  CG  LEU A  56      30.443 111.466   0.791  1.00 37.34           C  
ATOM    239  CD1 LEU A  56      30.366 109.944   1.093  1.00 35.08           C  
ATOM    240  CD2 LEU A  56      29.396 112.263   1.635  1.00 39.32           C  
ATOM    241  N   ASP A  57      34.166 114.476  -0.037  1.00 35.08           N  
ATOM    242  CA  ASP A  57      35.472 115.089   0.198  1.00 36.66           C  
ATOM    243  C   ASP A  57      35.366 116.320   1.125  1.00 36.53           C  
ATOM    244  O   ASP A  57      36.373 116.782   1.660  1.00 36.09           O  
ATOM    245  CB  ASP A  57      36.222 115.365  -1.124  1.00 38.58           C  
ATOM    246  CG  ASP A  57      35.667 116.542  -1.913  1.00 47.16           C  
ATOM    247  OD1 ASP A  57      34.752 117.246  -1.441  1.00 58.42           O  
ATOM    248  OD2 ASP A  57      36.169 116.768  -3.036  1.00 57.14           O  
ATOM    249  N   LYS A  58      34.146 116.818   1.368  1.00 37.36           N  
ATOM    250  CA  LYS A  58      33.958 117.912   2.339  1.00 43.02           C  
ATOM    251  C   LYS A  58      34.328 117.484   3.766  1.00 39.53           C  
ATOM    252  O   LYS A  58      34.552 118.312   4.627  1.00 36.07           O  
ATOM    253  CB  LYS A  58      32.527 118.450   2.316  1.00 40.82           C  
ATOM    254  CG  LYS A  58      31.501 117.616   3.049  1.00 47.24           C  
ATOM    255  CD  LYS A  58      30.106 118.117   2.791  1.00 48.84           C  
ATOM    256  CE  LYS A  58      29.362 118.420   4.062  1.00 62.36           C  
ATOM    257  NZ  LYS A  58      27.915 118.640   3.790  1.00 58.49           N  
ATOM    258  N   TYR A  59      34.391 116.185   3.995  1.00 32.76           N  
ATOM    259  CA  TYR A  59      34.742 115.616   5.297  1.00 31.98           C  
ATOM    260  C   TYR A  59      36.244 115.396   5.493  1.00 38.50           C  
ATOM    261  O   TYR A  59      36.668 114.918   6.540  1.00 37.10           O  
ATOM    262  CB  TYR A  59      33.954 114.334   5.498  1.00 36.49           C  
ATOM    263  CG  TYR A  59      32.475 114.583   5.619  1.00 43.97           C  
ATOM    264  CD1 TYR A  59      31.939 115.177   6.762  1.00 42.74           C  
ATOM    265  CD2 TYR A  59      31.604 114.211   4.601  1.00 40.04           C  
ATOM    266  CE1 TYR A  59      30.574 115.394   6.883  1.00 37.83           C  
ATOM    267  CE2 TYR A  59      30.262 114.446   4.699  1.00 37.15           C  
ATOM    268  CZ  TYR A  59      29.737 115.008   5.845  1.00 42.90           C  
ATOM    269  OH  TYR A  59      28.378 115.199   5.916  1.00 42.80           O  
ATOM    270  N   ARG A  60      37.063 115.813   4.521  1.00 38.74           N  
ATOM    271  CA  ARG A  60      38.498 115.690   4.672  1.00 38.67           C  
ATOM    272  C   ARG A  60      38.919 116.579   5.850  1.00 40.36           C  
ATOM    273  O   ARG A  60      38.504 117.733   5.949  1.00 37.00           O  
ATOM    274  CB  ARG A  60      39.237 116.085   3.385  1.00 38.65           C  
ATOM    275  CG  ARG A  60      40.747 115.905   3.452  1.00 46.12           C  
ATOM    276  CD  ARG A  60      41.391 115.888   2.061  1.00 52.42           C  
ATOM    277  NE  ARG A  60      40.709 116.799   1.143  1.00 69.39           N  
ATOM    278  CZ  ARG A  60      40.144 116.468  -0.020  1.00 48.60           C  
ATOM    279  NH1 ARG A  60      40.175 115.221  -0.501  1.00 65.85           N  
ATOM    280  NH2 ARG A  60      39.545 117.416  -0.733  1.00 72.45           N  
ATOM    281  N   GLY A  61      39.713 116.014   6.748  1.00 39.18           N  
ATOM    282  CA  GLY A  61      40.172 116.706   7.932  1.00 40.56           C  
ATOM    283  C   GLY A  61      39.277 116.527   9.142  1.00 39.14           C  
ATOM    284  O   GLY A  61      39.568 117.059  10.221  1.00 33.70           O  
ATOM    285  N   PHE A  62      38.185 115.781   8.983  1.00 34.49           N  
ATOM    286  CA  PHE A  62      37.269 115.482  10.072  1.00 36.93           C  
ATOM    287  C   PHE A  62      37.221 113.992  10.305  1.00 35.85           C  
ATOM    288  O   PHE A  62      37.406 113.214   9.376  1.00 38.88           O  
ATOM    289  CB  PHE A  62      35.850 115.982   9.745  1.00 37.80           C  
ATOM    290  CG  PHE A  62      35.788 117.458   9.519  1.00 35.24           C  
ATOM    291  CD1 PHE A  62      35.714 118.328  10.593  1.00 40.27           C  
ATOM    292  CD2 PHE A  62      35.863 117.988   8.235  1.00 38.77           C  
ATOM    293  CE1 PHE A  62      35.690 119.706  10.382  1.00 43.70           C  
ATOM    294  CE2 PHE A  62      35.846 119.356   8.018  1.00 44.95           C  
ATOM    295  CZ  PHE A  62      35.753 120.213   9.087  1.00 51.99           C  
ATOM    296  N   VAL A  63      36.970 113.617  11.556  1.00 33.37           N  
ATOM    297  CA  VAL A  63      36.721 112.229  11.958  1.00 32.35           C  
ATOM    298  C   VAL A  63      35.224 112.013  11.840  1.00 36.39           C  
ATOM    299  O   VAL A  63      34.432 112.837  12.305  1.00 39.50           O  
ATOM    300  CB  VAL A  63      37.207 111.972  13.407  1.00 37.26           C  
ATOM    301  CG1 VAL A  63      36.876 110.559  13.875  1.00 33.70           C  
ATOM    302  CG2 VAL A  63      38.725 112.245  13.514  1.00 34.60           C  
ATOM    303  N   CYS A  64      34.826 110.932  11.175  1.00 33.87           N  
ATOM    304  CA  CYS A  64      33.407 110.693  10.891  1.00 35.40           C  
ATOM    305  C   CYS A  64      32.937 109.343  11.399  1.00 34.02           C  
ATOM    306  O   CYS A  64      33.668 108.365  11.360  1.00 39.73           O  
ATOM    307  CB  CYS A  64      33.131 110.720   9.381  1.00 37.39           C  
ATOM    308  SG  CYS A  64      33.568 112.285   8.626  1.00 43.41           S  
ATOM    309  N   ILE A  65      31.698 109.330  11.875  1.00 36.22           N  
ATOM    310  CA  ILE A  65      30.961 108.108  12.150  1.00 36.25           C  
ATOM    311  C   ILE A  65      29.934 108.013  11.040  1.00 36.99           C  
ATOM    312  O   ILE A  65      29.127 108.924  10.867  1.00 39.27           O  
ATOM    313  CB  ILE A  65      30.247 108.135  13.505  1.00 39.12           C  
ATOM    314  CG1 ILE A  65      31.282 108.228  14.649  1.00 40.25           C  
ATOM    315  CG2 ILE A  65      29.319 106.887  13.642  1.00 37.15           C  
ATOM    316  CD1 ILE A  65      30.682 108.602  16.061  1.00 35.00           C  
ATOM    317  N   VAL A  66      29.990 106.924  10.271  1.00 39.60           N  
ATOM    318  CA  VAL A  66      29.010 106.674   9.215  1.00 35.51           C  
ATOM    319  C   VAL A  66      28.101 105.534   9.670  1.00 37.29           C  
ATOM    320  O   VAL A  66      28.580 104.465  10.055  1.00 39.11           O  
ATOM    321  CB  VAL A  66      29.678 106.326   7.863  1.00 36.15           C  
ATOM    322  CG1 VAL A  66      28.575 105.961   6.798  1.00 33.28           C  
ATOM    323  CG2 VAL A  66      30.614 107.458   7.359  1.00 36.47           C  
ATOM    324  N   THR A  67      26.791 105.766   9.678  1.00 35.18           N  
ATOM    325  CA  THR A  67      25.877 104.756  10.235  1.00 35.18           C  
ATOM    326  C   THR A  67      24.615 104.643   9.421  1.00 35.87           C  
ATOM    327  O   THR A  67      24.183 105.616   8.822  1.00 36.22           O  
ATOM    328  CB  THR A  67      25.530 105.092  11.749  1.00 36.12           C  
ATOM    329  OG1 THR A  67      24.754 104.049  12.338  1.00 40.56           O  
ATOM    330  CG2 THR A  67      24.796 106.442  11.868  1.00 41.06           C  
ATOM    331  N   ASN A  68      24.007 103.446   9.401  1.00 34.36           N  
ATOM    332  CA  ASN A  68      22.707 103.257   8.805  1.00 34.30           C  
ATOM    333  C   ASN A  68      21.632 103.339   9.906  1.00 38.87           C  
ATOM    334  O   ASN A  68      21.746 102.686  10.964  1.00 39.79           O  
ATOM    335  CB  ASN A  68      22.554 101.898   8.080  1.00 34.58           C  
ATOM    336  CG  ASN A  68      22.860 100.696   8.949  1.00 34.78           C  
ATOM    337  OD1 ASN A  68      23.915 100.636   9.579  1.00 37.82           O  
ATOM    338  ND2 ASN A  68      21.945  99.691   8.944  1.00 34.04           N  
ATOM    339  N   VAL A  69      20.598 104.121   9.633  1.00 38.30           N  
ATOM    340  CA  VAL A  69      19.590 104.450  10.641  1.00 35.11           C  
ATOM    341  C   VAL A  69      18.210 103.973  10.230  1.00 38.94           C  
ATOM    342  O   VAL A  69      17.963 103.643   9.062  1.00 38.40           O  
ATOM    343  CB  VAL A  69      19.609 105.966  10.984  1.00 37.98           C  
ATOM    344  CG1 VAL A  69      20.987 106.379  11.447  1.00 36.90           C  
ATOM    345  CG2 VAL A  69      19.141 106.827   9.814  1.00 34.77           C  
ATOM    346  N   ALA A  70      17.341 103.851  11.236  1.00 37.03           N  
ATOM    347  CA  ALA A  70      15.950 103.476  11.056  1.00 34.31           C  
ATOM    348  C   ALA A  70      15.150 104.167  12.153  1.00 38.62           C  
ATOM    349  O   ALA A  70      15.663 104.378  13.254  1.00 41.09           O  
ATOM    350  CB  ALA A  70      15.786 101.979  11.142  1.00 37.18           C  
ATOM    351  N   SER A  71      13.900 104.501  11.849  1.00 36.47           N  
ATOM    352  CA  SER A  71      13.017 105.189  12.777  1.00 35.33           C  
ATOM    353  C   SER A  71      12.210 104.225  13.649  1.00 36.53           C  
ATOM    354  O   SER A  71      11.779 104.592  14.732  1.00 37.45           O  
ATOM    355  CB  SER A  71      12.050 106.063  11.997  1.00 37.86           C  
ATOM    356  OG  SER A  71      12.760 107.057  11.273  1.00 44.22           O  
ATOM    357  N   GLN A  72      11.972 103.015  13.154  1.00 34.30           N  
ATOM    358  CA  GLN A  72      11.139 102.045  13.856  1.00 34.10           C  
ATOM    359  C   GLN A  72      11.928 100.838  14.363  1.00 36.90           C  
ATOM    360  O   GLN A  72      11.376  99.746  14.465  1.00 35.82           O  
ATOM    361  CB  GLN A  72       9.994 101.574  12.959  1.00 38.71           C  
ATOM    362  CG  GLN A  72       9.037 102.666  12.535  1.00 43.45           C  
ATOM    363  CD  GLN A  72       7.906 102.136  11.659  1.00 44.01           C  
ATOM    364  OE1 GLN A  72       7.517 100.977  11.760  1.00 64.84           O  
ATOM    365  NE2 GLN A  72       7.379 102.993  10.797  1.00 64.52           N  
ATOM    366  N   GLY A  73      13.208 101.034  14.667  1.00 36.56           N  
ATOM    367  CA  GLY A  73      14.047  99.967  15.212  1.00 39.43           C  
ATOM    368  C   GLY A  73      13.936  99.867  16.725  1.00 40.45           C  
ATOM    369  O   GLY A  73      13.637 100.851  17.410  1.00 40.93           O  
ATOM    370  N   GLY A  74      14.217  98.682  17.258  1.00 37.82           N  
ATOM    371  CA  GLY A  74      14.255  98.474  18.710  1.00 38.54           C  
ATOM    372  C   GLY A  74      15.336  99.287  19.404  1.00 39.76           C  
ATOM    373  O   GLY A  74      15.255  99.552  20.600  1.00 40.94           O  
ATOM    374  N   LYS A  75      16.372  99.670  18.680  1.00 35.69           N  
ATOM    375  CA  LYS A  75      17.434 100.501  19.272  1.00 34.92           C  
ATOM    376  C   LYS A  75      17.482 101.915  18.724  1.00 34.48           C  
ATOM    377  O   LYS A  75      18.488 102.612  18.878  1.00 36.49           O  
ATOM    378  CB  LYS A  75      18.779  99.789  19.153  1.00 38.64           C  
ATOM    379  CG  LYS A  75      18.756  98.434  19.896  1.00 45.62           C  
ATOM    380  CD  LYS A  75      20.085  97.701  19.900  1.00 45.70           C  
ATOM    381  CE  LYS A  75      19.928  96.326  20.621  1.00 45.60           C  
ATOM    382  NZ  LYS A  75      20.950  95.335  20.174  1.00 74.35           N  
ATOM    383  N   THR A  76      16.385 102.358  18.105  1.00 35.82           N  
ATOM    384  CA  THR A  76      16.320 103.696  17.525  1.00 34.78           C  
ATOM    385  C   THR A  76      16.559 104.772  18.598  1.00 34.57           C  
ATOM    386  O   THR A  76      17.364 105.694  18.407  1.00 37.57           O  
ATOM    387  CB  THR A  76      14.957 103.934  16.802  1.00 37.46           C  
ATOM    388  OG1 THR A  76      14.901 103.141  15.603  1.00 40.25           O  
ATOM    389  CG2 THR A  76      14.764 105.390  16.418  1.00 32.59           C  
ATOM    390  N   GLU A  77      15.880 104.656  19.740  1.00 33.17           N  
ATOM    391  CA  GLU A  77      15.970 105.715  20.769  1.00 38.36           C  
ATOM    392  C   GLU A  77      17.388 105.871  21.319  1.00 36.60           C  
ATOM    393  O   GLU A  77      17.926 106.989  21.380  1.00 36.76           O  
ATOM    394  CB  GLU A  77      14.957 105.482  21.895  1.00 39.45           C  
ATOM    395  CG  GLU A  77      14.803 106.648  22.881  1.00 44.29           C  
ATOM    396  CD  GLU A  77      13.714 106.377  23.927  1.00 48.63           C  
ATOM    397  N   VAL A  78      18.020 104.758  21.686  1.00 37.07           N  
ATOM    398  CA  VAL A  78      19.387 104.811  22.240  1.00 38.77           C  
ATOM    399  C   VAL A  78      20.394 105.309  21.224  1.00 33.35           C  
ATOM    400  O   VAL A  78      21.292 106.105  21.557  1.00 39.31           O  
ATOM    401  CB  VAL A  78      19.870 103.431  22.791  1.00 43.38           C  
ATOM    402  CG1 VAL A  78      19.943 102.395  21.705  1.00 51.66           C  
ATOM    403  CG2 VAL A  78      21.233 103.572  23.470  1.00 56.57           C  
ATOM    404  N   ASN A  79      20.259 104.858  19.984  1.00 36.15           N  
ATOM    405  CA  ASN A  79      21.198 105.267  18.953  1.00 33.34           C  
ATOM    406  C   ASN A  79      21.090 106.746  18.624  1.00 38.07           C  
ATOM    407  O   ASN A  79      22.087 107.429  18.651  1.00 36.62           O  
ATOM    408  CB  ASN A  79      21.119 104.419  17.699  1.00 35.93           C  
ATOM    409  CG  ASN A  79      21.903 103.128  17.833  1.00 40.21           C  
ATOM    410  OD1 ASN A  79      23.107 103.082  17.591  1.00 41.42           O  
ATOM    411  ND2 ASN A  79      21.219 102.077  18.222  1.00 34.22           N  
ATOM    412  N   TYR A  80      19.889 107.260  18.358  1.00 38.55           N  
ATOM    413  CA  TYR A  80      19.770 108.703  18.066  1.00 34.08           C  
ATOM    414  C   TYR A  80      20.226 109.557  19.256  1.00 36.27           C  
ATOM    415  O   TYR A  80      20.941 110.568  19.083  1.00 36.32           O  
ATOM    416  CB  TYR A  80      18.339 109.077  17.655  1.00 38.19           C  
ATOM    417  CG  TYR A  80      18.075 108.974  16.158  1.00 36.20           C  
ATOM    418  CD1 TYR A  80      17.488 107.842  15.591  1.00 36.16           C  
ATOM    419  CD2 TYR A  80      18.422 110.018  15.308  1.00 50.07           C  
ATOM    420  CE1 TYR A  80      17.243 107.768  14.212  1.00 34.79           C  
ATOM    421  CE2 TYR A  80      18.190 109.943  13.951  1.00 42.35           C  
ATOM    422  CZ  TYR A  80      17.597 108.829  13.408  1.00 46.58           C  
ATOM    423  OH  TYR A  80      17.393 108.797  12.055  1.00 50.14           O  
ATOM    424  N   THR A  81      19.842 109.145  20.457  1.00 34.66           N  
ATOM    425  CA  THR A  81      20.144 109.908  21.663  1.00 36.38           C  
ATOM    426  C   THR A  81      21.638 109.999  21.839  1.00 36.36           C  
ATOM    427  O   THR A  81      22.184 111.094  22.023  1.00 35.70           O  
ATOM    428  CB  THR A  81      19.501 109.288  22.934  1.00 36.35           C  
ATOM    429  OG1 THR A  81      18.091 109.189  22.746  1.00 44.25           O  
ATOM    430  CG2 THR A  81      19.769 110.185  24.157  1.00 43.39           C  
ATOM    431  N   GLN A  82      22.319 108.862  21.721  1.00 34.35           N  
ATOM    432  CA  GLN A  82      23.771 108.854  21.930  1.00 39.04           C  
ATOM    433  C   GLN A  82      24.582 109.473  20.802  1.00 39.39           C  
ATOM    434  O   GLN A  82      25.644 110.025  21.053  1.00 37.48           O  
ATOM    435  CB  GLN A  82      24.261 107.459  22.230  1.00 35.28           C  
ATOM    436  CG  GLN A  82      23.734 106.925  23.560  1.00 36.88           C  
ATOM    437  CD  GLN A  82      24.272 105.551  23.910  1.00 47.75           C  
ATOM    438  OE1 GLN A  82      25.205 105.052  23.290  1.00 39.89           O  
ATOM    439  NE2 GLN A  82      23.685 104.934  24.923  1.00 42.59           N  
ATOM    440  N   LEU A  83      24.094 109.375  19.566  1.00 39.27           N  
ATOM    441  CA  LEU A  83      24.758 110.035  18.443  1.00 35.29           C  
ATOM    442  C   LEU A  83      24.668 111.544  18.586  1.00 33.70           C  
ATOM    443  O   LEU A  83      25.637 112.245  18.331  1.00 36.22           O  
ATOM    444  CB  LEU A  83      24.153 109.594  17.107  1.00 39.48           C  
ATOM    445  CG  LEU A  83      24.495 108.158  16.671  1.00 39.90           C  
ATOM    446  CD1 LEU A  83      23.613 107.677  15.540  1.00 41.45           C  
ATOM    447  CD2 LEU A  83      25.983 107.990  16.301  1.00 36.46           C  
ATOM    448  N   VAL A  84      23.497 112.044  18.989  1.00 36.54           N  
ATOM    449  CA  VAL A  84      23.298 113.475  19.198  1.00 36.50           C  
ATOM    450  C   VAL A  84      24.213 113.994  20.313  1.00 37.24           C  
ATOM    451  O   VAL A  84      24.806 115.058  20.204  1.00 37.46           O  
ATOM    452  CB  VAL A  84      21.807 113.814  19.465  1.00 37.12           C  
ATOM    453  CG1 VAL A  84      21.658 115.289  19.928  1.00 35.73           C  
ATOM    454  CG2 VAL A  84      20.978 113.529  18.203  1.00 33.76           C  
ATOM    455  N   ASP A  85      24.331 113.218  21.374  1.00 39.04           N  
ATOM    456  CA  ASP A  85      25.233 113.517  22.484  1.00 39.16           C  
ATOM    457  C   ASP A  85      26.721 113.568  22.059  1.00 37.20           C  
ATOM    458  O   ASP A  85      27.436 114.528  22.386  1.00 37.46           O  
ATOM    459  CB  ASP A  85      25.011 112.463  23.590  1.00 45.39           C  
ATOM    460  CG  ASP A  85      25.831 112.737  24.835  1.00 47.05           C  
ATOM    461  OD1 ASP A  85      25.927 113.908  25.240  1.00 50.14           O  
ATOM    462  OD2 ASP A  85      26.355 111.770  25.423  1.00 61.18           O  
ATOM    463  N   LEU A  86      27.198 112.550  21.352  1.00 38.30           N  
ATOM    464  CA  LEU A  86      28.577 112.557  20.855  1.00 36.36           C  
ATOM    465  C   LEU A  86      28.823 113.767  19.977  1.00 36.79           C  
ATOM    466  O   LEU A  86      29.836 114.465  20.139  1.00 39.75           O  
ATOM    467  CB  LEU A  86      28.913 111.287  20.056  1.00 40.67           C  
ATOM    468  CG  LEU A  86      29.166 109.984  20.808  1.00 45.31           C  
ATOM    469  CD1 LEU A  86      29.330 108.826  19.819  1.00 45.73           C  
ATOM    470  CD2 LEU A  86      30.392 110.084  21.703  1.00 41.12           C  
ATOM    471  N   HIS A  87      27.888 114.027  19.069  1.00 37.98           N  
ATOM    472  CA  HIS A  87      28.019 115.187  18.175  1.00 31.86           C  
ATOM    473  C   HIS A  87      28.082 116.487  18.956  1.00 37.45           C  
ATOM    474  O   HIS A  87      28.934 117.321  18.673  1.00 37.15           O  
ATOM    475  CB  HIS A  87      26.923 115.210  17.090  1.00 37.29           C  
ATOM    476  CG  HIS A  87      27.140 116.269  16.043  1.00 33.78           C  
ATOM    477  ND1 HIS A  87      26.287 117.339  15.889  1.00 46.53           N  
ATOM    478  CD2 HIS A  87      28.113 116.424  15.114  1.00 41.23           C  
ATOM    479  CE1 HIS A  87      26.749 118.134  14.933  1.00 52.67           C  
ATOM    480  NE2 HIS A  87      27.858 117.603  14.448  1.00 35.98           N  
ATOM    481  N   ALA A  88      27.188 116.656  19.939  1.00 39.75           N  
ATOM    482  CA  ALA A  88      27.176 117.837  20.790  1.00 40.35           C  
ATOM    483  C   ALA A  88      28.509 117.988  21.495  1.00 41.57           C  
ATOM    484  O   ALA A  88      29.064 119.078  21.556  1.00 37.75           O  
ATOM    485  CB  ALA A  88      26.023 117.776  21.825  1.00 36.53           C  
ATOM    486  N   ARG A  89      29.046 116.888  22.003  1.00 35.98           N  
ATOM    487  CA  ARG A  89      30.244 116.973  22.835  1.00 36.84           C  
ATOM    488  C   ARG A  89      31.575 117.028  22.056  1.00 35.53           C  
ATOM    489  O   ARG A  89      32.564 117.610  22.551  1.00 35.45           O  
ATOM    490  CB  ARG A  89      30.201 115.855  23.881  1.00 41.79           C  
ATOM    491  CG  ARG A  89      29.127 116.171  24.947  1.00 41.37           C  
ATOM    492  CD  ARG A  89      29.187 115.262  26.138  1.00 48.30           C  
ATOM    493  NE  ARG A  89      28.926 113.878  25.742  1.00 39.17           N  
ATOM    494  CZ  ARG A  89      29.837 112.907  25.731  1.00 47.81           C  
ATOM    495  NH1 ARG A  89      29.485 111.689  25.360  1.00 45.37           N  
ATOM    496  NH2 ARG A  89      31.100 113.147  26.069  1.00 44.45           N  
ATOM    497  N   TYR A  90      31.587 116.542  20.821  1.00 33.79           N  
ATOM    498  CA  TYR A  90      32.844 116.439  20.041  1.00 31.47           C  
ATOM    499  C   TYR A  90      32.881 117.125  18.662  1.00 38.91           C  
ATOM    500  O   TYR A  90      33.919 117.081  17.956  1.00 36.29           O  
ATOM    501  CB  TYR A  90      33.193 114.981  19.860  1.00 33.01           C  
ATOM    502  CG  TYR A  90      33.577 114.301  21.143  1.00 35.02           C  
ATOM    503  CD1 TYR A  90      34.805 114.545  21.731  1.00 40.24           C  
ATOM    504  CD2 TYR A  90      32.705 113.404  21.768  1.00 38.32           C  
ATOM    505  CE1 TYR A  90      35.178 113.917  22.899  1.00 39.84           C  
ATOM    506  CE2 TYR A  90      33.071 112.775  22.959  1.00 38.52           C  
ATOM    507  CZ  TYR A  90      34.317 113.051  23.508  1.00 41.60           C  
ATOM    508  OH  TYR A  90      34.715 112.444  24.669  1.00 44.27           O  
ATOM    509  N   ALA A  91      31.803 117.804  18.284  1.00 38.83           N  
ATOM    510  CA  ALA A  91      31.804 118.494  16.982  1.00 38.49           C  
ATOM    511  C   ALA A  91      32.976 119.485  16.929  1.00 40.58           C  
ATOM    512  O   ALA A  91      33.629 119.633  15.898  1.00 37.55           O  
ATOM    513  CB  ALA A  91      30.496 119.237  16.756  1.00 40.79           C  
ATOM    514  N   GLU A  92      33.237 120.159  18.040  1.00 37.08           N  
ATOM    515  CA  GLU A  92      34.305 121.173  18.082  1.00 41.19           C  
ATOM    516  C   GLU A  92      35.702 120.549  18.052  1.00 39.23           C  
ATOM    517  O   GLU A  92      36.656 121.229  17.805  1.00 37.24           O  
ATOM    518  CB  GLU A  92      34.157 122.056  19.317  1.00 40.16           C  
ATOM    519  CG  GLU A  92      32.893 122.913  19.305  1.00 56.35           C  
ATOM    520  CD  GLU A  92      32.522 123.422  20.680  1.00 69.59           C  
ATOM    521  OE1 GLU A  92      31.649 122.813  21.360  1.00 63.17           O  
ATOM    522  OE2 GLU A  92      33.128 124.426  21.093  1.00 55.86           O  
ATOM    523  N   CYS A  93      35.803 119.249  18.314  1.00 35.56           N  
ATOM    524  CA  CYS A  93      37.061 118.501  18.189  1.00 40.50           C  
ATOM    525  C   CYS A  93      37.260 117.916  16.786  1.00 42.04           C  
ATOM    526  O   CYS A  93      38.329 117.422  16.482  1.00 42.45           O  
ATOM    527  CB  CYS A  93      37.059 117.336  19.194  1.00 38.66           C  
ATOM    528  SG  CYS A  93      36.712 117.859  20.883  1.00 40.92           S  
ATOM    529  N   GLY A  94      36.211 117.945  15.962  1.00 39.17           N  
ATOM    530  CA  GLY A  94      36.295 117.510  14.578  1.00 40.57           C  
ATOM    531  C   GLY A  94      35.428 116.325  14.233  1.00 35.57           C  
ATOM    532  O   GLY A  94      35.544 115.779  13.139  1.00 39.88           O  
ATOM    533  N   LEU A  95      34.530 115.924  15.138  1.00 33.50           N  
ATOM    534  CA  LEU A  95      33.641 114.811  14.864  1.00 32.38           C  
ATOM    535  C   LEU A  95      32.458 115.228  13.994  1.00 36.47           C  
ATOM    536  O   LEU A  95      31.785 116.232  14.283  1.00 35.64           O  
ATOM    537  CB  LEU A  95      33.108 114.208  16.167  1.00 34.88           C  
ATOM    538  CG  LEU A  95      32.192 113.009  15.998  1.00 36.80           C  
ATOM    539  CD1 LEU A  95      32.980 111.813  15.442  1.00 38.04           C  
ATOM    540  CD2 LEU A  95      31.487 112.609  17.300  1.00 34.37           C  
ATOM    541  N   ARG A  96      32.202 114.431  12.949  1.00 36.16           N  
ATOM    542  CA  ARG A  96      31.021 114.566  12.104  1.00 35.23           C  
ATOM    543  C   ARG A  96      30.330 113.227  12.041  1.00 36.32           C  
ATOM    544  O   ARG A  96      30.969 112.183  12.196  1.00 36.30           O  
ATOM    545  CB  ARG A  96      31.393 115.028  10.693  1.00 36.62           C  
ATOM    546  CG  ARG A  96      32.146 116.365  10.671  1.00 35.24           C  
ATOM    547  CD  ARG A  96      31.225 117.505  11.092  1.00 38.23           C  
ATOM    548  NE  ARG A  96      31.884 118.804  11.075  1.00 39.94           N  
ATOM    549  CZ  ARG A  96      32.467 119.414  12.110  1.00 44.71           C  
ATOM    550  NH1 ARG A  96      32.576 118.859  13.300  1.00 39.50           N  
ATOM    551  NH2 ARG A  96      33.002 120.611  11.931  1.00 39.81           N  
ATOM    552  N   ILE A  97      29.019 113.263  11.839  1.00 35.54           N  
ATOM    553  CA  ILE A  97      28.225 112.039  11.768  1.00 37.36           C  
ATOM    554  C   ILE A  97      27.382 112.074  10.492  1.00 38.45           C  
ATOM    555  O   ILE A  97      26.712 113.056  10.217  1.00 36.44           O  
ATOM    556  CB  ILE A  97      27.348 111.835  13.038  1.00 36.89           C  
ATOM    557  CG1 ILE A  97      28.236 111.763  14.291  1.00 38.16           C  
ATOM    558  CG2 ILE A  97      26.483 110.543  12.926  1.00 31.74           C  
ATOM    559  CD1 ILE A  97      27.513 111.652  15.591  1.00 37.09           C  
ATOM    560  N   LEU A  98      27.459 110.995   9.724  1.00 37.90           N  
ATOM    561  CA  LEU A  98      26.707 110.854   8.469  1.00 34.77           C  
ATOM    562  C   LEU A  98      25.727 109.739   8.697  1.00 34.24           C  
ATOM    563  O   LEU A  98      26.135 108.601   8.907  1.00 38.40           O  
ATOM    564  CB  LEU A  98      27.638 110.463   7.324  1.00 34.12           C  
ATOM    565  CG  LEU A  98      28.657 111.472   6.803  1.00 37.44           C  
ATOM    566  CD1 LEU A  98      29.789 111.676   7.796  1.00 39.19           C  
ATOM    567  CD2 LEU A  98      29.182 110.950   5.459  1.00 37.22           C  
ATOM    568  N   ALA A  99      24.436 110.056   8.644  1.00 35.17           N  
ATOM    569  CA  ALA A  99      23.389 109.081   8.893  1.00 34.39           C  
ATOM    570  C   ALA A  99      22.644 108.771   7.610  1.00 35.33           C  
ATOM    571  O   ALA A  99      22.114 109.673   6.967  1.00 37.22           O  
ATOM    572  CB  ALA A  99      22.413 109.615   9.950  1.00 33.71           C  
ATOM    573  N   PHE A 100      22.621 107.491   7.243  1.00 36.03           N  
ATOM    574  CA  PHE A 100      21.971 106.990   6.044  1.00 34.50           C  
ATOM    575  C   PHE A 100      20.770 106.136   6.406  1.00 35.97           C  
ATOM    576  O   PHE A 100      20.937 105.017   6.908  1.00 37.19           O  
ATOM    577  CB  PHE A 100      22.959 106.116   5.222  1.00 34.68           C  
ATOM    578  CG  PHE A 100      24.036 106.906   4.550  1.00 33.83           C  
ATOM    579  CD1 PHE A 100      23.870 107.375   3.255  1.00 34.08           C  
ATOM    580  CD2 PHE A 100      25.214 107.202   5.221  1.00 37.59           C  
ATOM    581  CE1 PHE A 100      24.862 108.126   2.645  1.00 38.10           C  
ATOM    582  CE2 PHE A 100      26.186 107.935   4.624  1.00 37.37           C  
ATOM    583  CZ  PHE A 100      26.016 108.411   3.333  1.00 40.68           C  
ATOM    584  N   PRO A 101      19.544 106.654   6.172  1.00 35.26           N  
ATOM    585  CA  PRO A 101      18.377 105.823   6.416  1.00 31.95           C  
ATOM    586  C   PRO A 101      18.381 104.601   5.530  1.00 34.68           C  
ATOM    587  O   PRO A 101      18.809 104.663   4.371  1.00 35.46           O  
ATOM    588  CB  PRO A 101      17.190 106.738   6.082  1.00 31.04           C  
ATOM    589  CG  PRO A 101      17.777 108.157   6.119  1.00 36.32           C  
ATOM    590  CD  PRO A 101      19.185 107.995   5.682  1.00 36.89           C  
ATOM    591  N   CYS A 102      17.880 103.488   6.070  1.00 38.79           N  
ATOM    592  CA  CYS A 102      17.809 102.242   5.313  1.00 35.79           C  
ATOM    593  C   CYS A 102      16.663 101.389   5.823  1.00 37.82           C  
ATOM    594  O   CYS A 102      16.522 101.202   7.027  1.00 34.80           O  
ATOM    595  CB  CYS A 102      19.140 101.488   5.437  1.00 36.55           C  
ATOM    596  SG  CYS A 102      19.205  99.895   4.619  1.00 39.10           S  
ATOM    597  N   ASN A 103      15.865 100.884   4.884  1.00 34.94           N  
ATOM    598  CA  ASN A 103      14.625 100.115   5.145  1.00 37.05           C  
ATOM    599  C   ASN A 103      14.780  98.596   4.943  1.00 33.50           C  
ATOM    600  O   ASN A 103      13.786  97.850   4.792  1.00 36.43           O  
ATOM    601  CB  ASN A 103      13.532 100.665   4.225  1.00 36.98           C  
ATOM    602  CG  ASN A 103      12.126 100.268   4.651  1.00 38.77           C  
ATOM    603  OD1 ASN A 103      11.808 100.163   5.839  1.00 33.60           O  
ATOM    604  ND2 ASN A 103      11.264 100.073   3.665  1.00 33.52           N  
ATOM    605  N   GLN A 104      16.018  98.116   4.998  1.00 32.74           N  
ATOM    606  CA  GLN A 104      16.323  96.721   4.659  1.00 33.29           C  
ATOM    607  C   GLN A 104      16.197  95.755   5.852  1.00 37.74           C  
ATOM    608  O   GLN A 104      16.232  94.526   5.677  1.00 36.87           O  
ATOM    609  CB  GLN A 104      17.718  96.614   4.043  1.00 40.61           C  
ATOM    610  CG  GLN A 104      17.794  97.096   2.609  1.00 42.06           C  
ATOM    611  CD  GLN A 104      19.143  96.817   1.976  1.00 41.72           C  
ATOM    612  OE1 GLN A 104      20.167  97.426   2.338  1.00 41.31           O  
ATOM    613  NE2 GLN A 104      19.145  95.940   0.974  1.00 39.96           N  
ATOM    614  N   PHE A 105      15.979  96.302   7.043  1.00 36.64           N  
ATOM    615  CA  PHE A 105      15.958  95.500   8.277  1.00 36.40           C  
ATOM    616  C   PHE A 105      14.595  95.584   8.942  1.00 38.53           C  
ATOM    617  O   PHE A 105      14.292  96.532   9.666  1.00 36.80           O  
ATOM    618  CB  PHE A 105      17.101  95.965   9.187  1.00 37.04           C  
ATOM    619  CG  PHE A 105      18.424  95.951   8.487  1.00 33.51           C  
ATOM    620  CD1 PHE A 105      19.020  94.733   8.161  1.00 38.63           C  
ATOM    621  CD2 PHE A 105      19.025  97.121   8.065  1.00 38.65           C  
ATOM    622  CE1 PHE A 105      20.241  94.706   7.477  1.00 41.63           C  
ATOM    623  CE2 PHE A 105      20.226  97.091   7.370  1.00 41.56           C  
ATOM    624  CZ  PHE A 105      20.816  95.868   7.068  1.00 42.54           C  
ATOM    625  N   GLY A 106      13.766  94.587   8.646  1.00 35.44           N  
ATOM    626  CA  GLY A 106      12.380  94.521   9.125  1.00 40.12           C  
ATOM    627  C   GLY A 106      11.508  95.665   8.626  1.00 39.14           C  
ATOM    628  O   GLY A 106      10.475  95.977   9.235  1.00 38.64           O  
ATOM    629  N   LYS A 107      11.911  96.261   7.500  1.00 37.18           N  
ATOM    630  CA  LYS A 107      11.230  97.431   6.940  1.00 38.13           C  
ATOM    631  C   LYS A 107      10.980  98.464   8.033  1.00 35.84           C  
ATOM    632  O   LYS A 107       9.864  98.951   8.233  1.00 34.20           O  
ATOM    633  CB  LYS A 107       9.937  97.008   6.231  1.00 39.40           C  
ATOM    634  CG  LYS A 107      10.224  96.167   4.997  1.00 48.97           C  
ATOM    635  CD  LYS A 107       8.986  95.795   4.210  1.00 55.64           C  
ATOM    636  CE  LYS A 107       9.372  95.219   2.846  1.00 61.72           C  
ATOM    637  N   GLN A 108      12.051  98.812   8.726  1.00 35.02           N  
ATOM    638  CA  GLN A 108      11.963  99.693   9.883  1.00 33.00           C  
ATOM    639  C   GLN A 108      12.314 101.153   9.575  1.00 33.18           C  
ATOM    640  O   GLN A 108      12.497 101.961  10.478  1.00 36.62           O  
ATOM    641  CB  GLN A 108      12.769  99.101  11.035  1.00 32.02           C  
ATOM    642  CG  GLN A 108      12.004  97.956  11.635  1.00 33.07           C  
ATOM    643  CD  GLN A 108      12.779  97.124  12.610  1.00 40.44           C  
ATOM    644  OE1 GLN A 108      13.889  97.457  12.987  1.00 35.40           O  
ATOM    645  NE2 GLN A 108      12.173  96.035  13.046  1.00 35.86           N  
ATOM    646  N   GLU A 109      12.375 101.479   8.283  1.00 36.22           N  
ATOM    647  CA  GLU A 109      12.507 102.865   7.814  1.00 34.12           C  
ATOM    648  C   GLU A 109      11.616 103.057   6.574  1.00 33.98           C  
ATOM    649  O   GLU A 109      12.108 103.321   5.486  1.00 39.03           O  
ATOM    650  CB  GLU A 109      13.973 103.189   7.502  1.00 36.72           C  
ATOM    651  CG  GLU A 109      14.271 104.665   7.260  1.00 39.66           C  
ATOM    652  CD  GLU A 109      14.195 105.485   8.504  1.00 48.56           C  
ATOM    653  OE1 GLU A 109      15.245 106.056   8.896  1.00 56.58           O  
ATOM    654  OE2 GLU A 109      13.090 105.550   9.092  1.00 51.57           O  
ATOM    655  N   PRO A 110      10.289 102.861   6.733  1.00 38.41           N  
ATOM    656  CA  PRO A 110       9.379 102.879   5.587  1.00 39.17           C  
ATOM    657  C   PRO A 110       8.996 104.268   5.062  1.00 38.22           C  
ATOM    658  O   PRO A 110       8.466 104.377   3.961  1.00 40.04           O  
ATOM    659  CB  PRO A 110       8.131 102.182   6.132  1.00 39.40           C  
ATOM    660  CG  PRO A 110       8.141 102.491   7.578  1.00 41.04           C  
ATOM    661  CD  PRO A 110       9.578 102.566   7.992  1.00 41.76           C  
ATOM    662  N   GLY A 111       9.225 105.309   5.846  1.00 40.71           N  
ATOM    663  CA  GLY A 111       8.771 106.643   5.493  1.00 42.20           C  
ATOM    664  C   GLY A 111       9.562 107.327   4.396  1.00 43.91           C  
ATOM    665  O   GLY A 111      10.582 106.817   3.919  1.00 44.08           O  
ATOM    666  N   SER A 112       9.072 108.497   3.998  1.00 42.31           N  
ATOM    667  CA  SER A 112       9.708 109.295   2.962  1.00 39.66           C  
ATOM    668  C   SER A 112      10.875 110.038   3.581  1.00 36.55           C  
ATOM    669  O   SER A 112      10.969 110.149   4.798  1.00 36.86           O  
ATOM    670  CB  SER A 112       8.713 110.301   2.396  1.00 40.20           C  
ATOM    671  OG  SER A 112       8.360 111.242   3.394  1.00 31.71           O  
ATOM    672  N   ASN A 113      11.757 110.558   2.741  1.00 37.37           N  
ATOM    673  CA  ASN A 113      12.882 111.344   3.226  1.00 37.00           C  
ATOM    674  C   ASN A 113      12.425 112.537   4.055  1.00 36.97           C  
ATOM    675  O   ASN A 113      13.053 112.888   5.062  1.00 37.50           O  
ATOM    676  CB  ASN A 113      13.752 111.797   2.064  1.00 41.39           C  
ATOM    677  CG  ASN A 113      14.547 110.658   1.462  1.00 37.73           C  
ATOM    678  OD1 ASN A 113      15.088 109.819   2.178  1.00 37.13           O  
ATOM    679  ND2 ASN A 113      14.641 110.637   0.139  1.00 40.94           N  
ATOM    680  N   GLU A 114      11.319 113.143   3.641  1.00 36.27           N  
ATOM    681  CA  GLU A 114      10.749 114.289   4.347  1.00 36.67           C  
ATOM    682  C   GLU A 114      10.309 113.901   5.762  1.00 35.43           C  
ATOM    683  O   GLU A 114      10.591 114.607   6.726  1.00 34.90           O  
ATOM    684  CB  GLU A 114       9.569 114.874   3.557  1.00 40.76           C  
ATOM    685  CG  GLU A 114       9.865 115.117   2.059  1.00 52.18           C  
ATOM    686  CD  GLU A 114       9.412 113.958   1.150  1.00 70.17           C  
ATOM    687  OE1 GLU A 114      10.266 113.105   0.795  1.00 41.94           O  
ATOM    688  OE2 GLU A 114       8.205 113.895   0.801  1.00 69.98           O  
ATOM    689  N   GLU A 115       9.641 112.757   5.880  1.00 34.74           N  
ATOM    690  CA  GLU A 115       9.221 112.225   7.175  1.00 36.59           C  
ATOM    691  C   GLU A 115      10.417 111.841   8.058  1.00 36.46           C  
ATOM    692  O   GLU A 115      10.418 112.095   9.266  1.00 36.19           O  
ATOM    693  CB  GLU A 115       8.301 111.010   6.962  1.00 35.83           C  
ATOM    694  CG  GLU A 115       6.964 111.369   6.295  1.00 42.64           C  
ATOM    695  CD  GLU A 115       6.102 110.162   5.928  1.00 45.36           C  
ATOM    696  OE1 GLU A 115       6.628 109.139   5.440  1.00 47.93           O  
ATOM    697  OE2 GLU A 115       4.875 110.258   6.111  1.00 65.40           O  
ATOM    698  N   ILE A 116      11.438 111.236   7.453  1.00 36.33           N  
ATOM    699  CA  ILE A 116      12.648 110.857   8.193  1.00 37.23           C  
ATOM    700  C   ILE A 116      13.377 112.103   8.717  1.00 40.63           C  
ATOM    701  O   ILE A 116      13.889 112.118   9.841  1.00 38.14           O  
ATOM    702  CB  ILE A 116      13.597 109.992   7.328  1.00 37.71           C  
ATOM    703  CG1 ILE A 116      12.919 108.650   6.973  1.00 38.53           C  
ATOM    704  CG2 ILE A 116      14.954 109.782   8.065  1.00 37.40           C  
ATOM    705  CD1 ILE A 116      13.522 107.907   5.744  1.00 37.53           C  
ATOM    706  N   LYS A 117      13.387 113.158   7.910  1.00 37.05           N  
ATOM    707  CA  LYS A 117      13.978 114.430   8.311  1.00 38.49           C  
ATOM    708  C   LYS A 117      13.298 114.985   9.569  1.00 36.81           C  
ATOM    709  O   LYS A 117      13.971 115.406  10.508  1.00 38.02           O  
ATOM    710  CB  LYS A 117      13.885 115.437   7.152  1.00 33.54           C  
ATOM    711  CG  LYS A 117      14.695 116.719   7.350  1.00 37.28           C  
ATOM    712  CD  LYS A 117      14.438 117.714   6.259  1.00 45.98           C  
ATOM    713  CE  LYS A 117      15.276 118.984   6.477  1.00 49.20           C  
ATOM    714  NZ  LYS A 117      14.875 120.059   5.531  1.00 59.76           N  
ATOM    715  N   GLU A 118      11.966 114.980   9.589  1.00 36.81           N  
ATOM    716  CA  GLU A 118      11.221 115.475  10.738  1.00 37.73           C  
ATOM    717  C   GLU A 118      11.415 114.543  11.946  1.00 37.73           C  
ATOM    718  O   GLU A 118      11.459 114.997  13.089  1.00 37.83           O  
ATOM    719  CB  GLU A 118       9.725 115.620  10.400  1.00 40.39           C  
ATOM    720  CG  GLU A 118       8.911 116.444  11.413  1.00 47.50           C  
ATOM    721  CD  GLU A 118       9.337 117.910  11.478  1.00 53.59           C  
ATOM    722  N   PHE A 119      11.538 113.244  11.696  1.00 38.12           N  
ATOM    723  CA  PHE A 119      11.810 112.300  12.784  1.00 39.84           C  
ATOM    724  C   PHE A 119      13.108 112.671  13.504  1.00 37.59           C  
ATOM    725  O   PHE A 119      13.146 112.782  14.730  1.00 34.47           O  
ATOM    726  CB  PHE A 119      11.918 110.874  12.261  1.00 41.25           C  
ATOM    727  CG  PHE A 119      12.027 109.862  13.346  1.00 39.74           C  
ATOM    728  CD1 PHE A 119      10.890 109.427  14.004  1.00 44.26           C  
ATOM    729  CD2 PHE A 119      13.257 109.379  13.744  1.00 41.95           C  
ATOM    730  CE1 PHE A 119      10.977 108.514  15.025  1.00 45.32           C  
ATOM    731  CE2 PHE A 119      13.345 108.459  14.776  1.00 40.68           C  
ATOM    732  CZ  PHE A 119      12.206 108.031  15.411  1.00 42.01           C  
ATOM    733  N   ALA A 120      14.164 112.867  12.723  1.00 39.29           N  
ATOM    734  CA  ALA A 120      15.472 113.258  13.245  1.00 40.84           C  
ATOM    735  C   ALA A 120      15.432 114.601  13.987  1.00 42.13           C  
ATOM    736  O   ALA A 120      16.126 114.793  14.991  1.00 42.79           O  
ATOM    737  CB  ALA A 120      16.491 113.298  12.114  1.00 39.11           C  
ATOM    738  N   ALA A 121      14.606 115.522  13.497  1.00 42.69           N  
ATOM    739  CA  ALA A 121      14.453 116.834  14.121  1.00 41.66           C  
ATOM    740  C   ALA A 121      13.886 116.699  15.540  1.00 40.06           C  
ATOM    741  O   ALA A 121      14.226 117.470  16.419  1.00 41.59           O  
ATOM    742  CB  ALA A 121      13.570 117.738  13.254  1.00 39.13           C  
ATOM    743  N   GLY A 122      13.058 115.687  15.775  1.00 41.72           N  
ATOM    744  CA  GLY A 122      12.508 115.447  17.110  1.00 40.07           C  
ATOM    745  C   GLY A 122      13.567 115.006  18.113  1.00 40.86           C  
ATOM    746  O   GLY A 122      13.370 115.129  19.317  1.00 38.61           O  
ATOM    747  N   TYR A 123      14.684 114.475  17.614  1.00 35.72           N  
ATOM    748  CA  TYR A 123      15.837 114.123  18.452  1.00 36.96           C  
ATOM    749  C   TYR A 123      16.867 115.245  18.509  1.00 37.24           C  
ATOM    750  O   TYR A 123      17.928 115.086  19.106  1.00 41.17           O  
ATOM    751  CB  TYR A 123      16.496 112.842  17.939  1.00 37.10           C  
ATOM    752  CG  TYR A 123      15.771 111.612  18.394  1.00 35.96           C  
ATOM    753  CD1 TYR A 123      15.957 111.119  19.674  1.00 41.53           C  
ATOM    754  CD2 TYR A 123      14.896 110.942  17.547  1.00 44.55           C  
ATOM    755  CE1 TYR A 123      15.277 109.977  20.108  1.00 41.49           C  
ATOM    756  CE2 TYR A 123      14.206 109.817  17.975  1.00 46.86           C  
ATOM    757  CZ  TYR A 123      14.410 109.336  19.245  1.00 43.65           C  
ATOM    758  OH  TYR A 123      13.730 108.224  19.663  1.00 44.56           O  
ATOM    759  N   ASN A 124      16.532 116.383  17.913  1.00 37.39           N  
ATOM    760  CA  ASN A 124      17.425 117.537  17.857  1.00 37.34           C  
ATOM    761  C   ASN A 124      18.755 117.199  17.173  1.00 36.59           C  
ATOM    762  O   ASN A 124      19.835 117.657  17.581  1.00 40.55           O  
ATOM    763  CB  ASN A 124      17.630 118.118  19.259  1.00 38.77           C  
ATOM    764  CG  ASN A 124      16.303 118.518  19.925  1.00 59.55           C  
ATOM    765  OD1 ASN A 124      15.505 119.264  19.346  1.00 64.46           O  
ATOM    766  ND2 ASN A 124      16.063 118.013  21.137  1.00 57.71           N  
ATOM    767  N   VAL A 125      18.654 116.446  16.083  1.00 34.34           N  
ATOM    768  CA  VAL A 125      19.826 116.045  15.298  1.00 34.82           C  
ATOM    769  C   VAL A 125      20.414 117.252  14.568  1.00 39.48           C  
ATOM    770  O   VAL A 125      19.700 117.938  13.822  1.00 38.58           O  
ATOM    771  CB  VAL A 125      19.447 114.933  14.299  1.00 34.36           C  
ATOM    772  CG1 VAL A 125      20.484 114.806  13.174  1.00 35.61           C  
ATOM    773  CG2 VAL A 125      19.274 113.614  15.050  1.00 34.05           C  
ATOM    774  N   LYS A 126      21.700 117.513  14.806  1.00 38.01           N  
ATOM    775  CA  LYS A 126      22.431 118.593  14.119  1.00 38.61           C  
ATOM    776  C   LYS A 126      23.513 118.076  13.166  1.00 40.56           C  
ATOM    777  O   LYS A 126      24.213 118.863  12.523  1.00 37.76           O  
ATOM    778  CB  LYS A 126      23.097 119.521  15.132  1.00 42.91           C  
ATOM    779  CG  LYS A 126      22.166 120.164  16.165  1.00 45.49           C  
ATOM    780  CD  LYS A 126      20.980 120.841  15.543  1.00 54.44           C  
ATOM    781  CE  LYS A 126      20.215 121.630  16.591  1.00 65.50           C  
ATOM    782  NZ  LYS A 126      19.090 122.381  15.983  1.00 76.37           N  
ATOM    783  N   PHE A 127      23.668 116.768  13.102  1.00 37.49           N  
ATOM    784  CA  PHE A 127      24.609 116.141  12.191  1.00 38.58           C  
ATOM    785  C   PHE A 127      23.940 115.888  10.832  1.00 43.82           C  
ATOM    786  O   PHE A 127      22.826 116.363  10.592  1.00 39.30           O  
ATOM    787  CB  PHE A 127      25.246 114.906  12.827  1.00 39.59           C  
ATOM    788  CG  PHE A 127      24.270 113.847  13.311  1.00 38.91           C  
ATOM    789  CD1 PHE A 127      23.641 113.005  12.415  1.00 37.99           C  
ATOM    790  CD2 PHE A 127      24.029 113.675  14.674  1.00 39.03           C  
ATOM    791  CE1 PHE A 127      22.762 112.009  12.853  1.00 38.49           C  
ATOM    792  CE2 PHE A 127      23.168 112.685  15.125  1.00 41.04           C  
ATOM    793  CZ  PHE A 127      22.527 111.856  14.219  1.00 37.40           C  
ATOM    794  N   ASP A 128      24.613 115.179   9.927  1.00 40.10           N  
ATOM    795  CA  ASP A 128      24.234 115.227   8.511  1.00 38.94           C  
ATOM    796  C   ASP A 128      23.387 114.026   8.172  1.00 37.47           C  
ATOM    797  O   ASP A 128      23.816 112.903   8.391  1.00 35.72           O  
ATOM    798  CB  ASP A 128      25.496 115.295   7.650  1.00 39.97           C  
ATOM    799  CG  ASP A 128      26.285 116.570   7.905  1.00 52.56           C  
ATOM    800  OD1 ASP A 128      25.622 117.617   8.070  1.00 49.56           O  
ATOM    801  OD2 ASP A 128      27.535 116.531   7.971  1.00 46.45           O  
ATOM    802  N   MET A 129      22.172 114.284   7.683  1.00 37.39           N  
ATOM    803  CA  MET A 129      21.206 113.240   7.344  1.00 37.95           C  
ATOM    804  C   MET A 129      21.222 113.102   5.834  1.00 37.00           C  
ATOM    805  O   MET A 129      21.235 114.098   5.116  1.00 37.04           O  
ATOM    806  CB  MET A 129      19.796 113.645   7.775  1.00 41.40           C  
ATOM    807  CG  MET A 129      19.574 113.730   9.288  1.00 39.28           C  
ATOM    808  SD  MET A 129      19.715 112.170  10.156  1.00 46.57           S  
ATOM    809  CE  MET A 129      18.523 111.129   9.323  1.00 39.37           C  
ATOM    810  N   PHE A 130      21.222 111.870   5.366  1.00 35.80           N  
ATOM    811  CA  PHE A 130      21.211 111.571   3.951  1.00 34.13           C  
ATOM    812  C   PHE A 130      19.892 110.959   3.497  1.00 35.17           C  
ATOM    813  O   PHE A 130      19.095 110.492   4.304  1.00 37.31           O  
ATOM    814  CB  PHE A 130      22.432 110.694   3.595  1.00 32.73           C  
ATOM    815  CG  PHE A 130      23.728 111.435   3.703  1.00 37.99           C  
ATOM    816  CD1 PHE A 130      24.291 112.028   2.579  1.00 36.11           C  
ATOM    817  CD2 PHE A 130      24.349 111.600   4.929  1.00 38.86           C  
ATOM    818  CE1 PHE A 130      25.476 112.778   2.662  1.00 42.84           C  
ATOM    819  CE2 PHE A 130      25.524 112.353   5.030  1.00 38.63           C  
ATOM    820  CZ  PHE A 130      26.090 112.926   3.897  1.00 39.98           C  
ATOM    821  N   SER A 131      19.641 110.999   2.190  1.00 34.45           N  
ATOM    822  CA  SER A 131      18.521 110.276   1.601  1.00 33.71           C  
ATOM    823  C   SER A 131      18.648 108.783   1.842  1.00 37.06           C  
ATOM    824  O   SER A 131      19.758 108.242   1.883  1.00 34.12           O  
ATOM    825  CB  SER A 131      18.424 110.526   0.089  1.00 39.51           C  
ATOM    826  OG  SER A 131      18.083 111.885  -0.159  1.00 48.18           O  
ATOM    827  N   LYS A 132      17.495 108.122   1.913  1.00 35.56           N  
ATOM    828  CA  LYS A 132      17.406 106.676   2.143  1.00 33.95           C  
ATOM    829  C   LYS A 132      18.098 105.902   1.032  1.00 40.32           C  
ATOM    830  O   LYS A 132      17.947 106.220  -0.155  1.00 38.41           O  
ATOM    831  CB  LYS A 132      15.935 106.260   2.210  1.00 38.66           C  
ATOM    832  CG  LYS A 132      15.688 104.810   2.701  1.00 41.61           C  
ATOM    833  CD  LYS A 132      14.249 104.327   2.438  1.00 45.78           C  
ATOM    834  CE  LYS A 132      13.177 105.183   3.088  1.00 47.51           C  
ATOM    835  NZ  LYS A 132      11.808 104.542   3.003  1.00 34.36           N  
ATOM    836  N   ILE A 133      18.840 104.871   1.419  1.00 36.68           N  
ATOM    837  CA  ILE A 133      19.564 104.006   0.489  1.00 34.39           C  
ATOM    838  C   ILE A 133      19.408 102.542   0.885  1.00 39.70           C  
ATOM    839  O   ILE A 133      18.846 102.261   1.927  1.00 38.76           O  
ATOM    840  CB  ILE A 133      21.059 104.331   0.516  1.00 38.33           C  
ATOM    841  CG1 ILE A 133      21.625 104.185   1.950  1.00 38.20           C  
ATOM    842  CG2 ILE A 133      21.313 105.758  -0.023  1.00 39.20           C  
ATOM    843  CD1 ILE A 133      23.129 104.097   1.985  1.00 39.80           C  
ATOM    844  N   CYS A 134      19.943 101.640   0.061  1.00 36.08           N  
ATOM    845  CA  CYS A 134      20.262 100.259   0.488  1.00 38.72           C  
ATOM    846  C   CYS A 134      21.723 100.201   0.908  1.00 37.15           C  
ATOM    847  O   CYS A 134      22.576 100.861   0.311  1.00 37.67           O  
ATOM    848  CB  CYS A 134      20.045  99.273  -0.648  1.00 38.55           C  
ATOM    849  SG  CYS A 134      18.345  99.116  -1.064  1.00 46.90           S  
ATOM    850  N   VAL A 135      22.011  99.401   1.924  1.00 33.73           N  
ATOM    851  CA  VAL A 135      23.394  99.182   2.349  1.00 34.09           C  
ATOM    852  C   VAL A 135      23.944  97.799   1.993  1.00 35.44           C  
ATOM    853  O   VAL A 135      25.178  97.620   2.036  1.00 36.29           O  
ATOM    854  CB  VAL A 135      23.581  99.413   3.875  1.00 37.72           C  
ATOM    855  CG1 VAL A 135      23.206 100.832   4.258  1.00 35.05           C  
ATOM    856  CG2 VAL A 135      22.745  98.405   4.666  1.00 34.82           C  
ATOM    857  N   ASN A 136      23.039  96.840   1.725  1.00 34.25           N  
ATOM    858  CA  ASN A 136      23.360  95.504   1.244  1.00 32.80           C  
ATOM    859  C   ASN A 136      22.771  95.251  -0.134  1.00 35.52           C  
ATOM    860  O   ASN A 136      21.736  95.813  -0.487  1.00 35.87           O  
ATOM    861  CB  ASN A 136      22.762  94.442   2.171  1.00 34.09           C  
ATOM    862  CG  ASN A 136      23.404  94.416   3.545  1.00 32.36           C  
ATOM    863  OD1 ASN A 136      24.568  94.789   3.704  1.00 38.81           O  
ATOM    864  ND2 ASN A 136      22.635  93.982   4.554  1.00 33.34           N  
ATOM    865  N   GLY A 137      23.394  94.341  -0.879  1.00 38.05           N  
ATOM    866  CA  GLY A 137      22.830  93.832  -2.112  1.00 41.83           C  
ATOM    867  C   GLY A 137      23.272  94.608  -3.330  1.00 42.15           C  
ATOM    868  O   GLY A 137      24.055  95.528  -3.231  1.00 38.29           O  
ATOM    869  N   ASP A 138      22.748  94.233  -4.490  1.00 40.65           N  
ATOM    870  CA  ASP A 138      23.220  94.789  -5.763  1.00 44.71           C  
ATOM    871  C   ASP A 138      22.982  96.280  -5.892  1.00 43.64           C  
ATOM    872  O   ASP A 138      23.793  96.977  -6.535  1.00 40.41           O  
ATOM    873  CB  ASP A 138      22.576  94.032  -6.946  1.00 47.86           C  
ATOM    874  CG  ASP A 138      23.106  92.609  -7.088  1.00 58.42           C  
ATOM    875  OD1 ASP A 138      24.225  92.328  -6.591  1.00 62.15           O  
ATOM    876  OD2 ASP A 138      22.406  91.768  -7.706  1.00 71.80           O  
ATOM    877  N   ASP A 139      21.920  96.775  -5.245  1.00 37.67           N  
ATOM    878  CA  ASP A 139      21.565  98.204  -5.301  1.00 39.13           C  
ATOM    879  C   ASP A 139      22.109  99.034  -4.143  1.00 36.89           C  
ATOM    880  O   ASP A 139      21.767 100.225  -4.016  1.00 39.44           O  
ATOM    881  CB  ASP A 139      20.042  98.395  -5.387  1.00 42.54           C  
ATOM    882  CG  ASP A 139      19.471  97.982  -6.738  1.00 54.54           C  
ATOM    883  OD1 ASP A 139      20.104  98.244  -7.780  1.00 60.82           O  
ATOM    884  OD2 ASP A 139      18.371  97.397  -6.748  1.00 67.77           O  
ATOM    885  N   ALA A 140      23.002  98.446  -3.339  1.00 35.32           N  
ATOM    886  CA  ALA A 140      23.665  99.177  -2.279  1.00 32.25           C  
ATOM    887  C   ALA A 140      24.410 100.365  -2.815  1.00 36.77           C  
ATOM    888  O   ALA A 140      25.099 100.274  -3.834  1.00 34.59           O  
ATOM    889  CB  ALA A 140      24.646  98.272  -1.491  1.00 33.09           C  
ATOM    890  N   HIS A 141      24.331 101.464  -2.080  1.00 34.96           N  
ATOM    891  CA  HIS A 141      25.109 102.644  -2.399  1.00 37.37           C  
ATOM    892  C   HIS A 141      26.592 102.254  -2.452  1.00 36.53           C  
ATOM    893  O   HIS A 141      27.070 101.502  -1.606  1.00 35.32           O  
ATOM    894  CB  HIS A 141      24.853 103.734  -1.373  1.00 35.11           C  
ATOM    895  CG  HIS A 141      25.496 105.040  -1.721  1.00 35.50           C  
ATOM    896  ND1 HIS A 141      26.851 105.246  -1.611  1.00 35.89           N  
ATOM    897  CD2 HIS A 141      24.971 106.204  -2.174  1.00 40.56           C  
ATOM    898  CE1 HIS A 141      27.144 106.474  -2.010  1.00 41.98           C  
ATOM    899  NE2 HIS A 141      26.020 107.076  -2.357  1.00 41.35           N  
ATOM    900  N   PRO A 142      27.318 102.735  -3.462  1.00 37.46           N  
ATOM    901  CA  PRO A 142      28.725 102.356  -3.628  1.00 34.05           C  
ATOM    902  C   PRO A 142      29.619 102.594  -2.398  1.00 32.22           C  
ATOM    903  O   PRO A 142      30.549 101.825  -2.158  1.00 36.98           O  
ATOM    904  CB  PRO A 142      29.190 103.238  -4.794  1.00 37.28           C  
ATOM    905  CG  PRO A 142      27.989 103.586  -5.528  1.00 41.32           C  
ATOM    906  CD  PRO A 142      26.854 103.623  -4.550  1.00 42.60           C  
ATOM    907  N   LEU A 143      29.356 103.638  -1.625  1.00 34.87           N  
ATOM    908  CA  LEU A 143      30.154 103.902  -0.415  1.00 37.12           C  
ATOM    909  C   LEU A 143      30.043 102.742   0.553  1.00 35.39           C  
ATOM    910  O   LEU A 143      31.023 102.355   1.177  1.00 37.91           O  
ATOM    911  CB  LEU A 143      29.689 105.175   0.293  1.00 36.95           C  
ATOM    912  CG  LEU A 143      30.313 105.414   1.675  1.00 41.60           C  
ATOM    913  CD1 LEU A 143      31.801 105.719   1.505  1.00 37.98           C  
ATOM    914  CD2 LEU A 143      29.587 106.535   2.406  1.00 40.43           C  
ATOM    915  N   TRP A 144      28.841 102.193   0.656  1.00 36.82           N  
ATOM    916  CA  TRP A 144      28.567 101.070   1.546  1.00 36.49           C  
ATOM    917  C   TRP A 144      29.153  99.768   1.028  1.00 39.33           C  
ATOM    918  O   TRP A 144      29.669  98.975   1.803  1.00 37.69           O  
ATOM    919  CB  TRP A 144      27.060 100.978   1.829  1.00 36.19           C  
ATOM    920  CG  TRP A 144      26.676 102.023   2.834  1.00 34.01           C  
ATOM    921  CD1 TRP A 144      26.392 103.345   2.601  1.00 37.43           C  
ATOM    922  CD2 TRP A 144      26.561 101.830   4.242  1.00 37.50           C  
ATOM    923  NE1 TRP A 144      26.118 103.980   3.782  1.00 36.38           N  
ATOM    924  CE2 TRP A 144      26.212 103.076   4.807  1.00 38.49           C  
ATOM    925  CE3 TRP A 144      26.701 100.718   5.082  1.00 36.65           C  
ATOM    926  CZ2 TRP A 144      26.009 103.246   6.171  1.00 37.19           C  
ATOM    927  CZ3 TRP A 144      26.490 100.885   6.449  1.00 38.85           C  
ATOM    928  CH2 TRP A 144      26.160 102.144   6.972  1.00 34.25           C  
ATOM    929  N   LYS A 145      29.112  99.553  -0.282  1.00 34.90           N  
ATOM    930  CA  LYS A 145      29.822  98.431  -0.865  1.00 35.35           C  
ATOM    931  C   LYS A 145      31.316  98.521  -0.543  1.00 31.73           C  
ATOM    932  O   LYS A 145      31.957  97.520  -0.255  1.00 36.05           O  
ATOM    933  CB  LYS A 145      29.621  98.389  -2.382  1.00 36.40           C  
ATOM    934  CG  LYS A 145      28.204  98.086  -2.829  1.00 35.41           C  
ATOM    935  CD  LYS A 145      28.164  97.754  -4.331  1.00 35.26           C  
ATOM    936  CE  LYS A 145      26.754  97.529  -4.840  1.00 37.96           C  
ATOM    937  NZ  LYS A 145      26.731  97.287  -6.327  1.00 33.66           N  
ATOM    938  N   TRP A 146      31.880  99.715  -0.660  1.00 34.74           N  
ATOM    939  CA  TRP A 146      33.305  99.924  -0.425  1.00 31.66           C  
ATOM    940  C   TRP A 146      33.695  99.775   1.049  1.00 35.02           C  
ATOM    941  O   TRP A 146      34.713  99.145   1.369  1.00 33.90           O  
ATOM    942  CB  TRP A 146      33.705 101.319  -0.935  1.00 35.38           C  
ATOM    943  CG  TRP A 146      35.114 101.725  -0.634  1.00 34.78           C  
ATOM    944  CD1 TRP A 146      36.241 101.398  -1.340  1.00 39.09           C  
ATOM    945  CD2 TRP A 146      35.542 102.579   0.437  1.00 36.68           C  
ATOM    946  NE1 TRP A 146      37.346 102.004  -0.764  1.00 37.44           N  
ATOM    947  CE2 TRP A 146      36.940 102.713   0.336  1.00 37.22           C  
ATOM    948  CE3 TRP A 146      34.872 103.227   1.485  1.00 36.09           C  
ATOM    949  CZ2 TRP A 146      37.688 103.459   1.257  1.00 38.37           C  
ATOM    950  CZ3 TRP A 146      35.602 103.954   2.390  1.00 38.73           C  
ATOM    951  CH2 TRP A 146      37.003 104.087   2.257  1.00 39.71           C  
ATOM    952  N   MET A 147      32.917 100.380   1.945  1.00 35.38           N  
ATOM    953  CA  MET A 147      33.238 100.344   3.370  1.00 35.97           C  
ATOM    954  C   MET A 147      33.318  98.917   3.897  1.00 37.13           C  
ATOM    955  O   MET A 147      34.193  98.569   4.694  1.00 36.70           O  
ATOM    956  CB  MET A 147      32.196 101.133   4.188  1.00 36.55           C  
ATOM    957  CG  MET A 147      32.434 102.635   4.207  1.00 35.92           C  
ATOM    958  SD  MET A 147      31.372 103.530   5.362  1.00 38.48           S  
ATOM    959  CE  MET A 147      29.750 102.814   5.011  1.00 36.13           C  
ATOM    960  N   LYS A 148      32.417  98.051   3.459  1.00 34.74           N  
ATOM    961  CA  LYS A 148      32.392  96.718   4.052  1.00 37.46           C  
ATOM    962  C   LYS A 148      33.482  95.768   3.540  1.00 39.16           C  
ATOM    963  O   LYS A 148      33.641  94.680   4.090  1.00 44.88           O  
ATOM    964  CB  LYS A 148      30.986  96.088   3.942  1.00 38.48           C  
ATOM    965  CG  LYS A 148      30.563  95.736   2.594  1.00 45.86           C  
ATOM    966  CD  LYS A 148      29.301  94.868   2.634  1.00 49.82           C  
ATOM    967  CE  LYS A 148      28.064  95.655   3.062  1.00 50.17           C  
ATOM    968  NZ  LYS A 148      27.295  96.131   1.909  1.00 51.15           N  
ATOM    969  N   ILE A 149      34.217  96.161   2.498  1.00 35.78           N  
ATOM    970  CA  ILE A 149      35.379  95.368   2.055  1.00 37.48           C  
ATOM    971  C   ILE A 149      36.738  95.974   2.474  1.00 40.99           C  
ATOM    972  O   ILE A 149      37.799  95.490   2.073  1.00 36.00           O  
ATOM    973  CB  ILE A 149      35.349  95.101   0.546  1.00 37.61           C  
ATOM    974  CG1 ILE A 149      35.481  96.377  -0.276  1.00 42.59           C  
ATOM    975  CG2 ILE A 149      34.056  94.346   0.177  1.00 40.83           C  
ATOM    976  CD1 ILE A 149      35.674  96.094  -1.765  1.00 43.89           C  
ATOM    977  N   GLN A 150      36.710  97.041   3.258  1.00 40.83           N  
ATOM    978  CA  GLN A 150      37.948  97.610   3.778  1.00 36.37           C  
ATOM    979  C   GLN A 150      38.518  96.692   4.852  1.00 39.89           C  
ATOM    980  O   GLN A 150      37.757  96.030   5.534  1.00 39.78           O  
ATOM    981  CB  GLN A 150      37.693  98.998   4.343  1.00 36.32           C  
ATOM    982  CG  GLN A 150      37.206  99.962   3.302  1.00 37.34           C  
ATOM    983  CD  GLN A 150      38.109  99.955   2.093  1.00 46.64           C  
ATOM    984  OE1 GLN A 150      39.268 100.360   2.184  1.00 40.49           O  
ATOM    985  NE2 GLN A 150      37.604  99.461   0.969  1.00 39.21           N  
ATOM    986  N   PRO A 151      39.861  96.645   5.002  1.00 40.04           N  
ATOM    987  CA  PRO A 151      40.432  95.758   6.022  1.00 41.53           C  
ATOM    988  C   PRO A 151      39.780  95.914   7.406  1.00 40.95           C  
ATOM    989  O   PRO A 151      39.451  94.908   8.040  1.00 43.39           O  
ATOM    990  CB  PRO A 151      41.915  96.147   6.041  1.00 45.41           C  
ATOM    991  CG  PRO A 151      42.174  96.644   4.660  1.00 47.21           C  
ATOM    992  CD  PRO A 151      40.909  97.353   4.243  1.00 44.80           C  
ATOM    993  N   LYS A 152      39.542  97.155   7.841  1.00 39.44           N  
ATOM    994  CA  LYS A 152      38.943  97.398   9.171  1.00 41.64           C  
ATOM    995  C   LYS A 152      37.416  97.552   9.156  1.00 41.13           C  
ATOM    996  O   LYS A 152      36.811  97.896  10.178  1.00 46.19           O  
ATOM    997  CB  LYS A 152      39.607  98.618   9.821  1.00 45.03           C  
ATOM    998  CG  LYS A 152      41.128  98.486  10.006  1.00 48.89           C  
ATOM    999  CD  LYS A 152      41.493  97.302  10.914  1.00 60.94           C  
ATOM   1000  CE  LYS A 152      43.007  97.107  11.031  1.00 68.76           C  
ATOM   1001  NZ  LYS A 152      43.664  98.202  11.803  1.00 75.37           N  
ATOM   1002  N   GLY A 153      36.798  97.286   8.002  1.00 39.14           N  
ATOM   1003  CA  GLY A 153      35.348  97.352   7.832  1.00 38.93           C  
ATOM   1004  C   GLY A 153      34.721  95.982   7.671  1.00 38.73           C  
ATOM   1005  O   GLY A 153      33.536  95.851   7.386  1.00 38.21           O  
ATOM   1006  N   LYS A 154      35.520  94.945   7.821  1.00 39.92           N  
ATOM   1007  CA  LYS A 154      35.018  93.598   7.587  1.00 48.98           C  
ATOM   1008  C   LYS A 154      34.155  93.179   8.764  1.00 44.41           C  
ATOM   1009  O   LYS A 154      34.362  93.643   9.883  1.00 43.26           O  
ATOM   1010  CB  LYS A 154      36.174  92.621   7.345  1.00 52.64           C  
ATOM   1011  CG  LYS A 154      36.804  92.818   5.952  1.00 64.24           C  
ATOM   1012  CD  LYS A 154      37.847  91.757   5.624  1.00 64.06           C  
ATOM   1013  CE  LYS A 154      38.635  92.117   4.371  1.00 75.56           C  
ATOM   1014  NZ  LYS A 154      37.746  92.366   3.201  1.00 74.60           N  
ATOM   1015  N   GLY A 155      33.166  92.335   8.489  1.00 48.44           N  
ATOM   1016  CA  GLY A 155      32.253  91.841   9.513  1.00 49.32           C  
ATOM   1017  C   GLY A 155      32.756  90.529  10.075  1.00 56.80           C  
ATOM   1018  O   GLY A 155      33.840  90.061   9.719  1.00 57.66           O  
ATOM   1019  N   ILE A 156      31.956  89.930  10.948  1.00 61.72           N  
ATOM   1020  CA  ILE A 156      32.359  88.725  11.673  1.00 63.01           C  
ATOM   1021  C   ILE A 156      32.183  87.504  10.798  1.00 66.62           C  
ATOM   1022  O   ILE A 156      33.146  86.792  10.518  1.00 75.39           O  
ATOM   1023  CB  ILE A 156      31.567  88.585  12.977  1.00 60.25           C  
ATOM   1024  CG1 ILE A 156      32.080  89.611  13.990  1.00 63.66           C  
ATOM   1025  CG2 ILE A 156      31.677  87.159  13.525  1.00 69.41           C  
ATOM   1026  CD1 ILE A 156      31.006  90.174  14.890  1.00 71.21           C  
ATOM   1027  N   LEU A 157      30.952  87.264  10.369  1.00 64.83           N  
ATOM   1028  CA  LEU A 157      30.674  86.196   9.425  1.00 69.20           C  
ATOM   1029  C   LEU A 157      30.282  86.909   8.144  1.00 69.70           C  
ATOM   1030  O   LEU A 157      29.143  87.364   7.995  1.00 75.10           O  
ATOM   1031  CB  LEU A 157      29.558  85.277   9.938  1.00 67.15           C  
ATOM   1032  N   GLY A 158      31.247  87.058   7.241  1.00 63.19           N  
ATOM   1033  CA  GLY A 158      31.042  87.873   6.051  1.00 55.73           C  
ATOM   1034  C   GLY A 158      30.909  89.347   6.406  1.00 46.41           C  
ATOM   1035  O   GLY A 158      30.997  89.748   7.568  1.00 48.66           O  
ATOM   1036  N   ASN A 159      30.653  90.159   5.396  1.00 36.73           N  
ATOM   1037  CA  ASN A 159      30.731  91.612   5.553  1.00 36.52           C  
ATOM   1038  C   ASN A 159      29.381  92.305   5.506  1.00 35.03           C  
ATOM   1039  O   ASN A 159      29.315  93.505   5.688  1.00 36.55           O  
ATOM   1040  CB  ASN A 159      31.616  92.139   4.452  1.00 39.22           C  
ATOM   1041  CG  ASN A 159      33.023  91.585   4.532  1.00 41.03           C  
ATOM   1042  OD1 ASN A 159      33.558  91.377   5.622  1.00 43.19           O  
ATOM   1043  ND2 ASN A 159      33.639  91.378   3.381  1.00 54.05           N  
ATOM   1044  N   ALA A 160      28.302  91.557   5.270  1.00 33.73           N  
ATOM   1045  CA  ALA A 160      26.981  92.196   5.123  1.00 33.79           C  
ATOM   1046  C   ALA A 160      26.665  93.039   6.355  1.00 33.15           C  
ATOM   1047  O   ALA A 160      27.059  92.702   7.481  1.00 36.42           O  
ATOM   1048  CB  ALA A 160      25.891  91.139   4.881  1.00 34.67           C  
ATOM   1049  N   ILE A 161      25.971  94.152   6.162  1.00 34.08           N  
ATOM   1050  CA  ILE A 161      25.462  94.907   7.306  1.00 33.07           C  
ATOM   1051  C   ILE A 161      24.401  94.019   7.955  1.00 33.59           C  
ATOM   1052  O   ILE A 161      23.529  93.493   7.267  1.00 32.99           O  
ATOM   1053  CB  ILE A 161      24.863  96.243   6.883  1.00 35.07           C  
ATOM   1054  CG1 ILE A 161      25.907  97.035   6.105  1.00 34.56           C  
ATOM   1055  CG2 ILE A 161      24.294  97.007   8.116  1.00 32.74           C  
ATOM   1056  CD1 ILE A 161      27.272  97.160   6.799  1.00 38.16           C  
ATOM   1057  N   LYS A 162      24.514  93.796   9.261  1.00 32.89           N  
ATOM   1058  CA  LYS A 162      23.649  92.804   9.926  1.00 37.58           C  
ATOM   1059  C   LYS A 162      22.286  93.328  10.395  1.00 34.49           C  
ATOM   1060  O   LYS A 162      21.324  92.567  10.447  1.00 35.24           O  
ATOM   1061  CB  LYS A 162      24.393  92.187  11.112  1.00 40.58           C  
ATOM   1062  CG  LYS A 162      25.618  91.366  10.720  1.00 46.77           C  
ATOM   1063  CD  LYS A 162      25.339  90.209   9.782  1.00 50.01           C  
ATOM   1064  CE  LYS A 162      24.763  89.011  10.538  1.00 56.09           C  
ATOM   1065  NZ  LYS A 162      24.420  87.835   9.659  1.00 58.95           N  
ATOM   1066  N   TRP A 163      22.220  94.592  10.791  1.00 34.10           N  
ATOM   1067  CA  TRP A 163      20.967  95.192  11.283  1.00 36.99           C  
ATOM   1068  C   TRP A 163      21.087  96.712  11.253  1.00 37.43           C  
ATOM   1069  O   TRP A 163      22.102  97.239  10.837  1.00 35.20           O  
ATOM   1070  CB  TRP A 163      20.623  94.673  12.693  1.00 42.48           C  
ATOM   1071  CG  TRP A 163      19.153  94.700  12.978  1.00 37.85           C  
ATOM   1072  CD1 TRP A 163      18.508  95.465  13.919  1.00 36.94           C  
ATOM   1073  CD2 TRP A 163      18.140  93.975  12.289  1.00 39.79           C  
ATOM   1074  NE1 TRP A 163      17.158  95.238  13.856  1.00 41.18           N  
ATOM   1075  CE2 TRP A 163      16.904  94.334  12.862  1.00 35.39           C  
ATOM   1076  CE3 TRP A 163      18.153  93.044  11.238  1.00 37.19           C  
ATOM   1077  CZ2 TRP A 163      15.691  93.813  12.403  1.00 36.22           C  
ATOM   1078  CZ3 TRP A 163      16.936  92.495  10.808  1.00 35.90           C  
ATOM   1079  CH2 TRP A 163      15.734  92.886  11.389  1.00 43.25           C  
ATOM   1080  N   ASN A 164      20.039  97.419  11.665  1.00 35.92           N  
ATOM   1081  CA  ASN A 164      20.100  98.864  11.822  1.00 33.81           C  
ATOM   1082  C   ASN A 164      21.242  99.279  12.751  1.00 35.71           C  
ATOM   1083  O   ASN A 164      21.593  98.581  13.701  1.00 34.51           O  
ATOM   1084  CB  ASN A 164      18.797  99.427  12.413  1.00 36.05           C  
ATOM   1085  CG  ASN A 164      17.554  98.949  11.687  1.00 40.67           C  
ATOM   1086  OD1 ASN A 164      17.428  99.110  10.471  1.00 37.36           O  
ATOM   1087  ND2 ASN A 164      16.635  98.366  12.428  1.00 36.48           N  
ATOM   1088  N   PHE A 165      21.785 100.453  12.492  1.00 34.92           N  
ATOM   1089  CA  PHE A 165      22.780 101.069  13.349  1.00 35.77           C  
ATOM   1090  C   PHE A 165      24.116 100.329  13.453  1.00 38.66           C  
ATOM   1091  O   PHE A 165      24.712 100.197  14.523  1.00 38.76           O  
ATOM   1092  CB  PHE A 165      22.176 101.375  14.736  1.00 40.20           C  
ATOM   1093  CG  PHE A 165      20.947 102.266  14.677  1.00 37.41           C  
ATOM   1094  CD1 PHE A 165      21.102 103.634  14.440  1.00 35.40           C  
ATOM   1095  CD2 PHE A 165      19.684 101.778  14.872  1.00 44.80           C  
ATOM   1096  CE1 PHE A 165      19.974 104.469  14.396  1.00 34.90           C  
ATOM   1097  CE2 PHE A 165      18.575 102.619  14.812  1.00 35.09           C  
ATOM   1098  CZ  PHE A 165      18.736 103.957  14.578  1.00 39.76           C  
ATOM   1099  N   THR A 166      24.603  99.861  12.318  1.00 36.42           N  
ATOM   1100  CA  THR A 166      26.008  99.514  12.209  1.00 33.23           C  
ATOM   1101  C   THR A 166      26.748 100.854  12.031  1.00 35.32           C  
ATOM   1102  O   THR A 166      26.233 101.800  11.421  1.00 38.97           O  
ATOM   1103  CB  THR A 166      26.228  98.538  11.038  1.00 34.63           C  
ATOM   1104  OG1 THR A 166      25.486  97.327  11.296  1.00 35.19           O  
ATOM   1105  CG2 THR A 166      27.706  98.214  10.840  1.00 36.51           C  
ATOM   1106  N   LYS A 167      27.943 100.944  12.597  1.00 33.64           N  
ATOM   1107  CA  LYS A 167      28.721 102.208  12.630  1.00 33.80           C  
ATOM   1108  C   LYS A 167      30.118 101.936  12.068  1.00 38.51           C  
ATOM   1109  O   LYS A 167      30.736 100.953  12.426  1.00 40.34           O  
ATOM   1110  CB  LYS A 167      28.769 102.786  14.060  1.00 36.03           C  
ATOM   1111  CG  LYS A 167      27.363 103.325  14.546  1.00 45.03           C  
ATOM   1112  CD  LYS A 167      26.871 102.982  15.957  1.00 55.76           C  
ATOM   1113  CE  LYS A 167      26.682 101.563  16.203  1.00 48.38           C  
ATOM   1114  NZ  LYS A 167      25.384 101.157  16.958  1.00 41.78           N  
ATOM   1115  N   PHE A 168      30.569 102.775  11.137  1.00 37.18           N  
ATOM   1116  CA  PHE A 168      31.954 102.771  10.689  1.00 35.30           C  
ATOM   1117  C   PHE A 168      32.612 104.077  11.153  1.00 35.82           C  
ATOM   1118  O   PHE A 168      32.045 105.153  10.976  1.00 37.36           O  
ATOM   1119  CB  PHE A 168      32.015 102.725   9.163  1.00 36.75           C  
ATOM   1120  CG  PHE A 168      31.552 101.434   8.584  1.00 37.38           C  
ATOM   1121  CD1 PHE A 168      32.456 100.421   8.314  1.00 36.74           C  
ATOM   1122  CD2 PHE A 168      30.205 101.211   8.341  1.00 38.92           C  
ATOM   1123  CE1 PHE A 168      32.015  99.210   7.787  1.00 35.62           C  
ATOM   1124  CE2 PHE A 168      29.770  99.987   7.795  1.00 35.97           C  
ATOM   1125  CZ  PHE A 168      30.686  99.015   7.507  1.00 36.20           C  
ATOM   1126  N   LEU A 169      33.806 103.953  11.717  1.00 34.81           N  
ATOM   1127  CA  LEU A 169      34.648 105.078  12.071  1.00 32.83           C  
ATOM   1128  C   LEU A 169      35.622 105.304  10.935  1.00 33.76           C  
ATOM   1129  O   LEU A 169      36.306 104.381  10.487  1.00 35.74           O  
ATOM   1130  CB  LEU A 169      35.381 104.794  13.383  1.00 32.58           C  
ATOM   1131  CG  LEU A 169      36.231 105.925  13.994  1.00 36.79           C  
ATOM   1132  CD1 LEU A 169      35.373 107.143  14.235  1.00 36.07           C  
ATOM   1133  CD2 LEU A 169      36.864 105.432  15.314  1.00 36.63           C  
ATOM   1134  N   ILE A 170      35.654 106.550  10.481  1.00 33.90           N  
ATOM   1135  CA  ILE A 170      36.426 107.023   9.352  1.00 34.23           C  
ATOM   1136  C   ILE A 170      37.370 108.119   9.845  1.00 35.76           C  
ATOM   1137  O   ILE A 170      36.951 109.045  10.534  1.00 38.01           O  
ATOM   1138  CB  ILE A 170      35.507 107.675   8.308  1.00 35.92           C  
ATOM   1139  CG1 ILE A 170      34.322 106.786   7.947  1.00 38.49           C  
ATOM   1140  CG2 ILE A 170      36.257 108.050   7.043  1.00 35.02           C  
ATOM   1141  CD1 ILE A 170      34.690 105.521   7.238  1.00 37.49           C  
ATOM   1142  N   ASP A 171      38.640 108.012   9.471  1.00 34.80           N  
ATOM   1143  CA  ASP A 171      39.661 108.946   9.916  1.00 37.95           C  
ATOM   1144  C   ASP A 171      39.697 110.182   9.035  1.00 33.41           C  
ATOM   1145  O   ASP A 171      38.915 110.312   8.098  1.00 33.09           O  
ATOM   1146  CB  ASP A 171      41.033 108.249  10.019  1.00 38.00           C  
ATOM   1147  CG  ASP A 171      41.684 107.950   8.675  1.00 43.07           C  
ATOM   1148  OD1 ASP A 171      41.249 108.456   7.615  1.00 39.82           O  
ATOM   1149  OD2 ASP A 171      42.704 107.228   8.706  1.00 44.72           O  
ATOM   1150  N   LYS A 172      40.599 111.117   9.345  1.00 34.42           N  
ATOM   1151  CA  LYS A 172      40.615 112.382   8.631  1.00 34.05           C  
ATOM   1152  C   LYS A 172      40.987 112.260   7.148  1.00 36.82           C  
ATOM   1153  O   LYS A 172      40.711 113.163   6.370  1.00 38.40           O  
ATOM   1154  CB  LYS A 172      41.552 113.389   9.345  1.00 32.32           C  
ATOM   1155  CG  LYS A 172      40.998 113.793  10.722  1.00 35.94           C  
ATOM   1156  CD  LYS A 172      41.802 114.891  11.454  1.00 42.16           C  
ATOM   1157  CE  LYS A 172      43.184 114.464  11.886  1.00 55.26           C  
ATOM   1158  NZ  LYS A 172      43.890 115.566  12.673  1.00 44.83           N  
ATOM   1159  N   ASN A 173      41.645 111.166   6.774  1.00 35.56           N  
ATOM   1160  CA  ASN A 173      41.958 110.879   5.375  1.00 35.86           C  
ATOM   1161  C   ASN A 173      40.886 110.069   4.650  1.00 37.73           C  
ATOM   1162  O   ASN A 173      41.045 109.734   3.477  1.00 39.15           O  
ATOM   1163  CB  ASN A 173      43.282 110.143   5.299  1.00 37.26           C  
ATOM   1164  CG  ASN A 173      44.398 110.935   5.872  1.00 50.55           C  
ATOM   1165  OD1 ASN A 173      44.543 112.108   5.568  1.00 48.04           O  
ATOM   1166  ND2 ASN A 173      45.200 110.308   6.712  1.00 51.94           N  
ATOM   1167  N   GLY A 174      39.782 109.795   5.340  1.00 34.02           N  
ATOM   1168  CA  GLY A 174      38.638 109.069   4.777  1.00 35.41           C  
ATOM   1169  C   GLY A 174      38.766 107.563   4.755  1.00 39.11           C  
ATOM   1170  O   GLY A 174      37.981 106.901   4.091  1.00 37.76           O  
ATOM   1171  N   CYS A 175      39.737 107.016   5.487  1.00 36.49           N  
ATOM   1172  CA  CYS A 175      39.893 105.570   5.573  1.00 37.18           C  
ATOM   1173  C   CYS A 175      39.037 104.980   6.669  1.00 35.87           C  
ATOM   1174  O   CYS A 175      38.861 105.581   7.734  1.00 35.19           O  
ATOM   1175  CB  CYS A 175      41.342 105.197   5.836  1.00 39.74           C  
ATOM   1176  SG  CYS A 175      42.486 105.999   4.701  1.00 49.38           S  
ATOM   1177  N   VAL A 176      38.539 103.769   6.437  1.00 33.68           N  
ATOM   1178  CA  VAL A 176      37.811 103.050   7.477  1.00 33.06           C  
ATOM   1179  C   VAL A 176      38.814 102.556   8.513  1.00 34.34           C  
ATOM   1180  O   VAL A 176      39.789 101.879   8.184  1.00 36.53           O  
ATOM   1181  CB  VAL A 176      36.978 101.866   6.917  1.00 35.43           C  
ATOM   1182  CG1 VAL A 176      36.393 101.089   8.044  1.00 34.21           C  
ATOM   1183  CG2 VAL A 176      35.868 102.391   5.978  1.00 36.40           C  
ATOM   1184  N   VAL A 177      38.602 102.939   9.765  1.00 34.68           N  
ATOM   1185  CA  VAL A 177      39.506 102.525  10.842  1.00 36.39           C  
ATOM   1186  C   VAL A 177      38.850 101.563  11.853  1.00 37.48           C  
ATOM   1187  O   VAL A 177      39.551 100.843  12.554  1.00 32.16           O  
ATOM   1188  CB  VAL A 177      40.165 103.742  11.552  1.00 38.60           C  
ATOM   1189  CG1 VAL A 177      41.119 104.423  10.603  1.00 39.28           C  
ATOM   1190  CG2 VAL A 177      39.115 104.730  12.095  1.00 37.38           C  
ATOM   1191  N   LYS A 178      37.523 101.527  11.937  1.00 35.20           N  
ATOM   1192  CA  LYS A 178      36.862 100.529  12.804  1.00 37.03           C  
ATOM   1193  C   LYS A 178      35.418 100.349  12.406  1.00 35.29           C  
ATOM   1194  O   LYS A 178      34.829 101.240  11.824  1.00 34.65           O  
ATOM   1195  CB  LYS A 178      36.953 100.968  14.276  1.00 41.04           C  
ATOM   1196  CG  LYS A 178      36.662  99.827  15.257  1.00 38.20           C  
ATOM   1197  CD  LYS A 178      37.336 100.053  16.594  1.00 46.63           C  
ATOM   1198  CE  LYS A 178      36.965  99.016  17.647  1.00 46.89           C  
ATOM   1199  NZ  LYS A 178      37.518  99.464  19.005  1.00 42.96           N  
ATOM   1200  N   ARG A 179      34.858  99.158  12.663  1.00 36.49           N  
ATOM   1201  CA  ARG A 179      33.466  98.918  12.458  1.00 36.11           C  
ATOM   1202  C   ARG A 179      32.849  98.449  13.781  1.00 41.66           C  
ATOM   1203  O   ARG A 179      33.442  97.620  14.492  1.00 35.80           O  
ATOM   1204  CB  ARG A 179      33.276  97.838  11.386  1.00 36.37           C  
ATOM   1205  CG  ARG A 179      31.836  97.390  11.163  1.00 39.19           C  
ATOM   1206  CD  ARG A 179      31.797  96.341  10.046  1.00 39.48           C  
ATOM   1207  NE  ARG A 179      30.485  95.702   9.932  1.00 36.50           N  
ATOM   1208  CZ  ARG A 179      30.065  95.043   8.859  1.00 37.94           C  
ATOM   1209  NH1 ARG A 179      30.845  94.931   7.790  1.00 36.47           N  
ATOM   1210  NH2 ARG A 179      28.854  94.478   8.864  1.00 36.56           N  
ATOM   1211  N   TYR A 180      31.671  98.995  14.106  1.00 36.30           N  
ATOM   1212  CA  TYR A 180      30.942  98.630  15.323  1.00 37.47           C  
ATOM   1213  C   TYR A 180      29.589  98.078  14.911  1.00 40.35           C  
ATOM   1214  O   TYR A 180      28.866  98.705  14.151  1.00 42.14           O  
ATOM   1215  CB  TYR A 180      30.726  99.839  16.230  1.00 36.63           C  
ATOM   1216  CG  TYR A 180      31.982 100.610  16.573  1.00 33.93           C  
ATOM   1217  CD1 TYR A 180      32.650 100.392  17.776  1.00 39.32           C  
ATOM   1218  CD2 TYR A 180      32.504 101.567  15.699  1.00 39.00           C  
ATOM   1219  CE1 TYR A 180      33.805 101.097  18.087  1.00 36.54           C  
ATOM   1220  CE2 TYR A 180      33.644 102.266  16.004  1.00 39.48           C  
ATOM   1221  CZ  TYR A 180      34.301 102.027  17.195  1.00 43.21           C  
ATOM   1222  OH  TYR A 180      35.448 102.758  17.507  1.00 39.38           O  
ATOM   1223  N   GLY A 181      29.234  96.918  15.429  1.00 38.22           N  
ATOM   1224  CA  GLY A 181      27.964  96.295  15.065  1.00 38.97           C  
ATOM   1225  C   GLY A 181      26.757  96.879  15.798  1.00 39.36           C  
ATOM   1226  O   GLY A 181      26.903  97.725  16.677  1.00 39.18           O  
ATOM   1227  N   PRO A 182      25.550  96.389  15.472  1.00 36.99           N  
ATOM   1228  CA  PRO A 182      24.294  96.840  16.098  1.00 42.83           C  
ATOM   1229  C   PRO A 182      24.242  96.595  17.622  1.00 42.06           C  
ATOM   1230  O   PRO A 182      23.460  97.216  18.337  1.00 44.30           O  
ATOM   1231  CB  PRO A 182      23.224  95.969  15.419  1.00 43.74           C  
ATOM   1232  CG  PRO A 182      23.873  95.339  14.252  1.00 49.80           C  
ATOM   1233  CD  PRO A 182      25.334  95.307  14.489  1.00 40.42           C  
ATOM   1234  N   MET A 183      25.086  95.711  18.128  1.00 41.66           N  
ATOM   1235  CA  MET A 183      25.146  95.394  19.558  0.50 44.86           C  
ATOM   1237  C   MET A 183      25.967  96.426  20.331  1.00 47.05           C  
ATOM   1238  O   MET A 183      26.010  96.409  21.552  1.00 49.04           O  
ATOM   1239  CB  MET A 183      25.744  93.998  19.771  0.50 47.93           C  
ATOM   1241  CG  MET A 183      27.262  93.867  19.544  0.50 43.11           C  
ATOM   1243  SD  MET A 183      27.871  94.061  17.850  0.50 51.98           S  
ATOM   1245  CE  MET A 183      26.677  93.155  16.862  0.50 40.03           C  
ATOM   1247  N   GLU A 184      26.653  97.295  19.612  1.00 42.22           N  
ATOM   1248  CA  GLU A 184      27.478  98.309  20.242  1.00 44.34           C  
ATOM   1249  C   GLU A 184      26.788  99.668  20.202  1.00 41.83           C  
ATOM   1250  O   GLU A 184      26.628 100.262  19.142  1.00 45.31           O  
ATOM   1251  CB  GLU A 184      28.851  98.341  19.560  1.00 40.29           C  
ATOM   1252  CG  GLU A 184      29.684  97.086  19.891  1.00 56.21           C  
ATOM   1253  CD  GLU A 184      30.844  96.857  18.936  1.00 68.09           C  
ATOM   1254  OE1 GLU A 184      30.630  96.241  17.860  1.00 71.38           O  
ATOM   1255  OE2 GLU A 184      31.977  97.267  19.282  1.00 79.19           O  
ATOM   1256  N   GLU A 185      26.404 100.184  21.372  1.00 38.97           N  
ATOM   1257  CA  GLU A 185      25.807 101.517  21.432  1.00 41.86           C  
ATOM   1258  C   GLU A 185      26.861 102.589  21.073  1.00 39.77           C  
ATOM   1259  O   GLU A 185      28.053 102.401  21.312  1.00 44.61           O  
ATOM   1260  CB  GLU A 185      25.221 101.801  22.811  1.00 46.19           C  
ATOM   1261  CG  GLU A 185      26.252 102.015  23.917  1.00 54.54           C  
ATOM   1262  CD  GLU A 185      25.638 102.110  25.325  1.00 60.87           C  
ATOM   1263  OE1 GLU A 185      24.442 101.737  25.511  1.00 55.86           O  
ATOM   1264  OE2 GLU A 185      26.375 102.564  26.237  1.00 62.10           O  
ATOM   1265  N   PRO A 186      26.422 103.709  20.484  1.00 38.36           N  
ATOM   1266  CA  PRO A 186      27.375 104.726  20.026  1.00 38.55           C  
ATOM   1267  C   PRO A 186      28.393 105.225  21.067  1.00 40.44           C  
ATOM   1268  O   PRO A 186      29.516 105.544  20.698  1.00 42.14           O  
ATOM   1269  CB  PRO A 186      26.465 105.861  19.549  1.00 39.62           C  
ATOM   1270  CG  PRO A 186      25.214 105.212  19.159  1.00 38.85           C  
ATOM   1271  CD  PRO A 186      25.035 104.084  20.144  1.00 36.20           C  
ATOM   1272  N   LEU A 187      28.044 105.268  22.350  1.00 39.53           N  
ATOM   1273  CA  LEU A 187      29.008 105.731  23.358  1.00 41.97           C  
ATOM   1274  C   LEU A 187      30.241 104.826  23.477  1.00 42.35           C  
ATOM   1275  O   LEU A 187      31.292 105.271  23.945  1.00 41.03           O  
ATOM   1276  CB  LEU A 187      28.348 105.906  24.728  1.00 46.41           C  
ATOM   1277  CG  LEU A 187      27.370 107.087  24.859  1.00 45.31           C  
ATOM   1278  CD1 LEU A 187      26.772 107.086  26.276  1.00 51.58           C  
ATOM   1279  CD2 LEU A 187      27.991 108.453  24.520  1.00 47.62           C  
ATOM   1280  N   VAL A 188      30.117 103.572  23.049  1.00 40.46           N  
ATOM   1281  CA  VAL A 188      31.264 102.659  22.933  1.00 43.06           C  
ATOM   1282  C   VAL A 188      32.396 103.214  22.044  1.00 40.67           C  
ATOM   1283  O   VAL A 188      33.563 102.860  22.206  1.00 36.89           O  
ATOM   1284  CB  VAL A 188      30.806 101.291  22.389  1.00 46.90           C  
ATOM   1285  CG1 VAL A 188      31.988 100.459  21.935  1.00 56.41           C  
ATOM   1286  CG2 VAL A 188      29.991 100.568  23.455  1.00 47.28           C  
ATOM   1287  N   ILE A 189      32.026 104.057  21.093  1.00 36.81           N  
ATOM   1288  CA  ILE A 189      32.961 104.609  20.120  1.00 37.06           C  
ATOM   1289  C   ILE A 189      33.810 105.674  20.783  1.00 38.43           C  
ATOM   1290  O   ILE A 189      34.956 105.973  20.356  1.00 39.43           O  
ATOM   1291  CB  ILE A 189      32.181 105.206  18.919  1.00 36.70           C  
ATOM   1292  CG1 ILE A 189      31.246 104.127  18.318  1.00 37.20           C  
ATOM   1293  CG2 ILE A 189      33.145 105.754  17.862  1.00 38.22           C  
ATOM   1294  CD1 ILE A 189      30.411 104.589  17.112  1.00 40.18           C  
ATOM   1295  N   GLU A 190      33.258 106.274  21.837  1.00 40.13           N  
ATOM   1296  CA  GLU A 190      33.862 107.463  22.410  1.00 39.84           C  
ATOM   1297  C   GLU A 190      35.336 107.286  22.766  1.00 39.08           C  
ATOM   1298  O   GLU A 190      36.142 108.196  22.536  1.00 38.49           O  
ATOM   1299  CB  GLU A 190      33.065 107.933  23.631  1.00 42.94           C  
ATOM   1300  CG  GLU A 190      33.665 109.135  24.250  1.00 43.46           C  
ATOM   1301  CD  GLU A 190      32.766 109.884  25.220  1.00 52.32           C  
ATOM   1302  OE1 GLU A 190      31.651 109.430  25.488  1.00 45.84           O  
ATOM   1303  OE2 GLU A 190      33.198 110.959  25.697  1.00 45.91           O  
ATOM   1304  N   LYS A 191      35.687 106.138  23.342  1.00 36.21           N  
ATOM   1305  CA  LYS A 191      37.053 105.872  23.799  1.00 40.76           C  
ATOM   1306  C   LYS A 191      38.072 105.788  22.664  1.00 38.20           C  
ATOM   1307  O   LYS A 191      39.259 105.992  22.892  1.00 37.50           O  
ATOM   1308  CB  LYS A 191      37.111 104.599  24.648  1.00 43.29           C  
ATOM   1309  CG  LYS A 191      36.851 103.297  23.917  1.00 44.87           C  
ATOM   1310  CD  LYS A 191      36.982 102.100  24.847  1.00 49.33           C  
ATOM   1311  CE  LYS A 191      35.722 101.874  25.683  1.00 54.29           C  
ATOM   1312  NZ  LYS A 191      34.539 101.482  24.863  1.00 44.90           N  
ATOM   1313  N   ASP A 192      37.601 105.535  21.449  1.00 38.35           N  
ATOM   1314  CA  ASP A 192      38.461 105.377  20.279  1.00 38.74           C  
ATOM   1315  C   ASP A 192      38.731 106.706  19.537  1.00 40.77           C  
ATOM   1316  O   ASP A 192      39.680 106.812  18.766  1.00 40.42           O  
ATOM   1317  CB  ASP A 192      37.820 104.393  19.298  1.00 38.46           C  
ATOM   1318  CG  ASP A 192      37.734 102.969  19.854  1.00 46.91           C  
ATOM   1319  OD1 ASP A 192      38.574 102.596  20.701  1.00 43.14           O  
ATOM   1320  OD2 ASP A 192      36.832 102.221  19.434  1.00 48.03           O  
ATOM   1321  N   LEU A 193      37.889 107.704  19.764  1.00 40.35           N  
ATOM   1322  CA  LEU A 193      37.985 108.976  19.025  1.00 36.46           C  
ATOM   1323  C   LEU A 193      39.280 109.743  19.240  1.00 36.09           C  
ATOM   1324  O   LEU A 193      39.812 110.276  18.272  1.00 38.19           O  
ATOM   1325  CB  LEU A 193      36.794 109.898  19.351  1.00 35.41           C  
ATOM   1326  CG  LEU A 193      35.412 109.342  18.988  1.00 40.72           C  
ATOM   1327  CD1 LEU A 193      34.303 110.277  19.482  1.00 42.59           C  
ATOM   1328  CD2 LEU A 193      35.324 109.105  17.485  1.00 41.64           C  
ATOM   1329  N   PRO A 194      39.758 109.867  20.493  1.00 35.71           N  
ATOM   1330  CA  PRO A 194      40.965 110.687  20.678  1.00 36.81           C  
ATOM   1331  C   PRO A 194      42.144 110.277  19.804  1.00 38.35           C  
ATOM   1332  O   PRO A 194      42.938 111.124  19.418  1.00 34.42           O  
ATOM   1333  CB  PRO A 194      41.277 110.512  22.168  1.00 37.52           C  
ATOM   1334  CG  PRO A 194      39.945 110.323  22.769  1.00 38.26           C  
ATOM   1335  CD  PRO A 194      39.235 109.412  21.792  1.00 40.17           C  
ATOM   1336  N   HIS A 195      42.243 108.999  19.448  1.00 35.38           N  
ATOM   1337  CA  HIS A 195      43.366 108.563  18.622  1.00 41.73           C  
ATOM   1338  C   HIS A 195      43.313 109.165  17.217  1.00 42.10           C  
ATOM   1339  O   HIS A 195      44.355 109.394  16.609  1.00 38.40           O  
ATOM   1340  CB  HIS A 195      43.447 107.037  18.521  1.00 43.60           C  
ATOM   1341  CG  HIS A 195      44.684 106.555  17.824  1.00 59.47           C  
ATOM   1342  ND1 HIS A 195      44.650 105.860  16.634  1.00 56.81           N  
ATOM   1343  CD2 HIS A 195      45.995 106.705  18.135  1.00 58.05           C  
ATOM   1344  CE1 HIS A 195      45.885 105.585  16.250  1.00 57.89           C  
ATOM   1345  NE2 HIS A 195      46.719 106.088  17.143  1.00 63.44           N  
ATOM   1346  N   TYR A 196      42.112 109.460  16.734  1.00 36.09           N  
ATOM   1347  CA  TYR A 196      41.932 109.946  15.360  1.00 38.77           C  
ATOM   1348  C   TYR A 196      41.755 111.461  15.202  1.00 43.39           C  
ATOM   1349  O   TYR A 196      41.880 111.980  14.095  1.00 42.38           O  
ATOM   1350  CB  TYR A 196      40.792 109.177  14.679  1.00 38.98           C  
ATOM   1351  CG  TYR A 196      41.113 107.706  14.661  1.00 42.21           C  
ATOM   1352  CD1 TYR A 196      42.078 107.201  13.788  1.00 35.00           C  
ATOM   1353  CD2 TYR A 196      40.537 106.853  15.575  1.00 38.41           C  
ATOM   1354  CE1 TYR A 196      42.413 105.851  13.805  1.00 40.81           C  
ATOM   1355  CE2 TYR A 196      40.866 105.491  15.601  1.00 45.69           C  
ATOM   1356  CZ  TYR A 196      41.818 105.012  14.706  1.00 41.97           C  
ATOM   1357  OH  TYR A 196      42.164 103.683  14.698  1.00 50.01           O  
ATOM   1358  N   PHE A 197      41.487 112.179  16.287  1.00 41.07           N  
ATOM   1359  CA  PHE A 197      41.290 113.620  16.182  1.00 43.57           C  
ATOM   1360  C   PHE A 197      42.544 114.322  15.609  1.00 54.42           C  
ATOM   1361  O   PHE A 197      42.500 115.435  15.030  1.00 57.28           O  
ATOM   1362  CB  PHE A 197      40.860 114.210  17.534  1.00 41.53           C  
ATOM   1363  CG  PHE A 197      39.409 113.942  17.895  1.00 37.80           C  
ATOM   1364  CD1 PHE A 197      38.419 113.888  16.923  1.00 40.99           C  
ATOM   1365  CD2 PHE A 197      39.024 113.828  19.217  1.00 37.96           C  
ATOM   1366  CE1 PHE A 197      37.100 113.686  17.265  1.00 41.03           C  
ATOM   1367  CE2 PHE A 197      37.698 113.616  19.561  1.00 41.93           C  
ATOM   1368  CZ  PHE A 197      36.739 113.541  18.585  1.00 40.68           C  
ATOM   1369  OXT PHE A 197      43.646 113.758  15.667  1.00 61.51           O  
TER    1370      PHE A 197                                                      
END
MOLECULE T0388.pdb
ATOM      1  N   GLU     1      45.443  90.137 -10.548  1.00 51.54           N   
ATOM      2  CA  GLU     1      45.061  91.567 -10.758  1.00 51.41           C   
ATOM      4  CB  GLU     1      45.087  92.333  -9.422  1.00 51.28           C   
ATOM     11  C   GLU     1      45.993  92.249 -11.762  1.00 48.45           C   
ATOM     12  O   GLU     1      46.840  91.604 -12.393  1.00 50.33           O   
ATOM     16  N   ASN     2      45.801  93.552 -11.938  1.00 42.49           N   
ATOM     17  CA  ASN     2      46.827  94.396 -12.536  1.00 37.28           C   
ATOM     19  CB  ASN     2      46.341  95.072 -13.830  1.00 38.12           C   
ATOM     22  CG  ASN     2      47.489  95.718 -14.649  1.00 45.46           C   
ATOM     23  OD1 ASN     2      48.565  96.038 -14.123  1.00 47.75           O   
ATOM     24  ND2 ASN     2      47.245  95.911 -15.948  1.00 44.01           N   
ATOM     27  C   ASN     2      47.162  95.433 -11.481  1.00 26.47           C   
ATOM     28  O   ASN     2      46.259  96.035 -10.920  1.00 23.24           O   
ATOM     30  N   LEU     3      48.456  95.593 -11.201  1.00 20.53           N   
ATOM     31  CA  LEU     3      48.991  96.681 -10.379  1.00 20.35           C   
ATOM     33  CB  LEU     3      50.516  96.724 -10.551  1.00 22.47           C   
ATOM     36  CG  LEU     3      51.334  97.745  -9.775  1.00 20.02           C   
ATOM     38  CD1 LEU     3      51.125  97.595  -8.266  1.00 22.66           C   
ATOM     42  CD2 LEU     3      52.799  97.571 -10.168  1.00 15.24           C   
ATOM     46  C   LEU     3      48.371  98.024 -10.791  1.00 20.64           C   
ATOM     47  O   LEU     3      47.968  98.832  -9.953  1.00 19.61           O   
ATOM     49  N   TYR     4      48.246  98.237 -12.097  1.00 21.40           N   
ATOM     50  CA  TYR     4      47.686  99.485 -12.604  1.00 20.01           C   
ATOM     52  CB  TYR     4      47.663  99.486 -14.129  1.00 18.90           C   
ATOM     55  CG  TYR     4      47.540 100.853 -14.749  1.00 23.26           C   
ATOM     56  CD1 TYR     4      48.670 101.588 -15.084  1.00 20.41           C   
ATOM     58  CE1 TYR     4      48.566 102.846 -15.682  1.00 25.10           C   
ATOM     60  CZ  TYR     4      47.311 103.378 -15.940  1.00 23.97           C   
ATOM     61  OH  TYR     4      47.205 104.612 -16.520  1.00 24.79           O   
ATOM     63  CE2 TYR     4      46.173 102.672 -15.627  1.00 16.47           C   
ATOM     65  CD2 TYR     4      46.288 101.409 -15.024  1.00 26.40           C   
ATOM     67  C   TYR     4      46.298  99.769 -12.058  1.00 21.79           C   
ATOM     68  O   TYR     4      45.935 100.929 -11.881  1.00 18.77           O   
ATOM     70  N   PHE     5      45.523  98.721 -11.790  1.00 23.82           N   
ATOM     71  CA  PHE     5      44.136  98.899 -11.376  1.00 24.42           C   
ATOM     73  CB  PHE     5      43.234  98.066 -12.290  1.00 26.62           C   
ATOM     76  CG  PHE     5      43.181  98.580 -13.721  1.00 19.29           C   
ATOM     77  CD1 PHE     5      42.316  99.622 -14.070  1.00 25.22           C   
ATOM     79  CE1 PHE     5      42.257 100.100 -15.383  1.00 15.63           C   
ATOM     81  CZ  PHE     5      43.052  99.558 -16.341  1.00 15.65           C   
ATOM     83  CE2 PHE     5      43.922  98.503 -16.019  1.00 22.84           C   
ATOM     85  CD2 PHE     5      43.981  98.029 -14.699  1.00 16.27           C   
ATOM     87  C   PHE     5      43.876  98.579  -9.901  1.00 29.97           C   
ATOM     88  O   PHE     5      42.722  98.586  -9.462  1.00 30.09           O   
ATOM     90  N   GLN     6      44.931  98.327  -9.125  1.00 31.06           N   
ATOM     91  CA  GLN     6      44.766  98.089  -7.684  1.00 34.99           C   
ATOM     93  CB  GLN     6      45.994  97.390  -7.094  1.00 34.68           C   
ATOM     96  CG  GLN     6      46.199  95.970  -7.591  1.00 39.14           C   
ATOM     99  CD  GLN     6      47.409  95.297  -6.953  1.00 39.73           C   
ATOM    100  OE1 GLN     6      47.983  95.809  -5.986  1.00 41.58           O   
ATOM    101  NE2 GLN     6      47.802  94.146  -7.497  1.00 46.13           N   
ATOM    104  C   GLN     6      44.490  99.389  -6.929  1.00 32.04           C   
ATOM    105  O   GLN     6      45.023 100.437  -7.271  1.00 32.24           O   
ATOM    107  N   SER     7      43.638  99.320  -5.908  1.00 35.66           N   
ATOM    108  CA  SER     7      43.375 100.470  -5.018  1.00 37.58           C   
ATOM    110  CB  SER     7      44.628 100.781  -4.171  1.00 41.06           C   
ATOM    113  OG  SER     7      45.014  99.652  -3.402  1.00 43.18           O   
ATOM    115  C   SER     7      42.909 101.738  -5.744  1.00 37.12           C   
ATOM    116  O   SER     7      43.433 102.835  -5.516  1.00 39.26           O   
ATOM    118  N   MET     8      41.908 101.592  -6.603  1.00 32.96           N   
ATOM    119  CA  MET     8      41.400 102.726  -7.364  1.00 32.89           C   
ATOM    121  CB  MET     8      40.580 102.229  -8.551  1.00 31.58           C   
ATOM    124  CG  MET     8      41.438 101.599  -9.658  1.00 27.01           C   
ATOM    127  SD  MET     8      40.435 101.185 -11.079  1.00 31.62           S   
ATOM    128  CE  MET     8      39.668  99.662 -10.515  1.00 33.58           C   
ATOM    132  C   MET     8      40.566 103.683  -6.514  1.00 32.06           C   
ATOM    133  O   MET     8      40.592 104.884  -6.748  1.00 31.77           O   
ATOM    135  N   ILE     9      39.822 103.129  -5.556  1.00 33.27           N   
ATOM    136  CA  ILE     9      38.966 103.883  -4.636  1.00 33.17           C   
ATOM    138  CB  ILE     9      37.482 103.428  -4.691  1.00 37.36           C   
ATOM    140  CG1 ILE     9      36.982 103.258  -6.134  1.00 43.00           C   
ATOM    143  CD1 ILE     9      36.408 104.519  -6.730  1.00 39.67           C   
ATOM    147  CG2 ILE     9      36.603 104.427  -3.908  1.00 39.12           C   
ATOM    151  C   ILE     9      39.466 103.616  -3.223  1.00 31.81           C   
ATOM    152  O   ILE     9      39.372 102.490  -2.715  1.00 29.28           O   
ATOM    154  N   ASN    10      40.005 104.652  -2.596  1.00 27.61           N   
ATOM    155  CA  ASN    10      40.706 104.527  -1.337  1.00 33.21           C   
ATOM    157  CB  ASN    10      42.154 104.983  -1.532  1.00 38.12           C   
ATOM    160  CG  ASN    10      42.939 104.026  -2.377  1.00 44.61           C   
ATOM    161  OD1 ASN    10      43.051 102.855  -2.034  1.00 51.91           O   
ATOM    162  ND2 ASN    10      43.454 104.503  -3.509  1.00 40.92           N   
ATOM    165  C   ASN    10      40.100 105.324  -0.188  1.00 30.59           C   
ATOM    166  O   ASN    10      40.544 105.167   0.932  1.00 31.29           O   
ATOM    168  N   SER    11      39.124 106.182  -0.483  1.00 31.82           N   
ATOM    169  CA  SER    11      38.552 107.077   0.509  1.00 27.43           C   
ATOM    171  CB  SER    11      39.086 108.494   0.315  1.00 30.51           C   
ATOM    174  OG  SER    11      38.457 109.384   1.216  1.00 30.49           O   
ATOM    176  C   SER    11      37.037 107.121   0.417  1.00 27.29           C   
ATOM    177  O   SER    11      36.472 107.299  -0.657  1.00 25.84           O   
ATOM    179  N   PHE    12      36.394 106.998   1.574  1.00 27.56           N   
ATOM    180  CA  PHE    12      34.966 107.164   1.721  1.00 27.03           C   
ATOM    182  CB  PHE    12      34.588 106.920   3.192  1.00 27.70           C   
ATOM    185  CG  PHE    12      33.138 107.126   3.480  1.00 28.69           C   
ATOM    186  CD1 PHE    12      32.193 106.253   2.964  1.00 28.12           C   
ATOM    188  CE1 PHE    12      30.829 106.435   3.224  1.00 27.25           C   
ATOM    190  CZ  PHE    12      30.416 107.517   3.993  1.00 28.28           C   
ATOM    192  CE2 PHE    12      31.361 108.396   4.513  1.00 26.51           C   
ATOM    194  CD2 PHE    12      32.706 108.206   4.258  1.00 28.73           C   
ATOM    196  C   PHE    12      34.532 108.569   1.285  1.00 28.51           C   
ATOM    197  O   PHE    12      33.432 108.781   0.742  1.00 28.41           O   
ATOM    199  N   TYR    13      35.416 109.534   1.503  1.00 29.28           N   
ATOM    200  CA  TYR    13      35.113 110.922   1.196  1.00 30.10           C   
ATOM    202  CB  TYR    13      36.045 111.851   1.993  1.00 29.54           C   
ATOM    205  CG  TYR    13      35.977 111.695   3.497  1.00 27.12           C   
ATOM    206  CD1 TYR    13      34.757 111.534   4.152  1.00 28.98           C   
ATOM    208  CE1 TYR    13      34.692 111.389   5.534  1.00 28.57           C   
ATOM    210  CZ  TYR    13      35.854 111.436   6.273  1.00 26.71           C   
ATOM    211  OH  TYR    13      35.783 111.320   7.629  1.00 28.39           O   
ATOM    213  CE2 TYR    13      37.082 111.599   5.650  1.00 26.38           C   
ATOM    215  CD2 TYR    13      37.137 111.720   4.267  1.00 29.34           C   
ATOM    217  C   TYR    13      35.175 111.262  -0.306  1.00 31.24           C   
ATOM    218  O   TYR    13      34.811 112.372  -0.694  1.00 33.63           O   
ATOM    220  N   ALA    14      35.624 110.323  -1.138  1.00 29.52           N   
ATOM    221  CA  ALA    14      35.614 110.505  -2.592  1.00 31.39           C   
ATOM    223  CB  ALA    14      36.556 109.497  -3.262  1.00 31.60           C   
ATOM    227  C   ALA    14      34.218 110.423  -3.230  1.00 31.41           C   
ATOM    228  O   ALA    14      34.045 110.872  -4.370  1.00 30.15           O   
ATOM    230  N   PHE    15      33.234 109.874  -2.512  1.00 29.61           N   
ATOM    231  CA  PHE    15      31.910 109.580  -3.078  1.00 29.78           C   
ATOM    233  CB  PHE    15      31.274 108.396  -2.334  1.00 29.72           C   
ATOM    236  CG  PHE    15      31.970 107.086  -2.593  1.00 29.01           C   
ATOM    237  CD1 PHE    15      31.564 106.274  -3.636  1.00 31.73           C   
ATOM    239  CE1 PHE    15      32.214 105.093  -3.897  1.00 29.85           C   
ATOM    241  CZ  PHE    15      33.296 104.703  -3.127  1.00 32.39           C   
ATOM    243  CE2 PHE    15      33.716 105.502  -2.072  1.00 31.78           C   
ATOM    245  CD2 PHE    15      33.059 106.688  -1.820  1.00 30.15           C   
ATOM    247  C   PHE    15      30.937 110.756  -3.057  1.00 30.68           C   
ATOM    248  O   PHE    15      31.016 111.631  -2.174  1.00 29.58           O   
ATOM    250  N   GLU    16      30.032 110.760  -4.043  1.00 30.08           N   
ATOM    251  CA  GLU    16      28.838 111.601  -4.030  1.00 30.79           C   
ATOM    253  CB  GLU    16      28.476 112.102  -5.424  1.00 33.05           C   
ATOM    256  CG  GLU    16      29.355 113.230  -5.947  1.00 34.38           C   
ATOM    259  CD  GLU    16      28.980 113.689  -7.370  1.00 34.98           C   
ATOM    260  OE1 GLU    16      28.182 113.014  -8.052  1.00 40.23           O   
ATOM    261  OE2 GLU    16      29.488 114.739  -7.805  1.00 37.41           O   
ATOM    262  C   GLU    16      27.681 110.765  -3.503  1.00 32.79           C   
ATOM    263  O   GLU    16      27.595 109.572  -3.801  1.00 33.65           O   
ATOM    265  N   VAL    17      26.804 111.403  -2.717  1.00 32.58           N   
ATOM    266  CA  VAL    17      25.586 110.788  -2.194  1.00 31.53           C   
ATOM    268  CB  VAL    17      25.765 110.308  -0.721  1.00 30.61           C   
ATOM    270  CG1 VAL    17      26.842 109.197  -0.606  1.00 28.46           C   
ATOM    274  CG2 VAL    17      26.090 111.477   0.206  1.00 32.64           C   
ATOM    278  C   VAL    17      24.443 111.819  -2.290  1.00 31.97           C   
ATOM    279  O   VAL    17      24.695 113.003  -2.500  1.00 28.29           O   
ATOM    281  N   LYS    18      23.196 111.373  -2.155  1.00 31.42           N   
ATOM    282  CA  LYS    18      22.061 112.295  -2.143  1.00 33.73           C   
ATOM    284  CB  LYS    18      20.801 111.638  -2.714  1.00 34.15           C   
ATOM    287  CG  LYS    18      20.799 111.393  -4.219  1.00 41.34           C   
ATOM    290  CD  LYS    18      19.471 110.742  -4.634  1.00 43.28           C   
ATOM    293  CE  LYS    18      19.358 110.538  -6.143  1.00 52.14           C   
ATOM    296  NZ  LYS    18      20.315 109.512  -6.640  1.00 58.50           N   
ATOM    300  C   LYS    18      21.777 112.740  -0.710  1.00 31.50           C   
ATOM    301  O   LYS    18      21.782 111.939   0.211  1.00 30.92           O   
ATOM    303  N   ASP    19      21.487 114.019  -0.523  1.00 31.92           N   
ATOM    304  CA  ASP    19      21.008 114.483   0.776  1.00 32.25           C   
ATOM    306  CB  ASP    19      21.359 115.964   0.995  1.00 30.58           C   
ATOM    309  CG  ASP    19      20.502 116.926   0.192  1.00 35.92           C   
ATOM    310  OD1 ASP    19      19.466 116.538  -0.403  1.00 31.79           O   
ATOM    311  OD2 ASP    19      20.904 118.106   0.163  1.00 37.89           O   
ATOM    312  C   ASP    19      19.518 114.162   0.937  1.00 30.83           C   
ATOM    313  O   ASP    19      18.902 113.624   0.016  1.00 27.66           O   
ATOM    315  N   ALA    20      18.943 114.474   2.100  1.00 31.11           N   
ATOM    316  CA  ALA    20      17.545 114.100   2.376  1.00 32.68           C   
ATOM    318  CB  ALA    20      17.154 114.431   3.819  1.00 30.00           C   
ATOM    322  C   ALA    20      16.541 114.722   1.400  1.00 34.34           C   
ATOM    323  O   ALA    20      15.469 114.164   1.207  1.00 33.36           O   
ATOM    325  N   LYS    21      16.888 115.864   0.799  1.00 36.37           N   
ATOM    326  CA  LYS    21      16.028 116.537  -0.185  1.00 38.41           C   
ATOM    328  CB  LYS    21      16.269 118.054  -0.185  1.00 39.94           C   
ATOM    331  CG  LYS    21      16.363 118.712   1.188  1.00 44.33           C   
ATOM    334  CD  LYS    21      15.155 118.449   2.050  1.00 47.36           C   
ATOM    337  CE  LYS    21      15.253 119.228   3.354  1.00 51.12           C   
ATOM    340  NZ  LYS    21      15.286 120.703   3.089  1.00 56.98           N   
ATOM    344  C   LYS    21      16.244 116.051  -1.614  1.00 39.11           C   
ATOM    345  O   LYS    21      15.591 116.543  -2.527  1.00 37.07           O   
ATOM    347  N   GLY    22      17.177 115.123  -1.817  1.00 38.43           N   
ATOM    348  CA  GLY    22      17.433 114.578  -3.144  1.00 38.70           C   
ATOM    351  C   GLY    22      18.512 115.278  -3.952  1.00 39.00           C   
ATOM    352  O   GLY    22      18.711 114.941  -5.122  1.00 40.83           O   
ATOM    354  N   ARG    23      19.212 116.238  -3.347  1.00 37.97           N   
ATOM    355  CA  ARG    23      20.320 116.934  -4.020  1.00 39.46           C   
ATOM    357  CB  ARG    23      20.513 118.345  -3.471  1.00 39.35           C   
ATOM    360  CG  ARG    23      19.337 119.277  -3.755  1.00 45.66           C   
ATOM    363  CD  ARG    23      19.312 120.490  -2.827  1.00 47.91           C   
ATOM    366  NE  ARG    23      19.338 120.110  -1.413  1.00 53.73           N   
ATOM    368  CZ  ARG    23      19.107 120.943  -0.402  1.00 54.70           C   
ATOM    369  NH1 ARG    23      18.791 122.214  -0.621  1.00 55.43           N   
ATOM    372  NH2 ARG    23      19.171 120.492   0.847  1.00 52.44           N   
ATOM    375  C   ARG    23      21.626 116.170  -3.866  1.00 36.87           C   
ATOM    376  O   ARG    23      21.909 115.609  -2.795  1.00 32.72           O   
ATOM    378  N   THR    24      22.426 116.173  -4.930  1.00 35.27           N   
ATOM    379  CA  THR    24      23.734 115.523  -4.915  1.00 35.97           C   
ATOM    381  CB  THR    24      24.319 115.362  -6.321  1.00 35.96           C   
ATOM    383  OG1 THR    24      23.391 114.635  -7.137  1.00 37.50           O   
ATOM    385  CG2 THR    24      25.657 114.600  -6.280  1.00 34.81           C   
ATOM    389  C   THR    24      24.691 116.323  -4.043  1.00 36.39           C   
ATOM    390  O   THR    24      24.777 117.546  -4.165  1.00 34.43           O   
ATOM    392  N   VAL    25      25.375 115.613  -3.147  1.00 33.98           N   
ATOM    393  CA  VAL    25      26.331 116.195  -2.219  1.00 36.38           C   
ATOM    395  CB  VAL    25      25.751 116.185  -0.780  1.00 37.87           C   
ATOM    397  CG1 VAL    25      26.849 116.272   0.273  1.00 44.85           C   
ATOM    401  CG2 VAL    25      24.748 117.318  -0.617  1.00 44.92           C   
ATOM    405  C   VAL    25      27.613 115.362  -2.308  1.00 35.07           C   
ATOM    406  O   VAL    25      27.549 114.138  -2.393  1.00 34.93           O   
ATOM    408  N   SER    26      28.762 116.031  -2.303  1.00 33.43           N   
ATOM    409  CA  SER    26      30.070 115.362  -2.267  1.00 35.00           C   
ATOM    411  CB  SER    26      31.135 116.200  -2.990  1.00 36.34           C   
ATOM    414  OG  SER    26      32.412 115.596  -2.860  1.00 36.74           O   
ATOM    416  C   SER    26      30.493 115.166  -0.820  1.00 33.45           C   
ATOM    417  O   SER    26      30.333 116.065  -0.002  1.00 34.47           O   
ATOM    419  N   LEU    27      31.017 113.989  -0.501  1.00 32.40           N   
ATOM    420  CA  LEU    27      31.520 113.725   0.850  1.00 31.37           C   
ATOM    422  CB  LEU    27      31.481 112.233   1.172  1.00 31.70           C   
ATOM    425  CG  LEU    27      30.068 111.634   1.228  1.00 34.99           C   
ATOM    427  CD1 LEU    27      30.153 110.145   1.375  1.00 27.90           C   
ATOM    431  CD2 LEU    27      29.200 112.254   2.380  1.00 32.84           C   
ATOM    435  C   LEU    27      32.923 114.309   1.050  1.00 32.58           C   
ATOM    436  O   LEU    27      33.499 114.181   2.133  1.00 30.82           O   
ATOM    438  N   GLU    28      33.467 114.963   0.017  1.00 33.92           N   
ATOM    439  CA  GLU    28      34.766 115.614   0.127  1.00 35.56           C   
ATOM    441  CB  GLU    28      35.217 116.157  -1.224  1.00 37.08           C   
ATOM    444  CG  GLU    28      35.633 115.042  -2.183  1.00 41.61           C   
ATOM    450  C   GLU    28      34.769 116.710   1.181  1.00 34.80           C   
ATOM    451  O   GLU    28      35.814 117.031   1.742  1.00 35.43           O   
ATOM    453  N   LYS    29      33.599 117.276   1.470  1.00 34.83           N   
ATOM    454  CA  LYS    29      33.500 118.272   2.529  1.00 37.78           C   
ATOM    456  CB  LYS    29      32.111 118.931   2.554  1.00 39.47           C   
ATOM    459  CG  LYS    29      30.988 118.096   3.135  1.00 41.52           C   
ATOM    462  CD  LYS    29      29.994 118.958   3.937  1.00 44.25           C   
ATOM    465  CE  LYS    29      28.830 119.458   3.094  1.00 51.17           C   
ATOM    468  NZ  LYS    29      27.854 120.237   3.919  1.00 49.08           N   
ATOM    472  C   LYS    29      33.870 117.739   3.930  1.00 35.78           C   
ATOM    473  O   LYS    29      34.199 118.521   4.814  1.00 34.27           O   
ATOM    475  N   TYR    30      33.822 116.419   4.125  1.00 35.47           N   
ATOM    476  CA  TYR    30      34.223 115.813   5.400  1.00 33.55           C   
ATOM    478  CB  TYR    30      33.270 114.662   5.780  1.00 33.58           C   
ATOM    481  CG  TYR    30      31.837 115.111   5.777  1.00 30.86           C   
ATOM    482  CD1 TYR    30      31.357 115.966   6.778  1.00 32.55           C   
ATOM    484  CE1 TYR    30      30.054 116.429   6.767  1.00 29.85           C   
ATOM    486  CZ  TYR    30      29.205 116.030   5.753  1.00 33.24           C   
ATOM    487  OH  TYR    30      27.917 116.488   5.752  1.00 34.76           O   
ATOM    489  CE2 TYR    30      29.650 115.171   4.740  1.00 29.56           C   
ATOM    491  CD2 TYR    30      30.966 114.731   4.754  1.00 30.57           C   
ATOM    493  C   TYR    30      35.698 115.371   5.428  1.00 32.76           C   
ATOM    494  O   TYR    30      36.172 114.861   6.455  1.00 31.53           O   
ATOM    496  N   LYS    31      36.422 115.583   4.328  1.00 32.69           N   
ATOM    497  CA  LYS    31      37.853 115.288   4.278  1.00 34.14           C   
ATOM    499  CB  LYS    31      38.449 115.660   2.908  1.00 34.16           C   
ATOM    502  CG  LYS    31      39.728 114.895   2.586  1.00 42.04           C   
ATOM    505  CD  LYS    31      40.342 115.294   1.236  1.00 37.11           C   
ATOM    508  CE  LYS    31      41.687 115.990   1.403  1.00 51.57           C   
ATOM    512  C   LYS    31      38.585 116.024   5.402  1.00 33.18           C   
ATOM    513  O   LYS    31      38.306 117.184   5.658  1.00 33.52           O   
ATOM    515  N   GLY    32      39.484 115.328   6.099  1.00 32.67           N   
ATOM    516  CA  GLY    32      40.201 115.898   7.245  1.00 33.31           C   
ATOM    519  C   GLY    32      39.462 115.770   8.579  1.00 33.60           C   
ATOM    520  O   GLY    32      40.002 116.112   9.631  1.00 34.30           O   
ATOM    522  N   LYS    33      38.220 115.295   8.536  1.00 33.13           N   
ATOM    523  CA  LYS    33      37.451 115.038   9.749  1.00 33.38           C   
ATOM    525  CB  LYS    33      36.020 115.577   9.629  1.00 34.52           C   
ATOM    528  CG  LYS    33      35.939 117.069   9.319  1.00 34.83           C   
ATOM    531  CD  LYS    33      34.495 117.554   9.381  1.00 37.73           C   
ATOM    534  CE  LYS    33      34.382 119.085   9.322  1.00 46.88           C   
ATOM    537  NZ  LYS    33      35.581 119.796   8.795  1.00 46.69           N   
ATOM    541  C   LYS    33      37.388 113.543  10.042  1.00 30.10           C   
ATOM    542  O   LYS    33      37.546 112.706   9.155  1.00 27.92           O   
ATOM    544  N   VAL    34      37.172 113.225  11.314  1.00 29.07           N   
ATOM    545  CA  VAL    34      36.819 111.884  11.739  1.00 29.27           C   
ATOM    547  CB  VAL    34      37.226 111.613  13.219  1.00 28.84           C   
ATOM    549  CG1 VAL    34      36.769 110.212  13.685  1.00 27.40           C   
ATOM    553  CG2 VAL    34      38.716 111.771  13.402  1.00 27.02           C   
ATOM    557  C   VAL    34      35.301 111.774  11.572  1.00 31.17           C   
ATOM    558  O   VAL    34      34.574 112.706  11.905  1.00 28.48           O   
ATOM    560  N   SER    35      34.835 110.667  11.009  1.00 28.25           N   
ATOM    561  CA  SER    35      33.406 110.454  10.805  1.00 28.19           C   
ATOM    563  CB  SER    35      33.047 110.516   9.311  1.00 28.35           C   
ATOM    566  OG  SER    35      33.254 111.843   8.810  1.00 35.43           O   
ATOM    568  C   SER    35      33.002 109.117  11.382  1.00 28.55           C   
ATOM    569  O   SER    35      33.689 108.088  11.195  1.00 28.19           O   
ATOM    571  N   LEU    36      31.878 109.125  12.078  1.00 27.27           N   
ATOM    572  CA  LEU    36      31.202 107.892  12.473  1.00 29.01           C   
ATOM    574  CB  LEU    36      30.737 107.929  13.942  1.00 29.21           C   
ATOM    577  CG  LEU    36      30.124 106.599  14.481  1.00 25.97           C   
ATOM    579  CD1 LEU    36      31.205 105.520  14.630  1.00 29.17           C   
ATOM    583  CD2 LEU    36      29.402 106.819  15.814  1.00 26.31           C   
ATOM    587  C   LEU    36      30.009 107.713  11.533  1.00 29.07           C   
ATOM    588  O   LEU    36      29.029 108.465  11.594  1.00 28.10           O   
ATOM    590  N   VAL    37      30.120 106.727  10.654  1.00 27.97           N   
ATOM    591  CA  VAL    37      29.091 106.469   9.656  1.00 27.25           C   
ATOM    593  CB  VAL    37      29.701 106.167   8.275  1.00 27.64           C   
ATOM    595  CG1 VAL    37      28.607 106.143   7.221  1.00 29.14           C   
ATOM    599  CG2 VAL    37      30.781 107.237   7.910  1.00 25.53           C   
ATOM    603  C   VAL    37      28.170 105.331  10.139  1.00 27.49           C   
ATOM    604  O   VAL    37      28.631 104.260  10.552  1.00 30.77           O   
ATOM    606  N   VAL    38      26.869 105.586  10.098  1.00 28.11           N   
ATOM    607  CA  VAL    38      25.869 104.726  10.750  1.00 27.63           C   
ATOM    609  CB  VAL    38      25.361 105.342  12.097  1.00 28.71           C   
ATOM    611  CG1 VAL    38      24.449 104.327  12.847  1.00 27.69           C   
ATOM    615  CG2 VAL    38      26.539 105.813  12.991  1.00 29.94           C   
ATOM    619  C   VAL    38      24.675 104.556   9.825  1.00 26.64           C   
ATOM    620  O   VAL    38      24.172 105.545   9.294  1.00 28.30           O   
ATOM    622  N   ASN    39      24.210 103.319   9.639  1.00 28.23           N   
ATOM    623  CA  ASN    39      22.886 103.107   9.017  1.00 28.79           C   
ATOM    625  CB  ASN    39      22.795 101.770   8.245  1.00 27.43           C   
ATOM    628  CG  ASN    39      23.004 100.545   9.128  1.00 32.37           C   
ATOM    629  OD1 ASN    39      24.032 100.407   9.761  1.00 28.55           O   
ATOM    630  ND2 ASN    39      22.041  99.632   9.123  1.00 27.09           N   
ATOM    633  C   ASN    39      21.781 103.257  10.058  1.00 27.57           C   
ATOM    634  O   ASN    39      21.809 102.594  11.101  1.00 29.56           O   
ATOM    636  N   VAL    40      20.819 104.147   9.787  1.00 28.40           N   
ATOM    637  CA  VAL    40      19.786 104.484  10.761  1.00 27.97           C   
ATOM    639  CB  VAL    40      19.789 106.002  11.119  1.00 27.75           C   
ATOM    641  CG1 VAL    40      21.186 106.422  11.666  1.00 26.04           C   
ATOM    645  CG2 VAL    40      19.344 106.885   9.923  1.00 24.25           C   
ATOM    649  C   VAL    40      18.374 104.023  10.342  1.00 28.94           C   
ATOM    650  O   VAL    40      18.141 103.592   9.226  1.00 25.98           O   
ATOM    652  N   ALA    41      17.451 104.097  11.292  1.00 28.10           N   
ATOM    653  CA  ALA    41      16.064 103.737  11.074  1.00 27.64           C   
ATOM    655  CB  ALA    41      15.893 102.243  11.073  1.00 28.79           C   
ATOM    659  C   ALA    41      15.232 104.391  12.191  1.00 30.17           C   
ATOM    660  O   ALA    41      15.729 104.583  13.316  1.00 29.74           O   
ATOM    662  N   SER    42      13.989 104.758  11.864  1.00 29.69           N   
ATOM    663  CA  SER    42      13.106 105.490  12.793  1.00 27.61           C   
ATOM    665  CB  SER    42      12.227 106.500  12.024  1.00 28.81           C   
ATOM    668  OG  SER    42      12.998 107.447  11.295  1.00 28.59           O   
ATOM    670  C   SER    42      12.171 104.564  13.580  1.00 28.00           C   
ATOM    671  O   SER    42      11.631 104.955  14.634  1.00 27.36           O   
ATOM    673  N   ASP    43      11.929 103.368  13.047  1.00 26.77           N   
ATOM    674  CA  ASP    43      10.879 102.486  13.562  1.00 26.73           C   
ATOM    676  CB  ASP    43       9.809 102.257  12.505  1.00 26.78           C   
ATOM    679  CG  ASP    43       8.586 101.511  13.035  1.00 32.47           C   
ATOM    680  OD1 ASP    43       8.272 101.595  14.254  1.00 33.38           O   
ATOM    681  OD2 ASP    43       7.925 100.839  12.213  1.00 36.00           O   
ATOM    682  C   ASP    43      11.500 101.162  13.983  1.00 28.33           C   
ATOM    683  O   ASP    43      11.180 100.099  13.457  1.00 25.98           O   
ATOM    685  N   CYS    44      12.350 101.251  14.995  1.00 31.14           N   
ATOM    686  CA  CYS    44      13.196 100.151  15.429  1.00 29.48           C   
ATOM    688  CB  CYS    44      14.530 100.368  14.722  1.00 35.98           C   
ATOM    691  SG  CYS    44      15.841  99.485  15.259  1.00 37.28           S   
ATOM    693  C   CYS    44      13.368 100.187  16.954  1.00 26.28           C   
ATOM    694  O   CYS    44      13.390 101.261  17.541  1.00 28.92           O   
ATOM    696  N   GLN    45      13.446  99.024  17.615  1.00 28.06           N   
ATOM    697  CA  GLN    45      13.692  98.986  19.072  1.00 27.51           C   
ATOM    699  CB  GLN    45      13.948  97.546  19.578  1.00 28.07           C   
ATOM    702  CG  GLN    45      14.286  97.431  21.078  1.00 27.78           C   
ATOM    705  CD  GLN    45      14.665  95.996  21.497  1.00 28.26           C   
ATOM    706  OE1 GLN    45      13.987  95.042  21.151  1.00 28.26           O   
ATOM    707  NE2 GLN    45      15.756  95.859  22.237  1.00 33.73           N   
ATOM    710  C   GLN    45      14.877  99.874  19.463  1.00 26.40           C   
ATOM    711  O   GLN    45      14.843 100.538  20.507  1.00 25.47           O   
ATOM    713  N   LEU    46      15.911  99.865  18.614  1.00 27.06           N   
ATOM    714  CA  LEU    46      17.166 100.560  18.859  1.00 28.83           C   
ATOM    716  CB  LEU    46      18.310  99.841  18.112  1.00 30.05           C   
ATOM    719  CG  LEU    46      18.660  98.420  18.557  1.00 30.59           C   
ATOM    721  CD1 LEU    46      19.739  97.796  17.676  1.00 27.67           C   
ATOM    725  CD2 LEU    46      19.117  98.460  20.009  1.00 32.19           C   
ATOM    729  C   LEU    46      17.194 102.054  18.498  1.00 27.19           C   
ATOM    730  O   LEU    46      18.170 102.741  18.764  1.00 27.57           O   
ATOM    732  N   THR    47      16.132 102.565  17.897  1.00 26.88           N   
ATOM    733  CA  THR    47      16.106 103.938  17.398  1.00 26.56           C   
ATOM    735  CB  THR    47      14.727 104.266  16.764  1.00 28.77           C   
ATOM    737  OG1 THR    47      14.572 103.513  15.562  1.00 24.42           O   
ATOM    739  CG2 THR    47      14.577 105.793  16.460  1.00 26.33           C   
ATOM    743  C   THR    47      16.439 105.007  18.451  1.00 27.39           C   
ATOM    744  O   THR    47      17.317 105.875  18.231  1.00 25.14           O   
ATOM    746  N   ASP    48      15.716 104.963  19.570  1.00 26.10           N   
ATOM    747  CA  ASP    48      15.837 105.976  20.620  1.00 27.82           C   
ATOM    749  CB  ASP    48      14.800 105.709  21.724  1.00 26.06           C   
ATOM    752  CG  ASP    48      14.729 106.810  22.760  1.00 30.08           C   
ATOM    753  OD1 ASP    48      14.435 107.972  22.392  1.00 26.32           O   
ATOM    754  OD2 ASP    48      14.968 106.502  23.956  1.00 24.99           O   
ATOM    755  C   ASP    48      17.246 106.007  21.199  1.00 27.22           C   
ATOM    756  O   ASP    48      17.869 107.069  21.244  1.00 27.28           O   
ATOM    758  N   ARG    49      17.763 104.850  21.619  1.00 26.54           N   
ATOM    759  CA  ARG    49      19.078 104.834  22.266  1.00 29.48           C   
ATOM    761  CB  ARG    49      19.400 103.457  22.868  1.00 29.33           C   
ATOM    764  CG  ARG    49      19.658 102.352  21.883  1.00 33.98           C   
ATOM    767  CD  ARG    49      19.800 100.993  22.592  1.00 38.23           C   
ATOM    770  NE  ARG    49      18.495 100.357  22.848  1.00 41.38           N   
ATOM    772  CZ  ARG    49      18.344  99.098  23.272  1.00 43.01           C   
ATOM    773  NH1 ARG    49      19.410  98.323  23.511  1.00 42.46           N   
ATOM    776  NH2 ARG    49      17.130  98.602  23.464  1.00 35.29           N   
ATOM    779  C   ARG    49      20.178 105.295  21.311  1.00 28.85           C   
ATOM    780  O   ARG    49      21.138 105.973  21.713  1.00 25.64           O   
ATOM    782  N   ASN    50      20.025 104.963  20.038  1.00 28.96           N   
ATOM    783  CA  ASN    50      21.025 105.360  19.042  1.00 29.07           C   
ATOM    785  CB  ASN    50      20.931 104.485  17.804  1.00 30.92           C   
ATOM    788  CG  ASN    50      21.731 103.216  17.962  1.00 29.89           C   
ATOM    789  OD1 ASN    50      22.922 103.212  17.652  1.00 35.14           O   
ATOM    790  ND2 ASN    50      21.114 102.155  18.530  1.00 27.55           N   
ATOM    793  C   ASN    50      21.003 106.831  18.697  1.00 30.38           C   
ATOM    794  O   ASN    50      22.053 107.471  18.671  1.00 30.04           O   
ATOM    796  N   TYR    51      19.828 107.406  18.454  1.00 27.69           N   
ATOM    797  CA  TYR    51      19.778 108.842  18.215  1.00 29.40           C   
ATOM    799  CB  TYR    51      18.395 109.327  17.781  1.00 29.81           C   
ATOM    802  CG  TYR    51      18.206 109.214  16.285  1.00 27.26           C   
ATOM    803  CD1 TYR    51      17.404 108.221  15.734  1.00 30.73           C   
ATOM    805  CE1 TYR    51      17.250 108.101  14.353  1.00 31.86           C   
ATOM    807  CZ  TYR    51      17.885 108.983  13.503  1.00 30.53           C   
ATOM    808  OH  TYR    51      17.694 108.869  12.133  1.00 32.18           O   
ATOM    810  CE2 TYR    51      18.707 109.977  14.024  1.00 31.88           C   
ATOM    812  CD2 TYR    51      18.868 110.083  15.410  1.00 34.42           C   
ATOM    814  C   TYR    51      20.295 109.643  19.404  1.00 29.27           C   
ATOM    815  O   TYR    51      21.037 110.608  19.224  1.00 29.81           O   
ATOM    817  N   LEU    52      19.940 109.219  20.610  1.00 28.46           N   
ATOM    818  CA  LEU    52      20.437 109.882  21.808  1.00 28.36           C   
ATOM    820  CB  LEU    52      19.730 109.354  23.061  1.00 28.79           C   
ATOM    823  CG  LEU    52      18.285 109.826  23.268  1.00 28.20           C   
ATOM    825  CD1 LEU    52      17.643 109.057  24.430  1.00 33.83           C   
ATOM    829  CD2 LEU    52      18.229 111.348  23.523  1.00 34.54           C   
ATOM    833  C   LEU    52      21.965 109.768  21.915  1.00 28.67           C   
ATOM    834  O   LEU    52      22.636 110.780  22.165  1.00 29.61           O   
ATOM    836  N   GLY    53      22.510 108.571  21.713  1.00 27.55           N   
ATOM    837  CA  GLY    53      23.951 108.359  21.814  1.00 29.04           C   
ATOM    840  C   GLY    53      24.730 109.095  20.739  1.00 29.18           C   
ATOM    841  O   GLY    53      25.759 109.694  21.016  1.00 27.14           O   
ATOM    843  N   LEU    54      24.251 109.026  19.498  1.00 29.30           N   
ATOM    844  CA  LEU    54      24.899 109.725  18.383  1.00 30.45           C   
ATOM    846  CB  LEU    54      24.256 109.340  17.042  1.00 29.74           C   
ATOM    849  CG  LEU    54      24.416 107.877  16.618  1.00 31.60           C   
ATOM    851  CD1 LEU    54      23.633 107.547  15.344  1.00 31.13           C   
ATOM    855  CD2 LEU    54      25.886 107.558  16.449  1.00 29.92           C   
ATOM    859  C   LEU    54      24.866 111.251  18.575  1.00 30.35           C   
ATOM    860  O   LEU    54      25.831 111.953  18.251  1.00 31.78           O   
ATOM    862  N   LYS    55      23.763 111.762  19.120  1.00 29.29           N   
ATOM    863  CA  LYS    55      23.647 113.184  19.430  1.00 29.75           C   
ATOM    865  CB  LYS    55      22.253 113.536  19.974  1.00 29.43           C   
ATOM    868  CG  LYS    55      22.088 114.976  20.332  1.00 33.21           C   
ATOM    871  CD  LYS    55      20.730 115.276  20.900  1.00 34.28           C   
ATOM    874  CE  LYS    55      20.604 116.766  21.244  1.00 38.23           C   
ATOM    877  NZ  LYS    55      19.265 117.092  21.766  1.00 36.14           N   
ATOM    881  C   LYS    55      24.715 113.592  20.438  1.00 29.69           C   
ATOM    882  O   LYS    55      25.350 114.631  20.276  1.00 29.31           O   
ATOM    884  N   GLU    56      24.903 112.772  21.468  1.00 28.45           N   
ATOM    885  CA  GLU    56      25.858 113.076  22.516  1.00 29.35           C   
ATOM    887  CB  GLU    56      25.723 112.078  23.675  1.00 28.94           C   
ATOM    894  C   GLU    56      27.270 113.121  21.939  1.00 28.19           C   
ATOM    895  O   GLU    56      27.993 114.066  22.187  1.00 27.49           O   
ATOM    897  N   LEU    57      27.644 112.121  21.136  1.00 29.73           N   
ATOM    898  CA  LEU    57      28.970 112.063  20.515  1.00 28.30           C   
ATOM    900  CB  LEU    57      29.151 110.762  19.709  1.00 29.20           C   
ATOM    903  CG  LEU    57      29.315 109.454  20.493  1.00 33.40           C   
ATOM    905  CD1 LEU    57      29.333 108.272  19.539  1.00 29.68           C   
ATOM    909  CD2 LEU    57      30.592 109.478  21.367  1.00 30.63           C   
ATOM    913  C   LEU    57      29.242 113.261  19.604  1.00 29.43           C   
ATOM    914  O   LEU    57      30.326 113.842  19.652  1.00 28.96           O   
ATOM    916  N   HIS    58      28.267 113.615  18.767  1.00 30.93           N   
ATOM    917  CA  HIS    58      28.403 114.739  17.843  1.00 30.59           C   
ATOM    919  CB  HIS    58      27.200 114.817  16.898  1.00 34.70           C   
ATOM    922  CG  HIS    58      27.368 115.805  15.777  1.00 37.39           C   
ATOM    923  ND1 HIS    58      28.187 115.570  14.688  1.00 37.97           N   
ATOM    925  CE1 HIS    58      28.120 116.600  13.860  1.00 33.90           C   
ATOM    927  NE2 HIS    58      27.291 117.492  14.373  1.00 27.65           N   
ATOM    929  CD2 HIS    58      26.797 117.014  15.563  1.00 30.15           C   
ATOM    931  C   HIS    58      28.545 116.046  18.584  1.00 33.29           C   
ATOM    932  O   HIS    58      29.378 116.864  18.217  1.00 27.95           O   
ATOM    934  N   LYS    59      27.734 116.238  19.631  1.00 33.33           N   
ATOM    935  CA  LYS    59      27.817 117.430  20.463  1.00 37.52           C   
ATOM    937  CB  LYS    59      26.738 117.431  21.565  1.00 39.79           C   
ATOM    940  CG  LYS    59      25.362 117.912  21.109  1.00 47.22           C   
ATOM    943  CD  LYS    59      24.361 117.939  22.283  1.00 44.96           C   
ATOM    946  CE  LYS    59      24.443 119.230  23.087  1.00 52.24           C   
ATOM    949  NZ  LYS    59      23.793 120.363  22.360  1.00 57.42           N   
ATOM    953  C   LYS    59      29.179 117.574  21.122  1.00 35.71           C   
ATOM    954  O   LYS    59      29.708 118.680  21.222  1.00 34.97           O   
ATOM    956  N   GLU    60      29.737 116.465  21.586  1.00 34.21           N   
ATOM    957  CA  GLU    60      31.013 116.505  22.283  1.00 34.92           C   
ATOM    959  CB  GLU    60      31.214 115.216  23.068  1.00 35.98           C   
ATOM    962  CG  GLU    60      32.434 115.229  23.975  1.00 38.51           C   
ATOM    965  CD  GLU    60      32.559 113.969  24.804  1.00 43.62           C   
ATOM    966  OE1 GLU    60      31.700 113.058  24.674  1.00 43.74           O   
ATOM    967  OE2 GLU    60      33.531 113.897  25.584  1.00 48.82           O   
ATOM    968  C   GLU    60      32.205 116.742  21.341  1.00 31.99           C   
ATOM    969  O   GLU    60      33.043 117.577  21.629  1.00 29.88           O   
ATOM    971  N   PHE    61      32.276 116.031  20.218  1.00 30.95           N   
ATOM    972  CA  PHE    61      33.484 116.064  19.381  1.00 31.86           C   
ATOM    974  CB  PHE    61      33.922 114.638  19.044  1.00 32.01           C   
ATOM    977  CG  PHE    61      34.278 113.837  20.250  1.00 29.73           C   
ATOM    978  CD1 PHE    61      33.403 112.874  20.744  1.00 30.56           C   
ATOM    980  CE1 PHE    61      33.721 112.139  21.887  1.00 32.50           C   
ATOM    982  CZ  PHE    61      34.920 112.372  22.556  1.00 31.23           C   
ATOM    984  CE2 PHE    61      35.803 113.333  22.070  1.00 36.16           C   
ATOM    986  CD2 PHE    61      35.476 114.061  20.914  1.00 29.91           C   
ATOM    988  C   PHE    61      33.357 116.880  18.098  1.00 33.59           C   
ATOM    989  O   PHE    61      34.371 117.207  17.482  1.00 33.02           O   
ATOM    991  N   GLY    62      32.126 117.179  17.688  1.00 32.60           N   
ATOM    992  CA  GLY    62      31.871 117.914  16.452  1.00 35.14           C   
ATOM    995  C   GLY    62      31.769 119.410  16.679  1.00 34.74           C   
ATOM    996  O   GLY    62      31.859 119.876  17.829  1.00 32.53           O   
ATOM    998  N   PRO    63      31.553 120.179  15.593  1.00 35.67           N   
ATOM    999  CA  PRO    63      31.425 119.752  14.197  1.00 36.58           C   
ATOM   1001  CB  PRO    63      30.300 120.667  13.696  1.00 37.91           C   
ATOM   1004  CG  PRO    63      30.551 121.971  14.436  1.00 36.42           C   
ATOM   1007  CD  PRO    63      31.337 121.635  15.704  1.00 37.26           C   
ATOM   1010  C   PRO    63      32.689 119.987  13.349  1.00 33.92           C   
ATOM   1011  O   PRO    63      32.702 119.662  12.164  1.00 37.73           O   
ATOM   1012  N   SER    64      33.737 120.550  13.939  1.00 33.87           N   
ATOM   1013  CA  SER    64      34.913 120.940  13.175  1.00 33.33           C   
ATOM   1015  CB  SER    64      35.734 121.991  13.932  1.00 32.10           C   
ATOM   1018  OG  SER    64      34.941 123.115  14.284  1.00 44.49           O   
ATOM   1020  C   SER    64      35.784 119.731  12.862  1.00 30.71           C   
ATOM   1021  O   SER    64      36.291 119.598  11.739  1.00 32.95           O   
ATOM   1023  N   HIS    65      35.965 118.851  13.844  1.00 29.03           N   
ATOM   1024  CA  HIS    65      36.895 117.724  13.679  1.00 28.12           C   
ATOM   1026  CB  HIS    65      37.911 117.724  14.829  1.00 29.47           C   
ATOM   1029  CG  HIS    65      38.572 119.051  15.038  1.00 26.75           C   
ATOM   1030  ND1 HIS    65      39.480 119.575  14.146  1.00 31.04           N   
ATOM   1032  CE1 HIS    65      39.885 120.757  14.580  1.00 31.81           C   
ATOM   1034  NE2 HIS    65      39.265 121.019  15.718  1.00 30.24           N   
ATOM   1036  CD2 HIS    65      38.431 119.972  16.020  1.00 31.98           C   
ATOM   1038  C   HIS    65      36.207 116.362  13.575  1.00 28.96           C   
ATOM   1039  O   HIS    65      36.866 115.338  13.322  1.00 26.65           O   
ATOM   1041  N   PHE    66      34.892 116.353  13.757  1.00 27.13           N   
ATOM   1042  CA  PHE    66      34.140 115.113  13.808  1.00 26.37           C   
ATOM   1044  CB  PHE    66      34.078 114.641  15.249  1.00 27.98           C   
ATOM   1047  CG  PHE    66      33.186 113.450  15.469  1.00 26.37           C   
ATOM   1048  CD1 PHE    66      33.585 112.184  15.097  1.00 26.85           C   
ATOM   1050  CE1 PHE    66      32.749 111.078  15.313  1.00 28.17           C   
ATOM   1052  CZ  PHE    66      31.520 111.249  15.913  1.00 26.35           C   
ATOM   1054  CE2 PHE    66      31.115 112.518  16.292  1.00 27.66           C   
ATOM   1056  CD2 PHE    66      31.944 113.606  16.071  1.00 29.10           C   
ATOM   1058  C   PHE    66      32.724 115.308  13.291  1.00 27.79           C   
ATOM   1059  O   PHE    66      32.100 116.329  13.555  1.00 28.02           O   
ATOM   1061  N   SER    67      32.204 114.309  12.585  1.00 29.16           N   
ATOM   1062  CA  SER    67      30.771 114.277  12.298  1.00 29.81           C   
ATOM   1064  CB  SER    67      30.472 114.870  10.915  1.00 29.55           C   
ATOM   1067  OG  SER    67      29.069 114.938  10.717  1.00 37.46           O   
ATOM   1069  C   SER    67      30.201 112.875  12.376  1.00 29.25           C   
ATOM   1070  O   SER    67      30.876 111.884  12.095  1.00 29.41           O   
ATOM   1072  N   VAL    68      28.928 112.811  12.735  1.00 30.58           N   
ATOM   1073  CA  VAL    68      28.125 111.613  12.541  1.00 31.24           C   
ATOM   1075  CB  VAL    68      27.029 111.482  13.627  1.00 29.08           C   
ATOM   1077  CG1 VAL    68      26.077 110.317  13.323  1.00 22.81           C   
ATOM   1081  CG2 VAL    68      27.672 111.323  14.986  1.00 28.26           C   
ATOM   1085  C   VAL    68      27.513 111.794  11.157  1.00 29.65           C   
ATOM   1086  O   VAL    68      26.984 112.865  10.855  1.00 29.56           O   
ATOM   1088  N   LEU    69      27.639 110.774  10.318  1.00 28.56           N   
ATOM   1089  CA  LEU    69      27.022 110.745   8.989  1.00 28.24           C   
ATOM   1091  CB  LEU    69      28.081 110.493   7.924  1.00 29.42           C   
ATOM   1094  CG  LEU    69      29.194 111.562   7.929  1.00 26.40           C   
ATOM   1096  CD1 LEU    69      30.220 111.184   6.879  1.00 22.66           C   
ATOM   1100  CD2 LEU    69      28.624 112.973   7.713  1.00 24.78           C   
ATOM   1104  C   LEU    69      25.977 109.629   8.955  1.00 29.56           C   
ATOM   1105  O   LEU    69      26.319 108.465   9.013  1.00 28.56           O   
ATOM   1107  N   ALA    70      24.704 110.007   8.922  1.00 27.94           N   
ATOM   1108  CA  ALA    70      23.619 109.046   9.106  1.00 29.23           C   
ATOM   1110  CB  ALA    70      22.585 109.592  10.122  1.00 27.85           C   
ATOM   1114  C   ALA    70      22.957 108.710   7.762  1.00 28.92           C   
ATOM   1115  O   ALA    70      22.514 109.591   7.052  1.00 27.96           O   
ATOM   1117  N   PHE    71      22.912 107.416   7.433  1.00 28.74           N   
ATOM   1118  CA  PHE    71      22.267 106.928   6.221  1.00 27.45           C   
ATOM   1120  CB  PHE    71      23.268 106.150   5.379  1.00 26.28           C   
ATOM   1123  CG  PHE    71      24.324 107.018   4.773  1.00 25.35           C   
ATOM   1124  CD1 PHE    71      24.145 107.562   3.517  1.00 26.62           C   
ATOM   1126  CE1 PHE    71      25.121 108.394   2.955  1.00 31.36           C   
ATOM   1128  CZ  PHE    71      26.290 108.686   3.668  1.00 32.57           C   
ATOM   1130  CE2 PHE    71      26.474 108.157   4.939  1.00 29.41           C   
ATOM   1132  CD2 PHE    71      25.495 107.309   5.483  1.00 27.51           C   
ATOM   1134  C   PHE    71      21.072 106.051   6.554  1.00 28.44           C   
ATOM   1135  O   PHE    71      21.244 104.908   6.993  1.00 29.70           O   
ATOM   1137  N   PRO    72      19.850 106.592   6.378  1.00 29.22           N   
ATOM   1138  CA  PRO    72      18.682 105.768   6.622  1.00 28.27           C   
ATOM   1140  CB  PRO    72      17.511 106.728   6.421  1.00 27.34           C   
ATOM   1143  CG  PRO    72      18.090 108.088   6.511  1.00 26.10           C   
ATOM   1146  CD  PRO    72      19.482 107.968   6.015  1.00 29.30           C   
ATOM   1149  C   PRO    72      18.611 104.615   5.647  1.00 26.53           C   
ATOM   1150  O   PRO    72      19.086 104.729   4.517  1.00 26.16           O   
ATOM   1151  N   CYS    73      18.004 103.521   6.099  1.00 28.22           N   
ATOM   1152  CA  CYS    73      17.864 102.311   5.302  1.00 27.50           C   
ATOM   1154  CB  CYS    73      19.151 101.485   5.376  1.00 29.55           C   
ATOM   1157  SG  CYS    73      19.159  99.957   4.401  1.00 28.22           S   
ATOM   1159  C   CYS    73      16.660 101.504   5.779  1.00 27.45           C   
ATOM   1160  O   CYS    73      16.462 101.340   6.980  1.00 27.13           O   
ATOM   1162  N   ASN    74      15.861 101.024   4.822  1.00 25.79           N   
ATOM   1163  CA  ASN    74      14.623 100.270   5.107  1.00 25.88           C   
ATOM   1165  CB  ASN    74      13.481 100.767   4.197  1.00 26.64           C   
ATOM   1168  CG  ASN    74      12.088 100.335   4.683  1.00 28.09           C   
ATOM   1169  OD1 ASN    74      11.813 100.291   5.887  1.00 27.59           O   
ATOM   1170  ND2 ASN    74      11.195 100.033   3.731  1.00 25.31           N   
ATOM   1173  C   ASN    74      14.770  98.746   4.955  1.00 27.99           C   
ATOM   1174  O   ASN    74      13.767  98.026   4.935  1.00 27.75           O   
ATOM   1176  N   GLN    75      15.999  98.240   4.880  1.00 27.00           N   
ATOM   1177  CA  GLN    75      16.210  96.826   4.572  1.00 28.71           C   
ATOM   1179  CB  GLN    75      17.465  96.670   3.734  1.00 26.34           C   
ATOM   1182  CG  GLN    75      17.312  97.255   2.341  1.00 25.53           C   
ATOM   1185  CD  GLN    75      18.569  97.075   1.524  1.00 27.65           C   
ATOM   1186  OE1 GLN    75      19.639  97.458   1.954  1.00 29.05           O   
ATOM   1187  NE2 GLN    75      18.446  96.470   0.364  1.00 24.29           N   
ATOM   1190  C   GLN    75      16.283  95.882   5.788  1.00 30.10           C   
ATOM   1191  O   GLN    75      16.482  94.675   5.619  1.00 28.94           O   
ATOM   1193  N   PHE    76      16.151  96.433   6.993  1.00 28.98           N   
ATOM   1194  CA  PHE    76      16.322  95.674   8.227  1.00 27.38           C   
ATOM   1196  CB  PHE    76      17.536  96.160   8.997  1.00 27.82           C   
ATOM   1199  CG  PHE    76      18.792  96.144   8.187  1.00 28.63           C   
ATOM   1200  CD1 PHE    76      19.462  94.946   7.950  1.00 27.46           C   
ATOM   1202  CE1 PHE    76      20.589  94.914   7.179  1.00 24.65           C   
ATOM   1204  CZ  PHE    76      21.092  96.102   6.626  1.00 28.82           C   
ATOM   1206  CE2 PHE    76      20.442  97.301   6.859  1.00 27.80           C   
ATOM   1208  CD2 PHE    76      19.288  97.317   7.623  1.00 26.30           C   
ATOM   1210  C   PHE    76      15.050  95.794   9.041  1.00 27.35           C   
ATOM   1211  O   PHE    76      14.829  96.776   9.744  1.00 29.26           O   
ATOM   1213  N   GLY    77      14.181  94.808   8.863  1.00 27.78           N   
ATOM   1214  CA  GLY    77      12.875  94.781   9.501  1.00 29.70           C   
ATOM   1217  C   GLY    77      11.931  95.850   9.011  1.00 28.53           C   
ATOM   1218  O   GLY    77      11.013  96.195   9.730  1.00 28.30           O   
ATOM   1220  N   GLU    78      12.156  96.371   7.801  1.00 27.48           N   
ATOM   1221  CA  GLU    78      11.384  97.490   7.258  1.00 30.34           C   
ATOM   1223  CB  GLU    78       9.998  97.016   6.796  1.00 31.96           C   
ATOM   1226  CG  GLU    78      10.065  95.856   5.797  1.00 35.53           C   
ATOM   1229  CD  GLU    78       8.714  95.479   5.252  1.00 40.39           C   
ATOM   1230  OE1 GLU    78       7.748  95.416   6.048  1.00 54.01           O   
ATOM   1231  OE2 GLU    78       8.617  95.239   4.030  1.00 53.10           O   
ATOM   1232  C   GLU    78      11.270  98.605   8.299  1.00 28.44           C   
ATOM   1233  O   GLU    78      10.194  99.073   8.621  1.00 26.86           O   
ATOM   1235  N   SER    79      12.403  99.039   8.822  1.00 27.51           N   
ATOM   1236  CA  SER    79      12.393  99.952   9.967  1.00 28.88           C   
ATOM   1238  CB  SER    79      13.504  99.555  10.943  1.00 26.12           C   
ATOM   1241  OG  SER    79      13.259  98.271  11.445  1.00 27.38           O   
ATOM   1243  C   SER    79      12.519 101.437   9.587  1.00 27.36           C   
ATOM   1244  O   SER    79      12.612 102.287  10.467  1.00 28.09           O   
ATOM   1246  N   GLU    80      12.518 101.735   8.286  1.00 27.52           N   
ATOM   1247  CA  GLU    80      12.566 103.101   7.791  1.00 28.81           C   
ATOM   1249  CB  GLU    80      13.997 103.434   7.353  1.00 29.69           C   
ATOM   1252  CG  GLU    80      14.280 104.909   7.193  1.00 30.19           C   
ATOM   1255  CD  GLU    80      14.349 105.627   8.520  1.00 33.10           C   
ATOM   1256  OE1 GLU    80      13.291 105.720   9.178  1.00 30.57           O   
ATOM   1257  OE2 GLU    80      15.453 106.090   8.907  1.00 30.03           O   
ATOM   1258  C   GLU    80      11.599 103.263   6.631  1.00 27.91           C   
ATOM   1259  O   GLU    80      12.021 103.551   5.507  1.00 28.51           O   
ATOM   1261  N   PRO    81      10.292 103.058   6.896  1.00 29.07           N   
ATOM   1262  CA  PRO    81       9.265 103.141   5.869  1.00 28.77           C   
ATOM   1264  CB  PRO    81       8.024 102.563   6.585  1.00 31.68           C   
ATOM   1267  CG  PRO    81       8.233 102.912   8.012  1.00 30.31           C   
ATOM   1270  CD  PRO    81       9.709 102.709   8.212  1.00 28.37           C   
ATOM   1273  C   PRO    81       8.945 104.543   5.301  1.00 29.30           C   
ATOM   1274  O   PRO    81       8.456 104.621   4.167  1.00 28.30           O   
ATOM   1275  N   ARG    82       9.205 105.620   6.047  1.00 28.52           N   
ATOM   1276  CA  ARG    82       8.801 106.970   5.625  1.00 29.08           C   
ATOM   1278  CB  ARG    82       8.728 107.928   6.819  1.00 29.58           C   
ATOM   1281  CG  ARG    82       7.917 107.449   8.027  1.00 34.40           C   
ATOM   1284  CD  ARG    82       6.586 106.879   7.639  1.00 44.17           C   
ATOM   1287  NE  ARG    82       5.790 107.819   6.853  1.00 51.65           N   
ATOM   1289  CZ  ARG    82       4.980 107.477   5.849  1.00 53.71           C   
ATOM   1290  NH1 ARG    82       4.307 108.420   5.202  1.00 50.80           N   
ATOM   1293  NH2 ARG    82       4.843 106.205   5.470  1.00 54.42           N   
ATOM   1296  C   ARG    82       9.760 107.551   4.577  1.00 30.48           C   
ATOM   1297  O   ARG    82      10.914 107.107   4.487  1.00 30.56           O   
ATOM   1299  N   PRO    83       9.283 108.530   3.776  1.00 30.86           N   
ATOM   1300  CA  PRO    83      10.160 109.226   2.824  1.00 31.15           C   
ATOM   1302  CB  PRO    83       9.222 110.241   2.147  1.00 32.56           C   
ATOM   1305  CG  PRO    83       7.853 109.675   2.324  1.00 31.88           C   
ATOM   1308  CD  PRO    83       7.887 109.013   3.674  1.00 30.70           C   
ATOM   1311  C   PRO    83      11.337 109.937   3.484  1.00 30.14           C   
ATOM   1312  O   PRO    83      11.249 110.363   4.636  1.00 28.86           O   
ATOM   1313  N   SER    84      12.422 110.065   2.733  1.00 27.96           N   
ATOM   1314  CA  SER    84      13.682 110.634   3.224  1.00 27.85           C   
ATOM   1316  CB  SER    84      14.683 110.721   2.070  1.00 27.62           C   
ATOM   1319  OG  SER    84      15.065 109.419   1.665  1.00 28.29           O   
ATOM   1321  C   SER    84      13.553 111.997   3.902  1.00 28.57           C   
ATOM   1322  O   SER    84      14.196 112.240   4.922  1.00 28.38           O   
ATOM   1324  N   LYS    85      12.733 112.887   3.337  1.00 27.24           N   
ATOM   1325  CA  LYS    85      12.537 114.208   3.923  1.00 30.63           C   
ATOM   1327  CB  LYS    85      11.777 115.137   2.950  1.00 30.86           C   
ATOM   1330  CG  LYS    85      11.864 116.614   3.295  1.00 38.04           C   
ATOM   1333  CD  LYS    85      11.239 117.503   2.202  1.00 35.94           C   
ATOM   1338  C   LYS    85      11.837 114.120   5.288  1.00 29.07           C   
ATOM   1339  O   LYS    85      12.152 114.892   6.190  1.00 27.35           O   
ATOM   1341  N   GLU    86      10.907 113.177   5.438  1.00 28.90           N   
ATOM   1342  CA  GLU    86      10.265 112.901   6.737  1.00 31.25           C   
ATOM   1344  CB  GLU    86       9.089 111.934   6.580  1.00 31.51           C   
ATOM   1347  CG  GLU    86       7.819 112.523   5.990  1.00 40.24           C   
ATOM   1350  CD  GLU    86       6.616 111.605   6.193  1.00 38.52           C   
ATOM   1351  OE1 GLU    86       6.566 110.904   7.237  1.00 50.00           O   
ATOM   1352  OE2 GLU    86       5.735 111.588   5.308  1.00 50.11           O   
ATOM   1353  C   GLU    86      11.209 112.289   7.768  1.00 29.07           C   
ATOM   1354  O   GLU    86      11.083 112.543   8.954  1.00 27.41           O   
ATOM   1356  N   VAL    87      12.129 111.441   7.320  1.00 29.08           N   
ATOM   1357  CA  VAL    87      13.101 110.844   8.215  1.00 26.19           C   
ATOM   1359  CB  VAL    87      14.032 109.828   7.480  1.00 27.96           C   
ATOM   1361  CG1 VAL    87      15.124 109.356   8.402  1.00 28.46           C   
ATOM   1365  CG2 VAL    87      13.227 108.644   6.941  1.00 24.70           C   
ATOM   1369  C   VAL    87      13.958 111.934   8.833  1.00 29.90           C   
ATOM   1370  O   VAL    87      14.201 111.937  10.041  1.00 28.83           O   
ATOM   1372  N   GLU    88      14.446 112.852   8.000  1.00 29.40           N   
ATOM   1373  CA  GLU    88      15.230 113.975   8.496  1.00 29.38           C   
ATOM   1375  CB  GLU    88      15.694 114.862   7.345  1.00 27.93           C   
ATOM   1378  CG  GLU    88      16.477 116.070   7.799  1.00 32.11           C   
ATOM   1381  CD  GLU    88      16.959 116.918   6.629  1.00 31.85           C   
ATOM   1382  OE1 GLU    88      16.136 117.226   5.737  1.00 33.91           O   
ATOM   1383  OE2 GLU    88      18.163 117.258   6.610  1.00 39.54           O   
ATOM   1384  C   GLU    88      14.450 114.820   9.510  1.00 29.26           C   
ATOM   1385  O   GLU    88      14.995 115.211  10.537  1.00 31.08           O   
ATOM   1387  N   SER    89      13.193 115.120   9.223  1.00 30.37           N   
ATOM   1388  CA  SER    89      12.398 115.913  10.166  1.00 33.23           C   
ATOM   1390  CB  SER    89      11.137 116.497   9.508  1.00 36.48           C   
ATOM   1393  OG  SER    89      10.499 115.569   8.661  1.00 45.37           O   
ATOM   1395  C   SER    89      12.089 115.135  11.459  1.00 33.11           C   
ATOM   1396  O   SER    89      12.091 115.720  12.530  1.00 33.55           O   
ATOM   1398  N   PHE    90      11.882 113.820  11.361  1.00 33.01           N   
ATOM   1399  CA  PHE    90      11.763 112.943  12.540  1.00 32.27           C   
ATOM   1401  CB  PHE    90      11.696 111.473  12.097  1.00 33.62           C   
ATOM   1404  CG  PHE    90      11.766 110.470  13.237  1.00 32.52           C   
ATOM   1405  CD1 PHE    90      10.620 110.110  13.940  1.00 37.38           C   
ATOM   1407  CE1 PHE    90      10.690 109.175  14.989  1.00 37.05           C   
ATOM   1409  CZ  PHE    90      11.915 108.608  15.336  1.00 28.50           C   
ATOM   1411  CE2 PHE    90      13.049 108.956  14.642  1.00 35.80           C   
ATOM   1413  CD2 PHE    90      12.972 109.887  13.592  1.00 31.95           C   
ATOM   1415  C   PHE    90      12.931 113.135  13.498  1.00 31.55           C   
ATOM   1416  O   PHE    90      12.741 113.404  14.695  1.00 30.76           O   
ATOM   1418  N   ALA    91      14.137 113.003  12.961  1.00 29.57           N   
ATOM   1419  CA  ALA    91      15.353 113.096  13.760  1.00 31.68           C   
ATOM   1421  CB  ALA    91      16.572 112.773  12.896  1.00 31.06           C   
ATOM   1425  C   ALA    91      15.470 114.496  14.380  1.00 32.59           C   
ATOM   1426  O   ALA    91      15.729 114.644  15.574  1.00 30.47           O   
ATOM   1428  N   ARG    92      15.239 115.529  13.577  1.00 32.13           N   
ATOM   1429  CA  ARG    92      15.364 116.902  14.077  1.00 33.96           C   
ATOM   1431  CB  ARG    92      15.346 117.888  12.922  1.00 36.79           C   
ATOM   1434  CG  ARG    92      16.600 117.764  12.066  1.00 44.94           C   
ATOM   1437  CD  ARG    92      16.497 118.659  10.864  1.00 55.66           C   
ATOM   1440  NE  ARG    92      17.789 118.895  10.230  1.00 58.24           N   
ATOM   1442  CZ  ARG    92      17.933 119.497   9.054  1.00 58.86           C   
ATOM   1443  NH1 ARG    92      16.868 119.914   8.384  1.00 57.38           N   
ATOM   1446  NH2 ARG    92      19.149 119.687   8.543  1.00 59.87           N   
ATOM   1449  C   ARG    92      14.288 117.252  15.107  1.00 32.87           C   
ATOM   1450  O   ARG    92      14.582 117.850  16.133  1.00 31.93           O   
ATOM   1452  N   LYS    93      13.058 116.826  14.847  1.00 31.73           N   
ATOM   1453  CA  LYS    93      11.938 117.116  15.727  1.00 32.05           C   
ATOM   1455  CB  LYS    93      10.609 116.718  15.066  1.00 32.78           C   
ATOM   1458  CG  LYS    93       9.371 116.909  15.950  1.00 34.33           C   
ATOM   1464  C   LYS    93      12.052 116.413  17.065  1.00 32.28           C   
ATOM   1465  O   LYS    93      11.817 117.029  18.111  1.00 33.39           O   
ATOM   1467  N   ASN    94      12.377 115.126  17.027  1.00 31.10           N   
ATOM   1468  CA  ASN    94      12.362 114.300  18.229  1.00 33.26           C   
ATOM   1470  CB  ASN    94      11.944 112.863  17.886  1.00 34.55           C   
ATOM   1473  CG  ASN    94      10.494 112.771  17.425  1.00 37.29           C   
ATOM   1474  OD1 ASN    94      10.208 112.277  16.336  1.00 42.45           O   
ATOM   1475  ND2 ASN    94       9.584 113.273  18.235  1.00 30.75           N   
ATOM   1478  C   ASN    94      13.667 114.310  19.016  1.00 33.93           C   
ATOM   1479  O   ASN    94      13.645 114.089  20.218  1.00 32.32           O   
ATOM   1481  N   TYR    95      14.788 114.591  18.352  1.00 33.08           N   
ATOM   1482  CA  TYR    95      16.097 114.558  19.011  1.00 33.80           C   
ATOM   1484  CB  TYR    95      16.912 113.372  18.463  1.00 31.72           C   
ATOM   1487  CG  TYR    95      16.213 112.087  18.792  1.00 28.65           C   
ATOM   1488  CD1 TYR    95      16.237 111.578  20.095  1.00 33.14           C   
ATOM   1490  CE1 TYR    95      15.562 110.414  20.419  1.00 32.18           C   
ATOM   1492  CZ  TYR    95      14.828 109.770  19.450  1.00 28.16           C   
ATOM   1493  OH  TYR    95      14.129 108.625  19.759  1.00 32.06           O   
ATOM   1495  CE2 TYR    95      14.762 110.278  18.169  1.00 29.06           C   
ATOM   1497  CD2 TYR    95      15.450 111.432  17.848  1.00 28.76           C   
ATOM   1499  C   TYR    95      16.897 115.851  18.946  1.00 33.23           C   
ATOM   1500  O   TYR    95      17.850 116.034  19.697  1.00 33.93           O   
ATOM   1502  N   GLY    96      16.511 116.762  18.068  1.00 33.77           N   
ATOM   1503  CA  GLY    96      17.263 118.001  17.895  1.00 33.96           C   
ATOM   1506  C   GLY    96      18.692 117.764  17.435  1.00 35.92           C   
ATOM   1507  O   GLY    96      19.589 118.562  17.755  1.00 35.78           O   
ATOM   1509  N   VAL    97      18.916 116.690  16.673  1.00 35.11           N   
ATOM   1510  CA  VAL    97      20.240 116.418  16.142  1.00 36.43           C   
ATOM   1512  CB  VAL    97      20.413 114.970  15.617  1.00 38.31           C   
ATOM   1514  CG1 VAL    97      20.142 113.960  16.729  1.00 38.76           C   
ATOM   1518  CG2 VAL    97      19.543 114.700  14.397  1.00 37.76           C   
ATOM   1522  C   VAL    97      20.576 117.415  15.037  1.00 35.77           C   
ATOM   1523  O   VAL    97      19.695 117.859  14.285  1.00 36.26           O   
ATOM   1525  N   THR    98      21.853 117.772  14.961  1.00 34.73           N   
ATOM   1526  CA  THR    98      22.336 118.678  13.938  1.00 34.24           C   
ATOM   1528  CB  THR    98      23.014 119.923  14.563  1.00 34.29           C   
ATOM   1530  OG1 THR    98      24.165 119.507  15.309  1.00 40.12           O   
ATOM   1532  CG2 THR    98      22.032 120.685  15.496  1.00 35.02           C   
ATOM   1536  C   THR    98      23.320 117.994  12.993  1.00 34.15           C   
ATOM   1537  O   THR    98      23.850 118.646  12.091  1.00 34.45           O   
ATOM   1539  N   PHE    99      23.572 116.699  13.187  1.00 31.30           N   
ATOM   1540  CA  PHE    99      24.404 115.950  12.244  1.00 29.34           C   
ATOM   1542  CB  PHE    99      25.027 114.676  12.852  1.00 29.00           C   
ATOM   1545  CG  PHE    99      24.041 113.681  13.437  1.00 27.85           C   
ATOM   1546  CD1 PHE    99      23.964 113.505  14.816  1.00 30.03           C   
ATOM   1548  CE1 PHE    99      23.099 112.566  15.376  1.00 30.17           C   
ATOM   1550  CZ  PHE    99      22.308 111.774  14.560  1.00 29.29           C   
ATOM   1552  CE2 PHE    99      22.380 111.942  13.172  1.00 32.16           C   
ATOM   1554  CD2 PHE    99      23.258 112.870  12.622  1.00 26.54           C   
ATOM   1556  C   PHE    99      23.596 115.651  10.976  1.00 29.46           C   
ATOM   1557  O   PHE    99      22.367 115.664  11.009  1.00 29.75           O   
ATOM   1559  N   PRO   100      24.277 115.478   9.842  1.00 30.96           N   
ATOM   1560  CA  PRO   100      23.579 115.194   8.591  1.00 32.54           C   
ATOM   1562  CB  PRO   100      24.700 115.232   7.534  1.00 30.74           C   
ATOM   1565  CG  PRO   100      25.926 115.015   8.275  1.00 33.41           C   
ATOM   1568  CD  PRO   100      25.720 115.645   9.620  1.00 31.74           C   
ATOM   1571  C   PRO   100      22.850 113.854   8.538  1.00 30.36           C   
ATOM   1572  O   PRO   100      23.399 112.808   8.913  1.00 28.53           O   
ATOM   1573  N   ILE   101      21.601 113.939   8.083  1.00 30.06           N   
ATOM   1574  CA  ILE   101      20.782 112.788   7.771  0.50 29.51           C   
ATOM   1578  CB  ILE   101      19.383 112.879   8.421  0.50 30.88           C   
ATOM   1582  CG1 ILE   101      19.483 113.076   9.942  0.50 34.16           C   
ATOM   1588  CD1 ILE   101      20.062 111.893  10.683  0.50 35.52           C   
ATOM   1596  CG2 ILE   101      18.551 111.628   8.088  0.50 27.04           C   
ATOM   1604  C   ILE   101      20.628 112.787   6.249  1.00 29.22           C   
ATOM   1605  O   ILE   101      19.947 113.640   5.700  1.00 29.74           O   
ATOM   1607  N   PHE   102      21.254 111.823   5.584  1.00 27.89           N   
ATOM   1608  CA  PHE   102      21.267 111.772   4.132  1.00 27.80           C   
ATOM   1610  CB  PHE   102      22.543 111.054   3.665  1.00 28.45           C   
ATOM   1613  CG  PHE   102      23.801 111.828   3.957  1.00 29.33           C   
ATOM   1614  CD1 PHE   102      24.200 112.860   3.121  1.00 30.75           C   
ATOM   1616  CE1 PHE   102      25.354 113.601   3.400  1.00 29.63           C   
ATOM   1618  CZ  PHE   102      26.099 113.308   4.526  1.00 30.33           C   
ATOM   1620  CE2 PHE   102      25.700 112.266   5.374  1.00 29.17           C   
ATOM   1622  CD2 PHE   102      24.559 111.550   5.090  1.00 29.16           C   
ATOM   1624  C   PHE   102      20.019 111.084   3.607  1.00 28.23           C   
ATOM   1625  O   PHE   102      19.164 110.653   4.383  1.00 27.44           O   
ATOM   1627  N   HIS   103      19.911 110.985   2.286  1.00 27.68           N   
ATOM   1628  CA  HIS   103      18.810 110.270   1.662  1.00 26.40           C   
ATOM   1630  CB  HIS   103      18.894 110.450   0.141  1.00 26.42           C   
ATOM   1633  CG  HIS   103      17.622 110.164  -0.589  1.00 25.59           C   
ATOM   1634  ND1 HIS   103      17.189 108.883  -0.859  1.00 29.35           N   
ATOM   1636  CE1 HIS   103      16.057 108.938  -1.537  1.00 34.11           C   
ATOM   1638  NE2 HIS   103      15.744 110.210  -1.724  1.00 29.40           N   
ATOM   1640  CD2 HIS   103      16.716 110.998  -1.156  1.00 27.52           C   
ATOM   1642  C   HIS   103      18.856 108.788   2.034  1.00 26.10           C   
ATOM   1643  O   HIS   103      19.928 108.203   2.198  1.00 26.81           O   
ATOM   1645  N   LYS   104      17.682 108.188   2.158  1.00 26.83           N   
ATOM   1646  CA  LYS   104      17.566 106.758   2.327  1.00 27.52           C   
ATOM   1648  CB  LYS   104      16.096 106.351   2.317  1.00 29.33           C   
ATOM   1651  CG  LYS   104      15.793 104.976   2.893  1.00 31.62           C   
ATOM   1654  CD  LYS   104      14.318 104.590   2.623  1.00 32.33           C   
ATOM   1657  CE  LYS   104      13.315 105.540   3.269  1.00 33.08           C   
ATOM   1660  NZ  LYS   104      11.921 105.049   3.080  1.00 25.60           N   
ATOM   1664  C   LYS   104      18.324 106.039   1.202  1.00 27.93           C   
ATOM   1665  O   LYS   104      18.262 106.450   0.028  1.00 25.95           O   
ATOM   1667  N   ILE   105      19.018 104.965   1.575  1.00 26.11           N   
ATOM   1668  CA  ILE   105      19.799 104.174   0.639  1.00 27.19           C   
ATOM   1670  CB  ILE   105      21.311 104.369   0.870  1.00 27.08           C   
ATOM   1672  CG1 ILE   105      21.702 103.961   2.295  1.00 27.13           C   
ATOM   1675  CD1 ILE   105      23.192 103.717   2.492  1.00 25.89           C   
ATOM   1679  CG2 ILE   105      21.697 105.806   0.597  1.00 27.75           C   
ATOM   1683  C   ILE   105      19.465 102.703   0.776  1.00 27.78           C   
ATOM   1684  O   ILE   105      18.798 102.282   1.739  1.00 26.73           O   
ATOM   1686  N   LYS   106      19.924 101.930  -0.204  1.00 28.31           N   
ATOM   1687  CA  LYS   106      20.016 100.483  -0.073  1.00 30.69           C   
ATOM   1689  CB  LYS   106      19.623  99.774  -1.359  1.00 29.77           C   
ATOM   1692  CG  LYS   106      18.175  99.991  -1.708  1.00 37.12           C   
ATOM   1695  CD  LYS   106      17.731  99.119  -2.839  1.00 40.47           C   
ATOM   1698  CE  LYS   106      16.216  99.182  -3.013  1.00 51.60           C   
ATOM   1701  NZ  LYS   106      15.761  98.180  -4.021  1.00 59.57           N   
ATOM   1705  C   LYS   106      21.447 100.148   0.309  1.00 28.68           C   
ATOM   1706  O   LYS   106      22.385 100.842  -0.099  1.00 30.20           O   
ATOM   1708  N   ILE   107      21.595  99.100   1.115  1.00 27.58           N   
ATOM   1709  CA  ILE   107      22.898  98.631   1.581  1.00 28.92           C   
ATOM   1711  CB  ILE   107      23.034  98.745   3.136  1.00 29.79           C   
ATOM   1713  CG1 ILE   107      22.967 100.220   3.544  1.00 29.45           C   
ATOM   1716  CD1 ILE   107      23.032 100.483   5.067  1.00 29.71           C   
ATOM   1720  CG2 ILE   107      24.314  98.079   3.617  1.00 27.96           C   
ATOM   1724  C   ILE   107      23.149  97.217   1.117  1.00 28.12           C   
ATOM   1725  O   ILE   107      24.230  96.927   0.630  1.00 29.80           O   
ATOM   1727  N   LEU   108      22.147  96.349   1.262  1.00 28.59           N   
ATOM   1728  CA  LEU   108      22.217  94.977   0.801  1.00 30.72           C   
ATOM   1730  CB  LEU   108      21.269  94.077   1.620  1.00 31.17           C   
ATOM   1733  CG  LEU   108      21.254  94.215   3.151  1.00 33.04           C   
ATOM   1735  CD1 LEU   108      20.168  93.357   3.776  1.00 31.90           C   
ATOM   1739  CD2 LEU   108      22.623  93.878   3.732  1.00 28.71           C   
ATOM   1743  C   LEU   108      21.828  94.892  -0.693  1.00 35.65           C   
ATOM   1744  O   LEU   108      21.019  95.695  -1.213  1.00 34.78           O   
ATOM   1746  N   GLY   109      22.375  93.889  -1.363  1.00 39.46           N   
ATOM   1747  CA  GLY   109      21.921  93.520  -2.712  1.00 42.10           C   
ATOM   1750  C   GLY   109      22.677  94.210  -3.829  1.00 42.00           C   
ATOM   1751  O   GLY   109      23.630  94.947  -3.589  1.00 45.04           O   
ATOM   1753  N   SER   110      22.226  93.978  -5.057  1.00 43.40           N   
ATOM   1754  CA  SER   110      22.914  94.482  -6.253  1.00 44.55           C   
ATOM   1756  CB  SER   110      22.281  93.891  -7.525  1.00 45.66           C   
ATOM   1759  OG  SER   110      20.954  94.369  -7.715  1.00 49.64           O   
ATOM   1761  C   SER   110      22.927  96.012  -6.352  1.00 44.43           C   
ATOM   1762  O   SER   110      23.852  96.584  -6.922  1.00 45.26           O   
ATOM   1764  N   GLU   111      21.903  96.664  -5.801  1.00 45.50           N   
ATOM   1765  CA  GLU   111      21.771  98.122  -5.885  1.00 45.31           C   
ATOM   1767  CB  GLU   111      20.296  98.513  -6.047  1.00 45.28           C   
ATOM   1770  CG  GLU   111      19.643  98.013  -7.328  1.00 52.28           C   
ATOM   1773  CD  GLU   111      18.162  98.346  -7.397  1.00 53.23           C   
ATOM   1774  OE1 GLU   111      17.561  98.686  -6.348  1.00 60.44           O   
ATOM   1775  OE2 GLU   111      17.597  98.264  -8.510  1.00 68.05           O   
ATOM   1776  C   GLU   111      22.351  98.862  -4.673  1.00 42.31           C   
ATOM   1777  O   GLU   111      21.980 100.017  -4.426  1.00 41.85           O   
ATOM   1779  N   GLY   112      23.243  98.210  -3.920  1.00 38.99           N   
ATOM   1780  CA  GLY   112      23.796  98.796  -2.701  1.00 34.93           C   
ATOM   1783  C   GLY   112      24.530 100.090  -3.005  1.00 32.34           C   
ATOM   1784  O   GLY   112      25.279 100.142  -3.954  1.00 31.07           O   
ATOM   1786  N   GLU   113      24.291 101.131  -2.204  1.00 29.44           N   
ATOM   1787  CA  GLU   113      24.915 102.446  -2.376  1.00 30.16           C   
ATOM   1789  CB  GLU   113      24.495 103.377  -1.225  1.00 30.67           C   
ATOM   1792  CG  GLU   113      24.918 104.824  -1.399  1.00 31.75           C   
ATOM   1795  CD  GLU   113      24.112 105.554  -2.446  1.00 39.02           C   
ATOM   1796  OE1 GLU   113      23.061 105.025  -2.877  1.00 42.91           O   
ATOM   1797  OE2 GLU   113      24.527 106.663  -2.828  1.00 41.76           O   
ATOM   1798  C   GLU   113      26.448 102.344  -2.383  1.00 29.83           C   
ATOM   1799  O   GLU   113      27.027 101.936  -1.393  1.00 27.86           O   
ATOM   1801  N   PRO   114      27.104 102.713  -3.494  1.00 28.25           N   
ATOM   1802  CA  PRO   114      28.581 102.581  -3.551  1.00 29.47           C   
ATOM   1804  CB  PRO   114      28.947 103.344  -4.829  1.00 29.03           C   
ATOM   1807  CG  PRO   114      27.746 103.148  -5.715  1.00 30.01           C   
ATOM   1810  CD  PRO   114      26.547 103.163  -4.783  1.00 30.62           C   
ATOM   1813  C   PRO   114      29.366 103.122  -2.335  1.00 27.68           C   
ATOM   1814  O   PRO   114      30.298 102.474  -1.885  1.00 27.74           O   
ATOM   1815  N   ALA   115      28.992 104.288  -1.806  1.00 28.91           N   
ATOM   1816  CA  ALA   115      29.683 104.857  -0.652  1.00 28.07           C   
ATOM   1818  CB  ALA   115      29.123 106.263  -0.293  1.00 28.33           C   
ATOM   1822  C   ALA   115      29.604 103.927   0.562  1.00 29.05           C   
ATOM   1823  O   ALA   115      30.586 103.718   1.249  1.00 27.89           O   
ATOM   1825  N   PHE   116      28.432 103.356   0.815  1.00 29.98           N   
ATOM   1826  CA  PHE   116      28.295 102.432   1.934  1.00 28.60           C   
ATOM   1828  CB  PHE   116      26.839 102.272   2.329  1.00 28.65           C   
ATOM   1831  CG  PHE   116      26.646 102.103   3.808  1.00 27.83           C   
ATOM   1832  CD1 PHE   116      26.248 103.167   4.587  1.00 25.96           C   
ATOM   1834  CE1 PHE   116      26.089 103.016   5.962  1.00 28.49           C   
ATOM   1836  CZ  PHE   116      26.347 101.782   6.564  1.00 31.92           C   
ATOM   1838  CE2 PHE   116      26.770 100.727   5.795  1.00 29.70           C   
ATOM   1840  CD2 PHE   116      26.913 100.881   4.423  1.00 28.00           C   
ATOM   1842  C   PHE   116      28.961 101.070   1.662  1.00 29.05           C   
ATOM   1843  O   PHE   116      29.528 100.485   2.560  1.00 28.00           O   
ATOM   1845  N   ARG   117      28.932 100.593   0.422  1.00 29.72           N   
ATOM   1846  CA  ARG   117      29.624  99.346   0.060  1.00 29.05           C   
ATOM   1848  CB  ARG   117      29.305  98.941  -1.391  1.00 29.89           C   
ATOM   1851  CG  ARG   117      27.837  98.617  -1.678  1.00 31.60           C   
ATOM   1854  CD  ARG   117      27.248  97.566  -0.749  1.00 30.09           C   
ATOM   1857  NE  ARG   117      28.027  96.329  -0.729  1.00 29.30           N   
ATOM   1859  CZ  ARG   117      27.770  95.285   0.058  1.00 32.13           C   
ATOM   1860  NH1 ARG   117      26.734  95.287   0.891  1.00 30.86           N   
ATOM   1863  NH2 ARG   117      28.544  94.213  -0.005  1.00 33.31           N   
ATOM   1866  C   ARG   117      31.148  99.458   0.254  1.00 29.09           C   
ATOM   1867  O   ARG   117      31.827  98.462   0.492  1.00 30.17           O   
ATOM   1869  N   PHE   118      31.678 100.664   0.131  1.00 28.76           N   
ATOM   1870  CA  PHE   118      33.080 100.947   0.459  1.00 29.33           C   
ATOM   1872  CB  PHE   118      33.394 102.435   0.242  1.00 29.83           C   
ATOM   1875  CG  PHE   118      34.796 102.809   0.603  1.00 28.72           C   
ATOM   1876  CD1 PHE   118      35.831 102.607  -0.294  1.00 30.83           C   
ATOM   1878  CE1 PHE   118      37.156 102.957   0.055  1.00 29.86           C   
ATOM   1880  CZ  PHE   118      37.419 103.487   1.302  1.00 28.75           C   
ATOM   1882  CE2 PHE   118      36.379 103.663   2.213  1.00 29.22           C   
ATOM   1884  CD2 PHE   118      35.086 103.341   1.855  1.00 34.13           C   
ATOM   1886  C   PHE   118      33.389 100.589   1.911  1.00 27.04           C   
ATOM   1887  O   PHE   118      34.396  99.964   2.198  1.00 28.31           O   
ATOM   1889  N   LEU   119      32.502 100.991   2.804  1.00 27.12           N   
ATOM   1890  CA  LEU   119      32.611 100.672   4.215  1.00 27.76           C   
ATOM   1892  CB  LEU   119      31.472 101.349   5.010  1.00 27.48           C   
ATOM   1895  CG  LEU   119      31.357 102.882   4.951  1.00 26.39           C   
ATOM   1897  CD1 LEU   119      30.096 103.327   5.712  1.00 27.63           C   
ATOM   1901  CD2 LEU   119      32.588 103.643   5.508  1.00 24.86           C   
ATOM   1905  C   LEU   119      32.597  99.175   4.446  1.00 28.84           C   
ATOM   1906  O   LEU   119      33.401  98.661   5.229  1.00 29.67           O   
ATOM   1908  N   VAL   120      31.673  98.483   3.768  1.00 28.66           N   
ATOM   1909  CA  VAL   120      31.503  97.023   3.882  1.00 28.79           C   
ATOM   1911  CB  VAL   120      30.203  96.549   3.148  1.00 27.38           C   
ATOM   1913  CG1 VAL   120      30.069  95.008   3.129  1.00 26.61           C   
ATOM   1917  CG2 VAL   120      28.969  97.224   3.791  1.00 29.12           C   
ATOM   1921  C   VAL   120      32.717  96.288   3.341  1.00 29.24           C   
ATOM   1922  O   VAL   120      33.251  95.394   3.993  1.00 28.67           O   
ATOM   1924  N   ASP   121      33.180  96.696   2.166  1.00 30.90           N   
ATOM   1925  CA  ASP   121      34.324  96.053   1.530  1.00 31.10           C   
ATOM   1927  CB  ASP   121      34.463  96.562   0.086  1.00 34.09           C   
ATOM   1930  CG  ASP   121      33.273  96.162  -0.816  1.00 40.21           C   
ATOM   1931  OD1 ASP   121      32.493  95.244  -0.466  1.00 41.65           O   
ATOM   1932  OD2 ASP   121      33.123  96.786  -1.888  1.00 44.66           O   
ATOM   1933  C   ASP   121      35.625  96.283   2.300  1.00 32.47           C   
ATOM   1934  O   ASP   121      36.498  95.410   2.323  1.00 31.31           O   
ATOM   1936  N   SER   122      35.756  97.460   2.906  1.00 31.55           N   
ATOM   1937  CA  SER   122      36.935  97.817   3.704  1.00 34.54           C   
ATOM   1939  CB  SER   122      36.929  99.318   4.025  1.00 36.60           C   
ATOM   1942  OG  SER   122      37.081 100.118   2.871  1.00 36.53           O   
ATOM   1944  C   SER   122      36.993  97.027   5.016  1.00 33.34           C   
ATOM   1945  O   SER   122      38.024  96.496   5.378  1.00 32.67           O   
ATOM   1947  N   SER   123      35.872  96.984   5.724  1.00 31.74           N   
ATOM   1948  CA  SER   123      35.795  96.325   7.021  1.00 31.91           C   
ATOM   1950  CB  SER   123      34.650  96.956   7.799  1.00 29.35           C   
ATOM   1953  OG  SER   123      33.434  96.660   7.132  1.00 31.12           O   
ATOM   1955  C   SER   123      35.542  94.815   6.919  1.00 32.46           C   
ATOM   1956  O   SER   123      35.735  94.100   7.889  1.00 30.85           O   
ATOM   1958  N   LYS   124      35.064  94.374   5.748  1.00 29.13           N   
ATOM   1959  CA  LYS   124      34.546  93.031   5.503  1.00 30.92           C   
ATOM   1961  CB  LYS   124      35.651  91.964   5.615  1.00 32.43           C   
ATOM   1964  CG  LYS   124      36.874  92.272   4.768  1.00 34.55           C   
ATOM   1967  CD  LYS   124      36.542  92.234   3.288  1.00 41.11           C   
ATOM   1972  C   LYS   124      33.334  92.708   6.390  1.00 31.80           C   
ATOM   1973  O   LYS   124      33.066  91.550   6.674  1.00 30.18           O   
ATOM   1975  N   LYS   125      32.587  93.738   6.800  1.00 29.72           N   
ATOM   1976  CA  LYS   125      31.391  93.543   7.602  1.00 30.37           C   
ATOM   1978  CB  LYS   125      31.599  94.063   9.026  1.00 29.96           C   
ATOM   1981  CG  LYS   125      32.739  93.422   9.768  1.00 35.46           C   
ATOM   1984  CD  LYS   125      32.484  91.964  10.118  1.00 40.08           C   
ATOM   1987  CE  LYS   125      33.818  91.288  10.467  1.00 48.50           C   
ATOM   1990  NZ  LYS   125      33.701  89.828  10.487  1.00 51.21           N   
ATOM   1994  C   LYS   125      30.209  94.266   6.996  1.00 29.73           C   
ATOM   1995  O   LYS   125      30.165  95.515   6.965  1.00 31.31           O   
ATOM   1997  N   GLU   126      29.240  93.479   6.563  1.00 28.81           N   
ATOM   1998  CA  GLU   126      27.990  93.968   6.041  1.00 30.22           C   
ATOM   2000  CB  GLU   126      27.454  92.997   4.972  1.00 29.05           C   
ATOM   2003  CG  GLU   126      26.159  93.446   4.331  1.00 31.69           C   
ATOM   2006  CD  GLU   126      25.674  92.508   3.247  1.00 33.88           C   
ATOM   2007  OE1 GLU   126      25.264  91.363   3.556  1.00 36.21           O   
ATOM   2008  OE2 GLU   126      25.671  92.930   2.075  1.00 29.63           O   
ATOM   2009  C   GLU   126      27.014  94.067   7.209  1.00 28.28           C   
ATOM   2010  O   GLU   126      26.892  93.126   7.983  1.00 27.97           O   
ATOM   2012  N   PRO   127      26.303  95.202   7.337  1.00 26.68           N   
ATOM   2013  CA  PRO   127      25.285  95.291   8.365  1.00 26.82           C   
ATOM   2015  CB  PRO   127      24.603  96.638   8.070  1.00 27.30           C   
ATOM   2018  CG  PRO   127      25.642  97.443   7.410  1.00 27.54           C   
ATOM   2021  CD  PRO   127      26.431  96.457   6.585  1.00 26.06           C   
ATOM   2024  C   PRO   127      24.244  94.179   8.308  1.00 26.60           C   
ATOM   2025  O   PRO   127      23.793  93.798   7.232  1.00 26.62           O   
ATOM   2026  N   ARG   128      23.848  93.709   9.483  1.00 26.54           N   
ATOM   2027  CA  ARG   128      22.837  92.682   9.623  1.00 26.74           C   
ATOM   2029  CB  ARG   128      23.439  91.502  10.393  1.00 26.78           C   
ATOM   2032  CG  ARG   128      24.511  90.714   9.573  1.00 30.09           C   
ATOM   2035  CD  ARG   128      23.897  89.537   8.815  1.00 27.91           C   
ATOM   2038  NE  ARG   128      23.027  89.961   7.724  1.00 31.10           N   
ATOM   2040  CZ  ARG   128      23.452  90.357   6.523  1.00 34.30           C   
ATOM   2041  NH1 ARG   128      22.575  90.752   5.603  1.00 36.42           N   
ATOM   2044  NH2 ARG   128      24.738  90.351   6.227  1.00 32.84           N   
ATOM   2047  C   ARG   128      21.595  93.251  10.309  1.00 27.40           C   
ATOM   2048  O   ARG   128      20.602  92.544  10.524  1.00 28.87           O   
ATOM   2050  N   TRP   129      21.643  94.543  10.627  1.00 27.27           N   
ATOM   2051  CA  TRP   129      20.509  95.218  11.245  1.00 24.31           C   
ATOM   2053  CB  TRP   129      20.327  94.760  12.704  1.00 24.03           C   
ATOM   2056  CG  TRP   129      18.970  95.057  13.283  1.00 25.30           C   
ATOM   2057  CD1 TRP   129      18.675  95.909  14.336  1.00 29.50           C   
ATOM   2059  NE1 TRP   129      17.319  95.946  14.552  1.00 27.54           N   
ATOM   2061  CE2 TRP   129      16.701  95.134  13.632  1.00 27.08           C   
ATOM   2062  CD2 TRP   129      17.716  94.549  12.821  1.00 22.86           C   
ATOM   2063  CE3 TRP   129      17.344  93.698  11.772  1.00 26.20           C   
ATOM   2065  CZ3 TRP   129      16.013  93.422  11.594  1.00 24.66           C   
ATOM   2067  CH2 TRP   129      15.022  93.996  12.436  1.00 25.79           C   
ATOM   2069  CZ2 TRP   129      15.351  94.856  13.449  1.00 29.08           C   
ATOM   2071  C   TRP   129      20.730  96.722  11.153  1.00 25.87           C   
ATOM   2072  O   TRP   129      21.746  97.210  10.635  1.00 25.91           O   
ATOM   2074  N   ASN   130      19.763  97.460  11.664  1.00 28.37           N   
ATOM   2075  CA  ASN   130      19.925  98.877  11.839  1.00 28.49           C   
ATOM   2077  CB  ASN   130      18.610  99.467  12.293  1.00 28.92           C   
ATOM   2080  CG  ASN   130      17.484  99.059  11.407  1.00 26.82           C   
ATOM   2081  OD1 ASN   130      17.420  99.447  10.225  1.00 29.60           O   
ATOM   2082  ND2 ASN   130      16.570  98.271  11.967  1.00 26.93           N   
ATOM   2085  C   ASN   130      21.042  99.182  12.843  1.00 27.95           C   
ATOM   2086  O   ASN   130      21.275  98.409  13.795  1.00 27.08           O   
ATOM   2088  N   PHE   131      21.722 100.295  12.592  1.00 27.12           N   
ATOM   2089  CA  PHE   131      22.659 100.934  13.532  1.00 25.85           C   
ATOM   2091  CB  PHE   131      21.985 101.270  14.877  1.00 26.86           C   
ATOM   2094  CG  PHE   131      20.797 102.206  14.751  1.00 26.61           C   
ATOM   2095  CD1 PHE   131      20.986 103.558  14.500  1.00 28.11           C   
ATOM   2097  CE1 PHE   131      19.920 104.425  14.432  1.00 29.89           C   
ATOM   2099  CZ  PHE   131      18.639 103.946  14.554  1.00 26.41           C   
ATOM   2101  CE2 PHE   131      18.428 102.600  14.792  1.00 28.45           C   
ATOM   2103  CD2 PHE   131      19.504 101.733  14.895  1.00 28.61           C   
ATOM   2105  C   PHE   131      24.001 100.211  13.704  1.00 26.78           C   
ATOM   2106  O   PHE   131      24.613 100.281  14.756  1.00 28.74           O   
ATOM   2108  N   TRP   132      24.483  99.588  12.629  1.00 27.31           N   
ATOM   2109  CA  TRP   132      25.907  99.270  12.519  1.00 27.86           C   
ATOM   2111  CB  TRP   132      26.191  98.306  11.370  1.00 27.46           C   
ATOM   2114  CG  TRP   132      25.852  96.902  11.681  1.00 26.34           C   
ATOM   2115  CD1 TRP   132      24.622  96.398  11.982  1.00 26.53           C   
ATOM   2117  NE1 TRP   132      24.711  95.040  12.217  1.00 29.07           N   
ATOM   2119  CE2 TRP   132      26.011  94.647  12.059  1.00 29.61           C   
ATOM   2120  CD2 TRP   132      26.755  95.789  11.699  1.00 24.42           C   
ATOM   2121  CE3 TRP   132      28.125  95.654  11.488  1.00 31.74           C   
ATOM   2123  CZ3 TRP   132      28.688  94.413  11.589  1.00 27.52           C   
ATOM   2125  CH2 TRP   132      27.929  93.294  11.931  1.00 26.04           C   
ATOM   2127  CZ2 TRP   132      26.592  93.382  12.170  1.00 26.35           C   
ATOM   2129  C   TRP   132      26.651 100.588  12.343  1.00 27.04           C   
ATOM   2130  O   TRP   132      26.080 101.539  11.830  1.00 29.21           O   
ATOM   2132  N   LYS   133      27.901 100.637  12.811  1.00 28.18           N   
ATOM   2133  CA  LYS   133      28.704 101.859  12.889  1.00 27.23           C   
ATOM   2135  CB  LYS   133      28.750 102.348  14.336  1.00 26.89           C   
ATOM   2138  CG  LYS   133      27.351 102.607  14.916  1.00 27.88           C   
ATOM   2141  CD  LYS   133      27.345 103.078  16.321  1.00 28.55           C   
ATOM   2144  CE  LYS   133      25.921 103.223  16.848  1.00 27.52           C   
ATOM   2147  NZ  LYS   133      25.228 101.897  17.053  1.00 27.47           N   
ATOM   2151  C   LYS   133      30.120 101.630  12.346  1.00 28.47           C   
ATOM   2152  O   LYS   133      30.753 100.624  12.634  1.00 27.99           O   
ATOM   2154  N   TYR   134      30.609 102.590  11.566  1.00 26.81           N   
ATOM   2155  CA  TYR   134      31.924 102.512  10.953  1.00 27.35           C   
ATOM   2157  CB  TYR   134      31.794 102.299   9.437  1.00 28.30           C   
ATOM   2160  CG  TYR   134      31.033 101.035   9.063  1.00 26.86           C   
ATOM   2161  CD1 TYR   134      31.710  99.859   8.753  1.00 26.85           C   
ATOM   2163  CE1 TYR   134      31.025  98.686   8.439  1.00 28.03           C   
ATOM   2165  CZ  TYR   134      29.640  98.684   8.439  1.00 28.79           C   
ATOM   2166  OH  TYR   134      28.948  97.547   8.135  1.00 32.33           O   
ATOM   2168  CE2 TYR   134      28.939  99.846   8.748  1.00 34.95           C   
ATOM   2170  CD2 TYR   134      29.635 101.013   9.040  1.00 26.96           C   
ATOM   2172  C   TYR   134      32.688 103.796  11.250  1.00 28.08           C   
ATOM   2173  O   TYR   134      32.169 104.898  11.035  1.00 27.59           O   
ATOM   2175  N   LEU   135      33.907 103.652  11.766  1.00 26.57           N   
ATOM   2176  CA  LEU   135      34.780 104.805  12.021  1.00 27.37           C   
ATOM   2178  CB  LEU   135      35.618 104.600  13.284  1.00 26.27           C   
ATOM   2181  CG  LEU   135      36.380 105.826  13.822  1.00 26.72           C   
ATOM   2183  CD1 LEU   135      35.465 106.928  14.299  1.00 28.38           C   
ATOM   2187  CD2 LEU   135      37.324 105.366  14.955  1.00 28.83           C   
ATOM   2191  C   LEU   135      35.688 105.058  10.820  1.00 25.17           C   
ATOM   2192  O   LEU   135      36.461 104.182  10.392  1.00 25.95           O   
ATOM   2194  N   VAL   136      35.581 106.271  10.292  1.00 25.45           N   
ATOM   2195  CA  VAL   136      36.333 106.718   9.135  1.00 27.28           C   
ATOM   2197  CB  VAL   136      35.386 107.273   8.054  1.00 27.26           C   
ATOM   2199  CG1 VAL   136      36.170 107.792   6.852  1.00 26.86           C   
ATOM   2203  CG2 VAL   136      34.387 106.173   7.603  1.00 25.18           C   
ATOM   2207  C   VAL   136      37.322 107.796   9.591  1.00 27.65           C   
ATOM   2208  O   VAL   136      36.939 108.789  10.217  1.00 29.40           O   
ATOM   2210  N   ASN   137      38.592 107.579   9.275  1.00 27.35           N   
ATOM   2211  CA  ASN   137      39.664 108.473   9.687  1.00 26.62           C   
ATOM   2213  CB  ASN   137      40.986 107.691   9.860  1.00 26.70           C   
ATOM   2216  CG  ASN   137      41.685 107.368   8.550  1.00 29.14           C   
ATOM   2217  OD1 ASN   137      41.305 107.851   7.492  1.00 30.66           O   
ATOM   2218  ND2 ASN   137      42.734 106.554   8.628  1.00 27.49           N   
ATOM   2221  C   ASN   137      39.756 109.702   8.778  1.00 26.63           C   
ATOM   2222  O   ASN   137      39.031 109.802   7.791  1.00 25.55           O   
ATOM   2224  N   PRO   138      40.580 110.698   9.149  1.00 30.62           N   
ATOM   2225  CA  PRO   138      40.653 111.902   8.314  1.00 31.44           C   
ATOM   2227  CB  PRO   138      41.742 112.738   9.007  1.00 33.15           C   
ATOM   2230  CG  PRO   138      41.641 112.313  10.446  1.00 31.78           C   
ATOM   2233  CD  PRO   138      41.413 110.831  10.359  1.00 32.22           C   
ATOM   2236  C   PRO   138      40.996 111.657   6.845  1.00 31.19           C   
ATOM   2237  O   PRO   138      40.636 112.472   5.997  1.00 28.33           O   
ATOM   2238  N   GLU   139      41.669 110.544   6.557  1.00 32.26           N   
ATOM   2239  CA  GLU   139      42.042 110.187   5.187  1.00 33.67           C   
ATOM   2241  CB  GLU   139      43.346 109.381   5.195  1.00 32.99           C   
ATOM   2244  CG  GLU   139      44.603 110.217   5.559  1.00 39.83           C   
ATOM   2247  CD  GLU   139      44.717 110.548   7.045  1.00 50.06           C   
ATOM   2248  OE1 GLU   139      44.274 109.735   7.887  1.00 50.90           O   
ATOM   2249  OE2 GLU   139      45.250 111.633   7.375  1.00 63.60           O   
ATOM   2250  C   GLU   139      40.938 109.425   4.435  1.00 33.03           C   
ATOM   2251  O   GLU   139      41.100 109.084   3.264  1.00 30.42           O   
ATOM   2253  N   GLY   140      39.811 109.170   5.102  1.00 28.99           N   
ATOM   2254  CA  GLY   140      38.701 108.460   4.499  1.00 29.53           C   
ATOM   2257  C   GLY   140      38.787 106.954   4.575  1.00 28.10           C   
ATOM   2258  O   GLY   140      38.027 106.264   3.889  1.00 28.32           O   
ATOM   2260  N   GLN   141      39.709 106.437   5.391  1.00 29.17           N   
ATOM   2261  CA  GLN   141      39.854 104.987   5.580  1.00 31.43           C   
ATOM   2263  CB  GLN   141      41.294 104.610   5.911  1.00 30.21           C   
ATOM   2266  CG  GLN   141      42.329 104.988   4.926  1.00 39.23           C   
ATOM   2269  CD  GLN   141      43.716 104.642   5.442  1.00 37.32           C   
ATOM   2270  OE1 GLN   141      44.289 105.365   6.263  1.00 47.82           O   
ATOM   2271  NE2 GLN   141      44.255 103.534   4.974  1.00 44.91           N   
ATOM   2274  C   GLN   141      39.020 104.493   6.742  1.00 28.31           C   
ATOM   2275  O   GLN   141      39.011 105.110   7.815  1.00 27.69           O   
ATOM   2277  N   VAL   142      38.368 103.348   6.560  1.00 30.15           N   
ATOM   2278  CA  VAL   142      37.649 102.702   7.668  1.00 30.70           C   
ATOM   2280  CB  VAL   142      36.601 101.674   7.164  1.00 29.71           C   
ATOM   2282  CG1 VAL   142      35.801 101.105   8.313  1.00 29.25           C   
ATOM   2286  CG2 VAL   142      35.674 102.289   6.136  1.00 34.97           C   
ATOM   2290  C   VAL   142      38.655 101.992   8.588  1.00 30.90           C   
ATOM   2291  O   VAL   142      39.397 101.126   8.140  1.00 29.58           O   
ATOM   2293  N   VAL   143      38.678 102.363   9.870  1.00 30.10           N   
ATOM   2294  CA  VAL   143      39.659 101.811  10.816  1.00 26.26           C   
ATOM   2296  CB  VAL   143      40.552 102.914  11.428  1.00 26.32           C   
ATOM   2298  CG1 VAL   143      41.406 103.604  10.331  1.00 29.80           C   
ATOM   2302  CG2 VAL   143      39.738 103.967  12.195  1.00 27.02           C   
ATOM   2306  C   VAL   143      39.015 100.930  11.914  1.00 26.18           C   
ATOM   2307  O   VAL   143      39.722 100.200  12.607  1.00 28.90           O   
ATOM   2309  N   LYS   144      37.696 100.988  12.040  1.00 28.96           N   
ATOM   2310  CA  LYS   144      36.967 100.236  13.050  1.00 28.44           C   
ATOM   2312  CB  LYS   144      37.151 100.879  14.446  1.00 29.27           C   
ATOM   2315  CG  LYS   144      36.647 100.000  15.621  1.00 34.32           C   
ATOM   2318  CD  LYS   144      37.606  99.983  16.814  1.00 36.40           C   
ATOM   2321  CE  LYS   144      37.010  99.260  18.033  1.00 42.79           C   
ATOM   2324  NZ  LYS   144      37.799  99.468  19.328  1.00 35.87           N   
ATOM   2328  C   LYS   144      35.485 100.143  12.677  1.00 27.39           C   
ATOM   2329  O   LYS   144      34.955 100.967  11.944  1.00 27.44           O   
ATOM   2331  N   PHE   145      34.827  99.109  13.167  1.00 28.66           N   
ATOM   2332  CA  PHE   145      33.371  99.006  13.066  1.00 28.25           C   
ATOM   2334  CB  PHE   145      32.940  98.016  11.967  1.00 30.67           C   
ATOM   2337  CG  PHE   145      33.106  96.555  12.372  1.00 33.48           C   
ATOM   2338  CD1 PHE   145      32.035  95.841  12.911  1.00 35.15           C   
ATOM   2340  CE1 PHE   145      32.191  94.513  13.328  1.00 32.96           C   
ATOM   2342  CZ  PHE   145      33.432  93.887  13.197  1.00 35.29           C   
ATOM   2344  CE2 PHE   145      34.513  94.600  12.651  1.00 32.59           C   
ATOM   2346  CD2 PHE   145      34.342  95.920  12.252  1.00 35.85           C   
ATOM   2348  C   PHE   145      32.856  98.554  14.417  1.00 27.55           C   
ATOM   2349  O   PHE   145      33.600  97.990  15.202  1.00 28.43           O   
ATOM   2351  N   TRP   146      31.582  98.824  14.679  1.00 27.56           N   
ATOM   2352  CA  TRP   146      30.878  98.317  15.849  1.00 26.84           C   
ATOM   2354  CB  TRP   146      30.604  99.417  16.872  1.00 28.87           C   
ATOM   2357  CG  TRP   146      31.797  99.981  17.509  1.00 29.81           C   
ATOM   2358  CD1 TRP   146      32.400  99.556  18.651  1.00 30.53           C   
ATOM   2360  NE1 TRP   146      33.481 100.351  18.938  1.00 33.41           N   
ATOM   2362  CE2 TRP   146      33.599 101.307  17.965  1.00 31.31           C   
ATOM   2363  CD2 TRP   146      32.559 101.092  17.036  1.00 29.84           C   
ATOM   2364  CE3 TRP   146      32.445 101.943  15.932  1.00 29.98           C   
ATOM   2366  CZ3 TRP   146      33.370 102.955  15.784  1.00 30.58           C   
ATOM   2368  CH2 TRP   146      34.403 103.138  16.719  1.00 30.96           C   
ATOM   2370  CZ2 TRP   146      34.531 102.327  17.816  1.00 29.68           C   
ATOM   2372  C   TRP   146      29.523  97.733  15.421  1.00 27.15           C   
ATOM   2373  O   TRP   146      28.843  98.258  14.537  1.00 28.20           O   
ATOM   2375  N   ARG   147      29.139  96.649  16.068  1.00 27.22           N   
ATOM   2376  CA  ARG   147      27.810  96.101  15.916  1.00 29.97           C   
ATOM   2378  CB  ARG   147      27.783  94.639  16.390  1.00 29.31           C   
ATOM   2381  CG  ARG   147      28.683  93.706  15.583  1.00 29.57           C   
ATOM   2384  CD  ARG   147      28.653  92.245  16.096  1.00 35.28           C   
ATOM   2387  NE  ARG   147      29.135  91.313  15.066  1.00 32.55           N   
ATOM   2389  CZ  ARG   147      30.416  91.126  14.769  1.00 35.21           C   
ATOM   2390  NH1 ARG   147      31.360  91.792  15.415  1.00 41.75           N   
ATOM   2393  NH2 ARG   147      30.750  90.277  13.813  1.00 39.00           N   
ATOM   2396  C   ARG   147      26.847  96.955  16.742  1.00 28.65           C   
ATOM   2397  O   ARG   147      27.282  97.650  17.653  1.00 27.60           O   
ATOM   2399  N   PRO   148      25.534  96.879  16.442  1.00 29.66           N   
ATOM   2400  CA  PRO   148      24.538  97.735  17.118  1.00 30.70           C   
ATOM   2402  CB  PRO   148      23.203  97.325  16.471  1.00 28.44           C   
ATOM   2405  CG  PRO   148      23.595  96.765  15.134  1.00 29.85           C   
ATOM   2408  CD  PRO   148      24.890  96.024  15.428  1.00 28.58           C   
ATOM   2411  C   PRO   148      24.468  97.565  18.621  1.00 33.54           C   
ATOM   2412  O   PRO   148      24.087  98.499  19.324  1.00 36.51           O   
ATOM   2413  N   GLU   149      24.834  96.393  19.117  1.00 31.90           N   
ATOM   2414  CA  GLU   149      24.804  96.136  20.554  1.00 35.00           C   
ATOM   2416  CB  GLU   149      24.792  94.616  20.835  1.00 36.92           C   
ATOM   2419  CG  GLU   149      26.050  93.851  20.400  1.00 44.51           C   
ATOM   2422  CD  GLU   149      25.912  93.075  19.069  1.00 54.00           C   
ATOM   2423  OE1 GLU   149      26.619  92.027  18.969  1.00 40.04           O   
ATOM   2424  OE2 GLU   149      25.126  93.491  18.151  1.00 36.29           O   
ATOM   2425  C   GLU   149      25.933  96.817  21.360  1.00 32.17           C   
ATOM   2426  O   GLU   149      25.918  96.781  22.588  1.00 33.78           O   
ATOM   2428  N   GLU   150      26.905  97.433  20.693  1.00 30.75           N   
ATOM   2429  CA  GLU   150      28.032  98.031  21.423  1.00 31.60           C   
ATOM   2431  CB  GLU   150      29.299  98.041  20.564  1.00 31.44           C   
ATOM   2434  CG  GLU   150      29.611  96.606  20.034  1.00 34.73           C   
ATOM   2437  CD  GLU   150      30.987  96.431  19.395  1.00 39.89           C   
ATOM   2438  OE1 GLU   150      31.997  96.549  20.128  1.00 47.21           O   
ATOM   2439  OE2 GLU   150      31.058  96.110  18.171  1.00 43.63           O   
ATOM   2440  C   GLU   150      27.621  99.407  21.937  1.00 30.60           C   
ATOM   2441  O   GLU   150      27.078 100.201  21.169  1.00 30.67           O   
ATOM   2443  N   PRO   151      27.818  99.667  23.256  1.00 32.73           N   
ATOM   2444  CA  PRO   151      27.387 100.937  23.818  1.00 33.29           C   
ATOM   2446  CB  PRO   151      27.329 100.652  25.333  1.00 31.68           C   
ATOM   2449  CG  PRO   151      28.430  99.693  25.551  1.00 33.58           C   
ATOM   2452  CD  PRO   151      28.435  98.813  24.297  1.00 34.01           C   
ATOM   2455  C   PRO   151      28.371 102.053  23.488  1.00 32.17           C   
ATOM   2456  O   PRO   151      29.516 101.786  23.138  1.00 31.24           O   
ATOM   2457  N   ILE   152      27.903 103.288  23.628  1.00 32.79           N   
ATOM   2458  CA  ILE   152      28.704 104.480  23.367  1.00 35.00           C   
ATOM   2460  CB  ILE   152      27.871 105.783  23.677  1.00 37.94           C   
ATOM   2462  CG1 ILE   152      26.651 105.902  22.743  1.00 41.78           C   
ATOM   2465  CD1 ILE   152      26.979 106.101  21.262  1.00 41.31           C   
ATOM   2469  CG2 ILE   152      28.726 107.041  23.547  1.00 35.86           C   
ATOM   2473  C   ILE   152      30.014 104.482  24.180  1.00 33.34           C   
ATOM   2474  O   ILE   152      31.024 105.003  23.730  1.00 34.84           O   
ATOM   2476  N   GLU   153      29.985 103.899  25.372  1.00 33.37           N   
ATOM   2477  CA  GLU   153      31.163 103.826  26.229  1.00 36.04           C   
ATOM   2479  CB  GLU   153      30.836 103.151  27.570  1.00 38.16           C   
ATOM   2482  CG  GLU   153      30.084 104.037  28.545  1.00 49.93           C   
ATOM   2485  CD  GLU   153      28.571 103.859  28.499  1.00 56.35           C   
ATOM   2486  OE1 GLU   153      28.040 103.360  27.478  1.00 45.92           O   
ATOM   2487  OE2 GLU   153      27.918 104.234  29.501  1.00 59.57           O   
ATOM   2488  C   GLU   153      32.332 103.091  25.573  1.00 32.63           C   
ATOM   2489  O   GLU   153      33.477 103.369  25.908  1.00 31.83           O   
ATOM   2491  N   VAL   154      32.063 102.159  24.656  1.00 31.52           N   
ATOM   2492  CA  VAL   154      33.158 101.504  23.909  1.00 33.23           C   
ATOM   2494  CB  VAL   154      32.967  99.962  23.824  1.00 36.08           C   
ATOM   2496  CG1 VAL   154      32.975  99.362  25.233  1.00 34.30           C   
ATOM   2500  CG2 VAL   154      31.690  99.582  23.060  1.00 35.76           C   
ATOM   2504  C   VAL   154      33.419 102.099  22.519  1.00 31.91           C   
ATOM   2505  O   VAL   154      34.300 101.626  21.803  1.00 36.62           O   
ATOM   2507  N   ILE   155      32.629 103.096  22.119  1.00 30.72           N   
ATOM   2508  CA  ILE   155      32.839 103.802  20.859  1.00 29.37           C   
ATOM   2510  CB  ILE   155      31.484 104.125  20.181  1.00 31.42           C   
ATOM   2512  CG1 ILE   155      30.670 102.840  19.942  1.00 30.95           C   
ATOM   2515  CD1 ILE   155      29.235 103.100  19.435  1.00 32.27           C   
ATOM   2519  CG2 ILE   155      31.712 104.850  18.889  1.00 24.77           C   
ATOM   2523  C   ILE   155      33.623 105.117  21.089  1.00 28.13           C   
ATOM   2524  O   ILE   155      34.537 105.486  20.310  1.00 27.10           O   
ATOM   2526  N   ARG   156      33.255 105.805  22.166  1.00 28.43           N   
ATOM   2527  CA  ARG   156      33.795 107.127  22.476  0.50 29.22           C   
ATOM   2531  CB  ARG   156      33.175 107.640  23.781  0.50 28.86           C   
ATOM   2537  CG  ARG   156      33.368 109.112  24.009  0.50 31.26           C   
ATOM   2543  CD  ARG   156      32.787 109.538  25.348  0.50 32.30           C   
ATOM   2549  NE  ARG   156      33.425 110.742  25.864  0.50 23.14           N   
ATOM   2553  CZ  ARG   156      34.656 110.785  26.386  0.50 39.76           C   
ATOM   2555  NH1 ARG   156      35.417 109.694  26.455  0.50 48.99           N   
ATOM   2561  NH2 ARG   156      35.145 111.936  26.836  0.50 40.34           N   
ATOM   2567  C   ARG   156      35.336 107.169  22.562  1.00 29.57           C   
ATOM   2568  O   ARG   156      35.957 108.091  22.036  1.00 27.46           O   
ATOM   2570  N   PRO   157      35.967 106.163  23.229  1.00 29.78           N   
ATOM   2571  CA  PRO   157      37.440 106.207  23.332  1.00 29.64           C   
ATOM   2573  CB  PRO   157      37.770 104.915  24.081  1.00 28.18           C   
ATOM   2576  CG  PRO   157      36.510 104.601  24.867  1.00 29.98           C   
ATOM   2579  CD  PRO   157      35.420 104.983  23.927  1.00 31.91           C   
ATOM   2582  C   PRO   157      38.198 106.274  21.977  1.00 27.46           C   
ATOM   2583  O   PRO   157      39.179 107.032  21.848  1.00 24.40           O   
ATOM   2584  N   ASP   158      37.768 105.491  20.992  1.00 27.63           N   
ATOM   2585  CA  ASP   158      38.358 105.580  19.624  1.00 29.08           C   
ATOM   2587  CB  ASP   158      37.825 104.475  18.707  1.00 29.61           C   
ATOM   2590  CG  ASP   158      38.526 103.148  18.892  1.00 29.22           C   
ATOM   2591  OD1 ASP   158      39.698 102.993  18.471  1.00 28.68           O   
ATOM   2592  OD2 ASP   158      37.868 102.227  19.426  1.00 27.24           O   
ATOM   2593  C   ASP   158      38.112 106.936  18.956  1.00 29.42           C   
ATOM   2594  O   ASP   158      38.995 107.493  18.300  1.00 29.97           O   
ATOM   2596  N   ILE   159      36.909 107.483  19.104  1.00 30.58           N   
ATOM   2597  CA  ILE   159      36.620 108.813  18.556  1.00 29.07           C   
ATOM   2599  CB  ILE   159      35.128 109.200  18.704  1.00 29.50           C   
ATOM   2601  CG1 ILE   159      34.257 108.269  17.852  1.00 26.80           C   
ATOM   2604  CD1 ILE   159      32.802 108.295  18.201  1.00 26.21           C   
ATOM   2608  CG2 ILE   159      34.918 110.670  18.278  1.00 26.93           C   
ATOM   2612  C   ILE   159      37.518 109.887  19.206  1.00 30.19           C   
ATOM   2613  O   ILE   159      38.185 110.639  18.499  1.00 27.45           O   
ATOM   2615  N   ALA   160      37.546 109.928  20.538  1.00 28.24           N   
ATOM   2616  CA  ALA   160      38.383 110.864  21.282  1.00 26.46           C   
ATOM   2618  CB  ALA   160      38.270 110.606  22.805  1.00 23.77           C   
ATOM   2622  C   ALA   160      39.843 110.789  20.849  1.00 25.09           C   
ATOM   2623  O   ALA   160      40.484 111.827  20.648  1.00 28.57           O   
ATOM   2625  N   ALA   161      40.362 109.567  20.744  1.00 25.59           N   
ATOM   2626  CA  ALA   161      41.766 109.324  20.399  1.00 27.92           C   
ATOM   2628  CB  ALA   161      42.148 107.847  20.578  1.00 24.52           C   
ATOM   2632  C   ALA   161      42.083 109.808  18.988  1.00 28.12           C   
ATOM   2633  O   ALA   161      43.102 110.462  18.784  1.00 31.62           O   
ATOM   2635  N   LEU   162      41.193 109.530  18.036  1.00 28.39           N   
ATOM   2636  CA  LEU   162      41.355 110.011  16.647  1.00 29.59           C   
ATOM   2638  CB  LEU   162      40.447 109.251  15.678  1.00 31.14           C   
ATOM   2641  CG  LEU   162      41.078 108.017  15.009  1.00 36.85           C   
ATOM   2643  CD1 LEU   162      41.261 106.876  15.998  1.00 37.13           C   
ATOM   2647  CD2 LEU   162      40.224 107.574  13.843  1.00 31.22           C   
ATOM   2651  C   LEU   162      41.166 111.517  16.472  1.00 29.44           C   
ATOM   2652  O   LEU   162      41.923 112.161  15.723  1.00 27.23           O   
ATOM   2654  N   VAL   163      40.175 112.085  17.161  1.00 27.95           N   
ATOM   2655  CA  VAL   163      39.946 113.531  17.147  1.00 27.57           C   
ATOM   2657  CB  VAL   163      38.614 113.888  17.859  1.00 30.00           C   
ATOM   2659  CG1 VAL   163      38.508 115.373  18.084  1.00 29.26           C   
ATOM   2663  CG2 VAL   163      37.421 113.358  17.042  1.00 25.65           C   
ATOM   2667  C   VAL   163      41.126 114.299  17.755  1.00 26.21           C   
ATOM   2668  O   VAL   163      41.522 115.360  17.262  1.00 25.48           O   
ATOM   2670  N   ARG   164      41.712 113.754  18.810  1.00 27.46           N   
ATOM   2671  CA  ARG   164      42.900 114.371  19.415  1.00 28.48           C   
ATOM   2673  CB  ARG   164      43.365 113.521  20.598  1.00 28.90           C   
ATOM   2676  CG  ARG   164      44.547 114.111  21.346  1.00 31.57           C   
ATOM   2679  CD  ARG   164      44.951 113.239  22.533  1.00 31.08           C   
ATOM   2682  NE  ARG   164      46.279 113.640  22.974  1.00 32.00           N   
ATOM   2684  CZ  ARG   164      47.411 113.224  22.413  1.00 32.69           C   
ATOM   2685  NH1 ARG   164      47.401 112.372  21.385  1.00 29.06           N   
ATOM   2688  NH2 ARG   164      48.560 113.685  22.877  1.00 28.87           N   
ATOM   2691  C   ARG   164      44.041 114.554  18.391  1.00 28.03           C   
ATOM   2692  O   ARG   164      44.658 115.623  18.301  1.00 24.37           O   
ATOM   2694  N   GLN   165      44.302 113.509  17.614  1.00 27.38           N   
ATOM   2695  CA  GLN   165      45.347 113.547  16.589  1.00 29.96           C   
ATOM   2697  CB  GLN   165      45.510 112.184  15.900  1.00 28.17           C   
ATOM   2700  CG  GLN   165      45.609 110.985  16.804  1.00 42.42           C   
ATOM   2703  CD  GLN   165      47.008 110.695  17.254  1.00 45.28           C   
ATOM   2704  OE1 GLN   165      47.721 111.583  17.706  1.00 54.65           O   
ATOM   2705  NE2 GLN   165      47.407 109.428  17.158  1.00 49.22           N   
ATOM   2708  C   GLN   165      45.064 114.564  15.493  1.00 27.00           C   
ATOM   2709  O   GLN   165      45.985 115.172  14.985  1.00 27.67           O   
ATOM   2711  N   VAL   166      43.797 114.677  15.083  1.00 29.20           N   
ATOM   2712  CA  VAL   166      43.374 115.674  14.087  1.00 27.94           C   
ATOM   2714  CB  VAL   166      41.873 115.541  13.740  1.00 30.80           C   
ATOM   2716  CG1 VAL   166      41.448 116.623  12.759  1.00 35.90           C   
ATOM   2720  CG2 VAL   166      41.592 114.204  13.135  1.00 31.24           C   
ATOM   2724  C   VAL   166      43.622 117.107  14.575  1.00 27.90           C   
ATOM   2725  O   VAL   166      44.078 117.958  13.809  1.00 26.85           O   
ATOM   2727  N   ILE   167      43.286 117.369  15.836  1.00 26.91           N   
ATOM   2728  CA  ILE   167      43.450 118.695  16.413  1.00 29.35           C   
ATOM   2730  CB  ILE   167      42.834 118.794  17.825  1.00 30.69           C   
ATOM   2732  CG1 ILE   167      41.302 118.645  17.730  1.00 29.42           C   
ATOM   2735  CD1 ILE   167      40.601 118.460  19.073  1.00 29.14           C   
ATOM   2739  CG2 ILE   167      43.266 120.121  18.523  1.00 25.81           C   
ATOM   2743  C   ILE   167      44.932 119.059  16.443  1.00 29.18           C   
ATOM   2744  O   ILE   167      45.292 120.157  16.056  1.00 30.62           O   
ATOM   2746  N   ILE   168      45.783 118.118  16.862  1.00 28.37           N   
ATOM   2747  CA  ILE   168      47.234 118.356  16.908  1.00 29.84           C   
ATOM   2749  CB  ILE   168      48.000 117.168  17.575  1.00 32.17           C   
ATOM   2751  CG1 ILE   168      47.587 117.005  19.049  1.00 31.49           C   
ATOM   2754  CD1 ILE   168      47.964 115.656  19.666  1.00 26.38           C   
ATOM   2758  CG2 ILE   168      49.521 117.385  17.470  1.00 30.89           C   
ATOM   2762  C   ILE   168      47.799 118.632  15.505  1.00 28.24           C   
ATOM   2763  O   ILE   168      48.601 119.542  15.320  1.00 28.92           O   
ATOM   2765  N   LYS   169      47.353 117.855  14.522  1.00 28.98           N   
ATOM   2766  CA  LYS   169      47.832 117.970  13.142  1.00 28.62           C   
ATOM   2768  CB  LYS   169      47.323 116.794  12.315  1.00 30.36           C   
ATOM   2771  CG  LYS   169      47.987 116.658  10.978  1.00 34.25           C   
ATOM   2774  CD  LYS   169      47.434 115.486  10.168  1.00 35.54           C   
ATOM   2777  CE  LYS   169      46.187 115.857   9.350  1.00 46.84           C   
ATOM   2780  NZ  LYS   169      44.903 115.407   9.986  1.00 55.08           N   
ATOM   2784  C   LYS   169      47.411 119.281  12.480  1.00 29.13           C   
ATOM   2785  O   LYS   169      48.191 119.884  11.730  1.00 26.59           O   
ATOM   2787  N   LYS   170      46.176 119.702  12.730  1.00 29.22           N   
ATOM   2788  CA  LYS   170      45.683 120.969  12.193  1.00 32.91           C   
ATOM   2790  CB  LYS   170      44.186 121.155  12.486  1.00 32.98           C   
ATOM   2793  CG  LYS   170      43.315 120.437  11.473  1.00 36.73           C   
ATOM   2796  CD  LYS   170      41.870 120.306  11.906  1.00 35.82           C   
ATOM   2799  CE  LYS   170      41.061 119.523  10.861  1.00 39.39           C   
ATOM   2802  NZ  LYS   170      39.606 119.460  11.169  1.00 41.48           N   
ATOM   2806  C   LYS   170      46.505 122.125  12.748  1.00 32.44           C   
ATOM   2807  O   LYS   170      46.825 123.066  12.013  1.00 28.91           O   
ATOM   2809  N   LYS   171      46.873 122.033  14.028  1.00 33.87           N   
ATOM   2810  CA  LYS   171      47.703 123.066  14.675  1.00 36.26           C   
ATOM   2812  CB  LYS   171      47.734 122.870  16.205  1.00 35.27           C   
ATOM   2815  CG  LYS   171      46.593 123.560  16.931  1.00 42.48           C   
ATOM   2818  CD  LYS   171      46.396 123.062  18.369  1.00 44.83           C   
ATOM   2821  CE  LYS   171      45.059 123.582  18.964  1.00 48.28           C   
ATOM   2824  NZ  LYS   171      44.696 122.959  20.279  1.00 37.96           N   
ATOM   2828  C   LYS   171      49.137 123.103  14.153  1.00 33.31           C   
ATOM   2829  O   LYS   171      49.679 124.176  13.845  1.00 34.25           O   
ATOM   2831  N   GLU   172      49.750 121.925  14.072  1.00 32.73           N   
ATOM   2832  CA  GLU   172      51.194 121.803  13.829  1.00 32.51           C   
ATOM   2834  CB  GLU   172      51.728 120.512  14.456  1.00 28.01           C   
ATOM   2837  CG  GLU   172      51.911 120.638  15.964  1.00 33.00           C   
ATOM   2840  CD  GLU   172      52.179 119.313  16.655  1.00 32.80           C   
ATOM   2841  OE1 GLU   172      52.222 118.268  15.968  1.00 29.96           O   
ATOM   2842  OE2 GLU   172      52.335 119.322  17.901  1.00 33.01           O   
ATOM   2843  C   GLU   172      51.618 121.876  12.365  1.00 32.48           C   
ATOM   2844  O   GLU   172      52.714 122.366  12.061  1.00 31.53           O   
ATOM   2846  N   ASP   173      50.768 121.368  11.476  1.00 35.42           N   
ATOM   2847  CA  ASP   173      51.075 121.318  10.051  1.00 36.94           C   
ATOM   2849  CB  ASP   173      50.592 119.992   9.444  1.00 37.17           C   
ATOM   2852  CG  ASP   173      51.314 118.775  10.019  1.00 44.38           C   
ATOM   2853  OD1 ASP   173      52.256 118.945  10.821  1.00 52.71           O   
ATOM   2854  OD2 ASP   173      50.940 117.639   9.656  1.00 48.80           O   
ATOM   2855  C   ASP   173      50.435 122.505   9.327  1.00 37.00           C   
ATOM   2856  O   ASP   173      49.325 122.931   9.668  1.00 35.18           O   
ATOM   2858  N   LEU   174      51.144 123.044   8.339  1.00 39.66           N   
ATOM   2859  CA  LEU   174      50.617 124.151   7.543  1.00 43.90           C   
ATOM   2861  CB  LEU   174      51.713 124.809   6.701  1.00 43.02           C   
ATOM   2864  CG  LEU   174      52.869 125.517   7.408  1.00 42.88           C   
ATOM   2866  CD1 LEU   174      53.796 126.090   6.357  1.00 33.93           C   
ATOM   2870  CD2 LEU   174      52.402 126.621   8.356  1.00 46.74           C   
ATOM   2874  C   LEU   174      49.502 123.637   6.631  1.00 47.18           C   
ATOM   2875  O   LEU   174      49.508 122.476   6.215  1.00 49.53           O   
ATOM   2877  OXT LEU   174      48.565 124.366   6.294  1.00 49.75           O   
END
